/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/LifeCycleConsumer.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerDBus.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerJson.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifeCycleConsumer {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/LifeCycleConsumer", LifeCycleConsumerProxy);

class LifeCycleConsumerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    LifeCycleConsumerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< LifeCycleConsumerProxy >& proxyShared = ::boost::static_pointer_cast< LifeCycleConsumerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_LifecycleRequest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestError> payload = ::boost::static_pointer_cast<LifecycleRequestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCallbackIF*) _callback)->onLifecycleRequestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestResponse> payload = ::boost::static_pointer_cast<LifecycleRequestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCallbackIF*) _callback)->onLifecycleRequestResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_LifecycleRequest: {
                ::boost::shared_ptr< LifecycleRequestError > payload = ::boost::shared_ptr< LifecycleRequestError >
                (new LifecycleRequestError(DBUS_ERROR_NO_SERVER, "The DBus service LifeCycleConsumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LifecycleRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LifeCycleConsumerProxy> proxyShared = ::boost::static_pointer_cast<LifeCycleConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LifecycleRequestCallbackIF*) _callback)->onLifecycleRequestError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& LifeCycleConsumerProxyCallback::_logger (LifeCycleConsumerProxy::_logger);

LifeCycleConsumerProxy::LifeCycleConsumerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.genivi.NodeStateManager.LifeCycleConsumer", serviceAvailable, _logger) {
}

LifeCycleConsumerProxy::~LifeCycleConsumerProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< LifeCycleConsumerProxy > LifeCycleConsumerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<LifeCycleConsumerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< LifeCycleConsumerProxy > proxyNew(new LifeCycleConsumerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t LifeCycleConsumerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    LifeCycleConsumerProxyCallback* callback = new LifeCycleConsumerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t LifeCycleConsumerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    LifeCycleConsumerProxyCallback* callback = new LifeCycleConsumerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t LifeCycleConsumerProxy::sendLifecycleRequestRequest(LifecycleRequestCallbackIF& cb, uint32 request, uint32 requestId) const {
    LifecycleRequestRequest* payload = new LifecycleRequestRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequest(request);
    payload->setRequestId(requestId);
    DBUS_MESSAGE_CALL(dbusMessage, "LifecycleRequest", LifecycleRequestRequest, payload, true)
    act_t act = addMethodCallback(ID_LifecycleRequest, dbusMessage.getUniqueSerial(), "LifecycleRequest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LifecycleRequest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace LifeCycleConsumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
