#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMER_H
#define ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <cstring>

/**
 * org.genivi.NodeStateManager.LifeCycleConsumer :
 *
 *                     short_description: Interface of a life cycle client.
 *                     This interface contains functions, which need to be implemented by life cycle clients, to be able to receive life cycle requests.
 */

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace LifeCycleConsumer {

// method IDs
static const uint16 ID_LifecycleRequest = 0;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class LifecycleRequestRequest;

class LifecycleRequestResponse;

// type definitions
/**
 * If the meaning of "LifecycleRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LifecycleRequestError;


/**
 * LifecycleRequest:
 *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
 *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
 *     	             when the client has processed the "LifecycleRequest".
 *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
 *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
 *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
 *
 *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
 *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
 */
class LifecycleRequestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestRequest ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestRequest (const LifecycleRequestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestRequest (uint32 Request_, uint32 RequestId_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestRequest();

    /**
     * Assignment operator
     */
    inline LifecycleRequestRequest& operator = (const LifecycleRequestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Request"

    static const int kRequest = 0;

    /**
     * Clears the field "Request".
     *
     * The field will be set to its default value. The hasRequest()
     * method will return false.
     */
    inline void clearRequest();

    /**
     * Checks whether the field "Request" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequest()). Otherwise it will return false.
     */
    inline bool hasRequest () const;

    /**
     * Returns the value of the member "Request".
     *
     * If the meaning of "Request" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Request"
     */
    inline uint32 getRequest () const;

    /**
     * Sets the value of the member "Request".
     *
     * If the meaning of "Request" isn't clear, then there should be a description here.
     *
     * @param Request The value which will be set
     */
    inline void setRequest (uint32 Request_);

    // API of field "RequestId"

    static const int kRequestId = 1;

    /**
     * Clears the field "RequestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "RequestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "RequestId".
     *
     * If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RequestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "RequestId".
     *
     * If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @param RequestId The value which will be set
     */
    inline void setRequestId (uint32 RequestId_);

    static const LifecycleRequestRequest &getDefaultInstance();

private:

    inline void set_has_Request ();

    inline void clear_has_Request ();

    inline void set_has_RequestId ();

    inline void clear_has_RequestId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _Request;

    uint32 _RequestId;

};

/**
 * LifecycleRequest:
 *     	Request:     The type of the life cycle request. Can be NSM_SHUTDOWNTYPE_RUNUP, NSM_SHUTDOWNTYPE_NORMAL or NSM_SHUTDOWNTYPE_FAST.
 *     	RequestId:   The Id of the client (current request). This Id needs to be passed to the NSM again via the interface "LifecycleRequestComplete",
 *     	             when the client has processed the "LifecycleRequest".
 *     	ErrorCode:   Client's return value, passed to the NodeStateManager. Based upon NsmErrorStatus_e. NsmErrorStatus_Ok:
 *     	             Request was successfully processed. NsmErrorStatus_ResponsePending: Processing of request started.
 *     	             LifecycleRequestComplete will be called to pass the status after completion. NsmErrorStatus_Error: An error occured, the request could not be processed.
 *
 *     	             The method has to be implemented by every life cycle client and is called by the NodeStateManager,
 *     	             when the node is shutting down (fast or normal) or an ongoing shutdown is cancelled (run up)
 */
class LifecycleRequestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifecycleRequestResponse ();

    /**
     * Copy constructor
     */
    inline  LifecycleRequestResponse (const LifecycleRequestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  LifecycleRequestResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    /**
     * Destructor
     */
    inline virtual  ~LifecycleRequestResponse();

    /**
     * Assignment operator
     */
    inline LifecycleRequestResponse& operator = (const LifecycleRequestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifecycleRequestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifecycleRequestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifecycleRequestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifecycleRequestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ErrorCode"
     */
    inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * If the meaning of "ErrorCode" isn't clear, then there should be a description here.
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_);

    static const LifecycleRequestResponse &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e _ErrorCode;

};

inline  LifecycleRequestRequest::LifecycleRequestRequest ()  :
    _Request (0u),
    _RequestId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestRequest::LifecycleRequestRequest (const LifecycleRequestRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Request (0u),
    _RequestId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestRequest::LifecycleRequestRequest (uint32 Request_, uint32 RequestId_)  :
    _Request (Request_),
    _RequestId (RequestId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestRequest::~LifecycleRequestRequest() {
}

inline LifecycleRequestRequest& LifecycleRequestRequest::operator = (const LifecycleRequestRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRequest()) {
            setRequest(rhs.getRequest());
        } else {
            clearRequest();
        }
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
    }
    return *this;
}

inline bool LifecycleRequestRequest::operator == (const LifecycleRequestRequest& rhs) const {
    return (((!hasRequest() && !rhs.hasRequest()) || getRequest() == rhs.getRequest()) &&
        ((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()));
}

inline bool LifecycleRequestRequest::operator != (const LifecycleRequestRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestRequest::operator < (const LifecycleRequestRequest& rhs) const {
    if (hasRequest() || rhs.hasRequest()) {
        if (getRequest() < rhs.getRequest()) return true;
        if (getRequest() > rhs.getRequest()) return false;
    }
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestRequest::clone() {
    return new LifecycleRequestRequest(*this);
}

inline bool LifecycleRequestRequest::operator > (const LifecycleRequestRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestRequest::clear() {
    clearRequest();
    clearRequestId();
}

inline void LifecycleRequestRequest::clearRequest() {
    if (hasRequest()) {
         clear_has_Request();
        _Request = 0u;
     }
}

inline bool LifecycleRequestRequest::hasRequest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 LifecycleRequestRequest::getRequest () const {
    return _Request;
}

inline void LifecycleRequestRequest::setRequest (uint32 Request_) {
    set_has_Request();
    this->_Request = Request_;
}

inline void LifecycleRequestRequest::clearRequestId() {
    if (hasRequestId()) {
         clear_has_RequestId();
        _RequestId = 0u;
     }
}

inline bool LifecycleRequestRequest::hasRequestId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 LifecycleRequestRequest::getRequestId () const {
    return _RequestId;
}

inline void LifecycleRequestRequest::setRequestId (uint32 RequestId_) {
    set_has_RequestId();
    this->_RequestId = RequestId_;
}

inline void LifecycleRequestRequest::set_has_Request () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestRequest::clear_has_Request () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void LifecycleRequestRequest::set_has_RequestId () {
    _has_bits_[0] |= 1u << 1;
}

inline void LifecycleRequestRequest::clear_has_RequestId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  LifecycleRequestResponse::LifecycleRequestResponse ()  :
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  LifecycleRequestResponse::LifecycleRequestResponse (const LifecycleRequestResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _ErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  LifecycleRequestResponse::LifecycleRequestResponse (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "LifecycleRequestResponse");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  LifecycleRequestResponse::~LifecycleRequestResponse() {
}

inline LifecycleRequestResponse& LifecycleRequestResponse::operator = (const LifecycleRequestResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool LifecycleRequestResponse::operator == (const LifecycleRequestResponse& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool LifecycleRequestResponse::operator != (const LifecycleRequestResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool LifecycleRequestResponse::operator < (const LifecycleRequestResponse& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if ((uint32)getErrorCode() < (uint32)rhs.getErrorCode()) return true;
        if ((uint32)getErrorCode() > (uint32)rhs.getErrorCode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* LifecycleRequestResponse::clone() {
    return new LifecycleRequestResponse(*this);
}

inline bool LifecycleRequestResponse::operator > (const LifecycleRequestResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void LifecycleRequestResponse::clear() {
    clearErrorCode();
}

inline void LifecycleRequestResponse::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e__NsmErrorStatus_NotSet;
     }
}

inline bool LifecycleRequestResponse::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e LifecycleRequestResponse::getErrorCode () const {
    return _ErrorCode;
}

inline void LifecycleRequestResponse::setErrorCode (::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e ErrorCode_) {
    #ifndef NDEBUG
    if (!(::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e_IsValid(ErrorCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ErrorCode_, "_NsmErrorStatus_e", "ErrorCode", "LifecycleRequestResponse");
    }
    #endif
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void LifecycleRequestResponse::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void LifecycleRequestResponse::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace LifeCycleConsumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_LIFECYCLECONSUMER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
