/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_GENIVI_NODESTATEMANAGER_CONSUMERPROXY_H
#define ORG_GENIVI_NODESTATEMANAGER_CONSUMERPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/genivi/NodeStateManager/Consumer.h"
#include "org/genivi/NodeStateManager/ConsumerConst.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

class ConsumerProxy;

class BootModeCallbackIF {
public:
    virtual ~BootModeCallbackIF() {}

    virtual void onBootModeError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< BootModeError >& error) = 0;

    virtual void onBootModeUpdate(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< BootModeUpdate >& update) = 0;
};

class GetAppHealthCountCallbackIF {
public:
    virtual ~GetAppHealthCountCallbackIF() {}

    virtual void onGetAppHealthCountError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetAppHealthCountError >& error) = 0;

    virtual void onGetAppHealthCountResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetAppHealthCountResponse >& response) = 0;
};

class GetApplicationModeCallbackIF {
public:
    virtual ~GetApplicationModeCallbackIF() {}

    virtual void onGetApplicationModeError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetApplicationModeError >& error) = 0;

    virtual void onGetApplicationModeResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetApplicationModeResponse >& response) = 0;
};

class GetInterfaceVersionCallbackIF {
public:
    virtual ~GetInterfaceVersionCallbackIF() {}

    virtual void onGetInterfaceVersionError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetInterfaceVersionError >& error) = 0;

    virtual void onGetInterfaceVersionResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetInterfaceVersionResponse >& response) = 0;
};

class GetNodeStateCallbackIF {
public:
    virtual ~GetNodeStateCallbackIF() {}

    virtual void onGetNodeStateError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetNodeStateError >& error) = 0;

    virtual void onGetNodeStateResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetNodeStateResponse >& response) = 0;
};

class GetSessionStateCallbackIF {
public:
    virtual ~GetSessionStateCallbackIF() {}

    virtual void onGetSessionStateError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetSessionStateError >& error) = 0;

    virtual void onGetSessionStateResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< GetSessionStateResponse >& response) = 0;
};

class LifecycleRequestCompleteCallbackIF {
public:
    virtual ~LifecycleRequestCompleteCallbackIF() {}

    virtual void onLifecycleRequestCompleteError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteError >& error) = 0;

    virtual void onLifecycleRequestCompleteResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< LifecycleRequestCompleteResponse >& response) = 0;
};

class NodeApplicationModeCallbackIF {
public:
    virtual ~NodeApplicationModeCallbackIF() {}

    virtual void onNodeApplicationModeError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< NodeApplicationModeError >& error) = 0;

    virtual void onNodeApplicationModeSignal(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< NodeApplicationModeSignal >& signal) = 0;
};

class NodeStateCallbackIF {
public:
    virtual ~NodeStateCallbackIF() {}

    virtual void onNodeStateError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< NodeStateError >& error) = 0;

    virtual void onNodeStateSignal(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< NodeStateSignal >& signal) = 0;
};

class RegisterSessionCallbackIF {
public:
    virtual ~RegisterSessionCallbackIF() {}

    virtual void onRegisterSessionError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RegisterSessionError >& error) = 0;

    virtual void onRegisterSessionResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RegisterSessionResponse >& response) = 0;
};

class RegisterShutdownClientCallbackIF {
public:
    virtual ~RegisterShutdownClientCallbackIF() {}

    virtual void onRegisterShutdownClientError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RegisterShutdownClientError >& error) = 0;

    virtual void onRegisterShutdownClientResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RegisterShutdownClientResponse >& response) = 0;
};

class RestartReasonCallbackIF {
public:
    virtual ~RestartReasonCallbackIF() {}

    virtual void onRestartReasonError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RestartReasonError >& error) = 0;

    virtual void onRestartReasonUpdate(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< RestartReasonUpdate >& update) = 0;
};

class SessionStateChangedCallbackIF {
public:
    virtual ~SessionStateChangedCallbackIF() {}

    virtual void onSessionStateChangedError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< SessionStateChangedError >& error) = 0;

    virtual void onSessionStateChangedSignal(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< SessionStateChangedSignal >& signal) = 0;
};

class SetSessionStateCallbackIF {
public:
    virtual ~SetSessionStateCallbackIF() {}

    virtual void onSetSessionStateError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< SetSessionStateError >& error) = 0;

    virtual void onSetSessionStateResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< SetSessionStateResponse >& response) = 0;
};

class ShutdownReasonCallbackIF {
public:
    virtual ~ShutdownReasonCallbackIF() {}

    virtual void onShutdownReasonError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< ShutdownReasonError >& error) = 0;

    virtual void onShutdownReasonUpdate(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< ShutdownReasonUpdate >& update) = 0;
};

class UnRegisterSessionCallbackIF {
public:
    virtual ~UnRegisterSessionCallbackIF() {}

    virtual void onUnRegisterSessionError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< UnRegisterSessionError >& error) = 0;

    virtual void onUnRegisterSessionResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< UnRegisterSessionResponse >& response) = 0;
};

class UnRegisterShutdownClientCallbackIF {
public:
    virtual ~UnRegisterShutdownClientCallbackIF() {}

    virtual void onUnRegisterShutdownClientError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< UnRegisterShutdownClientError >& error) = 0;

    virtual void onUnRegisterShutdownClientResponse(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< UnRegisterShutdownClientResponse >& response) = 0;
};

class WakeUpReasonCallbackIF {
public:
    virtual ~WakeUpReasonCallbackIF() {}

    virtual void onWakeUpReasonError(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< WakeUpReasonError >& error) = 0;

    virtual void onWakeUpReasonUpdate(const ::boost::shared_ptr< ConsumerProxy >& proxy, const ::boost::shared_ptr< WakeUpReasonUpdate >& update) = 0;
};


/**
 * ConsumerProxy is the client side representation of the D-Bus service
 * interface 'org.genivi.NodeStateManager.Consumer' (specified in file
 * org.genivi.NodeStateManager.Consumer_.xml).
 *
 * org.genivi.NodeStateManager.Consumer:
 *
 *                     short_description: "Consumer" interface of the NodeStateManager.
 *
 * 	                This interface contains functions which are not safety critical and can be accessed by "every" client without further restrictions.
 */
class ConsumerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ConsumerProxy.
     */
    static ::boost::shared_ptr< ConsumerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ConsumerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ConsumerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ConsumerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ConsumerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ConsumerProxy > proxyNew(new ConsumerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ConsumerProxy ();


    // Signal 'NodeState'

    /**
     * Notify on the signal 'NodeState'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'NodeState'</b>:
     *
     * NodeState:
     * 	   NodeState: Numeric value for the current NodeState defined in NsmNodeState_e.
     *
     * 	   Clients can register for notifications when the NodeState is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeState as a parameter.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNodeStateRegister(NodeStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NodeState'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NodeState'</b>:
     *
     * NodeState:
     * 	   NodeState: Numeric value for the current NodeState defined in NsmNodeState_e.
     *
     * 	   Clients can register for notifications when the NodeState is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeState as a parameter.
     *
     * @param act The act which was previously returned by the
     * sendNodeStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNodeStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NodeState'.
     */
    void sendNodeStateDeregisterAll () const;

    // Signal 'NodeApplicationMode'

    /**
     * Notify on the signal 'NodeApplicationMode'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'NodeApplicationMode'</b>:
     *
     * NodeApplicationMode:
     * 	   ApplicationModeId: Numeric value for the current ApplicationMode defined in NsmAplicationMode_e.
     *
     * 	   Clients can register for notifications when the NodeApplicationMode is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeApplicationMode as a parameter.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNodeApplicationModeRegister(NodeApplicationModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NodeApplicationMode'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NodeApplicationMode'</b>:
     *
     * NodeApplicationMode:
     * 	   ApplicationModeId: Numeric value for the current ApplicationMode defined in NsmAplicationMode_e.
     *
     * 	   Clients can register for notifications when the NodeApplicationMode is updated inside the NodeStateManager.
     * 	   This signal is sent to registered clients and will include the current NodeApplicationMode as a parameter.
     *
     * @param act The act which was previously returned by the
     * sendNodeApplicationModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNodeApplicationModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NodeApplicationMode'.
     */
    void sendNodeApplicationModeDeregisterAll () const;

    // Signal 'SessionStateChanged'

    /**
     * Notify on the signal 'SessionStateChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SessionStateChanged'</b>:
     *
     * SessionStateChanged:
     *     	SessionStateName: The SessionName will be based upon either the pre-defined platform SessionNames or using a newly added product defined session name.
     *     	SeatID:           This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState:     This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	                  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *
     *     	This signal is sent to registered clients when a particular session is state is changed.
     *     	The client can register for notification about a specific session through the use of the SessionName as a "match rule".
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionStateChangedRegister(SessionStateChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SessionStateChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SessionStateChanged'</b>:
     *
     * SessionStateChanged:
     *     	SessionStateName: The SessionName will be based upon either the pre-defined platform SessionNames or using a newly added product defined session name.
     *     	SeatID:           This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState:     This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	                  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *
     *     	This signal is sent to registered clients when a particular session is state is changed.
     *     	The client can register for notification about a specific session through the use of the SessionName as a "match rule".
     *
     * @param act The act which was previously returned by the
     * sendSessionStateChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSessionStateChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SessionStateChanged'.
     */
    void sendSessionStateChangedDeregisterAll () const;


    // Property 'RestartReason'

    /**
     * Notify on the property 'RestartReason'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestartReasonRegister(RestartReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RestartReason'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @param act The act which was previously returned by the
     * sendRestartReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRestartReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RestartReason'.
     */
    void sendRestartReasonDeregisterAll() const;

    /**
     * Request the value of the property 'RestartReason' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RestartReason'</b>:
     *
     * RestartReason: This property informs clients about the reason for the last restart.
     *                       The values are based upon the enummeration NsmRestartReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestartReasonGet(RestartReasonCallbackIF& cb);


    /**
     * Returns the current value of the property 'RestartReason' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasRestartReason() returns true.
     *
     * @return the previously received value of the property 'RestartReason'.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e getRestartReason() const;

    /**
     * Determines whether a status message for the property 'RestartReason'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRestartReason() const;

    // Property 'ShutdownReason'

    /**
     * Notify on the property 'ShutdownReason'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShutdownReasonRegister(ShutdownReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ShutdownReason'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @param act The act which was previously returned by the
     * sendShutdownReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendShutdownReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ShutdownReason'.
     */
    void sendShutdownReasonDeregisterAll() const;

    /**
     * Request the value of the property 'ShutdownReason' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ShutdownReason'</b>:
     *
     * ShutdownReason: This property informs clients about the reason for the last shutdown.
     *                       The values are based upon the enummeration NsmShutdownReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShutdownReasonGet(ShutdownReasonCallbackIF& cb);


    /**
     * Returns the current value of the property 'ShutdownReason' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasShutdownReason() returns true.
     *
     * @return the previously received value of the property 'ShutdownReason'.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e getShutdownReason() const;

    /**
     * Determines whether a status message for the property 'ShutdownReason'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasShutdownReason() const;

    // Property 'WakeUpReason'

    /**
     * Notify on the property 'WakeUpReason'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWakeUpReasonRegister(WakeUpReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'WakeUpReason'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @param act The act which was previously returned by the
     * sendWakeUpReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWakeUpReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'WakeUpReason'.
     */
    void sendWakeUpReasonDeregisterAll() const;

    /**
     * Request the value of the property 'WakeUpReason' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'WakeUpReason'</b>:
     *
     * WakeUpReason: This property informs clients about the recent reason for waking up the target.
     *                       The values are based upon the enummeration NsmWakeUpReason_e. Note: The value is only set once at start-up.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWakeUpReasonGet(WakeUpReasonCallbackIF& cb);


    /**
     * Returns the current value of the property 'WakeUpReason' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWakeUpReason() returns true.
     *
     * @return the previously received value of the property 'WakeUpReason'.
     */
    ::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e getWakeUpReason() const;

    /**
     * Determines whether a status message for the property 'WakeUpReason' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWakeUpReason() const;

    // Property 'BootMode'

    /**
     * Notify on the property 'BootMode'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBootModeRegister(BootModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'BootMode'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @param act The act which was previously returned by the
     * sendBootModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBootModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'BootMode'.
     */
    void sendBootModeDeregisterAll() const;

    /**
     * Request the value of the property 'BootMode' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'BootMode'</b>:
     *
     * BootMode: This property informs clients about the recent BootMode of the target.
     *                       The values will be defined by a third party header which has not been delivered yet.
     *                       The description needs to be updated as soon as the header is available.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBootModeGet(BootModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'BootMode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasBootMode()
     * returns true.
     *
     * @return the previously received value of the property 'BootMode'.
     */
    int32 getBootMode() const;

    /**
     * Determines whether a status message for the property 'BootMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBootMode() const;


    // Method 'GetNodeState'

    /**
     * Call the method 'GetNodeState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetNodeState'</b>:
     *
     * GetNodeState:
     *     	NodeStateId: Will be based on the NsmNodeState_e.
     *     	ErrorCode:   Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to get the NodeState without the need of registration to the signal.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetNodeStateRequest(GetNodeStateCallbackIF& cb) const;

    // Method 'SetSessionState'

    /**
     * Call the method 'SetSessionState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetSessionState'</b>:
     *
     * SetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform SessionNames (see NSM content page) or using a newly added product defined session name.
     *     	SessionOwner: This parameter defines the name of the application that is setting the state of the session. This must be the applications systemd unit filename.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to set the state of a session.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SessionName If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionOwner If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SeatID If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SessionState If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetSessionStateRequest(SetSessionStateCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID, _NsmSessionState_e sessionState) const;

    // Method 'GetSessionState'

    /**
     * Call the method 'GetSessionState'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetSessionState'</b>:
     *
     * GetSessionState:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     				  The listed values are the default values that are mandatory for platform sessions but product sessions may have additional SessionStates.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by applications to get the state of a session.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SessionName If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SeatID If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSessionStateRequest(GetSessionStateCallbackIF& cb, const ::std::string& sessionName, _NsmSeat_e seatID) const;

    // Method 'GetApplicationMode'

    /**
     * Call the method 'GetApplicationMode'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetApplicationMode'</b>:
     *
     * GetApplicationMode:
     * 	    ApplicationModeId:This parameter will be based upon the NsmNodeApplicationMode_e.
     * 	    ErrorCode:        Return value passed to the caller based upon NsmErrorStatus_e.
     *
     * 	The method is used by other applications to get the application mode.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetApplicationModeRequest(GetApplicationModeCallbackIF& cb) const;

    // Method 'RegisterShutdownClient'

    /**
     * Call the method 'RegisterShutdownClient'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'RegisterShutdownClient'</b>:
     *
     * RegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to be informed (i.e normal fast etc).
     *     	TimeoutMs:    Max. Timeout to wait for response from shutdown client in ms.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register themselves as shutdown client.
     *     	Any client that registers must provide a method in their D-Bus object called "LifecycleRequest".
     *     	This method will take one parameter which is the RequestType (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	For an example of the required client interface please see the BootManager component who will be a client of the NSM.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param BusName If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param ObjName If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ShutdownMode If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @param TimeoutMs If the meaning of "TimeoutMs" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterShutdownClientRequest(RegisterShutdownClientCallbackIF& cb, const ::std::string& busName, const ::std::string& objName, uint32 shutdownMode, uint32 timeoutMs) const;

    // Method 'UnRegisterShutdownClient'

    /**
     * Call the method 'UnRegisterShutdownClient'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'UnRegisterShutdownClient'</b>:
     *
     * UnRegisterShutdownClient:
     *     	BusName:      Bus name of remote application.
     *     	ObjName:      Object name of remote object that provides the shutdown interface.
     *     	ShutdownMode: Shutdown mode for which client wants to unregister (NSM_SHUTDOWNTYPE_NORMAL NSM_SHUTDOWNTYPE_FAST).
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to unregister themselves as shutdown client.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param BusName If the meaning of "BusName" isn't clear, then there should be a description here.
     *
     * @param ObjName If the meaning of "ObjName" isn't clear, then there should be a description here.
     *
     * @param ShutdownMode If the meaning of "ShutdownMode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnRegisterShutdownClientRequest(UnRegisterShutdownClientCallbackIF& cb, const ::std::string& busName, const ::std::string& objName, uint32 shutdownMode) const;

    // Method 'RegisterSession'

    /**
     * Call the method 'RegisterSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RegisterSession'</b>:
     *
     * RegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that is registering the new session (this must be the applications systemd unit filename).
     *     	SeatID:       This parameter will be based upon the enum NsmSeatId_e
     *     	SessionState: This parameter will be based upon the NsmSessionState_e but it will not be bounded by the values in that enumeration.
     *     	              The listed values are the default values that are mandatory for platform sessions but product sessions may have additional session states.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to register a new session whose state should be observed and distributed by the NSM..
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SessionName If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionOwner If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SeatID If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @param SessionState If the meaning of "SessionState" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterSessionRequest(RegisterSessionCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID, _NsmSessionState_e sessionState) const;

    // Method 'UnRegisterSession'

    /**
     * Call the method 'UnRegisterSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnRegisterSession'</b>:
     *
     * UnRegisterSession:
     *     	SessionName:  The SessionName will be based upon either the pre-defined platform session names (see NSM content page) or using a newly
     *     				  added product defined SessionName.
     *     	SessionOwner: This is the name of the application that originally registered the session.
     *     	              It will be validated that this value matches the stored value from the registration.
     *     	SeatID:       This parameter will be based upon the enum NsmSeat_e.
     *     	ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *     	The method is used by other applications to remove a new session from the session list hosted by NSM.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param SessionName If the meaning of "SessionName" isn't clear, then there should be a description here.
     *
     * @param SessionOwner If the meaning of "SessionOwner" isn't clear, then there should be a description here.
     *
     * @param SeatID If the meaning of "SeatID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnRegisterSessionRequest(UnRegisterSessionCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID) const;

    // Method 'GetAppHealthCount'

    /**
     * Call the method 'GetAppHealthCount'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetAppHealthCount'</b>:
     *
     * GetAppHealthCount:
     *     	Count:        Return value passed to the caller. Number of applications that crashed or terminated accidentally.
     *
     *     	The method returns the number of applications that crashed or terminated accidentally within the current life cycle. It can be used to observe the system state.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAppHealthCountRequest(GetAppHealthCountCallbackIF& cb) const;

    // Method 'GetInterfaceVersion'

    /**
     * Call the method 'GetInterfaceVersion'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'GetInterfaceVersion'</b>:
     *
     * GetInterfaceVersion:
     *     	Version:      Unsigned integer that represents the version number of the Node State Manager.
     *
     *     	The method returns the version number of the Node State Manager. The number is organized in four bytes:
     *
     *     	Version: VVV.RRR.PPP.BBB
     *
     *     	<literallayout>
     *     		VVV => Version  [1..255]
     *     		RRR => Release  [0..255]
     *     		PPP => Patch    [0..255]
     *     		BBB => Build    [0..255]
     *     	</literallayout>
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetInterfaceVersionRequest(GetInterfaceVersionCallbackIF& cb) const;

    // Method 'LifecycleRequestComplete'

    /**
     * Call the method 'LifecycleRequestComplete'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'LifecycleRequestComplete'</b>:
     *
     * LifecycleRequestComplete:
     *         RequestId:    The request Id of the called life cycle client. The value has been passed when "LifecycleRequest" was called.
     *         Status:       The result of the call to "LifecycleRequest". NsmErrorStatus_Ok: Request successfully processed. NsmErrorStatus_Error:
     *                       An error occured while processing the "LifecycleRequest".
     *         ErrorCode:    Return value passed to the caller based upon NsmErrorStatus_e.
     *
     *         The function has to be called by a "asynchrounous" lifecycle client when he processed the "LifecycleRequest".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param RequestId If the meaning of "RequestId" isn't clear, then there should be a description here.
     *
     * @param Status If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLifecycleRequestCompleteRequest(LifecycleRequestCompleteCallbackIF& cb, uint32 requestId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e status) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ConsumerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'RestartReason'

    ::asf::core::nullable< RestartReasonUpdate > _restartReason;

    // Property 'ShutdownReason'

    ::asf::core::nullable< ShutdownReasonUpdate > _shutdownReason;

    // Property 'WakeUpReason'

    ::asf::core::nullable< WakeUpReasonUpdate > _wakeUpReason;

    // Property 'BootMode'

    ::asf::core::nullable< BootModeUpdate > _bootMode;

    DECLARE_CLASS_LOGGER();

    friend class ConsumerProxyCallback;
};

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org

#endif // ORG_GENIVI_NODESTATEMANAGER_CONSUMERPROXY_H
