/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/genivi/NodeStateManager/Consumer.h"
#include "org/genivi/NodeStateManager/ConsumerConst.h"
#include "org/genivi/NodeStateManager/ConsumerDBus.h"
#include "org/genivi/NodeStateManager/ConsumerJson.h"
#include "org/genivi/NodeStateManager/ConsumerProxy.h"
#include "org/genivi/NodeStateManager/LcmBasicTypesConst.h"
#include "org/genivi/NodeStateManager/LcmErrorTypesConst.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace genivi {
namespace NodeStateManager {
namespace Consumer {

DEFINE_CLASS_LOGGER("/org/genivi/NodeStateManager/org/genivi/NodeStateManager/Consumer", ConsumerProxy);

class ConsumerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ConsumerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ConsumerProxy >& proxyShared = ::boost::static_pointer_cast< ConsumerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NodeState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NodeStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NodeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NodeStateSignal> payload = ::boost::static_pointer_cast<NodeStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NodeStateCallbackIF*) _callback)->onNodeStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_NodeApplicationMode:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NodeApplicationModeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NodeApplicationMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NodeApplicationModeSignal> payload = ::boost::static_pointer_cast<NodeApplicationModeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NodeApplicationModeCallbackIF*) _callback)->onNodeApplicationModeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SessionStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SessionStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SessionStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SessionStateChangedSignal> payload = ::boost::static_pointer_cast<SessionStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SessionStateChangedCallbackIF*) _callback)->onSessionStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RestartReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestartReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartReasonError> payload = ::boost::static_pointer_cast<RestartReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RestartReasonCallbackIF*) _callback)->onRestartReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RestartReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestartReasonUpdate> payload = ::boost::static_pointer_cast<RestartReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RestartReasonCallbackIF*) _callback)->onRestartReasonUpdate(proxyShared, payload);
                        proxyShared->_restartReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ShutdownReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShutdownReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShutdownReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShutdownReasonError> payload = ::boost::static_pointer_cast<ShutdownReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ShutdownReasonCallbackIF*) _callback)->onShutdownReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShutdownReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ShutdownReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ShutdownReasonUpdate> payload = ::boost::static_pointer_cast<ShutdownReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ShutdownReasonCallbackIF*) _callback)->onShutdownReasonUpdate(proxyShared, payload);
                        proxyShared->_shutdownReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WakeUpReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WakeUpReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WakeUpReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WakeUpReasonError> payload = ::boost::static_pointer_cast<WakeUpReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WakeUpReasonCallbackIF*) _callback)->onWakeUpReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WakeUpReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WakeUpReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WakeUpReasonUpdate> payload = ::boost::static_pointer_cast<WakeUpReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WakeUpReasonCallbackIF*) _callback)->onWakeUpReasonUpdate(proxyShared, payload);
                        proxyShared->_wakeUpReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BootMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BootModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BootMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BootModeError> payload = ::boost::static_pointer_cast<BootModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BootModeCallbackIF*) _callback)->onBootModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BootModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BootMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BootModeUpdate> payload = ::boost::static_pointer_cast<BootModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BootModeCallbackIF*) _callback)->onBootModeUpdate(proxyShared, payload);
                        proxyShared->_bootMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetNodeState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetNodeStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNodeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNodeStateError> payload = ::boost::static_pointer_cast<GetNodeStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNodeStateCallbackIF*) _callback)->onGetNodeStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNodeStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetNodeState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetNodeStateResponse> payload = ::boost::static_pointer_cast<GetNodeStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetNodeStateCallbackIF*) _callback)->onGetNodeStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetSessionState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetSessionStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSessionState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSessionStateError> payload = ::boost::static_pointer_cast<SetSessionStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSessionStateCallbackIF*) _callback)->onSetSessionStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetSessionStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSessionState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetSessionStateResponse> payload = ::boost::static_pointer_cast<SetSessionStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetSessionStateCallbackIF*) _callback)->onSetSessionStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetSessionState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetSessionStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSessionState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSessionStateError> payload = ::boost::static_pointer_cast<GetSessionStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSessionStateCallbackIF*) _callback)->onGetSessionStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSessionStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetSessionState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetSessionStateResponse> payload = ::boost::static_pointer_cast<GetSessionStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetSessionStateCallbackIF*) _callback)->onGetSessionStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetApplicationMode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetApplicationModeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetApplicationMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetApplicationModeError> payload = ::boost::static_pointer_cast<GetApplicationModeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetApplicationModeCallbackIF*) _callback)->onGetApplicationModeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetApplicationModeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetApplicationMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetApplicationModeResponse> payload = ::boost::static_pointer_cast<GetApplicationModeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetApplicationModeCallbackIF*) _callback)->onGetApplicationModeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterShutdownClient:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterShutdownClientError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterShutdownClientError> payload = ::boost::static_pointer_cast<RegisterShutdownClientError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterShutdownClientCallbackIF*) _callback)->onRegisterShutdownClientError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterShutdownClientResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterShutdownClientResponse> payload = ::boost::static_pointer_cast<RegisterShutdownClientResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterShutdownClientCallbackIF*) _callback)->onRegisterShutdownClientResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnRegisterShutdownClient:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterShutdownClientError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnRegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnRegisterShutdownClientError> payload = ::boost::static_pointer_cast<UnRegisterShutdownClientError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnRegisterShutdownClientCallbackIF*) _callback)->onUnRegisterShutdownClientError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterShutdownClientResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnRegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnRegisterShutdownClientResponse> payload = ::boost::static_pointer_cast<UnRegisterShutdownClientResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnRegisterShutdownClientCallbackIF*) _callback)->onUnRegisterShutdownClientResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterSessionError> payload = ::boost::static_pointer_cast<RegisterSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterSessionCallbackIF*) _callback)->onRegisterSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterSessionResponse> payload = ::boost::static_pointer_cast<RegisterSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterSessionCallbackIF*) _callback)->onRegisterSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnRegisterSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnRegisterSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnRegisterSessionError> payload = ::boost::static_pointer_cast<UnRegisterSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnRegisterSessionCallbackIF*) _callback)->onUnRegisterSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnRegisterSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnRegisterSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnRegisterSessionResponse> payload = ::boost::static_pointer_cast<UnRegisterSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnRegisterSessionCallbackIF*) _callback)->onUnRegisterSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetAppHealthCount:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetAppHealthCountError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAppHealthCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAppHealthCountError> payload = ::boost::static_pointer_cast<GetAppHealthCountError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAppHealthCountCallbackIF*) _callback)->onGetAppHealthCountError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetAppHealthCountResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAppHealthCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetAppHealthCountResponse> payload = ::boost::static_pointer_cast<GetAppHealthCountResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetAppHealthCountCallbackIF*) _callback)->onGetAppHealthCountResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetInterfaceVersion:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceVersionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetInterfaceVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetInterfaceVersionError> payload = ::boost::static_pointer_cast<GetInterfaceVersionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetInterfaceVersionCallbackIF*) _callback)->onGetInterfaceVersionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceVersionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetInterfaceVersion", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetInterfaceVersionResponse> payload = ::boost::static_pointer_cast<GetInterfaceVersionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetInterfaceVersionCallbackIF*) _callback)->onGetInterfaceVersionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_LifecycleRequestComplete:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestCompleteError> payload = ::boost::static_pointer_cast<LifecycleRequestCompleteError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LifecycleRequestCompleteResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LifecycleRequestCompleteResponse> payload = ::boost::static_pointer_cast<LifecycleRequestCompleteResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NodeState: {
                ::boost::shared_ptr< NodeStateError > payload = ::boost::shared_ptr< NodeStateError >
                (new NodeStateError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NodeState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NodeStateCallbackIF*) _callback)->onNodeStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NodeApplicationMode: {
                ::boost::shared_ptr< NodeApplicationModeError > payload = ::boost::shared_ptr< NodeApplicationModeError >
                (new NodeApplicationModeError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NodeApplicationMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NodeApplicationModeCallbackIF*) _callback)->onNodeApplicationModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SessionStateChanged: {
                ::boost::shared_ptr< SessionStateChangedError > payload = ::boost::shared_ptr< SessionStateChangedError >
                (new SessionStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SessionStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SessionStateChangedCallbackIF*) _callback)->onSessionStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestartReason: {
                ::boost::shared_ptr< RestartReasonError > payload = ::boost::shared_ptr< RestartReasonError >
                (new RestartReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestartReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestartReasonCallbackIF*) _callback)->onRestartReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ShutdownReason: {
                ::boost::shared_ptr< ShutdownReasonError > payload = ::boost::shared_ptr< ShutdownReasonError >
                (new ShutdownReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ShutdownReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ShutdownReasonCallbackIF*) _callback)->onShutdownReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WakeUpReason: {
                ::boost::shared_ptr< WakeUpReasonError > payload = ::boost::shared_ptr< WakeUpReasonError >
                (new WakeUpReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WakeUpReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WakeUpReasonCallbackIF*) _callback)->onWakeUpReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BootMode: {
                ::boost::shared_ptr< BootModeError > payload = ::boost::shared_ptr< BootModeError >
                (new BootModeError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BootMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BootModeCallbackIF*) _callback)->onBootModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetNodeState: {
                ::boost::shared_ptr< GetNodeStateError > payload = ::boost::shared_ptr< GetNodeStateError >
                (new GetNodeStateError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetNodeState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetNodeStateCallbackIF*) _callback)->onGetNodeStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetSessionState: {
                ::boost::shared_ptr< SetSessionStateError > payload = ::boost::shared_ptr< SetSessionStateError >
                (new SetSessionStateError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetSessionState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetSessionStateCallbackIF*) _callback)->onSetSessionStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetSessionState: {
                ::boost::shared_ptr< GetSessionStateError > payload = ::boost::shared_ptr< GetSessionStateError >
                (new GetSessionStateError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetSessionState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetSessionStateCallbackIF*) _callback)->onGetSessionStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetApplicationMode: {
                ::boost::shared_ptr< GetApplicationModeError > payload = ::boost::shared_ptr< GetApplicationModeError >
                (new GetApplicationModeError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetApplicationMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetApplicationModeCallbackIF*) _callback)->onGetApplicationModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterShutdownClient: {
                ::boost::shared_ptr< RegisterShutdownClientError > payload = ::boost::shared_ptr< RegisterShutdownClientError >
                (new RegisterShutdownClientError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterShutdownClientCallbackIF*) _callback)->onRegisterShutdownClientError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnRegisterShutdownClient: {
                ::boost::shared_ptr< UnRegisterShutdownClientError > payload = ::boost::shared_ptr< UnRegisterShutdownClientError >
                (new UnRegisterShutdownClientError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnRegisterShutdownClient", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnRegisterShutdownClientCallbackIF*) _callback)->onUnRegisterShutdownClientError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterSession: {
                ::boost::shared_ptr< RegisterSessionError > payload = ::boost::shared_ptr< RegisterSessionError >
                (new RegisterSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterSessionCallbackIF*) _callback)->onRegisterSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnRegisterSession: {
                ::boost::shared_ptr< UnRegisterSessionError > payload = ::boost::shared_ptr< UnRegisterSessionError >
                (new UnRegisterSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnRegisterSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnRegisterSessionCallbackIF*) _callback)->onUnRegisterSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetAppHealthCount: {
                ::boost::shared_ptr< GetAppHealthCountError > payload = ::boost::shared_ptr< GetAppHealthCountError >
                (new GetAppHealthCountError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetAppHealthCount", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetAppHealthCountCallbackIF*) _callback)->onGetAppHealthCountError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetInterfaceVersion: {
                ::boost::shared_ptr< GetInterfaceVersionError > payload = ::boost::shared_ptr< GetInterfaceVersionError >
                (new GetInterfaceVersionError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetInterfaceVersion", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetInterfaceVersionCallbackIF*) _callback)->onGetInterfaceVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LifecycleRequestComplete: {
                ::boost::shared_ptr< LifecycleRequestCompleteError > payload = ::boost::shared_ptr< LifecycleRequestCompleteError >
                (new LifecycleRequestCompleteError(DBUS_ERROR_NO_SERVER, "The DBus service Consumer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LifecycleRequestComplete", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConsumerProxy> proxyShared = ::boost::static_pointer_cast<ConsumerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LifecycleRequestCompleteCallbackIF*) _callback)->onLifecycleRequestCompleteError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ConsumerProxyCallback::_logger (ConsumerProxy::_logger);

ConsumerProxy::ConsumerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.genivi.NodeStateManager.Consumer", serviceAvailable, _logger) {
}

ConsumerProxy::~ConsumerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ConsumerProxy > ConsumerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ConsumerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ConsumerProxy > proxyNew(new ConsumerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ConsumerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ConsumerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ConsumerProxy::clearAllProperties ()
{
    _restartReason = ::asf::core::nullable< RestartReasonUpdate >();
    _shutdownReason = ::asf::core::nullable< ShutdownReasonUpdate >();
    _wakeUpReason = ::asf::core::nullable< WakeUpReasonUpdate >();
    _bootMode = ::asf::core::nullable< BootModeUpdate >();
}

void ConsumerProxy::sendDeregisterAll () const
{
    sendRestartReasonDeregisterAll();
    sendShutdownReasonDeregisterAll();
    sendWakeUpReasonDeregisterAll();
    sendBootModeDeregisterAll();
    sendNodeStateDeregisterAll();
    sendNodeApplicationModeDeregisterAll();
    sendSessionStateChangedDeregisterAll();
}

act_t ConsumerProxy::sendNodeStateRegister(NodeStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NodeState");
    act_t act = addSignalCallback(ID_NodeState, "NodeState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NodeState", &cb, act);
    return act;
}

bool ConsumerProxy::sendNodeStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NodeState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NodeState", act, static_cast<int>(rv));
    return rv;
}

void ConsumerProxy::sendNodeStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NodeState");
    _dbusProxyDelegate->deregisterSignalCallback("NodeState", 0, _dbusDaemonProxy.get(), false);
}

act_t ConsumerProxy::sendNodeApplicationModeRegister(NodeApplicationModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NodeApplicationMode");
    act_t act = addSignalCallback(ID_NodeApplicationMode, "NodeApplicationMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NodeApplicationMode", &cb, act);
    return act;
}

bool ConsumerProxy::sendNodeApplicationModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NodeApplicationMode", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NodeApplicationMode", act, static_cast<int>(rv));
    return rv;
}

void ConsumerProxy::sendNodeApplicationModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NodeApplicationMode");
    _dbusProxyDelegate->deregisterSignalCallback("NodeApplicationMode", 0, _dbusDaemonProxy.get(), false);
}

act_t ConsumerProxy::sendSessionStateChangedRegister(SessionStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SessionStateChanged");
    act_t act = addSignalCallback(ID_SessionStateChanged, "SessionStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SessionStateChanged", &cb, act);
    return act;
}

bool ConsumerProxy::sendSessionStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SessionStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SessionStateChanged", act, static_cast<int>(rv));
    return rv;
}

void ConsumerProxy::sendSessionStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SessionStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("SessionStateChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t ConsumerProxy::sendRestartReasonRegister(RestartReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RestartReason, "RestartReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RestartReason", &cb, act);
    return act;
}

bool ConsumerProxy::sendRestartReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RestartReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RestartReason", act, static_cast<int>(rv));
    return rv;
}

act_t ConsumerProxy::sendRestartReasonGet(RestartReasonCallbackIF& cb) {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(ID_RestartReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RestartReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RestartReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRestartReason_e ConsumerProxy::getRestartReason() const {
    return _restartReason.get().getRestartReason();
}

bool ConsumerProxy::hasRestartReason() const {
    return _restartReason.hasValue();
}

void ConsumerProxy::sendRestartReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RestartReason");
    _dbusProxyDelegate->deregisterSignalCallback("RestartReason", 0, _dbusDaemonProxy.get(), true);
}

act_t ConsumerProxy::sendShutdownReasonRegister(ShutdownReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ShutdownReason, "ShutdownReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ShutdownReason", &cb, act);
    return act;
}

bool ConsumerProxy::sendShutdownReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ShutdownReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ShutdownReason", act, static_cast<int>(rv));
    return rv;
}

act_t ConsumerProxy::sendShutdownReasonGet(ShutdownReasonCallbackIF& cb) {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(ID_ShutdownReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ShutdownReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ShutdownReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


::org::genivi::NodeStateManager::LcmBasicTypes::_NsmShutdownReason_e ConsumerProxy::getShutdownReason() const {
    return _shutdownReason.get().getShutdownReason();
}

bool ConsumerProxy::hasShutdownReason() const {
    return _shutdownReason.hasValue();
}

void ConsumerProxy::sendShutdownReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ShutdownReason");
    _dbusProxyDelegate->deregisterSignalCallback("ShutdownReason", 0, _dbusDaemonProxy.get(), true);
}

act_t ConsumerProxy::sendWakeUpReasonRegister(WakeUpReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WakeUpReason, "WakeUpReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WakeUpReason", &cb, act);
    return act;
}

bool ConsumerProxy::sendWakeUpReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WakeUpReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WakeUpReason", act, static_cast<int>(rv));
    return rv;
}

act_t ConsumerProxy::sendWakeUpReasonGet(WakeUpReasonCallbackIF& cb) {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(ID_WakeUpReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WakeUpReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WakeUpReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


::org::genivi::NodeStateManager::LcmBasicTypes::_NsmRunningReason_e ConsumerProxy::getWakeUpReason() const {
    return _wakeUpReason.get().getWakeUpReason();
}

bool ConsumerProxy::hasWakeUpReason() const {
    return _wakeUpReason.hasValue();
}

void ConsumerProxy::sendWakeUpReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WakeUpReason");
    _dbusProxyDelegate->deregisterSignalCallback("WakeUpReason", 0, _dbusDaemonProxy.get(), true);
}

act_t ConsumerProxy::sendBootModeRegister(BootModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_BootMode, "BootMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BootMode", &cb, act);
    return act;
}

bool ConsumerProxy::sendBootModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BootMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BootMode", act, static_cast<int>(rv));
    return rv;
}

act_t ConsumerProxy::sendBootModeGet(BootModeCallbackIF& cb) {
    ConsumerProxyCallback* callback = new ConsumerProxyCallback(ID_BootMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BootMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BootMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 ConsumerProxy::getBootMode() const {
    return _bootMode.get().getBootMode();
}

bool ConsumerProxy::hasBootMode() const {
    return _bootMode.hasValue();
}

void ConsumerProxy::sendBootModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BootMode");
    _dbusProxyDelegate->deregisterSignalCallback("BootMode", 0, _dbusDaemonProxy.get(), true);
}

act_t ConsumerProxy::sendGetNodeStateRequest(GetNodeStateCallbackIF& cb) const {
    GetNodeStateRequest* payload = new GetNodeStateRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetNodeState", GetNodeStateRequest, payload, true)
    act_t act = addMethodCallback(ID_GetNodeState, dbusMessage.getUniqueSerial(), "GetNodeState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetNodeState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendSetSessionStateRequest(SetSessionStateCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID, _NsmSessionState_e sessionState) const {
    SetSessionStateRequest* payload = new SetSessionStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSessionName(sessionName);
    payload->setSessionOwner(sessionOwner);
    payload->setSeatID(seatID);
    payload->setSessionState(sessionState);
    DBUS_MESSAGE_CALL(dbusMessage, "SetSessionState", SetSessionStateRequest, payload, true)
    act_t act = addMethodCallback(ID_SetSessionState, dbusMessage.getUniqueSerial(), "SetSessionState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetSessionState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendGetSessionStateRequest(GetSessionStateCallbackIF& cb, const ::std::string& sessionName, _NsmSeat_e seatID) const {
    GetSessionStateRequest* payload = new GetSessionStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSessionName(sessionName);
    payload->setSeatID(seatID);
    DBUS_MESSAGE_CALL(dbusMessage, "GetSessionState", GetSessionStateRequest, payload, true)
    act_t act = addMethodCallback(ID_GetSessionState, dbusMessage.getUniqueSerial(), "GetSessionState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetSessionState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendGetApplicationModeRequest(GetApplicationModeCallbackIF& cb) const {
    GetApplicationModeRequest* payload = new GetApplicationModeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetApplicationMode", GetApplicationModeRequest, payload, true)
    act_t act = addMethodCallback(ID_GetApplicationMode, dbusMessage.getUniqueSerial(), "GetApplicationMode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetApplicationMode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendRegisterShutdownClientRequest(RegisterShutdownClientCallbackIF& cb, const ::std::string& busName, const ::std::string& objName, uint32 shutdownMode, uint32 timeoutMs) const {
    RegisterShutdownClientRequest* payload = new RegisterShutdownClientRequest();
    CHECK_ALLOCATION(payload);
    payload->setBusName(busName);
    payload->setObjName(objName);
    payload->setShutdownMode(shutdownMode);
    payload->setTimeoutMs(timeoutMs);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterShutdownClient", RegisterShutdownClientRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterShutdownClient, dbusMessage.getUniqueSerial(), "RegisterShutdownClient", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterShutdownClient", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendUnRegisterShutdownClientRequest(UnRegisterShutdownClientCallbackIF& cb, const ::std::string& busName, const ::std::string& objName, uint32 shutdownMode) const {
    UnRegisterShutdownClientRequest* payload = new UnRegisterShutdownClientRequest();
    CHECK_ALLOCATION(payload);
    payload->setBusName(busName);
    payload->setObjName(objName);
    payload->setShutdownMode(shutdownMode);
    DBUS_MESSAGE_CALL(dbusMessage, "UnRegisterShutdownClient", UnRegisterShutdownClientRequest, payload, true)
    act_t act = addMethodCallback(ID_UnRegisterShutdownClient, dbusMessage.getUniqueSerial(), "UnRegisterShutdownClient", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnRegisterShutdownClient", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendRegisterSessionRequest(RegisterSessionCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID, _NsmSessionState_e sessionState) const {
    RegisterSessionRequest* payload = new RegisterSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSessionName(sessionName);
    payload->setSessionOwner(sessionOwner);
    payload->setSeatID(seatID);
    payload->setSessionState(sessionState);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterSession", RegisterSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterSession, dbusMessage.getUniqueSerial(), "RegisterSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendUnRegisterSessionRequest(UnRegisterSessionCallbackIF& cb, const ::std::string& sessionName, const ::std::string& sessionOwner, _NsmSeat_e seatID) const {
    UnRegisterSessionRequest* payload = new UnRegisterSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSessionName(sessionName);
    payload->setSessionOwner(sessionOwner);
    payload->setSeatID(seatID);
    DBUS_MESSAGE_CALL(dbusMessage, "UnRegisterSession", UnRegisterSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_UnRegisterSession, dbusMessage.getUniqueSerial(), "UnRegisterSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnRegisterSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendGetAppHealthCountRequest(GetAppHealthCountCallbackIF& cb) const {
    GetAppHealthCountRequest* payload = new GetAppHealthCountRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetAppHealthCount", GetAppHealthCountRequest, payload, true)
    act_t act = addMethodCallback(ID_GetAppHealthCount, dbusMessage.getUniqueSerial(), "GetAppHealthCount", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetAppHealthCount", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendGetInterfaceVersionRequest(GetInterfaceVersionCallbackIF& cb) const {
    GetInterfaceVersionRequest* payload = new GetInterfaceVersionRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetInterfaceVersion", GetInterfaceVersionRequest, payload, true)
    act_t act = addMethodCallback(ID_GetInterfaceVersion, dbusMessage.getUniqueSerial(), "GetInterfaceVersion", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetInterfaceVersion", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConsumerProxy::sendLifecycleRequestCompleteRequest(LifecycleRequestCompleteCallbackIF& cb, uint32 requestId, ::org::genivi::NodeStateManager::LcmErrorTypes::_NsmErrorStatus_e status) const {
    LifecycleRequestCompleteRequest* payload = new LifecycleRequestCompleteRequest();
    CHECK_ALLOCATION(payload);
    payload->setRequestId(requestId);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "LifecycleRequestComplete", LifecycleRequestCompleteRequest, payload, true)
    act_t act = addMethodCallback(ID_LifecycleRequestComplete, dbusMessage.getUniqueSerial(), "LifecycleRequestComplete", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "LifecycleRequestComplete", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Consumer
} // namespace NodeStateManager
} // namespace genivi
} // namespace org
