/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTSTUB_H
#define ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm/Generic_RecoveryClient.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include <string>

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

class Generic_RecoveryClientStubDelegate;

class Generic_RecoveryClientStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the Generic_RecoveryClientStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    Generic_RecoveryClientStub (const std::string& portName);

    /**
     * Create an instance of the Generic_RecoveryClientStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    Generic_RecoveryClientStub (const std::string& portName, const std::string& objectPath);

    virtual ~Generic_RecoveryClientStub();

    // property 'FI_Version'

    /**
     * The method onFI_VersionGet() is called by ASF when a client invokes the
     * read method for the property 'FI_Version'. The onFI_VersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    virtual void onFI_VersionGet(const ::boost::shared_ptr< FI_VersionGet >& payload);

    /**
     * Sends back the update to a previous onFI_VersionGet().
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param act Identifies a previous invocation of onFI_VersionGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFI_VersionGetUpdate(const ::std::string& fI_Version, act_t act = 0);

    /**
     * The method onFI_VersionSet() is called by ASF when a client invokes the
     * write method for the property 'FI_Version'. The onFI_VersionSet()
     * method set property value to the given parameter FI_Version by default.
     * If this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    virtual void onFI_VersionSet(const ::boost::shared_ptr< FI_VersionSet >& payload);

    /**
     * Sends back the update to a previous onFI_VersionSet().
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param act Identifies a previous invocation of onFI_VersionSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendFI_VersionSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'FI_Version' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    void setFI_Version(const ::std::string& fI_Version);

    /**
     * Returns the current value of the property 'FI_Version'.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    const ::std::string& getFI_Version() const;

    /**
     * Returns the current value of the property 'FI_Version' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFI_VersionUpdate() method.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    ::std::string& getFI_VersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFI_VersionUpdate().
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    void sendFI_VersionUpdate();

    // property 'FailedServiceName'

    /**
     * The method onFailedServiceNameGet() is called by ASF when a client
     * invokes the read method for the property 'FailedServiceName'. The
     * onFailedServiceNameGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    virtual void onFailedServiceNameGet(const ::boost::shared_ptr< FailedServiceNameGet >& payload);

    /**
     * Sends back the update to a previous onFailedServiceNameGet().
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param act Identifies a previous invocation of
     * onFailedServiceNameGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFailedServiceNameGetUpdate(const ::std::string& failedServiceName, act_t act = 0);

    /**
     * The method onFailedServiceNameSet() is called by ASF when a client
     * invokes the write method for the property 'FailedServiceName'. The
     * onFailedServiceNameSet() method set property value to the given
     * parameter FailedServiceName by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    virtual void onFailedServiceNameSet(const ::boost::shared_ptr< FailedServiceNameSet >& payload);

    /**
     * Sends back the update to a previous onFailedServiceNameSet().
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param act Identifies a previous invocation of
     * onFailedServiceNameSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFailedServiceNameSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'FailedServiceName' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    void setFailedServiceName(const ::std::string& failedServiceName);

    /**
     * Returns the current value of the property 'FailedServiceName'.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    const ::std::string& getFailedServiceName() const;

    /**
     * Returns the current value of the property 'FailedServiceName' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendFailedServiceNameUpdate() method.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    ::std::string& getFailedServiceNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFailedServiceNameUpdate().
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    void sendFailedServiceNameUpdate();

    // property 'FailedServiceStatus'

    /**
     * The method onFailedServiceStatusGet() is called by ASF when a client
     * invokes the read method for the property 'FailedServiceStatus'. The
     * onFailedServiceStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    virtual void onFailedServiceStatusGet(const ::boost::shared_ptr< FailedServiceStatusGet >& payload);

    /**
     * Sends back the update to a previous onFailedServiceStatusGet().
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param act Identifies a previous invocation of
     * onFailedServiceStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFailedServiceStatusGetUpdate(UnitStates failedServiceStatus, act_t act = 0);

    /**
     * The method onFailedServiceStatusSet() is called by ASF when a client
     * invokes the write method for the property 'FailedServiceStatus'. The
     * onFailedServiceStatusSet() method set property value to the given
     * parameter FailedServiceStatus by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    virtual void onFailedServiceStatusSet(const ::boost::shared_ptr< FailedServiceStatusSet >& payload);

    /**
     * Sends back the update to a previous onFailedServiceStatusSet().
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param act Identifies a previous invocation of
     * onFailedServiceStatusSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendFailedServiceStatusSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'FailedServiceStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    void setFailedServiceStatus(UnitStates failedServiceStatus);

    /**
     * Returns the current value of the property 'FailedServiceStatus'.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    UnitStates getFailedServiceStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFailedServiceStatusUpdate().
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    void sendFailedServiceStatusUpdate();

    // property 'CallStackRequestCounter'

    /**
     * The method onCallStackRequestCounterGet() is called by ASF when a
     * client invokes the read method for the property
     * 'CallStackRequestCounter'. The onCallStackRequestCounterGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    virtual void onCallStackRequestCounterGet(const ::boost::shared_ptr< CallStackRequestCounterGet >& payload);

    /**
     * Sends back the update to a previous onCallStackRequestCounterGet().
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param act Identifies a previous invocation of
     * onCallStackRequestCounterGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCallStackRequestCounterGetUpdate(uint8 callStackRequestCounter, act_t act = 0);

    /**
     * The method onCallStackRequestCounterSet() is called by ASF when a
     * client invokes the write method for the property
     * 'CallStackRequestCounter'. The onCallStackRequestCounterSet() method
     * set property value to the given parameter CallStackRequestCounter by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    virtual void onCallStackRequestCounterSet(const ::boost::shared_ptr< CallStackRequestCounterSet >& payload);

    /**
     * Sends back the update to a previous onCallStackRequestCounterSet().
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param act Identifies a previous invocation of
     * onCallStackRequestCounterSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCallStackRequestCounterSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'CallStackRequestCounter' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    void setCallStackRequestCounter(uint8 callStackRequestCounter);

    /**
     * Returns the current value of the property 'CallStackRequestCounter'.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    uint8 getCallStackRequestCounter() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCallStackRequestCounterUpdate().
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    void sendCallStackRequestCounterUpdate();

    // property 'ActionRequest'

    /**
     * The method onActionRequestGet() is called by ASF when a client invokes
     * the read method for the property 'ActionRequest'. The
     * onActionRequestGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    virtual void onActionRequestGet(const ::boost::shared_ptr< ActionRequestGet >& payload);

    /**
     * Sends back the update to a previous onActionRequestGet().
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param act Identifies a previous invocation of onActionRequestGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActionRequestGetUpdate(UnitActions actionRequest, act_t act = 0);

    /**
     * The method onActionRequestSet() is called by ASF when a client invokes
     * the write method for the property 'ActionRequest'. The
     * onActionRequestSet() method set property value to the given parameter
     * ActionRequest by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    virtual void onActionRequestSet(const ::boost::shared_ptr< ActionRequestSet >& payload);

    /**
     * Sends back the update to a previous onActionRequestSet().
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param act Identifies a previous invocation of onActionRequestSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActionRequestSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'ActionRequest' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    void setActionRequest(UnitActions actionRequest);

    /**
     * Returns the current value of the property 'ActionRequest'.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    UnitActions getActionRequest() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActionRequestUpdate().
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    void sendActionRequestUpdate();

    // property 'RequestPermissionRequest'

    /**
     * The method onRequestPermissionRequestGet() is called by ASF when a
     * client invokes the read method for the property
     * 'RequestPermissionRequest'. The onRequestPermissionRequestGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    virtual void onRequestPermissionRequestGet(const ::boost::shared_ptr< RequestPermissionRequestGet >& payload);

    /**
     * Sends back the update to a previous onRequestPermissionRequestGet().
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param act Identifies a previous invocation of
     * onRequestPermissionRequestGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestPermissionRequestGetUpdate(LcmResetAllowed requestPermissionRequest, act_t act = 0);

    /**
     * The method onRequestPermissionRequestSet() is called by ASF when a
     * client invokes the write method for the property
     * 'RequestPermissionRequest'. The onRequestPermissionRequestSet() method
     * set property value to the given parameter RequestPermissionRequest by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    virtual void onRequestPermissionRequestSet(const ::boost::shared_ptr< RequestPermissionRequestSet >& payload);

    /**
     * Sends back the update to a previous onRequestPermissionRequestSet().
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param act Identifies a previous invocation of
     * onRequestPermissionRequestSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestPermissionRequestSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'RequestPermissionRequest' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    void setRequestPermissionRequest(LcmResetAllowed requestPermissionRequest);

    /**
     * Returns the current value of the property 'RequestPermissionRequest'.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    LcmResetAllowed getRequestPermissionRequest() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRequestPermissionRequestUpdate().
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    void sendRequestPermissionRequestUpdate();

    // method 'setFailedServiceName'

    /**
     * The method onSetFailedServiceName() is called by ASF when a client
     * invokes the method 'setFailedServiceName'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetFailedServiceName() or sendSetFailedServiceNameError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'setFailedServiceName'</b>:
     *
     * set the name of the service again
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetFailedServiceNameRequest (const ::boost::shared_ptr< SetFailedServiceNameRequest >& request) = 0;

    /**
     * The method sendSetFailedServiceNameResponse() sends a response of a
     * previous method invocation of 'setFailedServiceName' back to the
     * client.
     *
     * <b>Documentation of 'setFailedServiceName'</b>:
     *
     * set the name of the service again
     *
     * @param response response to this command see enumeration
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetFailedServiceName(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFailedServiceNameResponse (Response response, act_t act = 0);

    /**
     * The method sendSetFailedServiceNameError() sends an error response of a
     * previous method invocation of 'setFailedServiceName' back to the
     * client.
     *
     * <b>Documentation of 'setFailedServiceName'</b>:
     *
     * set the name of the service again
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetFailedServiceName(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFailedServiceNameError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setFailedServiceStatus'

    /**
     * The method onSetFailedServiceStatus() is called by ASF when a client
     * invokes the method 'setFailedServiceStatus'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetFailedServiceStatus() or
     * sendSetFailedServiceStatusError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setFailedServiceStatus'</b>:
     *
     * set the status of the service again
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetFailedServiceStatusRequest (const ::boost::shared_ptr< SetFailedServiceStatusRequest >& request) = 0;

    /**
     * The method sendSetFailedServiceStatusResponse() sends a response of a
     * previous method invocation of 'setFailedServiceStatus' back to the
     * client.
     *
     * <b>Documentation of 'setFailedServiceStatus'</b>:
     *
     * set the status of the service again
     *
     * @param response response to this command see enumeration
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetFailedServiceStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFailedServiceStatusResponse (Response response, act_t act = 0);

    /**
     * The method sendSetFailedServiceStatusError() sends an error response of
     * a previous method invocation of 'setFailedServiceStatus' back to the
     * client.
     *
     * <b>Documentation of 'setFailedServiceStatus'</b>:
     *
     * set the status of the service again
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetFailedServiceStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetFailedServiceStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setCallStackRequestCounter'

    /**
     * The method onSetCallStackRequestCounter() is called by ASF when a
     * client invokes the method 'setCallStackRequestCounter'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendSetCallStackRequestCounter() or
     * sendSetCallStackRequestCounterError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'setCallStackRequestCounter'</b>:
     *
     * send the actual counter of SIGUSER2 signals send
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetCallStackRequestCounterRequest (const ::boost::shared_ptr< SetCallStackRequestCounterRequest >& request) = 0;

    /**
     * The method sendSetCallStackRequestCounterResponse() sends a response of
     * a previous method invocation of 'setCallStackRequestCounter' back to
     * the client.
     *
     * <b>Documentation of 'setCallStackRequestCounter'</b>:
     *
     * send the actual counter of SIGUSER2 signals send
     *
     * @param response response to this command see enumeration
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetCallStackRequestCounter(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetCallStackRequestCounterResponse (Response response, act_t act = 0);

    /**
     * The method sendSetCallStackRequestCounterError() sends an error
     * response of a previous method invocation of
     * 'setCallStackRequestCounter' back to the client.
     *
     * <b>Documentation of 'setCallStackRequestCounter'</b>:
     *
     * send the actual counter of SIGUSER2 signals send
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetCallStackRequestCounter(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetCallStackRequestCounterError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'checkResetCondition'

    /**
     * The method onCheckResetCondition() is called by ASF when a client
     * invokes the method 'checkResetCondition'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendCheckResetCondition() or sendCheckResetConditionError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'checkResetCondition'</b>:
     *
     * Send request to Lcm in order to know reset condition
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCheckResetConditionRequest (const ::boost::shared_ptr< CheckResetConditionRequest >& request) = 0;

    /**
     * The method sendCheckResetConditionResponse() sends a response of a
     * previous method invocation of 'checkResetCondition' back to the client.
     *
     * <b>Documentation of 'checkResetCondition'</b>:
     *
     * Send request to Lcm in order to know reset condition
     *
     * @param isOKToReset Status of the service can be reset or not
     *
     * @param act The parameter act identifies a previous invocation of
     * onCheckResetCondition(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCheckResetConditionResponse (LcmResetAllowed isOKToReset, act_t act = 0);

    /**
     * The method sendCheckResetConditionError() sends an error response of a
     * previous method invocation of 'checkResetCondition' back to the client.
     *
     * <b>Documentation of 'checkResetCondition'</b>:
     *
     * Send request to Lcm in order to know reset condition
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCheckResetCondition().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCheckResetConditionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    FI_VersionUpdate _FI_VersionProperty;

    FailedServiceNameUpdate _FailedServiceNameProperty;

    FailedServiceStatusUpdate _FailedServiceStatusProperty;

    CallStackRequestCounterUpdate _CallStackRequestCounterProperty;

    ActionRequestUpdate _ActionRequestProperty;

    RequestPermissionRequestUpdate _RequestPermissionRequestProperty;

    friend class Generic_RecoveryClientStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTSTUB_H
