/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm/Generic_RecoveryClient.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientDBus.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientJson.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

DEFINE_CLASS_LOGGER("/org/bosch/cm/lcm/org/bosch/cm/lcm/Generic_RecoveryClient", Generic_RecoveryClientStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 19, "checkResetCondition", 3 },
    { 20, "setFailedServiceName", 0 },
    { 22, "setFailedServiceStatus", 1 },
    { 26, "setCallStackRequestCounter", 2 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 10, "FI_Version", 0 },
    { 13, "ActionRequest", 4 },
    { 17, "FailedServiceName", 1 },
    { 19, "FailedServiceStatus", 2 },
    { 23, "CallStackRequestCounter", 3 },
    { 24, "RequestPermissionRequest", 5 },
};

class Generic_RecoveryClientStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Generic_RecoveryClientStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Generic_RecoveryClientStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Generic_RecoveryClientStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.lcm.Generic_RecoveryClient"),
          _logger(logger) {}

    virtual ~Generic_RecoveryClientStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Generic_RecoveryClientStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'setFailedServiceName'

            LOG_DEBUG_STUB("process method '%s'", "setFailedServiceName");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceNameRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetFailedServiceName", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetFailedServiceNameRequest > payload = ::boost::static_pointer_cast<SetFailedServiceNameRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Generic_RecoveryClientStub*>(getStub())->onSetFailedServiceNameRequest(payload);
            return;
        }
        case 1: {

            // method 'setFailedServiceStatus'

            LOG_DEBUG_STUB("process method '%s'", "setFailedServiceStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFailedServiceStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetFailedServiceStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetFailedServiceStatusRequest > payload = ::boost::static_pointer_cast<SetFailedServiceStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Generic_RecoveryClientStub*>(getStub())->onSetFailedServiceStatusRequest(payload);
            return;
        }
        case 2: {

            // method 'setCallStackRequestCounter'

            LOG_DEBUG_STUB("process method '%s'", "setCallStackRequestCounter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCallStackRequestCounterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetCallStackRequestCounter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetCallStackRequestCounterRequest > payload = ::boost::static_pointer_cast<SetCallStackRequestCounterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Generic_RecoveryClientStub*>(getStub())->onSetCallStackRequestCounterRequest(payload);
            return;
        }
        case 3: {

            // method 'checkResetCondition'

            LOG_DEBUG_STUB("process method '%s'", "checkResetCondition");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CheckResetConditionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CheckResetCondition", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CheckResetConditionRequest > payload = ::boost::static_pointer_cast<CheckResetConditionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Generic_RecoveryClientStub*>(getStub())->onCheckResetConditionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Generic_RecoveryClientStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.lcm.Generic_RecoveryClient\">\n"
            "    <property access=\"readwrite\" name=\"FI_Version\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"FailedServiceName\" type=\"s\"/>\n"
            "    <property access=\"readwrite\" name=\"FailedServiceStatus\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"CallStackRequestCounter\" type=\"y\"/>\n"
            "    <property access=\"readwrite\" name=\"ActionRequest\" type=\"u\"/>\n"
            "    <property access=\"readwrite\" name=\"RequestPermissionRequest\" type=\"u\"/>\n"
            "    <method name=\"setFailedServiceName\">\n"
            "      <doc>\n"
            "        <line>setFailedServiceName = set the name of the service again</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"serviceName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>serviceName = Name of the service this instance runs for</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"defaultAction\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>defaultAction (of type UnitActions) = default action defined for this service file</line>\n"
            "          <line>enum[UNIT_KILL (null), UNIT_STOP (null), UNIT_RELOAD (null), UNIT_REACTIVATE (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>response (of type Response) = response to this command see enumeration</line>\n"
            "          <line>enum[E_OK (null), E_BUSY (null), E_ALREADY_PRESENT (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setFailedServiceStatus\">\n"
            "      <doc>\n"
            "        <line>setFailedServiceStatus = set the status of the service again</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"serviceName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>serviceName = Name of the service this instance runs for</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"serviceState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>serviceState (of type UnitStates) = Status of the service this instance runs for</line>\n"
            "          <line>enum[UNIT_ACTIVE (null), UNIT_RELOADING (null), UNIT_INACTIVE (null), UNIT_FAILED (null), UNIT_ACTIVATING (null), UNIT_DEACTIVATING (null), _UNIT_ACTIVE_STATE_MAX (null), _UNIT_ACTIVE_STATE_INVALID (0xFF)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>response (of type Response) = response to this command see enumeration</line>\n"
            "          <line>enum[E_OK (null), E_BUSY (null), E_ALREADY_PRESENT (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setCallStackRequestCounter\">\n"
            "      <doc>\n"
            "        <line>setCallStackRequestCounter = send the actual counter of SIGUSER2 signals send</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"serviceName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>serviceName = Name of the service this instance runs for</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"callStackRequestCounter\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>callStackRequestCounter = Status of the service this instance runs for</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>response (of type Response) = response to this command see enumeration</line>\n"
            "          <line>enum[E_OK (null), E_BUSY (null), E_ALREADY_PRESENT (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"checkResetCondition\">\n"
            "      <doc>\n"
            "        <line>checkResetCondition = Send request to Lcm in order to know reset condition</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"serviceName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>serviceName = Name of the service this instance runs for</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"isOKToReset\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>isOKToReset (of type LcmResetAllowed) = Status of the service can be reset or not</line>\n"
            "          <line>enum[ALLOW_TO_RESET (null), NOT_ALLOW_TO_RESET (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void Generic_RecoveryClientStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Generic_RecoveryClientStub*>(getStub()))->onGetAll (properties);
}

void Generic_RecoveryClientStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 6, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FI_Version");
            ::boost::shared_ptr< FI_VersionSet > payload(new FI_VersionSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFI_VersionSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "FailedServiceName");
            ::boost::shared_ptr< FailedServiceNameSet > payload(new FailedServiceNameSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFailedServiceNameSet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "FailedServiceStatus");
            ::boost::shared_ptr< FailedServiceStatusSet > payload(new FailedServiceStatusSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFailedServiceStatusSet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "CallStackRequestCounter");
            ::boost::shared_ptr< CallStackRequestCounterSet > payload(new CallStackRequestCounterSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onCallStackRequestCounterSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "ActionRequest");
            ::boost::shared_ptr< ActionRequestSet > payload(new ActionRequestSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onActionRequestSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "RequestPermissionRequest");
            ::boost::shared_ptr< RequestPermissionRequestSet > payload(new RequestPermissionRequestSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onRequestPermissionRequestSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Generic_RecoveryClientStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 6, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FI_Version");
            ::boost::shared_ptr< FI_VersionGet > payload(new FI_VersionGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFI_VersionGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "FailedServiceName");
            ::boost::shared_ptr< FailedServiceNameGet > payload(new FailedServiceNameGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFailedServiceNameGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "FailedServiceStatus");
            ::boost::shared_ptr< FailedServiceStatusGet > payload(new FailedServiceStatusGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onFailedServiceStatusGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "CallStackRequestCounter");
            ::boost::shared_ptr< CallStackRequestCounterGet > payload(new CallStackRequestCounterGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onCallStackRequestCounterGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "ActionRequest");
            ::boost::shared_ptr< ActionRequestGet > payload(new ActionRequestGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onActionRequestGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "RequestPermissionRequest");
            ::boost::shared_ptr< RequestPermissionRequestGet > payload(new RequestPermissionRequestGet());
            payload->setAct(act);
            static_cast<Generic_RecoveryClientStub*>(getStub())->onRequestPermissionRequestGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Generic_RecoveryClientStub::Generic_RecoveryClientStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Generic_RecoveryClientStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Generic_RecoveryClientStub::Generic_RecoveryClientStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Generic_RecoveryClientStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Generic_RecoveryClientStub::~Generic_RecoveryClientStub() {
    delete _stubDelegate;
}

void Generic_RecoveryClientStub::sendFI_VersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FI_VersionUpdate payload(_FI_VersionProperty);

        LOG_INFO ("-> send%s", "FI_VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FI_Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FI_VersionUpdate");
    }
}

void Generic_RecoveryClientStub::onFI_VersionGet(const ::boost::shared_ptr< FI_VersionGet >& fI_Version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FI_VersionGet", fI_Version->getAct());
    sendFI_VersionGetUpdate(_FI_VersionProperty.getFI_Version(), fI_Version->getAct());
}

void Generic_RecoveryClientStub::sendFI_VersionGetUpdate(const ::std::string& fI_Version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FI_VersionGet payload(fI_Version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FI_VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onFI_VersionSet(const ::boost::shared_ptr< FI_VersionSet >& fI_Version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FI_VersionSet", fI_Version->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*fI_Version, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setFI_Version (fI_Version->getFI_Version());
    sendFI_VersionSetUpdate(fI_Version->getAct());
}

void Generic_RecoveryClientStub::sendFI_VersionSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FI_VersionSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setFI_Version(const ::std::string& fI_Version) {
    if(fI_Version!=_FI_VersionProperty.getFI_Version()) {
        _FI_VersionProperty.setFI_Version(fI_Version);
        sendFI_VersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Generic_RecoveryClientStub::getFI_Version() const {
    return _FI_VersionProperty.getFI_Version();
}

::std::string& Generic_RecoveryClientStub::getFI_VersionMutable() {
    return _FI_VersionProperty.getFI_VersionMutable();
}

void Generic_RecoveryClientStub::sendFailedServiceNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FailedServiceNameUpdate payload(_FailedServiceNameProperty);

        LOG_INFO ("-> send%s", "FailedServiceNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FailedServiceName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FailedServiceNameUpdate");
    }
}

void Generic_RecoveryClientStub::onFailedServiceNameGet(const ::boost::shared_ptr< FailedServiceNameGet >& failedServiceName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FailedServiceNameGet", failedServiceName->getAct());
    sendFailedServiceNameGetUpdate(_FailedServiceNameProperty.getFailedServiceName(), failedServiceName->getAct());
}

void Generic_RecoveryClientStub::sendFailedServiceNameGetUpdate(const ::std::string& failedServiceName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FailedServiceNameGet payload(failedServiceName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FailedServiceNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onFailedServiceNameSet(const ::boost::shared_ptr< FailedServiceNameSet >& failedServiceName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FailedServiceNameSet", failedServiceName->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*failedServiceName, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setFailedServiceName (failedServiceName->getFailedServiceName());
    sendFailedServiceNameSetUpdate(failedServiceName->getAct());
}

void Generic_RecoveryClientStub::sendFailedServiceNameSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FailedServiceNameSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setFailedServiceName(const ::std::string& failedServiceName) {
    if(failedServiceName!=_FailedServiceNameProperty.getFailedServiceName()) {
        _FailedServiceNameProperty.setFailedServiceName(failedServiceName);
        sendFailedServiceNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Generic_RecoveryClientStub::getFailedServiceName() const {
    return _FailedServiceNameProperty.getFailedServiceName();
}

::std::string& Generic_RecoveryClientStub::getFailedServiceNameMutable() {
    return _FailedServiceNameProperty.getFailedServiceNameMutable();
}

void Generic_RecoveryClientStub::sendFailedServiceStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FailedServiceStatusUpdate payload(_FailedServiceStatusProperty);

        LOG_INFO ("-> send%s", "FailedServiceStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FailedServiceStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FailedServiceStatusUpdate");
    }
}

void Generic_RecoveryClientStub::onFailedServiceStatusGet(const ::boost::shared_ptr< FailedServiceStatusGet >& failedServiceStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FailedServiceStatusGet", failedServiceStatus->getAct());
    sendFailedServiceStatusGetUpdate(_FailedServiceStatusProperty.getFailedServiceStatus(), failedServiceStatus->getAct());
}

void Generic_RecoveryClientStub::sendFailedServiceStatusGetUpdate(UnitStates failedServiceStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FailedServiceStatusGet payload(failedServiceStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FailedServiceStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onFailedServiceStatusSet(const ::boost::shared_ptr< FailedServiceStatusSet >& failedServiceStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FailedServiceStatusSet", failedServiceStatus->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*failedServiceStatus, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setFailedServiceStatus (failedServiceStatus->getFailedServiceStatus());
    sendFailedServiceStatusSetUpdate(failedServiceStatus->getAct());
}

void Generic_RecoveryClientStub::sendFailedServiceStatusSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FailedServiceStatusSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setFailedServiceStatus(UnitStates failedServiceStatus) {
    if(failedServiceStatus!=_FailedServiceStatusProperty.getFailedServiceStatus()) {
        _FailedServiceStatusProperty.setFailedServiceStatus(failedServiceStatus);
        sendFailedServiceStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

UnitStates Generic_RecoveryClientStub::getFailedServiceStatus() const {
    return _FailedServiceStatusProperty.getFailedServiceStatus();
}

void Generic_RecoveryClientStub::sendCallStackRequestCounterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CallStackRequestCounterUpdate payload(_CallStackRequestCounterProperty);

        LOG_INFO ("-> send%s", "CallStackRequestCounterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CallStackRequestCounter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CallStackRequestCounterUpdate");
    }
}

void Generic_RecoveryClientStub::onCallStackRequestCounterGet(const ::boost::shared_ptr< CallStackRequestCounterGet >& callStackRequestCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CallStackRequestCounterGet", callStackRequestCounter->getAct());
    sendCallStackRequestCounterGetUpdate(_CallStackRequestCounterProperty.getCallStackRequestCounter(), callStackRequestCounter->getAct());
}

void Generic_RecoveryClientStub::sendCallStackRequestCounterGetUpdate(uint8 callStackRequestCounter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CallStackRequestCounterGet payload(callStackRequestCounter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CallStackRequestCounterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onCallStackRequestCounterSet(const ::boost::shared_ptr< CallStackRequestCounterSet >& callStackRequestCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CallStackRequestCounterSet", callStackRequestCounter->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*callStackRequestCounter, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setCallStackRequestCounter (callStackRequestCounter->getCallStackRequestCounter());
    sendCallStackRequestCounterSetUpdate(callStackRequestCounter->getAct());
}

void Generic_RecoveryClientStub::sendCallStackRequestCounterSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CallStackRequestCounterSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setCallStackRequestCounter(uint8 callStackRequestCounter) {
    if(callStackRequestCounter!=_CallStackRequestCounterProperty.getCallStackRequestCounter()) {
        _CallStackRequestCounterProperty.setCallStackRequestCounter(callStackRequestCounter);
        sendCallStackRequestCounterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 Generic_RecoveryClientStub::getCallStackRequestCounter() const {
    return _CallStackRequestCounterProperty.getCallStackRequestCounter();
}

void Generic_RecoveryClientStub::sendActionRequestUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActionRequestUpdate payload(_ActionRequestProperty);

        LOG_INFO ("-> send%s", "ActionRequestUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActionRequest", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActionRequestUpdate");
    }
}

void Generic_RecoveryClientStub::onActionRequestGet(const ::boost::shared_ptr< ActionRequestGet >& actionRequest) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActionRequestGet", actionRequest->getAct());
    sendActionRequestGetUpdate(_ActionRequestProperty.getActionRequest(), actionRequest->getAct());
}

void Generic_RecoveryClientStub::sendActionRequestGetUpdate(UnitActions actionRequest, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActionRequestGet payload(actionRequest);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActionRequestGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onActionRequestSet(const ::boost::shared_ptr< ActionRequestSet >& actionRequest) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActionRequestSet", actionRequest->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*actionRequest, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setActionRequest (actionRequest->getActionRequest());
    sendActionRequestSetUpdate(actionRequest->getAct());
}

void Generic_RecoveryClientStub::sendActionRequestSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActionRequestSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setActionRequest(UnitActions actionRequest) {
    if(actionRequest!=_ActionRequestProperty.getActionRequest()) {
        _ActionRequestProperty.setActionRequest(actionRequest);
        sendActionRequestUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

UnitActions Generic_RecoveryClientStub::getActionRequest() const {
    return _ActionRequestProperty.getActionRequest();
}

void Generic_RecoveryClientStub::sendRequestPermissionRequestUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RequestPermissionRequestUpdate payload(_RequestPermissionRequestProperty);

        LOG_INFO ("-> send%s", "RequestPermissionRequestUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RequestPermissionRequest", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm.Generic_RecoveryClient", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RequestPermissionRequestUpdate");
    }
}

void Generic_RecoveryClientStub::onRequestPermissionRequestGet(const ::boost::shared_ptr< RequestPermissionRequestGet >& requestPermissionRequest) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequestPermissionRequestGet", requestPermissionRequest->getAct());
    sendRequestPermissionRequestGetUpdate(_RequestPermissionRequestProperty.getRequestPermissionRequest(), requestPermissionRequest->getAct());
}

void Generic_RecoveryClientStub::sendRequestPermissionRequestGetUpdate(LcmResetAllowed requestPermissionRequest, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RequestPermissionRequestGet payload(requestPermissionRequest);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequestPermissionRequestGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Generic_RecoveryClientStub::onRequestPermissionRequestSet(const ::boost::shared_ptr< RequestPermissionRequestSet >& requestPermissionRequest) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RequestPermissionRequestSet", requestPermissionRequest->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*requestPermissionRequest, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setRequestPermissionRequest (requestPermissionRequest->getRequestPermissionRequest());
    sendRequestPermissionRequestSetUpdate(requestPermissionRequest->getAct());
}

void Generic_RecoveryClientStub::sendRequestPermissionRequestSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RequestPermissionRequestSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Generic_RecoveryClientStub::setRequestPermissionRequest(LcmResetAllowed requestPermissionRequest) {
    if(requestPermissionRequest!=_RequestPermissionRequestProperty.getRequestPermissionRequest()) {
        _RequestPermissionRequestProperty.setRequestPermissionRequest(requestPermissionRequest);
        sendRequestPermissionRequestUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

LcmResetAllowed Generic_RecoveryClientStub::getRequestPermissionRequest() const {
    return _RequestPermissionRequestProperty.getRequestPermissionRequest();
}

void  Generic_RecoveryClientStub::sendSetFailedServiceNameResponse (Response response, act_t act) {
    SetFailedServiceNameResponse* payload = new SetFailedServiceNameResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "setFailedServiceName", SetFailedServiceNameResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetFailedServiceName", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendSetFailedServiceNameError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetFailedServiceNameError* payload = new SetFailedServiceNameError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setFailedServiceName", SetFailedServiceNameError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetFailedServiceName", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendSetFailedServiceStatusResponse (Response response, act_t act) {
    SetFailedServiceStatusResponse* payload = new SetFailedServiceStatusResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "setFailedServiceStatus", SetFailedServiceStatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetFailedServiceStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendSetFailedServiceStatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetFailedServiceStatusError* payload = new SetFailedServiceStatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setFailedServiceStatus", SetFailedServiceStatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetFailedServiceStatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendSetCallStackRequestCounterResponse (Response response, act_t act) {
    SetCallStackRequestCounterResponse* payload = new SetCallStackRequestCounterResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "setCallStackRequestCounter", SetCallStackRequestCounterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetCallStackRequestCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendSetCallStackRequestCounterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetCallStackRequestCounterError* payload = new SetCallStackRequestCounterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setCallStackRequestCounter", SetCallStackRequestCounterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetCallStackRequestCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendCheckResetConditionResponse (LcmResetAllowed isOKToReset, act_t act) {
    CheckResetConditionResponse* payload = new CheckResetConditionResponse(isOKToReset);
    DBUS_MESSAGE_REPLY(dbusMessage, "checkResetCondition", CheckResetConditionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CheckResetCondition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Generic_RecoveryClientStub::sendCheckResetConditionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CheckResetConditionError* payload = new CheckResetConditionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "checkResetCondition", CheckResetConditionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CheckResetCondition", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Generic_RecoveryClientStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'FI_Version'
    {
        ::asf::dbus::DBusVariant variant;
        FI_VersionGet payload(_FI_VersionProperty.getFI_Version());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FI_Version", variant));
    }

    //property 'FailedServiceName'
    {
        ::asf::dbus::DBusVariant variant;
        FailedServiceNameGet payload(_FailedServiceNameProperty.getFailedServiceName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FailedServiceName", variant));
    }

    //property 'FailedServiceStatus'
    {
        ::asf::dbus::DBusVariant variant;
        FailedServiceStatusGet payload(_FailedServiceStatusProperty.getFailedServiceStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FailedServiceStatus", variant));
    }

    //property 'CallStackRequestCounter'
    {
        ::asf::dbus::DBusVariant variant;
        CallStackRequestCounterGet payload(_CallStackRequestCounterProperty.getCallStackRequestCounter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CallStackRequestCounter", variant));
    }

    //property 'ActionRequest'
    {
        ::asf::dbus::DBusVariant variant;
        ActionRequestGet payload(_ActionRequestProperty.getActionRequest());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActionRequest", variant));
    }

    //property 'RequestPermissionRequest'
    {
        ::asf::dbus::DBusVariant variant;
        RequestPermissionRequestGet payload(_RequestPermissionRequestProperty.getRequestPermissionRequest());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RequestPermissionRequest", variant));
    }
}

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org
