/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTPROXY_H
#define ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClient.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientConst.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace Generic_RecoveryClient {

class Generic_RecoveryClientProxy;

class ActionRequestCallbackIF {
public:
    virtual ~ActionRequestCallbackIF() {}

    virtual void onActionRequestError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< ActionRequestError >& error) = 0;

    virtual void onActionRequestUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< ActionRequestUpdate >& update) = 0;
};

class CallStackRequestCounterCallbackIF {
public:
    virtual ~CallStackRequestCounterCallbackIF() {}

    virtual void onCallStackRequestCounterError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< CallStackRequestCounterError >& error) = 0;

    virtual void onCallStackRequestCounterUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< CallStackRequestCounterUpdate >& update) = 0;
};

class CheckResetConditionCallbackIF {
public:
    virtual ~CheckResetConditionCallbackIF() {}

    virtual void onCheckResetConditionError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< CheckResetConditionError >& error) = 0;

    virtual void onCheckResetConditionResponse(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< CheckResetConditionResponse >& response) = 0;
};

class FI_VersionCallbackIF {
public:
    virtual ~FI_VersionCallbackIF() {}

    virtual void onFI_VersionError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FI_VersionError >& error) = 0;

    virtual void onFI_VersionUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FI_VersionUpdate >& update) = 0;
};

class FailedServiceNameCallbackIF {
public:
    virtual ~FailedServiceNameCallbackIF() {}

    virtual void onFailedServiceNameError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FailedServiceNameError >& error) = 0;

    virtual void onFailedServiceNameUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FailedServiceNameUpdate >& update) = 0;
};

class FailedServiceStatusCallbackIF {
public:
    virtual ~FailedServiceStatusCallbackIF() {}

    virtual void onFailedServiceStatusError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FailedServiceStatusError >& error) = 0;

    virtual void onFailedServiceStatusUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< FailedServiceStatusUpdate >& update) = 0;
};

class RequestPermissionRequestCallbackIF {
public:
    virtual ~RequestPermissionRequestCallbackIF() {}

    virtual void onRequestPermissionRequestError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< RequestPermissionRequestError >& error) = 0;

    virtual void onRequestPermissionRequestUpdate(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< RequestPermissionRequestUpdate >& update) = 0;
};

class SetCallStackRequestCounterCallbackIF {
public:
    virtual ~SetCallStackRequestCounterCallbackIF() {}

    virtual void onSetCallStackRequestCounterError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetCallStackRequestCounterError >& error) = 0;

    virtual void onSetCallStackRequestCounterResponse(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetCallStackRequestCounterResponse >& response) = 0;
};

class SetFailedServiceNameCallbackIF {
public:
    virtual ~SetFailedServiceNameCallbackIF() {}

    virtual void onSetFailedServiceNameError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetFailedServiceNameError >& error) = 0;

    virtual void onSetFailedServiceNameResponse(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetFailedServiceNameResponse >& response) = 0;
};

class SetFailedServiceStatusCallbackIF {
public:
    virtual ~SetFailedServiceStatusCallbackIF() {}

    virtual void onSetFailedServiceStatusError(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetFailedServiceStatusError >& error) = 0;

    virtual void onSetFailedServiceStatusResponse(const ::boost::shared_ptr< Generic_RecoveryClientProxy >& proxy, const ::boost::shared_ptr< SetFailedServiceStatusResponse >& response) = 0;
};


/**
 * Generic_RecoveryClientProxy is the client side representation of the
 * D-Bus service interface 'org.bosch.cm.lcm.Generic_RecoveryClient'
 * (specified in file Generic_RecoveryClient_.xml).
 *
 * LCM Generic recovery client interface.
 * 	The recovery client is used to handle an unexpected state change of a systemd unit from
 * 	active to any other state
 *
 * 	The recovery client is started automatically by systemd
 */
class Generic_RecoveryClientProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of Generic_RecoveryClientProxy.
     */
    static ::boost::shared_ptr< Generic_RecoveryClientProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of Generic_RecoveryClientProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< Generic_RecoveryClientProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of Generic_RecoveryClientProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< Generic_RecoveryClientProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Generic_RecoveryClientProxy > proxyNew(new Generic_RecoveryClientProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~Generic_RecoveryClientProxy ();



    // Property 'FI_Version'

    /**
     * Notify on the property 'FI_Version'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFI_VersionRegister(FI_VersionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FI_Version'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param act The act which was previously returned by the
     * sendFI_VersionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFI_VersionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FI_Version'.
     */
    void sendFI_VersionDeregisterAll() const;

    /**
     * Request the value of the property 'FI_Version' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFI_VersionGet(FI_VersionCallbackIF& cb);

    /**
     * Set the value of the property 'FI_Version'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendFI_VersionSet(FI_VersionCallbackIF& cb, const
     * ::std::string& fI_Version) method instead.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     */
    void sendFI_VersionSet(const ::std::string& fI_Version);

    /**
     * Set the value of the property 'FI_Version'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'FI_Version'</b>:
     *
     * This encodes the version string of the running
     * 	    systemd instance.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFI_VersionSet(FI_VersionCallbackIF& cb, const ::std::string& fI_Version);

    /**
     * Returns the current value of the property 'FI_Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasFI_Version() returns true.
     *
     * @return the previously received value of the property 'FI_Version'.
     */
    const ::std::string& getFI_Version() const;

    /**
     * Determines whether a status message for the property 'FI_Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFI_Version() const;

    // Property 'FailedServiceName'

    /**
     * Notify on the property 'FailedServiceName'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceNameRegister(FailedServiceNameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FailedServiceName'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param act The act which was previously returned by the
     * sendFailedServiceNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFailedServiceNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FailedServiceName'.
     */
    void sendFailedServiceNameDeregisterAll() const;

    /**
     * Request the value of the property 'FailedServiceName' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceNameGet(FailedServiceNameCallbackIF& cb);

    /**
     * Set the value of the property 'FailedServiceName'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendFailedServiceNameSet(FailedServiceNameCallbackIF& cb, const
     * ::std::string& failedServiceName) method instead.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     */
    void sendFailedServiceNameSet(const ::std::string& failedServiceName);

    /**
     * Set the value of the property 'FailedServiceName'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'FailedServiceName'</b>:
     *
     * This encodes the service name of the failed unit.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceNameSet(FailedServiceNameCallbackIF& cb, const ::std::string& failedServiceName);

    /**
     * Returns the current value of the property 'FailedServiceName' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFailedServiceName() returns true.
     *
     * @return the previously received value of the property 'FailedServiceName'.
     */
    const ::std::string& getFailedServiceName() const;

    /**
     * Determines whether a status message for the property
     * 'FailedServiceName' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFailedServiceName() const;

    // Property 'FailedServiceStatus'

    /**
     * Notify on the property 'FailedServiceStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceStatusRegister(FailedServiceStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FailedServiceStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param act The act which was previously returned by the
     * sendFailedServiceStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFailedServiceStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FailedServiceStatus'.
     */
    void sendFailedServiceStatusDeregisterAll() const;

    /**
     * Request the value of the property 'FailedServiceStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceStatusGet(FailedServiceStatusCallbackIF& cb);

    /**
     * Set the value of the property 'FailedServiceStatus'. This method sends
     * a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendFailedServiceStatusSet(FailedServiceStatusCallbackIF& cb,
     * UnitStates failedServiceStatus) method instead.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     */
    void sendFailedServiceStatusSet(UnitStates failedServiceStatus);

    /**
     * Set the value of the property 'FailedServiceStatus'. This method sends
     * a Set message to the D-Bus server.
     *
     * <b>Documentation of 'FailedServiceStatus'</b>:
     *
     * Status of the service this instance runs for
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServiceStatusSet(FailedServiceStatusCallbackIF& cb, UnitStates failedServiceStatus);

    /**
     * Returns the current value of the property 'FailedServiceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFailedServiceStatus() returns true.
     *
     * @return the previously received value of the property 'FailedServiceStatus'.
     */
    UnitStates getFailedServiceStatus() const;

    /**
     * Determines whether a status message for the property
     * 'FailedServiceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFailedServiceStatus() const;

    // Property 'CallStackRequestCounter'

    /**
     * Notify on the property 'CallStackRequestCounter'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStackRequestCounterRegister(CallStackRequestCounterCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CallStackRequestCounter'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param act The act which was previously returned by the
     * sendCallStackRequestCounterRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCallStackRequestCounterDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'CallStackRequestCounter'.
     */
    void sendCallStackRequestCounterDeregisterAll() const;

    /**
     * Request the value of the property 'CallStackRequestCounter' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStackRequestCounterGet(CallStackRequestCounterCallbackIF& cb);

    /**
     * Set the value of the property 'CallStackRequestCounter'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendCallStackRequestCounterSet(CallStackRequestCounterCallbackIF& cb,
     * uint8 callStackRequestCounter) method instead.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     */
    void sendCallStackRequestCounterSet(uint8 callStackRequestCounter);

    /**
     * Set the value of the property 'CallStackRequestCounter'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'CallStackRequestCounter'</b>:
     *
     * This encodes the number of trials that the callstack was requested to be dumped
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCallStackRequestCounterSet(CallStackRequestCounterCallbackIF& cb, uint8 callStackRequestCounter);

    /**
     * Returns the current value of the property 'CallStackRequestCounter' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCallStackRequestCounter() returns true.
     *
     * @return the previously received value of the property 'CallStackRequestCounter'.
     */
    uint8 getCallStackRequestCounter() const;

    /**
     * Determines whether a status message for the property
     * 'CallStackRequestCounter' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCallStackRequestCounter() const;

    // Property 'ActionRequest'

    /**
     * Notify on the property 'ActionRequest'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActionRequestRegister(ActionRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ActionRequest'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param act The act which was previously returned by the
     * sendActionRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendActionRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ActionRequest'.
     */
    void sendActionRequestDeregisterAll() const;

    /**
     * Request the value of the property 'ActionRequest' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActionRequestGet(ActionRequestCallbackIF& cb);

    /**
     * Set the value of the property 'ActionRequest'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendActionRequestSet(ActionRequestCallbackIF& cb,
     * UnitActions actionRequest) method instead.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     */
    void sendActionRequestSet(UnitActions actionRequest);

    /**
     * Set the value of the property 'ActionRequest'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'ActionRequest'</b>:
     *
     * This encodes the action to be taken for the failed service
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActionRequestSet(ActionRequestCallbackIF& cb, UnitActions actionRequest);

    /**
     * Returns the current value of the property 'ActionRequest' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasActionRequest() returns true.
     *
     * @return the previously received value of the property 'ActionRequest'.
     */
    UnitActions getActionRequest() const;

    /**
     * Determines whether a status message for the property 'ActionRequest'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasActionRequest() const;

    // Property 'RequestPermissionRequest'

    /**
     * Notify on the property 'RequestPermissionRequest'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPermissionRequestRegister(RequestPermissionRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RequestPermissionRequest'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param act The act which was previously returned by the
     * sendRequestPermissionRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRequestPermissionRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'RequestPermissionRequest'.
     */
    void sendRequestPermissionRequestDeregisterAll() const;

    /**
     * Request the value of the property 'RequestPermissionRequest' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPermissionRequestGet(RequestPermissionRequestCallbackIF& cb);

    /**
     * Set the value of the property 'RequestPermissionRequest'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendRequestPermissionRequestSet(RequestPermissionRequestCallbackIF& cb,
     * LcmResetAllowed requestPermissionRequest) method instead.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     */
    void sendRequestPermissionRequestSet(LcmResetAllowed requestPermissionRequest);

    /**
     * Set the value of the property 'RequestPermissionRequest'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'RequestPermissionRequest'</b>:
     *
     * Status of reset permission from LcmRecoveryClient
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPermissionRequestSet(RequestPermissionRequestCallbackIF& cb, LcmResetAllowed requestPermissionRequest);

    /**
     * Returns the current value of the property 'RequestPermissionRequest'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRequestPermissionRequest() returns true.
     *
     * @return the previously received value of the property 'RequestPermissionRequest'.
     */
    LcmResetAllowed getRequestPermissionRequest() const;

    /**
     * Determines whether a status message for the property
     * 'RequestPermissionRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRequestPermissionRequest() const;


    // Method 'setFailedServiceName'

    /**
     * Call the method 'setFailedServiceName'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'setFailedServiceName'</b>:
     *
     * set the name of the service again
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param serviceName Name of the service this instance runs for
     *
     * @param defaultAction default action defined for this service file
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFailedServiceNameRequest(SetFailedServiceNameCallbackIF& cb, const ::std::string& serviceName, UnitActions defaultAction) const;

    // Method 'setFailedServiceStatus'

    /**
     * Call the method 'setFailedServiceStatus'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'setFailedServiceStatus'</b>:
     *
     * set the status of the service again
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param serviceName Name of the service this instance runs for
     *
     * @param serviceState Status of the service this instance runs for
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFailedServiceStatusRequest(SetFailedServiceStatusCallbackIF& cb, const ::std::string& serviceName, UnitStates serviceState) const;

    // Method 'setCallStackRequestCounter'

    /**
     * Call the method 'setCallStackRequestCounter'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'setCallStackRequestCounter'</b>:
     *
     * send the actual counter of SIGUSER2 signals send
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param serviceName Name of the service this instance runs for
     *
     * @param callStackRequestCounter Status of the service this instance runs for
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCallStackRequestCounterRequest(SetCallStackRequestCounterCallbackIF& cb, const ::std::string& serviceName, uint8 callStackRequestCounter) const;

    // Method 'checkResetCondition'

    /**
     * Call the method 'checkResetCondition'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'checkResetCondition'</b>:
     *
     * Send request to Lcm in order to know reset condition
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param serviceName Name of the service this instance runs for
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCheckResetConditionRequest(CheckResetConditionCallbackIF& cb, const ::std::string& serviceName) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    Generic_RecoveryClientProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'FI_Version'

    ::asf::core::nullable< FI_VersionUpdate > _fI_Version;

    // Property 'FailedServiceName'

    ::asf::core::nullable< FailedServiceNameUpdate > _failedServiceName;

    // Property 'FailedServiceStatus'

    ::asf::core::nullable< FailedServiceStatusUpdate > _failedServiceStatus;

    // Property 'CallStackRequestCounter'

    ::asf::core::nullable< CallStackRequestCounterUpdate > _callStackRequestCounter;

    // Property 'ActionRequest'

    ::asf::core::nullable< ActionRequestUpdate > _actionRequest;

    // Property 'RequestPermissionRequest'

    ::asf::core::nullable< RequestPermissionRequestUpdate > _requestPermissionRequest;

    DECLARE_CLASS_LOGGER();

    friend class Generic_RecoveryClientProxyCallback;
};

} // namespace Generic_RecoveryClient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_LCM_GENERIC_RECOVERYCLIENTPROXY_H
