/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "example/echoDBus/EchoDBusService.h"
#include "example/echoDBus/EchoDBusServiceDBus.h"
#include "example/echoDBus/EchoDBusServiceJson.h"
#include "example/echoDBus/EchoDBusServiceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace example {
namespace echoDBus {
namespace EchoDBusService {

DEFINE_CLASS_LOGGER("/example/echoDBus/EchoDBusService", EchoDBusServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "echo", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 9, "echoCount", 0 },
};

class EchoDBusServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    EchoDBusServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    EchoDBusServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    EchoDBusServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "example.echoDBus.EchoDBusService"),
          _logger(logger) {}

    virtual ~EchoDBusServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void EchoDBusServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'echo'

            LOG_DEBUG_STUB("process method '%s'", "echo");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EchoRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Echo", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EchoRequest > payload = ::boost::static_pointer_cast<EchoRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<EchoDBusServiceStub*>(getStub())->onEchoRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* EchoDBusServiceStubDelegate::introspect() const {
    return     "<interface name=\"example.echoDBus.EchoDBusService\">\n"
            "      <method name=\"echo\">\n"
            "        <arg direction=\"in\" name=\"message\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"message\" type=\"s\"/>\n"
            "      </method>\n"
            "      <property access=\"readwrite\" name=\"echoCount\" type=\"i\"/>\n"
            "      <signal name=\"echoResponseSent\">\n"
            "        <arg name=\"message\" type=\"s\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void EchoDBusServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<EchoDBusServiceStub*>(getStub()))->onGetAll (properties);
}

void EchoDBusServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "echoCount");
            ::boost::shared_ptr< EchoCountSet > payload(new EchoCountSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<EchoDBusServiceStub*>(getStub())->onEchoCountSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void EchoDBusServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "echoCount");
            ::boost::shared_ptr< EchoCountGet > payload(new EchoCountGet());
            payload->setAct(act);
            static_cast<EchoDBusServiceStub*>(getStub())->onEchoCountGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

EchoDBusServiceStub::EchoDBusServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new EchoDBusServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

EchoDBusServiceStub::EchoDBusServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new EchoDBusServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

EchoDBusServiceStub::~EchoDBusServiceStub() {
    delete _stubDelegate;
}

void EchoDBusServiceStub::sendEchoResponseSentSignal(const ::std::string& message) {
    if (_stubDelegate->isConnected()) {
        EchoResponseSentSignal* payload = new EchoResponseSentSignal(message);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "echoResponseSent", EchoResponseSentSignal, payload)
        LOG_INFO ("-> send%sSignal", "EchoResponseSent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "EchoResponseSent");
    }
}

void EchoDBusServiceStub::sendEchoCountUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EchoCountUpdate payload(_echoCountProperty);

        LOG_INFO ("-> send%s", "EchoCountUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("echoCount", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("example.echoDBus.EchoDBusService", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EchoCountUpdate");
    }
}

void EchoDBusServiceStub::onEchoCountGet(const ::boost::shared_ptr< EchoCountGet >& echoCount) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EchoCountGet", echoCount->getAct());
    sendEchoCountGetUpdate(_echoCountProperty.getEchoCount(), echoCount->getAct());
}

void EchoDBusServiceStub::sendEchoCountGetUpdate(int32 echoCount, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EchoCountGet payload(echoCount);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EchoCountGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void EchoDBusServiceStub::onEchoCountSet(const ::boost::shared_ptr< EchoCountSet >& echoCount) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EchoCountSet", echoCount->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*echoCount, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setEchoCount (echoCount->getEchoCount());
    sendEchoCountSetUpdate(echoCount->getAct());
}

void EchoDBusServiceStub::sendEchoCountSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EchoCountSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void EchoDBusServiceStub::setEchoCount(int32 echoCount) {
    if(echoCount!=_echoCountProperty.getEchoCount()) {
        _echoCountProperty.setEchoCount(echoCount);
        sendEchoCountUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 EchoDBusServiceStub::getEchoCount() const {
    return _echoCountProperty.getEchoCount();
}

void  EchoDBusServiceStub::sendEchoResponse (const ::std::string& message, act_t act) {
    EchoResponse* payload = new EchoResponse(message);
    DBUS_MESSAGE_REPLY(dbusMessage, "echo", EchoResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Echo", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  EchoDBusServiceStub::sendEchoError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EchoError* payload = new EchoError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "echo", EchoError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Echo", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void EchoDBusServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'echoCount'
    {
        ::asf::dbus::DBusVariant variant;
        EchoCountGet payload(_echoCountProperty.getEchoCount());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("echoCount", variant));
    }
}

} // namespace EchoDBusService
} // namespace echoDBus
} // namespace example
