/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "example/echoDBus/EchoDBusService.h"
#include "example/echoDBus/EchoDBusServiceDBus.h"
#include "example/echoDBus/EchoDBusServiceJson.h"
#include "example/echoDBus/EchoDBusServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace example {
namespace echoDBus {
namespace EchoDBusService {

DEFINE_CLASS_LOGGER("/example/echoDBus/EchoDBusService", EchoDBusServiceProxy);

class EchoDBusServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    EchoDBusServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< EchoDBusServiceProxy >& proxyShared = ::boost::static_pointer_cast< EchoDBusServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_echoResponseSent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EchoResponseSentSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EchoResponseSent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EchoResponseSentSignal> payload = ::boost::static_pointer_cast<EchoResponseSentSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EchoResponseSentCallbackIF*) _callback)->onEchoResponseSentSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_echoCount:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EchoCountError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EchoCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EchoCountError> payload = ::boost::static_pointer_cast<EchoCountError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((EchoCountCallbackIF*) _callback)->onEchoCountError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EchoCountUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EchoCount", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EchoCountUpdate> payload = ::boost::static_pointer_cast<EchoCountUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((EchoCountCallbackIF*) _callback)->onEchoCountUpdate(proxyShared, payload);
                        proxyShared->_echoCount = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_echo:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), EchoError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Echo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EchoError> payload = ::boost::static_pointer_cast<EchoError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EchoCallbackIF*) _callback)->onEchoError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EchoResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Echo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<EchoResponse> payload = ::boost::static_pointer_cast<EchoResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((EchoCallbackIF*) _callback)->onEchoResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_echoResponseSent: {
                ::boost::shared_ptr< EchoResponseSentError > payload = ::boost::shared_ptr< EchoResponseSentError >
                (new EchoResponseSentError(DBUS_ERROR_NO_SERVER, "The DBus service EchoDBusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EchoResponseSent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<EchoDBusServiceProxy> proxyShared = ::boost::static_pointer_cast<EchoDBusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EchoResponseSentCallbackIF*) _callback)->onEchoResponseSentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_echoCount: {
                ::boost::shared_ptr< EchoCountError > payload = ::boost::shared_ptr< EchoCountError >
                (new EchoCountError(DBUS_ERROR_NO_SERVER, "The DBus service EchoDBusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EchoCount", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<EchoDBusServiceProxy> proxyShared = ::boost::static_pointer_cast<EchoDBusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EchoCountCallbackIF*) _callback)->onEchoCountError (proxyShared,payload);
                return true;
            }
            break;
            case ID_echo: {
                ::boost::shared_ptr< EchoError > payload = ::boost::shared_ptr< EchoError >
                (new EchoError(DBUS_ERROR_NO_SERVER, "The DBus service EchoDBusService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Echo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<EchoDBusServiceProxy> proxyShared = ::boost::static_pointer_cast<EchoDBusServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EchoCallbackIF*) _callback)->onEchoError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& EchoDBusServiceProxyCallback::_logger (EchoDBusServiceProxy::_logger);

EchoDBusServiceProxy::EchoDBusServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "example.echoDBus.EchoDBusService", serviceAvailable, _logger) {
}

EchoDBusServiceProxy::~EchoDBusServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< EchoDBusServiceProxy > EchoDBusServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<EchoDBusServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< EchoDBusServiceProxy > proxyNew(new EchoDBusServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t EchoDBusServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    EchoDBusServiceProxyCallback* callback = new EchoDBusServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t EchoDBusServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    EchoDBusServiceProxyCallback* callback = new EchoDBusServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void EchoDBusServiceProxy::clearAllProperties ()
{
    _echoCount = ::asf::core::nullable< EchoCountUpdate >();
}

void EchoDBusServiceProxy::sendDeregisterAll () const
{
    sendEchoCountDeregisterAll();
    sendEchoResponseSentDeregisterAll();
}

act_t EchoDBusServiceProxy::sendEchoResponseSentRegister(EchoResponseSentCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "echoResponseSent");
    act_t act = addSignalCallback(ID_echoResponseSent, "echoResponseSent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EchoResponseSent", &cb, act);
    return act;
}

bool EchoDBusServiceProxy::sendEchoResponseSentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("echoResponseSent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EchoResponseSent", act, static_cast<int>(rv));
    return rv;
}

void EchoDBusServiceProxy::sendEchoResponseSentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EchoResponseSent");
    _dbusProxyDelegate->deregisterSignalCallback("echoResponseSent", 0, _dbusDaemonProxy.get(), false);
}

act_t EchoDBusServiceProxy::sendEchoCountRegister(EchoCountCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_echoCount, "echoCount", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EchoCount", &cb, act);
    return act;
}

bool EchoDBusServiceProxy::sendEchoCountDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("echoCount", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EchoCount", act, static_cast<int>(rv));
    return rv;
}

act_t EchoDBusServiceProxy::sendEchoCountGet(EchoCountCallbackIF& cb) {
    EchoDBusServiceProxyCallback* callback = new EchoDBusServiceProxyCallback(ID_echoCount, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "EchoCount", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("echoCount", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void EchoDBusServiceProxy::sendEchoCountSet(int32 echoCount) {
    EchoCountSet parameter(echoCount);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "EchoCount");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "echoCount", propertyContent);
}

act_t EchoDBusServiceProxy::sendEchoCountSet(EchoCountCallbackIF& cb, int32 echoCount) {
    EchoDBusServiceProxyCallback* callback = new EchoDBusServiceProxyCallback(ID_echoCount, &cb);
    EchoCountSet parameter(echoCount);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "EchoCount", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "echoCount", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

int32 EchoDBusServiceProxy::getEchoCount() const {
    return _echoCount.get().getEchoCount();
}

bool EchoDBusServiceProxy::hasEchoCount() const {
    return _echoCount.hasValue();
}

void EchoDBusServiceProxy::sendEchoCountDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EchoCount");
    _dbusProxyDelegate->deregisterSignalCallback("echoCount", 0, _dbusDaemonProxy.get(), true);
}

act_t EchoDBusServiceProxy::sendEchoRequest(EchoCallbackIF& cb, const ::std::string& message) const {
    EchoRequest* payload = new EchoRequest();
    CHECK_ALLOCATION(payload);
    payload->setMessage(message);
    DBUS_MESSAGE_CALL(dbusMessage, "echo", EchoRequest, payload, true)
    act_t act = addMethodCallback(ID_echo, dbusMessage.getUniqueSerial(), "echo", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Echo", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace EchoDBusService
} // namespace echoDBus
} // namespace example
