#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef EXAMPLE_ECHOCCA_ECHOFI_H
#define EXAMPLE_ECHOCCA_ECHOFI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * CCA Functional Interface 'EchoFI'
 *
 * Fullname: EchoFI
 */

namespace example {
namespace echoCca {
namespace EchoFI {

static const int SERVICE_ID = 1;

static const int FID_echoCount = 1;

static const int FID_echo = 2;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class EchoCountStatus;

class EchoStart;

class EchoResult;

// type definitions
/**
 * The get message of the property "echoCount"
 * This is a property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EchoCountGet;

/**
 * The upreg message of the property "echoCount"
 * This is a property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EchoCountUpReg;

/**
 * The relUpReg message of the property "echoCount"
 * This is a property
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EchoCountRelUpReg;

/**
 * The error message of 'echoCount'
 */
typedef ::asf::cca::CcaTypes::DefaultError EchoCountError;

/**
 * The abort error message of the method "echo"
 * This is a method
 */
typedef ::asf::cca::CcaTypes::DefaultError EchoAbortError;

/**
 * The error message of 'echo'
 */
typedef ::asf::cca::CcaTypes::DefaultError EchoError;


/**
 * The status message of the property "echoCount"
 * This is a property
 */
class EchoCountStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoCountStatus ();

    /**
     * Copy constructor
     */
    inline  EchoCountStatus (const EchoCountStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EchoCountStatus (uint32 echoCount_);

    /**
     * Destructor
     */
    inline virtual  ~EchoCountStatus();

    /**
     * Assignment operator
     */
    inline EchoCountStatus& operator = (const EchoCountStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoCountStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoCountStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoCountStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoCountStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "echoCount"

    static const int kEchoCount = 0;

    /**
     * Clears the field "echoCount".
     *
     * The field will be set to its default value. The hasEchoCount()
     * method will return false.
     */
    inline void clearEchoCount();

    /**
     * Checks whether the field "echoCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEchoCount()). Otherwise it will return false.
     */
    inline bool hasEchoCount () const;

    /**
     * Returns the value of the member "echoCount".
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "echoCount"
     */
    inline uint32 getEchoCount () const;

    /**
     * Sets the value of the member "echoCount".
     *
     * If the meaning of "echoCount" isn't clear, then there should be a description here.
     *
     * @param echoCount The value which will be set
     */
    inline void setEchoCount (uint32 echoCount_);

    static const EchoCountStatus &getDefaultInstance();

private:

    inline void set_has_echoCount ();

    inline void clear_has_echoCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _echoCount;

};

/**
 * The start message of the method "echo"
 * This is a method
 */
class EchoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoStart ();

    /**
     * Copy constructor
     */
    inline  EchoStart (const EchoStart &rhs);

    /**
     * All fields constructor
     */
    inline  EchoStart (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~EchoStart();

    /**
     * Assignment operator
     */
    inline EchoStart& operator = (const EchoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    static const EchoStart &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _message;

};

/**
 * The result message of the method "echo"
 * This is a method
 */
class EchoResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EchoResult ();

    /**
     * Copy constructor
     */
    inline  EchoResult (const EchoResult &rhs);

    /**
     * All fields constructor
     */
    inline  EchoResult (const ::std::string& result_);

    /**
     * Destructor
     */
    inline virtual  ~EchoResult();

    /**
     * Assignment operator
     */
    inline EchoResult& operator = (const EchoResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EchoResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EchoResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EchoResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EchoResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "result"

    static const int kResult = 0;

    /**
     * Clears the field "result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "result"
     */
    inline const ::std::string& getResult () const;

    /**
     * Retrieves the value of the field "result" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "result".
     */
    inline ::std::string& getResultMutable ();

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const ::std::string& result_);

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const char* result_);

    /**
     * Sets the value of the member "result".
     *
     * If the meaning of "result" isn't clear, then there should be a description here.
     *
     * @param result The value which will be set
     */
    inline void setResult (const char* value, size_t size);

    static const EchoResult &getDefaultInstance();

private:

    inline void set_has_result ();

    inline void clear_has_result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _result;

};

inline  EchoCountStatus::EchoCountStatus ()  :
    _echoCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoCountStatus::EchoCountStatus (const EchoCountStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _echoCount (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoCountStatus::EchoCountStatus (uint32 echoCount_)  :
    _echoCount (echoCount_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoCountStatus::~EchoCountStatus() {
}

inline EchoCountStatus& EchoCountStatus::operator = (const EchoCountStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEchoCount()) {
            setEchoCount(rhs.getEchoCount());
        } else {
            clearEchoCount();
        }
    }
    return *this;
}

inline bool EchoCountStatus::operator == (const EchoCountStatus& rhs) const {
    return (((!hasEchoCount() && !rhs.hasEchoCount()) || getEchoCount() == rhs.getEchoCount()));
}

inline bool EchoCountStatus::operator != (const EchoCountStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoCountStatus::operator < (const EchoCountStatus& rhs) const {
    if (hasEchoCount() || rhs.hasEchoCount()) {
        if (getEchoCount() < rhs.getEchoCount()) return true;
        if (getEchoCount() > rhs.getEchoCount()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoCountStatus::clone() {
    return new EchoCountStatus(*this);
}

inline bool EchoCountStatus::operator > (const EchoCountStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoCountStatus::clear() {
    clearEchoCount();
}

inline void EchoCountStatus::clearEchoCount() {
    if (hasEchoCount()) {
         clear_has_echoCount();
        _echoCount = 0u;
     }
}

inline bool EchoCountStatus::hasEchoCount () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 EchoCountStatus::getEchoCount () const {
    return _echoCount;
}

inline void EchoCountStatus::setEchoCount (uint32 echoCount_) {
    set_has_echoCount();
    this->_echoCount = echoCount_;
}

inline void EchoCountStatus::set_has_echoCount () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoCountStatus::clear_has_echoCount () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EchoStart::EchoStart ()  :
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoStart::EchoStart (const EchoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _message ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoStart::EchoStart (const ::std::string& message_)  :
    _message (message_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoStart::~EchoStart() {
}

inline EchoStart& EchoStart::operator = (const EchoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool EchoStart::operator == (const EchoStart& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool EchoStart::operator != (const EchoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoStart::operator < (const EchoStart& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoStart::clone() {
    return new EchoStart(*this);
}

inline bool EchoStart::operator > (const EchoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoStart::clear() {
    clearMessage();
}

inline void EchoStart::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        _message.clear();
     }
}

inline bool EchoStart::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EchoStart::getMessage () const {
    return _message;
}

inline ::std::string& EchoStart::getMessageMutable () {
    set_has_message();
    return _message;
}

inline void EchoStart::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message = message_;
}

inline void EchoStart::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(message_);
}

inline void EchoStart::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    this->_message.assign(value, size);
}

inline void EchoStart::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoStart::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EchoResult::EchoResult ()  :
    _result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EchoResult::EchoResult (const EchoResult &rhs)  :
    ::asf::core::Payload(rhs),
    _result ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EchoResult::EchoResult (const ::std::string& result_)  :
    _result (result_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (result_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EchoResult::~EchoResult() {
}

inline EchoResult& EchoResult::operator = (const EchoResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
    }
    return *this;
}

inline bool EchoResult::operator == (const EchoResult& rhs) const {
    return (((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()));
}

inline bool EchoResult::operator != (const EchoResult& rhs) const {
    return ! (*this == rhs);
}

inline bool EchoResult::operator < (const EchoResult& rhs) const {
    if (hasResult() || rhs.hasResult()) {
        if (getResult() < rhs.getResult()) return true;
        if (getResult() > rhs.getResult()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EchoResult::clone() {
    return new EchoResult(*this);
}

inline bool EchoResult::operator > (const EchoResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EchoResult::clear() {
    clearResult();
}

inline void EchoResult::clearResult() {
    if (hasResult()) {
         clear_has_result();
        _result.clear();
     }
}

inline bool EchoResult::hasResult () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& EchoResult::getResult () const {
    return _result;
}

inline ::std::string& EchoResult::getResultMutable () {
    set_has_result();
    return _result;
}

inline void EchoResult::setResult (const ::std::string& result_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (result_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_result();
    this->_result = result_;
}

inline void EchoResult::setResult (const char* result_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (result_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_result();
    this->_result.assign(result_);
}

inline void EchoResult::setResult (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_result();
    this->_result.assign(value, size);
}

inline void EchoResult::set_has_result () {
    _has_bits_[0] |= 1u << 0;
}

inline void EchoResult::clear_has_result () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace EchoFI
} // namespace echoCca
} // namespace example

#endif // EXAMPLE_ECHOCCA_ECHOFI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
