/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGPROXY_H
#define ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/cm/diagnosis/dbus/Diaglog.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace diagnosis {
namespace dbus {
namespace Diaglog {

class DiaglogProxy;

class ClearDTCCallbackIF {
public:
    virtual ~ClearDTCCallbackIF() {}

    virtual void onClearDTCError(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCError >& error) = 0;

    virtual void onClearDTCResponse(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< ClearDTCResponse >& response) = 0;
};

class SaveTestResultCallbackIF {
public:
    virtual ~SaveTestResultCallbackIF() {}

    virtual void onSaveTestResultError(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< SaveTestResultError >& error) = 0;

    virtual void onSaveTestResultResponse(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< SaveTestResultResponse >& response) = 0;
};

class SendNextTestResultCallbackIF {
public:
    virtual ~SendNextTestResultCallbackIF() {}

    virtual void onSendNextTestResultError(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< SendNextTestResultError >& error) = 0;

    virtual void onSendNextTestResultSignal(const ::boost::shared_ptr< DiaglogProxy >& proxy, const ::boost::shared_ptr< SendNextTestResultSignal >& signal) = 0;
};


/**
 * DiaglogProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.cm.diagnosis.dbus.Diaglog' (specified in file
 * DiaglogInterfaceIntrospectionData.xml).
 *
 * Param 1: Type - Boolean: Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful. Status = true if client is required to send next test result to DiagLog.
 * Param 2: Type - T_e8_SendNextTestResReason: indicates the reason behind requesting the next test result: Either due a DTC Clearing or due to reset of the Blocking Mode of the DTC
 * Param 3: Type - array of ITCs: for these the next test result has to be sent. If the list is empty the client should report all the ITCs for which he is reponsible.
 */
class DiaglogProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DiaglogProxy.
     */
    static ::boost::shared_ptr< DiaglogProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DiaglogProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DiaglogProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DiaglogProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DiaglogProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DiaglogProxy > proxyNew(new DiaglogProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DiaglogProxy ();


    // Signal 'SendNextTestResult'

    /**
     * Notify on the signal 'SendNextTestResult'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SendNextTestResult'</b>:
     *
     * Contains the reasons for the signal and a list of Trouble Codes. Refer T_SendNextTestResultStructure.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendNextTestResultRegister(SendNextTestResultCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SendNextTestResult'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SendNextTestResult'</b>:
     *
     * Contains the reasons for the signal and a list of Trouble Codes. Refer T_SendNextTestResultStructure.
     *
     * @param act The act which was previously returned by the
     * sendSendNextTestResultRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSendNextTestResultDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SendNextTestResult'.
     */
    void sendSendNextTestResultDeregisterAll () const;



    // Method 'SaveTestResult'

    /**
     * Call the method 'SaveTestResult'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SaveTestResult'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param TestResultList If the meaning of "TestResultList" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveTestResultRequest(SaveTestResultCallbackIF& cb, const ::std::vector< SaveTestResultRequestTestResultListStruct >& testResultList) const;

    // Method 'ClearDTC'

    /**
     * Call the method 'ClearDTC'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ClearDTC'</b>:
     *
     * Indicates the validity of the method execution. Refer T_e8_MethodResultReply.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param Group If the meaning of "Group" isn't clear, then there should be a description here.
     *
     * @param DTCMask If the meaning of "DTCMask" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDTCRequest(ClearDTCCallbackIF& cb, uint8 group, uint32 dTCMask) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DiaglogProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DiaglogProxyCallback;
};

} // namespace Diaglog
} // namespace dbus
} // namespace diagnosis
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_DIAGNOSIS_DBUS_DIAGLOGPROXY_H
