/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/genivi/audiomanager/CommandInterface.h"
#include "org/genivi/audiomanager/CommandInterfaceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of ConnectRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::ConnectRequest& in, DBusMessageIter* out) {
    uint16 o0 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o0));
    uint16 o1 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o1));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::ConnectRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConnectResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::ConnectResponse& in, DBusMessageIter* out) {
    int16 o2 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o2));
    uint16 o3 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o3));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::ConnectResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisconnectRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::DisconnectRequest& in, DBusMessageIter* out) {
    uint16 o4 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o4));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::DisconnectRequest& out) {
    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DisconnectResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::DisconnectResponse& in, DBusMessageIter* out) {
    int16 o5 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o5));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::DisconnectResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetVolumeRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetVolumeRequest& in, DBusMessageIter* out) {
    uint16 o6 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o6));
    uint16 o7 = in.getMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o7));
    int16 o8 = in.getValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetVolumeRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 ModeValue;
        uint16 &ModeTmpValue = ModeValue;
        dbus_message_iter_get_basic(in, &ModeTmpValue);
        out.setMode(ModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 valueValue;
        int16 &valueTmpValue = valueValue;
        dbus_message_iter_get_basic(in, &valueTmpValue);
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetVolumeResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetVolumeResponse& in, DBusMessageIter* out) {
    int16 o9 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o9));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetVolumeResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeStepRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::VolumeStepRequest& in, DBusMessageIter* out) {
    uint16 o10 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o10));
    int16 o11 = in.getVolumeStep();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::VolumeStepRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 volumeStepValue;
        int16 &volumeStepTmpValue = volumeStepValue;
        dbus_message_iter_get_basic(in, &volumeStepTmpValue);
        out.setVolumeStep(volumeStepValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeStepResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::VolumeStepResponse& in, DBusMessageIter* out) {
    int16 o12 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::VolumeStepResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSinkMuteStateRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateRequest& in, DBusMessageIter* out) {
    uint16 o13 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o13));
    int16 o14 = in.getMuteState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o14));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 muteStateValue;
        int16 &muteStateTmpValue = muteStateValue;
        dbus_message_iter_get_basic(in, &muteStateTmpValue);
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSinkMuteStateResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateResponse& in, DBusMessageIter* out) {
    int16 o15 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o15));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSinkMuteStateResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequest& in, DBusMessageIter* out) {
    uint16 o16 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o16));
    {
        DBusMessageIter o17Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o17Struct));
        serializeDBus(in.getSoundProperty(), &o17Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o17Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct soundPropertyValue;
        {
            DBusMessageIter o18;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o18);

                    if (!deserializeDBus(&o18, soundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(soundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse& in, DBusMessageIter* out) {
    int16 o19 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o19));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequest& in, DBusMessageIter* out) {
    uint16 o20 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o20));
    {
        DBusMessageIter o21Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o21Struct));
        serializeDBus(in.getSoundProperty(), &o21Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o21Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct soundPropertyValue;
        {
            DBusMessageIter o22;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o22);

                    if (!deserializeDBus(&o22, soundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(soundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyResponse& in, DBusMessageIter* out) {
    int16 o23 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o23));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequest& in, DBusMessageIter* out) {
    {
        DBusMessageIter o24Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o24Struct));
        serializeDBus(in.getProperty(), &o24Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o24Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequest& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct propertyValue;
        {
            DBusMessageIter o25;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o25);

                    if (!deserializeDBus(&o25, propertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setProperty(propertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyResponse& in, DBusMessageIter* out) {
    int16 o26 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o26));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainConnectionsResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponse& in, DBusMessageIter* out) {
    int16 o27 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o27));
    DBusMessageIter o28ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qqqnn)", &o28ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >* o29 = &in.getListConnections();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >::const_iterator o30 = o29->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct >::const_iterator o31 = o29->begin(); o31 != o30; ++o31) {
        {
            DBusMessageIter o32Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o28ArrayIter, DBUS_TYPE_STRUCT, 0, &o32Struct));
            serializeDBus((*o31), &o32Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o28ArrayIter, &o32Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o28ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct > listConnectionsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o33ArrayIter;
            dbus_message_iter_recurse (in, &o33ArrayIter);

            if(dbus_message_iter_get_arg_type(&o33ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct o34;
                    {
                        DBusMessageIter o35;
                        char* signature = dbus_message_iter_get_signature(&o33ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o33ArrayIter)) {
                                dbus_message_iter_recurse (&o33ArrayIter, &o35);

                                if (!deserializeDBus(&o35, o34)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listConnectionsValue.push_back(o34);
                } while (dbus_message_iter_next(&o33ArrayIter));
            }
        }
        out.setListConnections(listConnectionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponse& in, DBusMessageIter* out) {
    int16 o36 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o36));
    DBusMessageIter o37ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qs(nn)nnq)", &o37ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >* o38 = &in.getListMainSinks();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >::const_iterator o39 = o38->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct >::const_iterator o40 = o38->begin(); o40 != o39; ++o40) {
        {
            DBusMessageIter o41Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o37ArrayIter, DBUS_TYPE_STRUCT, 0, &o41Struct));
            serializeDBus((*o40), &o41Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o37ArrayIter, &o41Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o37ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct > listMainSinksValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o42ArrayIter;
            dbus_message_iter_recurse (in, &o42ArrayIter);

            if(dbus_message_iter_get_arg_type(&o42ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct o43;
                    {
                        DBusMessageIter o44;
                        char* signature = dbus_message_iter_get_signature(&o42ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o42ArrayIter)) {
                                dbus_message_iter_recurse (&o42ArrayIter, &o44);

                                if (!deserializeDBus(&o44, o43)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listMainSinksValue.push_back(o43);
                } while (dbus_message_iter_next(&o42ArrayIter));
            }
        }
        out.setListMainSinks(listMainSinksValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponse& in, DBusMessageIter* out) {
    int16 o45 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o45));
    DBusMessageIter o46ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qs(nn)q)", &o46ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >* o47 = &in.getListMainSources();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >::const_iterator o48 = o47->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct >::const_iterator o49 = o47->begin(); o49 != o48; ++o49) {
        {
            DBusMessageIter o50Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o46ArrayIter, DBUS_TYPE_STRUCT, 0, &o50Struct));
            serializeDBus((*o49), &o50Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o46ArrayIter, &o50Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o46ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct > listMainSourcesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o51ArrayIter;
            dbus_message_iter_recurse (in, &o51ArrayIter);

            if(dbus_message_iter_get_arg_type(&o51ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct o52;
                    {
                        DBusMessageIter o53;
                        char* signature = dbus_message_iter_get_signature(&o51ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o51ArrayIter)) {
                                dbus_message_iter_recurse (&o51ArrayIter, &o53);

                                if (!deserializeDBus(&o53, o52)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listMainSourcesValue.push_back(o52);
                } while (dbus_message_iter_next(&o51ArrayIter));
            }
        }
        out.setListMainSources(listMainSourcesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesRequest& in, DBusMessageIter* out) {
    uint16 o54 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o54));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesRequest& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse& in, DBusMessageIter* out) {
    int16 o55 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o55));
    DBusMessageIter o56ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o56ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >* o57 = &in.getListSoundProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >::const_iterator o58 = o57->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct >::const_iterator o59 = o57->begin(); o59 != o58; ++o59) {
        {
            DBusMessageIter o60Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o56ArrayIter, DBUS_TYPE_STRUCT, 0, &o60Struct));
            serializeDBus((*o59), &o60Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o56ArrayIter, &o60Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o56ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct > listSoundPropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o61ArrayIter;
            dbus_message_iter_recurse (in, &o61ArrayIter);

            if(dbus_message_iter_get_arg_type(&o61ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct o62;
                    {
                        DBusMessageIter o63;
                        char* signature = dbus_message_iter_get_signature(&o61ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o61ArrayIter)) {
                                dbus_message_iter_recurse (&o61ArrayIter, &o63);

                                if (!deserializeDBus(&o63, o62)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSoundPropertiesValue.push_back(o62);
                } while (dbus_message_iter_next(&o61ArrayIter));
            }
        }
        out.setListSoundProperties(listSoundPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesRequest& in, DBusMessageIter* out) {
    uint16 o64 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o64));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesRequest& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponse& in, DBusMessageIter* out) {
    int16 o65 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o65));
    DBusMessageIter o66ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o66ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >* o67 = &in.getListSourceProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >::const_iterator o68 = o67->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct >::const_iterator o69 = o67->begin(); o69 != o68; ++o69) {
        {
            DBusMessageIter o70Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o66ArrayIter, DBUS_TYPE_STRUCT, 0, &o70Struct));
            serializeDBus((*o69), &o70Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o66ArrayIter, &o70Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o66ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct > listSourcePropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o71ArrayIter;
            dbus_message_iter_recurse (in, &o71ArrayIter);

            if(dbus_message_iter_get_arg_type(&o71ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct o72;
                    {
                        DBusMessageIter o73;
                        char* signature = dbus_message_iter_get_signature(&o71ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o71ArrayIter)) {
                                dbus_message_iter_recurse (&o71ArrayIter, &o73);

                                if (!deserializeDBus(&o73, o72)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSourcePropertiesValue.push_back(o72);
                } while (dbus_message_iter_next(&o71ArrayIter));
            }
        }
        out.setListSourceProperties(listSourcePropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponse& in, DBusMessageIter* out) {
    int16 o74 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o74));
    DBusMessageIter o75ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qsa(nn))", &o75ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >* o76 = &in.getListSourceClasses();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >::const_iterator o77 = o76->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct >::const_iterator o78 = o76->begin(); o78 != o77; ++o78) {
        {
            DBusMessageIter o79Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o75ArrayIter, DBUS_TYPE_STRUCT, 0, &o79Struct));
            serializeDBus((*o78), &o79Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o75ArrayIter, &o79Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o75ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct > listSourceClassesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o80ArrayIter;
            dbus_message_iter_recurse (in, &o80ArrayIter);

            if(dbus_message_iter_get_arg_type(&o80ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct o81;
                    {
                        DBusMessageIter o82;
                        char* signature = dbus_message_iter_get_signature(&o80ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o80ArrayIter)) {
                                dbus_message_iter_recurse (&o80ArrayIter, &o82);

                                if (!deserializeDBus(&o82, o81)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSourceClassesValue.push_back(o81);
                } while (dbus_message_iter_next(&o80ArrayIter));
            }
        }
        out.setListSourceClasses(listSourceClassesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponse& in, DBusMessageIter* out) {
    int16 o83 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o83));
    DBusMessageIter o84ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(qsa(nn))", &o84ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >* o85 = &in.getListSinkClasses();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >::const_iterator o86 = o85->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct >::const_iterator o87 = o85->begin(); o87 != o86; ++o87) {
        {
            DBusMessageIter o88Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o84ArrayIter, DBUS_TYPE_STRUCT, 0, &o88Struct));
            serializeDBus((*o87), &o88Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o84ArrayIter, &o88Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o84ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct > listSinkClassesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o89ArrayIter;
            dbus_message_iter_recurse (in, &o89ArrayIter);

            if(dbus_message_iter_get_arg_type(&o89ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct o90;
                    {
                        DBusMessageIter o91;
                        char* signature = dbus_message_iter_get_signature(&o89ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o89ArrayIter)) {
                                dbus_message_iter_recurse (&o89ArrayIter, &o91);

                                if (!deserializeDBus(&o91, o90)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSinkClassesValue.push_back(o90);
                } while (dbus_message_iter_next(&o89ArrayIter));
            }
        }
        out.setListSinkClasses(listSinkClassesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSystemPropertiesResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse& in, DBusMessageIter* out) {
    int16 o92 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o92));
    DBusMessageIter o93ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o93ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct >* o94 = &in.getListSystemProperties();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct >::const_iterator o95 = o94->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct >::const_iterator o96 = o94->begin(); o96 != o95; ++o96) {
        {
            DBusMessageIter o97Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o93ArrayIter, DBUS_TYPE_STRUCT, 0, &o97Struct));
            serializeDBus((*o96), &o97Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o93ArrayIter, &o97Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o93ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct > listSystemPropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o98ArrayIter;
            dbus_message_iter_recurse (in, &o98ArrayIter);

            if(dbus_message_iter_get_arg_type(&o98ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct o99;
                    {
                        DBusMessageIter o100;
                        char* signature = dbus_message_iter_get_signature(&o98ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o98ArrayIter)) {
                                dbus_message_iter_recurse (&o98ArrayIter, &o100);

                                if (!deserializeDBus(&o100, o99)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    listSystemPropertiesValue.push_back(o99);
                } while (dbus_message_iter_next(&o98ArrayIter));
            }
        }
        out.setListSystemProperties(listSystemPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTimingInformationRequest

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetTimingInformationRequest& in, DBusMessageIter* out) {
    uint16 o101 = in.getMainConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o101));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetTimingInformationRequest& out) {
    {
        uint16 mainConnectionIDValue;
        uint16 &mainConnectionIDTmpValue = mainConnectionIDValue;
        dbus_message_iter_get_basic(in, &mainConnectionIDTmpValue);
        out.setMainConnectionID(mainConnectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTimingInformationResponse

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetTimingInformationResponse& in, DBusMessageIter* out) {
    int16 o102 = in.getResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o102));
    int16 o103 = in.getDelay();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o103));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetTimingInformationResponse& out) {
    {
        int16 resultValue;
        int16 &resultTmpValue = resultValue;
        dbus_message_iter_get_basic(in, &resultTmpValue);
        out.setResult(resultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 delayValue;
        int16 &delayTmpValue = delayValue;
        dbus_message_iter_get_basic(in, &delayTmpValue);
        out.setDelay(delayValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o104Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o104Struct));
        serializeDBus(in.getNewSink(), &o104Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o104Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct newSinkValue;
        {
            DBusMessageIter o105;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o105);

                    if (!deserializeDBus(&o105, newSinkValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setNewSink(newSinkValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkRemovedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkRemovedSignal& in, DBusMessageIter* out) {
    uint16 o106 = in.getRemovedSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o106));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkRemovedSignal& out) {
    {
        uint16 removedSinkIDValue;
        uint16 &removedSinkIDTmpValue = removedSinkIDValue;
        dbus_message_iter_get_basic(in, &removedSinkIDTmpValue);
        out.setRemovedSinkID(removedSinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o107Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o107Struct));
        serializeDBus(in.getNewSource(), &o107Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o107Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct newSourceValue;
        {
            DBusMessageIter o108;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o108);

                    if (!deserializeDBus(&o108, newSourceValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setNewSource(newSourceValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceRemovedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceRemovedSignal& in, DBusMessageIter* out) {
    uint16 o109 = in.getRemovedSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o109));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceRemovedSignal& out) {
    {
        uint16 removedSourceIDValue;
        uint16 &removedSourceIDTmpValue = removedSourceIDValue;
        dbus_message_iter_get_basic(in, &removedSourceIDTmpValue);
        out.setRemovedSourceID(removedSourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NewMainConnectionSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::NewMainConnectionSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o110Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o110Struct));
        serializeDBus(in.getNewMainConnection(), &o110Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o110Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::NewMainConnectionSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::NewMainConnectionSignalNewMainConnectionStruct NewMainConnectionValue;
        {
            DBusMessageIter o111;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o111);

                    if (!deserializeDBus(&o111, NewMainConnectionValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setNewMainConnection(NewMainConnectionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemovedMainConnectionSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::RemovedMainConnectionSignal& in, DBusMessageIter* out) {
    uint16 o112 = in.getConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o112));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::RemovedMainConnectionSignal& out) {
    {
        uint16 connectionIDValue;
        uint16 &connectionIDTmpValue = connectionIDValue;
        dbus_message_iter_get_basic(in, &connectionIDTmpValue);
        out.setConnectionID(connectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainConnectionStateChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedSignal& in, DBusMessageIter* out) {
    uint16 o113 = in.getConnectionID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o113));
    int16 o114 = in.getConnectionState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o114));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainConnectionStateChangedSignal& out) {
    {
        uint16 connectionIDValue;
        uint16 &connectionIDTmpValue = connectionIDValue;
        dbus_message_iter_get_basic(in, &connectionIDTmpValue);
        out.setConnectionID(connectionIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 connectionStateValue;
        int16 &connectionStateTmpValue = connectionStateValue;
        dbus_message_iter_get_basic(in, &connectionStateTmpValue);
        out.setConnectionState(connectionStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSinkSoundPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal& in, DBusMessageIter* out) {
    uint16 o115 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o115));
    {
        DBusMessageIter o116Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o116Struct));
        serializeDBus(in.getSoundProperty(), &o116Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o116Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct SoundPropertyValue;
        {
            DBusMessageIter o117;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o117);

                    if (!deserializeDBus(&o117, SoundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(SoundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSourceSoundPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignal& in, DBusMessageIter* out) {
    uint16 o118 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o118));
    {
        DBusMessageIter o119Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o119Struct));
        serializeDBus(in.getSoundProperty(), &o119Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o119Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignal& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct SoundPropertyValue;
        {
            DBusMessageIter o120;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o120);

                    if (!deserializeDBus(&o120, SoundPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSoundProperty(SoundPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAvailabilityChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignal& in, DBusMessageIter* out) {
    uint16 o121 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o121));
    {
        DBusMessageIter o122Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o122Struct));
        serializeDBus(in.getAvailability(), &o122Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o122Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct availabilityValue;
        {
            DBusMessageIter o123;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o123);

                    if (!deserializeDBus(&o123, availabilityValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setAvailability(availabilityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAvailabilityChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignal& in, DBusMessageIter* out) {
    uint16 o124 = in.getSourceID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o124));
    {
        DBusMessageIter o125Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o125Struct));
        serializeDBus(in.getAvailability(), &o125Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o125Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignal& out) {
    {
        uint16 sourceIDValue;
        uint16 &sourceIDTmpValue = sourceIDValue;
        dbus_message_iter_get_basic(in, &sourceIDTmpValue);
        out.setSourceID(sourceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct availabilityValue;
        {
            DBusMessageIter o126;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o126);

                    if (!deserializeDBus(&o126, availabilityValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setAvailability(availabilityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VolumeChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::VolumeChangedSignal& in, DBusMessageIter* out) {
    uint16 o127 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o127));
    int16 o128 = in.getVolume();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o128));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::VolumeChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 volumeValue;
        int16 &volumeTmpValue = volumeValue;
        dbus_message_iter_get_basic(in, &volumeTmpValue);
        out.setVolume(volumeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkMuteStateChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedSignal& in, DBusMessageIter* out) {
    uint16 o129 = in.getSinkID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o129));
    int16 o130 = in.getMuteState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o130));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkMuteStateChangedSignal& out) {
    {
        uint16 sinkIDValue;
        uint16 &sinkIDTmpValue = sinkIDValue;
        dbus_message_iter_get_basic(in, &sinkIDTmpValue);
        out.setSinkID(sinkIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 muteStateValue;
        int16 &muteStateTmpValue = muteStateValue;
        dbus_message_iter_get_basic(in, &muteStateTmpValue);
        out.setMuteState(muteStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignal& in, DBusMessageIter* out) {
    {
        DBusMessageIter o131Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o131Struct));
        serializeDBus(in.getSystemProperty(), &o131Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o131Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignal& out) {
    {
        ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct SystemPropertyValue;
        {
            DBusMessageIter o132;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o132);

                    if (!deserializeDBus(&o132, SystemPropertyValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setSystemProperty(SystemPropertyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TimingInformationChangedSignal

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::TimingInformationChangedSignal& in, DBusMessageIter* out) {
    uint16 o133 = in.getMainConnection();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o133));
    int16 o134 = in.getTime();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o134));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::TimingInformationChangedSignal& out) {
    {
        uint16 mainConnectionValue;
        uint16 &mainConnectionTmpValue = mainConnectionValue;
        dbus_message_iter_get_basic(in, &mainConnectionTmpValue);
        out.setMainConnection(mainConnectionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 timeValue;
        int16 &timeTmpValue = timeValue;
        dbus_message_iter_get_basic(in, &timeTmpValue);
        out.setTime(timeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSinkSoundPropertyRequestSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o135 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o135));
    int16 o136 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o136));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSinkSoundPropertyRequestSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMainSourceSoundPropertyRequestSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o137 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o137));
    int16 o138 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o138));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetMainSourceSoundPropertyRequestSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSystemPropertyRequestPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct& in, DBusMessageIter* out) {
    int16 o139 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o139));
    int16 o140 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o140));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SetSystemPropertyRequestPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainConnectionsResponseListConnectionsStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct& in, DBusMessageIter* out) {
    uint16 o141 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o141));
    uint16 o142 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o142));
    uint16 o143 = in.getElem3();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o143));
    int16 o144 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o144));
    int16 o145 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o145));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainConnectionsResponseListConnectionsStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem2Value;
        uint16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem3Value;
        uint16 &elem3TmpValue = elem3Value;
        dbus_message_iter_get_basic(in, &elem3TmpValue);
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponseListMainSinksElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct& in, DBusMessageIter* out) {
    int16 o146 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o146));
    int16 o147 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o147));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinksResponseListMainSinksStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct& in, DBusMessageIter* out) {
    uint16 o148 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o148));
    const char* o149 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o149));
    {
        DBusMessageIter o150Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o150Struct));
        serializeDBus(in.getElem3(), &o150Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o150Struct));
    }
    int16 o151 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o151));
    int16 o152 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o152));
    uint16 o153 = in.getElem6();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o153));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o154 = 0;
            dbus_message_iter_get_basic(in, &o154);
            elem2TmpValue.assign (o154);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::GetListMainSinksResponseListMainSinksElem3Struct elem3Value;
        {
            DBusMessageIter o155;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o155);

                    if (!deserializeDBus(&o155, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem6Value;
        uint16 &elem6TmpValue = elem6Value;
        dbus_message_iter_get_basic(in, &elem6TmpValue);
        out.setElem6(elem6Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponseListMainSourcesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct& in, DBusMessageIter* out) {
    int16 o156 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o156));
    int16 o157 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o157));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourcesResponseListMainSourcesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct& in, DBusMessageIter* out) {
    uint16 o158 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o158));
    const char* o159 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o159));
    {
        DBusMessageIter o160Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o160Struct));
        serializeDBus(in.getElem3(), &o160Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o160Struct));
    }
    uint16 o161 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o161));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o162 = 0;
            dbus_message_iter_get_basic(in, &o162);
            elem2TmpValue.assign (o162);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::GetListMainSourcesResponseListMainSourcesElem3Struct elem3Value;
        {
            DBusMessageIter o163;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o163);

                    if (!deserializeDBus(&o163, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem4Value;
        uint16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& in, DBusMessageIter* out) {
    int16 o164 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o164));
    int16 o165 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o165));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSinkSoundPropertiesResponseListSoundPropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& in, DBusMessageIter* out) {
    int16 o166 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o166));
    int16 o167 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o167));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListMainSourceSoundPropertiesResponseListSourcePropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponseListSourceClassesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct& in, DBusMessageIter* out) {
    int16 o168 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o168));
    int16 o169 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o169));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSourceClassesResponseListSourceClassesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct& in, DBusMessageIter* out) {
    uint16 o170 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o170));
    const char* o171 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o171));
    DBusMessageIter o172ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o172ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >* o173 = &in.getElem3();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >::const_iterator o174 = o173->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct >::const_iterator o175 = o173->begin(); o175 != o174; ++o175) {
        {
            DBusMessageIter o176Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o172ArrayIter, DBUS_TYPE_STRUCT, 0, &o176Struct));
            serializeDBus((*o175), &o176Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o172ArrayIter, &o176Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o172ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o177 = 0;
            dbus_message_iter_get_basic(in, &o177);
            elem2TmpValue.assign (o177);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct > elem3Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o178ArrayIter;
            dbus_message_iter_recurse (in, &o178ArrayIter);

            if(dbus_message_iter_get_arg_type(&o178ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSourceClassesResponseListSourceClassesElem3Struct o179;
                    {
                        DBusMessageIter o180;
                        char* signature = dbus_message_iter_get_signature(&o178ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o178ArrayIter)) {
                                dbus_message_iter_recurse (&o178ArrayIter, &o180);

                                if (!deserializeDBus(&o180, o179)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem3Value.push_back(o179);
                } while (dbus_message_iter_next(&o178ArrayIter));
            }
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponseListSinkClassesElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct& in, DBusMessageIter* out) {
    int16 o181 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o181));
    int16 o182 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o182));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSinkClassesResponseListSinkClassesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct& in, DBusMessageIter* out) {
    uint16 o183 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o183));
    const char* o184 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o184));
    DBusMessageIter o185ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(nn)", &o185ArrayIter));
    const ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >* o186 = &in.getElem3();
    ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >::const_iterator o187 = o186->end();
    for (::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct >::const_iterator o188 = o186->begin(); o188 != o187; ++o188) {
        {
            DBusMessageIter o189Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o185ArrayIter, DBUS_TYPE_STRUCT, 0, &o189Struct));
            serializeDBus((*o188), &o189Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o185ArrayIter, &o189Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o185ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o190 = 0;
            dbus_message_iter_get_basic(in, &o190);
            elem2TmpValue.assign (o190);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct > elem3Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o191ArrayIter;
            dbus_message_iter_recurse (in, &o191ArrayIter);

            if(dbus_message_iter_get_arg_type(&o191ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::genivi::audiomanager::CommandInterface::GetListSinkClassesResponseListSinkClassesElem3Struct o192;
                    {
                        DBusMessageIter o193;
                        char* signature = dbus_message_iter_get_signature(&o191ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o191ArrayIter)) {
                                dbus_message_iter_recurse (&o191ArrayIter, &o193);

                                if (!deserializeDBus(&o193, o192)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem3Value.push_back(o192);
                } while (dbus_message_iter_next(&o191ArrayIter));
            }
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetListSystemPropertiesResponseListSystemPropertiesStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct& in, DBusMessageIter* out) {
    int16 o194 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o194));
    int16 o195 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o195));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponseListSystemPropertiesStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignalNewSinkElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct& in, DBusMessageIter* out) {
    int16 o196 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o196));
    int16 o197 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o197));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAddedSignalNewSinkStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct& in, DBusMessageIter* out) {
    uint16 o198 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o198));
    const char* o199 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o199));
    {
        DBusMessageIter o200Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o200Struct));
        serializeDBus(in.getElem3(), &o200Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o200Struct));
    }
    int16 o201 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o201));
    int16 o202 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o202));
    uint16 o203 = in.getElem6();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o203));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o204 = 0;
            dbus_message_iter_get_basic(in, &o204);
            elem2TmpValue.assign (o204);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SinkAddedSignalNewSinkElem3Struct elem3Value;
        {
            DBusMessageIter o205;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o205);

                    if (!deserializeDBus(&o205, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem6Value;
        uint16 &elem6TmpValue = elem6Value;
        dbus_message_iter_get_basic(in, &elem6TmpValue);
        out.setElem6(elem6Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignalNewSourceElem3Struct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct& in, DBusMessageIter* out) {
    int16 o206 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o206));
    int16 o207 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o207));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAddedSignalNewSourceStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct& in, DBusMessageIter* out) {
    uint16 o208 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o208));
    const char* o209 = in.getElem2().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o209));
    {
        DBusMessageIter o210Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o210Struct));
        serializeDBus(in.getElem3(), &o210Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o210Struct));
    }
    uint16 o211 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o211));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string elem2Value;
        ::std::string &elem2TmpValue = elem2Value;
        {
            char* o212 = 0;
            dbus_message_iter_get_basic(in, &o212);
            elem2TmpValue.assign (o212);
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::genivi::audiomanager::CommandInterface::SourceAddedSignalNewSourceElem3Struct elem3Value;
        {
            DBusMessageIter o213;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o213);

                    if (!deserializeDBus(&o213, elem3Value)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem4Value;
        uint16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NewMainConnectionSignalNewMainConnectionStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::NewMainConnectionSignalNewMainConnectionStruct& in, DBusMessageIter* out) {
    uint16 o214 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o214));
    uint16 o215 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o215));
    uint16 o216 = in.getElem3();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o216));
    int16 o217 = in.getElem4();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o217));
    int16 o218 = in.getElem5();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o218));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::NewMainConnectionSignalNewMainConnectionStruct& out) {
    {
        uint16 elem1Value;
        uint16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem2Value;
        uint16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 elem3Value;
        uint16 &elem3TmpValue = elem3Value;
        dbus_message_iter_get_basic(in, &elem3TmpValue);
        out.setElem3(elem3Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem4Value;
        int16 &elem4TmpValue = elem4Value;
        dbus_message_iter_get_basic(in, &elem4TmpValue);
        out.setElem4(elem4Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem5Value;
        int16 &elem5TmpValue = elem5Value;
        dbus_message_iter_get_basic(in, &elem5TmpValue);
        out.setElem5(elem5Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSinkSoundPropertyChangedSignalSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o219 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o219));
    int16 o220 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o220));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSinkSoundPropertyChangedSignalSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MainSourceSoundPropertyChangedSignalSoundPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct& in, DBusMessageIter* out) {
    int16 o221 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o221));
    int16 o222 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o222));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::MainSourceSoundPropertyChangedSignalSoundPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SinkAvailabilityChangedSignalAvailabilityStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct& in, DBusMessageIter* out) {
    int16 o223 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o223));
    int16 o224 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o224));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SinkAvailabilityChangedSignalAvailabilityStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SourceAvailabilityChangedSignalAvailabilityStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct& in, DBusMessageIter* out) {
    int16 o225 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o225));
    int16 o226 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o226));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SourceAvailabilityChangedSignalAvailabilityStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SystemPropertyChangedSignalSystemPropertyStruct

void serializeDBus (const ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct& in, DBusMessageIter* out) {
    int16 o227 = in.getElem1();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o227));
    int16 o228 = in.getElem2();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o228));
}

bool deserializeDBus (DBusMessageIter* in, ::org::genivi::audiomanager::CommandInterface::SystemPropertyChangedSignalSystemPropertyStruct& out) {
    {
        int16 elem1Value;
        int16 &elem1TmpValue = elem1Value;
        dbus_message_iter_get_basic(in, &elem1TmpValue);
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 elem2Value;
        int16 &elem2TmpValue = elem2Value;
        dbus_message_iter_get_basic(in, &elem2TmpValue);
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

