#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLREGULATORYTYPES_H
#define ORG_BOSCH_WBLREGULATORYTYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "WBLRegulatoryTypes" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace WBLRegulatoryTypes {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class WifiChannel;

class NetworkInterface;

class WifiRadio;

class RegulatoryUpdate;


/**
 * If the meaning of "WifiChannel" isn't clear, then there should be a description here.
 */
class WifiChannel {
public:

    /**
     * Default constructor
     */
    inline  WifiChannel ();

    /**
     * Copy constructor
     */
    inline  WifiChannel (const WifiChannel &rhs);

    /**
     * All fields constructor
     */
    inline  WifiChannel (uint16 channel_, uint16 frequency_, uint32 flags_);

    /**
     * Destructor
     */
    inline  ~WifiChannel();

    /**
     * Assignment operator
     */
    inline WifiChannel& operator = (const WifiChannel& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiChannel& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiChannel& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiChannel& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiChannel& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "channel"

    static const int kChannel = 0;

    /**
     * Clears the field "channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "channel".
     *
     * If the meaning of "channel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channel"
     */
    inline uint16 getChannel () const;

    /**
     * Sets the value of the member "channel".
     *
     * If the meaning of "channel" isn't clear, then there should be a description here.
     *
     * @param channel The value which will be set
     */
    inline void setChannel (uint16 channel_);

    // API of field "frequency"

    static const int kFrequency = 1;

    /**
     * Clears the field "frequency".
     *
     * The field will be set to its default value. The hasFrequency()
     * method will return false.
     */
    inline void clearFrequency();

    /**
     * Checks whether the field "frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequency()). Otherwise it will return false.
     */
    inline bool hasFrequency () const;

    /**
     * Returns the value of the member "frequency".
     *
     * If the meaning of "frequency" isn't clear, then there should be a description here.
     *
     * @return The value of the field "frequency"
     */
    inline uint16 getFrequency () const;

    /**
     * Sets the value of the member "frequency".
     *
     * If the meaning of "frequency" isn't clear, then there should be a description here.
     *
     * @param frequency The value which will be set
     */
    inline void setFrequency (uint16 frequency_);

    // API of field "flags"

    static const int kFlags = 2;

    /**
     * Clears the field "flags".
     *
     * The field will be set to its default value. The hasFlags()
     * method will return false.
     */
    inline void clearFlags();

    /**
     * Checks whether the field "flags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFlags()). Otherwise it will return false.
     */
    inline bool hasFlags () const;

    /**
     * Returns the value of the member "flags".
     *
     * If the meaning of "flags" isn't clear, then there should be a description here.
     *
     * @return The value of the field "flags"
     */
    inline uint32 getFlags () const;

    /**
     * Sets the value of the member "flags".
     *
     * If the meaning of "flags" isn't clear, then there should be a description here.
     *
     * @param flags The value which will be set
     */
    inline void setFlags (uint32 flags_);

    static const WifiChannel &getDefaultInstance();

private:

    inline void set_has_channel ();

    inline void clear_has_channel ();

    inline void set_has_frequency ();

    inline void clear_has_frequency ();

    inline void set_has_flags ();

    inline void clear_has_flags ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _channel;

    uint16 _frequency;

    uint32 _flags;

};

/**
 * If the meaning of "NetworkInterface" isn't clear, then there should be a description here.
 */
class NetworkInterface {
public:

    /**
     * Default constructor
     */
    inline  NetworkInterface ();

    /**
     * Copy constructor
     */
    inline  NetworkInterface (const NetworkInterface &rhs);

    /**
     * All fields constructor
     */
    inline  NetworkInterface (uint32 index_, const ::std::string& macaddress_, const ::std::string& ifname_);

    /**
     * Destructor
     */
    inline  ~NetworkInterface();

    /**
     * Assignment operator
     */
    inline NetworkInterface& operator = (const NetworkInterface& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NetworkInterface& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NetworkInterface& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NetworkInterface& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NetworkInterface& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "index"

    static const int kIndex = 0;

    /**
     * Clears the field "index".
     *
     * The field will be set to its default value. The hasIndex()
     * method will return false.
     */
    inline void clearIndex();

    /**
     * Checks whether the field "index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIndex()). Otherwise it will return false.
     */
    inline bool hasIndex () const;

    /**
     * Returns the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "index"
     */
    inline uint32 getIndex () const;

    /**
     * Sets the value of the member "index".
     *
     * If the meaning of "index" isn't clear, then there should be a description here.
     *
     * @param index The value which will be set
     */
    inline void setIndex (uint32 index_);

    // API of field "macaddress"

    static const int kMacaddress = 1;

    /**
     * Clears the field "macaddress".
     *
     * The field will be set to its default value. The hasMacaddress()
     * method will return false.
     */
    inline void clearMacaddress();

    /**
     * Checks whether the field "macaddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMacaddress()). Otherwise it will return false.
     */
    inline bool hasMacaddress () const;

    /**
     * Returns the value of the member "macaddress".
     *
     * If the meaning of "macaddress" isn't clear, then there should be a description here.
     *
     * @return The value of the field "macaddress"
     */
    inline const ::std::string& getMacaddress () const;

    /**
     * Retrieves the value of the field "macaddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "macaddress".
     */
    inline ::std::string& getMacaddressMutable ();

    /**
     * Sets the value of the member "macaddress".
     *
     * If the meaning of "macaddress" isn't clear, then there should be a description here.
     *
     * @param macaddress The value which will be set
     */
    inline void setMacaddress (const ::std::string& macaddress_);

    /**
     * Sets the value of the member "macaddress".
     *
     * If the meaning of "macaddress" isn't clear, then there should be a description here.
     *
     * @param macaddress The value which will be set
     */
    inline void setMacaddress (const char* macaddress_);

    /**
     * Sets the value of the member "macaddress".
     *
     * If the meaning of "macaddress" isn't clear, then there should be a description here.
     *
     * @param macaddress The value which will be set
     */
    inline void setMacaddress (const char* value, size_t size);

    /**
     * Release the object stored in the field "macaddress".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "macaddress"
     */
    inline ::std::string* releaseMacaddress();

    /**
     * Replace the field "macaddress".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMacaddress (::std::string* macaddress_);

    // API of field "ifname"

    static const int kIfname = 2;

    /**
     * Clears the field "ifname".
     *
     * The field will be set to its default value. The hasIfname()
     * method will return false.
     */
    inline void clearIfname();

    /**
     * Checks whether the field "ifname" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIfname()). Otherwise it will return false.
     */
    inline bool hasIfname () const;

    /**
     * Returns the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ifname"
     */
    inline const ::std::string& getIfname () const;

    /**
     * Retrieves the value of the field "ifname" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ifname".
     */
    inline ::std::string& getIfnameMutable ();

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const ::std::string& ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* ifname_);

    /**
     * Sets the value of the member "ifname".
     *
     * If the meaning of "ifname" isn't clear, then there should be a description here.
     *
     * @param ifname The value which will be set
     */
    inline void setIfname (const char* value, size_t size);

    /**
     * Release the object stored in the field "ifname".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ifname"
     */
    inline ::std::string* releaseIfname();

    /**
     * Replace the field "ifname".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceIfname (::std::string* ifname_);

    static const NetworkInterface &getDefaultInstance();

private:

    inline void set_has_index ();

    inline void clear_has_index ();

    inline void set_has_macaddress ();

    inline void clear_has_macaddress ();

    inline void set_has_ifname ();

    inline void clear_has_ifname ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _index;

    ::std::string* _macaddress;

    ::std::string* _ifname;

};

/**
 * If the meaning of "WifiRadio" isn't clear, then there should be a description here.
 */
class WifiRadio {
public:

    /**
     * Default constructor
     */
    inline  WifiRadio ();

    /**
     * Copy constructor
     */
    inline  WifiRadio (const WifiRadio &rhs);

    /**
     * All fields constructor
     */
    inline  WifiRadio (const ::std::string& radio_, const ::std::string& regDomain_, uint8 initiator_, uint8 regtype_, int32 selfManaged_, int32 ieee80211index_, const ::boost::ptr_vector< NetworkInterface >& netdevices_, const ::boost::ptr_vector< WifiChannel >& channelsinfo_);

    /**
     * Destructor
     */
    inline  ~WifiRadio();

    /**
     * Assignment operator
     */
    inline WifiRadio& operator = (const WifiRadio& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiRadio& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiRadio& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiRadio& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiRadio& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "radio"

    static const int kRadio = 0;

    /**
     * Clears the field "radio".
     *
     * The field will be set to its default value. The hasRadio()
     * method will return false.
     */
    inline void clearRadio();

    /**
     * Checks whether the field "radio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadio()). Otherwise it will return false.
     */
    inline bool hasRadio () const;

    /**
     * Returns the value of the member "radio".
     *
     * If the meaning of "radio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "radio"
     */
    inline const ::std::string& getRadio () const;

    /**
     * Retrieves the value of the field "radio" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "radio".
     */
    inline ::std::string& getRadioMutable ();

    /**
     * Sets the value of the member "radio".
     *
     * If the meaning of "radio" isn't clear, then there should be a description here.
     *
     * @param radio The value which will be set
     */
    inline void setRadio (const ::std::string& radio_);

    /**
     * Sets the value of the member "radio".
     *
     * If the meaning of "radio" isn't clear, then there should be a description here.
     *
     * @param radio The value which will be set
     */
    inline void setRadio (const char* radio_);

    /**
     * Sets the value of the member "radio".
     *
     * If the meaning of "radio" isn't clear, then there should be a description here.
     *
     * @param radio The value which will be set
     */
    inline void setRadio (const char* value, size_t size);

    /**
     * Release the object stored in the field "radio".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "radio"
     */
    inline ::std::string* releaseRadio();

    /**
     * Replace the field "radio".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceRadio (::std::string* radio_);

    // API of field "regDomain"

    static const int kRegDomain = 1;

    /**
     * Clears the field "regDomain".
     *
     * The field will be set to its default value. The hasRegDomain()
     * method will return false.
     */
    inline void clearRegDomain();

    /**
     * Checks whether the field "regDomain" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegDomain()). Otherwise it will return false.
     */
    inline bool hasRegDomain () const;

    /**
     * Returns the value of the member "regDomain".
     *
     * If the meaning of "regDomain" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regDomain"
     */
    inline const ::std::string& getRegDomain () const;

    /**
     * Retrieves the value of the field "regDomain" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "regDomain".
     */
    inline ::std::string& getRegDomainMutable ();

    /**
     * Sets the value of the member "regDomain".
     *
     * If the meaning of "regDomain" isn't clear, then there should be a description here.
     *
     * @param regDomain The value which will be set
     */
    inline void setRegDomain (const ::std::string& regDomain_);

    /**
     * Sets the value of the member "regDomain".
     *
     * If the meaning of "regDomain" isn't clear, then there should be a description here.
     *
     * @param regDomain The value which will be set
     */
    inline void setRegDomain (const char* regDomain_);

    /**
     * Sets the value of the member "regDomain".
     *
     * If the meaning of "regDomain" isn't clear, then there should be a description here.
     *
     * @param regDomain The value which will be set
     */
    inline void setRegDomain (const char* value, size_t size);

    /**
     * Release the object stored in the field "regDomain".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "regDomain"
     */
    inline ::std::string* releaseRegDomain();

    /**
     * Replace the field "regDomain".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceRegDomain (::std::string* regDomain_);

    // API of field "initiator"

    static const int kInitiator = 2;

    /**
     * Clears the field "initiator".
     *
     * The field will be set to its default value. The hasInitiator()
     * method will return false.
     */
    inline void clearInitiator();

    /**
     * Checks whether the field "initiator" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInitiator()). Otherwise it will return false.
     */
    inline bool hasInitiator () const;

    /**
     * Returns the value of the member "initiator".
     *
     * If the meaning of "initiator" isn't clear, then there should be a description here.
     *
     * @return The value of the field "initiator"
     */
    inline uint8 getInitiator () const;

    /**
     * Sets the value of the member "initiator".
     *
     * If the meaning of "initiator" isn't clear, then there should be a description here.
     *
     * @param initiator The value which will be set
     */
    inline void setInitiator (uint8 initiator_);

    // API of field "regtype"

    static const int kRegtype = 3;

    /**
     * Clears the field "regtype".
     *
     * The field will be set to its default value. The hasRegtype()
     * method will return false.
     */
    inline void clearRegtype();

    /**
     * Checks whether the field "regtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegtype()). Otherwise it will return false.
     */
    inline bool hasRegtype () const;

    /**
     * Returns the value of the member "regtype".
     *
     * If the meaning of "regtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regtype"
     */
    inline uint8 getRegtype () const;

    /**
     * Sets the value of the member "regtype".
     *
     * If the meaning of "regtype" isn't clear, then there should be a description here.
     *
     * @param regtype The value which will be set
     */
    inline void setRegtype (uint8 regtype_);

    // API of field "selfManaged"

    static const int kSelfManaged = 4;

    /**
     * Clears the field "selfManaged".
     *
     * The field will be set to its default value. The hasSelfManaged()
     * method will return false.
     */
    inline void clearSelfManaged();

    /**
     * Checks whether the field "selfManaged" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelfManaged()). Otherwise it will return false.
     */
    inline bool hasSelfManaged () const;

    /**
     * Returns the value of the member "selfManaged".
     *
     * If the meaning of "selfManaged" isn't clear, then there should be a description here.
     *
     * @return The value of the field "selfManaged"
     */
    inline int32 getSelfManaged () const;

    /**
     * Sets the value of the member "selfManaged".
     *
     * If the meaning of "selfManaged" isn't clear, then there should be a description here.
     *
     * @param selfManaged The value which will be set
     */
    inline void setSelfManaged (int32 selfManaged_);

    // API of field "ieee80211index"

    static const int kIeee80211index = 5;

    /**
     * Clears the field "ieee80211index".
     *
     * The field will be set to its default value. The hasIeee80211index()
     * method will return false.
     */
    inline void clearIeee80211index();

    /**
     * Checks whether the field "ieee80211index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIeee80211index()). Otherwise it will return false.
     */
    inline bool hasIeee80211index () const;

    /**
     * Returns the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ieee80211index"
     */
    inline int32 getIeee80211index () const;

    /**
     * Sets the value of the member "ieee80211index".
     *
     * If the meaning of "ieee80211index" isn't clear, then there should be a description here.
     *
     * @param ieee80211index The value which will be set
     */
    inline void setIeee80211index (int32 ieee80211index_);

    // API of field "netdevices"

    static const int kNetdevices = 6;

    /**
     * Clears the field "netdevices".
     *
     * The field will be set to its default value. The hasNetdevices()
     * method will return false.
     */
    inline void clearNetdevices();

    /**
     * Checks whether the field "netdevices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNetdevices()). Otherwise it will return false.
     */
    inline bool hasNetdevices () const;

    /**
     * Returns the value of the member "netdevices".
     *
     * If the meaning of "netdevices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "netdevices"
     */
    inline const ::boost::ptr_vector< NetworkInterface >& getNetdevices () const;

    /**
     * Retrieves the value of the field "netdevices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "netdevices".
     */
    inline ::boost::ptr_vector< NetworkInterface >& getNetdevicesMutable ();

    /**
     * Sets the value of the member "netdevices".
     *
     * If the meaning of "netdevices" isn't clear, then there should be a description here.
     *
     * @param netdevices The value which will be set
     */
    inline void setNetdevices (const ::boost::ptr_vector< NetworkInterface >& netdevices_);

    /**
     * Release the object stored in the field "netdevices".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "netdevices"
     */
    inline ::boost::ptr_vector< NetworkInterface >* releaseNetdevices();

    /**
     * Replace the field "netdevices".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceNetdevices (::boost::ptr_vector< NetworkInterface >* netdevices_);

    // API of field "channelsinfo"

    static const int kChannelsinfo = 7;

    /**
     * Clears the field "channelsinfo".
     *
     * The field will be set to its default value. The hasChannelsinfo()
     * method will return false.
     */
    inline void clearChannelsinfo();

    /**
     * Checks whether the field "channelsinfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelsinfo()). Otherwise it will return false.
     */
    inline bool hasChannelsinfo () const;

    /**
     * Returns the value of the member "channelsinfo".
     *
     * If the meaning of "channelsinfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "channelsinfo"
     */
    inline const ::boost::ptr_vector< WifiChannel >& getChannelsinfo () const;

    /**
     * Retrieves the value of the field "channelsinfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "channelsinfo".
     */
    inline ::boost::ptr_vector< WifiChannel >& getChannelsinfoMutable ();

    /**
     * Sets the value of the member "channelsinfo".
     *
     * If the meaning of "channelsinfo" isn't clear, then there should be a description here.
     *
     * @param channelsinfo The value which will be set
     */
    inline void setChannelsinfo (const ::boost::ptr_vector< WifiChannel >& channelsinfo_);

    /**
     * Release the object stored in the field "channelsinfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "channelsinfo"
     */
    inline ::boost::ptr_vector< WifiChannel >* releaseChannelsinfo();

    /**
     * Replace the field "channelsinfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceChannelsinfo (::boost::ptr_vector< WifiChannel >* channelsinfo_);

    static const WifiRadio &getDefaultInstance();

private:

    static const ::boost::ptr_vector< NetworkInterface >& getNetworkInterfacePointerList_DefaultInstance ();

    static const ::boost::ptr_vector< WifiChannel >& getWifiChannelPointerList_DefaultInstance ();

    inline void set_has_radio ();

    inline void clear_has_radio ();

    inline void set_has_regDomain ();

    inline void clear_has_regDomain ();

    inline void set_has_initiator ();

    inline void clear_has_initiator ();

    inline void set_has_regtype ();

    inline void clear_has_regtype ();

    inline void set_has_selfManaged ();

    inline void clear_has_selfManaged ();

    inline void set_has_ieee80211index ();

    inline void clear_has_ieee80211index ();

    inline void set_has_netdevices ();

    inline void clear_has_netdevices ();

    inline void set_has_channelsinfo ();

    inline void clear_has_channelsinfo ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string* _radio;

    ::std::string* _regDomain;

    uint8 _initiator;

    uint8 _regtype;

    int32 _selfManaged;

    int32 _ieee80211index;

    ::boost::ptr_vector< NetworkInterface >* _netdevices;

    ::boost::ptr_vector< WifiChannel >* _channelsinfo;

};

/**
 * If the meaning of "RegulatoryUpdate" isn't clear, then there should be a description here.
 */
class RegulatoryUpdate {
public:

    /**
     * Default constructor
     */
    inline  RegulatoryUpdate ();

    /**
     * Copy constructor
     */
    inline  RegulatoryUpdate (const RegulatoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RegulatoryUpdate (uint8 initiator_, uint8 regtype_, uint8 global_, const ::std::string& country_, const ::boost::ptr_vector< WifiRadio >& radios_);

    /**
     * Destructor
     */
    inline  ~RegulatoryUpdate();

    /**
     * Assignment operator
     */
    inline RegulatoryUpdate& operator = (const RegulatoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RegulatoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RegulatoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RegulatoryUpdate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RegulatoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "initiator"

    static const int kInitiator = 0;

    /**
     * Clears the field "initiator".
     *
     * The field will be set to its default value. The hasInitiator()
     * method will return false.
     */
    inline void clearInitiator();

    /**
     * Checks whether the field "initiator" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInitiator()). Otherwise it will return false.
     */
    inline bool hasInitiator () const;

    /**
     * Returns the value of the member "initiator".
     *
     * If the meaning of "initiator" isn't clear, then there should be a description here.
     *
     * @return The value of the field "initiator"
     */
    inline uint8 getInitiator () const;

    /**
     * Sets the value of the member "initiator".
     *
     * If the meaning of "initiator" isn't clear, then there should be a description here.
     *
     * @param initiator The value which will be set
     */
    inline void setInitiator (uint8 initiator_);

    // API of field "regtype"

    static const int kRegtype = 1;

    /**
     * Clears the field "regtype".
     *
     * The field will be set to its default value. The hasRegtype()
     * method will return false.
     */
    inline void clearRegtype();

    /**
     * Checks whether the field "regtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegtype()). Otherwise it will return false.
     */
    inline bool hasRegtype () const;

    /**
     * Returns the value of the member "regtype".
     *
     * If the meaning of "regtype" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regtype"
     */
    inline uint8 getRegtype () const;

    /**
     * Sets the value of the member "regtype".
     *
     * If the meaning of "regtype" isn't clear, then there should be a description here.
     *
     * @param regtype The value which will be set
     */
    inline void setRegtype (uint8 regtype_);

    // API of field "global"

    static const int kGlobal = 2;

    /**
     * Clears the field "global".
     *
     * The field will be set to its default value. The hasGlobal()
     * method will return false.
     */
    inline void clearGlobal();

    /**
     * Checks whether the field "global" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGlobal()). Otherwise it will return false.
     */
    inline bool hasGlobal () const;

    /**
     * Returns the value of the member "global".
     *
     * If the meaning of "global" isn't clear, then there should be a description here.
     *
     * @return The value of the field "global"
     */
    inline uint8 getGlobal () const;

    /**
     * Sets the value of the member "global".
     *
     * If the meaning of "global" isn't clear, then there should be a description here.
     *
     * @param global The value which will be set
     */
    inline void setGlobal (uint8 global_);

    // API of field "country"

    static const int kCountry = 3;

    /**
     * Clears the field "country".
     *
     * The field will be set to its default value. The hasCountry()
     * method will return false.
     */
    inline void clearCountry();

    /**
     * Checks whether the field "country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountry()). Otherwise it will return false.
     */
    inline bool hasCountry () const;

    /**
     * Returns the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "country"
     */
    inline const ::std::string& getCountry () const;

    /**
     * Retrieves the value of the field "country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "country".
     */
    inline ::std::string& getCountryMutable ();

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const ::std::string& country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* country_);

    /**
     * Sets the value of the member "country".
     *
     * If the meaning of "country" isn't clear, then there should be a description here.
     *
     * @param country The value which will be set
     */
    inline void setCountry (const char* value, size_t size);

    /**
     * Release the object stored in the field "country".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "country"
     */
    inline ::std::string* releaseCountry();

    /**
     * Replace the field "country".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCountry (::std::string* country_);

    // API of field "radios"

    static const int kRadios = 4;

    /**
     * Clears the field "radios".
     *
     * The field will be set to its default value. The hasRadios()
     * method will return false.
     */
    inline void clearRadios();

    /**
     * Checks whether the field "radios" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRadios()). Otherwise it will return false.
     */
    inline bool hasRadios () const;

    /**
     * Returns the value of the member "radios".
     *
     * If the meaning of "radios" isn't clear, then there should be a description here.
     *
     * @return The value of the field "radios"
     */
    inline const ::boost::ptr_vector< WifiRadio >& getRadios () const;

    /**
     * Retrieves the value of the field "radios" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "radios".
     */
    inline ::boost::ptr_vector< WifiRadio >& getRadiosMutable ();

    /**
     * Sets the value of the member "radios".
     *
     * If the meaning of "radios" isn't clear, then there should be a description here.
     *
     * @param radios The value which will be set
     */
    inline void setRadios (const ::boost::ptr_vector< WifiRadio >& radios_);

    /**
     * Release the object stored in the field "radios".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "radios"
     */
    inline ::boost::ptr_vector< WifiRadio >* releaseRadios();

    /**
     * Replace the field "radios".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceRadios (::boost::ptr_vector< WifiRadio >* radios_);

    static const RegulatoryUpdate &getDefaultInstance();

private:

    static const ::boost::ptr_vector< WifiRadio >& getWifiRadioPointerList_DefaultInstance ();

    inline void set_has_initiator ();

    inline void clear_has_initiator ();

    inline void set_has_regtype ();

    inline void clear_has_regtype ();

    inline void set_has_global ();

    inline void clear_has_global ();

    inline void set_has_country ();

    inline void clear_has_country ();

    inline void set_has_radios ();

    inline void clear_has_radios ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _initiator;

    uint8 _regtype;

    uint8 _global;

    ::std::string* _country;

    ::boost::ptr_vector< WifiRadio >* _radios;

};

inline  WifiChannel::WifiChannel ()  :
    _channel (0u),
    _frequency (0u),
    _flags (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WifiChannel::WifiChannel (const WifiChannel &rhs)  :
    _channel (0u),
    _frequency (0u),
    _flags (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WifiChannel::WifiChannel (uint16 channel_, uint16 frequency_, uint32 flags_)  :
    _channel (channel_),
    _frequency (frequency_),
    _flags (flags_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WifiChannel::~WifiChannel() {
}

inline WifiChannel& WifiChannel::operator = (const WifiChannel& rhs) {
    if( this != &rhs ) {
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
        if (rhs.hasFrequency()) {
            setFrequency(rhs.getFrequency());
        } else {
            clearFrequency();
        }
        if (rhs.hasFlags()) {
            setFlags(rhs.getFlags());
        } else {
            clearFlags();
        }
    }
    return *this;
}

inline bool WifiChannel::operator == (const WifiChannel& rhs) const {
    return (((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()) &&
        ((!hasFrequency() && !rhs.hasFrequency()) || getFrequency() == rhs.getFrequency()) &&
        ((!hasFlags() && !rhs.hasFlags()) || getFlags() == rhs.getFlags()));
}

inline bool WifiChannel::operator != (const WifiChannel& rhs) const {
    return ! (*this == rhs);
}

inline bool WifiChannel::operator < (const WifiChannel& rhs) const {
    if (hasChannel() || rhs.hasChannel()) {
        if (getChannel() < rhs.getChannel()) return true;
        if (getChannel() > rhs.getChannel()) return false;
    }
    if (hasFrequency() || rhs.hasFrequency()) {
        if (getFrequency() < rhs.getFrequency()) return true;
        if (getFrequency() > rhs.getFrequency()) return false;
    }
    if (hasFlags() || rhs.hasFlags()) {
        if (getFlags() < rhs.getFlags()) return true;
        if (getFlags() > rhs.getFlags()) return false;
    }
    return false;
}

inline bool WifiChannel::operator > (const WifiChannel& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WifiChannel::clear() {
    clearChannel();
    clearFrequency();
    clearFlags();
}

inline void WifiChannel::clearChannel() {
    if (hasChannel()) {
         clear_has_channel();
        _channel = 0u;
     }
}

inline bool WifiChannel::hasChannel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 WifiChannel::getChannel () const {
    return _channel;
}

inline void WifiChannel::setChannel (uint16 channel_) {
    set_has_channel();
    this->_channel = channel_;
}

inline void WifiChannel::clearFrequency() {
    if (hasFrequency()) {
         clear_has_frequency();
        _frequency = 0u;
     }
}

inline bool WifiChannel::hasFrequency () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 WifiChannel::getFrequency () const {
    return _frequency;
}

inline void WifiChannel::setFrequency (uint16 frequency_) {
    set_has_frequency();
    this->_frequency = frequency_;
}

inline void WifiChannel::clearFlags() {
    if (hasFlags()) {
         clear_has_flags();
        _flags = 0u;
     }
}

inline bool WifiChannel::hasFlags () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 WifiChannel::getFlags () const {
    return _flags;
}

inline void WifiChannel::setFlags (uint32 flags_) {
    set_has_flags();
    this->_flags = flags_;
}

inline void WifiChannel::set_has_channel () {
    _has_bits_[0] |= 1u << 0;
}

inline void WifiChannel::clear_has_channel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void WifiChannel::set_has_frequency () {
    _has_bits_[0] |= 1u << 1;
}

inline void WifiChannel::clear_has_frequency () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void WifiChannel::set_has_flags () {
    _has_bits_[0] |= 1u << 2;
}

inline void WifiChannel::clear_has_flags () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  NetworkInterface::NetworkInterface ()  :
    _index (0u),
    _macaddress (NULL),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NetworkInterface::NetworkInterface (const NetworkInterface &rhs)  :
    _index (0u),
    _macaddress (NULL),
    _ifname (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NetworkInterface::NetworkInterface (uint32 index_, const ::std::string& macaddress_, const ::std::string& ifname_)  :
    _index (index_),
    _macaddress (new ::std::string(macaddress_)),
    _ifname (new ::std::string(ifname_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (macaddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NetworkInterface::~NetworkInterface() {
    delete _macaddress;
    delete _ifname;
}

inline NetworkInterface& NetworkInterface::operator = (const NetworkInterface& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIndex()) {
            setIndex(rhs.getIndex());
        } else {
            clearIndex();
        }
        if (rhs.hasMacaddress()) {
            setMacaddress(rhs.getMacaddress());
        } else {
            clearMacaddress();
        }
        if (rhs.hasIfname()) {
            setIfname(rhs.getIfname());
        } else {
            clearIfname();
        }
    }
    return *this;
}

inline bool NetworkInterface::operator == (const NetworkInterface& rhs) const {
    return (((!hasIndex() && !rhs.hasIndex()) || getIndex() == rhs.getIndex()) &&
        ((!hasMacaddress() && !rhs.hasMacaddress()) || getMacaddress() == rhs.getMacaddress()) &&
        ((!hasIfname() && !rhs.hasIfname()) || getIfname() == rhs.getIfname()));
}

inline bool NetworkInterface::operator != (const NetworkInterface& rhs) const {
    return ! (*this == rhs);
}

inline bool NetworkInterface::operator < (const NetworkInterface& rhs) const {
    if (hasIndex() || rhs.hasIndex()) {
        if (getIndex() < rhs.getIndex()) return true;
        if (getIndex() > rhs.getIndex()) return false;
    }
    if (hasMacaddress() || rhs.hasMacaddress()) {
        if (getMacaddress() < rhs.getMacaddress()) return true;
        if (getMacaddress() > rhs.getMacaddress()) return false;
    }
    if (hasIfname() || rhs.hasIfname()) {
        if (getIfname() < rhs.getIfname()) return true;
        if (getIfname() > rhs.getIfname()) return false;
    }
    return false;
}

inline bool NetworkInterface::operator > (const NetworkInterface& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NetworkInterface::clear() {
    clearIndex();
    clearMacaddress();
    clearIfname();
}

inline void NetworkInterface::clearIndex() {
    if (hasIndex()) {
         clear_has_index();
        _index = 0u;
     }
}

inline bool NetworkInterface::hasIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 NetworkInterface::getIndex () const {
    return _index;
}

inline void NetworkInterface::setIndex (uint32 index_) {
    set_has_index();
    this->_index = index_;
}

inline void NetworkInterface::clearMacaddress() {
    if (hasMacaddress()) {
         clear_has_macaddress();
        if (_macaddress != NULL) {
            _macaddress->clear();
        }
     }
}

inline bool NetworkInterface::hasMacaddress () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NetworkInterface::getMacaddress () const {
    if (_macaddress == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_macaddress;
}

inline ::std::string& NetworkInterface::getMacaddressMutable () {
    set_has_macaddress();
    if (_macaddress == NULL) {
        _macaddress = new ::std::string ();
        CHECK_ALLOCATION( _macaddress );
    }
    return *_macaddress;
}

inline void NetworkInterface::setMacaddress (const ::std::string& macaddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (macaddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_macaddress();
    if (this->_macaddress == NULL) {
        this->_macaddress = new ::std::string (macaddress_);
        CHECK_ALLOCATION( this->_macaddress );
    } else {
        *this->_macaddress = macaddress_;
    }
}

inline void NetworkInterface::setMacaddress (const char* macaddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (macaddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_macaddress();
    if (this->_macaddress == NULL) {
        this->_macaddress = new ::std::string (macaddress_);
        CHECK_ALLOCATION( this->_macaddress );
    } else {
        this->_macaddress->assign(macaddress_);
    }
}

inline void NetworkInterface::setMacaddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_macaddress();
    if (this->_macaddress == NULL) {
        this->_macaddress = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_macaddress );
    } else {
        this->_macaddress->assign(value, size);
    }
}

inline ::std::string* NetworkInterface::releaseMacaddress() {
    clear_has_macaddress();
    ::std::string* temp = _macaddress;
    this->_macaddress = NULL;
    return temp;
}

inline void NetworkInterface::replaceMacaddress (::std::string* macaddress_) {
    set_has_macaddress();
    if (this->_macaddress != macaddress_) {
        if (this->_macaddress != NULL) {
            delete this->_macaddress;
        }
        this->_macaddress = macaddress_;
    }
}

inline void NetworkInterface::clearIfname() {
    if (hasIfname()) {
         clear_has_ifname();
        if (_ifname != NULL) {
            _ifname->clear();
        }
     }
}

inline bool NetworkInterface::hasIfname () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& NetworkInterface::getIfname () const {
    if (_ifname == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_ifname;
}

inline ::std::string& NetworkInterface::getIfnameMutable () {
    set_has_ifname();
    if (_ifname == NULL) {
        _ifname = new ::std::string ();
        CHECK_ALLOCATION( _ifname );
    }
    return *_ifname;
}

inline void NetworkInterface::setIfname (const ::std::string& ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        *this->_ifname = ifname_;
    }
}

inline void NetworkInterface::setIfname (const char* ifname_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ifname_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (ifname_);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(ifname_);
    }
}

inline void NetworkInterface::setIfname (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ifname();
    if (this->_ifname == NULL) {
        this->_ifname = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_ifname );
    } else {
        this->_ifname->assign(value, size);
    }
}

inline ::std::string* NetworkInterface::releaseIfname() {
    clear_has_ifname();
    ::std::string* temp = _ifname;
    this->_ifname = NULL;
    return temp;
}

inline void NetworkInterface::replaceIfname (::std::string* ifname_) {
    set_has_ifname();
    if (this->_ifname != ifname_) {
        if (this->_ifname != NULL) {
            delete this->_ifname;
        }
        this->_ifname = ifname_;
    }
}

inline void NetworkInterface::set_has_index () {
    _has_bits_[0] |= 1u << 0;
}

inline void NetworkInterface::clear_has_index () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NetworkInterface::set_has_macaddress () {
    _has_bits_[0] |= 1u << 1;
}

inline void NetworkInterface::clear_has_macaddress () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NetworkInterface::set_has_ifname () {
    _has_bits_[0] |= 1u << 2;
}

inline void NetworkInterface::clear_has_ifname () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  WifiRadio::WifiRadio ()  :
    _radio (NULL),
    _regDomain (NULL),
    _initiator (0u),
    _regtype (0u),
    _selfManaged (0),
    _ieee80211index (0),
    _netdevices (NULL),
    _channelsinfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WifiRadio::WifiRadio (const WifiRadio &rhs)  :
    _radio (NULL),
    _regDomain (NULL),
    _initiator (0u),
    _regtype (0u),
    _selfManaged (0),
    _ieee80211index (0),
    _netdevices (NULL),
    _channelsinfo (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WifiRadio::WifiRadio (const ::std::string& radio_, const ::std::string& regDomain_, uint8 initiator_, uint8 regtype_, int32 selfManaged_, int32 ieee80211index_, const ::boost::ptr_vector< NetworkInterface >& netdevices_, const ::boost::ptr_vector< WifiChannel >& channelsinfo_)  :
    _radio (new ::std::string(radio_)),
    _regDomain (new ::std::string(regDomain_)),
    _initiator (initiator_),
    _regtype (regtype_),
    _selfManaged (selfManaged_),
    _ieee80211index (ieee80211index_),
    _netdevices (new ::boost::ptr_vector< NetworkInterface >(netdevices_)),
    _channelsinfo (new ::boost::ptr_vector< WifiChannel >(channelsinfo_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (radio_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regDomain_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WifiRadio::~WifiRadio() {
    delete _radio;
    delete _regDomain;
    delete _netdevices;
    delete _channelsinfo;
}

inline WifiRadio& WifiRadio::operator = (const WifiRadio& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRadio()) {
            setRadio(rhs.getRadio());
        } else {
            clearRadio();
        }
        if (rhs.hasRegDomain()) {
            setRegDomain(rhs.getRegDomain());
        } else {
            clearRegDomain();
        }
        if (rhs.hasInitiator()) {
            setInitiator(rhs.getInitiator());
        } else {
            clearInitiator();
        }
        if (rhs.hasRegtype()) {
            setRegtype(rhs.getRegtype());
        } else {
            clearRegtype();
        }
        if (rhs.hasSelfManaged()) {
            setSelfManaged(rhs.getSelfManaged());
        } else {
            clearSelfManaged();
        }
        if (rhs.hasIeee80211index()) {
            setIeee80211index(rhs.getIeee80211index());
        } else {
            clearIeee80211index();
        }
        if (rhs.hasNetdevices()) {
            setNetdevices(rhs.getNetdevices());
        } else {
            clearNetdevices();
        }
        if (rhs.hasChannelsinfo()) {
            setChannelsinfo(rhs.getChannelsinfo());
        } else {
            clearChannelsinfo();
        }
    }
    return *this;
}

inline bool WifiRadio::operator == (const WifiRadio& rhs) const {
    return (((!hasRadio() && !rhs.hasRadio()) || getRadio() == rhs.getRadio()) &&
        ((!hasRegDomain() && !rhs.hasRegDomain()) || getRegDomain() == rhs.getRegDomain()) &&
        ((!hasInitiator() && !rhs.hasInitiator()) || getInitiator() == rhs.getInitiator()) &&
        ((!hasRegtype() && !rhs.hasRegtype()) || getRegtype() == rhs.getRegtype()) &&
        ((!hasSelfManaged() && !rhs.hasSelfManaged()) || getSelfManaged() == rhs.getSelfManaged()) &&
        ((!hasIeee80211index() && !rhs.hasIeee80211index()) || getIeee80211index() == rhs.getIeee80211index()) &&
        ((!hasNetdevices() && !rhs.hasNetdevices()) || getNetdevices() == rhs.getNetdevices()) &&
        ((!hasChannelsinfo() && !rhs.hasChannelsinfo()) || getChannelsinfo() == rhs.getChannelsinfo()));
}

inline bool WifiRadio::operator != (const WifiRadio& rhs) const {
    return ! (*this == rhs);
}

inline bool WifiRadio::operator < (const WifiRadio& rhs) const {
    if (hasRadio() || rhs.hasRadio()) {
        if (getRadio() < rhs.getRadio()) return true;
        if (getRadio() > rhs.getRadio()) return false;
    }
    if (hasRegDomain() || rhs.hasRegDomain()) {
        if (getRegDomain() < rhs.getRegDomain()) return true;
        if (getRegDomain() > rhs.getRegDomain()) return false;
    }
    if (hasInitiator() || rhs.hasInitiator()) {
        if (getInitiator() < rhs.getInitiator()) return true;
        if (getInitiator() > rhs.getInitiator()) return false;
    }
    if (hasRegtype() || rhs.hasRegtype()) {
        if (getRegtype() < rhs.getRegtype()) return true;
        if (getRegtype() > rhs.getRegtype()) return false;
    }
    if (hasSelfManaged() || rhs.hasSelfManaged()) {
        if (getSelfManaged() < rhs.getSelfManaged()) return true;
        if (getSelfManaged() > rhs.getSelfManaged()) return false;
    }
    if (hasIeee80211index() || rhs.hasIeee80211index()) {
        if (getIeee80211index() < rhs.getIeee80211index()) return true;
        if (getIeee80211index() > rhs.getIeee80211index()) return false;
    }
    if (hasNetdevices() || rhs.hasNetdevices()) {
        if (getNetdevices() < rhs.getNetdevices()) return true;
        if (getNetdevices() > rhs.getNetdevices()) return false;
    }
    if (hasChannelsinfo() || rhs.hasChannelsinfo()) {
        if (getChannelsinfo() < rhs.getChannelsinfo()) return true;
        if (getChannelsinfo() > rhs.getChannelsinfo()) return false;
    }
    return false;
}

inline bool WifiRadio::operator > (const WifiRadio& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WifiRadio::clear() {
    clearRadio();
    clearRegDomain();
    clearInitiator();
    clearRegtype();
    clearSelfManaged();
    clearIeee80211index();
    clearNetdevices();
    clearChannelsinfo();
}

inline void WifiRadio::clearRadio() {
    if (hasRadio()) {
         clear_has_radio();
        if (_radio != NULL) {
            _radio->clear();
        }
     }
}

inline bool WifiRadio::hasRadio () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& WifiRadio::getRadio () const {
    if (_radio == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_radio;
}

inline ::std::string& WifiRadio::getRadioMutable () {
    set_has_radio();
    if (_radio == NULL) {
        _radio = new ::std::string ();
        CHECK_ALLOCATION( _radio );
    }
    return *_radio;
}

inline void WifiRadio::setRadio (const ::std::string& radio_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (radio_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_radio();
    if (this->_radio == NULL) {
        this->_radio = new ::std::string (radio_);
        CHECK_ALLOCATION( this->_radio );
    } else {
        *this->_radio = radio_;
    }
}

inline void WifiRadio::setRadio (const char* radio_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (radio_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_radio();
    if (this->_radio == NULL) {
        this->_radio = new ::std::string (radio_);
        CHECK_ALLOCATION( this->_radio );
    } else {
        this->_radio->assign(radio_);
    }
}

inline void WifiRadio::setRadio (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_radio();
    if (this->_radio == NULL) {
        this->_radio = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_radio );
    } else {
        this->_radio->assign(value, size);
    }
}

inline ::std::string* WifiRadio::releaseRadio() {
    clear_has_radio();
    ::std::string* temp = _radio;
    this->_radio = NULL;
    return temp;
}

inline void WifiRadio::replaceRadio (::std::string* radio_) {
    set_has_radio();
    if (this->_radio != radio_) {
        if (this->_radio != NULL) {
            delete this->_radio;
        }
        this->_radio = radio_;
    }
}

inline void WifiRadio::clearRegDomain() {
    if (hasRegDomain()) {
         clear_has_regDomain();
        if (_regDomain != NULL) {
            _regDomain->clear();
        }
     }
}

inline bool WifiRadio::hasRegDomain () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& WifiRadio::getRegDomain () const {
    if (_regDomain == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_regDomain;
}

inline ::std::string& WifiRadio::getRegDomainMutable () {
    set_has_regDomain();
    if (_regDomain == NULL) {
        _regDomain = new ::std::string ();
        CHECK_ALLOCATION( _regDomain );
    }
    return *_regDomain;
}

inline void WifiRadio::setRegDomain (const ::std::string& regDomain_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regDomain_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regDomain();
    if (this->_regDomain == NULL) {
        this->_regDomain = new ::std::string (regDomain_);
        CHECK_ALLOCATION( this->_regDomain );
    } else {
        *this->_regDomain = regDomain_;
    }
}

inline void WifiRadio::setRegDomain (const char* regDomain_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (regDomain_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regDomain();
    if (this->_regDomain == NULL) {
        this->_regDomain = new ::std::string (regDomain_);
        CHECK_ALLOCATION( this->_regDomain );
    } else {
        this->_regDomain->assign(regDomain_);
    }
}

inline void WifiRadio::setRegDomain (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_regDomain();
    if (this->_regDomain == NULL) {
        this->_regDomain = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_regDomain );
    } else {
        this->_regDomain->assign(value, size);
    }
}

inline ::std::string* WifiRadio::releaseRegDomain() {
    clear_has_regDomain();
    ::std::string* temp = _regDomain;
    this->_regDomain = NULL;
    return temp;
}

inline void WifiRadio::replaceRegDomain (::std::string* regDomain_) {
    set_has_regDomain();
    if (this->_regDomain != regDomain_) {
        if (this->_regDomain != NULL) {
            delete this->_regDomain;
        }
        this->_regDomain = regDomain_;
    }
}

inline void WifiRadio::clearInitiator() {
    if (hasInitiator()) {
         clear_has_initiator();
        _initiator = 0u;
     }
}

inline bool WifiRadio::hasInitiator () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 WifiRadio::getInitiator () const {
    return _initiator;
}

inline void WifiRadio::setInitiator (uint8 initiator_) {
    set_has_initiator();
    this->_initiator = initiator_;
}

inline void WifiRadio::clearRegtype() {
    if (hasRegtype()) {
         clear_has_regtype();
        _regtype = 0u;
     }
}

inline bool WifiRadio::hasRegtype () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 WifiRadio::getRegtype () const {
    return _regtype;
}

inline void WifiRadio::setRegtype (uint8 regtype_) {
    set_has_regtype();
    this->_regtype = regtype_;
}

inline void WifiRadio::clearSelfManaged() {
    if (hasSelfManaged()) {
         clear_has_selfManaged();
        _selfManaged = 0;
     }
}

inline bool WifiRadio::hasSelfManaged () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int32 WifiRadio::getSelfManaged () const {
    return _selfManaged;
}

inline void WifiRadio::setSelfManaged (int32 selfManaged_) {
    set_has_selfManaged();
    this->_selfManaged = selfManaged_;
}

inline void WifiRadio::clearIeee80211index() {
    if (hasIeee80211index()) {
         clear_has_ieee80211index();
        _ieee80211index = 0;
     }
}

inline bool WifiRadio::hasIeee80211index () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline int32 WifiRadio::getIeee80211index () const {
    return _ieee80211index;
}

inline void WifiRadio::setIeee80211index (int32 ieee80211index_) {
    set_has_ieee80211index();
    this->_ieee80211index = ieee80211index_;
}

inline void WifiRadio::clearNetdevices() {
    if (hasNetdevices()) {
         clear_has_netdevices();
        if (_netdevices != NULL) {
            _netdevices->clear();
        }
     }
}

inline bool WifiRadio::hasNetdevices () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::boost::ptr_vector< NetworkInterface >& WifiRadio::getNetdevices () const {
    if (_netdevices == NULL) {
        return getNetworkInterfacePointerList_DefaultInstance();
    }
    return *_netdevices;
}

inline ::boost::ptr_vector< NetworkInterface >& WifiRadio::getNetdevicesMutable () {
    set_has_netdevices();
    if (_netdevices == NULL) {
        _netdevices = new ::boost::ptr_vector< NetworkInterface > ();
        CHECK_ALLOCATION( _netdevices );
    }
    return *_netdevices;
}

inline void WifiRadio::setNetdevices (const ::boost::ptr_vector< NetworkInterface >& netdevices_) {
    set_has_netdevices();
    if (this->_netdevices == NULL) {
        this->_netdevices = new ::boost::ptr_vector< NetworkInterface > (netdevices_);
        CHECK_ALLOCATION( this->_netdevices );
    } else {
        *this->_netdevices = netdevices_;
    }
}

inline ::boost::ptr_vector< NetworkInterface >* WifiRadio::releaseNetdevices() {
    clear_has_netdevices();
    ::boost::ptr_vector< NetworkInterface >* temp = _netdevices;
    this->_netdevices = NULL;
    return temp;
}

inline void WifiRadio::replaceNetdevices (::boost::ptr_vector< NetworkInterface >* netdevices_) {
    set_has_netdevices();
    if (this->_netdevices != netdevices_) {
        if (this->_netdevices != NULL) {
            delete this->_netdevices;
        }
        this->_netdevices = netdevices_;
    }
}

inline void WifiRadio::clearChannelsinfo() {
    if (hasChannelsinfo()) {
         clear_has_channelsinfo();
        if (_channelsinfo != NULL) {
            _channelsinfo->clear();
        }
     }
}

inline bool WifiRadio::hasChannelsinfo () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::boost::ptr_vector< WifiChannel >& WifiRadio::getChannelsinfo () const {
    if (_channelsinfo == NULL) {
        return getWifiChannelPointerList_DefaultInstance();
    }
    return *_channelsinfo;
}

inline ::boost::ptr_vector< WifiChannel >& WifiRadio::getChannelsinfoMutable () {
    set_has_channelsinfo();
    if (_channelsinfo == NULL) {
        _channelsinfo = new ::boost::ptr_vector< WifiChannel > ();
        CHECK_ALLOCATION( _channelsinfo );
    }
    return *_channelsinfo;
}

inline void WifiRadio::setChannelsinfo (const ::boost::ptr_vector< WifiChannel >& channelsinfo_) {
    set_has_channelsinfo();
    if (this->_channelsinfo == NULL) {
        this->_channelsinfo = new ::boost::ptr_vector< WifiChannel > (channelsinfo_);
        CHECK_ALLOCATION( this->_channelsinfo );
    } else {
        *this->_channelsinfo = channelsinfo_;
    }
}

inline ::boost::ptr_vector< WifiChannel >* WifiRadio::releaseChannelsinfo() {
    clear_has_channelsinfo();
    ::boost::ptr_vector< WifiChannel >* temp = _channelsinfo;
    this->_channelsinfo = NULL;
    return temp;
}

inline void WifiRadio::replaceChannelsinfo (::boost::ptr_vector< WifiChannel >* channelsinfo_) {
    set_has_channelsinfo();
    if (this->_channelsinfo != channelsinfo_) {
        if (this->_channelsinfo != NULL) {
            delete this->_channelsinfo;
        }
        this->_channelsinfo = channelsinfo_;
    }
}

inline void WifiRadio::set_has_radio () {
    _has_bits_[0] |= 1u << 0;
}

inline void WifiRadio::clear_has_radio () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void WifiRadio::set_has_regDomain () {
    _has_bits_[0] |= 1u << 1;
}

inline void WifiRadio::clear_has_regDomain () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void WifiRadio::set_has_initiator () {
    _has_bits_[0] |= 1u << 2;
}

inline void WifiRadio::clear_has_initiator () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void WifiRadio::set_has_regtype () {
    _has_bits_[0] |= 1u << 3;
}

inline void WifiRadio::clear_has_regtype () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void WifiRadio::set_has_selfManaged () {
    _has_bits_[0] |= 1u << 4;
}

inline void WifiRadio::clear_has_selfManaged () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void WifiRadio::set_has_ieee80211index () {
    _has_bits_[0] |= 1u << 5;
}

inline void WifiRadio::clear_has_ieee80211index () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void WifiRadio::set_has_netdevices () {
    _has_bits_[0] |= 1u << 6;
}

inline void WifiRadio::clear_has_netdevices () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void WifiRadio::set_has_channelsinfo () {
    _has_bits_[0] |= 1u << 7;
}

inline void WifiRadio::clear_has_channelsinfo () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  RegulatoryUpdate::RegulatoryUpdate ()  :
    _initiator (0u),
    _regtype (0u),
    _global (0u),
    _country (NULL),
    _radios (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RegulatoryUpdate::RegulatoryUpdate (const RegulatoryUpdate &rhs)  :
    _initiator (0u),
    _regtype (0u),
    _global (0u),
    _country (NULL),
    _radios (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RegulatoryUpdate::RegulatoryUpdate (uint8 initiator_, uint8 regtype_, uint8 global_, const ::std::string& country_, const ::boost::ptr_vector< WifiRadio >& radios_)  :
    _initiator (initiator_),
    _regtype (regtype_),
    _global (global_),
    _country (new ::std::string(country_)),
    _radios (new ::boost::ptr_vector< WifiRadio >(radios_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RegulatoryUpdate::~RegulatoryUpdate() {
    delete _country;
    delete _radios;
}

inline RegulatoryUpdate& RegulatoryUpdate::operator = (const RegulatoryUpdate& rhs) {
    if( this != &rhs ) {
        if (rhs.hasInitiator()) {
            setInitiator(rhs.getInitiator());
        } else {
            clearInitiator();
        }
        if (rhs.hasRegtype()) {
            setRegtype(rhs.getRegtype());
        } else {
            clearRegtype();
        }
        if (rhs.hasGlobal()) {
            setGlobal(rhs.getGlobal());
        } else {
            clearGlobal();
        }
        if (rhs.hasCountry()) {
            setCountry(rhs.getCountry());
        } else {
            clearCountry();
        }
        if (rhs.hasRadios()) {
            setRadios(rhs.getRadios());
        } else {
            clearRadios();
        }
    }
    return *this;
}

inline bool RegulatoryUpdate::operator == (const RegulatoryUpdate& rhs) const {
    return (((!hasInitiator() && !rhs.hasInitiator()) || getInitiator() == rhs.getInitiator()) &&
        ((!hasRegtype() && !rhs.hasRegtype()) || getRegtype() == rhs.getRegtype()) &&
        ((!hasGlobal() && !rhs.hasGlobal()) || getGlobal() == rhs.getGlobal()) &&
        ((!hasCountry() && !rhs.hasCountry()) || getCountry() == rhs.getCountry()) &&
        ((!hasRadios() && !rhs.hasRadios()) || getRadios() == rhs.getRadios()));
}

inline bool RegulatoryUpdate::operator != (const RegulatoryUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RegulatoryUpdate::operator < (const RegulatoryUpdate& rhs) const {
    if (hasInitiator() || rhs.hasInitiator()) {
        if (getInitiator() < rhs.getInitiator()) return true;
        if (getInitiator() > rhs.getInitiator()) return false;
    }
    if (hasRegtype() || rhs.hasRegtype()) {
        if (getRegtype() < rhs.getRegtype()) return true;
        if (getRegtype() > rhs.getRegtype()) return false;
    }
    if (hasGlobal() || rhs.hasGlobal()) {
        if (getGlobal() < rhs.getGlobal()) return true;
        if (getGlobal() > rhs.getGlobal()) return false;
    }
    if (hasCountry() || rhs.hasCountry()) {
        if (getCountry() < rhs.getCountry()) return true;
        if (getCountry() > rhs.getCountry()) return false;
    }
    if (hasRadios() || rhs.hasRadios()) {
        if (getRadios() < rhs.getRadios()) return true;
        if (getRadios() > rhs.getRadios()) return false;
    }
    return false;
}

inline bool RegulatoryUpdate::operator > (const RegulatoryUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RegulatoryUpdate::clear() {
    clearInitiator();
    clearRegtype();
    clearGlobal();
    clearCountry();
    clearRadios();
}

inline void RegulatoryUpdate::clearInitiator() {
    if (hasInitiator()) {
         clear_has_initiator();
        _initiator = 0u;
     }
}

inline bool RegulatoryUpdate::hasInitiator () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RegulatoryUpdate::getInitiator () const {
    return _initiator;
}

inline void RegulatoryUpdate::setInitiator (uint8 initiator_) {
    set_has_initiator();
    this->_initiator = initiator_;
}

inline void RegulatoryUpdate::clearRegtype() {
    if (hasRegtype()) {
         clear_has_regtype();
        _regtype = 0u;
     }
}

inline bool RegulatoryUpdate::hasRegtype () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 RegulatoryUpdate::getRegtype () const {
    return _regtype;
}

inline void RegulatoryUpdate::setRegtype (uint8 regtype_) {
    set_has_regtype();
    this->_regtype = regtype_;
}

inline void RegulatoryUpdate::clearGlobal() {
    if (hasGlobal()) {
         clear_has_global();
        _global = 0u;
     }
}

inline bool RegulatoryUpdate::hasGlobal () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 RegulatoryUpdate::getGlobal () const {
    return _global;
}

inline void RegulatoryUpdate::setGlobal (uint8 global_) {
    set_has_global();
    this->_global = global_;
}

inline void RegulatoryUpdate::clearCountry() {
    if (hasCountry()) {
         clear_has_country();
        if (_country != NULL) {
            _country->clear();
        }
     }
}

inline bool RegulatoryUpdate::hasCountry () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& RegulatoryUpdate::getCountry () const {
    if (_country == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_country;
}

inline ::std::string& RegulatoryUpdate::getCountryMutable () {
    set_has_country();
    if (_country == NULL) {
        _country = new ::std::string ();
        CHECK_ALLOCATION( _country );
    }
    return *_country;
}

inline void RegulatoryUpdate::setCountry (const ::std::string& country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    if (this->_country == NULL) {
        this->_country = new ::std::string (country_);
        CHECK_ALLOCATION( this->_country );
    } else {
        *this->_country = country_;
    }
}

inline void RegulatoryUpdate::setCountry (const char* country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    if (this->_country == NULL) {
        this->_country = new ::std::string (country_);
        CHECK_ALLOCATION( this->_country );
    } else {
        this->_country->assign(country_);
    }
}

inline void RegulatoryUpdate::setCountry (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_country();
    if (this->_country == NULL) {
        this->_country = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_country );
    } else {
        this->_country->assign(value, size);
    }
}

inline ::std::string* RegulatoryUpdate::releaseCountry() {
    clear_has_country();
    ::std::string* temp = _country;
    this->_country = NULL;
    return temp;
}

inline void RegulatoryUpdate::replaceCountry (::std::string* country_) {
    set_has_country();
    if (this->_country != country_) {
        if (this->_country != NULL) {
            delete this->_country;
        }
        this->_country = country_;
    }
}

inline void RegulatoryUpdate::clearRadios() {
    if (hasRadios()) {
         clear_has_radios();
        if (_radios != NULL) {
            _radios->clear();
        }
     }
}

inline bool RegulatoryUpdate::hasRadios () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::boost::ptr_vector< WifiRadio >& RegulatoryUpdate::getRadios () const {
    if (_radios == NULL) {
        return getWifiRadioPointerList_DefaultInstance();
    }
    return *_radios;
}

inline ::boost::ptr_vector< WifiRadio >& RegulatoryUpdate::getRadiosMutable () {
    set_has_radios();
    if (_radios == NULL) {
        _radios = new ::boost::ptr_vector< WifiRadio > ();
        CHECK_ALLOCATION( _radios );
    }
    return *_radios;
}

inline void RegulatoryUpdate::setRadios (const ::boost::ptr_vector< WifiRadio >& radios_) {
    set_has_radios();
    if (this->_radios == NULL) {
        this->_radios = new ::boost::ptr_vector< WifiRadio > (radios_);
        CHECK_ALLOCATION( this->_radios );
    } else {
        *this->_radios = radios_;
    }
}

inline ::boost::ptr_vector< WifiRadio >* RegulatoryUpdate::releaseRadios() {
    clear_has_radios();
    ::boost::ptr_vector< WifiRadio >* temp = _radios;
    this->_radios = NULL;
    return temp;
}

inline void RegulatoryUpdate::replaceRadios (::boost::ptr_vector< WifiRadio >* radios_) {
    set_has_radios();
    if (this->_radios != radios_) {
        if (this->_radios != NULL) {
            delete this->_radios;
        }
        this->_radios = radios_;
    }
}

inline void RegulatoryUpdate::set_has_initiator () {
    _has_bits_[0] |= 1u << 0;
}

inline void RegulatoryUpdate::clear_has_initiator () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RegulatoryUpdate::set_has_regtype () {
    _has_bits_[0] |= 1u << 1;
}

inline void RegulatoryUpdate::clear_has_regtype () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RegulatoryUpdate::set_has_global () {
    _has_bits_[0] |= 1u << 2;
}

inline void RegulatoryUpdate::clear_has_global () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RegulatoryUpdate::set_has_country () {
    _has_bits_[0] |= 1u << 3;
}

inline void RegulatoryUpdate::clear_has_country () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void RegulatoryUpdate::set_has_radios () {
    _has_bits_[0] |= 1u << 4;
}

inline void RegulatoryUpdate::clear_has_radios () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace WBLRegulatoryTypes
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLREGULATORYTYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
