/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLMlmeTypesJson.h"
#include "org/bosch/WBLMlmeTypesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstdlib>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "MlmeEventConnect"

void serializeJson (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIeee80211index()) {
        yajl_gen_string(g, (const unsigned char*)  "ieee80211index" , 14);
        yajl_gen_integer(g, (long long)value.getIeee80211index());
    }
    if (!isSparse || value.hasIfindex()) {
        yajl_gen_string(g, (const unsigned char*)  "ifindex" , 7);
        yajl_gen_integer(g, (long long)value.getIfindex());
    }
    if (!isSparse || value.hasBssid()) {
        yajl_gen_string(g, (const unsigned char*)  "bssid" , 5);
        const char *s = value.getBssid().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStatuscode()) {
        yajl_gen_string(g, (const unsigned char*)  "statuscode" , 10);
        yajl_gen_integer(g, (long long)value.getStatuscode());
    }
    if (!isSparse || value.hasTimedout()) {
        yajl_gen_string(g, (const unsigned char*)  "timedout" , 8);
        yajl_gen_bool(g, (bool)value.getTimedout());
    }
    if (!isSparse || value.hasIfname()) {
        yajl_gen_string(g, (const unsigned char*)  "ifname" , 6);
        const char *s = value.getIfname().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLMlmeTypes::MlmeEventConnect& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserMlmeEventConnect", jsonParser__org__bosch__WBLMlmeTypes__MlmeEventConnect, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForMlmeEventConnect (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"BSSID", 5},
        {6,"IFNAME", 11},
        {7,"IFINDEX", 3},
        {8,"TIMEDOUT", 9},
        {10,"STATUSCODE", 7},
        {14,"IEEE80211INDEX", 1},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 6, value))
        return (int)value;
    else
        return 12;
}

static int processMapKeyForMlmeEventConnect (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForMlmeEventConnect(s, length);
    if (i != 12 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLMlmeTypes__MlmeEventConnect(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IEEE80211INDEX,
        KEY_IEEE80211INDEX,
        INIT_KEY_IFINDEX,
        KEY_IFINDEX,
        INIT_KEY_BSSID,
        KEY_BSSID,
        INIT_KEY_STATUSCODE,
        KEY_STATUSCODE,
        INIT_KEY_TIMEDOUT,
        KEY_TIMEDOUT,
        INIT_KEY_IFNAME,
        KEY_IFNAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "ieee80211index", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->setIeee80211index(t);
                    setState (context, INIT_KEY_IFINDEX);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IFINDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "ifindex", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IFINDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->setIfindex(t);
                    setState (context, INIT_KEY_BSSID);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_BSSID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "bssid", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_BSSID:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->replaceBssid(t);
                setState (context, INIT_KEY_STATUSCODE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_STATUSCODE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "statuscode", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_STATUSCODE:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->setStatuscode(t);
                    setState (context, INIT_KEY_TIMEDOUT);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_TIMEDOUT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "timedout", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_TIMEDOUT:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->setTimedout(t);
                setState (context, INIT_KEY_IFNAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventConnect (context, (char*) p1, (size_t) p2, "ifname", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLMlmeTypes::MlmeEventConnect*) parser.object)->replaceIfname(t);
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "MlmeEventDisconnect"

void serializeJson (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIeee80211index()) {
        yajl_gen_string(g, (const unsigned char*)  "ieee80211index" , 14);
        yajl_gen_integer(g, (long long)value.getIeee80211index());
    }
    if (!isSparse || value.hasIfindex()) {
        yajl_gen_string(g, (const unsigned char*)  "ifindex" , 7);
        yajl_gen_integer(g, (long long)value.getIfindex());
    }
    if (!isSparse || value.hasDisconnectedbyap()) {
        yajl_gen_string(g, (const unsigned char*)  "disconnectedbyap" , 16);
        yajl_gen_bool(g, (bool)value.getDisconnectedbyap());
    }
    if (!isSparse || value.hasReason()) {
        yajl_gen_string(g, (const unsigned char*)  "reason" , 6);
        yajl_gen_integer(g, (long long)value.getReason());
    }
    if (!isSparse || value.hasIfname()) {
        yajl_gen_string(g, (const unsigned char*)  "ifname" , 6);
        const char *s = value.getIfname().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserMlmeEventDisconnect", jsonParser__org__bosch__WBLMlmeTypes__MlmeEventDisconnect, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForMlmeEventDisconnect (char *s, size_t length)
{
    static stringEntry entries[] = {
        {6,"IFNAME", 9},
        {6,"REASON", 7},
        {7,"IFINDEX", 3},
        {14,"IEEE80211INDEX", 1},
        {16,"DISCONNECTEDBYAP", 5},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 5, value))
        return (int)value;
    else
        return 10;
}

static int processMapKeyForMlmeEventDisconnect (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForMlmeEventDisconnect(s, length);
    if (i != 10 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__org__bosch__WBLMlmeTypes__MlmeEventDisconnect(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_IEEE80211INDEX,
        KEY_IEEE80211INDEX,
        INIT_KEY_IFINDEX,
        KEY_IFINDEX,
        INIT_KEY_DISCONNECTEDBYAP,
        KEY_DISCONNECTEDBYAP,
        INIT_KEY_REASON,
        KEY_REASON,
        INIT_KEY_IFNAME,
        KEY_IFNAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventDisconnect (context, (char*) p1, (size_t) p2, "ieee80211index", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IEEE80211INDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventDisconnect*) parser.object)->setIeee80211index(t);
                    setState (context, INIT_KEY_IFINDEX);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IFINDEX:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventDisconnect (context, (char*) p1, (size_t) p2, "ifindex", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IFINDEX:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventDisconnect*) parser.object)->setIfindex(t);
                    setState (context, INIT_KEY_DISCONNECTEDBYAP);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_DISCONNECTEDBYAP:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventDisconnect (context, (char*) p1, (size_t) p2, "disconnectedbyap", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_DISCONNECTEDBYAP:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::org::bosch::WBLMlmeTypes::MlmeEventDisconnect*) parser.object)->setDisconnectedbyap(t);
                setState (context, INIT_KEY_REASON);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_REASON:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventDisconnect (context, (char*) p1, (size_t) p2, "reason", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_REASON:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::org::bosch::WBLMlmeTypes::MlmeEventDisconnect*) parser.object)->setReason(t);
                    setState (context, INIT_KEY_IFNAME);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForMlmeEventDisconnect (context, (char*) p1, (size_t) p2, "ifname", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IFNAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::org::bosch::WBLMlmeTypes::MlmeEventDisconnect*) parser.object)->replaceIfname(t);
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_IEEE80211INDEX);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLMlmeTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLMlmeTypes
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace WBLMlmeTypes {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WBLMlmeTypes
} // namespace bosch
} // namespace org

