/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cms/CmsStubDelegate.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/WBLASFService.h"
#include "org/bosch/WBLASFServiceJson.h"
#include "org/bosch/WBLASFServiceStub.h"
#include "org/bosch/WBLASFServiceStubConnector.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLRegulatoryTypes.h"

/**
 * If the meaning of "WBLASFService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace WBLASFService {

DEFINE_CLASS_LOGGER("/org/bosch/WBLASFService", WBLASFServiceStub);

WBLASFServiceStub::WBLASFServiceStub(const std::string& portName) :
    Stub(portName),
    _currentRegSettingsProperty(),
    _mediaConnectedProperty(),
    _mediaDisconnectedProperty(),
    _stubConnector(new WBLASFServiceStubConnector()),
    _cmsStubDelegate(new ::asf::cms::CmsStubDelegate( "WBLASFService", this, _stubConnector)) {
        CHECK_ALLOCATION(_stubConnector);
        CHECK_ALLOCATION(_cmsStubDelegate);
}

WBLASFServiceStub::~WBLASFServiceStub() {
    delete _stubConnector;
    delete _cmsStubDelegate;
}

// request starteventloop

void WBLASFServiceStub::sendStarteventloopResponse (act_t act) {
    ::boost::shared_ptr< StarteventloopResponse > obj(new StarteventloopResponse());
    LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "Starteventloop", act, _cmsStubDelegate->getStub());
    _cmsStubDelegate->sendResponse("starteventloop", obj, act);
}

// request setproperty

void WBLASFServiceStub::sendSetpropertyResponse (bool data, act_t act) {
    ::boost::shared_ptr< SetpropertyResponse > obj(new SetpropertyResponse(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sResponse, act=%" PRIuPTR ", stub=%p", "Setproperty", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendResponse("setproperty", obj, act);
}

// property currentRegSettings

void WBLASFServiceStub::onCurrentRegSettingsRegister(bool /*isFirst*/, act_t act) {
    sendCurrentRegSettingsUpdate(getCurrentRegSettings(), act);
}

void WBLASFServiceStub::onCurrentRegSettingsDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WBLASFServiceStub::sendCurrentRegSettingsUpdate(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data, act_t act) {
    ::boost::shared_ptr< CurrentRegSettingsUpdate > obj(new CurrentRegSettingsUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "CurrentRegSettings", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("currentRegSettings", obj, act);
}

void WBLASFServiceStub::sendCurrentRegSettingsGetUpdate(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data, act_t act) {
    ::boost::shared_ptr< CurrentRegSettingsUpdate > obj(new CurrentRegSettingsUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "CurrentRegSettings", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("currentRegSettings", obj, act);
}

void WBLASFServiceStub::onCurrentRegSettingsGet(const ::boost::shared_ptr< CurrentRegSettingsGet >& currentRegSettings) {
    sendCurrentRegSettingsGetUpdate(getCurrentRegSettings(), currentRegSettings->getAct());
}

void WBLASFServiceStub::setCurrentRegSettings(const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data) {
    if(data!=_currentRegSettingsProperty.getData()) {
        _currentRegSettingsProperty.setData(data);
        ::boost::shared_ptr< CurrentRegSettingsUpdate > obj(new CurrentRegSettingsUpdate(_currentRegSettingsProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "CurrentRegSettings", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("currentRegSettings", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "CurrentRegSettings", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_currentRegSettingsProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& WBLASFServiceStub::getCurrentRegSettings() const {
    return _currentRegSettingsProperty.getData();
}


::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& WBLASFServiceStub::getCurrentRegSettingsMutable() {
    return _currentRegSettingsProperty.getDataMutable();
}

void WBLASFServiceStub::sendCurrentRegSettingsNotification() {
    ::boost::shared_ptr< CurrentRegSettingsUpdate > obj(new CurrentRegSettingsUpdate(_currentRegSettingsProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "CurrentRegSettings", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("currentRegSettings", obj);
}

// property mediaConnected

void WBLASFServiceStub::onMediaConnectedRegister(bool /*isFirst*/, act_t act) {
    sendMediaConnectedUpdate(getMediaConnected(), act);
}

void WBLASFServiceStub::onMediaConnectedDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WBLASFServiceStub::sendMediaConnectedUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data, act_t act) {
    ::boost::shared_ptr< MediaConnectedUpdate > obj(new MediaConnectedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "MediaConnected", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("mediaConnected", obj, act);
}

void WBLASFServiceStub::sendMediaConnectedGetUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data, act_t act) {
    ::boost::shared_ptr< MediaConnectedUpdate > obj(new MediaConnectedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "MediaConnected", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("mediaConnected", obj, act);
}

void WBLASFServiceStub::onMediaConnectedGet(const ::boost::shared_ptr< MediaConnectedGet >& mediaConnected) {
    sendMediaConnectedGetUpdate(getMediaConnected(), mediaConnected->getAct());
}

void WBLASFServiceStub::setMediaConnected(const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data) {
    if(data!=_mediaConnectedProperty.getData()) {
        _mediaConnectedProperty.setData(data);
        ::boost::shared_ptr< MediaConnectedUpdate > obj(new MediaConnectedUpdate(_mediaConnectedProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "MediaConnected", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("mediaConnected", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "MediaConnected", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_mediaConnectedProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& WBLASFServiceStub::getMediaConnected() const {
    return _mediaConnectedProperty.getData();
}


::org::bosch::WBLMlmeTypes::MlmeEventConnect& WBLASFServiceStub::getMediaConnectedMutable() {
    return _mediaConnectedProperty.getDataMutable();
}

void WBLASFServiceStub::sendMediaConnectedNotification() {
    ::boost::shared_ptr< MediaConnectedUpdate > obj(new MediaConnectedUpdate(_mediaConnectedProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "MediaConnected", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("mediaConnected", obj);
}

// property mediaDisconnected

void WBLASFServiceStub::onMediaDisconnectedRegister(bool /*isFirst*/, act_t act) {
    sendMediaDisconnectedUpdate(getMediaDisconnected(), act);
}

void WBLASFServiceStub::onMediaDisconnectedDeregister(bool /*isLast*/, act_t /*act*/) {
}

void WBLASFServiceStub::sendMediaDisconnectedUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data, act_t act) {
    ::boost::shared_ptr< MediaDisconnectedUpdate > obj(new MediaDisconnectedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sUpdate, act=%" PRIuPTR ", stub=%p", "MediaDisconnected", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendRegisterNotify("mediaDisconnected", obj, act);
}

void WBLASFServiceStub::sendMediaDisconnectedGetUpdate(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data, act_t act) {
    ::boost::shared_ptr< MediaDisconnectedUpdate > obj(new MediaDisconnectedUpdate(data));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sGetUpdate, act=%" PRIuPTR ", stub=%p", "MediaDisconnected", act, _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotify("mediaDisconnected", obj, act);
}

void WBLASFServiceStub::onMediaDisconnectedGet(const ::boost::shared_ptr< MediaDisconnectedGet >& mediaDisconnected) {
    sendMediaDisconnectedGetUpdate(getMediaDisconnected(), mediaDisconnected->getAct());
}

void WBLASFServiceStub::setMediaDisconnected(const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data) {
    if(data!=_mediaDisconnectedProperty.getData()) {
        _mediaDisconnectedProperty.setData(data);
        ::boost::shared_ptr< MediaDisconnectedUpdate > obj(new MediaDisconnectedUpdate(_mediaDisconnectedProperty));
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (changed), stub=%p", "MediaDisconnected", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(*obj,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        _cmsStubDelegate->sendNotifyAll("mediaDisconnected", obj);
    } else {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO("-> set%s (not changed), stub=%p", "MediaDisconnected", _cmsStubDelegate->getStub());
            std::string jsonPayload;
            serializeJson(_mediaDisconnectedProperty,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
        LOG_DEBUG ("Data not changed, no notification send");
    }
}

const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& WBLASFServiceStub::getMediaDisconnected() const {
    return _mediaDisconnectedProperty.getData();
}


::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& WBLASFServiceStub::getMediaDisconnectedMutable() {
    return _mediaDisconnectedProperty.getDataMutable();
}

void WBLASFServiceStub::sendMediaDisconnectedNotification() {
    ::boost::shared_ptr< MediaDisconnectedUpdate > obj(new MediaDisconnectedUpdate(_mediaDisconnectedProperty));
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO("-> send%sNotification, stub=%p", "MediaDisconnected", _cmsStubDelegate->getStub());
        std::string jsonPayload;
        serializeJson(*obj,jsonPayload);
        LOG_INFO("payload: %s", jsonPayload.c_str());
    }
    _cmsStubDelegate->sendNotifyAll("mediaDisconnected", obj);
}

} // namespace WBLASFService
} // namespace bosch
} // namespace org
