/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLASFSERVICEPROXY_H
#define ORG_BOSCH_WBLASFSERVICEPROXY_H

#include "asf/cms/CmsProxyDelegate.h"
#include "asf/cms/CmsTypesJson.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/WBLASFService.h"
#include "org/bosch/WBLASFServiceJson.h"
#include "org/bosch/WBLASFServiceProxyStreamerCmsBin.h"
#include "org/bosch/WBLASFServiceProxyStreamerJson.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLRegulatoryTypes.h"
#include <string>

namespace org {
namespace bosch {
namespace WBLASFService {

/**
 * If the meaning of "WBLASFService" isn't clear, then there should be a description here.
 */



class WBLASFServiceProxy;

class StarteventloopCallbackIF
{
public:

    StarteventloopCallbackIF() {}

    virtual ~StarteventloopCallbackIF() {}

    virtual void onStarteventloopResponse(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< StarteventloopResponse >& response) = 0;

    virtual void onStarteventloopError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< StarteventloopError >& error) = 0;
};

class SetpropertyCallbackIF
{
public:

    SetpropertyCallbackIF() {}

    virtual ~SetpropertyCallbackIF() {}

    virtual void onSetpropertyResponse(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< SetpropertyResponse >& response) = 0;

    virtual void onSetpropertyError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< SetpropertyError >& error) = 0;
};

class CurrentRegSettingsRegisterCallbackIF
{
public:
    CurrentRegSettingsRegisterCallbackIF() {}

    virtual ~CurrentRegSettingsRegisterCallbackIF() {}

    virtual void onCurrentRegSettingsUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< CurrentRegSettingsUpdate >& update) = 0;

    virtual void onCurrentRegSettingsRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< CurrentRegSettingsRegisterError >& error) = 0;
};

class CurrentRegSettingsGetCallbackIF
{
public:
    CurrentRegSettingsGetCallbackIF() {}

    virtual ~CurrentRegSettingsGetCallbackIF() {}

    virtual void onCurrentRegSettingsGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< CurrentRegSettingsUpdate >& update) = 0;

    virtual void onCurrentRegSettingsGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< CurrentRegSettingsGetError >& error) = 0;
};

class MediaConnectedRegisterCallbackIF
{
public:
    MediaConnectedRegisterCallbackIF() {}

    virtual ~MediaConnectedRegisterCallbackIF() {}

    virtual void onMediaConnectedUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaConnectedUpdate >& update) = 0;

    virtual void onMediaConnectedRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaConnectedRegisterError >& error) = 0;
};

class MediaConnectedGetCallbackIF
{
public:
    MediaConnectedGetCallbackIF() {}

    virtual ~MediaConnectedGetCallbackIF() {}

    virtual void onMediaConnectedGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaConnectedUpdate >& update) = 0;

    virtual void onMediaConnectedGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaConnectedGetError >& error) = 0;
};

class MediaDisconnectedRegisterCallbackIF
{
public:
    MediaDisconnectedRegisterCallbackIF() {}

    virtual ~MediaDisconnectedRegisterCallbackIF() {}

    virtual void onMediaDisconnectedUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaDisconnectedUpdate >& update) = 0;

    virtual void onMediaDisconnectedRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaDisconnectedRegisterError >& error) = 0;
};

class MediaDisconnectedGetCallbackIF
{
public:
    MediaDisconnectedGetCallbackIF() {}

    virtual ~MediaDisconnectedGetCallbackIF() {}

    virtual void onMediaDisconnectedGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaDisconnectedUpdate >& update) = 0;

    virtual void onMediaDisconnectedGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& proxy, const ::boost::shared_ptr< MediaDisconnectedGetError >& error) = 0;
};

class WBLASFServiceClientBase
:     public CurrentRegSettingsGetCallbackIF,
    public CurrentRegSettingsRegisterCallbackIF,
    public MediaConnectedGetCallbackIF,
    public MediaConnectedRegisterCallbackIF,
    public MediaDisconnectedGetCallbackIF,
    public MediaDisconnectedRegisterCallbackIF,
    public SetpropertyCallbackIF,
    public StarteventloopCallbackIF
{
public:

    virtual ~WBLASFServiceClientBase() {}


    virtual void onStarteventloopResponse(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< StarteventloopResponse >& /*response*/) {
        LOG_FATAL("on%sResponse() is not implemented yet", "Starteventloop");
    }

    virtual void onStarteventloopError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< StarteventloopError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "Starteventloop", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onSetpropertyResponse(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SetpropertyResponse >& /*response*/) {
        LOG_FATAL("on%sResponse() is not implemented yet", "Setproperty");
    }

    virtual void onSetpropertyError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< SetpropertyError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "Setproperty", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onCurrentRegSettingsUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CurrentRegSettingsUpdate >& /*update*/) {
        LOG_FATAL("on%sUpdate is not implemented yet", "CurrentRegSettings");
    }

    virtual void onCurrentRegSettingsRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CurrentRegSettingsRegisterError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "CurrentRegSettingsRegister", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onCurrentRegSettingsGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CurrentRegSettingsUpdate >& /*update*/) {
        LOG_FATAL("on%sGetUpdate is not implemented yet", "CurrentRegSettings");
    }

    virtual void onCurrentRegSettingsGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< CurrentRegSettingsGetError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "CurrentRegSettingsGet", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onMediaConnectedUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaConnectedUpdate >& /*update*/) {
        LOG_FATAL("on%sUpdate is not implemented yet", "MediaConnected");
    }

    virtual void onMediaConnectedRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaConnectedRegisterError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "MediaConnectedRegister", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onMediaConnectedGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaConnectedUpdate >& /*update*/) {
        LOG_FATAL("on%sGetUpdate is not implemented yet", "MediaConnected");
    }

    virtual void onMediaConnectedGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaConnectedGetError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "MediaConnectedGet", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onMediaDisconnectedUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaDisconnectedUpdate >& /*update*/) {
        LOG_FATAL("on%sUpdate is not implemented yet", "MediaDisconnected");
    }

    virtual void onMediaDisconnectedRegisterError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaDisconnectedRegisterError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "MediaDisconnectedRegister", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

    virtual void onMediaDisconnectedGetUpdate(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaDisconnectedUpdate >& /*update*/) {
        LOG_FATAL("on%sGetUpdate is not implemented yet", "MediaDisconnected");
    }

    virtual void onMediaDisconnectedGetError(const ::boost::shared_ptr< WBLASFServiceProxy >& /*proxy*/, const ::boost::shared_ptr< MediaDisconnectedGetError >& error) {
        switch(error->getField()) {
        case ::asf::cms::CmsTypes::BaseError::E_SYSTEM_ERROR:
            LOG_FATAL("on%sError (%s) is not implemented yet", "MediaDisconnectedGet", "E_SYSTEM_ERROR");
            break;
        default:
            break;
        }
    }

private:

    DECLARE_CLASS_LOGGER();
};

/**
 * WBLASFServiceProxy is the client side representation of the
 * 'WBLASFService' Car Multimedia Service. The interface is specified in
 * the file 'WBLASFService.cms'.
 */
class WBLASFServiceProxy : public ::asf::cms::CmsProxy
{
public:

    /**
     * Create a new instance of WBLASFServiceProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     * Additionally it is necessary to pass a reference on a implementation of
     * the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< WBLASFServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of WBLASFServiceProxy. The caller has to pass the
     * port name and the address of the service (e.g.
     * cms-json://localhost:12345). It is only possible to use this function
     * if the port is defined in the CMC model as "wired at runtime"-port.
     * Additionally it is necessary to pass a reference on a implementation of
     * the ServiceAvailableIF interface.
     */
    static ::boost::shared_ptr< WBLASFServiceProxy > createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of WBLASFServiceProxy. The destructor will send messages for
     * all existing property notifications. Additionally it will call the
     * error callback of all pending method invocations.
     */
    virtual ~WBLASFServiceProxy();

    // Request 'starteventloop'

    /**
     * Call the Request 'starteventloop'. This method sends a Request message
     * to the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'starteventloop'</b>:
     *
     * If the meaning of "starteventloop" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStarteventloopRequest(StarteventloopCallbackIF& cb);

    // Request 'setproperty'

    /**
     * Call the Request 'setproperty'. This method sends a Request message to
     * the  CMS (Car Multimedia Service) server.
     *
     * <b>Documentation of 'setproperty'</b>:
     *
     * If the meaning of "setproperty" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Response or Error message
     * is received.
     *
     * @param message If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetpropertyRequest(SetpropertyCallbackIF& cb, const ::std::string& message);

    // Property 'currentRegSettings'

    /**
     * Register the property 'currentRegSettings'. This method sends a
     * Register message to the CMS server.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Update or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentRegSettingsRegister(CurrentRegSettingsRegisterCallbackIF& cb);

    /**
     * Deregister the property 'currentRegSettings'. This method sends a
     * Deregister message to the CMS server.
     *
     * @param act The act which was previously returned by the
     * sendCurrentRegSettingsRegister method.
     *
     * @return true, if a Deregister message was sent, otherwise false
     */
    bool sendCurrentRegSettingsDeregister(act_t act);

    /**
     * Deregister all property registrations on the property
     * 'currentRegSettings'.
     */
    void sendCurrentRegSettingsDeregisterAll();


    /**
     * Request the value of the property 'currentRegSettings' from the CMS
     * server. This method sends a Get message to the CMS server.
     *
     * <b>Documentation of 'currentRegSettings'</b>:
     *
     * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Result or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentRegSettingsGet(CurrentRegSettingsGetCallbackIF& cb);

    /**
     * Returns the current value of the property 'currentRegSettings' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCurrentRegSettings()
     *
     * @return the previously received value of the property
     * 'currentRegSettings'.
     */
    const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& getCurrentRegSettings() const;

    /**
     * Determines whether a status message for the property
     * 'currentRegSettings' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCurrentRegSettings() const;

    // Property 'mediaConnected'

    /**
     * Register the property 'mediaConnected'. This method sends a Register
     * message to the CMS server.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Update or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMediaConnectedRegister(MediaConnectedRegisterCallbackIF& cb);

    /**
     * Deregister the property 'mediaConnected'. This method sends a
     * Deregister message to the CMS server.
     *
     * @param act The act which was previously returned by the
     * sendMediaConnectedRegister method.
     *
     * @return true, if a Deregister message was sent, otherwise false
     */
    bool sendMediaConnectedDeregister(act_t act);

    /**
     * Deregister all property registrations on the property 'mediaConnected'.
     */
    void sendMediaConnectedDeregisterAll();


    /**
     * Request the value of the property 'mediaConnected' from the CMS server.
     * This method sends a Get message to the CMS server.
     *
     * <b>Documentation of 'mediaConnected'</b>:
     *
     * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Result or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMediaConnectedGet(MediaConnectedGetCallbackIF& cb);

    /**
     * Returns the current value of the property 'mediaConnected' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMediaConnected()
     *
     * @return the previously received value of the property 'mediaConnected'.
     */
    const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& getMediaConnected() const;

    /**
     * Determines whether a status message for the property 'mediaConnected'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMediaConnected() const;

    // Property 'mediaDisconnected'

    /**
     * Register the property 'mediaDisconnected'. This method sends a Register
     * message to the CMS server.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Update or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMediaDisconnectedRegister(MediaDisconnectedRegisterCallbackIF& cb);

    /**
     * Deregister the property 'mediaDisconnected'. This method sends a
     * Deregister message to the CMS server.
     *
     * @param act The act which was previously returned by the
     * sendMediaDisconnectedRegister method.
     *
     * @return true, if a Deregister message was sent, otherwise false
     */
    bool sendMediaDisconnectedDeregister(act_t act);

    /**
     * Deregister all property registrations on the property
     * 'mediaDisconnected'.
     */
    void sendMediaDisconnectedDeregisterAll();


    /**
     * Request the value of the property 'mediaDisconnected' from the CMS
     * server. This method sends a Get message to the CMS server.
     *
     * <b>Documentation of 'mediaDisconnected'</b>:
     *
     * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
     *
     * @param cb This callback will be called when a Result or Error message
     * is received.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMediaDisconnectedGet(MediaDisconnectedGetCallbackIF& cb);

    /**
     * Returns the current value of the property 'mediaDisconnected' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMediaDisconnected()
     *
     * @return the previously received value of the property
     * 'mediaDisconnected'.
     */
    const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& getMediaDisconnected() const;

    /**
     * Determines whether a status message for the property
     * 'mediaDisconnected' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMediaDisconnected() const;

    /**
     * Release all property and event notifications.
     */
    void sendDeregisterAll ();

    ::asf::cms::CmsServiceStreamer* getStreamer();

private:

    WBLASFServiceProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);


    static void starteventloopRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    static void setpropertyRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    static void currentRegSettingsPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    ::asf::core::nullable< ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate > _currentRegSettings;

    static void mediaConnectedPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    ::asf::core::nullable< ::org::bosch::WBLMlmeTypes::MlmeEventConnect > _mediaConnected;

    static void mediaDisconnectedPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg);

    ::asf::core::nullable< ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect > _mediaDisconnected;

    WBLASFServiceProxyStreamerJson _streamerJson;

    WBLASFServiceProxyStreamerCmsBin _streamerCmsBin;

    DECLARE_CLASS_LOGGER();
};

} // namespace WBLASFService
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLASFSERVICEPROXY_H
