/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cms/CmsProxyRegistry.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/WBLASFService.h"
#include "org/bosch/WBLASFServiceProxy.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLRegulatoryTypes.h"
#include <string>

namespace org {
namespace bosch {
namespace WBLASFService {

DEFINE_CLASS_LOGGER("/org/bosch/WBLASFService", WBLASFServiceProxy);
DEFINE_CLASS_LOGGER("/org/bosch/WBLASFService", WBLASFServiceClientBase);


// static
::boost::shared_ptr< WBLASFServiceProxy > WBLASFServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cms::CmsProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<WBLASFServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< WBLASFServiceProxy >  proxyNew(new WBLASFServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew);
    return proxyNew;
}

// static
::boost::shared_ptr< WBLASFServiceProxy > WBLASFServiceProxy::createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< WBLASFServiceProxy >  proxyNew(new WBLASFServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew, uriAddress);
    return proxyNew;
}

WBLASFServiceProxy::WBLASFServiceProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    CmsProxy(portName,serviceAvailable, "org.bosch.WBLASFService", _logger) {
    LOG_INFO ("Create proxy=%p, compId=%d, portName='%s'", this, _cmsProxyDelegate.getClientComponentId(), getPortName().c_str());
}

WBLASFServiceProxy::~WBLASFServiceProxy () {
    ::asf::cms::CmsProxyRegistry::getInstance().deregisterProxy(_cmsProxyDelegate.getProxyId());
}

void WBLASFServiceProxy::sendDeregisterAll () {
    sendCurrentRegSettingsDeregisterAll();
    sendMediaConnectedDeregisterAll();
    sendMediaDisconnectedDeregisterAll();
}

act_t WBLASFServiceProxy::sendStarteventloopRequest(StarteventloopCallbackIF& cb) {
    ::boost::shared_ptr< StarteventloopRequest > para(new StarteventloopRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"starteventloop",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)starteventloopRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "Starteventloop", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WBLASFServiceProxy::sendSetpropertyRequest(SetpropertyCallbackIF& cb, const ::std::string& message) {
    ::boost::shared_ptr< SetpropertyRequest > para(new SetpropertyRequest(message));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"setproperty",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)setpropertyRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "Setproperty", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

// Property 'currentRegSettings'

act_t WBLASFServiceProxy::sendCurrentRegSettingsRegister(CurrentRegSettingsRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"currentRegSettings",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)currentRegSettingsPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentRegSettings", &cb, regId);
    }
    return regId;
}

bool WBLASFServiceProxy::sendCurrentRegSettingsDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "currentRegSettings")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"currentRegSettings",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "CurrentRegSettings", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "CurrentRegSettings", act);
        return false;
    }
    return true;
}

void WBLASFServiceProxy::sendCurrentRegSettingsDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("currentRegSettings");
}

act_t WBLASFServiceProxy::sendCurrentRegSettingsGet(CurrentRegSettingsGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"currentRegSettings",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)currentRegSettingsPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "CurrentRegSettings", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& WBLASFServiceProxy::getCurrentRegSettings() const {
    return _currentRegSettings.get();
}

bool WBLASFServiceProxy::hasCurrentRegSettings() const {
    return _currentRegSettings.hasValue();
}

// Property 'mediaConnected'

act_t WBLASFServiceProxy::sendMediaConnectedRegister(MediaConnectedRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"mediaConnected",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)mediaConnectedPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MediaConnected", &cb, regId);
    }
    return regId;
}

bool WBLASFServiceProxy::sendMediaConnectedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "mediaConnected")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"mediaConnected",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "MediaConnected", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "MediaConnected", act);
        return false;
    }
    return true;
}

void WBLASFServiceProxy::sendMediaConnectedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("mediaConnected");
}

act_t WBLASFServiceProxy::sendMediaConnectedGet(MediaConnectedGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"mediaConnected",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)mediaConnectedPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "MediaConnected", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& WBLASFServiceProxy::getMediaConnected() const {
    return _mediaConnected.get();
}

bool WBLASFServiceProxy::hasMediaConnected() const {
    return _mediaConnected.hasValue();
}

// Property 'mediaDisconnected'

act_t WBLASFServiceProxy::sendMediaDisconnectedRegister(MediaDisconnectedRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"mediaDisconnected",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)mediaDisconnectedPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MediaDisconnected", &cb, regId);
    }
    return regId;
}

bool WBLASFServiceProxy::sendMediaDisconnectedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "mediaDisconnected")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"mediaDisconnected",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "MediaDisconnected", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "MediaDisconnected", act);
        return false;
    }
    return true;
}

void WBLASFServiceProxy::sendMediaDisconnectedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("mediaDisconnected");
}

act_t WBLASFServiceProxy::sendMediaDisconnectedGet(MediaDisconnectedGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"mediaDisconnected",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)mediaDisconnectedPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "MediaDisconnected", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& WBLASFServiceProxy::getMediaDisconnected() const {
    return _mediaDisconnected.get();
}

bool WBLASFServiceProxy::hasMediaDisconnected() const {
    return _mediaDisconnected.hasValue();
}

::asf::cms::CmsServiceStreamer* WBLASFServiceProxy::getStreamer() {
    ::asf::cms::CmsServiceStreamer* streamer=0;
    switch(_cmsProxyDelegate.getEncoding()) {
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json:
            streamer=&_streamerJson;
            break;
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__FastBin:
            streamer=&_streamerCmsBin;
            break;
        default:
            streamer=0;
            break;
    }
    return streamer;
}

// static
void WBLASFServiceProxy::starteventloopRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    StarteventloopCallbackIF* pcb = static_cast< StarteventloopCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WBLASFServiceProxy >& proxyShared = ::boost::static_pointer_cast< WBLASFServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< StarteventloopResponse > payload = ::boost::static_pointer_cast< StarteventloopResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Starteventloop", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onStarteventloopResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< StarteventloopError > error(new StarteventloopError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< StarteventloopError > error = ::boost::static_pointer_cast< StarteventloopError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Starteventloop", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onStarteventloopError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WBLASFServiceProxy::setpropertyRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    SetpropertyCallbackIF* pcb = static_cast< SetpropertyCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WBLASFServiceProxy >& proxyShared = ::boost::static_pointer_cast< WBLASFServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< SetpropertyResponse > payload = ::boost::static_pointer_cast< SetpropertyResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Setproperty", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onSetpropertyResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SetpropertyError > error(new SetpropertyError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SetpropertyError > error = ::boost::static_pointer_cast< SetpropertyError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Setproperty", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSetpropertyError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WBLASFServiceProxy::currentRegSettingsPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WBLASFServiceProxy >& proxyShared = ::boost::static_pointer_cast< WBLASFServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< CurrentRegSettingsUpdate > update = ::boost::static_pointer_cast< CurrentRegSettingsUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_currentRegSettings = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentRegSettings", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            CurrentRegSettingsRegisterCallbackIF* pcb = static_cast< CurrentRegSettingsRegisterCallbackIF* >(callbackIf);
            pcb->onCurrentRegSettingsUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            CurrentRegSettingsGetCallbackIF* pcb = static_cast< CurrentRegSettingsGetCallbackIF* >(callbackIf);
            pcb->onCurrentRegSettingsGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        CurrentRegSettingsRegisterCallbackIF* pcb = static_cast< CurrentRegSettingsRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CurrentRegSettingsRegisterError > error(new CurrentRegSettingsRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CurrentRegSettingsRegisterError > error = ::boost::static_pointer_cast< CurrentRegSettingsRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentRegSettings", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCurrentRegSettingsRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        CurrentRegSettingsGetCallbackIF* pcb = static_cast< CurrentRegSettingsGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CurrentRegSettingsGetError > error(new CurrentRegSettingsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CurrentRegSettingsGetError > error = ::boost::static_pointer_cast< CurrentRegSettingsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentRegSettings", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCurrentRegSettingsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WBLASFServiceProxy::mediaConnectedPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WBLASFServiceProxy >& proxyShared = ::boost::static_pointer_cast< WBLASFServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< MediaConnectedUpdate > update = ::boost::static_pointer_cast< MediaConnectedUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_mediaConnected = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaConnected", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            MediaConnectedRegisterCallbackIF* pcb = static_cast< MediaConnectedRegisterCallbackIF* >(callbackIf);
            pcb->onMediaConnectedUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            MediaConnectedGetCallbackIF* pcb = static_cast< MediaConnectedGetCallbackIF* >(callbackIf);
            pcb->onMediaConnectedGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        MediaConnectedRegisterCallbackIF* pcb = static_cast< MediaConnectedRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MediaConnectedRegisterError > error(new MediaConnectedRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MediaConnectedRegisterError > error = ::boost::static_pointer_cast< MediaConnectedRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaConnected", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMediaConnectedRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        MediaConnectedGetCallbackIF* pcb = static_cast< MediaConnectedGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MediaConnectedGetError > error(new MediaConnectedGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MediaConnectedGetError > error = ::boost::static_pointer_cast< MediaConnectedGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaConnected", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMediaConnectedGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WBLASFServiceProxy::mediaDisconnectedPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WBLASFServiceProxy >& proxyShared = ::boost::static_pointer_cast< WBLASFServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< MediaDisconnectedUpdate > update = ::boost::static_pointer_cast< MediaDisconnectedUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_mediaDisconnected = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaDisconnected", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            MediaDisconnectedRegisterCallbackIF* pcb = static_cast< MediaDisconnectedRegisterCallbackIF* >(callbackIf);
            pcb->onMediaDisconnectedUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            MediaDisconnectedGetCallbackIF* pcb = static_cast< MediaDisconnectedGetCallbackIF* >(callbackIf);
            pcb->onMediaDisconnectedGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        MediaDisconnectedRegisterCallbackIF* pcb = static_cast< MediaDisconnectedRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MediaDisconnectedRegisterError > error(new MediaDisconnectedRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MediaDisconnectedRegisterError > error = ::boost::static_pointer_cast< MediaDisconnectedRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaDisconnected", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMediaDisconnectedRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        MediaDisconnectedGetCallbackIF* pcb = static_cast< MediaDisconnectedGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MediaDisconnectedGetError > error(new MediaDisconnectedGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MediaDisconnectedGetError > error = ::boost::static_pointer_cast< MediaDisconnectedGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MediaDisconnected", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMediaDisconnectedGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

} // namespace WBLASFService
} // namespace bosch
} // namespace org
