#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_WBLASFSERVICE_H
#define ORG_BOSCH_WBLASFSERVICE_H

#include "asf/cms/CmsTypes.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "org/bosch/WBLMlmeTypes.h"
#include "org/bosch/WBLRegulatoryTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "WBLASFService" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace WBLASFService {

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

static const int STARTEVENTLOOP__ID = 1968793116;

static const int SETPROPERTY__ID = 931534903;

static const int CURRENT_REG_SETTINGS__ID = -2128348770;

static const int MEDIA_CONNECTED__ID = 1024607109;

static const int MEDIA_DISCONNECTED__ID = 732412991;

// forward declarations
class SetpropertyRequest;

class SetpropertyResponse;

class CurrentRegSettingsUpdate;

class MediaConnectedUpdate;

class MediaDisconnectedUpdate;

// type definitions
/**
 * If the meaning of "starteventloop" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::DefaultMessage StarteventloopRequest;

/**
 * If the meaning of "starteventloop" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::DefaultMessage StarteventloopResponse;

/**
 * If the meaning of "starteventloop" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError StarteventloopError;

/**
 * If the meaning of "setproperty" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError SetpropertyError;

/**
 * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::DefaultMessage CurrentRegSettingsGet;

/**
 * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError CurrentRegSettingsRegisterError;

/**
 * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError CurrentRegSettingsGetError;

/**
 * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::DefaultMessage MediaConnectedGet;

/**
 * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError MediaConnectedRegisterError;

/**
 * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError MediaConnectedGetError;

/**
 * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::DefaultMessage MediaDisconnectedGet;

/**
 * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError MediaDisconnectedRegisterError;

/**
 * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
 */
typedef ::asf::cms::CmsTypes::BaseError MediaDisconnectedGetError;


/**
 * If the meaning of "setproperty" isn't clear, then there should be a description here.
 */
class SetpropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetpropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetpropertyRequest (const SetpropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetpropertyRequest (const ::std::string& message_);

    /**
     * Destructor
     */
    inline virtual  ~SetpropertyRequest();

    /**
     * Assignment operator
     */
    inline SetpropertyRequest& operator = (const SetpropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetpropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetpropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetpropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetpropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "message"

    static const int kMessage = 0;

    /**
     * Clears the field "message".
     *
     * The field will be set to its default value. The hasMessage()
     * method will return false.
     */
    inline void clearMessage();

    /**
     * Checks whether the field "message" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMessage()). Otherwise it will return false.
     */
    inline bool hasMessage () const;

    /**
     * Returns the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @return The value of the field "message"
     */
    inline const ::std::string& getMessage () const;

    /**
     * Retrieves the value of the field "message" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "message".
     */
    inline ::std::string& getMessageMutable ();

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const ::std::string& message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* message_);

    /**
     * Sets the value of the member "message".
     *
     * If the meaning of "message" isn't clear, then there should be a description here.
     *
     * @param message The value which will be set
     */
    inline void setMessage (const char* value, size_t size);

    /**
     * Release the object stored in the field "message".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "message"
     */
    inline ::std::string* releaseMessage();

    /**
     * Replace the field "message".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMessage (::std::string* message_);

    static const SetpropertyRequest &getDefaultInstance();

private:

    inline void set_has_message ();

    inline void clear_has_message ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _message;

};

/**
 * If the meaning of "setproperty" isn't clear, then there should be a description here.
 */
class SetpropertyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetpropertyResponse ();

    /**
     * Copy constructor
     */
    inline  SetpropertyResponse (const SetpropertyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetpropertyResponse (bool data_);

    /**
     * Destructor
     */
    inline virtual  ~SetpropertyResponse();

    /**
     * Assignment operator
     */
    inline SetpropertyResponse& operator = (const SetpropertyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetpropertyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetpropertyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetpropertyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetpropertyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline bool getData () const;

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (bool data_);

    static const SetpropertyResponse &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _data;

};

/**
 * If the meaning of "currentRegSettings" isn't clear, then there should be a description here.
 */
class CurrentRegSettingsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentRegSettingsUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentRegSettingsUpdate (const CurrentRegSettingsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentRegSettingsUpdate (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentRegSettingsUpdate();

    /**
     * Assignment operator
     */
    inline CurrentRegSettingsUpdate& operator = (const CurrentRegSettingsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentRegSettingsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentRegSettingsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentRegSettingsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentRegSettingsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data_);

    /**
     * Release the object stored in the field "data".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "data"
     */
    inline ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* releaseData();

    /**
     * Replace the field "data".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceData (::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* data_);

    static const CurrentRegSettingsUpdate &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* _data;

};

/**
 * If the meaning of "mediaConnected" isn't clear, then there should be a description here.
 */
class MediaConnectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaConnectedUpdate ();

    /**
     * Copy constructor
     */
    inline  MediaConnectedUpdate (const MediaConnectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MediaConnectedUpdate (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data_);

    /**
     * Destructor
     */
    inline virtual  ~MediaConnectedUpdate();

    /**
     * Assignment operator
     */
    inline MediaConnectedUpdate& operator = (const MediaConnectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaConnectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaConnectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaConnectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaConnectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::org::bosch::WBLMlmeTypes::MlmeEventConnect& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data_);

    /**
     * Release the object stored in the field "data".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "data"
     */
    inline ::org::bosch::WBLMlmeTypes::MlmeEventConnect* releaseData();

    /**
     * Replace the field "data".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceData (::org::bosch::WBLMlmeTypes::MlmeEventConnect* data_);

    static const MediaConnectedUpdate &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::bosch::WBLMlmeTypes::MlmeEventConnect* _data;

};

/**
 * If the meaning of "mediaDisconnected" isn't clear, then there should be a description here.
 */
class MediaDisconnectedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaDisconnectedUpdate ();

    /**
     * Copy constructor
     */
    inline  MediaDisconnectedUpdate (const MediaDisconnectedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MediaDisconnectedUpdate (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data_);

    /**
     * Destructor
     */
    inline virtual  ~MediaDisconnectedUpdate();

    /**
     * Assignment operator
     */
    inline MediaDisconnectedUpdate& operator = (const MediaDisconnectedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaDisconnectedUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaDisconnectedUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaDisconnectedUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaDisconnectedUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data_);

    /**
     * Release the object stored in the field "data".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "data"
     */
    inline ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* releaseData();

    /**
     * Replace the field "data".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceData (::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* data_);

    static const MediaDisconnectedUpdate &getDefaultInstance();

private:

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* _data;

};

inline  SetpropertyRequest::SetpropertyRequest ()  :
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetpropertyRequest::SetpropertyRequest (const SetpropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _message (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetpropertyRequest::SetpropertyRequest (const ::std::string& message_)  :
    _message (new ::std::string(message_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetpropertyRequest::~SetpropertyRequest() {
    delete _message;
}

inline SetpropertyRequest& SetpropertyRequest::operator = (const SetpropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMessage()) {
            setMessage(rhs.getMessage());
        } else {
            clearMessage();
        }
    }
    return *this;
}

inline bool SetpropertyRequest::operator == (const SetpropertyRequest& rhs) const {
    return (((!hasMessage() && !rhs.hasMessage()) || getMessage() == rhs.getMessage()));
}

inline bool SetpropertyRequest::operator != (const SetpropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetpropertyRequest::operator < (const SetpropertyRequest& rhs) const {
    if (hasMessage() || rhs.hasMessage()) {
        if (getMessage() < rhs.getMessage()) return true;
        if (getMessage() > rhs.getMessage()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetpropertyRequest::clone() {
    return new SetpropertyRequest(*this);
}

inline bool SetpropertyRequest::operator > (const SetpropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetpropertyRequest::clear() {
    clearMessage();
}

inline void SetpropertyRequest::clearMessage() {
    if (hasMessage()) {
         clear_has_message();
        if (_message != NULL) {
            _message->clear();
        }
     }
}

inline bool SetpropertyRequest::hasMessage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetpropertyRequest::getMessage () const {
    if (_message == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_message;
}

inline ::std::string& SetpropertyRequest::getMessageMutable () {
    set_has_message();
    if (_message == NULL) {
        _message = new ::std::string ();
        CHECK_ALLOCATION( _message );
    }
    return *_message;
}

inline void SetpropertyRequest::setMessage (const ::std::string& message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (message_);
        CHECK_ALLOCATION( this->_message );
    } else {
        *this->_message = message_;
    }
}

inline void SetpropertyRequest::setMessage (const char* message_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (message_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (message_);
        CHECK_ALLOCATION( this->_message );
    } else {
        this->_message->assign(message_);
    }
}

inline void SetpropertyRequest::setMessage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_message();
    if (this->_message == NULL) {
        this->_message = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_message );
    } else {
        this->_message->assign(value, size);
    }
}

inline ::std::string* SetpropertyRequest::releaseMessage() {
    clear_has_message();
    ::std::string* temp = _message;
    this->_message = NULL;
    return temp;
}

inline void SetpropertyRequest::replaceMessage (::std::string* message_) {
    set_has_message();
    if (this->_message != message_) {
        if (this->_message != NULL) {
            delete this->_message;
        }
        this->_message = message_;
    }
}

inline void SetpropertyRequest::set_has_message () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetpropertyRequest::clear_has_message () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetpropertyResponse::SetpropertyResponse ()  :
    _data (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetpropertyResponse::SetpropertyResponse (const SetpropertyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _data (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetpropertyResponse::SetpropertyResponse (bool data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetpropertyResponse::~SetpropertyResponse() {
}

inline SetpropertyResponse& SetpropertyResponse::operator = (const SetpropertyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool SetpropertyResponse::operator == (const SetpropertyResponse& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool SetpropertyResponse::operator != (const SetpropertyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SetpropertyResponse::operator < (const SetpropertyResponse& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetpropertyResponse::clone() {
    return new SetpropertyResponse(*this);
}

inline bool SetpropertyResponse::operator > (const SetpropertyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetpropertyResponse::clear() {
    clearData();
}

inline void SetpropertyResponse::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = false;
     }
}

inline bool SetpropertyResponse::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetpropertyResponse::getData () const {
    return _data;
}

inline void SetpropertyResponse::setData (bool data_) {
    set_has_data();
    this->_data = data_;
}

inline void SetpropertyResponse::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetpropertyResponse::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentRegSettingsUpdate::CurrentRegSettingsUpdate ()  :
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentRegSettingsUpdate::CurrentRegSettingsUpdate (const CurrentRegSettingsUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentRegSettingsUpdate::CurrentRegSettingsUpdate (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data_)  :
    _data (new ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate(data_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentRegSettingsUpdate::~CurrentRegSettingsUpdate() {
    delete _data;
}

inline CurrentRegSettingsUpdate& CurrentRegSettingsUpdate::operator = (const CurrentRegSettingsUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool CurrentRegSettingsUpdate::operator == (const CurrentRegSettingsUpdate& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool CurrentRegSettingsUpdate::operator != (const CurrentRegSettingsUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentRegSettingsUpdate::operator < (const CurrentRegSettingsUpdate& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentRegSettingsUpdate::clone() {
    return new CurrentRegSettingsUpdate(*this);
}

inline bool CurrentRegSettingsUpdate::operator > (const CurrentRegSettingsUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentRegSettingsUpdate::clear() {
    clearData();
}

inline void CurrentRegSettingsUpdate::clearData() {
    if (hasData()) {
         clear_has_data();
        if (_data != NULL) {
            _data->clear();
        }
     }
}

inline bool CurrentRegSettingsUpdate::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& CurrentRegSettingsUpdate::getData () const {
    if (_data == NULL) {
        return ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate::getDefaultInstance();
    }
    return *_data;
}

inline ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& CurrentRegSettingsUpdate::getDataMutable () {
    set_has_data();
    if (_data == NULL) {
        _data = new ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate ();
        CHECK_ALLOCATION( _data );
    }
    return *_data;
}

inline void CurrentRegSettingsUpdate::setData (const ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate& data_) {
    set_has_data();
    if (this->_data == NULL) {
        this->_data = new ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate (data_);
        CHECK_ALLOCATION( this->_data );
    } else {
        *this->_data = data_;
    }
}

inline ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* CurrentRegSettingsUpdate::releaseData() {
    clear_has_data();
    ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* temp = _data;
    this->_data = NULL;
    return temp;
}

inline void CurrentRegSettingsUpdate::replaceData (::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate* data_) {
    set_has_data();
    if (this->_data != data_) {
        if (this->_data != NULL) {
            delete this->_data;
        }
        this->_data = data_;
    }
}

inline void CurrentRegSettingsUpdate::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentRegSettingsUpdate::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MediaConnectedUpdate::MediaConnectedUpdate ()  :
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MediaConnectedUpdate::MediaConnectedUpdate (const MediaConnectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MediaConnectedUpdate::MediaConnectedUpdate (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data_)  :
    _data (new ::org::bosch::WBLMlmeTypes::MlmeEventConnect(data_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MediaConnectedUpdate::~MediaConnectedUpdate() {
    delete _data;
}

inline MediaConnectedUpdate& MediaConnectedUpdate::operator = (const MediaConnectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool MediaConnectedUpdate::operator == (const MediaConnectedUpdate& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool MediaConnectedUpdate::operator != (const MediaConnectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MediaConnectedUpdate::operator < (const MediaConnectedUpdate& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MediaConnectedUpdate::clone() {
    return new MediaConnectedUpdate(*this);
}

inline bool MediaConnectedUpdate::operator > (const MediaConnectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MediaConnectedUpdate::clear() {
    clearData();
}

inline void MediaConnectedUpdate::clearData() {
    if (hasData()) {
         clear_has_data();
        if (_data != NULL) {
            _data->clear();
        }
     }
}

inline bool MediaConnectedUpdate::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& MediaConnectedUpdate::getData () const {
    if (_data == NULL) {
        return ::org::bosch::WBLMlmeTypes::MlmeEventConnect::getDefaultInstance();
    }
    return *_data;
}

inline ::org::bosch::WBLMlmeTypes::MlmeEventConnect& MediaConnectedUpdate::getDataMutable () {
    set_has_data();
    if (_data == NULL) {
        _data = new ::org::bosch::WBLMlmeTypes::MlmeEventConnect ();
        CHECK_ALLOCATION( _data );
    }
    return *_data;
}

inline void MediaConnectedUpdate::setData (const ::org::bosch::WBLMlmeTypes::MlmeEventConnect& data_) {
    set_has_data();
    if (this->_data == NULL) {
        this->_data = new ::org::bosch::WBLMlmeTypes::MlmeEventConnect (data_);
        CHECK_ALLOCATION( this->_data );
    } else {
        *this->_data = data_;
    }
}

inline ::org::bosch::WBLMlmeTypes::MlmeEventConnect* MediaConnectedUpdate::releaseData() {
    clear_has_data();
    ::org::bosch::WBLMlmeTypes::MlmeEventConnect* temp = _data;
    this->_data = NULL;
    return temp;
}

inline void MediaConnectedUpdate::replaceData (::org::bosch::WBLMlmeTypes::MlmeEventConnect* data_) {
    set_has_data();
    if (this->_data != data_) {
        if (this->_data != NULL) {
            delete this->_data;
        }
        this->_data = data_;
    }
}

inline void MediaConnectedUpdate::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void MediaConnectedUpdate::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MediaDisconnectedUpdate::MediaDisconnectedUpdate ()  :
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MediaDisconnectedUpdate::MediaDisconnectedUpdate (const MediaDisconnectedUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _data (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MediaDisconnectedUpdate::MediaDisconnectedUpdate (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data_)  :
    _data (new ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect(data_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MediaDisconnectedUpdate::~MediaDisconnectedUpdate() {
    delete _data;
}

inline MediaDisconnectedUpdate& MediaDisconnectedUpdate::operator = (const MediaDisconnectedUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool MediaDisconnectedUpdate::operator == (const MediaDisconnectedUpdate& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool MediaDisconnectedUpdate::operator != (const MediaDisconnectedUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool MediaDisconnectedUpdate::operator < (const MediaDisconnectedUpdate& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MediaDisconnectedUpdate::clone() {
    return new MediaDisconnectedUpdate(*this);
}

inline bool MediaDisconnectedUpdate::operator > (const MediaDisconnectedUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MediaDisconnectedUpdate::clear() {
    clearData();
}

inline void MediaDisconnectedUpdate::clearData() {
    if (hasData()) {
         clear_has_data();
        if (_data != NULL) {
            _data->clear();
        }
     }
}

inline bool MediaDisconnectedUpdate::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& MediaDisconnectedUpdate::getData () const {
    if (_data == NULL) {
        return ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect::getDefaultInstance();
    }
    return *_data;
}

inline ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& MediaDisconnectedUpdate::getDataMutable () {
    set_has_data();
    if (_data == NULL) {
        _data = new ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect ();
        CHECK_ALLOCATION( _data );
    }
    return *_data;
}

inline void MediaDisconnectedUpdate::setData (const ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect& data_) {
    set_has_data();
    if (this->_data == NULL) {
        this->_data = new ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect (data_);
        CHECK_ALLOCATION( this->_data );
    } else {
        *this->_data = data_;
    }
}

inline ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* MediaDisconnectedUpdate::releaseData() {
    clear_has_data();
    ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* temp = _data;
    this->_data = NULL;
    return temp;
}

inline void MediaDisconnectedUpdate::replaceData (::org::bosch::WBLMlmeTypes::MlmeEventDisconnect* data_) {
    set_has_data();
    if (this->_data != data_) {
        if (this->_data != NULL) {
            delete this->_data;
        }
        this->_data = data_;
    }
}

inline void MediaDisconnectedUpdate::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void MediaDisconnectedUpdate::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace WBLASFService
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_WBLASFSERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
