/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Stub/WapdmanServiceTypes.h"
#include "Stub/WapdmanServiceTypesJson.h"
#include "Stub/WapdmanServiceTypesJsonPrivate.h"
#include "asf/stream/json.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstdlib>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "StructAPList"

void serializeJson (const ::Stub::WapdmanServiceTypes::StructAPList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasObjPath()) {
        yajl_gen_string(g, (const unsigned char*)  "objPath" , 7);
        const char *s = value.getObjPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "Address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInterface()) {
        yajl_gen_string(g, (const unsigned char*)  "interface" , 9);
        const char *s = value.getInterface().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSSID()) {
        yajl_gen_string(g, (const unsigned char*)  "SSID" , 4);
        const char *s = value.getSSID().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPowered()) {
        yajl_gen_string(g, (const unsigned char*)  "Powered" , 7);
        yajl_gen_bool(g, (bool)value.getPowered());
    }
    if (!isSparse || value.hasHidden()) {
        yajl_gen_string(g, (const unsigned char*)  "Hidden" , 6);
        yajl_gen_bool(g, (bool)value.getHidden());
    }
    if (!isSparse || value.hasSecurity()) {
        yajl_gen_string(g, (const unsigned char*)  "security" , 8);
        const char *s = value.getSecurity().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPassphrase()) {
        yajl_gen_string(g, (const unsigned char*)  "Passphrase" , 10);
        const char *s = value.getPassphrase().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCurrentOperatingChannel()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentOperatingChannel" , 23);
        yajl_gen_integer(g, (long long)value.getCurrentOperatingChannel());
    }
    if (!isSparse || value.hasSupportedChannels()) {
        yajl_gen_string(g, (const unsigned char*)  "SupportedChannels" , 17);
        const char *s = value.getSupportedChannels().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHWFeatures()) {
        yajl_gen_string(g, (const unsigned char*)  "HWFeatures" , 10);
        const char *s = value.getHWFeatures().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMaximumStationsAllowed()) {
        yajl_gen_string(g, (const unsigned char*)  "MaximumStationsAllowed" , 22);
        yajl_gen_integer(g, (long long)value.getMaximumStationsAllowed());
    }
    if (!isSparse || value.hasPowerState()) {
        yajl_gen_string(g, (const unsigned char*)  "PowerState" , 10);
        const char *s = value.getPowerState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPowerFailureReason()) {
        yajl_gen_string(g, (const unsigned char*)  "PowerFailureReason" , 18);
        const char *s = value.getPowerFailureReason().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCurrentHwMode()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentHwMode" , 13);
        const char *s = value.getCurrentHwMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::StructAPList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::StructAPList& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserStructAPList", jsonParser__Stub__WapdmanServiceTypes__StructAPList, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForStructAPList (char *s, size_t length)
{
    static stringEntry entries[] = {
        {4,"SSID", 7},
        {6,"HIDDEN", 11},
        {7,"ADDRESS", 3},
        {7,"OBJPATH", 1},
        {7,"POWERED", 9},
        {8,"SECURITY", 13},
        {9,"INTERFACE", 5},
        {10,"HWFEATURES", 21},
        {10,"PASSPHRASE", 15},
        {10,"POWERSTATE", 25},
        {13,"CURRENTHWMODE", 29},
        {17,"SUPPORTEDCHANNELS", 19},
        {18,"POWERFAILUREREASON", 27},
        {22,"MAXIMUMSTATIONSALLOWED", 23},
        {23,"CURRENTOPERATINGCHANNEL", 17},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 15, value))
        return (int)value;
    else
        return 30;
}

static int processMapKeyForStructAPList (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForStructAPList(s, length);
    if (i != 30 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__StructAPList(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_OBJPATH,
        KEY_OBJPATH,
        INIT_KEY_ADDRESS,
        KEY_ADDRESS,
        INIT_KEY_INTERFACE,
        KEY_INTERFACE,
        INIT_KEY_SSID,
        KEY_SSID,
        INIT_KEY_POWERED,
        KEY_POWERED,
        INIT_KEY_HIDDEN,
        KEY_HIDDEN,
        INIT_KEY_SECURITY,
        KEY_SECURITY,
        INIT_KEY_PASSPHRASE,
        KEY_PASSPHRASE,
        INIT_KEY_CURRENTOPERATINGCHANNEL,
        KEY_CURRENTOPERATINGCHANNEL,
        INIT_KEY_SUPPORTEDCHANNELS,
        KEY_SUPPORTEDCHANNELS,
        INIT_KEY_HWFEATURES,
        KEY_HWFEATURES,
        INIT_KEY_MAXIMUMSTATIONSALLOWED,
        KEY_MAXIMUMSTATIONSALLOWED,
        INIT_KEY_POWERSTATE,
        KEY_POWERSTATE,
        INIT_KEY_POWERFAILUREREASON,
        KEY_POWERFAILUREREASON,
        INIT_KEY_CURRENTHWMODE,
        KEY_CURRENTHWMODE,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "objPath", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceObjPath(t);
                setState (context, INIT_KEY_ADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "Address", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceAddress(t);
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "interface", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceInterface(t);
                setState (context, INIT_KEY_SSID);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_SSID:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "SSID", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SSID:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceSSID(t);
                setState (context, INIT_KEY_POWERED);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "Powered", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_POWERED:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->setPowered(t);
                setState (context, INIT_KEY_HIDDEN);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "Hidden", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HIDDEN:
        switch (event) {
        case PARSER_EVENT__BOOLEAN:
            {
                bool t = p1 != NULL;
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->setHidden(t);
                setState (context, INIT_KEY_SECURITY);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "security", 13) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SECURITY:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceSecurity(t);
                setState (context, INIT_KEY_PASSPHRASE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "Passphrase", 15) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_PASSPHRASE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replacePassphrase(t);
                setState (context, INIT_KEY_CURRENTOPERATINGCHANNEL);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CURRENTOPERATINGCHANNEL:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "CurrentOperatingChannel", 17) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CURRENTOPERATINGCHANNEL:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->setCurrentOperatingChannel(t);
                    setState (context, INIT_KEY_SUPPORTEDCHANNELS);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_SUPPORTEDCHANNELS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "SupportedChannels", 19) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_SUPPORTEDCHANNELS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceSupportedChannels(t);
                setState (context, INIT_KEY_HWFEATURES);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_HWFEATURES:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "HWFeatures", 21) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HWFEATURES:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceHWFeatures(t);
                setState (context, INIT_KEY_MAXIMUMSTATIONSALLOWED);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MAXIMUMSTATIONSALLOWED:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "MaximumStationsAllowed", 23) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MAXIMUMSTATIONSALLOWED:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->setMaximumStationsAllowed(t);
                    setState (context, INIT_KEY_POWERSTATE);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_POWERSTATE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "PowerState", 25) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_POWERSTATE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replacePowerState(t);
                setState (context, INIT_KEY_POWERFAILUREREASON);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_POWERFAILUREREASON:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "PowerFailureReason", 27) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_POWERFAILUREREASON:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replacePowerFailureReason(t);
                setState (context, INIT_KEY_CURRENTHWMODE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CURRENTHWMODE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAPList (context, (char*) p1, (size_t) p2, "CurrentHwMode", 29) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CURRENTHWMODE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAPList*) parser.object)->replaceCurrentHwMode(t);
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "StructASList"

void serializeJson (const ::Stub::WapdmanServiceTypes::StructASList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasObjPath()) {
        yajl_gen_string(g, (const unsigned char*)  "objPath" , 7);
        const char *s = value.getObjPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAccesspoint()) {
        yajl_gen_string(g, (const unsigned char*)  "Accesspoint" , 11);
        const char *s = value.getAccesspoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMacAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "MacAddress" , 10);
        const char *s = value.getMacAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInterface()) {
        yajl_gen_string(g, (const unsigned char*)  "Interface" , 9);
        const char *s = value.getInterface().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIPAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "IPAddress" , 9);
        const char *s = value.getIPAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHostname()) {
        yajl_gen_string(g, (const unsigned char*)  "Hostname" , 8);
        const char *s = value.getHostname().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::StructASList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::StructASList& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserStructASList", jsonParser__Stub__WapdmanServiceTypes__StructASList, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForStructASList (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"OBJPATH", 1},
        {8,"HOSTNAME", 11},
        {9,"INTERFACE", 7},
        {9,"IPADDRESS", 9},
        {10,"MACADDRESS", 5},
        {11,"ACCESSPOINT", 3},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 6, value))
        return (int)value;
    else
        return 12;
}

static int processMapKeyForStructASList (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForStructASList(s, length);
    if (i != 12 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__StructASList(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_OBJPATH,
        KEY_OBJPATH,
        INIT_KEY_ACCESSPOINT,
        KEY_ACCESSPOINT,
        INIT_KEY_MACADDRESS,
        KEY_MACADDRESS,
        INIT_KEY_INTERFACE,
        KEY_INTERFACE,
        INIT_KEY_IPADDRESS,
        KEY_IPADDRESS,
        INIT_KEY_HOSTNAME,
        KEY_HOSTNAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "objPath", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceObjPath(t);
                setState (context, INIT_KEY_ACCESSPOINT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "Accesspoint", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceAccesspoint(t);
                setState (context, INIT_KEY_MACADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "MacAddress", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceMacAddress(t);
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "Interface", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceInterface(t);
                setState (context, INIT_KEY_IPADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IPADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "IPAddress", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IPADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceIPAddress(t);
                setState (context, INIT_KEY_HOSTNAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_HOSTNAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructASList (context, (char*) p1, (size_t) p2, "Hostname", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HOSTNAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructASList*) parser.object)->replaceHostname(t);
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "StructAssociatedStationsChanged"

void serializeJson (const ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasObjPath()) {
        yajl_gen_string(g, (const unsigned char*)  "objPath" , 7);
        const char *s = value.getObjPath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMacAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "MacAddress" , 10);
        const char *s = value.getMacAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAccesspoint()) {
        yajl_gen_string(g, (const unsigned char*)  "Accesspoint" , 11);
        const char *s = value.getAccesspoint().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasInterface()) {
        yajl_gen_string(g, (const unsigned char*)  "Interface" , 9);
        const char *s = value.getInterface().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIPAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "IPAddress" , 9);
        const char *s = value.getIPAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHostname()) {
        yajl_gen_string(g, (const unsigned char*)  "Hostname" , 8);
        const char *s = value.getHostname().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserStructAssociatedStationsChanged", jsonParser__Stub__WapdmanServiceTypes__StructAssociatedStationsChanged, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForStructAssociatedStationsChanged (char *s, size_t length)
{
    static stringEntry entries[] = {
        {7,"OBJPATH", 1},
        {8,"HOSTNAME", 11},
        {9,"INTERFACE", 7},
        {9,"IPADDRESS", 9},
        {10,"MACADDRESS", 3},
        {11,"ACCESSPOINT", 5},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 6, value))
        return (int)value;
    else
        return 12;
}

static int processMapKeyForStructAssociatedStationsChanged (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForStructAssociatedStationsChanged(s, length);
    if (i != 12 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__StructAssociatedStationsChanged(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_OBJPATH,
        KEY_OBJPATH,
        INIT_KEY_MACADDRESS,
        KEY_MACADDRESS,
        INIT_KEY_ACCESSPOINT,
        KEY_ACCESSPOINT,
        INIT_KEY_INTERFACE,
        KEY_INTERFACE,
        INIT_KEY_IPADDRESS,
        KEY_IPADDRESS,
        INIT_KEY_HOSTNAME,
        KEY_HOSTNAME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "objPath", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_OBJPATH:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceObjPath(t);
                setState (context, INIT_KEY_MACADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "MacAddress", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MACADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceMacAddress(t);
                setState (context, INIT_KEY_ACCESSPOINT);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "Accesspoint", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ACCESSPOINT:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceAccesspoint(t);
                setState (context, INIT_KEY_INTERFACE);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "Interface", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_INTERFACE:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceInterface(t);
                setState (context, INIT_KEY_IPADDRESS);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_IPADDRESS:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "IPAddress", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_IPADDRESS:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceIPAddress(t);
                setState (context, INIT_KEY_HOSTNAME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_HOSTNAME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructAssociatedStationsChanged (context, (char*) p1, (size_t) p2, "Hostname", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_HOSTNAME:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged*) parser.object)->replaceHostname(t);
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_OBJPATH);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "StructHWFeaturesList"

void serializeJson (const ::Stub::WapdmanServiceTypes::StructHWFeaturesList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasModeB()) {
        yajl_gen_string(g, (const unsigned char*)  "ModeB" , 5);
        yajl_gen_integer(g, (long long)value.getModeB());
    }
    if (!isSparse || value.hasModeG()) {
        yajl_gen_string(g, (const unsigned char*)  "ModeG" , 5);
        yajl_gen_integer(g, (long long)value.getModeG());
    }
    if (!isSparse || value.hasModeA()) {
        yajl_gen_string(g, (const unsigned char*)  "ModeA" , 5);
        yajl_gen_integer(g, (long long)value.getModeA());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::StructHWFeaturesList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::StructHWFeaturesList& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserStructHWFeaturesList", jsonParser__Stub__WapdmanServiceTypes__StructHWFeaturesList, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForStructHWFeaturesList (char *s, size_t length)
{
    static stringEntry entries[] = {
        {5,"MODEA", 5},
        {5,"MODEB", 1},
        {5,"MODEG", 3},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 3, value))
        return (int)value;
    else
        return 6;
}

static int processMapKeyForStructHWFeaturesList (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForStructHWFeaturesList(s, length);
    if (i != 6 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__StructHWFeaturesList(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_MODEB,
        KEY_MODEB,
        INIT_KEY_MODEG,
        KEY_MODEG,
        INIT_KEY_MODEA,
        KEY_MODEA,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_MODEB:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructHWFeaturesList (context, (char*) p1, (size_t) p2, "ModeB", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MODEB:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructHWFeaturesList*) parser.object)->setModeB(t);
                    setState (context, INIT_KEY_MODEG);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MODEG:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructHWFeaturesList (context, (char*) p1, (size_t) p2, "ModeG", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MODEG:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructHWFeaturesList*) parser.object)->setModeG(t);
                    setState (context, INIT_KEY_MODEA);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_MODEA:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructHWFeaturesList (context, (char*) p1, (size_t) p2, "ModeA", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_MODEA:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructHWFeaturesList*) parser.object)->setModeA(t);
                    setState (context, INIT_KEY_MODEB);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_MODEB);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_MODEB);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "SupportedChannelsList"

void serializeJson (const ::Stub::WapdmanServiceTypes::SupportedChannelsList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasChannels1()) {
        yajl_gen_string(g, (const unsigned char*)  "channels1" , 9);
        yajl_gen_integer(g, (long long)value.getChannels1());
    }
    if (!isSparse || value.hasChannels2()) {
        yajl_gen_string(g, (const unsigned char*)  "channels2" , 9);
        yajl_gen_integer(g, (long long)value.getChannels2());
    }
    if (!isSparse || value.hasChannels3()) {
        yajl_gen_string(g, (const unsigned char*)  "channels3" , 9);
        yajl_gen_integer(g, (long long)value.getChannels3());
    }
    if (!isSparse || value.hasChannels4()) {
        yajl_gen_string(g, (const unsigned char*)  "channels4" , 9);
        yajl_gen_integer(g, (long long)value.getChannels4());
    }
    if (!isSparse || value.hasChannels5()) {
        yajl_gen_string(g, (const unsigned char*)  "channels5" , 9);
        yajl_gen_integer(g, (long long)value.getChannels5());
    }
    if (!isSparse || value.hasChannels6()) {
        yajl_gen_string(g, (const unsigned char*)  "channels6" , 9);
        yajl_gen_integer(g, (long long)value.getChannels6());
    }
    if (!isSparse || value.hasChannels7()) {
        yajl_gen_string(g, (const unsigned char*)  "channels7" , 9);
        yajl_gen_integer(g, (long long)value.getChannels7());
    }
    if (!isSparse || value.hasChannels8()) {
        yajl_gen_string(g, (const unsigned char*)  "channels8" , 9);
        yajl_gen_integer(g, (long long)value.getChannels8());
    }
    if (!isSparse || value.hasChannels9()) {
        yajl_gen_string(g, (const unsigned char*)  "channels9" , 9);
        yajl_gen_integer(g, (long long)value.getChannels9());
    }
    if (!isSparse || value.hasChannels10()) {
        yajl_gen_string(g, (const unsigned char*)  "channels10" , 10);
        yajl_gen_integer(g, (long long)value.getChannels10());
    }
    if (!isSparse || value.hasChannels11()) {
        yajl_gen_string(g, (const unsigned char*)  "channels11" , 10);
        yajl_gen_integer(g, (long long)value.getChannels11());
    }
    if (!isSparse || value.hasChannels12()) {
        yajl_gen_string(g, (const unsigned char*)  "channels12" , 10);
        yajl_gen_integer(g, (long long)value.getChannels12());
    }
    if (!isSparse || value.hasChannels13()) {
        yajl_gen_string(g, (const unsigned char*)  "channels13" , 10);
        yajl_gen_integer(g, (long long)value.getChannels13());
    }
    if (!isSparse || value.hasChannels14()) {
        yajl_gen_string(g, (const unsigned char*)  "channels14" , 10);
        yajl_gen_integer(g, (long long)value.getChannels14());
    }
    if (!isSparse || value.hasChannels36()) {
        yajl_gen_string(g, (const unsigned char*)  "channels36" , 10);
        yajl_gen_integer(g, (long long)value.getChannels36());
    }
    if (!isSparse || value.hasChannels40()) {
        yajl_gen_string(g, (const unsigned char*)  "channels40" , 10);
        yajl_gen_integer(g, (long long)value.getChannels40());
    }
    if (!isSparse || value.hasChannels44()) {
        yajl_gen_string(g, (const unsigned char*)  "channels44" , 10);
        yajl_gen_integer(g, (long long)value.getChannels44());
    }
    if (!isSparse || value.hasChannels48()) {
        yajl_gen_string(g, (const unsigned char*)  "channels48" , 10);
        yajl_gen_integer(g, (long long)value.getChannels48());
    }
    if (!isSparse || value.hasChannels52()) {
        yajl_gen_string(g, (const unsigned char*)  "channels52" , 10);
        yajl_gen_integer(g, (long long)value.getChannels52());
    }
    if (!isSparse || value.hasChannels56()) {
        yajl_gen_string(g, (const unsigned char*)  "channels56" , 10);
        yajl_gen_integer(g, (long long)value.getChannels56());
    }
    if (!isSparse || value.hasChannels60()) {
        yajl_gen_string(g, (const unsigned char*)  "channels60" , 10);
        yajl_gen_integer(g, (long long)value.getChannels60());
    }
    if (!isSparse || value.hasChannels64()) {
        yajl_gen_string(g, (const unsigned char*)  "channels64" , 10);
        yajl_gen_integer(g, (long long)value.getChannels64());
    }
    if (!isSparse || value.hasChannels100()) {
        yajl_gen_string(g, (const unsigned char*)  "channels100" , 11);
        yajl_gen_integer(g, (long long)value.getChannels100());
    }
    if (!isSparse || value.hasChannels104()) {
        yajl_gen_string(g, (const unsigned char*)  "channels104" , 11);
        yajl_gen_integer(g, (long long)value.getChannels104());
    }
    if (!isSparse || value.hasChannels108()) {
        yajl_gen_string(g, (const unsigned char*)  "channels108" , 11);
        yajl_gen_integer(g, (long long)value.getChannels108());
    }
    if (!isSparse || value.hasChannels112()) {
        yajl_gen_string(g, (const unsigned char*)  "channels112" , 11);
        yajl_gen_integer(g, (long long)value.getChannels112());
    }
    if (!isSparse || value.hasChannels116()) {
        yajl_gen_string(g, (const unsigned char*)  "channels116" , 11);
        yajl_gen_integer(g, (long long)value.getChannels116());
    }
    if (!isSparse || value.hasChannels120()) {
        yajl_gen_string(g, (const unsigned char*)  "channels120" , 11);
        yajl_gen_integer(g, (long long)value.getChannels120());
    }
    if (!isSparse || value.hasChannels124()) {
        yajl_gen_string(g, (const unsigned char*)  "channels124" , 11);
        yajl_gen_integer(g, (long long)value.getChannels124());
    }
    if (!isSparse || value.hasChannels128()) {
        yajl_gen_string(g, (const unsigned char*)  "channels128" , 11);
        yajl_gen_integer(g, (long long)value.getChannels128());
    }
    if (!isSparse || value.hasChannels132()) {
        yajl_gen_string(g, (const unsigned char*)  "channels132" , 11);
        yajl_gen_integer(g, (long long)value.getChannels132());
    }
    if (!isSparse || value.hasChannels136()) {
        yajl_gen_string(g, (const unsigned char*)  "channels136" , 11);
        yajl_gen_integer(g, (long long)value.getChannels136());
    }
    if (!isSparse || value.hasChannels140()) {
        yajl_gen_string(g, (const unsigned char*)  "channels140" , 11);
        yajl_gen_integer(g, (long long)value.getChannels140());
    }
    if (!isSparse || value.hasChannels144()) {
        yajl_gen_string(g, (const unsigned char*)  "channels144" , 11);
        yajl_gen_integer(g, (long long)value.getChannels144());
    }
    if (!isSparse || value.hasChannels149()) {
        yajl_gen_string(g, (const unsigned char*)  "channels149" , 11);
        yajl_gen_integer(g, (long long)value.getChannels149());
    }
    if (!isSparse || value.hasChannels153()) {
        yajl_gen_string(g, (const unsigned char*)  "channels153" , 11);
        yajl_gen_integer(g, (long long)value.getChannels153());
    }
    if (!isSparse || value.hasChannels157()) {
        yajl_gen_string(g, (const unsigned char*)  "channels157" , 11);
        yajl_gen_integer(g, (long long)value.getChannels157());
    }
    if (!isSparse || value.hasChannels161()) {
        yajl_gen_string(g, (const unsigned char*)  "channels161" , 11);
        yajl_gen_integer(g, (long long)value.getChannels161());
    }
    if (!isSparse || value.hasChannels165()) {
        yajl_gen_string(g, (const unsigned char*)  "channels165" , 11);
        yajl_gen_integer(g, (long long)value.getChannels165());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::SupportedChannelsList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::SupportedChannelsList& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserSupportedChannelsList", jsonParser__Stub__WapdmanServiceTypes__SupportedChannelsList, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForSupportedChannelsList (char *s, size_t length)
{
    static stringEntry entries[] = {
        {9,"CHANNELS1", 1},
        {9,"CHANNELS2", 3},
        {9,"CHANNELS3", 5},
        {9,"CHANNELS4", 7},
        {9,"CHANNELS5", 9},
        {9,"CHANNELS6", 11},
        {9,"CHANNELS7", 13},
        {9,"CHANNELS8", 15},
        {9,"CHANNELS9", 17},
        {10,"CHANNELS10", 19},
        {10,"CHANNELS11", 21},
        {10,"CHANNELS12", 23},
        {10,"CHANNELS13", 25},
        {10,"CHANNELS14", 27},
        {10,"CHANNELS36", 29},
        {10,"CHANNELS40", 31},
        {10,"CHANNELS44", 33},
        {10,"CHANNELS48", 35},
        {10,"CHANNELS52", 37},
        {10,"CHANNELS56", 39},
        {10,"CHANNELS60", 41},
        {10,"CHANNELS64", 43},
        {11,"CHANNELS100", 45},
        {11,"CHANNELS104", 47},
        {11,"CHANNELS108", 49},
        {11,"CHANNELS112", 51},
        {11,"CHANNELS116", 53},
        {11,"CHANNELS120", 55},
        {11,"CHANNELS124", 57},
        {11,"CHANNELS128", 59},
        {11,"CHANNELS132", 61},
        {11,"CHANNELS136", 63},
        {11,"CHANNELS140", 65},
        {11,"CHANNELS144", 67},
        {11,"CHANNELS149", 69},
        {11,"CHANNELS153", 71},
        {11,"CHANNELS157", 73},
        {11,"CHANNELS161", 75},
        {11,"CHANNELS165", 77},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 39, value))
        return (int)value;
    else
        return 78;
}

static int processMapKeyForSupportedChannelsList (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForSupportedChannelsList(s, length);
    if (i != 78 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__SupportedChannelsList(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_CHANNELS1,
        KEY_CHANNELS1,
        INIT_KEY_CHANNELS2,
        KEY_CHANNELS2,
        INIT_KEY_CHANNELS3,
        KEY_CHANNELS3,
        INIT_KEY_CHANNELS4,
        KEY_CHANNELS4,
        INIT_KEY_CHANNELS5,
        KEY_CHANNELS5,
        INIT_KEY_CHANNELS6,
        KEY_CHANNELS6,
        INIT_KEY_CHANNELS7,
        KEY_CHANNELS7,
        INIT_KEY_CHANNELS8,
        KEY_CHANNELS8,
        INIT_KEY_CHANNELS9,
        KEY_CHANNELS9,
        INIT_KEY_CHANNELS10,
        KEY_CHANNELS10,
        INIT_KEY_CHANNELS11,
        KEY_CHANNELS11,
        INIT_KEY_CHANNELS12,
        KEY_CHANNELS12,
        INIT_KEY_CHANNELS13,
        KEY_CHANNELS13,
        INIT_KEY_CHANNELS14,
        KEY_CHANNELS14,
        INIT_KEY_CHANNELS36,
        KEY_CHANNELS36,
        INIT_KEY_CHANNELS40,
        KEY_CHANNELS40,
        INIT_KEY_CHANNELS44,
        KEY_CHANNELS44,
        INIT_KEY_CHANNELS48,
        KEY_CHANNELS48,
        INIT_KEY_CHANNELS52,
        KEY_CHANNELS52,
        INIT_KEY_CHANNELS56,
        KEY_CHANNELS56,
        INIT_KEY_CHANNELS60,
        KEY_CHANNELS60,
        INIT_KEY_CHANNELS64,
        KEY_CHANNELS64,
        INIT_KEY_CHANNELS100,
        KEY_CHANNELS100,
        INIT_KEY_CHANNELS104,
        KEY_CHANNELS104,
        INIT_KEY_CHANNELS108,
        KEY_CHANNELS108,
        INIT_KEY_CHANNELS112,
        KEY_CHANNELS112,
        INIT_KEY_CHANNELS116,
        KEY_CHANNELS116,
        INIT_KEY_CHANNELS120,
        KEY_CHANNELS120,
        INIT_KEY_CHANNELS124,
        KEY_CHANNELS124,
        INIT_KEY_CHANNELS128,
        KEY_CHANNELS128,
        INIT_KEY_CHANNELS132,
        KEY_CHANNELS132,
        INIT_KEY_CHANNELS136,
        KEY_CHANNELS136,
        INIT_KEY_CHANNELS140,
        KEY_CHANNELS140,
        INIT_KEY_CHANNELS144,
        KEY_CHANNELS144,
        INIT_KEY_CHANNELS149,
        KEY_CHANNELS149,
        INIT_KEY_CHANNELS153,
        KEY_CHANNELS153,
        INIT_KEY_CHANNELS157,
        KEY_CHANNELS157,
        INIT_KEY_CHANNELS161,
        KEY_CHANNELS161,
        INIT_KEY_CHANNELS165,
        KEY_CHANNELS165,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_CHANNELS1:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels1", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS1:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels1(t);
                    setState (context, INIT_KEY_CHANNELS2);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS2:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels2", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS2:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels2(t);
                    setState (context, INIT_KEY_CHANNELS3);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS3:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels3", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS3:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels3(t);
                    setState (context, INIT_KEY_CHANNELS4);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS4:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels4", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS4:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels4(t);
                    setState (context, INIT_KEY_CHANNELS5);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS5:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels5", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS5:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels5(t);
                    setState (context, INIT_KEY_CHANNELS6);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS6:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels6", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS6:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels6(t);
                    setState (context, INIT_KEY_CHANNELS7);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS7:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels7", 13) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS7:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels7(t);
                    setState (context, INIT_KEY_CHANNELS8);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS8:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels8", 15) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS8:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels8(t);
                    setState (context, INIT_KEY_CHANNELS9);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS9:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels9", 17) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS9:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels9(t);
                    setState (context, INIT_KEY_CHANNELS10);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS10:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels10", 19) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS10:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels10(t);
                    setState (context, INIT_KEY_CHANNELS11);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS11:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels11", 21) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS11:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels11(t);
                    setState (context, INIT_KEY_CHANNELS12);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS12:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels12", 23) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS12:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels12(t);
                    setState (context, INIT_KEY_CHANNELS13);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS13:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels13", 25) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS13:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels13(t);
                    setState (context, INIT_KEY_CHANNELS14);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS14:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels14", 27) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS14:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels14(t);
                    setState (context, INIT_KEY_CHANNELS36);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS36:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels36", 29) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS36:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels36(t);
                    setState (context, INIT_KEY_CHANNELS40);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS40:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels40", 31) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS40:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels40(t);
                    setState (context, INIT_KEY_CHANNELS44);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS44:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels44", 33) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS44:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels44(t);
                    setState (context, INIT_KEY_CHANNELS48);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS48:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels48", 35) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS48:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels48(t);
                    setState (context, INIT_KEY_CHANNELS52);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS52:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels52", 37) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS52:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels52(t);
                    setState (context, INIT_KEY_CHANNELS56);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS56:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels56", 39) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS56:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels56(t);
                    setState (context, INIT_KEY_CHANNELS60);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS60:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels60", 41) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS60:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels60(t);
                    setState (context, INIT_KEY_CHANNELS64);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS64:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels64", 43) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS64:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels64(t);
                    setState (context, INIT_KEY_CHANNELS100);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS100:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels100", 45) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS100:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels100(t);
                    setState (context, INIT_KEY_CHANNELS104);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS104:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels104", 47) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS104:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels104(t);
                    setState (context, INIT_KEY_CHANNELS108);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS108:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels108", 49) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS108:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels108(t);
                    setState (context, INIT_KEY_CHANNELS112);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS112:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels112", 51) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS112:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels112(t);
                    setState (context, INIT_KEY_CHANNELS116);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS116:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels116", 53) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS116:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels116(t);
                    setState (context, INIT_KEY_CHANNELS120);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS120:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels120", 55) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS120:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels120(t);
                    setState (context, INIT_KEY_CHANNELS124);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS124:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels124", 57) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS124:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels124(t);
                    setState (context, INIT_KEY_CHANNELS128);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS128:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels128", 59) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS128:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels128(t);
                    setState (context, INIT_KEY_CHANNELS132);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS132:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels132", 61) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS132:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels132(t);
                    setState (context, INIT_KEY_CHANNELS136);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS136:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels136", 63) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS136:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels136(t);
                    setState (context, INIT_KEY_CHANNELS140);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS140:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels140", 65) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS140:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels140(t);
                    setState (context, INIT_KEY_CHANNELS144);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS144:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels144", 67) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS144:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels144(t);
                    setState (context, INIT_KEY_CHANNELS149);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS149:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels149", 69) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS149:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels149(t);
                    setState (context, INIT_KEY_CHANNELS153);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS153:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels153", 71) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS153:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels153(t);
                    setState (context, INIT_KEY_CHANNELS157);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS157:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels157", 73) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS157:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels157(t);
                    setState (context, INIT_KEY_CHANNELS161);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS161:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels161", 75) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS161:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels161(t);
                    setState (context, INIT_KEY_CHANNELS165);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_CHANNELS165:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForSupportedChannelsList (context, (char*) p1, (size_t) p2, "channels165", 77) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_CHANNELS165:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint16 t = (uint16) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::SupportedChannelsList*) parser.object)->setChannels165(t);
                    setState (context, INIT_KEY_CHANNELS1);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_CHANNELS1);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_CHANNELS1);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

// Json serialization of "StructIPv4List"

void serializeJson (const ::Stub::WapdmanServiceTypes::StructIPv4List& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStart()) {
        yajl_gen_string(g, (const unsigned char*)  "start" , 5);
        const char *s = value.getStart().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEnd()) {
        yajl_gen_string(g, (const unsigned char*)  "end" , 3);
        const char *s = value.getEnd().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNetmask()) {
        yajl_gen_string(g, (const unsigned char*)  "netmask" , 7);
        const char *s = value.getNetmask().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasNetwork()) {
        yajl_gen_string(g, (const unsigned char*)  "network" , 7);
        const char *s = value.getNetwork().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBroadcast()) {
        yajl_gen_string(g, (const unsigned char*)  "broadcast" , 9);
        const char *s = value.getBroadcast().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRouter()) {
        yajl_gen_string(g, (const unsigned char*)  "router" , 6);
        const char *s = value.getRouter().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasLeasetime()) {
        yajl_gen_string(g, (const unsigned char*)  "leasetime" , 9);
        yajl_gen_integer(g, (long long)value.getLeasetime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::Stub::WapdmanServiceTypes::StructIPv4List& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

bool deserializeJson (const ::std::string &jsonString, ::Stub::WapdmanServiceTypes::StructIPv4List& value, bool isStrict)
{
    ParserContext _context;
    ParserContext* context = &_context;
    _context.isStrict = isStrict;
    callParser (context, "parserStructIPv4List", jsonParser__Stub__WapdmanServiceTypes__StructIPv4List, &value);
    callParser (context, "parserExpectMap", parserExpectMap, 0);

    yajl_handle handle = yajl_alloc(&callbacks, NULL, context);
    yajl_config (handle, yajl_allow_comments, 1);
    yajl_status status = yajl_parse(handle, (const unsigned char*) jsonString.c_str(), strlen (jsonString.c_str()));
    yajl_free(handle);

    return status == yajl_status_ok;
}

static int getKeyStateForStructIPv4List (char *s, size_t length)
{
    static stringEntry entries[] = {
        {3,"END", 3},
        {5,"START", 1},
        {6,"ROUTER", 11},
        {7,"NETMASK", 5},
        {7,"NETWORK", 7},
        {9,"BROADCAST", 9},
        {9,"LEASETIME", 13},
    };

    unsigned int value;
    if (lookupInStringEntryTable (s, length, entries, 7, value))
        return (int)value;
    else
        return 14;
}

static int processMapKeyForStructIPv4List (ParserContext *context, char* s, size_t length, const char* predictedKey, int predictedState) {
    if (streq (s, length, predictedKey)) {
        setState (context, predictedState);
        return PARSER_STATUS__OK;
    }
    int i = getKeyStateForStructIPv4List(s, length);
    if (i != 14 || !context->isStrict) {
        setState (context, i);
        return PARSER_STATUS__OK;
    }
    return PARSER_STATUS__FAIL;
}

ParserStatus jsonParser__Stub__WapdmanServiceTypes__StructIPv4List(ParserEvent event, ParserContext *context, void *p1, void *p2)
{
    (void)p1; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)p2; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    enum State {
        INIT_KEY_START,
        KEY_START,
        INIT_KEY_END,
        KEY_END,
        INIT_KEY_NETMASK,
        KEY_NETMASK,
        INIT_KEY_NETWORK,
        KEY_NETWORK,
        INIT_KEY_BROADCAST,
        KEY_BROADCAST,
        INIT_KEY_ROUTER,
        KEY_ROUTER,
        INIT_KEY_LEASETIME,
        KEY_LEASETIME,
        KEY__UNKNOWN_KEY,
        KEY__UNKNOWN_KEY__WAIT_FOR_RETURN
    };

    Parser parser = context->parsers.top();
    State state = (State) parser.state;

    switch (state) {
    case INIT_KEY_START:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "start", 1) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_START:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceStart(t);
                setState (context, INIT_KEY_END);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_END:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "end", 3) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_END:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceEnd(t);
                setState (context, INIT_KEY_NETMASK);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_NETMASK:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "netmask", 5) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_NETMASK:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceNetmask(t);
                setState (context, INIT_KEY_NETWORK);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_NETWORK:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "network", 7) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_NETWORK:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceNetwork(t);
                setState (context, INIT_KEY_BROADCAST);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_BROADCAST:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "broadcast", 9) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_BROADCAST:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceBroadcast(t);
                setState (context, INIT_KEY_ROUTER);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_ROUTER:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "router", 11) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_ROUTER:
        switch (event) {
        case PARSER_EVENT__STRING:
            {
                ::std::string* t = new ::std::string((char *) p1, (unsigned int)(uintptr_t) p2);
                CHECK_ALLOCATION( t );
                ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->replaceRouter(t);
                setState (context, INIT_KEY_LEASETIME);
                return PARSER_STATUS__OK;
            }
        default:
            break;
        }
        break;
    case INIT_KEY_LEASETIME:
        switch (event) {
        case PARSER_EVENT__MAP_KEY:
            if (processMapKeyForStructIPv4List (context, (char*) p1, (size_t) p2, "leasetime", 13) == PARSER_STATUS__OK)
                return PARSER_STATUS__OK;
            break;
        case PARSER_EVENT__END_MAP:
            return leaveParser (context);
        default:
            break;
        }
        break;
    case KEY_LEASETIME:
        switch (event) {
        case PARSER_EVENT__NUMBER:
            {
                char *end;
                uint32 t = (uint32) strtoul ((char *) p1, &end, 10);
                const bool success = end != p1;
                if (success) {
                    ((::Stub::WapdmanServiceTypes::StructIPv4List*) parser.object)->setLeasetime(t);
                    setState (context, INIT_KEY_START);
                    return PARSER_STATUS__OK;
                }
                break;
            }
        default:
            break;
        }
        break;
    case KEY__UNKNOWN_KEY:
        {
            switch (event) {
            case PARSER_EVENT__START_MAP:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyMap", parserAnyMap, 0);
                return PARSER_STATUS__OK;
            case PARSER_EVENT__START_ARRAY:
                setState (context, KEY__UNKNOWN_KEY__WAIT_FOR_RETURN);
                callParser (context, "parserAnyArray", parserAnyArray, 0);
                return PARSER_STATUS__OK;
            default:
                setState (context, INIT_KEY_START);
                return PARSER_STATUS__OK;
            }
        }
    case KEY__UNKNOWN_KEY__WAIT_FOR_RETURN:
        {
            switch (event) {
            case PARSER_EVENT__RETURN:
                setState (context, INIT_KEY_START);
                return PARSER_STATUS__OK;
            default:
                break;
            }
        }
        break;
    default:
        break;
    }

    errorMessage (event, parser);
    return PARSER_STATUS__FAIL;
}

using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::StructAPList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::StructASList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::StructHWFeaturesList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::SupportedChannelsList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub
using namespace ::asf::stream::json;

namespace Stub {
namespace WapdmanServiceTypes {

std::ostream& operator<<(std::ostream& o, const ::Stub::WapdmanServiceTypes::StructIPv4List& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace WapdmanServiceTypes
} // namespace Stub

