/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef STUB_WAPDMANSERVICESTUB_H
#define STUB_WAPDMANSERVICESTUB_H

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceTypes.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

namespace Stub {
namespace WapdmanService {

/**
 * If the meaning of "WapdmanService" isn't clear, then there should be a description here.
 */

class WapdmanServiceStubConnector;

/**
 * The WapdmanServiceStub is the hook to implement the WapdmanService. It
 * is necessary to derive from this class and implement the pure virtual
 * functions. That's the way to add the functionality to the service.
 */
class WapdmanServiceStub : public ::asf::core::Stub
{
public:
    /**
     * The derived class has to pass the port name to the WapdmanServiceStub.
     * The port name is defined in the "Car Multimedia Component" model.
     */
    WapdmanServiceStub (const std::string& portName);

    virtual ~WapdmanServiceStub();

    // request setSSID

    /**
     * This function will be called if the component receives the client
     * request "setSSIDRequest". The service implementation has to process the
     * request and send the response with sendSetSSIDResponse().
     *
     * <b>Documentation of 'setSSID'</b>:
     *
     * Requests
     */
    virtual void onSetSSIDRequest (const ::boost::shared_ptr< SetSSIDRequest >& setSSID) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onSetSSIDRequest()). It is not necessary to pass
     * the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'setSSID'</b>:
     *
     * Requests
     */
    void sendSetSSIDResponse (act_t act = 0);

    // request DeAuthenticateStation

    /**
     * This function will be called if the component receives the client
     * request "DeAuthenticateStationRequest". The service implementation has
     * to process the request and send the response with
     * sendDeAuthenticateStationResponse().
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     */
    virtual void onDeAuthenticateStationRequest (const ::boost::shared_ptr< DeAuthenticateStationRequest >& deAuthenticateStation) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onDeAuthenticateStationRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'DeAuthenticateStation'</b>:
     *
     * If the meaning of "DeAuthenticateStation" isn't clear, then there should be a description here.
     */
    void sendDeAuthenticateStationResponse (act_t act = 0);

    // request BlacklistStation

    /**
     * This function will be called if the component receives the client
     * request "BlacklistStationRequest". The service implementation has to
     * process the request and send the response with
     * sendBlacklistStationResponse().
     *
     * <b>Documentation of 'BlacklistStation'</b>:
     *
     * If the meaning of "BlacklistStation" isn't clear, then there should be a description here.
     */
    virtual void onBlacklistStationRequest (const ::boost::shared_ptr< BlacklistStationRequest >& blacklistStation) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onBlacklistStationRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'BlacklistStation'</b>:
     *
     * If the meaning of "BlacklistStation" isn't clear, then there should be a description here.
     */
    void sendBlacklistStationResponse (act_t act = 0);

    // request SetOperatingChannels

    /**
     * This function will be called if the component receives the client
     * request "SetOperatingChannelsRequest". The service implementation has
     * to process the request and send the response with
     * sendSetOperatingChannelsResponse().
     *
     * <b>Documentation of 'SetOperatingChannels'</b>:
     *
     * If the meaning of "SetOperatingChannels" isn't clear, then there should be a description here.
     */
    virtual void onSetOperatingChannelsRequest (const ::boost::shared_ptr< SetOperatingChannelsRequest >& setOperatingChannels) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onSetOperatingChannelsRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'SetOperatingChannels'</b>:
     *
     * If the meaning of "SetOperatingChannels" isn't clear, then there should be a description here.
     */
    void sendSetOperatingChannelsResponse (act_t act = 0);

    // request StartWPSPushButton

    /**
     * This function will be called if the component receives the client
     * request "StartWPSPushButtonRequest". The service implementation has to
     * process the request and send the response with
     * sendStartWPSPushButtonResponse().
     *
     * <b>Documentation of 'StartWPSPushButton'</b>:
     *
     * If the meaning of "StartWPSPushButton" isn't clear, then there should be a description here.
     */
    virtual void onStartWPSPushButtonRequest (const ::boost::shared_ptr< StartWPSPushButtonRequest >& startWPSPushButton) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onStartWPSPushButtonRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'StartWPSPushButton'</b>:
     *
     * If the meaning of "StartWPSPushButton" isn't clear, then there should be a description here.
     */
    void sendStartWPSPushButtonResponse (act_t act = 0);

    // request CancelWPS

    /**
     * This function will be called if the component receives the client
     * request "CancelWPSRequest". The service implementation has to process
     * the request and send the response with sendCancelWPSResponse().
     *
     * <b>Documentation of 'CancelWPS'</b>:
     *
     * If the meaning of "CancelWPS" isn't clear, then there should be a description here.
     */
    virtual void onCancelWPSRequest (const ::boost::shared_ptr< CancelWPSRequest >& cancelWPS) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onCancelWPSRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'CancelWPS'</b>:
     *
     * If the meaning of "CancelWPS" isn't clear, then there should be a description here.
     */
    void sendCancelWPSResponse (act_t act = 0);

    // request RegisterVendorService

    /**
     * This function will be called if the component receives the client
     * request "RegisterVendorServiceRequest". The service implementation has
     * to process the request and send the response with
     * sendRegisterVendorServiceResponse().
     *
     * <b>Documentation of 'RegisterVendorService'</b>:
     *
     * If the meaning of "RegisterVendorService" isn't clear, then there should be a description here.
     */
    virtual void onRegisterVendorServiceRequest (const ::boost::shared_ptr< RegisterVendorServiceRequest >& registerVendorService) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onRegisterVendorServiceRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'RegisterVendorService'</b>:
     *
     * If the meaning of "RegisterVendorService" isn't clear, then there should be a description here.
     */
    void sendRegisterVendorServiceResponse (act_t act = 0);

    // request UnregisterVendorService

    /**
     * This function will be called if the component receives the client
     * request "UnregisterVendorServiceRequest". The service implementation
     * has to process the request and send the response with
     * sendUnregisterVendorServiceResponse().
     *
     * <b>Documentation of 'UnregisterVendorService'</b>:
     *
     * If the meaning of "UnregisterVendorService" isn't clear, then there should be a description here.
     */
    virtual void onUnregisterVendorServiceRequest (const ::boost::shared_ptr< UnregisterVendorServiceRequest >& unregisterVendorService) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onUnregisterVendorServiceRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'UnregisterVendorService'</b>:
     *
     * If the meaning of "UnregisterVendorService" isn't clear, then there should be a description here.
     */
    void sendUnregisterVendorServiceResponse (act_t act = 0);

    // request GetAssociatedStations

    /**
     * This function will be called if the component receives the client
     * request "GetAssociatedStationsRequest". The service implementation has
     * to process the request and send the response with
     * sendGetAssociatedStationsResponse().
     *
     * <b>Documentation of 'GetAssociatedStations'</b>:
     *
     * If the meaning of "GetAssociatedStations" isn't clear, then there should be a description here.
     */
    virtual void onGetAssociatedStationsRequest (const ::boost::shared_ptr< GetAssociatedStationsRequest >& getAssociatedStations) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onGetAssociatedStationsRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'GetAssociatedStations'</b>:
     *
     * If the meaning of "GetAssociatedStations" isn't clear, then there should be a description here.
     */
    void sendGetAssociatedStationsResponse (const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructASList >& associatedstations, act_t act = 0);

    // request Get

    /**
     * This function will be called if the component receives the client
     * request "GetRequest". The service implementation has to process the
     * request and send the response with sendGetResponse().
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     */
    virtual void onGetRequest (const ::boost::shared_ptr< GetRequest >& get) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onGetRequest()). It is not necessary to pass the
     * act (asynchronous completion token), if you call the response function
     * inside the body of the corresponding request.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     */
    void sendGetResponse (const ::std::string& value, act_t act = 0);

    // request SSIDGet

    /**
     * This function will be called if the component receives the client
     * request "SSIDGetRequest". The service implementation has to process the
     * request and send the response with sendSSIDGetResponse().
     *
     * <b>Documentation of 'SSIDGet'</b>:
     *
     * If the meaning of "SSIDGet" isn't clear, then there should be a description here.
     */
    virtual void onSSIDGetRequest (const ::boost::shared_ptr< SSIDGetRequest >& sSIDGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onSSIDGetRequest()). It is not necessary to pass
     * the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'SSIDGet'</b>:
     *
     * If the meaning of "SSIDGet" isn't clear, then there should be a description here.
     */
    void sendSSIDGetResponse (const ::std::vector< uint8 >& ssid, act_t act = 0);

    // request Security

    /**
     * This function will be called if the component receives the client
     * request "SecurityRequest". The service implementation has to process
     * the request and send the response with sendSecurityResponse().
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    virtual void onSecurityRequest (const ::boost::shared_ptr< SecurityRequest >& security) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onSecurityRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'Security'</b>:
     *
     * If the meaning of "Security" isn't clear, then there should be a description here.
     */
    void sendSecurityResponse (const ::std::string& security, act_t act = 0);

    // request MacAddressGet

    /**
     * This function will be called if the component receives the client
     * request "MacAddressGetRequest". The service implementation has to
     * process the request and send the response with
     * sendMacAddressGetResponse().
     *
     * <b>Documentation of 'MacAddressGet'</b>:
     *
     * If the meaning of "MacAddressGet" isn't clear, then there should be a description here.
     */
    virtual void onMacAddressGetRequest (const ::boost::shared_ptr< MacAddressGetRequest >& macAddressGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onMacAddressGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'MacAddressGet'</b>:
     *
     * If the meaning of "MacAddressGet" isn't clear, then there should be a description here.
     */
    void sendMacAddressGetResponse (const ::std::string& macaddress, act_t act = 0);

    // request InterfaceGet

    /**
     * This function will be called if the component receives the client
     * request "InterfaceGetRequest". The service implementation has to
     * process the request and send the response with
     * sendInterfaceGetResponse().
     *
     * <b>Documentation of 'InterfaceGet'</b>:
     *
     * If the meaning of "InterfaceGet" isn't clear, then there should be a description here.
     */
    virtual void onInterfaceGetRequest (const ::boost::shared_ptr< InterfaceGetRequest >& interfaceGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onInterfaceGetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'InterfaceGet'</b>:
     *
     * If the meaning of "InterfaceGet" isn't clear, then there should be a description here.
     */
    void sendInterfaceGetResponse (const ::std::string& interface, act_t act = 0);

    // request PassphraseGet

    /**
     * This function will be called if the component receives the client
     * request "PassphraseGetRequest". The service implementation has to
     * process the request and send the response with
     * sendPassphraseGetResponse().
     *
     * <b>Documentation of 'PassphraseGet'</b>:
     *
     * If the meaning of "PassphraseGet" isn't clear, then there should be a description here.
     */
    virtual void onPassphraseGetRequest (const ::boost::shared_ptr< PassphraseGetRequest >& passphraseGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onPassphraseGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'PassphraseGet'</b>:
     *
     * If the meaning of "PassphraseGet" isn't clear, then there should be a description here.
     */
    void sendPassphraseGetResponse (const ::std::string& passphrase, act_t act = 0);

    // request PoweredGet

    /**
     * This function will be called if the component receives the client
     * request "PoweredGetRequest". The service implementation has to process
     * the request and send the response with sendPoweredGetResponse().
     *
     * <b>Documentation of 'PoweredGet'</b>:
     *
     * If the meaning of "PoweredGet" isn't clear, then there should be a description here.
     */
    virtual void onPoweredGetRequest (const ::boost::shared_ptr< PoweredGetRequest >& poweredGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onPoweredGetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'PoweredGet'</b>:
     *
     * If the meaning of "PoweredGet" isn't clear, then there should be a description here.
     */
    void sendPoweredGetResponse (bool powered, act_t act = 0);

    // request HiddenGet

    /**
     * This function will be called if the component receives the client
     * request "HiddenGetRequest". The service implementation has to process
     * the request and send the response with sendHiddenGetResponse().
     *
     * <b>Documentation of 'HiddenGet'</b>:
     *
     * If the meaning of "HiddenGet" isn't clear, then there should be a description here.
     */
    virtual void onHiddenGetRequest (const ::boost::shared_ptr< HiddenGetRequest >& hiddenGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onHiddenGetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'HiddenGet'</b>:
     *
     * If the meaning of "HiddenGet" isn't clear, then there should be a description here.
     */
    void sendHiddenGetResponse (bool hidden, act_t act = 0);

    // request CurrentOperatingChannelGet

    /**
     * This function will be called if the component receives the client
     * request "CurrentOperatingChannelGetRequest". The service implementation
     * has to process the request and send the response with
     * sendCurrentOperatingChannelGetResponse().
     *
     * <b>Documentation of 'CurrentOperatingChannelGet'</b>:
     *
     * If the meaning of "CurrentOperatingChannelGet" isn't clear, then there should be a description here.
     */
    virtual void onCurrentOperatingChannelGetRequest (const ::boost::shared_ptr< CurrentOperatingChannelGetRequest >& currentOperatingChannelGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onCurrentOperatingChannelGetRequest()). It is
     * not necessary to pass the act (asynchronous completion token), if you
     * call the response function inside the body of the corresponding
     * request.
     *
     * <b>Documentation of 'CurrentOperatingChannelGet'</b>:
     *
     * If the meaning of "CurrentOperatingChannelGet" isn't clear, then there should be a description here.
     */
    void sendCurrentOperatingChannelGetResponse (uint16 currentoperatingchannel, act_t act = 0);

    // request VendorIEsGet

    /**
     * This function will be called if the component receives the client
     * request "VendorIEsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendVendorIEsGetResponse().
     *
     * <b>Documentation of 'VendorIEsGet'</b>:
     *
     * If the meaning of "VendorIEsGet" isn't clear, then there should be a description here.
     */
    virtual void onVendorIEsGetRequest (const ::boost::shared_ptr< VendorIEsGetRequest >& vendorIEsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onVendorIEsGetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'VendorIEsGet'</b>:
     *
     * If the meaning of "VendorIEsGet" isn't clear, then there should be a description here.
     */
    void sendVendorIEsGetResponse (const ::std::vector< uint16 >& vendorIEs, act_t act = 0);

    // request PoweredSet

    /**
     * This function will be called if the component receives the client
     * request "PoweredSetRequest". The service implementation has to process
     * the request and send the response with sendPoweredSetResponse().
     *
     * <b>Documentation of 'PoweredSet'</b>:
     *
     * If the meaning of "PoweredSet" isn't clear, then there should be a description here.
     */
    virtual void onPoweredSetRequest (const ::boost::shared_ptr< PoweredSetRequest >& poweredSet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onPoweredSetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'PoweredSet'</b>:
     *
     * If the meaning of "PoweredSet" isn't clear, then there should be a description here.
     */
    void sendPoweredSetResponse (act_t act = 0);

    // request HiddenSet

    /**
     * This function will be called if the component receives the client
     * request "HiddenSetRequest". The service implementation has to process
     * the request and send the response with sendHiddenSetResponse().
     *
     * <b>Documentation of 'HiddenSet'</b>:
     *
     * If the meaning of "HiddenSet" isn't clear, then there should be a description here.
     */
    virtual void onHiddenSetRequest (const ::boost::shared_ptr< HiddenSetRequest >& hiddenSet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onHiddenSetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'HiddenSet'</b>:
     *
     * If the meaning of "HiddenSet" isn't clear, then there should be a description here.
     */
    void sendHiddenSetResponse (act_t act = 0);

    // request PassphraseSet

    /**
     * This function will be called if the component receives the client
     * request "PassphraseSetRequest". The service implementation has to
     * process the request and send the response with
     * sendPassphraseSetResponse().
     *
     * <b>Documentation of 'PassphraseSet'</b>:
     *
     * If the meaning of "PassphraseSet" isn't clear, then there should be a description here.
     */
    virtual void onPassphraseSetRequest (const ::boost::shared_ptr< PassphraseSetRequest >& passphraseSet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onPassphraseSetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'PassphraseSet'</b>:
     *
     * If the meaning of "PassphraseSet" isn't clear, then there should be a description here.
     */
    void sendPassphraseSetResponse (act_t act = 0);

    // request TetheringSet

    /**
     * This function will be called if the component receives the client
     * request "TetheringSetRequest". The service implementation has to
     * process the request and send the response with
     * sendTetheringSetResponse().
     *
     * <b>Documentation of 'TetheringSet'</b>:
     *
     * If the meaning of "TetheringSet" isn't clear, then there should be a description here.
     */
    virtual void onTetheringSetRequest (const ::boost::shared_ptr< TetheringSetRequest >& tetheringSet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onTetheringSetRequest()). It is not necessary to
     * pass the act (asynchronous completion token), if you call the response
     * function inside the body of the corresponding request.
     *
     * <b>Documentation of 'TetheringSet'</b>:
     *
     * If the meaning of "TetheringSet" isn't clear, then there should be a description here.
     */
    void sendTetheringSetResponse (act_t act = 0);

    // property PowerState

    /**
     * This function will be called if the component receives a "registration"
     * message for the property PowerState. The default implementation sends
     * back a notification message  with the current content of the property.
     * It is possible to override the function, if the user wants to react on
     * the registration event of the property. In this case it is necessary to
     * send the notification manually. Use the function
     * sendPowerStateUpdate(). The parameter isFirst is true if the count of
     * the registered clients is one otherwise the parameter is false.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onPowerStateRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property PowerState.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onPowerStateDeregister(bool /*isLast*/, act_t act);

    void sendPowerStateUpdate(const ::std::string& data, act_t act);

    void sendPowerStateGetUpdate(const ::std::string& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setPowerState(const ::std::string& data);

    const ::std::string& getPowerState() const;

    ::std::string& getPowerStateMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property PowerState.
     *
     * <b>Documentation of 'PowerState'</b>:
     *
     * If the meaning of "PowerState" isn't clear, then there should be a description here.
     */
    void sendPowerStateNotification();

    // property PowerFailureReason

    /**
     * This function will be called if the component receives a "registration"
     * message for the property PowerFailureReason. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendPowerFailureReasonUpdate(). The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onPowerFailureReasonRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property PowerFailureReason.  The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onPowerFailureReasonDeregister(bool /*isLast*/, act_t act);

    void sendPowerFailureReasonUpdate(const ::std::string& data, act_t act);

    void sendPowerFailureReasonGetUpdate(const ::std::string& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setPowerFailureReason(const ::std::string& data);

    const ::std::string& getPowerFailureReason() const;

    ::std::string& getPowerFailureReasonMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property PowerFailureReason.
     *
     * <b>Documentation of 'PowerFailureReason'</b>:
     *
     * If the meaning of "PowerFailureReason" isn't clear, then there should be a description here.
     */
    void sendPowerFailureReasonNotification();

    // property CurrentHwMode

    /**
     * This function will be called if the component receives a "registration"
     * message for the property CurrentHwMode. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendCurrentHwModeUpdate(). The parameter isFirst is true if the count
     * of the registered clients is one otherwise the parameter is false.
     *
     * <b>Documentation of 'CurrentHwMode'</b>:
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onCurrentHwModeRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property CurrentHwMode.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'CurrentHwMode'</b>:
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onCurrentHwModeDeregister(bool /*isLast*/, act_t act);

    void sendCurrentHwModeUpdate(const ::std::string& data, act_t act);

    void sendCurrentHwModeGetUpdate(const ::std::string& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'CurrentHwMode'</b>:
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onCurrentHwModeGet(const ::boost::shared_ptr< CurrentHwModeGet >& currentHwMode);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'CurrentHwMode'</b>:
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setCurrentHwMode(const ::std::string& data);

    const ::std::string& getCurrentHwMode() const;

    ::std::string& getCurrentHwModeMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property CurrentHwMode.
     *
     * <b>Documentation of 'CurrentHwMode'</b>:
     *
     * If the meaning of "CurrentHwMode" isn't clear, then there should be a description here.
     */
    void sendCurrentHwModeNotification();

    // property MaximumStationsAllowed

    /**
     * This function will be called if the component receives a "registration"
     * message for the property MaximumStationsAllowed. The default
     * implementation sends back a notification message  with the current
     * content of the property. It is possible to override the function, if
     * the user wants to react on the registration event of the property. In
     * this case it is necessary to send the notification manually. Use the
     * function sendMaximumStationsAllowedUpdate(). The parameter isFirst is
     * true if the count of the registered clients is one otherwise the
     * parameter is false.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onMaximumStationsAllowedRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property MaximumStationsAllowed.  The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onMaximumStationsAllowedDeregister(bool /*isLast*/, act_t act);

    void sendMaximumStationsAllowedUpdate(uint16 data, act_t act);

    void sendMaximumStationsAllowedGetUpdate(uint16 data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& maximumStationsAllowed);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'MaximumStationsAllowed'</b>:
     *
     * If the meaning of "MaximumStationsAllowed" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setMaximumStationsAllowed(uint16 data);

    uint16 getMaximumStationsAllowed() const;

    // property SupportedChannels

    /**
     * This function will be called if the component receives a "registration"
     * message for the property SupportedChannels. The default implementation
     * sends back a notification message  with the current content of the
     * property. It is possible to override the function, if the user wants to
     * react on the registration event of the property. In this case it is
     * necessary to send the notification manually. Use the function
     * sendSupportedChannelsUpdate(). The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onSupportedChannelsRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property SupportedChannels.  The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onSupportedChannelsDeregister(bool /*isLast*/, act_t act);

    void sendSupportedChannelsUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data, act_t act);

    void sendSupportedChannelsGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& supportedChannels);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setSupportedChannels(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& data);

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& getSupportedChannels() const;

    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& getSupportedChannelsMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property SupportedChannels.
     *
     * <b>Documentation of 'SupportedChannels'</b>:
     *
     * If the meaning of "SupportedChannels" isn't clear, then there should be a description here.
     */
    void sendSupportedChannelsNotification();

    // property HWFeatures

    /**
     * This function will be called if the component receives a "registration"
     * message for the property HWFeatures. The default implementation sends
     * back a notification message  with the current content of the property.
     * It is possible to override the function, if the user wants to react on
     * the registration event of the property. In this case it is necessary to
     * send the notification manually. Use the function
     * sendHWFeaturesUpdate(). The parameter isFirst is true if the count of
     * the registered clients is one otherwise the parameter is false.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onHWFeaturesRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property HWFeatures.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onHWFeaturesDeregister(bool /*isLast*/, act_t act);

    void sendHWFeaturesUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data, act_t act);

    void sendHWFeaturesGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& hWFeatures);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setHWFeatures(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& data);

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& getHWFeatures() const;

    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& getHWFeaturesMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property HWFeatures.
     *
     * <b>Documentation of 'HWFeatures'</b>:
     *
     * If the meaning of "HWFeatures" isn't clear, then there should be a description here.
     */
    void sendHWFeaturesNotification();

    // property Tethering

    /**
     * This function will be called if the component receives a "registration"
     * message for the property Tethering. The default implementation sends
     * back a notification message  with the current content of the property.
     * It is possible to override the function, if the user wants to react on
     * the registration event of the property. In this case it is necessary to
     * send the notification manually. Use the function sendTetheringUpdate().
     * The parameter isFirst is true if the count of the registered clients is
     * one otherwise the parameter is false.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onTetheringRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property Tethering.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onTetheringDeregister(bool /*isLast*/, act_t act);

    void sendTetheringUpdate(bool data, act_t act);

    void sendTetheringGetUpdate(bool data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setTethering(bool data);

    bool getTethering() const;

    // property IPv4Pool

    /**
     * This function will be called if the component receives a "registration"
     * message for the property IPv4Pool. The default implementation sends
     * back a notification message  with the current content of the property.
     * It is possible to override the function, if the user wants to react on
     * the registration event of the property. In this case it is necessary to
     * send the notification manually. Use the function sendIPv4PoolUpdate().
     * The parameter isFirst is true if the count of the registered clients is
     * one otherwise the parameter is false.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param isFirst true if count of registered clients is one
     */
    virtual void onIPv4PoolRegister(bool /*isFirst*/, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the property IPv4Pool.  The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onIPv4PoolDeregister(bool /*isLast*/, act_t act);

    void sendIPv4PoolUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data, act_t act);

    void sendIPv4PoolGetUpdate(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data, act_t act);

    /**
     * This function will be called if the component receives a "get" message
     * from the client. The default implementation sends back a notification
     * message with the current content of the property. If the property
     * supports options, override the method to modify the content (in
     * dependence on the options) before sending it back to the client.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param getOptions
     */
    virtual void onIPv4PoolGet(const ::boost::shared_ptr< IPv4PoolGet >& iPv4Pool);

    /**
     * The function sets the property value. If the value has changed the
     * framework will send a notification message to all registered clients
     * automatically.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     *
     * @param data
     */
    void setIPv4Pool(const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& data);

    const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& getIPv4Pool() const;

    ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& getIPv4PoolMutable();
    /**
     * The function sends a notification to all registered clients of the
     * property IPv4Pool.
     *
     * <b>Documentation of 'IPv4Pool'</b>:
     *
     * If the meaning of "IPv4Pool" isn't clear, then there should be a description here.
     */
    void sendIPv4PoolNotification();

    // request GetAccessPoints

    /**
     * This function will be called if the component receives the client
     * request "GetAccessPointsRequest". The service implementation has to
     * process the request and send the response with
     * sendGetAccessPointsResponse().
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     */
    virtual void onGetAccessPointsRequest (const ::boost::shared_ptr< GetAccessPointsRequest >& getAccessPoints) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onGetAccessPointsRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'GetAccessPoints'</b>:
     *
     * If the meaning of "GetAccessPoints" isn't clear, then there should be a description here.
     */
    void sendGetAccessPointsResponse (const ::Stub::WapdmanServiceTypes::StructAPList& accesspoints, act_t act = 0);

    // request RegisterAgent

    /**
     * This function will be called if the component receives the client
     * request "RegisterAgentRequest". The service implementation has to
     * process the request and send the response with
     * sendRegisterAgentResponse().
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     */
    virtual void onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& registerAgent) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onRegisterAgentRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     */
    void sendRegisterAgentResponse (act_t act = 0);

    // request UnregisterAgent

    /**
     * This function will be called if the component receives the client
     * request "UnregisterAgentRequest". The service implementation has to
     * process the request and send the response with
     * sendUnregisterAgentResponse().
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     */
    virtual void onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& unregisterAgent) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onUnregisterAgentRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     */
    void sendUnregisterAgentResponse (act_t act = 0);

    // request FindAccessPoint

    /**
     * This function will be called if the component receives the client
     * request "FindAccessPointRequest". The service implementation has to
     * process the request and send the response with
     * sendFindAccessPointResponse().
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     */
    virtual void onFindAccessPointRequest (const ::boost::shared_ptr< FindAccessPointRequest >& findAccessPoint) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onFindAccessPointRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'FindAccessPoint'</b>:
     *
     * If the meaning of "FindAccessPoint" isn't clear, then there should be a description here.
     */
    void sendFindAccessPointResponse (const ::std::string& accesspoint, act_t act = 0);

    // request MacAddressAsGet

    /**
     * This function will be called if the component receives the client
     * request "MacAddressAsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendMacAddressAsGetResponse().
     *
     * <b>Documentation of 'MacAddressAsGet'</b>:
     *
     * If the meaning of "MacAddressAsGet" isn't clear, then there should be a description here.
     */
    virtual void onMacAddressAsGetRequest (const ::boost::shared_ptr< MacAddressAsGetRequest >& macAddressAsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onMacAddressAsGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'MacAddressAsGet'</b>:
     *
     * If the meaning of "MacAddressAsGet" isn't clear, then there should be a description here.
     */
    void sendMacAddressAsGetResponse (const ::std::string& macaddressasget, act_t act = 0);

    // request AccesspointAsGet

    /**
     * This function will be called if the component receives the client
     * request "AccesspointAsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendAccesspointAsGetResponse().
     *
     * <b>Documentation of 'AccesspointAsGet'</b>:
     *
     * If the meaning of "AccesspointAsGet" isn't clear, then there should be a description here.
     */
    virtual void onAccesspointAsGetRequest (const ::boost::shared_ptr< AccesspointAsGetRequest >& accesspointAsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onAccesspointAsGetRequest()). It is not
     * necessary to pass the act (asynchronous completion token), if you call
     * the response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'AccesspointAsGet'</b>:
     *
     * If the meaning of "AccesspointAsGet" isn't clear, then there should be a description here.
     */
    void sendAccesspointAsGetResponse (const ::std::string& accesspointobjpath, act_t act = 0);

    // request InterfaceAsGet

    /**
     * This function will be called if the component receives the client
     * request "InterfaceAsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendInterfaceAsGetResponse().
     *
     * <b>Documentation of 'InterfaceAsGet'</b>:
     *
     * If the meaning of "InterfaceAsGet" isn't clear, then there should be a description here.
     */
    virtual void onInterfaceAsGetRequest (const ::boost::shared_ptr< InterfaceAsGetRequest >& interfaceAsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onInterfaceAsGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'InterfaceAsGet'</b>:
     *
     * If the meaning of "InterfaceAsGet" isn't clear, then there should be a description here.
     */
    void sendInterfaceAsGetResponse (const ::std::string& interfaceasget, act_t act = 0);

    // request IPAddressAsGet

    /**
     * This function will be called if the component receives the client
     * request "IPAddressAsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendIPAddressAsGetResponse().
     *
     * <b>Documentation of 'IPAddressAsGet'</b>:
     *
     * If the meaning of "IPAddressAsGet" isn't clear, then there should be a description here.
     */
    virtual void onIPAddressAsGetRequest (const ::boost::shared_ptr< IPAddressAsGetRequest >& iPAddressAsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onIPAddressAsGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'IPAddressAsGet'</b>:
     *
     * If the meaning of "IPAddressAsGet" isn't clear, then there should be a description here.
     */
    void sendIPAddressAsGetResponse (const ::std::string& ipaddressasget, act_t act = 0);

    // request HostnameAsGet

    /**
     * This function will be called if the component receives the client
     * request "HostnameAsGetRequest". The service implementation has to
     * process the request and send the response with
     * sendHostnameAsGetResponse().
     *
     * <b>Documentation of 'HostnameAsGet'</b>:
     *
     * If the meaning of "HostnameAsGet" isn't clear, then there should be a description here.
     */
    virtual void onHostnameAsGetRequest (const ::boost::shared_ptr< HostnameAsGetRequest >& hostnameAsGet) = 0;

    /**
     * The function sends a response to the client, which sent the
     * corresponding request (onHostnameAsGetRequest()). It is not necessary
     * to pass the act (asynchronous completion token), if you call the
     * response function inside the body of the corresponding request.
     *
     * <b>Documentation of 'HostnameAsGet'</b>:
     *
     * If the meaning of "HostnameAsGet" isn't clear, then there should be a description here.
     */
    void sendHostnameAsGetResponse (const ::std::string& hostnameasget, act_t act = 0);

    /**
     * This function will be called if the component receives a "registration"
     * message for the event AccessPointAdded. The function sends back the
     * confirmation message 'sendAccessPointAddedRegisterConfirmation' back by
     * default. Is possible to override the function, if the user wants to
     * react on the registration event. The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * Events
     *
     * @param isFirst true if the count of the registered clients is one
     */
    virtual void onAccessPointAddedRegister(bool isFirst, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the event  AccessPointAdded. The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * Events
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onAccessPointAddedDeregister(bool isLast, act_t act);


    /**
     * This function sends a notification to all registered clients of the
     * event AccessPointAdded.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * Events
     */
    void sendAccessPointAddedEvent(const ::std::string& data);

    /**
     * This function sends a confirmation to the client when the
     * AccessPointAdded event registration was successful. When overriding the
     * register default implementation this method needs to be called.
     *
     * <b>Documentation of 'AccessPointAdded'</b>:
     *
     * Events
     */
    void sendAccessPointAddedRegisterConfirmation(act_t act);

    /**
     * This function will be called if the component receives a "registration"
     * message for the event AccessPointRemoved. The function sends back the
     * confirmation message 'sendAccessPointRemovedRegisterConfirmation' back
     * by default. Is possible to override the function, if the user wants to
     * react on the registration event. The parameter isFirst is true if the
     * count of the registered clients is one otherwise the parameter is
     * false.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     *
     * @param isFirst true if the count of the registered clients is one
     */
    virtual void onAccessPointRemovedRegister(bool isFirst, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the event  AccessPointRemoved. The default
     * implementation does nothing. It is possible to override the function,
     * if the user wants to react on the deregistration. The parameter isLast
     * is false if no client is registered anymore, otherwise it's true.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onAccessPointRemovedDeregister(bool isLast, act_t act);


    /**
     * This function sends a notification to all registered clients of the
     * event AccessPointRemoved.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     */
    void sendAccessPointRemovedEvent(const ::std::string& data);

    /**
     * This function sends a confirmation to the client when the
     * AccessPointRemoved event registration was successful. When overriding
     * the register default implementation this method needs to be called.
     *
     * <b>Documentation of 'AccessPointRemoved'</b>:
     *
     * If the meaning of "AccessPointRemoved" isn't clear, then there should be a description here.
     */
    void sendAccessPointRemovedRegisterConfirmation(act_t act);

    /**
     * This function will be called if the component receives a "registration"
     * message for the event AssociatedStationsChanged. The function sends
     * back the confirmation message
     * 'sendAssociatedStationsChangedRegisterConfirmation' back by default. Is
     * possible to override the function, if the user wants to react on the
     * registration event. The parameter isFirst is true if the count of the
     * registered clients is one otherwise the parameter is false.
     *
     * <b>Documentation of 'AssociatedStationsChanged'</b>:
     *
     * If the meaning of "AssociatedStationsChanged" isn't clear, then there should be a description here.
     *
     * @param isFirst true if the count of the registered clients is one
     */
    virtual void onAssociatedStationsChangedRegister(bool isFirst, act_t act);

    /**
     * This function will be called if the component receives a
     * "deregistration" message for the event  AssociatedStationsChanged. The
     * default implementation does nothing. It is possible to override the
     * function, if the user wants to react on the deregistration. The
     * parameter isLast is false if no client is registered anymore, otherwise
     * it's true.
     *
     * <b>Documentation of 'AssociatedStationsChanged'</b>:
     *
     * If the meaning of "AssociatedStationsChanged" isn't clear, then there should be a description here.
     *
     * @param isLast true if no client is registered anymore
     */
    virtual void onAssociatedStationsChangedDeregister(bool isLast, act_t act);


    /**
     * This function sends a notification to all registered clients of the
     * event AssociatedStationsChanged.
     *
     * <b>Documentation of 'AssociatedStationsChanged'</b>:
     *
     * If the meaning of "AssociatedStationsChanged" isn't clear, then there should be a description here.
     */
    void sendAssociatedStationsChangedEvent(const ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged& data);

    /**
     * This function sends a confirmation to the client when the
     * AssociatedStationsChanged event registration was successful. When
     * overriding the register default implementation this method needs to be
     * called.
     *
     * <b>Documentation of 'AssociatedStationsChanged'</b>:
     *
     * If the meaning of "AssociatedStationsChanged" isn't clear, then there should be a description here.
     */
    void sendAssociatedStationsChangedRegisterConfirmation(act_t act);

private:
    WapdmanServiceStub(const WapdmanServiceStub&);

    WapdmanServiceStub& operator=(const WapdmanServiceStub&);

























    PowerStateUpdate _PowerStateProperty;


    PowerFailureReasonUpdate _PowerFailureReasonProperty;


    CurrentHwModeUpdate _CurrentHwModeProperty;


    MaximumStationsAllowedUpdate _MaximumStationsAllowedProperty;


    SupportedChannelsUpdate _SupportedChannelsProperty;


    HWFeaturesUpdate _HWFeaturesProperty;


    TetheringUpdate _TetheringProperty;


    IPv4PoolUpdate _IPv4PoolProperty;











    AccessPointAddedEvent _AccessPointAddedEvent;


    AccessPointRemovedEvent _AccessPointRemovedEvent;


    AssociatedStationsChangedEvent _AssociatedStationsChangedEvent;

    WapdmanServiceStubConnector* _stubConnector;

    ::asf::cms::CmsStubDelegate* _cmsStubDelegate;

    DECLARE_CLASS_LOGGER();

    friend class WapdmanServiceStubConnector;
};

} // namespace WapdmanService
} // namespace Stub

#endif // STUB_WAPDMANSERVICESTUB_H
