/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "Stub/WapdmanService.h"
#include "Stub/WapdmanServiceProxy.h"
#include "Stub/WapdmanServiceTypes.h"
#include "asf/cms/CmsProxyRegistry.h"
#include "asf/core/Types.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "boost/shared_ptr.hpp"
#include <string>
#include <vector>

namespace Stub {
namespace WapdmanService {

DEFINE_CLASS_LOGGER("/Stub/WapdmanService", WapdmanServiceProxy);
DEFINE_CLASS_LOGGER("/Stub/WapdmanService", WapdmanServiceClientBase);


// static
::boost::shared_ptr< WapdmanServiceProxy > WapdmanServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cms::CmsProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<WapdmanServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< WapdmanServiceProxy >  proxyNew(new WapdmanServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew);
    return proxyNew;
}

// static
::boost::shared_ptr< WapdmanServiceProxy > WapdmanServiceProxy::createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< WapdmanServiceProxy >  proxyNew(new WapdmanServiceProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew, uriAddress);
    return proxyNew;
}

WapdmanServiceProxy::WapdmanServiceProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    CmsProxy(portName,serviceAvailable, "Stub.WapdmanService", _logger) {
    LOG_INFO ("Create proxy=%p, compId=%d, portName='%s'", this, _cmsProxyDelegate.getClientComponentId(), getPortName().c_str());
}

WapdmanServiceProxy::~WapdmanServiceProxy () {
    ::asf::cms::CmsProxyRegistry::getInstance().deregisterProxy(_cmsProxyDelegate.getProxyId());
}

void WapdmanServiceProxy::sendDeregisterAll () {
    sendPowerStateDeregisterAll();
    sendPowerFailureReasonDeregisterAll();
    sendCurrentHwModeDeregisterAll();
    sendMaximumStationsAllowedDeregisterAll();
    sendSupportedChannelsDeregisterAll();
    sendHWFeaturesDeregisterAll();
    sendTetheringDeregisterAll();
    sendIPv4PoolDeregisterAll();
    sendAccessPointAddedDeregisterAll();
    sendAccessPointRemovedDeregisterAll();
    sendAssociatedStationsChangedDeregisterAll();
}

act_t WapdmanServiceProxy::sendSetSSIDRequest(SetSSIDCallbackIF& cb, const ::std::vector< uint8 >& ssid, bool utf_ssid) {
    ::boost::shared_ptr< SetSSIDRequest > para(new SetSSIDRequest(ssid, utf_ssid));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"setSSID",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)setSSIDRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "SetSSID", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendDeAuthenticateStationRequest(DeAuthenticateStationCallbackIF& cb, const ::std::string& address) {
    ::boost::shared_ptr< DeAuthenticateStationRequest > para(new DeAuthenticateStationRequest(address));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"DeAuthenticateStation",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)deAuthenticateStationRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "DeAuthenticateStation", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendBlacklistStationRequest(BlacklistStationCallbackIF& cb, const ::std::string& address, bool allow) {
    ::boost::shared_ptr< BlacklistStationRequest > para(new BlacklistStationRequest(address, allow));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"BlacklistStation",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)blacklistStationRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "BlacklistStation", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendSetOperatingChannelsRequest(SetOperatingChannelsCallbackIF& cb, const ::std::vector< uint16 >& channels) {
    ::boost::shared_ptr< SetOperatingChannelsRequest > para(new SetOperatingChannelsRequest(channels));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"SetOperatingChannels",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)setOperatingChannelsRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "SetOperatingChannels", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendStartWPSPushButtonRequest(StartWPSPushButtonCallbackIF& cb) {
    ::boost::shared_ptr< StartWPSPushButtonRequest > para(new StartWPSPushButtonRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"StartWPSPushButton",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)startWPSPushButtonRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "StartWPSPushButton", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendCancelWPSRequest(CancelWPSCallbackIF& cb) {
    ::boost::shared_ptr< CancelWPSRequest > para(new CancelWPSRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"CancelWPS",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)cancelWPSRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "CancelWPS", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendRegisterVendorServiceRequest(RegisterVendorServiceCallbackIF& cb, const ::boost::ptr_vector< ::std::vector< uint8 > >& IEs) {
    ::boost::shared_ptr< RegisterVendorServiceRequest > para(new RegisterVendorServiceRequest(IEs));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"RegisterVendorService",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)registerVendorServiceRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "RegisterVendorService", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendUnregisterVendorServiceRequest(UnregisterVendorServiceCallbackIF& cb, const ::boost::ptr_vector< ::std::vector< uint8 > >& IEs) {
    ::boost::shared_ptr< UnregisterVendorServiceRequest > para(new UnregisterVendorServiceRequest(IEs));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"UnregisterVendorService",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)unregisterVendorServiceRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "UnregisterVendorService", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendGetAssociatedStationsRequest(GetAssociatedStationsCallbackIF& cb) {
    ::boost::shared_ptr< GetAssociatedStationsRequest > para(new GetAssociatedStationsRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"GetAssociatedStations",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)getAssociatedStationsRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "GetAssociatedStations", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendGetRequest(GetCallbackIF& cb, const ::std::string& interface_name, const ::std::string& property_name) {
    ::boost::shared_ptr< GetRequest > para(new GetRequest(interface_name, property_name));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"Get",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)getRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "Get", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendSSIDGetRequest(SSIDGetCallbackIF& cb) {
    ::boost::shared_ptr< SSIDGetRequest > para(new SSIDGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"SSIDGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)sSIDGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "SSIDGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendSecurityRequest(SecurityCallbackIF& cb, const ::std::string& security) {
    ::boost::shared_ptr< SecurityRequest > para(new SecurityRequest(security));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"Security",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)securityRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "Security", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendMacAddressGetRequest(MacAddressGetCallbackIF& cb) {
    ::boost::shared_ptr< MacAddressGetRequest > para(new MacAddressGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"MacAddressGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)macAddressGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "MacAddressGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendInterfaceGetRequest(InterfaceGetCallbackIF& cb) {
    ::boost::shared_ptr< InterfaceGetRequest > para(new InterfaceGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"InterfaceGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)interfaceGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "InterfaceGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendPassphraseGetRequest(PassphraseGetCallbackIF& cb) {
    ::boost::shared_ptr< PassphraseGetRequest > para(new PassphraseGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"PassphraseGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)passphraseGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "PassphraseGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendPoweredGetRequest(PoweredGetCallbackIF& cb) {
    ::boost::shared_ptr< PoweredGetRequest > para(new PoweredGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"PoweredGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)poweredGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "PoweredGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendHiddenGetRequest(HiddenGetCallbackIF& cb) {
    ::boost::shared_ptr< HiddenGetRequest > para(new HiddenGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"HiddenGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)hiddenGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "HiddenGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendCurrentOperatingChannelGetRequest(CurrentOperatingChannelGetCallbackIF& cb) {
    ::boost::shared_ptr< CurrentOperatingChannelGetRequest > para(new CurrentOperatingChannelGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"CurrentOperatingChannelGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)currentOperatingChannelGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "CurrentOperatingChannelGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendVendorIEsGetRequest(VendorIEsGetCallbackIF& cb) {
    ::boost::shared_ptr< VendorIEsGetRequest > para(new VendorIEsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"VendorIEsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)vendorIEsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "VendorIEsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendPoweredSetRequest(PoweredSetCallbackIF& cb, bool powered) {
    ::boost::shared_ptr< PoweredSetRequest > para(new PoweredSetRequest(powered));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"PoweredSet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)poweredSetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "PoweredSet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendHiddenSetRequest(HiddenSetCallbackIF& cb, bool hidden) {
    ::boost::shared_ptr< HiddenSetRequest > para(new HiddenSetRequest(hidden));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"HiddenSet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)hiddenSetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "HiddenSet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendPassphraseSetRequest(PassphraseSetCallbackIF& cb, const ::std::string& passphrase) {
    ::boost::shared_ptr< PassphraseSetRequest > para(new PassphraseSetRequest(passphrase));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"PassphraseSet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)passphraseSetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "PassphraseSet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendTetheringSetRequest(TetheringSetCallbackIF& cb, bool tethering) {
    ::boost::shared_ptr< TetheringSetRequest > para(new TetheringSetRequest(tethering));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"TetheringSet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)tetheringSetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "TetheringSet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

// Property 'PowerState'

act_t WapdmanServiceProxy::sendPowerStateRegister(PowerStateRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"PowerState",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)powerStatePropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerState", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendPowerStateDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "PowerState")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"PowerState",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "PowerState", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "PowerState", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendPowerStateDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("PowerState");
}

act_t WapdmanServiceProxy::sendPowerStateGet(PowerStateGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"PowerState",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)powerStatePropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "PowerState", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::std::string& WapdmanServiceProxy::getPowerState() const {
    return _powerState.get();
}

bool WapdmanServiceProxy::hasPowerState() const {
    return _powerState.hasValue();
}

// Property 'PowerFailureReason'

act_t WapdmanServiceProxy::sendPowerFailureReasonRegister(PowerFailureReasonRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"PowerFailureReason",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)powerFailureReasonPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PowerFailureReason", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendPowerFailureReasonDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "PowerFailureReason")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"PowerFailureReason",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "PowerFailureReason", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "PowerFailureReason", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendPowerFailureReasonDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("PowerFailureReason");
}

act_t WapdmanServiceProxy::sendPowerFailureReasonGet(PowerFailureReasonGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"PowerFailureReason",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)powerFailureReasonPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "PowerFailureReason", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::std::string& WapdmanServiceProxy::getPowerFailureReason() const {
    return _powerFailureReason.get();
}

bool WapdmanServiceProxy::hasPowerFailureReason() const {
    return _powerFailureReason.hasValue();
}

// Property 'CurrentHwMode'

act_t WapdmanServiceProxy::sendCurrentHwModeRegister(CurrentHwModeRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"CurrentHwMode",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)currentHwModePropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentHwMode", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendCurrentHwModeDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "CurrentHwMode")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"CurrentHwMode",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "CurrentHwMode", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "CurrentHwMode", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendCurrentHwModeDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("CurrentHwMode");
}

act_t WapdmanServiceProxy::sendCurrentHwModeGet(CurrentHwModeGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"CurrentHwMode",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)currentHwModePropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "CurrentHwMode", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::std::string& WapdmanServiceProxy::getCurrentHwMode() const {
    return _currentHwMode.get();
}

bool WapdmanServiceProxy::hasCurrentHwMode() const {
    return _currentHwMode.hasValue();
}

// Property 'MaximumStationsAllowed'

act_t WapdmanServiceProxy::sendMaximumStationsAllowedRegister(MaximumStationsAllowedRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"MaximumStationsAllowed",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)maximumStationsAllowedPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MaximumStationsAllowed", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendMaximumStationsAllowedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "MaximumStationsAllowed")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"MaximumStationsAllowed",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "MaximumStationsAllowed", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "MaximumStationsAllowed", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendMaximumStationsAllowedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("MaximumStationsAllowed");
}

act_t WapdmanServiceProxy::sendMaximumStationsAllowedGet(MaximumStationsAllowedGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"MaximumStationsAllowed",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)maximumStationsAllowedPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "MaximumStationsAllowed", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

uint16 WapdmanServiceProxy::getMaximumStationsAllowed() const {
    return _maximumStationsAllowed.get();
}

bool WapdmanServiceProxy::hasMaximumStationsAllowed() const {
    return _maximumStationsAllowed.hasValue();
}

// Property 'SupportedChannels'

act_t WapdmanServiceProxy::sendSupportedChannelsRegister(SupportedChannelsRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"SupportedChannels",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)supportedChannelsPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SupportedChannels", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendSupportedChannelsDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "SupportedChannels")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"SupportedChannels",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "SupportedChannels", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "SupportedChannels", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendSupportedChannelsDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("SupportedChannels");
}

act_t WapdmanServiceProxy::sendSupportedChannelsGet(SupportedChannelsGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"SupportedChannels",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)supportedChannelsPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "SupportedChannels", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList >& WapdmanServiceProxy::getSupportedChannels() const {
    return _supportedChannels.get();
}

bool WapdmanServiceProxy::hasSupportedChannels() const {
    return _supportedChannels.hasValue();
}

// Property 'HWFeatures'

act_t WapdmanServiceProxy::sendHWFeaturesRegister(HWFeaturesRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"HWFeatures",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)hWFeaturesPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HWFeatures", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendHWFeaturesDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "HWFeatures")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"HWFeatures",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "HWFeatures", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "HWFeatures", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendHWFeaturesDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("HWFeatures");
}

act_t WapdmanServiceProxy::sendHWFeaturesGet(HWFeaturesGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"HWFeatures",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)hWFeaturesPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "HWFeatures", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList >& WapdmanServiceProxy::getHWFeatures() const {
    return _hWFeatures.get();
}

bool WapdmanServiceProxy::hasHWFeatures() const {
    return _hWFeatures.hasValue();
}

// Property 'Tethering'

act_t WapdmanServiceProxy::sendTetheringRegister(TetheringRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"Tethering",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)tetheringPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Tethering", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendTetheringDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "Tethering")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"Tethering",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "Tethering", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "Tethering", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendTetheringDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("Tethering");
}

act_t WapdmanServiceProxy::sendTetheringGet(TetheringGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"Tethering",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)tetheringPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "Tethering", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

bool WapdmanServiceProxy::getTethering() const {
    return _tethering.get();
}

bool WapdmanServiceProxy::hasTethering() const {
    return _tethering.hasValue();
}

// Property 'IPv4Pool'

act_t WapdmanServiceProxy::sendIPv4PoolRegister(IPv4PoolRegisterCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"IPv4Pool",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)iPv4PoolPropertyCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IPv4Pool", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendIPv4PoolDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "IPv4Pool")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"IPv4Pool",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "IPv4Pool", act);
        }
    } else {
        LOG_WARN ("-> send%sDeregister: invalid act=%" PRIuPTR ", returning false", "IPv4Pool", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendIPv4PoolDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("IPv4Pool");
}

act_t WapdmanServiceProxy::sendIPv4PoolGet(IPv4PoolGetCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get,_cmsProxyDelegate.getServiceId(),"IPv4Pool",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)iPv4PoolPropertyCallback, msg);
    if(_cmsProxyDelegate.get(msg)) {
        LOG_INFO ("-> send%sGet(cb=%p)", "IPv4Pool", &cb);
    }
    LOG_INFO ("Returning %" PRIuPTR, regId);
    return regId;
}

const ::boost::ptr_vector< ::Stub::WapdmanServiceTypes::StructIPv4List >& WapdmanServiceProxy::getIPv4Pool() const {
    return _iPv4Pool.get();
}

bool WapdmanServiceProxy::hasIPv4Pool() const {
    return _iPv4Pool.hasValue();
}

act_t WapdmanServiceProxy::sendGetAccessPointsRequest(GetAccessPointsCallbackIF& cb) {
    ::boost::shared_ptr< GetAccessPointsRequest > para(new GetAccessPointsRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"GetAccessPoints",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)getAccessPointsRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "GetAccessPoints", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& path) {
    ::boost::shared_ptr< RegisterAgentRequest > para(new RegisterAgentRequest(path));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"RegisterAgent",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)registerAgentRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "RegisterAgent", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& path) {
    ::boost::shared_ptr< UnregisterAgentRequest > para(new UnregisterAgentRequest(path));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"UnregisterAgent",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)unregisterAgentRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "UnregisterAgent", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendFindAccessPointRequest(FindAccessPointCallbackIF& cb, const ::std::string& pattern) {
    ::boost::shared_ptr< FindAccessPointRequest > para(new FindAccessPointRequest(pattern));
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"FindAccessPoint",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)findAccessPointRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "FindAccessPoint", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendMacAddressAsGetRequest(MacAddressAsGetCallbackIF& cb) {
    ::boost::shared_ptr< MacAddressAsGetRequest > para(new MacAddressAsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"MacAddressAsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)macAddressAsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "MacAddressAsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendAccesspointAsGetRequest(AccesspointAsGetCallbackIF& cb) {
    ::boost::shared_ptr< AccesspointAsGetRequest > para(new AccesspointAsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"AccesspointAsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)accesspointAsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "AccesspointAsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendInterfaceAsGetRequest(InterfaceAsGetCallbackIF& cb) {
    ::boost::shared_ptr< InterfaceAsGetRequest > para(new InterfaceAsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"InterfaceAsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)interfaceAsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "InterfaceAsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendIPAddressAsGetRequest(IPAddressAsGetCallbackIF& cb) {
    ::boost::shared_ptr< IPAddressAsGetRequest > para(new IPAddressAsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"IPAddressAsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)iPAddressAsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "IPAddressAsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

act_t WapdmanServiceProxy::sendHostnameAsGetRequest(HostnameAsGetCallbackIF& cb) {
    ::boost::shared_ptr< HostnameAsGetRequest > para(new HostnameAsGetRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Request,_cmsProxyDelegate.getServiceId(),"HostnameAsGet",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)hostnameAsGetRequestCallback, msg);
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR, "HostnameAsGet", &cb, regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

// Event 'AccessPointAdded'
act_t WapdmanServiceProxy::sendAccessPointAddedRegister(AccessPointAddedCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"AccessPointAdded",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)accessPointAddedEventCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccessPointAdded", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendAccessPointAddedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "AccessPointAdded")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"AccessPointAdded",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "AccessPointAdded", act);
        }
    } else {
        LOG_WARN ("-> %s: invalid act=%" PRIuPTR ", returning false", "send%sDeregister", "AccessPointAdded", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendAccessPointAddedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("AccessPointAdded");
}

// Event 'AccessPointRemoved'
act_t WapdmanServiceProxy::sendAccessPointRemovedRegister(AccessPointRemovedCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"AccessPointRemoved",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)accessPointRemovedEventCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccessPointRemoved", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendAccessPointRemovedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "AccessPointRemoved")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"AccessPointRemoved",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "AccessPointRemoved", act);
        }
    } else {
        LOG_WARN ("-> %s: invalid act=%" PRIuPTR ", returning false", "send%sDeregister", "AccessPointRemoved", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendAccessPointRemovedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("AccessPointRemoved");
}

// Event 'AssociatedStationsChanged'
act_t WapdmanServiceProxy::sendAssociatedStationsChangedRegister(AssociatedStationsChangedCallbackIF& cb) {
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register,_cmsProxyDelegate.getServiceId(),"AssociatedStationsChanged",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    act_t regId = _cmsProxyDelegate.registerCallback((void*)&cb,(::asf::cms::ProxyCallback)associatedStationsChangedEventCallback, msg);
    if(_cmsProxyDelegate.register_(msg)) {
        LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AssociatedStationsChanged", &cb, regId);
    }
    return regId;
}

bool WapdmanServiceProxy::sendAssociatedStationsChangedDeregister(act_t act) {
    if (_cmsProxyDelegate.hasRegistration (act, "AssociatedStationsChanged")) {
        ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Deregister,_cmsProxyDelegate.getServiceId(),"AssociatedStationsChanged",act,_cmsProxyDelegate.getProxyId());
        _cmsProxyDelegate.deregisterCallback(act);
        if(_cmsProxyDelegate.deregister(msg)) {
            LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning true", "AssociatedStationsChanged", act);
        }
    } else {
        LOG_WARN ("-> %s: invalid act=%" PRIuPTR ", returning false", "send%sDeregister", "AssociatedStationsChanged", act);
        return false;
    }
    return true;
}

void WapdmanServiceProxy::sendAssociatedStationsChangedDeregisterAll() {
    _cmsProxyDelegate.deregisterAll("AssociatedStationsChanged");
}

::asf::cms::CmsServiceStreamer* WapdmanServiceProxy::getStreamer() {
    ::asf::cms::CmsServiceStreamer* streamer=0;
    switch(_cmsProxyDelegate.getEncoding()) {
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json:
            streamer=&_streamerJson;
            break;
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__FastBin:
            streamer=&_streamerCmsBin;
            break;
        default:
            streamer=0;
            break;
    }
    return streamer;
}

// static
void WapdmanServiceProxy::setSSIDRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    SetSSIDCallbackIF* pcb = static_cast< SetSSIDCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< SetSSIDResponse > payload = ::boost::static_pointer_cast< SetSSIDResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSSID", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onSetSSIDResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SetSSIDError > error(new SetSSIDError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SetSSIDError > error = ::boost::static_pointer_cast< SetSSIDError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSSID", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSetSSIDError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::deAuthenticateStationRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    DeAuthenticateStationCallbackIF* pcb = static_cast< DeAuthenticateStationCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< DeAuthenticateStationResponse > payload = ::boost::static_pointer_cast< DeAuthenticateStationResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onDeAuthenticateStationResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< DeAuthenticateStationError > error(new DeAuthenticateStationError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< DeAuthenticateStationError > error = ::boost::static_pointer_cast< DeAuthenticateStationError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DeAuthenticateStation", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onDeAuthenticateStationError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::blacklistStationRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    BlacklistStationCallbackIF* pcb = static_cast< BlacklistStationCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< BlacklistStationResponse > payload = ::boost::static_pointer_cast< BlacklistStationResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BlacklistStation", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onBlacklistStationResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< BlacklistStationError > error(new BlacklistStationError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< BlacklistStationError > error = ::boost::static_pointer_cast< BlacklistStationError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BlacklistStation", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onBlacklistStationError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::setOperatingChannelsRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    SetOperatingChannelsCallbackIF* pcb = static_cast< SetOperatingChannelsCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< SetOperatingChannelsResponse > payload = ::boost::static_pointer_cast< SetOperatingChannelsResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetOperatingChannels", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onSetOperatingChannelsResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SetOperatingChannelsError > error(new SetOperatingChannelsError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SetOperatingChannelsError > error = ::boost::static_pointer_cast< SetOperatingChannelsError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetOperatingChannels", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSetOperatingChannelsError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::startWPSPushButtonRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    StartWPSPushButtonCallbackIF* pcb = static_cast< StartWPSPushButtonCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< StartWPSPushButtonResponse > payload = ::boost::static_pointer_cast< StartWPSPushButtonResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartWPSPushButton", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onStartWPSPushButtonResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< StartWPSPushButtonError > error(new StartWPSPushButtonError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< StartWPSPushButtonError > error = ::boost::static_pointer_cast< StartWPSPushButtonError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartWPSPushButton", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onStartWPSPushButtonError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::cancelWPSRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    CancelWPSCallbackIF* pcb = static_cast< CancelWPSCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< CancelWPSResponse > payload = ::boost::static_pointer_cast< CancelWPSResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelWPS", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onCancelWPSResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CancelWPSError > error(new CancelWPSError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CancelWPSError > error = ::boost::static_pointer_cast< CancelWPSError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelWPS", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCancelWPSError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::registerVendorServiceRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    RegisterVendorServiceCallbackIF* pcb = static_cast< RegisterVendorServiceCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< RegisterVendorServiceResponse > payload = ::boost::static_pointer_cast< RegisterVendorServiceResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterVendorService", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onRegisterVendorServiceResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< RegisterVendorServiceError > error(new RegisterVendorServiceError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< RegisterVendorServiceError > error = ::boost::static_pointer_cast< RegisterVendorServiceError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterVendorService", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onRegisterVendorServiceError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::unregisterVendorServiceRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    UnregisterVendorServiceCallbackIF* pcb = static_cast< UnregisterVendorServiceCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< UnregisterVendorServiceResponse > payload = ::boost::static_pointer_cast< UnregisterVendorServiceResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterVendorService", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onUnregisterVendorServiceResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< UnregisterVendorServiceError > error(new UnregisterVendorServiceError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< UnregisterVendorServiceError > error = ::boost::static_pointer_cast< UnregisterVendorServiceError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterVendorService", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onUnregisterVendorServiceError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::getAssociatedStationsRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    GetAssociatedStationsCallbackIF* pcb = static_cast< GetAssociatedStationsCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< GetAssociatedStationsResponse > payload = ::boost::static_pointer_cast< GetAssociatedStationsResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAssociatedStations", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onGetAssociatedStationsResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< GetAssociatedStationsError > error(new GetAssociatedStationsError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< GetAssociatedStationsError > error = ::boost::static_pointer_cast< GetAssociatedStationsError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAssociatedStations", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onGetAssociatedStationsError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::getRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    GetCallbackIF* pcb = static_cast< GetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< GetResponse > payload = ::boost::static_pointer_cast< GetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< GetError > error(new GetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< GetError > error = ::boost::static_pointer_cast< GetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::sSIDGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    SSIDGetCallbackIF* pcb = static_cast< SSIDGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< SSIDGetResponse > payload = ::boost::static_pointer_cast< SSIDGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SSIDGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onSSIDGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SSIDGetError > error(new SSIDGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SSIDGetError > error = ::boost::static_pointer_cast< SSIDGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SSIDGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSSIDGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::securityRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    SecurityCallbackIF* pcb = static_cast< SecurityCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< SecurityResponse > payload = ::boost::static_pointer_cast< SecurityResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Security", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onSecurityResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SecurityError > error(new SecurityError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SecurityError > error = ::boost::static_pointer_cast< SecurityError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Security", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSecurityError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::macAddressGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    MacAddressGetCallbackIF* pcb = static_cast< MacAddressGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< MacAddressGetResponse > payload = ::boost::static_pointer_cast< MacAddressGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MacAddressGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onMacAddressGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MacAddressGetError > error(new MacAddressGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MacAddressGetError > error = ::boost::static_pointer_cast< MacAddressGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MacAddressGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMacAddressGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::interfaceGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    InterfaceGetCallbackIF* pcb = static_cast< InterfaceGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< InterfaceGetResponse > payload = ::boost::static_pointer_cast< InterfaceGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "InterfaceGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onInterfaceGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< InterfaceGetError > error(new InterfaceGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< InterfaceGetError > error = ::boost::static_pointer_cast< InterfaceGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InterfaceGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onInterfaceGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::passphraseGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    PassphraseGetCallbackIF* pcb = static_cast< PassphraseGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< PassphraseGetResponse > payload = ::boost::static_pointer_cast< PassphraseGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PassphraseGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onPassphraseGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PassphraseGetError > error(new PassphraseGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PassphraseGetError > error = ::boost::static_pointer_cast< PassphraseGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PassphraseGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPassphraseGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::poweredGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    PoweredGetCallbackIF* pcb = static_cast< PoweredGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< PoweredGetResponse > payload = ::boost::static_pointer_cast< PoweredGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PoweredGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onPoweredGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PoweredGetError > error(new PoweredGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PoweredGetError > error = ::boost::static_pointer_cast< PoweredGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PoweredGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPoweredGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::hiddenGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    HiddenGetCallbackIF* pcb = static_cast< HiddenGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< HiddenGetResponse > payload = ::boost::static_pointer_cast< HiddenGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HiddenGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onHiddenGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< HiddenGetError > error(new HiddenGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< HiddenGetError > error = ::boost::static_pointer_cast< HiddenGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HiddenGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onHiddenGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::currentOperatingChannelGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    CurrentOperatingChannelGetCallbackIF* pcb = static_cast< CurrentOperatingChannelGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< CurrentOperatingChannelGetResponse > payload = ::boost::static_pointer_cast< CurrentOperatingChannelGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentOperatingChannelGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onCurrentOperatingChannelGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CurrentOperatingChannelGetError > error(new CurrentOperatingChannelGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CurrentOperatingChannelGetError > error = ::boost::static_pointer_cast< CurrentOperatingChannelGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentOperatingChannelGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCurrentOperatingChannelGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::vendorIEsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    VendorIEsGetCallbackIF* pcb = static_cast< VendorIEsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< VendorIEsGetResponse > payload = ::boost::static_pointer_cast< VendorIEsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "VendorIEsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onVendorIEsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< VendorIEsGetError > error(new VendorIEsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< VendorIEsGetError > error = ::boost::static_pointer_cast< VendorIEsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VendorIEsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onVendorIEsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::poweredSetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    PoweredSetCallbackIF* pcb = static_cast< PoweredSetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< PoweredSetResponse > payload = ::boost::static_pointer_cast< PoweredSetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PoweredSet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onPoweredSetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PoweredSetError > error(new PoweredSetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PoweredSetError > error = ::boost::static_pointer_cast< PoweredSetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PoweredSet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPoweredSetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::hiddenSetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    HiddenSetCallbackIF* pcb = static_cast< HiddenSetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< HiddenSetResponse > payload = ::boost::static_pointer_cast< HiddenSetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HiddenSet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onHiddenSetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< HiddenSetError > error(new HiddenSetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< HiddenSetError > error = ::boost::static_pointer_cast< HiddenSetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HiddenSet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onHiddenSetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::passphraseSetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    PassphraseSetCallbackIF* pcb = static_cast< PassphraseSetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< PassphraseSetResponse > payload = ::boost::static_pointer_cast< PassphraseSetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PassphraseSet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onPassphraseSetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PassphraseSetError > error(new PassphraseSetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PassphraseSetError > error = ::boost::static_pointer_cast< PassphraseSetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PassphraseSet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPassphraseSetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::tetheringSetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    TetheringSetCallbackIF* pcb = static_cast< TetheringSetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< TetheringSetResponse > payload = ::boost::static_pointer_cast< TetheringSetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "TetheringSet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onTetheringSetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< TetheringSetError > error(new TetheringSetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< TetheringSetError > error = ::boost::static_pointer_cast< TetheringSetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TetheringSet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onTetheringSetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::powerStatePropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< PowerStateUpdate > update = ::boost::static_pointer_cast< PowerStateUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_powerState = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerState", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            PowerStateRegisterCallbackIF* pcb = static_cast< PowerStateRegisterCallbackIF* >(callbackIf);
            pcb->onPowerStateUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            PowerStateGetCallbackIF* pcb = static_cast< PowerStateGetCallbackIF* >(callbackIf);
            pcb->onPowerStateGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        PowerStateRegisterCallbackIF* pcb = static_cast< PowerStateRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PowerStateRegisterError > error(new PowerStateRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PowerStateRegisterError > error = ::boost::static_pointer_cast< PowerStateRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerState", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPowerStateRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        PowerStateGetCallbackIF* pcb = static_cast< PowerStateGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PowerStateGetError > error(new PowerStateGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PowerStateGetError > error = ::boost::static_pointer_cast< PowerStateGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerState", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPowerStateGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::powerFailureReasonPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< PowerFailureReasonUpdate > update = ::boost::static_pointer_cast< PowerFailureReasonUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_powerFailureReason = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerFailureReason", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            PowerFailureReasonRegisterCallbackIF* pcb = static_cast< PowerFailureReasonRegisterCallbackIF* >(callbackIf);
            pcb->onPowerFailureReasonUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            PowerFailureReasonGetCallbackIF* pcb = static_cast< PowerFailureReasonGetCallbackIF* >(callbackIf);
            pcb->onPowerFailureReasonGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        PowerFailureReasonRegisterCallbackIF* pcb = static_cast< PowerFailureReasonRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PowerFailureReasonRegisterError > error(new PowerFailureReasonRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PowerFailureReasonRegisterError > error = ::boost::static_pointer_cast< PowerFailureReasonRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerFailureReason", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPowerFailureReasonRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        PowerFailureReasonGetCallbackIF* pcb = static_cast< PowerFailureReasonGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< PowerFailureReasonGetError > error(new PowerFailureReasonGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< PowerFailureReasonGetError > error = ::boost::static_pointer_cast< PowerFailureReasonGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PowerFailureReason", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onPowerFailureReasonGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::currentHwModePropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< CurrentHwModeUpdate > update = ::boost::static_pointer_cast< CurrentHwModeUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_currentHwMode = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentHwMode", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            CurrentHwModeRegisterCallbackIF* pcb = static_cast< CurrentHwModeRegisterCallbackIF* >(callbackIf);
            pcb->onCurrentHwModeUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            CurrentHwModeGetCallbackIF* pcb = static_cast< CurrentHwModeGetCallbackIF* >(callbackIf);
            pcb->onCurrentHwModeGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        CurrentHwModeRegisterCallbackIF* pcb = static_cast< CurrentHwModeRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CurrentHwModeRegisterError > error(new CurrentHwModeRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CurrentHwModeRegisterError > error = ::boost::static_pointer_cast< CurrentHwModeRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentHwMode", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCurrentHwModeRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        CurrentHwModeGetCallbackIF* pcb = static_cast< CurrentHwModeGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< CurrentHwModeGetError > error(new CurrentHwModeGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< CurrentHwModeGetError > error = ::boost::static_pointer_cast< CurrentHwModeGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentHwMode", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onCurrentHwModeGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::maximumStationsAllowedPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< MaximumStationsAllowedUpdate > update = ::boost::static_pointer_cast< MaximumStationsAllowedUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_maximumStationsAllowed = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "MaximumStationsAllowed", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            MaximumStationsAllowedRegisterCallbackIF* pcb = static_cast< MaximumStationsAllowedRegisterCallbackIF* >(callbackIf);
            pcb->onMaximumStationsAllowedUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            MaximumStationsAllowedGetCallbackIF* pcb = static_cast< MaximumStationsAllowedGetCallbackIF* >(callbackIf);
            pcb->onMaximumStationsAllowedGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        MaximumStationsAllowedRegisterCallbackIF* pcb = static_cast< MaximumStationsAllowedRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MaximumStationsAllowedRegisterError > error(new MaximumStationsAllowedRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MaximumStationsAllowedRegisterError > error = ::boost::static_pointer_cast< MaximumStationsAllowedRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MaximumStationsAllowed", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMaximumStationsAllowedRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        MaximumStationsAllowedGetCallbackIF* pcb = static_cast< MaximumStationsAllowedGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MaximumStationsAllowedGetError > error(new MaximumStationsAllowedGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MaximumStationsAllowedGetError > error = ::boost::static_pointer_cast< MaximumStationsAllowedGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MaximumStationsAllowed", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMaximumStationsAllowedGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::supportedChannelsPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< SupportedChannelsUpdate > update = ::boost::static_pointer_cast< SupportedChannelsUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_supportedChannels = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "SupportedChannels", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            SupportedChannelsRegisterCallbackIF* pcb = static_cast< SupportedChannelsRegisterCallbackIF* >(callbackIf);
            pcb->onSupportedChannelsUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            SupportedChannelsGetCallbackIF* pcb = static_cast< SupportedChannelsGetCallbackIF* >(callbackIf);
            pcb->onSupportedChannelsGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        SupportedChannelsRegisterCallbackIF* pcb = static_cast< SupportedChannelsRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SupportedChannelsRegisterError > error(new SupportedChannelsRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SupportedChannelsRegisterError > error = ::boost::static_pointer_cast< SupportedChannelsRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SupportedChannels", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSupportedChannelsRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        SupportedChannelsGetCallbackIF* pcb = static_cast< SupportedChannelsGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< SupportedChannelsGetError > error(new SupportedChannelsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< SupportedChannelsGetError > error = ::boost::static_pointer_cast< SupportedChannelsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SupportedChannels", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onSupportedChannelsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::hWFeaturesPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< HWFeaturesUpdate > update = ::boost::static_pointer_cast< HWFeaturesUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_hWFeatures = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "HWFeatures", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            HWFeaturesRegisterCallbackIF* pcb = static_cast< HWFeaturesRegisterCallbackIF* >(callbackIf);
            pcb->onHWFeaturesUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            HWFeaturesGetCallbackIF* pcb = static_cast< HWFeaturesGetCallbackIF* >(callbackIf);
            pcb->onHWFeaturesGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        HWFeaturesRegisterCallbackIF* pcb = static_cast< HWFeaturesRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< HWFeaturesRegisterError > error(new HWFeaturesRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< HWFeaturesRegisterError > error = ::boost::static_pointer_cast< HWFeaturesRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HWFeatures", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onHWFeaturesRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        HWFeaturesGetCallbackIF* pcb = static_cast< HWFeaturesGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< HWFeaturesGetError > error(new HWFeaturesGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< HWFeaturesGetError > error = ::boost::static_pointer_cast< HWFeaturesGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HWFeatures", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onHWFeaturesGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::tetheringPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< TetheringUpdate > update = ::boost::static_pointer_cast< TetheringUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_tethering = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "Tethering", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            TetheringRegisterCallbackIF* pcb = static_cast< TetheringRegisterCallbackIF* >(callbackIf);
            pcb->onTetheringUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            TetheringGetCallbackIF* pcb = static_cast< TetheringGetCallbackIF* >(callbackIf);
            pcb->onTetheringGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        TetheringRegisterCallbackIF* pcb = static_cast< TetheringRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< TetheringRegisterError > error(new TetheringRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< TetheringRegisterError > error = ::boost::static_pointer_cast< TetheringRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Tethering", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onTetheringRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        TetheringGetCallbackIF* pcb = static_cast< TetheringGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< TetheringGetError > error(new TetheringGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< TetheringGetError > error = ::boost::static_pointer_cast< TetheringGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Tethering", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onTetheringGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::iPv4PoolPropertyCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< IPv4PoolUpdate > update = ::boost::static_pointer_cast< IPv4PoolUpdate >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        assert(update);
        proxyShared->_iPv4Pool = update->getData();
        if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPv4Pool", update->getAct(), callbackIf, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*update,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        switch(msg->getInitiatorMessageType()) {
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Register: {
            IPv4PoolRegisterCallbackIF* pcb = static_cast< IPv4PoolRegisterCallbackIF* >(callbackIf);
            pcb->onIPv4PoolUpdate(proxyShared,update);
            break;
        }
        case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Get: {
            IPv4PoolGetCallbackIF* pcb = static_cast< IPv4PoolGetCallbackIF* >(callbackIf);
            pcb->onIPv4PoolGetUpdate(proxyShared,update);
            break;
        }
        default:
            break;
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        IPv4PoolRegisterCallbackIF* pcb = static_cast< IPv4PoolRegisterCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< IPv4PoolRegisterError > error(new IPv4PoolRegisterError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< IPv4PoolRegisterError > error = ::boost::static_pointer_cast< IPv4PoolRegisterError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sRegisterError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPv4Pool", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onIPv4PoolRegisterError(proxyShared,error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__GetError: {
        IPv4PoolGetCallbackIF* pcb = static_cast< IPv4PoolGetCallbackIF* >(callbackIf);
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< IPv4PoolGetError > error(new IPv4PoolGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< IPv4PoolGetError > error = ::boost::static_pointer_cast< IPv4PoolGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sGetError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPv4Pool", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onIPv4PoolGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}


// static
void WapdmanServiceProxy::getAccessPointsRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    GetAccessPointsCallbackIF* pcb = static_cast< GetAccessPointsCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< GetAccessPointsResponse > payload = ::boost::static_pointer_cast< GetAccessPointsResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAccessPoints", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onGetAccessPointsResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< GetAccessPointsError > error(new GetAccessPointsError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< GetAccessPointsError > error = ::boost::static_pointer_cast< GetAccessPointsError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetAccessPoints", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onGetAccessPointsError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::registerAgentRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    RegisterAgentCallbackIF* pcb = static_cast< RegisterAgentCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< RegisterAgentResponse > payload = ::boost::static_pointer_cast< RegisterAgentResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onRegisterAgentResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< RegisterAgentError > error(new RegisterAgentError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< RegisterAgentError > error = ::boost::static_pointer_cast< RegisterAgentError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onRegisterAgentError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::unregisterAgentRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    UnregisterAgentCallbackIF* pcb = static_cast< UnregisterAgentCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< UnregisterAgentResponse > payload = ::boost::static_pointer_cast< UnregisterAgentResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onUnregisterAgentResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< UnregisterAgentError > error(new UnregisterAgentError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< UnregisterAgentError > error = ::boost::static_pointer_cast< UnregisterAgentError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onUnregisterAgentError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::findAccessPointRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    FindAccessPointCallbackIF* pcb = static_cast< FindAccessPointCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< FindAccessPointResponse > payload = ::boost::static_pointer_cast< FindAccessPointResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FindAccessPoint", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onFindAccessPointResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< FindAccessPointError > error(new FindAccessPointError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< FindAccessPointError > error = ::boost::static_pointer_cast< FindAccessPointError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FindAccessPoint", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onFindAccessPointError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::macAddressAsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    MacAddressAsGetCallbackIF* pcb = static_cast< MacAddressAsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< MacAddressAsGetResponse > payload = ::boost::static_pointer_cast< MacAddressAsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MacAddressAsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onMacAddressAsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< MacAddressAsGetError > error(new MacAddressAsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< MacAddressAsGetError > error = ::boost::static_pointer_cast< MacAddressAsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MacAddressAsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onMacAddressAsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::accesspointAsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    AccesspointAsGetCallbackIF* pcb = static_cast< AccesspointAsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< AccesspointAsGetResponse > payload = ::boost::static_pointer_cast< AccesspointAsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccesspointAsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onAccesspointAsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< AccesspointAsGetError > error(new AccesspointAsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< AccesspointAsGetError > error = ::boost::static_pointer_cast< AccesspointAsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccesspointAsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onAccesspointAsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::interfaceAsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    InterfaceAsGetCallbackIF* pcb = static_cast< InterfaceAsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< InterfaceAsGetResponse > payload = ::boost::static_pointer_cast< InterfaceAsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "InterfaceAsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onInterfaceAsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< InterfaceAsGetError > error(new InterfaceAsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< InterfaceAsGetError > error = ::boost::static_pointer_cast< InterfaceAsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InterfaceAsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onInterfaceAsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::iPAddressAsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    IPAddressAsGetCallbackIF* pcb = static_cast< IPAddressAsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< IPAddressAsGetResponse > payload = ::boost::static_pointer_cast< IPAddressAsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAddressAsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onIPAddressAsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< IPAddressAsGetError > error(new IPAddressAsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< IPAddressAsGetError > error = ::boost::static_pointer_cast< IPAddressAsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAddressAsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onIPAddressAsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::hostnameAsGetRequestCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    HostnameAsGetCallbackIF* pcb = static_cast< HostnameAsGetCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >(msg->getProxy()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Response: {
        ::boost::shared_ptr< HostnameAsGetResponse > payload = ::boost::static_pointer_cast< HostnameAsGetResponse >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HostnameAsGet", payload->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*payload,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onHostnameAsGetResponse(proxyShared,payload);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RequestError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< HostnameAsGetError > error(new HostnameAsGetError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< HostnameAsGetError > error = ::boost::static_pointer_cast< HostnameAsGetError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HostnameAsGet", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onHostnameAsGetError(proxyShared,error);
        }
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::accessPointAddedEventCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    AccessPointAddedCallbackIF* pcb = static_cast< AccessPointAddedCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >((msg->getProxy())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< AccessPointAddedEvent > event = ::boost::static_pointer_cast< AccessPointAddedEvent >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sEvent, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccessPointAdded", event->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*event,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onAccessPointAddedEvent(proxyShared,event);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< AccessPointAddedError > error(new AccessPointAddedError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< AccessPointAddedError > error = ::boost::static_pointer_cast< AccessPointAddedError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccessPointAdded", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onAccessPointAddedError(proxyShared, error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterEventConfirmation: {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sRegisterConfirmation, cb=%p, proxy=%p", "AccessPointAdded", pcb, proxyShared.get());
        }
        pcb->onAccessPointAddedRegisterConfirmation(proxyShared);
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::accessPointRemovedEventCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    AccessPointRemovedCallbackIF* pcb = static_cast< AccessPointRemovedCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >((msg->getProxy())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< AccessPointRemovedEvent > event = ::boost::static_pointer_cast< AccessPointRemovedEvent >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sEvent, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccessPointRemoved", event->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*event,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onAccessPointRemovedEvent(proxyShared,event);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< AccessPointRemovedError > error(new AccessPointRemovedError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< AccessPointRemovedError > error = ::boost::static_pointer_cast< AccessPointRemovedError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AccessPointRemoved", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onAccessPointRemovedError(proxyShared, error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterEventConfirmation: {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sRegisterConfirmation, cb=%p, proxy=%p", "AccessPointRemoved", pcb, proxyShared.get());
        }
        pcb->onAccessPointRemovedRegisterConfirmation(proxyShared);
        break;
    }
    default:
        break;
    }
}

// static
void WapdmanServiceProxy::associatedStationsChangedEventCallback(void* callbackIf, ::asf::cms::CmsMessage* msg) {
    AssociatedStationsChangedCallbackIF* pcb = static_cast< AssociatedStationsChangedCallbackIF* >(callbackIf);
    const ::boost::shared_ptr< WapdmanServiceProxy >& proxyShared = ::boost::static_pointer_cast< WapdmanServiceProxy >((msg->getProxy())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast

    switch(msg->getCmsMessageType()) {
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__Notify: {
        ::boost::shared_ptr< AssociatedStationsChangedEvent > event = ::boost::static_pointer_cast< AssociatedStationsChangedEvent >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sEvent, act=%" PRIuPTR ", cb=%p, proxy=%p", "AssociatedStationsChanged", event->getAct(), pcb, proxyShared.get());
            std::string jsonPayload;
            serializeJson(*event,jsonPayload);
            LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
        }
        pcb->onAssociatedStationsChangedEvent(proxyShared,event);
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterError: {
        if(msg->getSystemError() != ::asf::cms::CmsTypes::SystemError__Undefined) {
            ::boost::shared_ptr< AssociatedStationsChangedError > error(new AssociatedStationsChangedError());
            error->setSystemError(msg->getSystemError());
            msg->setPayload(::boost::static_pointer_cast< ::asf::core::Payload >(error)); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            proxyShared->_cmsProxyDelegate.sendErrorLoopBack(*msg);
        }
        else {
            ::boost::shared_ptr< AssociatedStationsChangedError > error = ::boost::static_pointer_cast< AssociatedStationsChangedError >(msg->getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
            if (IS_LOG_INFO_ENABLED()) {
                LOG_INFO_STATIC ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AssociatedStationsChanged", error->getAct(), pcb, proxyShared.get());
                std::string jsonPayload;
                serializeJson(*error,jsonPayload);
                LOG_INFO_STATIC("payload: %s", jsonPayload.c_str());
            }
            pcb->onAssociatedStationsChangedError(proxyShared, error);
        }
        break;
    }
    case ::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__RegisterEventConfirmation: {
        if (IS_LOG_INFO_ENABLED()) {
            LOG_INFO_STATIC ("<- on%sRegisterConfirmation, cb=%p, proxy=%p", "AssociatedStationsChanged", pcb, proxyShared.get());
        }
        pcb->onAssociatedStationsChangedRegisterConfirmation(proxyShared);
        break;
    }
    default:
        break;
    }
}

} // namespace WapdmanService
} // namespace Stub
