/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "adapter/SdsAdapter.h"
#include "adapter/SdsAdapterApp.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "sds_am/SdsAmDB.h"
#include "sds_app/SdsAppDB.h"
#include "sds_dab/SdsDabDB.h"
#include "sds_fm/SdsFmDB.h"
#include "sds_sxm/SdsSxmDB.h"
#include "sds_tv/SdsTvDB.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "SdsAdapterApp" isn't clear, then there should be a description here.
 */

namespace adapter {

DEFINE_LOGGER_AND_LEVEL (_logger, "/adapter/SdsAdapterApp", Info);

/* static */ const char* SdsAdapterApp::sdsAdapter = "sdsAdapter";
/* static */ const char* SdsAdapterApp::sdsSxmDB = "sdsSxmDB";
/* static */ const char* SdsAdapterApp::sdsFmDB = "sdsFmDB";
/* static */ const char* SdsAdapterApp::sdsAmDB = "sdsAmDB";
/* static */ const char* SdsAdapterApp::sdsDabDB = "sdsDabDB";
/* static */ const char* SdsAdapterApp::sdsAppDB = "sdsAppDB";
/* static */ const char* SdsAdapterApp::sdsTvDB = "sdsTvDB";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool SdsAdapterApp_enabledASFSignalHandler = false;

void importSdsAdapterApp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach SdsAdapterApp, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(99);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'sdsAdapterThread'

    ::asf::core::ComponentContainerSharedPtr SdsAdapterThread(new ::asf::core::ComponentContainer("sdsAdapterThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SdsAdapterThread);

        // Component 'SdsAdapter sdsAdapter'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::adapter::SdsAdapter > > sdsAdapterFactory(new ::asf::core::ComponentFactory< ::adapter::SdsAdapter >);
        ::asf::core::ComponentDescriptionSharedPtr sdsAdapterDescription(new ::asf::core::ComponentDescription(1, "sdsAdapter", /* immediate = */ true, /* threadBridge = */ false, sdsAdapterFactory));
        SdsAdapterThread->addComponentDescription(sdsAdapterDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& sdsAdapter_spmFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("CFC_SPM_FI", "spmFiPort"));
            (void)sdsAdapter_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& sdsAdapter_ConsumerPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)sdsAdapter_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& sdsAdapter_LifecycleControlPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)sdsAdapter_LifecycleControlPort; // prevent unused variable warning

            // Port 'sdsFmServicePort'

            ::asf::core::RequiredPort& sdsAdapter_sdsFmServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_fm_fi.SdsFmService", "sdsFmServicePort"));
            (void)sdsAdapter_sdsFmServicePort; // prevent unused variable warning

            // Port 'sdsAmServicePort'

            ::asf::core::RequiredPort& sdsAdapter_sdsAmServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_am_fi.SdsAmService", "sdsAmServicePort"));
            (void)sdsAdapter_sdsAmServicePort; // prevent unused variable warning

            // Port 'sdsSxmServicePort'

            ::asf::core::RequiredPort& sdsAdapter_sdsSxmServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_sxm_fi.SdsSxmService", "sdsSxmServicePort"));
            (void)sdsAdapter_sdsSxmServicePort; // prevent unused variable warning

            // Port 'sdsAppServicePort'

            ::asf::core::RequiredPort& sdsAdapter_sdsAppServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_app_fi.SdsAppService", "sdsAppServicePort"));
            (void)sdsAdapter_sdsAppServicePort; // prevent unused variable warning

            // Port 'userProfilePort'

            ::asf::core::RequiredPort& sdsAdapter_userProfilePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.profile", "userProfilePort"));
            (void)sdsAdapter_userProfilePort; // prevent unused variable warning

            // Port 'commandInterfacePort'

            ::asf::core::RequiredPort& sdsAdapter_commandInterfacePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "commandInterfacePort"));
            (void)sdsAdapter_commandInterfacePort; // prevent unused variable warning

            // Port 'phoneTelPort'

            ::asf::core::RequiredPort& sdsAdapter_phoneTelPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Tel_FI", "phoneTelPort"));
            (void)sdsAdapter_phoneTelPort; // prevent unused variable warning

            // Port 'sds2phoneMsgPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2phoneMsgPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Msg_FI", "sds2phoneMsgPort"));
            (void)sdsAdapter_sds2phoneMsgPort; // prevent unused variable warning

            // Port 'sds2phoneBTSetPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2phoneBTSetPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "sds2phoneBTSetPort"));
            (void)sdsAdapter_sds2phoneBTSetPort; // prevent unused variable warning

            // Port 'phoneBookPort'

            ::asf::core::RequiredPort& sdsAdapter_phoneBookPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_PhonBk_FI", "phoneBookPort"));
            (void)sdsAdapter_phoneBookPort; // prevent unused variable warning

            // Port 'spiFiPort'

            ::asf::core::RequiredPort& sdsAdapter_spiFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("smartphoneint_main_fi", "spiFiPort"));
            (void)sdsAdapter_spiFiPort; // prevent unused variable warning

            // Port 'strFiPort'

            ::asf::core::RequiredPort& sdsAdapter_strFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("midw_streamrouter_fi", "strFiPort"));
            (void)sdsAdapter_strFiPort; // prevent unused variable warning

            // Port 'sds2mediaPlayerFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2mediaPlayerFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_MediaPlayer_FI", "sds2mediaPlayerFiPort"));
            (void)sdsAdapter_sds2mediaPlayerFiPort; // prevent unused variable warning

            // Port 'sdsAudioFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sdsAudioFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_audio_main_fi", "sdsAudioFiPort"));
            (void)sdsAdapter_sdsAudioFiPort; // prevent unused variable warning

            // Port 'sds2SxmCanadianFuelFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2SxmCanadianFuelFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_canadian_fuel_main_fi", "sds2SxmCanadianFuelFiPort"));
            (void)sdsAdapter_sds2SxmCanadianFuelFiPort; // prevent unused variable warning

            // Port 'sds2sxmFuelFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2sxmFuelFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_fuel_main_fi", "sds2sxmFuelFiPort"));
            (void)sdsAdapter_sds2sxmFuelFiPort; // prevent unused variable warning

            // Port 'sxmMoviesFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sxmMoviesFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_movies_main_fi", "sxmMoviesFiPort"));
            (void)sdsAdapter_sxmMoviesFiPort; // prevent unused variable warning

            // Port 'sds2sxmParkingFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2sxmParkingFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_parking_main_fi", "sds2sxmParkingFiPort"));
            (void)sdsAdapter_sds2sxmParkingFiPort; // prevent unused variable warning

            // Port 'sdsPhoneticsFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sdsPhoneticsFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_phonetics_main_fi", "sdsPhoneticsFiPort"));
            (void)sdsAdapter_sdsPhoneticsFiPort; // prevent unused variable warning

            // Port 'sds2sxmSportsFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2sxmSportsFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_sports_main_fi", "sds2sxmSportsFiPort"));
            (void)sdsAdapter_sds2sxmSportsFiPort; // prevent unused variable warning

            // Port 'sds2sxmStocksFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2sxmStocksFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_stocks_main_fi", "sds2sxmStocksFiPort"));
            (void)sdsAdapter_sds2sxmStocksFiPort; // prevent unused variable warning

            // Port 'sds2sxmTabWeatherFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2sxmTabWeatherFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_tabweather_main_fi", "sds2sxmTabWeatherFiPort"));
            (void)sdsAdapter_sds2sxmTabWeatherFiPort; // prevent unused variable warning

            // Port 'tcuFiPort'

            ::asf::core::RequiredPort& sdsAdapter_tcuFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("tcu_main_fi", "tcuFiPort"));
            (void)sdsAdapter_tcuFiPort; // prevent unused variable warning

            // Port 'sdstcuUsbMainFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sdstcuUsbMainFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("tcu_usb_main_fi", "sdstcuUsbMainFiPort"));
            (void)sdsAdapter_sdstcuUsbMainFiPort; // prevent unused variable warning

            // Port 'tunerFiPort'

            ::asf::core::RequiredPort& sdsAdapter_tunerFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("tuner_main_fi", "tunerFiPort"));
            (void)sdsAdapter_tunerFiPort; // prevent unused variable warning

            // Port 'sdstunermasterFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sdstunermasterFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("tunermaster_main_fi", "sdstunermasterFiPort"));
            (void)sdsAdapter_sdstunermasterFiPort; // prevent unused variable warning

            // Port 'sds2vehicledataPort'

            ::asf::core::RequiredPort& sdsAdapter_sds2vehicledataPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "sds2vehicledataPort"));
            (void)sdsAdapter_sds2vehicledataPort; // prevent unused variable warning

            // Port 'naviServicePort'

            ::asf::core::RequiredPort& sdsAdapter_naviServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.navigation.NavigationService", "naviServicePort"));
            (void)sdsAdapter_naviServicePort; // prevent unused variable warning

            // Port 'naviSDSServicePort'

            ::asf::core::RequiredPort& sdsAdapter_naviSDSServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.navigation.NavigationSDSService", "naviSDSServicePort"));
            (void)sdsAdapter_naviSDSServicePort; // prevent unused variable warning

            // Port 'sdsDabServicePort'

            ::asf::core::RequiredPort& sdsAdapter_sdsDabServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_dab_fi.SdsDabService", "sdsDabServicePort"));
            (void)sdsAdapter_sdsDabServicePort; // prevent unused variable warning

            // Port 'tvDbServicePort'

            ::asf::core::RequiredPort& sdsAdapter_tvDbServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("sds_tv_fi.SdsTvService", "tvDbServicePort"));
            (void)sdsAdapter_tvDbServicePort; // prevent unused variable warning

            // Port 'clockFiPort'

            ::asf::core::RequiredPort& sdsAdapter_clockFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("clock_main_fi", "clockFiPort"));
            (void)sdsAdapter_clockFiPort; // prevent unused variable warning

            // Port 'ecnrServicePort'

            ::asf::core::RequiredPort& sdsAdapter_ecnrServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.ecnr.service", "ecnrServicePort"));
            (void)sdsAdapter_ecnrServicePort; // prevent unused variable warning

            // Port 'audprocServicePort'

            ::asf::core::RequiredPort& sdsAdapter_audprocServicePort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.audproc.service", "audprocServicePort"));
            (void)sdsAdapter_audprocServicePort; // prevent unused variable warning

            // Port 'acrPort'

            ::asf::core::RequiredPort& sdsAdapter_acrPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("CMB_ACR_FI", "acrPort"));
            (void)sdsAdapter_acrPort; // prevent unused variable warning

            // Port 'sdsdabFiPort'

            ::asf::core::RequiredPort& sdsAdapter_sdsdabFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("dabtuner_main_fi", "sdsdabFiPort"));
            (void)sdsAdapter_sdsdabFiPort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& sdsAdapter_diagnosticsFiPort = sdsAdapterDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)sdsAdapter_diagnosticsFiPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& sdsAdapter_LifeCycleConsumerPort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)sdsAdapter_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'GuiServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_GuiServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SdsGuiService", "GuiServicePort", false, false));
            (void)sdsAdapter_GuiServicePort; // prevent unused variable warning

            // Port 'PopUpServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_PopUpServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.PopUpService", "PopUpServicePort", false, false));
            (void)sdsAdapter_PopUpServicePort; // prevent unused variable warning

            // Port 'SettingsServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_SettingsServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SettingsService", "SettingsServicePort", false, false));
            (void)sdsAdapter_SettingsServicePort; // prevent unused variable warning

            // Port 'SdsPhoneServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_SdsPhoneServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SdsPhoneService", "SdsPhoneServicePort", false, false));
            (void)sdsAdapter_SdsPhoneServicePort; // prevent unused variable warning

            // Port 'SdsDataHandoverServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_SdsDataHandoverServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SdsDataHandoverService", "SdsDataHandoverServicePort", false, false));
            (void)sdsAdapter_SdsDataHandoverServicePort; // prevent unused variable warning

            // Port 'SdsDiagnosisServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_SdsDiagnosisServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SdsDiagnosisService", "SdsDiagnosisServicePort", false, false));
            (void)sdsAdapter_SdsDiagnosisServicePort; // prevent unused variable warning

            // Port 'SdsFocusServicePort'

            ::asf::core::ProvidedPort& sdsAdapter_SdsFocusServicePort = sdsAdapterDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_gui_fi.SdsFocusService", "SdsFocusServicePort", false, false));
            (void)sdsAdapter_SdsFocusServicePort; // prevent unused variable warning

    // Thread 'sqlThread'

    ::asf::core::ComponentContainerSharedPtr SqlThread(new ::asf::core::ComponentContainer("sqlThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SqlThread);

        // Component 'SdsSxmDB sdsSxmDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_sxm::SdsSxmDB > > sdsSxmDBFactory(new ::asf::core::ComponentFactory< ::sds_sxm::SdsSxmDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsSxmDBDescription(new ::asf::core::ComponentDescription(2, "sdsSxmDB", /* immediate = */ true, /* threadBridge = */ false, sdsSxmDBFactory));
        SqlThread->addComponentDescription(sdsSxmDBDescription);

            // Port 'SxmDbServicePort'

            ::asf::core::ProvidedPort& sdsSxmDB_SxmDbServicePort = sdsSxmDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_sxm_fi.SdsSxmService", "SxmDbServicePort", false, false));
            (void)sdsSxmDB_SxmDbServicePort; // prevent unused variable warning

        // Component 'SdsFmDB sdsFmDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_fm::SdsFmDB > > sdsFmDBFactory(new ::asf::core::ComponentFactory< ::sds_fm::SdsFmDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsFmDBDescription(new ::asf::core::ComponentDescription(3, "sdsFmDB", /* immediate = */ true, /* threadBridge = */ false, sdsFmDBFactory));
        SqlThread->addComponentDescription(sdsFmDBDescription);

            // Port 'FmDbServicePort'

            ::asf::core::ProvidedPort& sdsFmDB_FmDbServicePort = sdsFmDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_fm_fi.SdsFmService", "FmDbServicePort", false, false));
            (void)sdsFmDB_FmDbServicePort; // prevent unused variable warning

        // Component 'SdsAmDB sdsAmDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_am::SdsAmDB > > sdsAmDBFactory(new ::asf::core::ComponentFactory< ::sds_am::SdsAmDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsAmDBDescription(new ::asf::core::ComponentDescription(4, "sdsAmDB", /* immediate = */ true, /* threadBridge = */ false, sdsAmDBFactory));
        SqlThread->addComponentDescription(sdsAmDBDescription);

            // Port 'AmDbServicePort'

            ::asf::core::ProvidedPort& sdsAmDB_AmDbServicePort = sdsAmDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_am_fi.SdsAmService", "AmDbServicePort", false, false));
            (void)sdsAmDB_AmDbServicePort; // prevent unused variable warning

        // Component 'SdsDabDB sdsDabDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_dab::SdsDabDB > > sdsDabDBFactory(new ::asf::core::ComponentFactory< ::sds_dab::SdsDabDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsDabDBDescription(new ::asf::core::ComponentDescription(5, "sdsDabDB", /* immediate = */ true, /* threadBridge = */ false, sdsDabDBFactory));
        SqlThread->addComponentDescription(sdsDabDBDescription);

            // Port 'DabDbServicePort'

            ::asf::core::ProvidedPort& sdsDabDB_DabDbServicePort = sdsDabDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_dab_fi.SdsDabService", "DabDbServicePort", false, false));
            (void)sdsDabDB_DabDbServicePort; // prevent unused variable warning

        // Component 'SdsAppDB sdsAppDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_app::SdsAppDB > > sdsAppDBFactory(new ::asf::core::ComponentFactory< ::sds_app::SdsAppDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsAppDBDescription(new ::asf::core::ComponentDescription(6, "sdsAppDB", /* immediate = */ true, /* threadBridge = */ false, sdsAppDBFactory));
        SqlThread->addComponentDescription(sdsAppDBDescription);

            // Port 'AppDbServicePort'

            ::asf::core::ProvidedPort& sdsAppDB_AppDbServicePort = sdsAppDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_app_fi.SdsAppService", "AppDbServicePort", false, false));
            (void)sdsAppDB_AppDbServicePort; // prevent unused variable warning

        // Component 'SdsTvDB sdsTvDB'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::sds_tv::SdsTvDB > > sdsTvDBFactory(new ::asf::core::ComponentFactory< ::sds_tv::SdsTvDB >);
        ::asf::core::ComponentDescriptionSharedPtr sdsTvDBDescription(new ::asf::core::ComponentDescription(7, "sdsTvDB", /* immediate = */ true, /* threadBridge = */ false, sdsTvDBFactory));
        SqlThread->addComponentDescription(sdsTvDBDescription);

            // Port 'tvDbServicePort'

            ::asf::core::ProvidedPort& sdsTvDB_tvDbServicePort = sdsTvDBDescription->addProvidedPort (::asf::core::ProvidedPort ("sds_tv_fi.SdsTvService", "tvDbServicePort", false, false));
            (void)sdsTvDB_tvDbServicePort; // prevent unused variable warning

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("CFC_SPM_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    ::asf::cca::CcaImportedPort& phoneTelFiImport = ccaConnector_->importByName (10, 4, 3, 2);
    phoneTelFiImport.setServiceName("MOST_Tel_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_phoneTelPort, phoneTelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& strFiImport = ccaConnector_->importByName (82, 1, 0, 2);
    strFiImport.setServiceName("midw_streamrouter_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_strFiPort, strFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2PhoneBtSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    sds2PhoneBtSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2phoneBTSetPort, sds2PhoneBtSetFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2phoneMsgFiImport = ccaConnector_->importByName (96, 2, 4, 2);
    sds2phoneMsgFiImport.setServiceName("MOST_Msg_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2phoneMsgPort, sds2phoneMsgFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& phoneBookFiImport = ccaConnector_->importByName (97, 3, 0, 2);
    phoneBookFiImport.setServiceName("MOST_PhonBk_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_phoneBookPort, phoneBookFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2vehicledataFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    sds2vehicledataFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2vehicledataPort, sds2vehicledataFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& acrFiImport = ccaConnector_->importByName (4099, 2, 0, 2);
    acrFiImport.setServiceName("CMB_ACR_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_acrPort, acrFiImport);

    // Expression

    dbusSystemConnector_->exportByName (sdsAdapter_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_GuiServicePort, ::std::string("/sds_gui_fi/SdsGuiService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_PopUpServicePort, ::std::string("/sds_gui_fi/PopUpService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_SettingsServicePort, ::std::string("/sds_gui_fi/SettingsService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_SdsPhoneServicePort, ::std::string("/sds_gui_fi/SdsPhoneService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_SdsDataHandoverServicePort, ::std::string("/sds_gui_fi/SdsDataHandoverService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_SdsDiagnosisServicePort, ::std::string("/sds_gui_fi/SdsDiagnosisService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAdapter_SdsFocusServicePort, ::std::string("/sds_gui_fi/SdsFocusService/SdsAdapter"));

    // Expression

    dbusSessionConnector_->exportByName (sdsSxmDB_SxmDbServicePort, ::std::string("/sds_sxm_fi/SdsSxmService/SdsSxmDB"));

    // Expression

    dbusSessionConnector_->exportByName (sdsFmDB_FmDbServicePort, ::std::string("/sds_fm_fi/SdsFmService/SdsFmDB"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAmDB_AmDbServicePort, ::std::string("/sds_am_fi/SdsAmService/SdsAmDB"));

    // Expression

    dbusSessionConnector_->exportByName (sdsDabDB_DabDbServicePort, ::std::string("/sds_dab_fi/SdsDabService/SdsDabDB"));

    // Expression

    dbusSessionConnector_->exportByName (sdsAppDB_AppDbServicePort, ::std::string("/sds_app_fi/SdsAppService/SdsAppDB"));

    // Expression

    dbusSessionConnector_->exportByName (sdsTvDB_tvDbServicePort, ::std::string("/sds_tv_fi/SdsTvService/SdsTvDB"));

    // Expression

    ::asf::cca::CcaImportedPort& tunerFiImport = ccaConnector_->importByName (264, 3, 0, 2);
    tunerFiImport.setServiceName("tuner_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_tunerFiPort, tunerFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2mediaPlayerFiImport = ccaConnector_->importByName (89, 4, 4, 2);
    sds2mediaPlayerFiImport.setServiceName("mplay_MediaPlayer_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2mediaPlayerFiPort, sds2mediaPlayerFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& tcuFiImport = ccaConnector_->importByName (144, 1, 0, 2);
    tcuFiImport.setServiceName("tcu_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_tcuFiPort, tcuFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sdsAudioFiImPort = ccaConnector_->importByName (140, 2, 7, 2);
    sdsAudioFiImPort.setServiceName("sxm_audio_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsAudioFiPort, sdsAudioFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sds2SxmCanadianFuelFiImport = ccaConnector_->importByName (140, 1, 0, 2);
    sds2SxmCanadianFuelFiImport.setServiceName("sxm_canadian_fuel_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2SxmCanadianFuelFiPort, sds2SxmCanadianFuelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2SxmFuelFiImPort = ccaConnector_->importByName (140, 1, 1, 2);
    sds2SxmFuelFiImPort.setServiceName("sxm_fuel_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2sxmFuelFiPort, sds2SxmFuelFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sxmMoviesFiImport = ccaConnector_->importByName (140, 1, 1, 2);
    sxmMoviesFiImport.setServiceName("sxm_movies_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sxmMoviesFiPort, sxmMoviesFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sds2sxmParkingFiImPort = ccaConnector_->importByName (140, 1, 2, 2);
    sds2sxmParkingFiImPort.setServiceName("sxm_parking_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2sxmParkingFiPort, sds2sxmParkingFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sdsPhoneticsFiImPort = ccaConnector_->importByName (140, 1, 0, 2);
    sdsPhoneticsFiImPort.setServiceName("sxm_phonetics_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsPhoneticsFiPort, sdsPhoneticsFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sds2sxmSportsFiImPort = ccaConnector_->importByName (140, 1, 1, 2);
    sds2sxmSportsFiImPort.setServiceName("sxm_sports_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2sxmSportsFiPort, sds2sxmSportsFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sds2sxmStocksFiImPort = ccaConnector_->importByName (140, 1, 0, 2);
    sds2sxmStocksFiImPort.setServiceName("sxm_stocks_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2sxmStocksFiPort, sds2sxmStocksFiImPort);

    // Expression

    ::asf::cca::CcaImportedPort& sds2sxmTabWeatherFiImport = ccaConnector_->importByName (140, 1, 0, 2);
    sds2sxmTabWeatherFiImport.setServiceName("sxm_tabweather_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sds2sxmTabWeatherFiPort, sds2sxmTabWeatherFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sdstunermasterFiImport = ccaConnector_->importByName (286, 3, 0, 2);
    sdstunermasterFiImport.setServiceName("tunermaster_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdstunermasterFiPort, sdstunermasterFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sdstcuUsbMainFiImport = ccaConnector_->importByName (180, 1, 0, 2);
    sdstcuUsbMainFiImport.setServiceName("tcu_usb_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdstcuUsbMainFiPort, sdstcuUsbMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sdsdabFiImport = ccaConnector_->importByName (46, 2, 0, 2);
    sdsdabFiImport.setServiceName("dabtuner_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsdabFiPort, sdsdabFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2SxmDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_sxm_fi/SdsSxmService/SdsSxmDB"));
    sds2SxmDbService.setServiceName("sds_sxm_fi.SdsSxmService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsSxmServicePort, sds2SxmDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2FmDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_fm_fi/SdsFmService/SdsFmDB"));
    sds2FmDbService.setServiceName("sds_fm_fi.SdsFmService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsFmServicePort, sds2FmDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2AmDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_am_fi/SdsAmService/SdsAmDB"));
    sds2AmDbService.setServiceName("sds_am_fi.SdsAmService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsAmServicePort, sds2AmDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2DabDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_dab_fi/SdsDabService/SdsDabDB"));
    sds2DabDbService.setServiceName("sds_dab_fi.SdsDabService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsDabServicePort, sds2DabDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2AppDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_app_fi/SdsAppService/SdsAppDB"));
    sds2AppDbService.setServiceName("sds_app_fi.SdsAppService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_sdsAppServicePort, sds2AppDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& sds2TvDbService = dbusSessionConnector_->importByName (::std::string("adapter.SdsAdapterApp"), ::std::string("/sds_tv_fi/SdsTvService/SdsTvDB"));
    sds2TvDbService.setServiceName("sds_tv_fi.SdsTvService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_tvDbServicePort, sds2TvDbService);

    // Expression

    ::asf::dbus::DBusImportedPort& userProfileImport = dbusSessionConnector_->importByName (::std::string("app.core.ProfileMngr"), ::std::string("/com/bosch/cm/profileMngr"));
    userProfileImport.setServiceName("bosch.cm.profile");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_userProfilePort, userProfileImport);

    // Expression

    ::asf::dbus::DBusImportedPort& commandInterfaceImport = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    commandInterfaceImport.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_commandInterfacePort, commandInterfaceImport);

    // Expression

    ::asf::cca::CcaImportedPort& clockFiImport = ccaConnector_->importByName (41, 1, 5, 2);
    clockFiImport.setServiceName("clock_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_clockFiPort, clockFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& spiFiImport = ccaConnector_->importByName (285, 1, 0, 2);
    spiFiImport.setServiceName("smartphoneint_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_spiFiPort, spiFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& naviService = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/com/bosch/cm/ai/navigation"));
    naviService.setServiceName("org.bosch.cm.navigation.NavigationService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_naviServicePort, naviService);

    // Expression

    ::asf::dbus::DBusImportedPort& naviSDSService = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/com/bosch/cm/ai/navigationsds"));
    naviSDSService.setServiceName("org.bosch.cm.navigation.NavigationSDSService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_naviSDSServicePort, naviSDSService);

    // Expression

    ::asf::dbus::DBusImportedPort& EcnrService = dbusSystemConnector_->importByName (::std::string("org.bosch.ecnr.service"), ::std::string("/"));
    EcnrService.setServiceName("org.bosch.ecnr.service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_ecnrServicePort, EcnrService);

    // Expression

    ::asf::dbus::DBusImportedPort& AudProcService = dbusSystemConnector_->importByName (::std::string("org.bosch.audproc.service"), ::std::string("/"));
    AudProcService.setServiceName("org.bosch.audproc.service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_audprocServicePort, AudProcService);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sdsAdapter_diagnosticsFiPort, diagnosticsFiImport);


    LOG_INFO_STATIC("Starting application 'SdsAdapterApp' version 0.1.0");

    app->start();
}

int executeSdsAdapterApp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("adapter", "SdsAdapterApp");
    } else {
        ::asf::core::Logger::setupLogging ("adapter", "SdsAdapterApp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", SdsAdapterApp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("adapter", "SdsAdapterApp", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create SdsAdapterApp");

    app->enableExceptionHandler(false);

    importSdsAdapterApp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace adapter

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::adapter::executeSdsAdapterApp(argc, argv);
}

