/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_SCREENBROKER_TYPESCONST_H
#define BOSCH_CM_AI_HMI_SCREENBROKER_TYPESCONST_H

#include <cstddef>

/**
 * If the meaning of "Types" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Types {

/**
 * The enumeration of pop-up overlay modalities.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum Modality {

    /**
     * Indicates a non-modal surface.
     */
    Modality__None,
    /**
     * Indicates an application-modal surface. User interaction is application-wide only possible with the regarding surface. User interaction with other applications is not affected.
     */
    Modality__System,
    /**
     * Indicates a system-modal surface. User interaction is system-wide only possible with the regarding surface.
     */
    Modality__Application

};

bool Modality_Parse (const char *str, size_t length, Modality &value);

const char* Modality_Name (Modality value);

bool Modality_IsValid (Modality value);

/**
 * The enumeration of alignment values intended to use for horizontal and vertical alignment attributes.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum HorizontalAlignment {

    /**
     * Align elements to left side of the parent element.
     */
    HorizontalAlignment__Left,
    /**
     * Align elements to the center of the parent element.
     */
    HorizontalAlignment__Center,
    /**
     * Align elements to right side of the parent element.
     */
    HorizontalAlignment__Right

};

bool HorizontalAlignment_Parse (const char *str, size_t length, HorizontalAlignment &value);

const char* HorizontalAlignment_Name (HorizontalAlignment value);

bool HorizontalAlignment_IsValid (HorizontalAlignment value);

/**
 * The enumeration of alignment values intended to use for horizontal and vertical alignment attributes.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum VerticalAlignment {

    /**
     * Align elements to top of the parent element.
     */
    VerticalAlignment__Bottom,
    /**
     * Align elements to the center of the parent element.
     */
    VerticalAlignment__Center,
    /**
     * Align elements to the bottom of the parent element.
     */
    VerticalAlignment__Top

};

bool VerticalAlignment_Parse (const char *str, size_t length, VerticalAlignment &value);

const char* VerticalAlignment_Name (VerticalAlignment value);

bool VerticalAlignment_IsValid (VerticalAlignment value);

/**
 * The enumeration of scaling configuration values intended to use for element scaling attributes.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum Scaling {

    /**
     * Indicates that no scaling shall be performed.
     */
    Scaling__None,
    /**
     * Indicates that the element shall be scaled to fully cover to it's parent element by maintaining the aspect ratio of the element. The element is scaled in a way that one dimension matches the size of the corresponding parent element while the other dimension of the element may be larger than the corresponding parent element size.
     */
    Scaling__Cut,
    /**
     * Indicates that the element shall be scaled to fit to it's parent element by maintaining the aspect ratio of the element. The element is scaled in a way that one dimension matches the size of the corresponding parent element while the other dimension of the element may be less than the corresponding parent element size.
     */
    Scaling__Fit,
    /**
     * Indicates that the element shall be scaled to the dimension of it's parent element without maintaining the aspect ratio of the element.
     */
    Scaling__Stretch

};

bool Scaling_Parse (const char *str, size_t length, Scaling &value);

const char* Scaling_Name (Scaling value);

bool Scaling_IsValid (Scaling value);

/**
 * The enumeration of surface states.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum SurfaceState {

    /**
     * Indicates that the surface has been registered
     */
    SurfaceState__Registered,
    /**
     * Indicates that the surface has been unregistered.
     */
    SurfaceState__Deregistered,
    /**
     * Indicates that the surface has been removed from presentation queue.
     */
    SurfaceState__Unqueued,
    /**
     * Indicates that the surface is queued for later presentation.
     */
    SurfaceState__Queued,
    /**
     * Indicates that the surface is unmapped and not shown on screen.
     */
    SurfaceState__Unmapped,
    /**
     * Indicates that the surface is mapped and shown on screen.
     */
    SurfaceState__Mapped,
    /**
     * Indicates that the surface is not stored and valid for short time
     */
    SurfaceState__CustomStart,
    /**
     * Indicates that the surface is valid again
     */
    SurfaceState__CustomEnd

};

bool SurfaceState_Parse (const char *str, size_t length, SurfaceState &value);

const char* SurfaceState_Name (SurfaceState value);

bool SurfaceState_IsValid (SurfaceState value);

/**
 * The enumeration of Layer state.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum LayerState {

    /**
     * Indicates Layer is Available/Created
     */
    LayerState__Created,
    /**
     * Indicates Layer is Unavailable/Destroyed
     */
    LayerState__Destroyed,
    /**
     * Indicates Animation Started for Layer
     */
    LayerState__AnimationStarted,
    /**
     * Indicates Animation Stopped/Completed for Layer
     */
    LayerState__AnimationStopped

};

bool LayerState_Parse (const char *str, size_t length, LayerState &value);

const char* LayerState_Name (LayerState value);

bool LayerState_IsValid (LayerState value);

/**
 * The enumeration of key states.
 *                 Note: The enumeration values shall be accessible via its own enumeration scope (e.g. class, namespace).
 */
enum KeyState {

    /**
     * Indicates a normal release of a key (not long press was indicated between the time of the key press and this release event).
     */
    KeyState__Release,
    /**
     * Indicates an initial key press event.
     */
    KeyState__Press,
    /**
     * Indicates a release of a long key press event (long press was indicated between the time of the key press and this release event).
     */
    KeyState__LongRelease,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress1,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress2,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress3,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress4,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress5,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress6,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress7,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress8,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress9,
    /**
     * Indicates a long key press event, sent when a key was not release for a certain time.
     */
    KeyState__LongPress10,
    /**
     * Indicates a Unknown key event
     */
    KeyState__UNKNOWN

};

bool KeyState_Parse (const char *str, size_t length, KeyState &value);

const char* KeyState_Name (KeyState value);

bool KeyState_IsValid (KeyState value);

} // namespace Types
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_SCREENBROKER_TYPESCONST_H
