/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <cstddef>

/**
 * If the meaning of "Types" isn't clear, then there should be a description here.
 */

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Types {

bool Modality_Parse (const char *str, size_t length, Modality &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"SYSTEM", 1U},
        {11,"APPLICATION", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* Modality_Name (Modality value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "System",
        "Application",
    };

    if (Modality_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool Modality_IsValid (Modality value)
{
    switch (value) {
    case Modality__None:
    case Modality__System:
    case Modality__Application:
        return true;
    default:
        return false;
    }
}

bool HorizontalAlignment_Parse (const char *str, size_t length, HorizontalAlignment &value)
{
    static stringEntry entries[] = {
        {4,"LEFT", 0U},
        {5,"RIGHT", 2U},
        {6,"CENTER", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* HorizontalAlignment_Name (HorizontalAlignment value)
{
    static const char* enumerationLiterals[] = {
        "Left",
        "Center",
        "Right",
    };

    if (HorizontalAlignment_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool HorizontalAlignment_IsValid (HorizontalAlignment value)
{
    switch (value) {
    case HorizontalAlignment__Left:
    case HorizontalAlignment__Center:
    case HorizontalAlignment__Right:
        return true;
    default:
        return false;
    }
}

bool VerticalAlignment_Parse (const char *str, size_t length, VerticalAlignment &value)
{
    static stringEntry entries[] = {
        {3,"TOP", 2U},
        {6,"BOTTOM", 0U},
        {6,"CENTER", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* VerticalAlignment_Name (VerticalAlignment value)
{
    static const char* enumerationLiterals[] = {
        "Bottom",
        "Center",
        "Top",
    };

    if (VerticalAlignment_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool VerticalAlignment_IsValid (VerticalAlignment value)
{
    switch (value) {
    case VerticalAlignment__Bottom:
    case VerticalAlignment__Center:
    case VerticalAlignment__Top:
        return true;
    default:
        return false;
    }
}

bool Scaling_Parse (const char *str, size_t length, Scaling &value)
{
    static stringEntry entries[] = {
        {3,"CUT", 1U},
        {3,"FIT", 2U},
        {4,"NONE", 0U},
        {7,"STRETCH", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* Scaling_Name (Scaling value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Cut",
        "Fit",
        "Stretch",
    };

    if (Scaling_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool Scaling_IsValid (Scaling value)
{
    switch (value) {
    case Scaling__None:
    case Scaling__Cut:
    case Scaling__Fit:
    case Scaling__Stretch:
        return true;
    default:
        return false;
    }
}

bool SurfaceState_Parse (const char *str, size_t length, SurfaceState &value)
{
    static stringEntry entries[] = {
        {6,"MAPPED", 5U},
        {6,"QUEUED", 3U},
        {8,"UNMAPPED", 4U},
        {8,"UNQUEUED", 2U},
        {9,"CUSTOMEND", 7U},
        {10,"REGISTERED", 0U},
        {11,"CUSTOMSTART", 6U},
        {12,"DEREGISTERED", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* SurfaceState_Name (SurfaceState value)
{
    static const char* enumerationLiterals[] = {
        "Registered",
        "Deregistered",
        "Unqueued",
        "Queued",
        "Unmapped",
        "Mapped",
        "CustomStart",
        "CustomEnd",
    };

    if (SurfaceState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool SurfaceState_IsValid (SurfaceState value)
{
    switch (value) {
    case SurfaceState__Registered:
    case SurfaceState__Deregistered:
    case SurfaceState__Unqueued:
    case SurfaceState__Queued:
    case SurfaceState__Unmapped:
    case SurfaceState__Mapped:
    case SurfaceState__CustomStart:
    case SurfaceState__CustomEnd:
        return true;
    default:
        return false;
    }
}

bool LayerState_Parse (const char *str, size_t length, LayerState &value)
{
    static stringEntry entries[] = {
        {7,"CREATED", 0U},
        {9,"DESTROYED", 1U},
        {16,"ANIMATIONSTARTED", 2U},
        {16,"ANIMATIONSTOPPED", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* LayerState_Name (LayerState value)
{
    static const char* enumerationLiterals[] = {
        "Created",
        "Destroyed",
        "AnimationStarted",
        "AnimationStopped",
    };

    if (LayerState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool LayerState_IsValid (LayerState value)
{
    switch (value) {
    case LayerState__Created:
    case LayerState__Destroyed:
    case LayerState__AnimationStarted:
    case LayerState__AnimationStopped:
        return true;
    default:
        return false;
    }
}

bool KeyState_Parse (const char *str, size_t length, KeyState &value)
{
    static stringEntry entries[] = {
        {5,"PRESS", 1U},
        {7,"RELEASE", 0U},
        {7,"UNKNOWN", 13U},
        {10,"LONGPRESS1", 3U},
        {10,"LONGPRESS2", 4U},
        {10,"LONGPRESS3", 5U},
        {10,"LONGPRESS4", 6U},
        {10,"LONGPRESS5", 7U},
        {10,"LONGPRESS6", 8U},
        {10,"LONGPRESS7", 9U},
        {10,"LONGPRESS8", 10U},
        {10,"LONGPRESS9", 11U},
        {11,"LONGPRESS10", 12U},
        {11,"LONGRELEASE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 14, (unsigned int&) value);
}

const char* KeyState_Name (KeyState value)
{
    static const char* enumerationLiterals[] = {
        "Release",
        "Press",
        "LongRelease",
        "LongPress1",
        "LongPress2",
        "LongPress3",
        "LongPress4",
        "LongPress5",
        "LongPress6",
        "LongPress7",
        "LongPress8",
        "LongPress9",
        "LongPress10",
        "UNKNOWN",
    };

    if (KeyState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool KeyState_IsValid (KeyState value)
{
    switch (value) {
    case KeyState__Release:
    case KeyState__Press:
    case KeyState__LongRelease:
    case KeyState__LongPress1:
    case KeyState__LongPress2:
    case KeyState__LongPress3:
    case KeyState__LongPress4:
    case KeyState__LongPress5:
    case KeyState__LongPress6:
    case KeyState__LongPress7:
    case KeyState__LongPress8:
    case KeyState__LongPress9:
    case KeyState__LongPress10:
    case KeyState__UNKNOWN:
        return true;
    default:
        return false;
    }
}

} // namespace Types
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
