/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_SCREENBROKER_SERVICESTUB_H
#define BOSCH_CM_AI_HMI_SCREENBROKER_SERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

class ServiceStubDelegate;

class ServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ServiceStub (const std::string& portName);

    /**
     * Create an instance of the ServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~ServiceStub();

    // signal 'OnGetDisplayId'

    /**
     * Raise the signal 'OnGetDisplayId' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnGetDisplayId'</b>:
     *
     * The response to "GetDisplayId" request providing the requested display ID (name).
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param requestArg General application specific request information.
     *
     * @param displayId The display ID, where the screen area (from request) is linked to.
     */
    void sendOnGetDisplayIdSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 displayId);

    // signal 'OnGetPreferredDimensions'

    /**
     * Raise the signal 'OnGetPreferredDimensions' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'OnGetPreferredDimensions'</b>:
     *
     * The response to "GetPreferredDimensions" request providing the requested dimensions (width/height).
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param requestArg General application specific request information.
     *
     * @param dimensionArg The dimensions of the screen area (from request).
     */
    void sendOnGetPreferredDimensionsSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg);

    // signal 'OnSurfaceStateChanged'

    /**
     * Raise the signal 'OnSurfaceStateChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnSurfaceStateChanged'</b>:
     *
     * Notifies clients that the state of the indicated surface has changed.
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param userData The user defined data.
     *
     * @param surfaceId The ID of the affected surface.
     *
     * @param displayId DEPRECATED: The ID of the affected display.
     *
     * @param displayAlias The alias of the affected display.
     *
     * @param surfaceState The new state of the surface.
     */
    void sendOnSurfaceStateChangedSignal(const ::std::string& clientId, uint32 userData, uint32 surfaceId, uint32 displayId, uint32 displayAlias, ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState);

    // signal 'OnError'

    /**
     * Raise the signal 'OnError' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'OnError'</b>:
     *
     * The error response to any failed request providing information about the error.
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param requestArg General application specific request information.
     *
     * @param systemErrno System error codes (like linux extended error codes defined in linux/errno.h).
     *
     * @param presentationErrno Error codes specific to the visual presentation module screen broker is connected to (e.g. layer manager).
     */
    void sendOnErrorSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, int32 systemErrno, int32 presentationErrno);

    // signal 'OnKeyEvent'

    /**
     * Raise the signal 'OnKeyEvent' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'OnKeyEvent'</b>:
     *
     * Notifies clients that a key event has occurred.
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param userData The user defined data.
     *
     * @param surfaceId The ID of the surface, which is currently focused.
     *
     * @param keyCode 32bit code of the key event.
     *
     * @param keyState The state of the key event.
     */
    void sendOnKeyEventSignal(const ::std::string& clientId, uint32 userData, uint32 surfaceId, uint32 keyCode, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState);

    // signal 'OnCurrentStatus'

    /**
     * Raise the signal 'OnCurrentStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnCurrentStatus'</b>:
     *
     * The response to "RequestCurrentStatus" request providing the status details based on
     *                 the request.
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param requestId 32bit information to inform about details of the requests nature.
     *
     * @param surfaceId The ID of the surface, which identifies the response path, may also be part of the status response.
     *
     * @param status 32bit of response data carrying the status information.
     *
     * @param userData Additional 32bit of user data for whatever use.
     */
    void sendOnCurrentStatusSignal(const ::std::string& clientId, uint32 requestId, uint32 surfaceId, uint32 status, uint32 userData);

    // signal 'OnCloseOnExternalTouch'

    /**
     * Raise the signal 'OnCloseOnExternalTouch' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnCloseOnExternalTouch'</b>:
     *
     * Notifies clients that close on external touch is enabled or disabled.
     *
     * @param status Enabled or Disabled
     */
    void sendOnCloseOnExternalTouchSignal(bool status);

    // signal 'OnLayerStateChanged'

    /**
     * Raise the signal 'OnLayerStateChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnLayerStateChanged'</b>:
     *
     * Notifies clients that about Layer with layer animation state.
     *
     * @param clientId Unique client identification, identifies the receiver of the response.
     *
     * @param requestId 32bit information to inform about details of the requests nature.
     *
     * @param layerID Value of Layer
     *
     * @param layerState State of the Layer
     */
    void sendOnLayerStateChangedSignal(const ::std::string& clientId, uint32 requestId, uint32 layerID, ::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState);

    // property 'Version'

    /**
     * The method onVersionGet() is called by ASF when a client invokes the
     * read method for the property 'Version'. The onVersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    virtual void onVersionGet(const ::boost::shared_ptr< VersionGet >& payload);

    /**
     * Sends back the update to a previous onVersionGet().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVersionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVersionGetUpdate(const ::std::string& version, act_t act = 0);

    /**
     * Set the value of the property 'Version' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void setVersion(const ::std::string& version);

    /**
     * Returns the current value of the property 'Version'.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    const ::std::string& getVersion() const;

    /**
     * Returns the current value of the property 'Version' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendVersionUpdate() method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    ::std::string& getVersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVersionUpdate().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void sendVersionUpdate();

    // property 'BuildInLayers'

    /**
     * The method onBuildInLayersGet() is called by ASF when a client invokes
     * the read method for the property 'BuildInLayers'. The
     * onBuildInLayersGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     */
    virtual void onBuildInLayersGet(const ::boost::shared_ptr< BuildInLayersGet >& payload);

    /**
     * Sends back the update to a previous onBuildInLayersGet().
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onBuildInLayersGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBuildInLayersGetUpdate(const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& buildInLayers, act_t act = 0);

    /**
     * Set the value of the property 'BuildInLayers' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     */
    void setBuildInLayers(const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& buildInLayers);

    /**
     * Returns the current value of the property 'BuildInLayers'.
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     */
    const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayers() const;

    /**
     * Returns the current value of the property 'BuildInLayers' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBuildInLayersUpdate() method.
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     */
    ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayersMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBuildInLayersUpdate().
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     */
    void sendBuildInLayersUpdate();

    // method 'ClientTermination'

    /**
     * The method onClientTermination() is called by ASF when a client invokes
     * the method 'ClientTermination'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendClientTermination() or sendClientTerminationError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ClientTermination'</b>:
     *
     * Informs service about a client shutdown.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClientTerminationRequest (const ::boost::shared_ptr< ClientTerminationRequest >& request) = 0;

    /**
     * The method sendClientTerminationResponse() sends a response of a
     * previous method invocation of 'ClientTermination' back to the client.
     *
     * <b>Documentation of 'ClientTermination'</b>:
     *
     * Informs service about a client shutdown.
     *
     * @param success Informs if the client shutdown has succeeded.
     *
     * @param act The parameter act identifies a previous invocation of
     * onClientTermination(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendClientTerminationResponse (bool success, act_t act = 0);

    /**
     * The method sendClientTerminationError() sends an error response of a
     * previous method invocation of 'ClientTermination' back to the client.
     *
     * <b>Documentation of 'ClientTermination'</b>:
     *
     * Informs service about a client shutdown.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onClientTermination().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendClientTerminationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetDisplayId'

    /**
     * The method onGetDisplayId() is called by ASF when a client invokes the
     * method 'GetDisplayId'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetDisplayId'</b>:
     *
     * Requests the alpha-numerical ID (name) of the display the addressed screen area is configured to.
     * 		Requested values are provided by response "OnGetDisplayId".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetDisplayIdRequest (const ::boost::shared_ptr< GetDisplayIdRequest >& request) = 0;

    // method 'GetPreferredDimensions'

    /**
     * The method onGetPreferredDimensions() is called by ASF when a client
     * invokes the method 'GetPreferredDimensions'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'GetPreferredDimensions'</b>:
     *
     * Requests the dimensions a "full area surface" should have to fit to the screen area identified by "screenAreaId".
     * 		Requested values are provided by response "OnGetPreferredDimensions".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPreferredDimensionsRequest (const ::boost::shared_ptr< GetPreferredDimensionsRequest >& request) = 0;

    // method 'RegisterSurface'

    /**
     * The method onRegisterSurface() is called by ASF when a client invokes
     * the method 'RegisterSurface'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'RegisterSurface'</b>:
     *
     * Registers the ILM surface addressed by "surfaceId" to the screen area addressed by "screenAreaId".
     * 		Surface specific hinting information is provided in field "userData"
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterSurfaceRequest (const ::boost::shared_ptr< RegisterSurfaceRequest >& request) = 0;

    // method 'DeregisterSurface'

    /**
     * The method onDeregisterSurface() is called by ASF when a client invokes
     * the method 'DeregisterSurface'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'DeregisterSurface'</b>:
     *
     * Deregisters the surface addressed by "surfaceId".
     * 		Surface specific hinting information is provided in field "userData"
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeregisterSurfaceRequest (const ::boost::shared_ptr< DeregisterSurfaceRequest >& request) = 0;

    // method 'ActivateApplication'

    /**
     * The method onActivateApplication() is called by ASF when a client
     * invokes the method 'ActivateApplication'.  Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ActivateApplication'</b>:
     *
     * Requests the activation of the requesting client application and applies the keyboard focus to the surface addressed by "surfaceId".
     * 		Activation status is provided by response "OnActivateApplication".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActivateApplicationRequest (const ::boost::shared_ptr< ActivateApplicationRequest >& request) = 0;

    // method 'StartAnimation'

    /**
     * The method onStartAnimation() is called by ASF when a client invokes
     * the method 'StartAnimation'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'StartAnimation'</b>:
     *
     * Requests the client application and applies animation Entry/Exit for the same surface "surfaceId".
     * 		Activation status is provided by response "OnStartAnimation".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartAnimationRequest (const ::boost::shared_ptr< StartAnimationRequest >& request) = 0;

    // method 'AttachandAnimateLayer'

    /**
     * The method onAttachandAnimateLayer() is called by ASF when a client
     * invokes the method 'AttachandAnimateLayer'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'AttachandAnimateLayer'</b>:
     *
     * Requests the client application and applies animation to the Layer with surfaces.
     * 		Activation status is provided by response "OnAttachandAnimateLayer".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAttachandAnimateLayerRequest (const ::boost::shared_ptr< AttachandAnimateLayerRequest >& request) = 0;

    // method 'ShowPopup'

    /**
     * The method onShowPopup() is called by ASF when a client invokes the
     * method 'ShowPopup'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'ShowPopup'</b>:
     *
     * Requests the presentation of the surface pop-up overlay addressed by "surfaceId". The surface must be registered on a screen area dedicated for pop-ups in order to be presented as pop-up. Additional arguments are passed to activator plug-ins.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowPopupRequest (const ::boost::shared_ptr< ShowPopupRequest >& request) = 0;

    // method 'HidePopup'

    /**
     * The method onHidePopup() is called by ASF when a client invokes the
     * method 'HidePopup'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'HidePopup'</b>:
     *
     * Requests the concealing of the surface pop-up overlay addressed by "surfaceId".
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHidePopupRequest (const ::boost::shared_ptr< HidePopupRequest >& request) = 0;

    // method 'CloseOnExternalTouch'

    /**
     * The method onCloseOnExternalTouch() is called by ASF when a client
     * invokes the method 'CloseOnExternalTouch'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'CloseOnExternalTouch'</b>:
     *
     * Requests closing popup based on external touch.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCloseOnExternalTouchRequest (const ::boost::shared_ptr< CloseOnExternalTouchRequest >& request) = 0;

    // method 'SetPopupFilter'

    /**
     * The method onSetPopupFilter() is called by ASF when a client invokes
     * the method 'SetPopupFilter'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetPopupFilter'</b>:
     *
     * Filters the presentation of popups matching the given popup presentation arguments. Filter arguments are passed to activator plug-ins.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPopupFilterRequest (const ::boost::shared_ptr< SetPopupFilterRequest >& request) = 0;

    // method 'ClearPopupFilter'

    /**
     * The method onClearPopupFilter() is called by ASF when a client invokes
     * the method 'ClearPopupFilter'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'ClearPopupFilter'</b>:
     *
     * Clears a previous set popup filter. Additional arguments are passed to activator plug-ins.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onClearPopupFilterRequest (const ::boost::shared_ptr< ClearPopupFilterRequest >& request) = 0;

    // method 'KeyFeedback'

    /**
     * The method onKeyFeedback() is called by ASF when a client invokes the
     * method 'KeyFeedback'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'KeyFeedback'</b>:
     *
     * Returns the feedback from the client, whether it has consumed the respective event or not.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onKeyFeedbackRequest (const ::boost::shared_ptr< KeyFeedbackRequest >& request) = 0;

    // method 'Action'

    /**
     * The method onAction() is called by ASF when a client invokes the method
     * 'Action'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'Action'</b>:
     *
     * Interface for requesting a generic action towards screenbroker service resp. its plugins.
     * 		The generic action request is routed to all attached plugins.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActionRequest (const ::boost::shared_ptr< ActionRequest >& request) = 0;

    // method 'SetInputFocus'

    /**
     * The method onSetInputFocus() is called by ASF when a client invokes the
     * method 'SetInputFocus'.  Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetInputFocus'</b>:
     *
     * set input focus
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetInputFocusRequest (const ::boost::shared_ptr< SetInputFocusRequest >& request) = 0;

    // method 'RequestCurrentStatus'

    /**
     * The method onRequestCurrentStatus() is called by ASF when a client
     * invokes the method 'RequestCurrentStatus'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'RequestCurrentStatus'</b>:
     *
     * Generic interface for requesting the current status based on the request ID,
     * 		which defines the details of the status requests nature.
     * 		The status request is routed to all attached plugins.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestCurrentStatusRequest (const ::boost::shared_ptr< RequestCurrentStatusRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    VersionUpdate _VersionProperty;

    BuildInLayersUpdate _BuildInLayersProperty;

    friend class ServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_SCREENBROKER_SERVICESTUB_H
