/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceDBus.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceJson.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceStub.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/screenbroker/bosch/cm/ai/hmi/screenbroker/Service", ServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Action", 14 },
    { 9, "HidePopup", 9 },
    { 9, "ShowPopup", 8 },
    { 11, "KeyFeedback", 13 },
    { 12, "GetDisplayId", 1 },
    { 13, "SetInputFocus", 15 },
    { 14, "SetPopupFilter", 11 },
    { 14, "StartAnimation", 6 },
    { 15, "RegisterSurface", 3 },
    { 16, "ClearPopupFilter", 12 },
    { 17, "ClientTermination", 0 },
    { 17, "DeregisterSurface", 4 },
    { 19, "ActivateApplication", 5 },
    { 20, "CloseOnExternalTouch", 10 },
    { 20, "RequestCurrentStatus", 16 },
    { 21, "AttachandAnimateLayer", 7 },
    { 22, "GetPreferredDimensions", 2 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 7, "Version", 0 },
    { 13, "BuildInLayers", 1 },
};

class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.screenbroker.Service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 17, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ClientTermination'

            LOG_DEBUG_STUB("process method '%s'", "ClientTermination");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClientTerminationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClientTermination", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClientTerminationRequest > payload = ::boost::static_pointer_cast<ClientTerminationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onClientTerminationRequest(payload);
            return;
        }
        case 1: {

            // method 'GetDisplayId'

            LOG_DEBUG_STUB("process method '%s'", "GetDisplayId");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetDisplayIdRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetDisplayId", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetDisplayIdRequest > payload = ::boost::static_pointer_cast<GetDisplayIdRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onGetDisplayIdRequest(payload);
            return;
        }
        case 2: {

            // method 'GetPreferredDimensions'

            LOG_DEBUG_STUB("process method '%s'", "GetPreferredDimensions");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPreferredDimensionsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetPreferredDimensions", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPreferredDimensionsRequest > payload = ::boost::static_pointer_cast<GetPreferredDimensionsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onGetPreferredDimensionsRequest(payload);
            return;
        }
        case 3: {

            // method 'RegisterSurface'

            LOG_DEBUG_STUB("process method '%s'", "RegisterSurface");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterSurfaceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterSurface", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterSurfaceRequest > payload = ::boost::static_pointer_cast<RegisterSurfaceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onRegisterSurfaceRequest(payload);
            return;
        }
        case 4: {

            // method 'DeregisterSurface'

            LOG_DEBUG_STUB("process method '%s'", "DeregisterSurface");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeregisterSurfaceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DeregisterSurface", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DeregisterSurfaceRequest > payload = ::boost::static_pointer_cast<DeregisterSurfaceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onDeregisterSurfaceRequest(payload);
            return;
        }
        case 5: {

            // method 'ActivateApplication'

            LOG_DEBUG_STUB("process method '%s'", "ActivateApplication");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateApplicationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ActivateApplication", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActivateApplicationRequest > payload = ::boost::static_pointer_cast<ActivateApplicationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onActivateApplicationRequest(payload);
            return;
        }
        case 6: {

            // method 'StartAnimation'

            LOG_DEBUG_STUB("process method '%s'", "StartAnimation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartAnimationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartAnimation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartAnimationRequest > payload = ::boost::static_pointer_cast<StartAnimationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onStartAnimationRequest(payload);
            return;
        }
        case 7: {

            // method 'AttachandAnimateLayer'

            LOG_DEBUG_STUB("process method '%s'", "AttachandAnimateLayer");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AttachandAnimateLayerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AttachandAnimateLayer", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AttachandAnimateLayerRequest > payload = ::boost::static_pointer_cast<AttachandAnimateLayerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onAttachandAnimateLayerRequest(payload);
            return;
        }
        case 8: {

            // method 'ShowPopup'

            LOG_DEBUG_STUB("process method '%s'", "ShowPopup");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShowPopupRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShowPopup", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShowPopupRequest > payload = ::boost::static_pointer_cast<ShowPopupRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onShowPopupRequest(payload);
            return;
        }
        case 9: {

            // method 'HidePopup'

            LOG_DEBUG_STUB("process method '%s'", "HidePopup");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HidePopupRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HidePopup", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HidePopupRequest > payload = ::boost::static_pointer_cast<HidePopupRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onHidePopupRequest(payload);
            return;
        }
        case 10: {

            // method 'CloseOnExternalTouch'

            LOG_DEBUG_STUB("process method '%s'", "CloseOnExternalTouch");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CloseOnExternalTouchRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CloseOnExternalTouch", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CloseOnExternalTouchRequest > payload = ::boost::static_pointer_cast<CloseOnExternalTouchRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onCloseOnExternalTouchRequest(payload);
            return;
        }
        case 11: {

            // method 'SetPopupFilter'

            LOG_DEBUG_STUB("process method '%s'", "SetPopupFilter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPopupFilterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetPopupFilter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPopupFilterRequest > payload = ::boost::static_pointer_cast<SetPopupFilterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onSetPopupFilterRequest(payload);
            return;
        }
        case 12: {

            // method 'ClearPopupFilter'

            LOG_DEBUG_STUB("process method '%s'", "ClearPopupFilter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearPopupFilterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearPopupFilter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearPopupFilterRequest > payload = ::boost::static_pointer_cast<ClearPopupFilterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onClearPopupFilterRequest(payload);
            return;
        }
        case 13: {

            // method 'KeyFeedback'

            LOG_DEBUG_STUB("process method '%s'", "KeyFeedback");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyFeedbackRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "KeyFeedback", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< KeyFeedbackRequest > payload = ::boost::static_pointer_cast<KeyFeedbackRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onKeyFeedbackRequest(payload);
            return;
        }
        case 14: {

            // method 'Action'

            LOG_DEBUG_STUB("process method '%s'", "Action");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Action", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActionRequest > payload = ::boost::static_pointer_cast<ActionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onActionRequest(payload);
            return;
        }
        case 15: {

            // method 'SetInputFocus'

            LOG_DEBUG_STUB("process method '%s'", "SetInputFocus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetInputFocusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetInputFocus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetInputFocusRequest > payload = ::boost::static_pointer_cast<SetInputFocusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onSetInputFocusRequest(payload);
            return;
        }
        case 16: {

            // method 'RequestCurrentStatus'

            LOG_DEBUG_STUB("process method '%s'", "RequestCurrentStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestCurrentStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestCurrentStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestCurrentStatusRequest > payload = ::boost::static_pointer_cast<RequestCurrentStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onRequestCurrentStatusRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.screenbroker.Service\">\n"
            "    <property access=\"read\" name=\"Version\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"BuildInLayers\" type=\"a(uuus(uu))\"/>\n"
            "    <method name=\"ClientTermination\">\n"
            "      <doc>\n"
            "        <line>ClientTermination = Informs service about a client shutdown.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"success\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>success = Informs if the client shutdown has succeeded.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetDisplayId\">\n"
            "      <doc>\n"
            "        <line>GetDisplayId = Requests the alpha-numerical ID (name) of the display the addressed screen area is configured to.</line>\n"
            "        <line>Requested values are provided by response &quot;OnGetDisplayId&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"screenAreaId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenAreaId = ID of screen area, for which the request is issued.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"GetPreferredDimensions\">\n"
            "      <doc>\n"
            "        <line>GetPreferredDimensions = Requests the dimensions a &quot;full area surface&quot; should have to fit to the screen area identified by &quot;screenAreaId&quot;.</line>\n"
            "        <line>Requested values are provided by response &quot;OnGetPreferredDimensions&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"screenAreaId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenAreaId = ID of screen area, for which the request is issued.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RegisterSurface\">\n"
            "      <doc>\n"
            "        <line>RegisterSurface = Registers the ILM surface addressed by &quot;surfaceId&quot; to the screen area addressed by &quot;screenAreaId&quot;.</line>\n"
            "        <line>Surface specific hinting information is provided in field &quot;userData&quot;</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"screenAreaId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>screenAreaId = The ID of the screen area to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DeregisterSurface\">\n"
            "      <doc>\n"
            "        <line>DeregisterSurface = Deregisters the surface addressed by &quot;surfaceId&quot;.</line>\n"
            "        <line>Surface specific hinting information is provided in field &quot;userData&quot;</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sendToIlm\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>sendToIlm = If remove surface should be send to ILM.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ActivateApplication\">\n"
            "      <doc>\n"
            "        <line>ActivateApplication = Requests the activation of the requesting client application and applies the keyboard focus to the surface addressed by &quot;surfaceId&quot;.</line>\n"
            "        <line>Activation status is provided by response &quot;OnActivateApplication&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"entryCustomAnimationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>entryCustomAnimationType = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"exitCustomAnimationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>exitCustomAnimationType = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartAnimation\">\n"
            "      <doc>\n"
            "        <line>StartAnimation = Requests the client application and applies animation Entry/Exit for the same surface &quot;surfaceId&quot;.</line>\n"
            "        <line>Activation status is provided by response &quot;OnStartAnimation&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"animationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>animationType = The value of animationType. It could be customeAnimation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"hint\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>hint = The value of hint. used to perform animation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AttachandAnimateLayer\">\n"
            "      <doc>\n"
            "        <line>AttachandAnimateLayer = Requests the client application and applies animation to the Layer with surfaces.</line>\n"
            "        <line>Activation status is provided by response &quot;OnAttachandAnimateLayer&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"layerID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>layerID = The ID of the Layer to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceID\" type=\"au\">\n"
            "        <doc>\n"
            "          <line>surfaceID = The list of surface to be attached</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"animationType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>animationType = The value of animationType</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"hint\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>hint = The value of hint. used to perform animation</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ShowPopup\">\n"
            "      <doc>\n"
            "        <line>ShowPopup = Requests the presentation of the surface pop-up overlay addressed by &quot;surfaceId&quot;. The surface must be registered on a screen area dedicated for pop-ups in order to be presented as pop-up. Additional arguments are passed to activator plug-ins.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"popupPresentationArg\" type=\"(uuuuuuuui)\">\n"
            "        <doc>\n"
            "          <line>popupPresentationArg (of type PopupPresentationArg) = The presentation arguments for pop-up overlays.</line>\n"
            "          <line>PopupPresentationArg struct[priority, modality, presentationTime, minimumPresentationTime, validityPeriod, horizontalAlignment, verticalAlignment, scaling, focusPriority] = This class encapsulates arguments for ScreenBroker requests involving presesntation arguments for pop-up overlays.</line>\n"
            "          <line>0: PopupPresentationArg.priority ('u') = The priority of the pop-up.</line>\n"
            "          <line>1: PopupPresentationArg.modality ('?') = The modality of the pop-up.</line>\n"
            "          <line>2: PopupPresentationArg.presentationTime ('u') = The optional time period after which the pop-up is hidden automatically.</line>\n"
            "          <line>3: PopupPresentationArg.minimumPresentationTime ('u') = The optional time period for which a pop-up shall be at least be visible.</line>\n"
            "          <line>4: PopupPresentationArg.validityPeriod ('u') = The optional time period after which a not presented pop-up is discarded.</line>\n"
            "          <line>5: PopupPresentationArg.horizontalAlignment ('?') = The optional horizontal alignment attribute of surface on the screen area.</line>\n"
            "          <line>6: PopupPresentationArg.verticalAlignment ('?') = The optional vertical alignment attribute of surface on the screen area.</line>\n"
            "          <line>7: PopupPresentationArg.scaling ('?') = The optional scaling attribute of surface on the screen area.</line>\n"
            "          <line>8: PopupPresentationArg.focusPriority ('i') = The optional focus priority of the popup surface.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"HidePopup\">\n"
            "      <doc>\n"
            "        <line>HidePopup = Requests the concealing of the surface pop-up overlay addressed by &quot;surfaceId&quot;.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"CloseOnExternalTouch\">\n"
            "      <doc>\n"
            "        <line>CloseOnExternalTouch = Requests closing popup based on external touch.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetPopupFilter\">\n"
            "      <doc>\n"
            "        <line>SetPopupFilter = Filters the presentation of popups matching the given popup presentation arguments. Filter arguments are passed to activator plug-ins.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"disableAll\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>disableAll = If true, presentation of all popups shall be disabled. In this case the argument popupPresentationArg is &quot;don't care&quot;.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"popupPresentationArg\" type=\"(uuuuuuuui)\">\n"
            "        <doc>\n"
            "          <line>popupPresentationArg (of type PopupPresentationArg) = The presentation arguments presenting the filter arguments. Only valid if argument &quot;disableAll&quot; is false.</line>\n"
            "          <line>PopupPresentationArg struct[priority, modality, presentationTime, minimumPresentationTime, validityPeriod, horizontalAlignment, verticalAlignment, scaling, focusPriority] = This class encapsulates arguments for ScreenBroker requests involving presesntation arguments for pop-up overlays.</line>\n"
            "          <line>0: PopupPresentationArg.priority ('u') = The priority of the pop-up.</line>\n"
            "          <line>1: PopupPresentationArg.modality ('?') = The modality of the pop-up.</line>\n"
            "          <line>2: PopupPresentationArg.presentationTime ('u') = The optional time period after which the pop-up is hidden automatically.</line>\n"
            "          <line>3: PopupPresentationArg.minimumPresentationTime ('u') = The optional time period for which a pop-up shall be at least be visible.</line>\n"
            "          <line>4: PopupPresentationArg.validityPeriod ('u') = The optional time period after which a not presented pop-up is discarded.</line>\n"
            "          <line>5: PopupPresentationArg.horizontalAlignment ('?') = The optional horizontal alignment attribute of surface on the screen area.</line>\n"
            "          <line>6: PopupPresentationArg.verticalAlignment ('?') = The optional vertical alignment attribute of surface on the screen area.</line>\n"
            "          <line>7: PopupPresentationArg.scaling ('?') = The optional scaling attribute of surface on the screen area.</line>\n"
            "          <line>8: PopupPresentationArg.focusPriority ('i') = The optional focus priority of the popup surface.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ClearPopupFilter\">\n"
            "      <doc>\n"
            "        <line>ClearPopupFilter = Clears a previous set popup filter. Additional arguments are passed to activator plug-ins.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"KeyFeedback\">\n"
            "      <doc>\n"
            "        <line>KeyFeedback = Returns the feedback from the client, whether it has consumed the respective event or not.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"keyCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>keyCode = 32bit code of the key event.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"keyState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>keyState (of type KeyState) = The state of the key event.</line>\n"
            "          <line>enum[Release (null), Press (null), LongRelease (null), LongPress1 (null), LongPress2 (null), LongPress3 (null), LongPress4 (null), LongPress5 (null), LongPress6 (null), LongPress7 (null), LongPress8 (null), LongPress9 (null), LongPress10 (null), UNKNOWN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"consumed\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>consumed = True, if the key event was already consumed, false otherwise.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"Action\">\n"
            "      <doc>\n"
            "        <line>Action = Interface for requesting a generic action towards screenbroker service resp. its plugins.</line>\n"
            "        <line>The generic action request is routed to all attached plugins.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"actionId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionId = 32bit information to transport details of the kind of action.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"actionData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>actionData = 32bit information to transport action specific data.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetInputFocus\">\n"
            "      <doc>\n"
            "        <line>SetInputFocus = set input focus</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface to address.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"keyboardFocus\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>keyboardFocus = keyboard focus</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"pointerFocus\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>pointerFocus = pointer focus</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"priority\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>priority = focus priority</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"focusData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>focusData = 32bit information to transport focus specific data.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestCurrentStatus\">\n"
            "      <doc>\n"
            "        <line>RequestCurrentStatus = Generic interface for requesting the current status based on the request ID,</line>\n"
            "        <line>which defines the details of the status requests nature.</line>\n"
            "        <line>The status request is routed to all attached plugins.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the sender of the request.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"requestId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>requestId = 32bit information to transport details of the requests nature.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"OnGetDisplayId\">\n"
            "      <doc>\n"
            "        <line>OnGetDisplayId = The response to &quot;GetDisplayId&quot; request providing the requested display ID (name).</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"displayId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>displayId = The display ID, where the screen area (from request) is linked to.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnGetPreferredDimensions\">\n"
            "      <doc>\n"
            "        <line>OnGetPreferredDimensions = The response to &quot;GetPreferredDimensions&quot; request providing the requested dimensions (width/height).</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"dimensionArg\" type=\"(uu)\">\n"
            "        <doc>\n"
            "          <line>dimensionArg (of type DimensionArg) = The dimensions of the screen area (from request).</line>\n"
            "          <line>DimensionArg struct[width, height] = This class encapsulates arguments for ScreenBroker responses providing dimensions.</line>\n"
            "          <line>0: DimensionArg.width ('u') = The horizontal dimension value.</line>\n"
            "          <line>1: DimensionArg.height ('u') = The vertical dimension value.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnSurfaceStateChanged\">\n"
            "      <doc>\n"
            "        <line>OnSurfaceStateChanged = Notifies clients that the state of the indicated surface has changed.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = The user defined data.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the affected surface.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"displayId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>displayId = DEPRECATED: The ID of the affected display.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"displayAlias\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>displayAlias = The alias of the affected display.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceState (of type SurfaceState) = The new state of the surface.</line>\n"
            "          <line>enum[Registered (null), Deregistered (null), Unqueued (null), Queued (null), Unmapped (null), Mapped (null), CustomStart (null), CustomEnd (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnError\">\n"
            "      <doc>\n"
            "        <line>OnError = The error response to any failed request providing information about the error.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestArg\" type=\"(uuu)\">\n"
            "        <doc>\n"
            "          <line>requestArg (of type RequestArg) = General application specific request information.</line>\n"
            "          <line>RequestArg struct[requestId, appId, userData] = This class encapsulates standard arguments for ScreenBroker requests.</line>\n"
            "          <line>0: RequestArg.requestId ('u') = The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.</line>\n"
            "          <line>1: RequestArg.appId ('u') = The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "          <line>2: RequestArg.userData ('u') = The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"systemErrno\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>systemErrno = System error codes (like linux extended error codes defined in linux/errno.h).</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"presentationErrno\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>presentationErrno = Error codes specific to the visual presentation module screen broker is connected to (e.g. layer manager).</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnKeyEvent\">\n"
            "      <doc>\n"
            "        <line>OnKeyEvent = Notifies clients that a key event has occurred.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = The user defined data.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface, which is currently focused.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"keyCode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>keyCode = 32bit code of the key event.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"keyState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>keyState (of type KeyState) = The state of the key event.</line>\n"
            "          <line>enum[Release (null), Press (null), LongRelease (null), LongPress1 (null), LongPress2 (null), LongPress3 (null), LongPress4 (null), LongPress5 (null), LongPress6 (null), LongPress7 (null), LongPress8 (null), LongPress9 (null), LongPress10 (null), UNKNOWN (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnCurrentStatus\">\n"
            "      <doc>\n"
            "        <line>OnCurrentStatus = The response to &quot;RequestCurrentStatus&quot; request providing the status details based on</line>\n"
            "        <line>the request.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>requestId = 32bit information to inform about details of the requests nature.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"surfaceId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>surfaceId = The ID of the surface, which identifies the response path, may also be part of the status response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>status = 32bit of response data carrying the status information.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"userData\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>userData = Additional 32bit of user data for whatever use.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnCloseOnExternalTouch\">\n"
            "      <doc>\n"
            "        <line>OnCloseOnExternalTouch = Notifies clients that close on external touch is enabled or disabled.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Enabled or Disabled</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"OnLayerStateChanged\">\n"
            "      <doc>\n"
            "        <line>OnLayerStateChanged = Notifies clients that about Layer with layer animation state.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"clientId\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>clientId = Unique client identification, identifies the receiver of the response.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"requestId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>requestId = 32bit information to inform about details of the requests nature.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"layerID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>layerID = Value of Layer</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"layerState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>layerState (of type LayerState) = State of the Layer</line>\n"
            "          <line>enum[Created (null), Destroyed (null), AnimationStarted (null), AnimationStopped (null)]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "BuildInLayers");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            ::boost::shared_ptr< VersionGet > payload(new VersionGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onVersionGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "BuildInLayers");
            ::boost::shared_ptr< BuildInLayersGet > payload(new BuildInLayersGet());
            payload->setAct(act);
            static_cast<ServiceStub*>(getStub())->onBuildInLayersGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendOnGetDisplayIdSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 displayId) {
    if (_stubDelegate->isConnected()) {
        OnGetDisplayIdSignal* payload = new OnGetDisplayIdSignal(clientId, requestArg, displayId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnGetDisplayId", OnGetDisplayIdSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnGetDisplayId");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnGetDisplayId");
    }
}

void ServiceStub::sendOnGetPreferredDimensionsSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, const ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg& dimensionArg) {
    if (_stubDelegate->isConnected()) {
        OnGetPreferredDimensionsSignal* payload = new OnGetPreferredDimensionsSignal(clientId, requestArg, dimensionArg);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnGetPreferredDimensions", OnGetPreferredDimensionsSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnGetPreferredDimensions");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnGetPreferredDimensions");
    }
}

void ServiceStub::sendOnSurfaceStateChangedSignal(const ::std::string& clientId, uint32 userData, uint32 surfaceId, uint32 displayId, uint32 displayAlias, ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceState) {
    if (_stubDelegate->isConnected()) {
        OnSurfaceStateChangedSignal* payload = new OnSurfaceStateChangedSignal(clientId, userData, surfaceId, displayId, displayAlias, surfaceState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnSurfaceStateChanged", OnSurfaceStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnSurfaceStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnSurfaceStateChanged");
    }
}

void ServiceStub::sendOnErrorSignal(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, int32 systemErrno, int32 presentationErrno) {
    if (_stubDelegate->isConnected()) {
        OnErrorSignal* payload = new OnErrorSignal(clientId, requestArg, systemErrno, presentationErrno);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnError", OnErrorSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnError");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnError");
    }
}

void ServiceStub::sendOnKeyEventSignal(const ::std::string& clientId, uint32 userData, uint32 surfaceId, uint32 keyCode, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState) {
    if (_stubDelegate->isConnected()) {
        OnKeyEventSignal* payload = new OnKeyEventSignal(clientId, userData, surfaceId, keyCode, keyState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnKeyEvent", OnKeyEventSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnKeyEvent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnKeyEvent");
    }
}

void ServiceStub::sendOnCurrentStatusSignal(const ::std::string& clientId, uint32 requestId, uint32 surfaceId, uint32 status, uint32 userData) {
    if (_stubDelegate->isConnected()) {
        OnCurrentStatusSignal* payload = new OnCurrentStatusSignal(clientId, requestId, surfaceId, status, userData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnCurrentStatus", OnCurrentStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnCurrentStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnCurrentStatus");
    }
}

void ServiceStub::sendOnCloseOnExternalTouchSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        OnCloseOnExternalTouchSignal* payload = new OnCloseOnExternalTouchSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnCloseOnExternalTouch", OnCloseOnExternalTouchSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnCloseOnExternalTouch");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnCloseOnExternalTouch");
    }
}

void ServiceStub::sendOnLayerStateChangedSignal(const ::std::string& clientId, uint32 requestId, uint32 layerID, ::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerState) {
    if (_stubDelegate->isConnected()) {
        OnLayerStateChangedSignal* payload = new OnLayerStateChangedSignal(clientId, requestId, layerID, layerState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnLayerStateChanged", OnLayerStateChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnLayerStateChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnLayerStateChanged");
    }
}

void ServiceStub::sendVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionUpdate payload(_VersionProperty);

        LOG_INFO ("-> send%s", "VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.screenbroker.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionUpdate");
    }
}

void ServiceStub::onVersionGet(const ::boost::shared_ptr< VersionGet >& version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionGet", version->getAct());
    sendVersionGetUpdate(_VersionProperty.getVersion(), version->getAct());
}

void ServiceStub::sendVersionGetUpdate(const ::std::string& version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionGet payload(version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setVersion(const ::std::string& version) {
    if(version!=_VersionProperty.getVersion()) {
        _VersionProperty.setVersion(version);
        sendVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ServiceStub::getVersion() const {
    return _VersionProperty.getVersion();
}

::std::string& ServiceStub::getVersionMutable() {
    return _VersionProperty.getVersionMutable();
}

void ServiceStub::sendBuildInLayersUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BuildInLayersUpdate payload(_BuildInLayersProperty);

        LOG_INFO ("-> send%s", "BuildInLayersUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BuildInLayers", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.screenbroker.Service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BuildInLayersUpdate");
    }
}

void ServiceStub::onBuildInLayersGet(const ::boost::shared_ptr< BuildInLayersGet >& buildInLayers) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BuildInLayersGet", buildInLayers->getAct());
    sendBuildInLayersGetUpdate(_BuildInLayersProperty.getBuildInLayers(), buildInLayers->getAct());
}

void ServiceStub::sendBuildInLayersGetUpdate(const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& buildInLayers, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BuildInLayersGet payload(buildInLayers);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BuildInLayersGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ServiceStub::setBuildInLayers(const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& buildInLayers) {
    if(buildInLayers!=_BuildInLayersProperty.getBuildInLayers()) {
        _BuildInLayersProperty.setBuildInLayers(buildInLayers);
        sendBuildInLayersUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& ServiceStub::getBuildInLayers() const {
    return _BuildInLayersProperty.getBuildInLayers();
}

::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& ServiceStub::getBuildInLayersMutable() {
    return _BuildInLayersProperty.getBuildInLayersMutable();
}

void  ServiceStub::sendClientTerminationResponse (bool success, act_t act) {
    ClientTerminationResponse* payload = new ClientTerminationResponse(success);
    DBUS_MESSAGE_REPLY(dbusMessage, "ClientTermination", ClientTerminationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClientTermination", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendClientTerminationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClientTerminationError* payload = new ClientTerminationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ClientTermination", ClientTerminationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClientTermination", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

















void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Version'
    {
        ::asf::dbus::DBusVariant variant;
        VersionGet payload(_VersionProperty.getVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Version", variant));
    }

    //property 'BuildInLayers'
    {
        ::asf::dbus::DBusVariant variant;
        BuildInLayersGet payload(_BuildInLayersProperty.getBuildInLayers());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BuildInLayers", variant));
    }
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
