/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_SCREENBROKER_SERVICEPROXY_H
#define BOSCH_CM_AI_HMI_SCREENBROKER_SERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

class ServiceProxy;

class BuildInLayersCallbackIF {
public:
    virtual ~BuildInLayersCallbackIF() {}

    virtual void onBuildInLayersError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< BuildInLayersError >& error) = 0;

    virtual void onBuildInLayersUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< BuildInLayersUpdate >& update) = 0;
};

class ClientTerminationCallbackIF {
public:
    virtual ~ClientTerminationCallbackIF() {}

    virtual void onClientTerminationError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ClientTerminationError >& error) = 0;

    virtual void onClientTerminationResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ClientTerminationResponse >& response) = 0;
};

class OnCloseOnExternalTouchCallbackIF {
public:
    virtual ~OnCloseOnExternalTouchCallbackIF() {}

    virtual void onOnCloseOnExternalTouchError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnCloseOnExternalTouchError >& error) = 0;

    virtual void onOnCloseOnExternalTouchSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnCloseOnExternalTouchSignal >& signal) = 0;
};

class OnCurrentStatusCallbackIF {
public:
    virtual ~OnCurrentStatusCallbackIF() {}

    virtual void onOnCurrentStatusError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnCurrentStatusError >& error) = 0;

    virtual void onOnCurrentStatusSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnCurrentStatusSignal >& signal) = 0;
};

class OnErrorCallbackIF {
public:
    virtual ~OnErrorCallbackIF() {}

    virtual void onOnErrorError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnErrorError >& error) = 0;

    virtual void onOnErrorSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnErrorSignal >& signal) = 0;
};

class OnGetDisplayIdCallbackIF {
public:
    virtual ~OnGetDisplayIdCallbackIF() {}

    virtual void onOnGetDisplayIdError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnGetDisplayIdError >& error) = 0;

    virtual void onOnGetDisplayIdSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnGetDisplayIdSignal >& signal) = 0;
};

class OnGetPreferredDimensionsCallbackIF {
public:
    virtual ~OnGetPreferredDimensionsCallbackIF() {}

    virtual void onOnGetPreferredDimensionsError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnGetPreferredDimensionsError >& error) = 0;

    virtual void onOnGetPreferredDimensionsSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnGetPreferredDimensionsSignal >& signal) = 0;
};

class OnKeyEventCallbackIF {
public:
    virtual ~OnKeyEventCallbackIF() {}

    virtual void onOnKeyEventError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnKeyEventError >& error) = 0;

    virtual void onOnKeyEventSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnKeyEventSignal >& signal) = 0;
};

class OnLayerStateChangedCallbackIF {
public:
    virtual ~OnLayerStateChangedCallbackIF() {}

    virtual void onOnLayerStateChangedError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnLayerStateChangedError >& error) = 0;

    virtual void onOnLayerStateChangedSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnLayerStateChangedSignal >& signal) = 0;
};

class OnSurfaceStateChangedCallbackIF {
public:
    virtual ~OnSurfaceStateChangedCallbackIF() {}

    virtual void onOnSurfaceStateChangedError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnSurfaceStateChangedError >& error) = 0;

    virtual void onOnSurfaceStateChangedSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< OnSurfaceStateChangedSignal >& signal) = 0;
};

class VersionCallbackIF {
public:
    virtual ~VersionCallbackIF() {}

    virtual void onVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

    virtual void onVersionUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
};


/**
 * ServiceProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.ai.hmi.screenbroker.Service' (specified in file
 * ScreenBrokerService_.xml).
 *
 * If the meaning of "bosch.cm.ai.hmi.screenbroker.Service" isn't clear, then there should be a description here.
 */
class ServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ServiceProxy.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ServiceProxy ();


    // Signal 'OnGetDisplayId'

    /**
     * Notify on the signal 'OnGetDisplayId'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'OnGetDisplayId'</b>:
     *
     * The response to "GetDisplayId" request providing the requested display ID (name).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnGetDisplayIdRegister(OnGetDisplayIdCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnGetDisplayId'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnGetDisplayId'</b>:
     *
     * The response to "GetDisplayId" request providing the requested display ID (name).
     *
     * @param act The act which was previously returned by the
     * sendOnGetDisplayIdRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnGetDisplayIdDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnGetDisplayId'.
     */
    void sendOnGetDisplayIdDeregisterAll () const;

    // Signal 'OnGetPreferredDimensions'

    /**
     * Notify on the signal 'OnGetPreferredDimensions'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'OnGetPreferredDimensions'</b>:
     *
     * The response to "GetPreferredDimensions" request providing the requested dimensions (width/height).
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnGetPreferredDimensionsRegister(OnGetPreferredDimensionsCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnGetPreferredDimensions'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnGetPreferredDimensions'</b>:
     *
     * The response to "GetPreferredDimensions" request providing the requested dimensions (width/height).
     *
     * @param act The act which was previously returned by the
     * sendOnGetPreferredDimensionsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnGetPreferredDimensionsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnGetPreferredDimensions'.
     */
    void sendOnGetPreferredDimensionsDeregisterAll () const;

    // Signal 'OnSurfaceStateChanged'

    /**
     * Notify on the signal 'OnSurfaceStateChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'OnSurfaceStateChanged'</b>:
     *
     * Notifies clients that the state of the indicated surface has changed.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnSurfaceStateChangedRegister(OnSurfaceStateChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnSurfaceStateChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnSurfaceStateChanged'</b>:
     *
     * Notifies clients that the state of the indicated surface has changed.
     *
     * @param act The act which was previously returned by the
     * sendOnSurfaceStateChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnSurfaceStateChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnSurfaceStateChanged'.
     */
    void sendOnSurfaceStateChangedDeregisterAll () const;

    // Signal 'OnError'

    /**
     * Notify on the signal 'OnError'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'OnError'</b>:
     *
     * The error response to any failed request providing information about the error.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnErrorRegister(OnErrorCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnError'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnError'</b>:
     *
     * The error response to any failed request providing information about the error.
     *
     * @param act The act which was previously returned by the
     * sendOnErrorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnErrorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnError'.
     */
    void sendOnErrorDeregisterAll () const;

    // Signal 'OnKeyEvent'

    /**
     * Notify on the signal 'OnKeyEvent'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'OnKeyEvent'</b>:
     *
     * Notifies clients that a key event has occurred.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnKeyEventRegister(OnKeyEventCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnKeyEvent'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnKeyEvent'</b>:
     *
     * Notifies clients that a key event has occurred.
     *
     * @param act The act which was previously returned by the
     * sendOnKeyEventRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnKeyEventDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnKeyEvent'.
     */
    void sendOnKeyEventDeregisterAll () const;

    // Signal 'OnCurrentStatus'

    /**
     * Notify on the signal 'OnCurrentStatus'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'OnCurrentStatus'</b>:
     *
     * The response to "RequestCurrentStatus" request providing the status details based on
     *                 the request.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnCurrentStatusRegister(OnCurrentStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnCurrentStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnCurrentStatus'</b>:
     *
     * The response to "RequestCurrentStatus" request providing the status details based on
     *                 the request.
     *
     * @param act The act which was previously returned by the
     * sendOnCurrentStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnCurrentStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnCurrentStatus'.
     */
    void sendOnCurrentStatusDeregisterAll () const;

    // Signal 'OnCloseOnExternalTouch'

    /**
     * Notify on the signal 'OnCloseOnExternalTouch'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'OnCloseOnExternalTouch'</b>:
     *
     * Notifies clients that close on external touch is enabled or disabled.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnCloseOnExternalTouchRegister(OnCloseOnExternalTouchCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnCloseOnExternalTouch'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnCloseOnExternalTouch'</b>:
     *
     * Notifies clients that close on external touch is enabled or disabled.
     *
     * @param act The act which was previously returned by the
     * sendOnCloseOnExternalTouchRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnCloseOnExternalTouchDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnCloseOnExternalTouch'.
     */
    void sendOnCloseOnExternalTouchDeregisterAll () const;

    // Signal 'OnLayerStateChanged'

    /**
     * Notify on the signal 'OnLayerStateChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'OnLayerStateChanged'</b>:
     *
     * Notifies clients that about Layer with layer animation state.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendOnLayerStateChangedRegister(OnLayerStateChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'OnLayerStateChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'OnLayerStateChanged'</b>:
     *
     * Notifies clients that about Layer with layer animation state.
     *
     * @param act The act which was previously returned by the
     * sendOnLayerStateChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendOnLayerStateChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'OnLayerStateChanged'.
     */
    void sendOnLayerStateChangedDeregisterAll () const;


    // Property 'Version'


    /**
     * Request the value of the property 'Version' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionGet(VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVersion()
     * returns true.
     *
     * @return the previously received value of the property 'Version'.
     */
    const ::std::string& getVersion() const;

    /**
     * Determines whether a status message for the property 'Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVersion() const;

    // Property 'BuildInLayers'


    /**
     * Request the value of the property 'BuildInLayers' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'BuildInLayers'</b>:
     *
     * If the meaning of "BuildInLayers" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBuildInLayersGet(BuildInLayersCallbackIF& cb);


    /**
     * Returns the current value of the property 'BuildInLayers' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasBuildInLayers() returns true.
     *
     * @return the previously received value of the property 'BuildInLayers'.
     */
    const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& getBuildInLayers() const;

    /**
     * Determines whether a status message for the property 'BuildInLayers'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBuildInLayers() const;


    // Method 'ClientTermination'

    /**
     * Call the method 'ClientTermination'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ClientTermination'</b>:
     *
     * Informs service about a client shutdown.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClientTerminationRequest(ClientTerminationCallbackIF& cb, const ::std::string& clientId) const;

    // Method 'GetDisplayId'

    /**
     * Call the method 'GetDisplayId'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetDisplayId'</b>:
     *
     * Requests the alpha-numerical ID (name) of the display the addressed screen area is configured to.
     * 		Requested values are provided by response "OnGetDisplayId".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param screenAreaId ID of screen area, for which the request is issued.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDisplayIdRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId) const;

    // Method 'GetPreferredDimensions'

    /**
     * Call the method 'GetPreferredDimensions'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'GetPreferredDimensions'</b>:
     *
     * Requests the dimensions a "full area surface" should have to fit to the screen area identified by "screenAreaId".
     * 		Requested values are provided by response "OnGetPreferredDimensions".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param screenAreaId ID of screen area, for which the request is issued.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPreferredDimensionsRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId) const;

    // Method 'RegisterSurface'

    /**
     * Call the method 'RegisterSurface'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RegisterSurface'</b>:
     *
     * Registers the ILM surface addressed by "surfaceId" to the screen area addressed by "screenAreaId".
     * 		Surface specific hinting information is provided in field "userData"
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param screenAreaId The ID of the screen area to address.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterSurfaceRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId, uint32 surfaceId) const;

    // Method 'DeregisterSurface'

    /**
     * Call the method 'DeregisterSurface'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DeregisterSurface'</b>:
     *
     * Deregisters the surface addressed by "surfaceId".
     * 		Surface specific hinting information is provided in field "userData"
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @param sendToIlm If remove surface should be send to ILM.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeregisterSurfaceRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, bool sendToIlm) const;

    // Method 'ActivateApplication'

    /**
     * Call the method 'ActivateApplication'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'ActivateApplication'</b>:
     *
     * Requests the activation of the requesting client application and applies the keyboard focus to the surface addressed by "surfaceId".
     * 		Activation status is provided by response "OnActivateApplication".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @param entryCustomAnimationType The ID of the surface to address.
     *
     * @param exitCustomAnimationType The ID of the surface to address.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActivateApplicationRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, uint32 entryCustomAnimationType, uint32 exitCustomAnimationType) const;

    // Method 'StartAnimation'

    /**
     * Call the method 'StartAnimation'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'StartAnimation'</b>:
     *
     * Requests the client application and applies animation Entry/Exit for the same surface "surfaceId".
     * 		Activation status is provided by response "OnStartAnimation".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @param animationType The value of animationType. It could be customeAnimation
     *
     * @param hint The value of hint. used to perform animation
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartAnimationRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, uint32 animationType, uint32 hint) const;

    // Method 'AttachandAnimateLayer'

    /**
     * Call the method 'AttachandAnimateLayer'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'AttachandAnimateLayer'</b>:
     *
     * Requests the client application and applies animation to the Layer with surfaces.
     * 		Activation status is provided by response "OnAttachandAnimateLayer".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param layerID The ID of the Layer to address.
     *
     * @param surfaceID The list of surface to be attached
     *
     * @param animationType The value of animationType
     *
     * @param hint The value of hint. used to perform animation
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAttachandAnimateLayerRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 layerID, const ::std::vector< uint32 >& surfaceID, uint32 animationType, uint32 hint) const;

    // Method 'ShowPopup'

    /**
     * Call the method 'ShowPopup'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ShowPopup'</b>:
     *
     * Requests the presentation of the surface pop-up overlay addressed by "surfaceId". The surface must be registered on a screen area dedicated for pop-ups in order to be presented as pop-up. Additional arguments are passed to activator plug-ins.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @param popupPresentationArg The presentation arguments for pop-up overlays.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendShowPopupRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg) const;

    // Method 'HidePopup'

    /**
     * Call the method 'HidePopup'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'HidePopup'</b>:
     *
     * Requests the concealing of the surface pop-up overlay addressed by "surfaceId".
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHidePopupRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId) const;

    // Method 'CloseOnExternalTouch'

    /**
     * Call the method 'CloseOnExternalTouch'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'CloseOnExternalTouch'</b>:
     *
     * Requests closing popup based on external touch.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCloseOnExternalTouchRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg) const;

    // Method 'SetPopupFilter'

    /**
     * Call the method 'SetPopupFilter'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetPopupFilter'</b>:
     *
     * Filters the presentation of popups matching the given popup presentation arguments. Filter arguments are passed to activator plug-ins.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @param disableAll If true, presentation of all popups shall be disabled. In this case the argument popupPresentationArg is "don't care".
     *
     * @param popupPresentationArg The presentation arguments presenting the filter arguments. Only valid if argument "disableAll" is false.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPopupFilterRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, bool disableAll, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg) const;

    // Method 'ClearPopupFilter'

    /**
     * Call the method 'ClearPopupFilter'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ClearPopupFilter'</b>:
     *
     * Clears a previous set popup filter. Additional arguments are passed to activator plug-ins.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestArg General application specific request information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearPopupFilterRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg) const;

    // Method 'KeyFeedback'

    /**
     * Call the method 'KeyFeedback'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'KeyFeedback'</b>:
     *
     * Returns the feedback from the client, whether it has consumed the respective event or not.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param userData The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @param keyCode 32bit code of the key event.
     *
     * @param keyState The state of the key event.
     *
     * @param consumed True, if the key event was already consumed, false otherwise.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyFeedbackRequest(const ::std::string& clientId, uint32 userData, uint32 keyCode, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState, bool consumed) const;

    // Method 'Action'

    /**
     * Call the method 'Action'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Action'</b>:
     *
     * Interface for requesting a generic action towards screenbroker service resp. its plugins.
     * 		The generic action request is routed to all attached plugins.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param actionId 32bit information to transport details of the kind of action.
     *
     * @param actionData 32bit information to transport action specific data.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendActionRequest(const ::std::string& clientId, uint32 actionId, uint32 actionData) const;

    // Method 'SetInputFocus'

    /**
     * Call the method 'SetInputFocus'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetInputFocus'</b>:
     *
     * set input focus
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param surfaceId The ID of the surface to address.
     *
     * @param keyboardFocus keyboard focus
     *
     * @param pointerFocus pointer focus
     *
     * @param priority focus priority
     *
     * @param focusData 32bit information to transport focus specific data.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetInputFocusRequest(const ::std::string& clientId, uint32 surfaceId, bool keyboardFocus, bool pointerFocus, int32 priority, uint32 focusData) const;

    // Method 'RequestCurrentStatus'

    /**
     * Call the method 'RequestCurrentStatus'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RequestCurrentStatus'</b>:
     *
     * Generic interface for requesting the current status based on the request ID,
     * 		which defines the details of the status requests nature.
     * 		The status request is routed to all attached plugins.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param clientId Unique client identification, identifies the sender of the request.
     *
     * @param requestId 32bit information to transport details of the requests nature.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestCurrentStatusRequest(const ::std::string& clientId, uint32 requestId) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Version'

    ::asf::core::nullable< VersionUpdate > _version;

    // Property 'BuildInLayers'

    ::asf::core::nullable< BuildInLayersUpdate > _buildInLayers;

    DECLARE_CLASS_LOGGER();

    friend class ServiceProxyCallback;
};

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_SCREENBROKER_SERVICEPROXY_H
