/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceDBus.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceJson.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceProxy.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Service {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/screenbroker/bosch/cm/ai/hmi/screenbroker/Service", ServiceProxy);

class ServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ServiceProxy >& proxyShared = ::boost::static_pointer_cast< ServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_OnGetDisplayId:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnGetDisplayIdSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnGetDisplayId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnGetDisplayIdSignal> payload = ::boost::static_pointer_cast<OnGetDisplayIdSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnGetDisplayIdCallbackIF*) _callback)->onOnGetDisplayIdSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnGetPreferredDimensions:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnGetPreferredDimensionsSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnGetPreferredDimensions", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnGetPreferredDimensionsSignal> payload = ::boost::static_pointer_cast<OnGetPreferredDimensionsSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnGetPreferredDimensionsCallbackIF*) _callback)->onOnGetPreferredDimensionsSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnSurfaceStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnSurfaceStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnSurfaceStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnSurfaceStateChangedSignal> payload = ::boost::static_pointer_cast<OnSurfaceStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnSurfaceStateChangedCallbackIF*) _callback)->onOnSurfaceStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnError:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnErrorSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnError", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnErrorSignal> payload = ::boost::static_pointer_cast<OnErrorSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnErrorCallbackIF*) _callback)->onOnErrorSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnKeyEvent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnKeyEventSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnKeyEvent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnKeyEventSignal> payload = ::boost::static_pointer_cast<OnKeyEventSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnKeyEventCallbackIF*) _callback)->onOnKeyEventSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnCurrentStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnCurrentStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnCurrentStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnCurrentStatusSignal> payload = ::boost::static_pointer_cast<OnCurrentStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnCurrentStatusCallbackIF*) _callback)->onOnCurrentStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnCloseOnExternalTouch:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnCloseOnExternalTouchSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnCloseOnExternalTouch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnCloseOnExternalTouchSignal> payload = ::boost::static_pointer_cast<OnCloseOnExternalTouchSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnCloseOnExternalTouchCallbackIF*) _callback)->onOnCloseOnExternalTouchSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnLayerStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnLayerStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnLayerStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnLayerStateChangedSignal> payload = ::boost::static_pointer_cast<OnLayerStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnLayerStateChangedCallbackIF*) _callback)->onOnLayerStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionError> payload = ::boost::static_pointer_cast<VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VersionCallbackIF*) _callback)->onVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionUpdate> payload = ::boost::static_pointer_cast<VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VersionCallbackIF*) _callback)->onVersionUpdate(proxyShared, payload);
                        proxyShared->_version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_BuildInLayers:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BuildInLayersError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BuildInLayers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BuildInLayersError> payload = ::boost::static_pointer_cast<BuildInLayersError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((BuildInLayersCallbackIF*) _callback)->onBuildInLayersError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BuildInLayersUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BuildInLayers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BuildInLayersUpdate> payload = ::boost::static_pointer_cast<BuildInLayersUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((BuildInLayersCallbackIF*) _callback)->onBuildInLayersUpdate(proxyShared, payload);
                        proxyShared->_buildInLayers = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ClientTermination:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ClientTerminationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClientTermination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClientTerminationError> payload = ::boost::static_pointer_cast<ClientTerminationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClientTerminationCallbackIF*) _callback)->onClientTerminationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClientTerminationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ClientTermination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClientTerminationResponse> payload = ::boost::static_pointer_cast<ClientTerminationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ClientTerminationCallbackIF*) _callback)->onClientTerminationResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_OnGetDisplayId: {
                ::boost::shared_ptr< OnGetDisplayIdError > payload = ::boost::shared_ptr< OnGetDisplayIdError >
                (new OnGetDisplayIdError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnGetDisplayId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnGetDisplayIdCallbackIF*) _callback)->onOnGetDisplayIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnGetPreferredDimensions: {
                ::boost::shared_ptr< OnGetPreferredDimensionsError > payload = ::boost::shared_ptr< OnGetPreferredDimensionsError >
                (new OnGetPreferredDimensionsError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnGetPreferredDimensions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnGetPreferredDimensionsCallbackIF*) _callback)->onOnGetPreferredDimensionsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnSurfaceStateChanged: {
                ::boost::shared_ptr< OnSurfaceStateChangedError > payload = ::boost::shared_ptr< OnSurfaceStateChangedError >
                (new OnSurfaceStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnSurfaceStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnSurfaceStateChangedCallbackIF*) _callback)->onOnSurfaceStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnError: {
                ::boost::shared_ptr< OnErrorError > payload = ::boost::shared_ptr< OnErrorError >
                (new OnErrorError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnError", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnErrorCallbackIF*) _callback)->onOnErrorError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnKeyEvent: {
                ::boost::shared_ptr< OnKeyEventError > payload = ::boost::shared_ptr< OnKeyEventError >
                (new OnKeyEventError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnKeyEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnKeyEventCallbackIF*) _callback)->onOnKeyEventError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnCurrentStatus: {
                ::boost::shared_ptr< OnCurrentStatusError > payload = ::boost::shared_ptr< OnCurrentStatusError >
                (new OnCurrentStatusError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnCurrentStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnCurrentStatusCallbackIF*) _callback)->onOnCurrentStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnCloseOnExternalTouch: {
                ::boost::shared_ptr< OnCloseOnExternalTouchError > payload = ::boost::shared_ptr< OnCloseOnExternalTouchError >
                (new OnCloseOnExternalTouchError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnCloseOnExternalTouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnCloseOnExternalTouchCallbackIF*) _callback)->onOnCloseOnExternalTouchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnLayerStateChanged: {
                ::boost::shared_ptr< OnLayerStateChangedError > payload = ::boost::shared_ptr< OnLayerStateChangedError >
                (new OnLayerStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnLayerStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnLayerStateChangedCallbackIF*) _callback)->onOnLayerStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Version: {
                ::boost::shared_ptr< VersionError > payload = ::boost::shared_ptr< VersionError >
                (new VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VersionCallbackIF*) _callback)->onVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BuildInLayers: {
                ::boost::shared_ptr< BuildInLayersError > payload = ::boost::shared_ptr< BuildInLayersError >
                (new BuildInLayersError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BuildInLayers", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BuildInLayersCallbackIF*) _callback)->onBuildInLayersError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ClientTermination: {
                ::boost::shared_ptr< ClientTerminationError > payload = ::boost::shared_ptr< ClientTerminationError >
                (new ClientTerminationError(DBUS_ERROR_NO_SERVER, "The DBus service Service is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ClientTermination", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ServiceProxy> proxyShared = ::boost::static_pointer_cast<ServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClientTerminationCallbackIF*) _callback)->onClientTerminationError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ServiceProxyCallback::_logger (ServiceProxy::_logger);

ServiceProxy::ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.screenbroker.Service", serviceAvailable, _logger) {
}

ServiceProxy::~ServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ServiceProxy > ServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ServiceProxyCallback* callback = new ServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ServiceProxy::clearAllProperties ()
{
    _version = ::asf::core::nullable< VersionUpdate >();
    _buildInLayers = ::asf::core::nullable< BuildInLayersUpdate >();
}

void ServiceProxy::sendDeregisterAll () const
{
    sendOnGetDisplayIdDeregisterAll();
    sendOnGetPreferredDimensionsDeregisterAll();
    sendOnSurfaceStateChangedDeregisterAll();
    sendOnErrorDeregisterAll();
    sendOnKeyEventDeregisterAll();
    sendOnCurrentStatusDeregisterAll();
    sendOnCloseOnExternalTouchDeregisterAll();
    sendOnLayerStateChangedDeregisterAll();
}

act_t ServiceProxy::sendOnGetDisplayIdRegister(OnGetDisplayIdCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnGetDisplayId");
    act_t act = addSignalCallback(ID_OnGetDisplayId, "OnGetDisplayId", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnGetDisplayId", &cb, act);
    return act;
}

bool ServiceProxy::sendOnGetDisplayIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnGetDisplayId", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnGetDisplayId", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnGetDisplayIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnGetDisplayId");
    _dbusProxyDelegate->deregisterSignalCallback("OnGetDisplayId", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnGetPreferredDimensionsRegister(OnGetPreferredDimensionsCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnGetPreferredDimensions");
    act_t act = addSignalCallback(ID_OnGetPreferredDimensions, "OnGetPreferredDimensions", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnGetPreferredDimensions", &cb, act);
    return act;
}

bool ServiceProxy::sendOnGetPreferredDimensionsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnGetPreferredDimensions", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnGetPreferredDimensions", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnGetPreferredDimensionsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnGetPreferredDimensions");
    _dbusProxyDelegate->deregisterSignalCallback("OnGetPreferredDimensions", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnSurfaceStateChangedRegister(OnSurfaceStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnSurfaceStateChanged");
    act_t act = addSignalCallback(ID_OnSurfaceStateChanged, "OnSurfaceStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnSurfaceStateChanged", &cb, act);
    return act;
}

bool ServiceProxy::sendOnSurfaceStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnSurfaceStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnSurfaceStateChanged", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnSurfaceStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnSurfaceStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("OnSurfaceStateChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnErrorRegister(OnErrorCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnError");
    act_t act = addSignalCallback(ID_OnError, "OnError", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnError", &cb, act);
    return act;
}

bool ServiceProxy::sendOnErrorDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnError", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnError", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnErrorDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnError");
    _dbusProxyDelegate->deregisterSignalCallback("OnError", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnKeyEventRegister(OnKeyEventCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnKeyEvent");
    act_t act = addSignalCallback(ID_OnKeyEvent, "OnKeyEvent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnKeyEvent", &cb, act);
    return act;
}

bool ServiceProxy::sendOnKeyEventDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnKeyEvent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnKeyEvent", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnKeyEventDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnKeyEvent");
    _dbusProxyDelegate->deregisterSignalCallback("OnKeyEvent", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnCurrentStatusRegister(OnCurrentStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnCurrentStatus");
    act_t act = addSignalCallback(ID_OnCurrentStatus, "OnCurrentStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnCurrentStatus", &cb, act);
    return act;
}

bool ServiceProxy::sendOnCurrentStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnCurrentStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnCurrentStatus", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnCurrentStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnCurrentStatus");
    _dbusProxyDelegate->deregisterSignalCallback("OnCurrentStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnCloseOnExternalTouchRegister(OnCloseOnExternalTouchCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnCloseOnExternalTouch");
    act_t act = addSignalCallback(ID_OnCloseOnExternalTouch, "OnCloseOnExternalTouch", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnCloseOnExternalTouch", &cb, act);
    return act;
}

bool ServiceProxy::sendOnCloseOnExternalTouchDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnCloseOnExternalTouch", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnCloseOnExternalTouch", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnCloseOnExternalTouchDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnCloseOnExternalTouch");
    _dbusProxyDelegate->deregisterSignalCallback("OnCloseOnExternalTouch", 0, _dbusDaemonProxy.get(), false);
}

act_t ServiceProxy::sendOnLayerStateChangedRegister(OnLayerStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnLayerStateChanged");
    act_t act = addSignalCallback(ID_OnLayerStateChanged, "OnLayerStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnLayerStateChanged", &cb, act);
    return act;
}

bool ServiceProxy::sendOnLayerStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnLayerStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnLayerStateChanged", act, static_cast<int>(rv));
    return rv;
}

void ServiceProxy::sendOnLayerStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnLayerStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("OnLayerStateChanged", 0, _dbusDaemonProxy.get(), false);
}


act_t ServiceProxy::sendVersionGet(VersionCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ServiceProxy::getVersion() const {
    return _version.get().getVersion();
}

bool ServiceProxy::hasVersion() const {
    return _version.hasValue();
}



act_t ServiceProxy::sendBuildInLayersGet(BuildInLayersCallbackIF& cb) {
    ServiceProxyCallback* callback = new ServiceProxyCallback(ID_BuildInLayers, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "BuildInLayers", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("BuildInLayers", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >& ServiceProxy::getBuildInLayers() const {
    return _buildInLayers.get().getBuildInLayers();
}

bool ServiceProxy::hasBuildInLayers() const {
    return _buildInLayers.hasValue();
}


act_t ServiceProxy::sendClientTerminationRequest(ClientTerminationCallbackIF& cb, const ::std::string& clientId) const {
    ClientTerminationRequest* payload = new ClientTerminationRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    DBUS_MESSAGE_CALL(dbusMessage, "ClientTermination", ClientTerminationRequest, payload, true)
    act_t act = addMethodCallback(ID_ClientTermination, dbusMessage.getUniqueSerial(), "ClientTermination", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ClientTermination", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ServiceProxy::sendGetDisplayIdRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId) const {
    GetDisplayIdRequest* payload = new GetDisplayIdRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setScreenAreaId(screenAreaId);
    DBUS_MESSAGE_CALL(dbusMessage, "GetDisplayId", GetDisplayIdRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "GetDisplayId");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendGetPreferredDimensionsRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId) const {
    GetPreferredDimensionsRequest* payload = new GetPreferredDimensionsRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setScreenAreaId(screenAreaId);
    DBUS_MESSAGE_CALL(dbusMessage, "GetPreferredDimensions", GetPreferredDimensionsRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "GetPreferredDimensions");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendRegisterSurfaceRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 screenAreaId, uint32 surfaceId) const {
    RegisterSurfaceRequest* payload = new RegisterSurfaceRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setScreenAreaId(screenAreaId);
    payload->setSurfaceId(surfaceId);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterSurface", RegisterSurfaceRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RegisterSurface");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendDeregisterSurfaceRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, bool sendToIlm) const {
    DeregisterSurfaceRequest* payload = new DeregisterSurfaceRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setSurfaceId(surfaceId);
    payload->setSendToIlm(sendToIlm);
    DBUS_MESSAGE_CALL(dbusMessage, "DeregisterSurface", DeregisterSurfaceRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "DeregisterSurface");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendActivateApplicationRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, uint32 entryCustomAnimationType, uint32 exitCustomAnimationType) const {
    ActivateApplicationRequest* payload = new ActivateApplicationRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setSurfaceId(surfaceId);
    payload->setEntryCustomAnimationType(entryCustomAnimationType);
    payload->setExitCustomAnimationType(exitCustomAnimationType);
    DBUS_MESSAGE_CALL(dbusMessage, "ActivateApplication", ActivateApplicationRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ActivateApplication");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendStartAnimationRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, uint32 animationType, uint32 hint) const {
    StartAnimationRequest* payload = new StartAnimationRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setSurfaceId(surfaceId);
    payload->setAnimationType(animationType);
    payload->setHint(hint);
    DBUS_MESSAGE_CALL(dbusMessage, "StartAnimation", StartAnimationRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "StartAnimation");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendAttachandAnimateLayerRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 layerID, const ::std::vector< uint32 >& surfaceID, uint32 animationType, uint32 hint) const {
    AttachandAnimateLayerRequest* payload = new AttachandAnimateLayerRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setLayerID(layerID);
    payload->setSurfaceID(surfaceID);
    payload->setAnimationType(animationType);
    payload->setHint(hint);
    DBUS_MESSAGE_CALL(dbusMessage, "AttachandAnimateLayer", AttachandAnimateLayerRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "AttachandAnimateLayer");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendShowPopupRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg) const {
    ShowPopupRequest* payload = new ShowPopupRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setSurfaceId(surfaceId);
    payload->setPopupPresentationArg(popupPresentationArg);
    DBUS_MESSAGE_CALL(dbusMessage, "ShowPopup", ShowPopupRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ShowPopup");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendHidePopupRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, uint32 surfaceId) const {
    HidePopupRequest* payload = new HidePopupRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setSurfaceId(surfaceId);
    DBUS_MESSAGE_CALL(dbusMessage, "HidePopup", HidePopupRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "HidePopup");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendCloseOnExternalTouchRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg) const {
    CloseOnExternalTouchRequest* payload = new CloseOnExternalTouchRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    DBUS_MESSAGE_CALL(dbusMessage, "CloseOnExternalTouch", CloseOnExternalTouchRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "CloseOnExternalTouch");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendSetPopupFilterRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg, bool disableAll, const ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg& popupPresentationArg) const {
    SetPopupFilterRequest* payload = new SetPopupFilterRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    payload->setDisableAll(disableAll);
    payload->setPopupPresentationArg(popupPresentationArg);
    DBUS_MESSAGE_CALL(dbusMessage, "SetPopupFilter", SetPopupFilterRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "SetPopupFilter");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendClearPopupFilterRequest(const ::std::string& clientId, const ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg& requestArg) const {
    ClearPopupFilterRequest* payload = new ClearPopupFilterRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestArg(requestArg);
    DBUS_MESSAGE_CALL(dbusMessage, "ClearPopupFilter", ClearPopupFilterRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ClearPopupFilter");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendKeyFeedbackRequest(const ::std::string& clientId, uint32 userData, uint32 keyCode, ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState, bool consumed) const {
    KeyFeedbackRequest* payload = new KeyFeedbackRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setUserData(userData);
    payload->setKeyCode(keyCode);
    payload->setKeyState(keyState);
    payload->setConsumed(consumed);
    DBUS_MESSAGE_CALL(dbusMessage, "KeyFeedback", KeyFeedbackRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "KeyFeedback");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendActionRequest(const ::std::string& clientId, uint32 actionId, uint32 actionData) const {
    ActionRequest* payload = new ActionRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setActionId(actionId);
    payload->setActionData(actionData);
    DBUS_MESSAGE_CALL(dbusMessage, "Action", ActionRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "Action");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendSetInputFocusRequest(const ::std::string& clientId, uint32 surfaceId, bool keyboardFocus, bool pointerFocus, int32 priority, uint32 focusData) const {
    SetInputFocusRequest* payload = new SetInputFocusRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setSurfaceId(surfaceId);
    payload->setKeyboardFocus(keyboardFocus);
    payload->setPointerFocus(pointerFocus);
    payload->setPriority(priority);
    payload->setFocusData(focusData);
    DBUS_MESSAGE_CALL(dbusMessage, "SetInputFocus", SetInputFocusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "SetInputFocus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

act_t ServiceProxy::sendRequestCurrentStatusRequest(const ::std::string& clientId, uint32 requestId) const {
    RequestCurrentStatusRequest* payload = new RequestCurrentStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setClientId(clientId);
    payload->setRequestId(requestId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestCurrentStatus", RequestCurrentStatusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "RequestCurrentStatus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace Service
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
