/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/ArgumentsDBus.h"
#include "bosch/cm/ai/hmi/screenbroker/Service.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of ClientTerminationRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest& in, DBusMessageIter* out) {
    const char* o0 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o0));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o1 = 0;
            dbus_message_iter_get_basic(in, &o1);
            clientIdTmpValue.assign (o1);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ClientTerminationResponse

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationResponse& in, DBusMessageIter* out) {
    dbus_bool_t o2 = in.getSuccess() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o2));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationResponse& out) {
    {
        bool successValue;
        bool &successTmpValue = successValue;
        {
            dbus_bool_t o3;
            dbus_message_iter_get_basic(in, &o3);
            successTmpValue = o3 ? true : false;
        }
        out.setSuccess(successValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetDisplayIdRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest& in, DBusMessageIter* out) {
    const char* o4 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o4));
    serializeDBus(in.getRequestArg(), out);
    uint32 o5 = in.getScreenAreaId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o5));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o6 = 0;
            dbus_message_iter_get_basic(in, &o6);
            clientIdTmpValue.assign (o6);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 screenAreaIdValue;
        uint32 &screenAreaIdTmpValue = screenAreaIdValue;
        dbus_message_iter_get_basic(in, &screenAreaIdTmpValue);
        out.setScreenAreaId(screenAreaIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetPreferredDimensionsRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest& in, DBusMessageIter* out) {
    const char* o7 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o7));
    serializeDBus(in.getRequestArg(), out);
    uint32 o8 = in.getScreenAreaId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o8));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            clientIdTmpValue.assign (o9);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 screenAreaIdValue;
        uint32 &screenAreaIdTmpValue = screenAreaIdValue;
        dbus_message_iter_get_basic(in, &screenAreaIdTmpValue);
        out.setScreenAreaId(screenAreaIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegisterSurfaceRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest& in, DBusMessageIter* out) {
    const char* o10 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o10));
    serializeDBus(in.getRequestArg(), out);
    uint32 o11 = in.getScreenAreaId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o11));
    uint32 o12 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o12));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o13 = 0;
            dbus_message_iter_get_basic(in, &o13);
            clientIdTmpValue.assign (o13);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 screenAreaIdValue;
        uint32 &screenAreaIdTmpValue = screenAreaIdValue;
        dbus_message_iter_get_basic(in, &screenAreaIdTmpValue);
        out.setScreenAreaId(screenAreaIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeregisterSurfaceRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest& in, DBusMessageIter* out) {
    const char* o14 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o14));
    serializeDBus(in.getRequestArg(), out);
    uint32 o15 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o15));
    dbus_bool_t o16 = in.getSendToIlm() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o16));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o17 = 0;
            dbus_message_iter_get_basic(in, &o17);
            clientIdTmpValue.assign (o17);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool sendToIlmValue;
        bool &sendToIlmTmpValue = sendToIlmValue;
        {
            dbus_bool_t o18;
            dbus_message_iter_get_basic(in, &o18);
            sendToIlmTmpValue = o18 ? true : false;
        }
        out.setSendToIlm(sendToIlmValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActivateApplicationRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest& in, DBusMessageIter* out) {
    const char* o19 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o19));
    serializeDBus(in.getRequestArg(), out);
    uint32 o20 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o20));
    uint32 o21 = in.getEntryCustomAnimationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o21));
    uint32 o22 = in.getExitCustomAnimationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o22));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o23 = 0;
            dbus_message_iter_get_basic(in, &o23);
            clientIdTmpValue.assign (o23);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 entryCustomAnimationTypeValue;
        uint32 &entryCustomAnimationTypeTmpValue = entryCustomAnimationTypeValue;
        dbus_message_iter_get_basic(in, &entryCustomAnimationTypeTmpValue);
        out.setEntryCustomAnimationType(entryCustomAnimationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 exitCustomAnimationTypeValue;
        uint32 &exitCustomAnimationTypeTmpValue = exitCustomAnimationTypeValue;
        dbus_message_iter_get_basic(in, &exitCustomAnimationTypeTmpValue);
        out.setExitCustomAnimationType(exitCustomAnimationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartAnimationRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest& in, DBusMessageIter* out) {
    const char* o24 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o24));
    serializeDBus(in.getRequestArg(), out);
    uint32 o25 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o25));
    uint32 o26 = in.getAnimationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o26));
    uint32 o27 = in.getHint();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o27));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o28 = 0;
            dbus_message_iter_get_basic(in, &o28);
            clientIdTmpValue.assign (o28);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 animationTypeValue;
        uint32 &animationTypeTmpValue = animationTypeValue;
        dbus_message_iter_get_basic(in, &animationTypeTmpValue);
        out.setAnimationType(animationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 hintValue;
        uint32 &hintTmpValue = hintValue;
        dbus_message_iter_get_basic(in, &hintTmpValue);
        out.setHint(hintValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of AttachandAnimateLayerRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest& in, DBusMessageIter* out) {
    const char* o29 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o29));
    serializeDBus(in.getRequestArg(), out);
    uint32 o30 = in.getLayerID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o30));
    DBusMessageIter o31ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o31ArrayIter));
    const ::std::vector< uint32 >* o32 = &in.getSurfaceID();
    ::std::vector< uint32 >::const_iterator o33 = o32->end();
    for (::std::vector< uint32 >::const_iterator o34 = o32->begin(); o34 != o33; ++o34) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o31ArrayIter, DBUS_TYPE_UINT32, &(*o34)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o31ArrayIter));
    uint32 o35 = in.getAnimationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o35));
    uint32 o36 = in.getHint();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o36));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o37 = 0;
            dbus_message_iter_get_basic(in, &o37);
            clientIdTmpValue.assign (o37);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 layerIDValue;
        uint32 &layerIDTmpValue = layerIDValue;
        dbus_message_iter_get_basic(in, &layerIDTmpValue);
        out.setLayerID(layerIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > surfaceIDValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o38ArrayIter;
            dbus_message_iter_recurse (in, &o38ArrayIter);

            if(dbus_message_iter_get_arg_type(&o38ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o39;
                    dbus_message_iter_get_basic(&o38ArrayIter, &o39);
                    surfaceIDValue.push_back(o39);
                } while (dbus_message_iter_next(&o38ArrayIter));
            }
        }
        out.setSurfaceID(surfaceIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 animationTypeValue;
        uint32 &animationTypeTmpValue = animationTypeValue;
        dbus_message_iter_get_basic(in, &animationTypeTmpValue);
        out.setAnimationType(animationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 hintValue;
        uint32 &hintTmpValue = hintValue;
        dbus_message_iter_get_basic(in, &hintTmpValue);
        out.setHint(hintValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowPopupRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest& in, DBusMessageIter* out) {
    const char* o40 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o40));
    serializeDBus(in.getRequestArg(), out);
    uint32 o41 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o41));
    serializeDBus(in.getPopupPresentationArg(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o42 = 0;
            dbus_message_iter_get_basic(in, &o42);
            clientIdTmpValue.assign (o42);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg popupPresentationArgValue;
        if (!deserializeDBus(in, popupPresentationArgValue)) {
            return false;
        }
        out.setPopupPresentationArg(popupPresentationArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HidePopupRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest& in, DBusMessageIter* out) {
    const char* o43 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o43));
    serializeDBus(in.getRequestArg(), out);
    uint32 o44 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o44));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o45 = 0;
            dbus_message_iter_get_basic(in, &o45);
            clientIdTmpValue.assign (o45);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CloseOnExternalTouchRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest& in, DBusMessageIter* out) {
    const char* o46 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o46));
    serializeDBus(in.getRequestArg(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o47 = 0;
            dbus_message_iter_get_basic(in, &o47);
            clientIdTmpValue.assign (o47);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetPopupFilterRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest& in, DBusMessageIter* out) {
    const char* o48 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o48));
    serializeDBus(in.getRequestArg(), out);
    dbus_bool_t o49 = in.getDisableAll() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o49));
    serializeDBus(in.getPopupPresentationArg(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o50 = 0;
            dbus_message_iter_get_basic(in, &o50);
            clientIdTmpValue.assign (o50);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool disableAllValue;
        bool &disableAllTmpValue = disableAllValue;
        {
            dbus_bool_t o51;
            dbus_message_iter_get_basic(in, &o51);
            disableAllTmpValue = o51 ? true : false;
        }
        out.setDisableAll(disableAllValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg popupPresentationArgValue;
        if (!deserializeDBus(in, popupPresentationArgValue)) {
            return false;
        }
        out.setPopupPresentationArg(popupPresentationArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ClearPopupFilterRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest& in, DBusMessageIter* out) {
    const char* o52 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o52));
    serializeDBus(in.getRequestArg(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o53 = 0;
            dbus_message_iter_get_basic(in, &o53);
            clientIdTmpValue.assign (o53);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of KeyFeedbackRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest& in, DBusMessageIter* out) {
    const char* o54 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o54));
    uint32 o55 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o55));
    uint32 o56 = in.getKeyCode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o56));
    const ::bosch::cm::ai::hmi::screenbroker::Types::KeyState  o57 = in.getKeyState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o57));
    dbus_bool_t o58 = in.getConsumed() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o58));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o59 = 0;
            dbus_message_iter_get_basic(in, &o59);
            clientIdTmpValue.assign (o59);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 keyCodeValue;
        uint32 &keyCodeTmpValue = keyCodeValue;
        dbus_message_iter_get_basic(in, &keyCodeTmpValue);
        out.setKeyCode(keyCodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyStateValue = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release;
        dbus_message_iter_get_basic(in, &keyStateValue);
        out.setKeyState(keyStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool consumedValue;
        bool &consumedTmpValue = consumedValue;
        {
            dbus_bool_t o60;
            dbus_message_iter_get_basic(in, &o60);
            consumedTmpValue = o60 ? true : false;
        }
        out.setConsumed(consumedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ActionRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::ActionRequest& in, DBusMessageIter* out) {
    const char* o61 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o61));
    uint32 o62 = in.getActionId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o62));
    uint32 o63 = in.getActionData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o63));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::ActionRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o64 = 0;
            dbus_message_iter_get_basic(in, &o64);
            clientIdTmpValue.assign (o64);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 actionIdValue;
        uint32 &actionIdTmpValue = actionIdValue;
        dbus_message_iter_get_basic(in, &actionIdTmpValue);
        out.setActionId(actionIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 actionDataValue;
        uint32 &actionDataTmpValue = actionDataValue;
        dbus_message_iter_get_basic(in, &actionDataTmpValue);
        out.setActionData(actionDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetInputFocusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest& in, DBusMessageIter* out) {
    const char* o65 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o65));
    uint32 o66 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o66));
    dbus_bool_t o67 = in.getKeyboardFocus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o67));
    dbus_bool_t o68 = in.getPointerFocus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o68));
    int32 o69 = in.getPriority();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o69));
    uint32 o70 = in.getFocusData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o70));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o71 = 0;
            dbus_message_iter_get_basic(in, &o71);
            clientIdTmpValue.assign (o71);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool keyboardFocusValue;
        bool &keyboardFocusTmpValue = keyboardFocusValue;
        {
            dbus_bool_t o72;
            dbus_message_iter_get_basic(in, &o72);
            keyboardFocusTmpValue = o72 ? true : false;
        }
        out.setKeyboardFocus(keyboardFocusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool pointerFocusValue;
        bool &pointerFocusTmpValue = pointerFocusValue;
        {
            dbus_bool_t o73;
            dbus_message_iter_get_basic(in, &o73);
            pointerFocusTmpValue = o73 ? true : false;
        }
        out.setPointerFocus(pointerFocusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 priorityValue;
        int32 &priorityTmpValue = priorityValue;
        dbus_message_iter_get_basic(in, &priorityTmpValue);
        out.setPriority(priorityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 focusDataValue;
        uint32 &focusDataTmpValue = focusDataValue;
        dbus_message_iter_get_basic(in, &focusDataTmpValue);
        out.setFocusData(focusDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestCurrentStatusRequest

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest& in, DBusMessageIter* out) {
    const char* o74 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o74));
    uint32 o75 = in.getRequestId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o75));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o76 = 0;
            dbus_message_iter_get_basic(in, &o76);
            clientIdTmpValue.assign (o76);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 requestIdValue;
        uint32 &requestIdTmpValue = requestIdValue;
        dbus_message_iter_get_basic(in, &requestIdTmpValue);
        out.setRequestId(requestIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VersionUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate& in, DBusMessageIter* out) {
    const char* o77 = in.getVersion().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o77));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate& out) {
    {
        ::std::string VersionValue;
        ::std::string &VersionTmpValue = VersionValue;
        {
            char* o78 = 0;
            dbus_message_iter_get_basic(in, &o78);
            VersionTmpValue.assign (o78);
        }
        out.setVersion(VersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of VersionRegister

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::VersionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::screenbroker::Service::VersionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BuildInLayersUpdate

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o79ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uuus(uu))", &o79ArrayIter));
    const ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >* o80 = &in.getBuildInLayers();
    ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >::const_iterator o81 = o80->end();
    for (::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo >::const_iterator o82 = o80->begin(); o82 != o81; ++o82) {
        serializeDBus((*o82), &o79ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o79ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate& out) {
    {
        ::std::vector< ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo > BuildInLayersValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o83ArrayIter;
            dbus_message_iter_recurse (in, &o83ArrayIter);

            if(dbus_message_iter_get_arg_type(&o83ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::bosch::cm::ai::hmi::screenbroker::Arguments::BuildInLayerInfo o84;
                    if (!deserializeDBus(&o83ArrayIter, o84)) {
                        return false;
                    }
                    BuildInLayersValue.push_back(o84);
                } while (dbus_message_iter_next(&o83ArrayIter));
            }
        }
        out.setBuildInLayers(BuildInLayersValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BuildInLayersRegister

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of OnGetDisplayIdSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal& in, DBusMessageIter* out) {
    const char* o85 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o85));
    serializeDBus(in.getRequestArg(), out);
    uint32 o86 = in.getDisplayId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o87 = 0;
            dbus_message_iter_get_basic(in, &o87);
            clientIdTmpValue.assign (o87);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 displayIdValue;
        uint32 &displayIdTmpValue = displayIdValue;
        dbus_message_iter_get_basic(in, &displayIdTmpValue);
        out.setDisplayId(displayIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnGetPreferredDimensionsSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal& in, DBusMessageIter* out) {
    const char* o88 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o88));
    serializeDBus(in.getRequestArg(), out);
    serializeDBus(in.getDimensionArg(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o89 = 0;
            dbus_message_iter_get_basic(in, &o89);
            clientIdTmpValue.assign (o89);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::DimensionArg dimensionArgValue;
        if (!deserializeDBus(in, dimensionArgValue)) {
            return false;
        }
        out.setDimensionArg(dimensionArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnSurfaceStateChangedSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal& in, DBusMessageIter* out) {
    const char* o90 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o90));
    uint32 o91 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o91));
    uint32 o92 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o92));
    uint32 o93 = in.getDisplayId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o93));
    uint32 o94 = in.getDisplayAlias();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o94));
    const ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState  o95 = in.getSurfaceState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o96 = 0;
            dbus_message_iter_get_basic(in, &o96);
            clientIdTmpValue.assign (o96);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 displayIdValue;
        uint32 &displayIdTmpValue = displayIdValue;
        dbus_message_iter_get_basic(in, &displayIdTmpValue);
        out.setDisplayId(displayIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 displayAliasValue;
        uint32 &displayAliasTmpValue = displayAliasValue;
        dbus_message_iter_get_basic(in, &displayAliasTmpValue);
        out.setDisplayAlias(displayAliasValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState surfaceStateValue = ::bosch::cm::ai::hmi::screenbroker::Types::SurfaceState__Registered;
        dbus_message_iter_get_basic(in, &surfaceStateValue);
        out.setSurfaceState(surfaceStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnErrorSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal& in, DBusMessageIter* out) {
    const char* o97 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o97));
    serializeDBus(in.getRequestArg(), out);
    int32 o98 = in.getSystemErrno();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o98));
    int32 o99 = in.getPresentationErrno();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o99));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o100 = 0;
            dbus_message_iter_get_basic(in, &o100);
            clientIdTmpValue.assign (o100);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArgValue;
        if (!deserializeDBus(in, requestArgValue)) {
            return false;
        }
        out.setRequestArg(requestArgValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 systemErrnoValue;
        int32 &systemErrnoTmpValue = systemErrnoValue;
        dbus_message_iter_get_basic(in, &systemErrnoTmpValue);
        out.setSystemErrno(systemErrnoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 presentationErrnoValue;
        int32 &presentationErrnoTmpValue = presentationErrnoValue;
        dbus_message_iter_get_basic(in, &presentationErrnoTmpValue);
        out.setPresentationErrno(presentationErrnoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnKeyEventSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal& in, DBusMessageIter* out) {
    const char* o101 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o101));
    uint32 o102 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o102));
    uint32 o103 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o103));
    uint32 o104 = in.getKeyCode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o104));
    const ::bosch::cm::ai::hmi::screenbroker::Types::KeyState  o105 = in.getKeyState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o105));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o106 = 0;
            dbus_message_iter_get_basic(in, &o106);
            clientIdTmpValue.assign (o106);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 keyCodeValue;
        uint32 &keyCodeTmpValue = keyCodeValue;
        dbus_message_iter_get_basic(in, &keyCodeTmpValue);
        out.setKeyCode(keyCodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Types::KeyState keyStateValue = ::bosch::cm::ai::hmi::screenbroker::Types::KeyState__Release;
        dbus_message_iter_get_basic(in, &keyStateValue);
        out.setKeyState(keyStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnCurrentStatusSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal& in, DBusMessageIter* out) {
    const char* o107 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o107));
    uint32 o108 = in.getRequestId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o108));
    uint32 o109 = in.getSurfaceId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o109));
    uint32 o110 = in.getStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o110));
    uint32 o111 = in.getUserData();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o111));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o112 = 0;
            dbus_message_iter_get_basic(in, &o112);
            clientIdTmpValue.assign (o112);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 requestIdValue;
        uint32 &requestIdTmpValue = requestIdValue;
        dbus_message_iter_get_basic(in, &requestIdTmpValue);
        out.setRequestId(requestIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 surfaceIdValue;
        uint32 &surfaceIdTmpValue = surfaceIdValue;
        dbus_message_iter_get_basic(in, &surfaceIdTmpValue);
        out.setSurfaceId(surfaceIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 statusValue;
        uint32 &statusTmpValue = statusValue;
        dbus_message_iter_get_basic(in, &statusTmpValue);
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 userDataValue;
        uint32 &userDataTmpValue = userDataValue;
        dbus_message_iter_get_basic(in, &userDataTmpValue);
        out.setUserData(userDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnCloseOnExternalTouchSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal& in, DBusMessageIter* out) {
    dbus_bool_t o113 = in.getStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o113));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal& out) {
    {
        bool statusValue;
        bool &statusTmpValue = statusValue;
        {
            dbus_bool_t o114;
            dbus_message_iter_get_basic(in, &o114);
            statusTmpValue = o114 ? true : false;
        }
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OnLayerStateChangedSignal

void serializeDBus (const ::bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal& in, DBusMessageIter* out) {
    const char* o115 = in.getClientId().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o115));
    uint32 o116 = in.getRequestId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o116));
    uint32 o117 = in.getLayerID();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o117));
    const ::bosch::cm::ai::hmi::screenbroker::Types::LayerState  o118 = in.getLayerState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o118));
}

bool deserializeDBus (DBusMessageIter* in, ::bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal& out) {
    {
        ::std::string clientIdValue;
        ::std::string &clientIdTmpValue = clientIdValue;
        {
            char* o119 = 0;
            dbus_message_iter_get_basic(in, &o119);
            clientIdTmpValue.assign (o119);
        }
        out.setClientId(clientIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 requestIdValue;
        uint32 &requestIdTmpValue = requestIdValue;
        dbus_message_iter_get_basic(in, &requestIdTmpValue);
        out.setRequestId(requestIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 layerIDValue;
        uint32 &layerIDTmpValue = layerIDValue;
        dbus_message_iter_get_basic(in, &layerIDTmpValue);
        out.setLayerID(layerIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::bosch::cm::ai::hmi::screenbroker::Types::LayerState layerStateValue = ::bosch::cm::ai::hmi::screenbroker::Types::LayerState__Created;
        dbus_message_iter_get_basic(in, &layerStateValue);
        out.setLayerState(layerStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

