#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_SCREENBROKER_ARGUMENTS_H
#define BOSCH_CM_AI_HMI_SCREENBROKER_ARGUMENTS_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Arguments" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace screenbroker {
namespace Arguments {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RequestArg;

class DimensionArg;

class PopupPresentationArg;

class BuildInLayerInfo;


/**
 * This class encapsulates standard arguments for ScreenBroker requests.
 */
class RequestArg {
public:

    /**
     * Default constructor
     */
    inline  RequestArg ();

    /**
     * Copy constructor
     */
    inline  RequestArg (const RequestArg &rhs);

    /**
     * All fields constructor
     */
    inline  RequestArg (uint32 requestId_, uint32 appId_, uint32 userData_);

    /**
     * Destructor
     */
    inline  ~RequestArg();

    /**
     * Assignment operator
     */
    inline RequestArg& operator = (const RequestArg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestArg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestArg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestArg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestArg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "requestId"

    static const int kRequestId = 0;

    /**
     * Clears the field "requestId".
     *
     * The field will be set to its default value. The hasRequestId()
     * method will return false.
     */
    inline void clearRequestId();

    /**
     * Checks whether the field "requestId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRequestId()). Otherwise it will return false.
     */
    inline bool hasRequestId () const;

    /**
     * Returns the value of the member "requestId".
     *
     * The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.
     *
     * @return The value of the field "requestId"
     */
    inline uint32 getRequestId () const;

    /**
     * Sets the value of the member "requestId".
     *
     * The application specific ID of the request. If a corresponding response is sent back, the request ID of the response matches this argument, otherwise it may be used to transport details of the requests nature.
     *
     * @param requestId The value which will be set
     */
    inline void setRequestId (uint32 requestId_);

    // API of field "appId"

    static const int kAppId = 1;

    /**
     * Clears the field "appId".
     *
     * The field will be set to its default value. The hasAppId()
     * method will return false.
     */
    inline void clearAppId();

    /**
     * Checks whether the field "appId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppId()). Otherwise it will return false.
     */
    inline bool hasAppId () const;

    /**
     * Returns the value of the member "appId".
     *
     * The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @return The value of the field "appId"
     */
    inline uint32 getAppId () const;

    /**
     * Sets the value of the member "appId".
     *
     * The application specific ID. This ID is intended to identify the application at project specific plug-ins. It is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @param appId The value which will be set
     */
    inline void setAppId (uint32 appId_);

    // API of field "userData"

    static const int kUserData = 2;

    /**
     * Clears the field "userData".
     *
     * The field will be set to its default value. The hasUserData()
     * method will return false.
     */
    inline void clearUserData();

    /**
     * Checks whether the field "userData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserData()). Otherwise it will return false.
     */
    inline bool hasUserData () const;

    /**
     * Returns the value of the member "userData".
     *
     * The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @return The value of the field "userData"
     */
    inline uint32 getUserData () const;

    /**
     * Sets the value of the member "userData".
     *
     * The application specific data intended for extra tagging or hinting for request processing by project specific plug-ins. This value is neither processed nor modified within generic ScreenBroker implementation.
     *
     * @param userData The value which will be set
     */
    inline void setUserData (uint32 userData_);

    static const RequestArg &getDefaultInstance();

private:

    inline void set_has_requestId ();

    inline void clear_has_requestId ();

    inline void set_has_appId ();

    inline void clear_has_appId ();

    inline void set_has_userData ();

    inline void clear_has_userData ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _requestId;

    uint32 _appId;

    uint32 _userData;

};

/**
 * This class encapsulates arguments for ScreenBroker responses providing dimensions.
 */
class DimensionArg {
public:

    /**
     * Default constructor
     */
    inline  DimensionArg ();

    /**
     * Copy constructor
     */
    inline  DimensionArg (const DimensionArg &rhs);

    /**
     * All fields constructor
     */
    inline  DimensionArg (uint32 width_, uint32 height_);

    /**
     * Destructor
     */
    inline  ~DimensionArg();

    /**
     * Assignment operator
     */
    inline DimensionArg& operator = (const DimensionArg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimensionArg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimensionArg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimensionArg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimensionArg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "width"

    static const int kWidth = 0;

    /**
     * Clears the field "width".
     *
     * The field will be set to its default value. The hasWidth()
     * method will return false.
     */
    inline void clearWidth();

    /**
     * Checks whether the field "width" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWidth()). Otherwise it will return false.
     */
    inline bool hasWidth () const;

    /**
     * Returns the value of the member "width".
     *
     * The horizontal dimension value.
     *
     * @return The value of the field "width"
     */
    inline uint32 getWidth () const;

    /**
     * Sets the value of the member "width".
     *
     * The horizontal dimension value.
     *
     * @param width The value which will be set
     */
    inline void setWidth (uint32 width_);

    // API of field "height"

    static const int kHeight = 1;

    /**
     * Clears the field "height".
     *
     * The field will be set to its default value. The hasHeight()
     * method will return false.
     */
    inline void clearHeight();

    /**
     * Checks whether the field "height" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHeight()). Otherwise it will return false.
     */
    inline bool hasHeight () const;

    /**
     * Returns the value of the member "height".
     *
     * The vertical dimension value.
     *
     * @return The value of the field "height"
     */
    inline uint32 getHeight () const;

    /**
     * Sets the value of the member "height".
     *
     * The vertical dimension value.
     *
     * @param height The value which will be set
     */
    inline void setHeight (uint32 height_);

    static const DimensionArg &getDefaultInstance();

private:

    inline void set_has_width ();

    inline void clear_has_width ();

    inline void set_has_height ();

    inline void clear_has_height ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _width;

    uint32 _height;

};

/**
 * This class encapsulates arguments for ScreenBroker requests involving presesntation arguments for pop-up overlays.
 */
class PopupPresentationArg {
public:

    /**
     * Default constructor
     */
    inline  PopupPresentationArg ();

    /**
     * Copy constructor
     */
    inline  PopupPresentationArg (const PopupPresentationArg &rhs);

    /**
     * All fields constructor
     */
    inline  PopupPresentationArg (uint32 priority_, ::bosch::cm::ai::hmi::screenbroker::Types::Modality modality_, uint32 presentationTime_, uint32 minimumPresentationTime_, uint32 validityPeriod_, ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment horizontalAlignment_, ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment verticalAlignment_, ::bosch::cm::ai::hmi::screenbroker::Types::Scaling scaling_, int32 focusPriority_);

    /**
     * Destructor
     */
    inline  ~PopupPresentationArg();

    /**
     * Assignment operator
     */
    inline PopupPresentationArg& operator = (const PopupPresentationArg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PopupPresentationArg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PopupPresentationArg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PopupPresentationArg& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PopupPresentationArg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "priority"

    static const int kPriority = 0;

    /**
     * Clears the field "priority".
     *
     * The field will be set to its default value. The hasPriority()
     * method will return false.
     */
    inline void clearPriority();

    /**
     * Checks whether the field "priority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPriority()). Otherwise it will return false.
     */
    inline bool hasPriority () const;

    /**
     * Returns the value of the member "priority".
     *
     * The priority of the pop-up.
     *
     * @return The value of the field "priority"
     */
    inline uint32 getPriority () const;

    /**
     * Sets the value of the member "priority".
     *
     * The priority of the pop-up.
     *
     * @param priority The value which will be set
     */
    inline void setPriority (uint32 priority_);

    // API of field "modality"

    static const int kModality = 1;

    /**
     * Clears the field "modality".
     *
     * The field will be set to its default value. The hasModality()
     * method will return false.
     */
    inline void clearModality();

    /**
     * Checks whether the field "modality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setModality()). Otherwise it will return false.
     */
    inline bool hasModality () const;

    /**
     * Returns the value of the member "modality".
     *
     * The modality of the pop-up.
     *
     * @return The value of the field "modality"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::Modality getModality () const;

    /**
     * Sets the value of the member "modality".
     *
     * The modality of the pop-up.
     *
     * @param modality The value which will be set
     */
    inline void setModality (::bosch::cm::ai::hmi::screenbroker::Types::Modality modality_);

    // API of field "presentationTime"

    static const int kPresentationTime = 2;

    /**
     * Clears the field "presentationTime".
     *
     * The field will be set to its default value. The hasPresentationTime()
     * method will return false.
     */
    inline void clearPresentationTime();

    /**
     * Checks whether the field "presentationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresentationTime()). Otherwise it will return false.
     */
    inline bool hasPresentationTime () const;

    /**
     * Returns the value of the member "presentationTime".
     *
     * The optional time period after which the pop-up is hidden automatically.
     *
     * @return The value of the field "presentationTime"
     */
    inline uint32 getPresentationTime () const;

    /**
     * Sets the value of the member "presentationTime".
     *
     * The optional time period after which the pop-up is hidden automatically.
     *
     * @param presentationTime The value which will be set
     */
    inline void setPresentationTime (uint32 presentationTime_);

    // API of field "minimumPresentationTime"

    static const int kMinimumPresentationTime = 3;

    /**
     * Clears the field "minimumPresentationTime".
     *
     * The field will be set to its default value. The hasMinimumPresentationTime()
     * method will return false.
     */
    inline void clearMinimumPresentationTime();

    /**
     * Checks whether the field "minimumPresentationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinimumPresentationTime()). Otherwise it will return false.
     */
    inline bool hasMinimumPresentationTime () const;

    /**
     * Returns the value of the member "minimumPresentationTime".
     *
     * The optional time period for which a pop-up shall be at least be visible.
     *
     * @return The value of the field "minimumPresentationTime"
     */
    inline uint32 getMinimumPresentationTime () const;

    /**
     * Sets the value of the member "minimumPresentationTime".
     *
     * The optional time period for which a pop-up shall be at least be visible.
     *
     * @param minimumPresentationTime The value which will be set
     */
    inline void setMinimumPresentationTime (uint32 minimumPresentationTime_);

    // API of field "validityPeriod"

    static const int kValidityPeriod = 4;

    /**
     * Clears the field "validityPeriod".
     *
     * The field will be set to its default value. The hasValidityPeriod()
     * method will return false.
     */
    inline void clearValidityPeriod();

    /**
     * Checks whether the field "validityPeriod" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValidityPeriod()). Otherwise it will return false.
     */
    inline bool hasValidityPeriod () const;

    /**
     * Returns the value of the member "validityPeriod".
     *
     * The optional time period after which a not presented pop-up is discarded.
     *
     * @return The value of the field "validityPeriod"
     */
    inline uint32 getValidityPeriod () const;

    /**
     * Sets the value of the member "validityPeriod".
     *
     * The optional time period after which a not presented pop-up is discarded.
     *
     * @param validityPeriod The value which will be set
     */
    inline void setValidityPeriod (uint32 validityPeriod_);

    // API of field "horizontalAlignment"

    static const int kHorizontalAlignment = 5;

    /**
     * Clears the field "horizontalAlignment".
     *
     * The field will be set to its default value. The hasHorizontalAlignment()
     * method will return false.
     */
    inline void clearHorizontalAlignment();

    /**
     * Checks whether the field "horizontalAlignment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHorizontalAlignment()). Otherwise it will return false.
     */
    inline bool hasHorizontalAlignment () const;

    /**
     * Returns the value of the member "horizontalAlignment".
     *
     * The optional horizontal alignment attribute of surface on the screen area.
     *
     * @return The value of the field "horizontalAlignment"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment getHorizontalAlignment () const;

    /**
     * Sets the value of the member "horizontalAlignment".
     *
     * The optional horizontal alignment attribute of surface on the screen area.
     *
     * @param horizontalAlignment The value which will be set
     */
    inline void setHorizontalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment horizontalAlignment_);

    // API of field "verticalAlignment"

    static const int kVerticalAlignment = 6;

    /**
     * Clears the field "verticalAlignment".
     *
     * The field will be set to its default value. The hasVerticalAlignment()
     * method will return false.
     */
    inline void clearVerticalAlignment();

    /**
     * Checks whether the field "verticalAlignment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVerticalAlignment()). Otherwise it will return false.
     */
    inline bool hasVerticalAlignment () const;

    /**
     * Returns the value of the member "verticalAlignment".
     *
     * The optional vertical alignment attribute of surface on the screen area.
     *
     * @return The value of the field "verticalAlignment"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment getVerticalAlignment () const;

    /**
     * Sets the value of the member "verticalAlignment".
     *
     * The optional vertical alignment attribute of surface on the screen area.
     *
     * @param verticalAlignment The value which will be set
     */
    inline void setVerticalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment verticalAlignment_);

    // API of field "scaling"

    static const int kScaling = 7;

    /**
     * Clears the field "scaling".
     *
     * The field will be set to its default value. The hasScaling()
     * method will return false.
     */
    inline void clearScaling();

    /**
     * Checks whether the field "scaling" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScaling()). Otherwise it will return false.
     */
    inline bool hasScaling () const;

    /**
     * Returns the value of the member "scaling".
     *
     * The optional scaling attribute of surface on the screen area.
     *
     * @return The value of the field "scaling"
     */
    inline ::bosch::cm::ai::hmi::screenbroker::Types::Scaling getScaling () const;

    /**
     * Sets the value of the member "scaling".
     *
     * The optional scaling attribute of surface on the screen area.
     *
     * @param scaling The value which will be set
     */
    inline void setScaling (::bosch::cm::ai::hmi::screenbroker::Types::Scaling scaling_);

    // API of field "focusPriority"

    static const int kFocusPriority = 8;

    /**
     * Clears the field "focusPriority".
     *
     * The field will be set to its default value. The hasFocusPriority()
     * method will return false.
     */
    inline void clearFocusPriority();

    /**
     * Checks whether the field "focusPriority" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFocusPriority()). Otherwise it will return false.
     */
    inline bool hasFocusPriority () const;

    /**
     * Returns the value of the member "focusPriority".
     *
     * The optional focus priority of the popup surface.
     *
     * @return The value of the field "focusPriority"
     */
    inline int32 getFocusPriority () const;

    /**
     * Sets the value of the member "focusPriority".
     *
     * The optional focus priority of the popup surface.
     *
     * @param focusPriority The value which will be set
     */
    inline void setFocusPriority (int32 focusPriority_);

    static const PopupPresentationArg &getDefaultInstance();

private:

    inline void set_has_priority ();

    inline void clear_has_priority ();

    inline void set_has_modality ();

    inline void clear_has_modality ();

    inline void set_has_presentationTime ();

    inline void clear_has_presentationTime ();

    inline void set_has_minimumPresentationTime ();

    inline void clear_has_minimumPresentationTime ();

    inline void set_has_validityPeriod ();

    inline void clear_has_validityPeriod ();

    inline void set_has_horizontalAlignment ();

    inline void clear_has_horizontalAlignment ();

    inline void set_has_verticalAlignment ();

    inline void clear_has_verticalAlignment ();

    inline void set_has_scaling ();

    inline void clear_has_scaling ();

    inline void set_has_focusPriority ();

    inline void clear_has_focusPriority ();

    uint32 _has_bits_[ (9 + 31) / 32];

    uint32 _priority;

    ::bosch::cm::ai::hmi::screenbroker::Types::Modality _modality;

    uint32 _presentationTime;

    uint32 _minimumPresentationTime;

    uint32 _validityPeriod;

    ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment _horizontalAlignment;

    ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment _verticalAlignment;

    ::bosch::cm::ai::hmi::screenbroker::Types::Scaling _scaling;

    int32 _focusPriority;

};

class BuildInLayerInfo {
public:

    /**
     * Default constructor
     */
    inline  BuildInLayerInfo ();

    /**
     * Copy constructor
     */
    inline  BuildInLayerInfo (const BuildInLayerInfo &rhs);

    /**
     * All fields constructor
     */
    inline  BuildInLayerInfo (uint32 layerId_, uint32 surfaceId_, uint32 screenId_, const ::std::string& connectorName_, const DimensionArg& dimensions_);

    /**
     * Destructor
     */
    inline  ~BuildInLayerInfo();

    /**
     * Assignment operator
     */
    inline BuildInLayerInfo& operator = (const BuildInLayerInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BuildInLayerInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BuildInLayerInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BuildInLayerInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BuildInLayerInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "layerId"

    static const int kLayerId = 0;

    /**
     * Clears the field "layerId".
     *
     * The field will be set to its default value. The hasLayerId()
     * method will return false.
     */
    inline void clearLayerId();

    /**
     * Checks whether the field "layerId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLayerId()). Otherwise it will return false.
     */
    inline bool hasLayerId () const;

    /**
     * Returns the value of the member "layerId".
     *
     *
     *
     * @return The value of the field "layerId"
     */
    inline uint32 getLayerId () const;

    /**
     * Sets the value of the member "layerId".
     *
     *
     *
     * @param layerId The value which will be set
     */
    inline void setLayerId (uint32 layerId_);

    // API of field "surfaceId"

    static const int kSurfaceId = 1;

    /**
     * Clears the field "surfaceId".
     *
     * The field will be set to its default value. The hasSurfaceId()
     * method will return false.
     */
    inline void clearSurfaceId();

    /**
     * Checks whether the field "surfaceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSurfaceId()). Otherwise it will return false.
     */
    inline bool hasSurfaceId () const;

    /**
     * Returns the value of the member "surfaceId".
     *
     *
     *
     * @return The value of the field "surfaceId"
     */
    inline uint32 getSurfaceId () const;

    /**
     * Sets the value of the member "surfaceId".
     *
     *
     *
     * @param surfaceId The value which will be set
     */
    inline void setSurfaceId (uint32 surfaceId_);

    // API of field "screenId"

    static const int kScreenId = 2;

    /**
     * Clears the field "screenId".
     *
     * The field will be set to its default value. The hasScreenId()
     * method will return false.
     */
    inline void clearScreenId();

    /**
     * Checks whether the field "screenId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setScreenId()). Otherwise it will return false.
     */
    inline bool hasScreenId () const;

    /**
     * Returns the value of the member "screenId".
     *
     *
     *
     * @return The value of the field "screenId"
     */
    inline uint32 getScreenId () const;

    /**
     * Sets the value of the member "screenId".
     *
     *
     *
     * @param screenId The value which will be set
     */
    inline void setScreenId (uint32 screenId_);

    // API of field "connectorName"

    static const int kConnectorName = 3;

    /**
     * Clears the field "connectorName".
     *
     * The field will be set to its default value. The hasConnectorName()
     * method will return false.
     */
    inline void clearConnectorName();

    /**
     * Checks whether the field "connectorName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectorName()). Otherwise it will return false.
     */
    inline bool hasConnectorName () const;

    /**
     * Returns the value of the member "connectorName".
     *
     *
     *
     * @return The value of the field "connectorName"
     */
    inline const ::std::string& getConnectorName () const;

    /**
     * Retrieves the value of the field "connectorName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "connectorName".
     */
    inline ::std::string& getConnectorNameMutable ();

    /**
     * Sets the value of the member "connectorName".
     *
     *
     *
     * @param connectorName The value which will be set
     */
    inline void setConnectorName (const ::std::string& connectorName_);

    /**
     * Sets the value of the member "connectorName".
     *
     *
     *
     * @param connectorName The value which will be set
     */
    inline void setConnectorName (const char* connectorName_);

    /**
     * Sets the value of the member "connectorName".
     *
     *
     *
     * @param connectorName The value which will be set
     */
    inline void setConnectorName (const char* value, size_t size);

    // API of field "dimensions"

    static const int kDimensions = 4;

    /**
     * Clears the field "dimensions".
     *
     * The field will be set to its default value. The hasDimensions()
     * method will return false.
     */
    inline void clearDimensions();

    /**
     * Checks whether the field "dimensions" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimensions()). Otherwise it will return false.
     */
    inline bool hasDimensions () const;

    /**
     * Returns the value of the member "dimensions".
     *
     *
     *
     * @return The value of the field "dimensions"
     */
    inline const DimensionArg& getDimensions () const;

    /**
     * Retrieves the value of the field "dimensions" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dimensions".
     */
    inline DimensionArg& getDimensionsMutable ();

    /**
     * Sets the value of the member "dimensions".
     *
     *
     *
     * @param dimensions The value which will be set
     */
    inline void setDimensions (const DimensionArg& dimensions_);

    static const BuildInLayerInfo &getDefaultInstance();

private:

    inline void set_has_layerId ();

    inline void clear_has_layerId ();

    inline void set_has_surfaceId ();

    inline void clear_has_surfaceId ();

    inline void set_has_screenId ();

    inline void clear_has_screenId ();

    inline void set_has_connectorName ();

    inline void clear_has_connectorName ();

    inline void set_has_dimensions ();

    inline void clear_has_dimensions ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _layerId;

    uint32 _surfaceId;

    uint32 _screenId;

    ::std::string _connectorName;

    DimensionArg _dimensions;

};

inline  RequestArg::RequestArg ()  :
    _requestId (0u),
    _appId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestArg::RequestArg (const RequestArg &rhs)  :
    _requestId (0u),
    _appId (0u),
    _userData (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestArg::RequestArg (uint32 requestId_, uint32 appId_, uint32 userData_)  :
    _requestId (requestId_),
    _appId (appId_),
    _userData (userData_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestArg::~RequestArg() {
}

inline RequestArg& RequestArg::operator = (const RequestArg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRequestId()) {
            setRequestId(rhs.getRequestId());
        } else {
            clearRequestId();
        }
        if (rhs.hasAppId()) {
            setAppId(rhs.getAppId());
        } else {
            clearAppId();
        }
        if (rhs.hasUserData()) {
            setUserData(rhs.getUserData());
        } else {
            clearUserData();
        }
    }
    return *this;
}

inline bool RequestArg::operator == (const RequestArg& rhs) const {
    return (((!hasRequestId() && !rhs.hasRequestId()) || getRequestId() == rhs.getRequestId()) &&
        ((!hasAppId() && !rhs.hasAppId()) || getAppId() == rhs.getAppId()) &&
        ((!hasUserData() && !rhs.hasUserData()) || getUserData() == rhs.getUserData()));
}

inline bool RequestArg::operator != (const RequestArg& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestArg::operator < (const RequestArg& rhs) const {
    if (hasRequestId() || rhs.hasRequestId()) {
        if (getRequestId() < rhs.getRequestId()) return true;
        if (getRequestId() > rhs.getRequestId()) return false;
    }
    if (hasAppId() || rhs.hasAppId()) {
        if (getAppId() < rhs.getAppId()) return true;
        if (getAppId() > rhs.getAppId()) return false;
    }
    if (hasUserData() || rhs.hasUserData()) {
        if (getUserData() < rhs.getUserData()) return true;
        if (getUserData() > rhs.getUserData()) return false;
    }
    return false;
}

inline bool RequestArg::operator > (const RequestArg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestArg::clear() {
    clearRequestId();
    clearAppId();
    clearUserData();
}

inline void RequestArg::clearRequestId() {
    if (hasRequestId()) {
         clear_has_requestId();
        _requestId = 0u;
     }
}

inline bool RequestArg::hasRequestId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestArg::getRequestId () const {
    return _requestId;
}

inline void RequestArg::setRequestId (uint32 requestId_) {
    set_has_requestId();
    this->_requestId = requestId_;
}

inline void RequestArg::clearAppId() {
    if (hasAppId()) {
         clear_has_appId();
        _appId = 0u;
     }
}

inline bool RequestArg::hasAppId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestArg::getAppId () const {
    return _appId;
}

inline void RequestArg::setAppId (uint32 appId_) {
    set_has_appId();
    this->_appId = appId_;
}

inline void RequestArg::clearUserData() {
    if (hasUserData()) {
         clear_has_userData();
        _userData = 0u;
     }
}

inline bool RequestArg::hasUserData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 RequestArg::getUserData () const {
    return _userData;
}

inline void RequestArg::setUserData (uint32 userData_) {
    set_has_userData();
    this->_userData = userData_;
}

inline void RequestArg::set_has_requestId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestArg::clear_has_requestId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestArg::set_has_appId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestArg::clear_has_appId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestArg::set_has_userData () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestArg::clear_has_userData () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DimensionArg::DimensionArg ()  :
    _width (0u),
    _height (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DimensionArg::DimensionArg (const DimensionArg &rhs)  :
    _width (0u),
    _height (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DimensionArg::DimensionArg (uint32 width_, uint32 height_)  :
    _width (width_),
    _height (height_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DimensionArg::~DimensionArg() {
}

inline DimensionArg& DimensionArg::operator = (const DimensionArg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasWidth()) {
            setWidth(rhs.getWidth());
        } else {
            clearWidth();
        }
        if (rhs.hasHeight()) {
            setHeight(rhs.getHeight());
        } else {
            clearHeight();
        }
    }
    return *this;
}

inline bool DimensionArg::operator == (const DimensionArg& rhs) const {
    return (((!hasWidth() && !rhs.hasWidth()) || getWidth() == rhs.getWidth()) &&
        ((!hasHeight() && !rhs.hasHeight()) || getHeight() == rhs.getHeight()));
}

inline bool DimensionArg::operator != (const DimensionArg& rhs) const {
    return ! (*this == rhs);
}

inline bool DimensionArg::operator < (const DimensionArg& rhs) const {
    if (hasWidth() || rhs.hasWidth()) {
        if (getWidth() < rhs.getWidth()) return true;
        if (getWidth() > rhs.getWidth()) return false;
    }
    if (hasHeight() || rhs.hasHeight()) {
        if (getHeight() < rhs.getHeight()) return true;
        if (getHeight() > rhs.getHeight()) return false;
    }
    return false;
}

inline bool DimensionArg::operator > (const DimensionArg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DimensionArg::clear() {
    clearWidth();
    clearHeight();
}

inline void DimensionArg::clearWidth() {
    if (hasWidth()) {
         clear_has_width();
        _width = 0u;
     }
}

inline bool DimensionArg::hasWidth () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 DimensionArg::getWidth () const {
    return _width;
}

inline void DimensionArg::setWidth (uint32 width_) {
    set_has_width();
    this->_width = width_;
}

inline void DimensionArg::clearHeight() {
    if (hasHeight()) {
         clear_has_height();
        _height = 0u;
     }
}

inline bool DimensionArg::hasHeight () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DimensionArg::getHeight () const {
    return _height;
}

inline void DimensionArg::setHeight (uint32 height_) {
    set_has_height();
    this->_height = height_;
}

inline void DimensionArg::set_has_width () {
    _has_bits_[0] |= 1u << 0;
}

inline void DimensionArg::clear_has_width () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DimensionArg::set_has_height () {
    _has_bits_[0] |= 1u << 1;
}

inline void DimensionArg::clear_has_height () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PopupPresentationArg::PopupPresentationArg ()  :
    _priority (0u),
    _modality (::bosch::cm::ai::hmi::screenbroker::Types::Modality__None),
    _presentationTime (0u),
    _minimumPresentationTime (0u),
    _validityPeriod (0u),
    _horizontalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment__Left),
    _verticalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment__Bottom),
    _scaling (::bosch::cm::ai::hmi::screenbroker::Types::Scaling__None),
    _focusPriority (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PopupPresentationArg::PopupPresentationArg (const PopupPresentationArg &rhs)  :
    _priority (0u),
    _modality (::bosch::cm::ai::hmi::screenbroker::Types::Modality__None),
    _presentationTime (0u),
    _minimumPresentationTime (0u),
    _validityPeriod (0u),
    _horizontalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment__Left),
    _verticalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment__Bottom),
    _scaling (::bosch::cm::ai::hmi::screenbroker::Types::Scaling__None),
    _focusPriority (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PopupPresentationArg::PopupPresentationArg (uint32 priority_, ::bosch::cm::ai::hmi::screenbroker::Types::Modality modality_, uint32 presentationTime_, uint32 minimumPresentationTime_, uint32 validityPeriod_, ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment horizontalAlignment_, ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment verticalAlignment_, ::bosch::cm::ai::hmi::screenbroker::Types::Scaling scaling_, int32 focusPriority_)  :
    _priority (priority_),
    _modality (modality_),
    _presentationTime (presentationTime_),
    _minimumPresentationTime (minimumPresentationTime_),
    _validityPeriod (validityPeriod_),
    _horizontalAlignment (horizontalAlignment_),
    _verticalAlignment (verticalAlignment_),
    _scaling (scaling_),
    _focusPriority (focusPriority_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::Modality_IsValid(modality_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", modality_, "Modality", "modality", "PopupPresentationArg");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment_IsValid(horizontalAlignment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", horizontalAlignment_, "HorizontalAlignment", "horizontalAlignment", "PopupPresentationArg");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment_IsValid(verticalAlignment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", verticalAlignment_, "VerticalAlignment", "verticalAlignment", "PopupPresentationArg");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::Scaling_IsValid(scaling_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", scaling_, "Scaling", "scaling", "PopupPresentationArg");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PopupPresentationArg::~PopupPresentationArg() {
}

inline PopupPresentationArg& PopupPresentationArg::operator = (const PopupPresentationArg& rhs) {
    if( this != &rhs ) {
        if (rhs.hasPriority()) {
            setPriority(rhs.getPriority());
        } else {
            clearPriority();
        }
        if (rhs.hasModality()) {
            setModality(rhs.getModality());
        } else {
            clearModality();
        }
        if (rhs.hasPresentationTime()) {
            setPresentationTime(rhs.getPresentationTime());
        } else {
            clearPresentationTime();
        }
        if (rhs.hasMinimumPresentationTime()) {
            setMinimumPresentationTime(rhs.getMinimumPresentationTime());
        } else {
            clearMinimumPresentationTime();
        }
        if (rhs.hasValidityPeriod()) {
            setValidityPeriod(rhs.getValidityPeriod());
        } else {
            clearValidityPeriod();
        }
        if (rhs.hasHorizontalAlignment()) {
            setHorizontalAlignment(rhs.getHorizontalAlignment());
        } else {
            clearHorizontalAlignment();
        }
        if (rhs.hasVerticalAlignment()) {
            setVerticalAlignment(rhs.getVerticalAlignment());
        } else {
            clearVerticalAlignment();
        }
        if (rhs.hasScaling()) {
            setScaling(rhs.getScaling());
        } else {
            clearScaling();
        }
        if (rhs.hasFocusPriority()) {
            setFocusPriority(rhs.getFocusPriority());
        } else {
            clearFocusPriority();
        }
    }
    return *this;
}

inline bool PopupPresentationArg::operator == (const PopupPresentationArg& rhs) const {
    return (((!hasPriority() && !rhs.hasPriority()) || getPriority() == rhs.getPriority()) &&
        ((!hasModality() && !rhs.hasModality()) || getModality() == rhs.getModality()) &&
        ((!hasPresentationTime() && !rhs.hasPresentationTime()) || getPresentationTime() == rhs.getPresentationTime()) &&
        ((!hasMinimumPresentationTime() && !rhs.hasMinimumPresentationTime()) || getMinimumPresentationTime() == rhs.getMinimumPresentationTime()) &&
        ((!hasValidityPeriod() && !rhs.hasValidityPeriod()) || getValidityPeriod() == rhs.getValidityPeriod()) &&
        ((!hasHorizontalAlignment() && !rhs.hasHorizontalAlignment()) || getHorizontalAlignment() == rhs.getHorizontalAlignment()) &&
        ((!hasVerticalAlignment() && !rhs.hasVerticalAlignment()) || getVerticalAlignment() == rhs.getVerticalAlignment()) &&
        ((!hasScaling() && !rhs.hasScaling()) || getScaling() == rhs.getScaling()) &&
        ((!hasFocusPriority() && !rhs.hasFocusPriority()) || getFocusPriority() == rhs.getFocusPriority()));
}

inline bool PopupPresentationArg::operator != (const PopupPresentationArg& rhs) const {
    return ! (*this == rhs);
}

inline bool PopupPresentationArg::operator < (const PopupPresentationArg& rhs) const {
    if (hasPriority() || rhs.hasPriority()) {
        if (getPriority() < rhs.getPriority()) return true;
        if (getPriority() > rhs.getPriority()) return false;
    }
    if (hasModality() || rhs.hasModality()) {
        if ((uint32)getModality() < (uint32)rhs.getModality()) return true;
        if ((uint32)getModality() > (uint32)rhs.getModality()) return false;
    }
    if (hasPresentationTime() || rhs.hasPresentationTime()) {
        if (getPresentationTime() < rhs.getPresentationTime()) return true;
        if (getPresentationTime() > rhs.getPresentationTime()) return false;
    }
    if (hasMinimumPresentationTime() || rhs.hasMinimumPresentationTime()) {
        if (getMinimumPresentationTime() < rhs.getMinimumPresentationTime()) return true;
        if (getMinimumPresentationTime() > rhs.getMinimumPresentationTime()) return false;
    }
    if (hasValidityPeriod() || rhs.hasValidityPeriod()) {
        if (getValidityPeriod() < rhs.getValidityPeriod()) return true;
        if (getValidityPeriod() > rhs.getValidityPeriod()) return false;
    }
    if (hasHorizontalAlignment() || rhs.hasHorizontalAlignment()) {
        if ((uint32)getHorizontalAlignment() < (uint32)rhs.getHorizontalAlignment()) return true;
        if ((uint32)getHorizontalAlignment() > (uint32)rhs.getHorizontalAlignment()) return false;
    }
    if (hasVerticalAlignment() || rhs.hasVerticalAlignment()) {
        if ((uint32)getVerticalAlignment() < (uint32)rhs.getVerticalAlignment()) return true;
        if ((uint32)getVerticalAlignment() > (uint32)rhs.getVerticalAlignment()) return false;
    }
    if (hasScaling() || rhs.hasScaling()) {
        if ((uint32)getScaling() < (uint32)rhs.getScaling()) return true;
        if ((uint32)getScaling() > (uint32)rhs.getScaling()) return false;
    }
    if (hasFocusPriority() || rhs.hasFocusPriority()) {
        if (getFocusPriority() < rhs.getFocusPriority()) return true;
        if (getFocusPriority() > rhs.getFocusPriority()) return false;
    }
    return false;
}

inline bool PopupPresentationArg::operator > (const PopupPresentationArg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PopupPresentationArg::clear() {
    clearPriority();
    clearModality();
    clearPresentationTime();
    clearMinimumPresentationTime();
    clearValidityPeriod();
    clearHorizontalAlignment();
    clearVerticalAlignment();
    clearScaling();
    clearFocusPriority();
}

inline void PopupPresentationArg::clearPriority() {
    if (hasPriority()) {
         clear_has_priority();
        _priority = 0u;
     }
}

inline bool PopupPresentationArg::hasPriority () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 PopupPresentationArg::getPriority () const {
    return _priority;
}

inline void PopupPresentationArg::setPriority (uint32 priority_) {
    set_has_priority();
    this->_priority = priority_;
}

inline void PopupPresentationArg::clearModality() {
    if (hasModality()) {
         clear_has_modality();
        _modality = ::bosch::cm::ai::hmi::screenbroker::Types::Modality__None;
     }
}

inline bool PopupPresentationArg::hasModality () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::Modality PopupPresentationArg::getModality () const {
    return _modality;
}

inline void PopupPresentationArg::setModality (::bosch::cm::ai::hmi::screenbroker::Types::Modality modality_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::Modality_IsValid(modality_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", modality_, "Modality", "modality", "PopupPresentationArg");
    }
    set_has_modality();
    this->_modality = modality_;
}

inline void PopupPresentationArg::clearPresentationTime() {
    if (hasPresentationTime()) {
         clear_has_presentationTime();
        _presentationTime = 0u;
     }
}

inline bool PopupPresentationArg::hasPresentationTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 PopupPresentationArg::getPresentationTime () const {
    return _presentationTime;
}

inline void PopupPresentationArg::setPresentationTime (uint32 presentationTime_) {
    set_has_presentationTime();
    this->_presentationTime = presentationTime_;
}

inline void PopupPresentationArg::clearMinimumPresentationTime() {
    if (hasMinimumPresentationTime()) {
         clear_has_minimumPresentationTime();
        _minimumPresentationTime = 0u;
     }
}

inline bool PopupPresentationArg::hasMinimumPresentationTime () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 PopupPresentationArg::getMinimumPresentationTime () const {
    return _minimumPresentationTime;
}

inline void PopupPresentationArg::setMinimumPresentationTime (uint32 minimumPresentationTime_) {
    set_has_minimumPresentationTime();
    this->_minimumPresentationTime = minimumPresentationTime_;
}

inline void PopupPresentationArg::clearValidityPeriod() {
    if (hasValidityPeriod()) {
         clear_has_validityPeriod();
        _validityPeriod = 0u;
     }
}

inline bool PopupPresentationArg::hasValidityPeriod () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 PopupPresentationArg::getValidityPeriod () const {
    return _validityPeriod;
}

inline void PopupPresentationArg::setValidityPeriod (uint32 validityPeriod_) {
    set_has_validityPeriod();
    this->_validityPeriod = validityPeriod_;
}

inline void PopupPresentationArg::clearHorizontalAlignment() {
    if (hasHorizontalAlignment()) {
         clear_has_horizontalAlignment();
        _horizontalAlignment = ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment__Left;
     }
}

inline bool PopupPresentationArg::hasHorizontalAlignment () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment PopupPresentationArg::getHorizontalAlignment () const {
    return _horizontalAlignment;
}

inline void PopupPresentationArg::setHorizontalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment horizontalAlignment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::HorizontalAlignment_IsValid(horizontalAlignment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", horizontalAlignment_, "HorizontalAlignment", "horizontalAlignment", "PopupPresentationArg");
    }
    set_has_horizontalAlignment();
    this->_horizontalAlignment = horizontalAlignment_;
}

inline void PopupPresentationArg::clearVerticalAlignment() {
    if (hasVerticalAlignment()) {
         clear_has_verticalAlignment();
        _verticalAlignment = ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment__Bottom;
     }
}

inline bool PopupPresentationArg::hasVerticalAlignment () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment PopupPresentationArg::getVerticalAlignment () const {
    return _verticalAlignment;
}

inline void PopupPresentationArg::setVerticalAlignment (::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment verticalAlignment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::VerticalAlignment_IsValid(verticalAlignment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", verticalAlignment_, "VerticalAlignment", "verticalAlignment", "PopupPresentationArg");
    }
    set_has_verticalAlignment();
    this->_verticalAlignment = verticalAlignment_;
}

inline void PopupPresentationArg::clearScaling() {
    if (hasScaling()) {
         clear_has_scaling();
        _scaling = ::bosch::cm::ai::hmi::screenbroker::Types::Scaling__None;
     }
}

inline bool PopupPresentationArg::hasScaling () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline ::bosch::cm::ai::hmi::screenbroker::Types::Scaling PopupPresentationArg::getScaling () const {
    return _scaling;
}

inline void PopupPresentationArg::setScaling (::bosch::cm::ai::hmi::screenbroker::Types::Scaling scaling_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::bosch::cm::ai::hmi::screenbroker::Types::Scaling_IsValid(scaling_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", scaling_, "Scaling", "scaling", "PopupPresentationArg");
    }
    set_has_scaling();
    this->_scaling = scaling_;
}

inline void PopupPresentationArg::clearFocusPriority() {
    if (hasFocusPriority()) {
         clear_has_focusPriority();
        _focusPriority = 0;
     }
}

inline bool PopupPresentationArg::hasFocusPriority () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline int32 PopupPresentationArg::getFocusPriority () const {
    return _focusPriority;
}

inline void PopupPresentationArg::setFocusPriority (int32 focusPriority_) {
    set_has_focusPriority();
    this->_focusPriority = focusPriority_;
}

inline void PopupPresentationArg::set_has_priority () {
    _has_bits_[0] |= 1u << 0;
}

inline void PopupPresentationArg::clear_has_priority () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PopupPresentationArg::set_has_modality () {
    _has_bits_[0] |= 1u << 1;
}

inline void PopupPresentationArg::clear_has_modality () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PopupPresentationArg::set_has_presentationTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void PopupPresentationArg::clear_has_presentationTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PopupPresentationArg::set_has_minimumPresentationTime () {
    _has_bits_[0] |= 1u << 3;
}

inline void PopupPresentationArg::clear_has_minimumPresentationTime () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void PopupPresentationArg::set_has_validityPeriod () {
    _has_bits_[0] |= 1u << 4;
}

inline void PopupPresentationArg::clear_has_validityPeriod () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void PopupPresentationArg::set_has_horizontalAlignment () {
    _has_bits_[0] |= 1u << 5;
}

inline void PopupPresentationArg::clear_has_horizontalAlignment () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void PopupPresentationArg::set_has_verticalAlignment () {
    _has_bits_[0] |= 1u << 6;
}

inline void PopupPresentationArg::clear_has_verticalAlignment () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void PopupPresentationArg::set_has_scaling () {
    _has_bits_[0] |= 1u << 7;
}

inline void PopupPresentationArg::clear_has_scaling () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void PopupPresentationArg::set_has_focusPriority () {
    _has_bits_[0] |= 1u << 8;
}

inline void PopupPresentationArg::clear_has_focusPriority () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  BuildInLayerInfo::BuildInLayerInfo ()  :
    _layerId (0u),
    _surfaceId (0u),
    _screenId (0u),
    _connectorName (),
    _dimensions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BuildInLayerInfo::BuildInLayerInfo (const BuildInLayerInfo &rhs)  :
    _layerId (0u),
    _surfaceId (0u),
    _screenId (0u),
    _connectorName (),
    _dimensions ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BuildInLayerInfo::BuildInLayerInfo (uint32 layerId_, uint32 surfaceId_, uint32 screenId_, const ::std::string& connectorName_, const DimensionArg& dimensions_)  :
    _layerId (layerId_),
    _surfaceId (surfaceId_),
    _screenId (screenId_),
    _connectorName (connectorName_),
    _dimensions (dimensions_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (connectorName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BuildInLayerInfo::~BuildInLayerInfo() {
}

inline BuildInLayerInfo& BuildInLayerInfo::operator = (const BuildInLayerInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasLayerId()) {
            setLayerId(rhs.getLayerId());
        } else {
            clearLayerId();
        }
        if (rhs.hasSurfaceId()) {
            setSurfaceId(rhs.getSurfaceId());
        } else {
            clearSurfaceId();
        }
        if (rhs.hasScreenId()) {
            setScreenId(rhs.getScreenId());
        } else {
            clearScreenId();
        }
        if (rhs.hasConnectorName()) {
            setConnectorName(rhs.getConnectorName());
        } else {
            clearConnectorName();
        }
        if (rhs.hasDimensions()) {
            setDimensions(rhs.getDimensions());
        } else {
            clearDimensions();
        }
    }
    return *this;
}

inline bool BuildInLayerInfo::operator == (const BuildInLayerInfo& rhs) const {
    return (((!hasLayerId() && !rhs.hasLayerId()) || getLayerId() == rhs.getLayerId()) &&
        ((!hasSurfaceId() && !rhs.hasSurfaceId()) || getSurfaceId() == rhs.getSurfaceId()) &&
        ((!hasScreenId() && !rhs.hasScreenId()) || getScreenId() == rhs.getScreenId()) &&
        ((!hasConnectorName() && !rhs.hasConnectorName()) || getConnectorName() == rhs.getConnectorName()) &&
        ((!hasDimensions() && !rhs.hasDimensions()) || getDimensions() == rhs.getDimensions()));
}

inline bool BuildInLayerInfo::operator != (const BuildInLayerInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool BuildInLayerInfo::operator < (const BuildInLayerInfo& rhs) const {
    if (hasLayerId() || rhs.hasLayerId()) {
        if (getLayerId() < rhs.getLayerId()) return true;
        if (getLayerId() > rhs.getLayerId()) return false;
    }
    if (hasSurfaceId() || rhs.hasSurfaceId()) {
        if (getSurfaceId() < rhs.getSurfaceId()) return true;
        if (getSurfaceId() > rhs.getSurfaceId()) return false;
    }
    if (hasScreenId() || rhs.hasScreenId()) {
        if (getScreenId() < rhs.getScreenId()) return true;
        if (getScreenId() > rhs.getScreenId()) return false;
    }
    if (hasConnectorName() || rhs.hasConnectorName()) {
        if (getConnectorName() < rhs.getConnectorName()) return true;
        if (getConnectorName() > rhs.getConnectorName()) return false;
    }
    if (hasDimensions() || rhs.hasDimensions()) {
        if (getDimensions() < rhs.getDimensions()) return true;
        if (getDimensions() > rhs.getDimensions()) return false;
    }
    return false;
}

inline bool BuildInLayerInfo::operator > (const BuildInLayerInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BuildInLayerInfo::clear() {
    clearLayerId();
    clearSurfaceId();
    clearScreenId();
    clearConnectorName();
    clearDimensions();
}

inline void BuildInLayerInfo::clearLayerId() {
    if (hasLayerId()) {
         clear_has_layerId();
        _layerId = 0u;
     }
}

inline bool BuildInLayerInfo::hasLayerId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 BuildInLayerInfo::getLayerId () const {
    return _layerId;
}

inline void BuildInLayerInfo::setLayerId (uint32 layerId_) {
    set_has_layerId();
    this->_layerId = layerId_;
}

inline void BuildInLayerInfo::clearSurfaceId() {
    if (hasSurfaceId()) {
         clear_has_surfaceId();
        _surfaceId = 0u;
     }
}

inline bool BuildInLayerInfo::hasSurfaceId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 BuildInLayerInfo::getSurfaceId () const {
    return _surfaceId;
}

inline void BuildInLayerInfo::setSurfaceId (uint32 surfaceId_) {
    set_has_surfaceId();
    this->_surfaceId = surfaceId_;
}

inline void BuildInLayerInfo::clearScreenId() {
    if (hasScreenId()) {
         clear_has_screenId();
        _screenId = 0u;
     }
}

inline bool BuildInLayerInfo::hasScreenId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 BuildInLayerInfo::getScreenId () const {
    return _screenId;
}

inline void BuildInLayerInfo::setScreenId (uint32 screenId_) {
    set_has_screenId();
    this->_screenId = screenId_;
}

inline void BuildInLayerInfo::clearConnectorName() {
    if (hasConnectorName()) {
         clear_has_connectorName();
        _connectorName.clear();
     }
}

inline bool BuildInLayerInfo::hasConnectorName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& BuildInLayerInfo::getConnectorName () const {
    return _connectorName;
}

inline ::std::string& BuildInLayerInfo::getConnectorNameMutable () {
    set_has_connectorName();
    return _connectorName;
}

inline void BuildInLayerInfo::setConnectorName (const ::std::string& connectorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (connectorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_connectorName();
    this->_connectorName = connectorName_;
}

inline void BuildInLayerInfo::setConnectorName (const char* connectorName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (connectorName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_connectorName();
    this->_connectorName.assign(connectorName_);
}

inline void BuildInLayerInfo::setConnectorName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_connectorName();
    this->_connectorName.assign(value, size);
}

inline void BuildInLayerInfo::clearDimensions() {
    if (hasDimensions()) {
         clear_has_dimensions();
        _dimensions.clear();
     }
}

inline bool BuildInLayerInfo::hasDimensions () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const DimensionArg& BuildInLayerInfo::getDimensions () const {
    return _dimensions;
}

inline DimensionArg& BuildInLayerInfo::getDimensionsMutable () {
    set_has_dimensions();
    return _dimensions;
}

inline void BuildInLayerInfo::setDimensions (const DimensionArg& dimensions_) {
    set_has_dimensions();
    this->_dimensions = dimensions_;
}

inline void BuildInLayerInfo::set_has_layerId () {
    _has_bits_[0] |= 1u << 0;
}

inline void BuildInLayerInfo::clear_has_layerId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BuildInLayerInfo::set_has_surfaceId () {
    _has_bits_[0] |= 1u << 1;
}

inline void BuildInLayerInfo::clear_has_surfaceId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void BuildInLayerInfo::set_has_screenId () {
    _has_bits_[0] |= 1u << 2;
}

inline void BuildInLayerInfo::clear_has_screenId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void BuildInLayerInfo::set_has_connectorName () {
    _has_bits_[0] |= 1u << 3;
}

inline void BuildInLayerInfo::clear_has_connectorName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void BuildInLayerInfo::set_has_dimensions () {
    _has_bits_[0] |= 1u << 4;
}

inline void BuildInLayerInfo::clear_has_dimensions () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace Arguments
} // namespace screenbroker
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_SCREENBROKER_ARGUMENTS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
