/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "ai_sw_update/common/recovery_hmi/imp/SWURecoveryHmiComponent.h"
#include "ai_sw_update/common/recovery_hmi/imp/SWURecoveryHmi_app.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "SWURecoveryHmi_app" isn't clear, then there should be a description here.
 */

namespace ai_sw_update {
namespace common {
namespace recovery_hmi {
namespace imp {

DEFINE_LOGGER_AND_LEVEL (_logger, "/ai_sw_update/common/recovery_hmi/imp/SWURecoveryHmi_app", Info);

/* static */ const char* SWURecoveryHmi_app::recoveryHmiClient = "recoveryHmiClient";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool SWURecoveryHmi_app_enabledASFSignalHandler = false;

void importSWURecoveryHmi_app() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach SWURecoveryHmi_app, because no Application is instantiated");

    // Thread 'ThreadRecoveryHmiClient'

    ::asf::core::ComponentContainerSharedPtr ThreadRecoveryHmiClient(new ::asf::core::ComponentContainer("ThreadRecoveryHmiClient", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThreadRecoveryHmiClient);

        // Component 'SWURecoveryHmiComponent recoveryHmiClient'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::ai_sw_update::common::recovery_hmi::imp::SWURecoveryHmiComponent > > recoveryHmiClientFactory(new ::asf::core::ComponentFactory< ::ai_sw_update::common::recovery_hmi::imp::SWURecoveryHmiComponent >);
        ::asf::core::ComponentDescriptionSharedPtr recoveryHmiClientDescription(new ::asf::core::ComponentDescription(1, "recoveryHmiClient", /* immediate = */ true, /* threadBridge = */ false, recoveryHmiClientFactory));
        ThreadRecoveryHmiClient->addComponentDescription(recoveryHmiClientDescription);

            // Port 'fcSwUpdatePort'

            ::asf::core::RequiredPort& recoveryHmiClient_fcSwUpdatePort = recoveryHmiClientDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort"));
            (void)recoveryHmiClient_fcSwUpdatePort; // prevent unused variable warning

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::asf::dbus::DBusImportedPort& fcSwUpdateService = dbusConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));
    fcSwUpdateService.setServiceName("fcswupdatesrv.FcSwUpdateSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (recoveryHmiClient_fcSwUpdatePort, fcSwUpdateService);


    LOG_INFO_STATIC("Starting application 'SWURecoveryHmi_app' version 0.1.0");

    app->start();
}

int executeSWURecoveryHmi_app(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.recovery_hmi.imp", "SWURecoveryHmi_app");
    } else {
        ::asf::core::Logger::setupLogging ("ai_sw_update.common.recovery_hmi.imp", "SWURecoveryHmi_app", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", SWURecoveryHmi_app_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("ai_sw_update.common.recovery_hmi.imp", "SWURecoveryHmi_app", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create SWURecoveryHmi_app");

    app->enableExceptionHandler(true);

    importSWURecoveryHmi_app();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace imp
} // namespace recovery_hmi
} // namespace common
} // namespace ai_sw_update

int main(int argc, char* argv[]) {
    ::ai_sw_update::common::recovery_hmi::imp::SWURecoveryHmi_app_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::ai_sw_update::common::recovery_hmi::imp::executeSWURecoveryHmi_app(argc, argv);
}

