/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/ProcDiagnosisSlave.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusExportedPort.h"
#include "asf/dia_ASFComponentSubsystemDiagnosisServer.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "ProcDiagnosisSlave" isn't clear, then there should be a description here.
 */

namespace asf {

DEFINE_LOGGER_AND_LEVEL (_logger, "/asf/ProcDiagnosisSlave", Info);

/* static */ const char* ProcDiagnosisSlave::SubsystemDiagnosisServer = "SubsystemDiagnosisServer";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool ProcDiagnosisSlave_enabledASFSignalHandler = false;

void importProcDiagnosisSlave() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach ProcDiagnosisSlave, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Thread 'diagThread'

    ::asf::core::ComponentContainerSharedPtr DiagThread(new ::asf::core::ComponentContainer("diagThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (DiagThread);

        // Component 'dia_ASFComponentSubsystemDiagnosisServer SubsystemDiagnosisServer'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSubsystemDiagnosisServer > > subsystemDiagnosisServerFactory(new ::asf::core::ComponentFactory< ::asf::dia_ASFComponentSubsystemDiagnosisServer >);
        ::asf::core::ComponentDescriptionSharedPtr subsystemDiagnosisServerDescription(new ::asf::core::ComponentDescription(1, "SubsystemDiagnosisServer", /* immediate = */ true, /* threadBridge = */ false, subsystemDiagnosisServerFactory));
        DiagThread->addComponentDescription(subsystemDiagnosisServerDescription);

            // Port 'SubsystemDiagnosisServerPort'

            ::asf::core::ProvidedPort& SubsystemDiagnosisServer_SubsystemDiagnosisServerPort = subsystemDiagnosisServerDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis", "SubsystemDiagnosisServerPort", false, false));
            (void)SubsystemDiagnosisServer_SubsystemDiagnosisServerPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusExportedPort& _SubsystemDiagnosis = dbusConnector_->exportByName (SubsystemDiagnosisServer_SubsystemDiagnosisServerPort, ::std::string("/org/bosch/cm/diagnosis/dbus/SubsystemDiagnosis"));
    _SubsystemDiagnosis.setServiceName("org.bosch.cm.diagnosis.dbus.SubsystemDiagnosis");


    LOG_INFO_STATIC("Starting application 'ProcDiagnosisSlave' version 0.0.1");

    app->start();
}

int executeProcDiagnosisSlave(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiagnosisSlave");
    } else {
        ::asf::core::Logger::setupLogging ("asf", "ProcDiagnosisSlave", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", ProcDiagnosisSlave_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("asf", "ProcDiagnosisSlave", ::asf::core::Version(0, 0, 1, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create ProcDiagnosisSlave");

    app->enableExceptionHandler(true);

    importProcDiagnosisSlave();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace asf

int main(int argc, char* argv[]) {
    ::asf::ProcDiagnosisSlave_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::asf::executeProcDiagnosisSlave(argc, argv);
}

