/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICERECOGNITIONSTUB_H
#define COM_BOSCH_PMAPP_VOICERECOGNITIONSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceRecognition.h"
#include <map>
#include <string>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceRecognition {

class VoiceRecognitionStubDelegate;

class VoiceRecognitionStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the VoiceRecognitionStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    VoiceRecognitionStub (const std::string& portName);

    /**
     * Create an instance of the VoiceRecognitionStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    VoiceRecognitionStub (const std::string& portName, const std::string& objectPath);

    virtual ~VoiceRecognitionStub();

    // property 'VoiceRecognitionStatus'

    /**
     * The method onVoiceRecognitionStatusGet() is called by ASF when a client
     * invokes the read method for the property 'VoiceRecognitionStatus'. The
     * onVoiceRecognitionStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     */
    virtual void onVoiceRecognitionStatusGet(const ::boost::shared_ptr< VoiceRecognitionStatusGet >& payload);

    /**
     * Sends back the update to a previous onVoiceRecognitionStatusGet().
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @param act Identifies a previous invocation of
     * onVoiceRecognitionStatusGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendVoiceRecognitionStatusGetUpdate(uint8 voiceRecognitionStatus, act_t act = 0);

    /**
     * Set the value of the property 'VoiceRecognitionStatus' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     */
    void setVoiceRecognitionStatus(uint8 voiceRecognitionStatus);

    /**
     * Returns the current value of the property 'VoiceRecognitionStatus'.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     */
    uint8 getVoiceRecognitionStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVoiceRecognitionStatusUpdate().
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     */
    void sendVoiceRecognitionStatusUpdate();

    // property 'EnhancedVoiceRecognitionFeature'

    /**
     * The method onEnhancedVoiceRecognitionFeatureGet() is called by ASF when
     * a client invokes the read method for the property
     * 'EnhancedVoiceRecognitionFeature'. The
     * onEnhancedVoiceRecognitionFeatureGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     */
    virtual void onEnhancedVoiceRecognitionFeatureGet(const ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureGet >& payload);

    /**
     * Sends back the update to a previous
     * onEnhancedVoiceRecognitionFeatureGet().
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @param act Identifies a previous invocation of
     * onEnhancedVoiceRecognitionFeatureGet(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendEnhancedVoiceRecognitionFeatureGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& enhancedVoiceRecognitionFeature, act_t act = 0);

    /**
     * Set the value of the property 'EnhancedVoiceRecognitionFeature' and
     * send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     */
    void setEnhancedVoiceRecognitionFeature(const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& enhancedVoiceRecognitionFeature);

    /**
     * Returns the current value of the property 'EnhancedVoiceRecognitionFeature'.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeature() const;

    /**
     * Returns the current value of the property
     * 'EnhancedVoiceRecognitionFeature' as a mutable reference. If you change
     * the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendEnhancedVoiceRecognitionFeatureUpdate() method.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     */
    ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeatureMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEnhancedVoiceRecognitionFeatureUpdate().
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     */
    void sendEnhancedVoiceRecognitionFeatureUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the Voice Recognition Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the Voice Recognition Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param VoiceRecognitionProperties Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"VoiceRecognitionStatus" : 0x01}
     *                     {"EnhancedVoiceRecognitionFeature" : {{"Feature" : "Siri"}, {"Status" : 0x00}}}
     *                 }
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceRecognitionVariant >& voiceRecognitionProperties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the Voice Recognition Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'StartStopVoiceRecognition'

    /**
     * The method onStartStopVoiceRecognition() is called by ASF when a client
     * invokes the method 'StartStopVoiceRecognition'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendStartStopVoiceRecognition() or
     * sendStartStopVoiceRecognitionError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'StartStopVoiceRecognition'</b>:
     *
     * Activate and deactivate the internal voice recognition of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartStopVoiceRecognitionRequest (const ::boost::shared_ptr< StartStopVoiceRecognitionRequest >& request) = 0;

    /**
     * The method sendStartStopVoiceRecognitionResponse() sends a response of
     * a previous method invocation of 'StartStopVoiceRecognition' back to the
     * client.
     *
     * <b>Documentation of 'StartStopVoiceRecognition'</b>:
     *
     * Activate and deactivate the internal voice recognition of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartStopVoiceRecognition(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartStopVoiceRecognitionResponse (act_t act = 0);

    /**
     * The method sendStartStopVoiceRecognitionError() sends an error response
     * of a previous method invocation of 'StartStopVoiceRecognition' back to
     * the client.
     *
     * <b>Documentation of 'StartStopVoiceRecognition'</b>:
     *
     * Activate and deactivate the internal voice recognition of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartStopVoiceRecognition(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartStopVoiceRecognitionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    VoiceRecognitionStatusUpdate _VoiceRecognitionStatusProperty;

    EnhancedVoiceRecognitionFeatureUpdate _EnhancedVoiceRecognitionFeatureProperty;

    friend class VoiceRecognitionStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace VoiceRecognition
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICERECOGNITIONSTUB_H
