/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICERECOGNITIONPROXY_H
#define COM_BOSCH_PMAPP_VOICERECOGNITIONPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceRecognition.h"
#include <dbus/dbus.h>

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceRecognition {

class VoiceRecognitionProxy;

class EnhancedVoiceRecognitionFeatureCallbackIF {
public:
    virtual ~EnhancedVoiceRecognitionFeatureCallbackIF() {}

    virtual void onEnhancedVoiceRecognitionFeatureError(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureError >& error) = 0;

    virtual void onEnhancedVoiceRecognitionFeatureUpdate(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< EnhancedVoiceRecognitionFeatureUpdate >& update) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class StartStopVoiceRecognitionCallbackIF {
public:
    virtual ~StartStopVoiceRecognitionCallbackIF() {}

    virtual void onStartStopVoiceRecognitionError(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< StartStopVoiceRecognitionError >& error) = 0;

    virtual void onStartStopVoiceRecognitionResponse(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< StartStopVoiceRecognitionResponse >& response) = 0;
};

class VoiceRecognitionStatusCallbackIF {
public:
    virtual ~VoiceRecognitionStatusCallbackIF() {}

    virtual void onVoiceRecognitionStatusError(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< VoiceRecognitionStatusError >& error) = 0;

    virtual void onVoiceRecognitionStatusUpdate(const ::boost::shared_ptr< VoiceRecognitionProxy >& proxy, const ::boost::shared_ptr< VoiceRecognitionStatusUpdate >& update) = 0;
};


/**
 * VoiceRecognitionProxy is the client side representation of the D-Bus
 * service interface 'com.bosch.pmapp.VoiceRecognition' (specified in file
 * pmapp_voice_recognition_.xml).
 *
 * The interface shall be exposed in the object path: /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of connected HFP device is - "aabbccddeeff", then the corresponding VoiceRecognition
 *     interface will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */
class VoiceRecognitionProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of VoiceRecognitionProxy.
     */
    static ::boost::shared_ptr< VoiceRecognitionProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of VoiceRecognitionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< VoiceRecognitionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of VoiceRecognitionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< VoiceRecognitionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< VoiceRecognitionProxy > proxyNew(new VoiceRecognitionProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~VoiceRecognitionProxy ();



    // Property 'VoiceRecognitionStatus'

    /**
     * Notify on the property 'VoiceRecognitionStatus'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceRecognitionStatusRegister(VoiceRecognitionStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'VoiceRecognitionStatus'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @param act The act which was previously returned by the
     * sendVoiceRecognitionStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVoiceRecognitionStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'VoiceRecognitionStatus'.
     */
    void sendVoiceRecognitionStatusDeregisterAll() const;

    /**
     * Request the value of the property 'VoiceRecognitionStatus' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'VoiceRecognitionStatus'</b>:
     *
     * Provides the current status of the Voice Recognition Session. The possible values are:
     *
     *             0x00 - VR_IDLE [Default],
     *             0x01 - VR_STARTING,
     *             0x02 - VR_ACTIVE,
     *             0x03 - VR_ENDING.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceRecognitionStatusGet(VoiceRecognitionStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'VoiceRecognitionStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasVoiceRecognitionStatus() returns true.
     *
     * @return the previously received value of the property 'VoiceRecognitionStatus'.
     */
    uint8 getVoiceRecognitionStatus() const;

    /**
     * Determines whether a status message for the property
     * 'VoiceRecognitionStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVoiceRecognitionStatus() const;

    // Property 'EnhancedVoiceRecognitionFeature'

    /**
     * Notify on the property 'EnhancedVoiceRecognitionFeature'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnhancedVoiceRecognitionFeatureRegister(EnhancedVoiceRecognitionFeatureCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'EnhancedVoiceRecognitionFeature'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @param act The act which was previously returned by the
     * sendEnhancedVoiceRecognitionFeatureRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEnhancedVoiceRecognitionFeatureDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'EnhancedVoiceRecognitionFeature'.
     */
    void sendEnhancedVoiceRecognitionFeatureDeregisterAll() const;

    /**
     * Request the value of the property 'EnhancedVoiceRecognitionFeature'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'EnhancedVoiceRecognitionFeature'</b>:
     *
     * This property updates the availability of the enhanced VoiceRecognition feature specific to the HFP Connected
     *         device. E.x. Siri - IPhone..
     *
     *         Type representation - Dict:
     *           { ParameterName : ParameterValue }
     *
     *         Example:
     *           {
     *             {"Feature" : "Siri"}
     *             {"Status" : 0x00}
     *           }
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnhancedVoiceRecognitionFeatureGet(EnhancedVoiceRecognitionFeatureCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'EnhancedVoiceRecognitionFeature' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasEnhancedVoiceRecognitionFeature() returns true.
     *
     * @return the previously received value of the property 'EnhancedVoiceRecognitionFeature'.
     */
    const ::com::bosch::pmapp::PMAppTypeCollections::EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeature() const;

    /**
     * Determines whether a status message for the property
     * 'EnhancedVoiceRecognitionFeature' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEnhancedVoiceRecognitionFeature() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Get the properties of the Voice Recognition Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'StartStopVoiceRecognition'

    /**
     * Call the method 'StartStopVoiceRecognition'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'StartStopVoiceRecognition'</b>:
     *
     * Activate and deactivate the internal voice recognition of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.InvalidArguments
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param VRAction The possible values are:
     *                     0x00 - Stop the VR session
     *                     0x01 - Start the VR session
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartStopVoiceRecognitionRequest(StartStopVoiceRecognitionCallbackIF& cb, uint8 vRAction) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    VoiceRecognitionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'VoiceRecognitionStatus'

    ::asf::core::nullable< VoiceRecognitionStatusUpdate > _voiceRecognitionStatus;

    // Property 'EnhancedVoiceRecognitionFeature'

    ::asf::core::nullable< EnhancedVoiceRecognitionFeatureUpdate > _enhancedVoiceRecognitionFeature;

    DECLARE_CLASS_LOGGER();

    friend class VoiceRecognitionProxyCallback;
};

} // namespace VoiceRecognition
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICERECOGNITIONPROXY_H
