/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include "com/bosch/pmapp/VoiceCallManager.h"
#include "com/bosch/pmapp/VoiceCallManagerDBus.h"
#include "com/bosch/pmapp/VoiceCallManagerJson.h"
#include "com/bosch/pmapp/VoiceCallManagerProxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCallManager {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/VoiceCallManager", VoiceCallManagerProxy);

class VoiceCallManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    VoiceCallManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< VoiceCallManagerProxy >& proxyShared = ::boost::static_pointer_cast< VoiceCallManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_CallStatusList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallStatusListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallStatusList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallStatusListError> payload = ::boost::static_pointer_cast<CallStatusListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CallStatusListCallbackIF*) _callback)->onCallStatusListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallStatusListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallStatusList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CallStatusListUpdate> payload = ::boost::static_pointer_cast<CallStatusListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CallStatusListCallbackIF*) _callback)->onCallStatusListUpdate(proxyShared, payload);
                        proxyShared->_callStatusList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_MicrophoneMuteState:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MicrophoneMuteStateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MicrophoneMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MicrophoneMuteStateError> payload = ::boost::static_pointer_cast<MicrophoneMuteStateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((MicrophoneMuteStateCallbackIF*) _callback)->onMicrophoneMuteStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MicrophoneMuteStateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MicrophoneMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MicrophoneMuteStateUpdate> payload = ::boost::static_pointer_cast<MicrophoneMuteStateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((MicrophoneMuteStateCallbackIF*) _callback)->onMicrophoneMuteStateUpdate(proxyShared, payload);
                        proxyShared->_microphoneMuteState = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MuteUnmuteMicrophone:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteMicrophoneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteUnmuteMicrophone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteUnmuteMicrophoneError> payload = ::boost::static_pointer_cast<MuteUnmuteMicrophoneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteUnmuteMicrophoneCallbackIF*) _callback)->onMuteUnmuteMicrophoneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteUnmuteMicrophoneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteUnmuteMicrophone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteUnmuteMicrophoneResponse> payload = ::boost::static_pointer_cast<MuteUnmuteMicrophoneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteUnmuteMicrophoneCallbackIF*) _callback)->onMuteUnmuteMicrophoneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MergeCalls:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MergeCallsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MergeCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MergeCallsError> payload = ::boost::static_pointer_cast<MergeCallsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MergeCallsCallbackIF*) _callback)->onMergeCallsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MergeCallsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MergeCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MergeCallsResponse> payload = ::boost::static_pointer_cast<MergeCallsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MergeCallsCallbackIF*) _callback)->onMergeCallsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SplitCalls:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SplitCallsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SplitCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SplitCallsError> payload = ::boost::static_pointer_cast<SplitCallsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SplitCallsCallbackIF*) _callback)->onSplitCallsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SplitCallsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SplitCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SplitCallsResponse> payload = ::boost::static_pointer_cast<SplitCallsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SplitCallsCallbackIF*) _callback)->onSplitCallsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HangupAll:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupAllError> payload = ::boost::static_pointer_cast<HangupAllError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupAllCallbackIF*) _callback)->onHangupAllError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupAllResponse> payload = ::boost::static_pointer_cast<HangupAllResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupAllCallbackIF*) _callback)->onHangupAllResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Redial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RedialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Redial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RedialError> payload = ::boost::static_pointer_cast<RedialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RedialCallbackIF*) _callback)->onRedialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RedialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Redial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RedialResponse> payload = ::boost::static_pointer_cast<RedialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RedialCallbackIF*) _callback)->onRedialResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_CallStatusList: {
                ::boost::shared_ptr< CallStatusListError > payload = ::boost::shared_ptr< CallStatusListError >
                (new CallStatusListError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CallStatusList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CallStatusListCallbackIF*) _callback)->onCallStatusListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MicrophoneMuteState: {
                ::boost::shared_ptr< MicrophoneMuteStateError > payload = ::boost::shared_ptr< MicrophoneMuteStateError >
                (new MicrophoneMuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MicrophoneMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MicrophoneMuteStateCallbackIF*) _callback)->onMicrophoneMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MuteUnmuteMicrophone: {
                ::boost::shared_ptr< MuteUnmuteMicrophoneError > payload = ::boost::shared_ptr< MuteUnmuteMicrophoneError >
                (new MuteUnmuteMicrophoneError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MuteUnmuteMicrophone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MuteUnmuteMicrophoneCallbackIF*) _callback)->onMuteUnmuteMicrophoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MergeCalls: {
                ::boost::shared_ptr< MergeCallsError > payload = ::boost::shared_ptr< MergeCallsError >
                (new MergeCallsError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MergeCalls", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MergeCallsCallbackIF*) _callback)->onMergeCallsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SplitCalls: {
                ::boost::shared_ptr< SplitCallsError > payload = ::boost::shared_ptr< SplitCallsError >
                (new SplitCallsError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SplitCalls", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SplitCallsCallbackIF*) _callback)->onSplitCallsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HangupAll: {
                ::boost::shared_ptr< HangupAllError > payload = ::boost::shared_ptr< HangupAllError >
                (new HangupAllError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HangupAll", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HangupAllCallbackIF*) _callback)->onHangupAllError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Redial: {
                ::boost::shared_ptr< RedialError > payload = ::boost::shared_ptr< RedialError >
                (new RedialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Redial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RedialCallbackIF*) _callback)->onRedialError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& VoiceCallManagerProxyCallback::_logger (VoiceCallManagerProxy::_logger);

VoiceCallManagerProxy::VoiceCallManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.pmapp.VoiceCallManager", serviceAvailable, _logger) {
}

VoiceCallManagerProxy::~VoiceCallManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< VoiceCallManagerProxy > VoiceCallManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<VoiceCallManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< VoiceCallManagerProxy > proxyNew(new VoiceCallManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t VoiceCallManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t VoiceCallManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void VoiceCallManagerProxy::clearAllProperties ()
{
    _callStatusList = ::asf::core::nullable< CallStatusListUpdate >();
    _microphoneMuteState = ::asf::core::nullable< MicrophoneMuteStateUpdate >();
}

void VoiceCallManagerProxy::sendDeregisterAll () const
{
    sendCallStatusListDeregisterAll();
    sendMicrophoneMuteStateDeregisterAll();
}

act_t VoiceCallManagerProxy::sendCallStatusListRegister(CallStatusListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CallStatusList, "CallStatusList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CallStatusList", &cb, act);
    return act;
}

bool VoiceCallManagerProxy::sendCallStatusListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CallStatusList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CallStatusList", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceCallManagerProxy::sendCallStatusListGet(CallStatusListCallbackIF& cb) {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(ID_CallStatusList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CallStatusList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CallStatusList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::CallStatusVariant > >& VoiceCallManagerProxy::getCallStatusList() const {
    return _callStatusList.get().getCallStatusList();
}

bool VoiceCallManagerProxy::hasCallStatusList() const {
    return _callStatusList.hasValue();
}

void VoiceCallManagerProxy::sendCallStatusListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CallStatusList");
    _dbusProxyDelegate->deregisterSignalCallback("CallStatusList", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceCallManagerProxy::sendMicrophoneMuteStateRegister(MicrophoneMuteStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_MicrophoneMuteState, "MicrophoneMuteState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MicrophoneMuteState", &cb, act);
    return act;
}

bool VoiceCallManagerProxy::sendMicrophoneMuteStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MicrophoneMuteState", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MicrophoneMuteState", act, static_cast<int>(rv));
    return rv;
}

act_t VoiceCallManagerProxy::sendMicrophoneMuteStateGet(MicrophoneMuteStateCallbackIF& cb) {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(ID_MicrophoneMuteState, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "MicrophoneMuteState", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("MicrophoneMuteState", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool VoiceCallManagerProxy::getMicrophoneMuteState() const {
    return _microphoneMuteState.get().getMicrophoneMuteState();
}

bool VoiceCallManagerProxy::hasMicrophoneMuteState() const {
    return _microphoneMuteState.hasValue();
}

void VoiceCallManagerProxy::sendMicrophoneMuteStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MicrophoneMuteState");
    _dbusProxyDelegate->deregisterSignalCallback("MicrophoneMuteState", 0, _dbusDaemonProxy.get(), true);
}

act_t VoiceCallManagerProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendMuteUnmuteMicrophoneRequest(MuteUnmuteMicrophoneCallbackIF& cb, bool muteState) const {
    MuteUnmuteMicrophoneRequest* payload = new MuteUnmuteMicrophoneRequest();
    CHECK_ALLOCATION(payload);
    payload->setMuteState(muteState);
    DBUS_MESSAGE_CALL(dbusMessage, "MuteUnmuteMicrophone", MuteUnmuteMicrophoneRequest, payload, true)
    act_t act = addMethodCallback(ID_MuteUnmuteMicrophone, dbusMessage.getUniqueSerial(), "MuteUnmuteMicrophone", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MuteUnmuteMicrophone", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendMergeCallsRequest(MergeCallsCallbackIF& cb, const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& callsToMerge) const {
    MergeCallsRequest* payload = new MergeCallsRequest();
    CHECK_ALLOCATION(payload);
    payload->setCallsToMerge(callsToMerge);
    DBUS_MESSAGE_CALL(dbusMessage, "MergeCalls", MergeCallsRequest, payload, true)
    act_t act = addMethodCallback(ID_MergeCalls, dbusMessage.getUniqueSerial(), "MergeCalls", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MergeCalls", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendSplitCallsRequest(SplitCallsCallbackIF& cb, const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceCallsList >& callsToSplit) const {
    SplitCallsRequest* payload = new SplitCallsRequest();
    CHECK_ALLOCATION(payload);
    payload->setCallsToSplit(callsToSplit);
    DBUS_MESSAGE_CALL(dbusMessage, "SplitCalls", SplitCallsRequest, payload, true)
    act_t act = addMethodCallback(ID_SplitCalls, dbusMessage.getUniqueSerial(), "SplitCalls", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SplitCalls", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendHangupAllRequest(HangupAllCallbackIF& cb, const ::std::vector< ::std::string >& deviceAddressList) const {
    HangupAllRequest* payload = new HangupAllRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceAddressList(deviceAddressList);
    DBUS_MESSAGE_CALL(dbusMessage, "HangupAll", HangupAllRequest, payload, true)
    act_t act = addMethodCallback(ID_HangupAll, dbusMessage.getUniqueSerial(), "HangupAll", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HangupAll", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendRedialRequest(RedialCallbackIF& cb, const ::std::string& deviceAddressIn, uint8 hideCallerID) const {
    RedialRequest* payload = new RedialRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceAddressIn(deviceAddressIn);
    payload->setHideCallerID(hideCallerID);
    DBUS_MESSAGE_CALL(dbusMessage, "Redial", RedialRequest, payload, true)
    act_t act = addMethodCallback(ID_Redial, dbusMessage.getUniqueSerial(), "Redial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Redial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace VoiceCallManager
} // namespace pmapp
} // namespace bosch
} // namespace com
