#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_VOICECALL_H
#define COM_BOSCH_PMAPP_VOICECALL_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of the HFP connected device is - "aabbccddeeff", then the corresponding  VoiceCall interface
 *     will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace VoiceCall {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_MuteUnmuteRingtone = 1;
static const uint16 ID_Dial = 2;
static const uint16 ID_AcceptCall = 3;
static const uint16 ID_SwapCall = 4;
static const uint16 ID_HangUpCall = 5;
static const uint16 ID_SpeedDial = 6;
static const uint16 ID_SendDTMF = 7;
static const uint16 ID_StartStopWaitingMode = 8;
static const uint16 ID_TransferAudio = 9;

// signal IDs

// property IDs
static const uint16 ID_SCOConnection = 10;
static const uint16 ID_RingtoneMuteState = 11;
static const uint16 ID_WaitingModeState = 12;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPropertiesResponse;

class MuteUnmuteRingtoneRequest;

class DialRequest;

class DialResponse;

class AcceptCallRequest;

class AcceptCallResponse;

class SwapCallRequest;

class HangUpCallRequest;

class HangUpCallResponse;

class SpeedDialRequest;

class SpeedDialResponse;

class SendDTMFRequest;

class StartStopWaitingModeRequest;

class TransferAudioRequest;

class SCOConnectionUpdate;

class SCOConnectionRegister;

class RingtoneMuteStateUpdate;

class RingtoneMuteStateRegister;

class WaitingModeStateUpdate;

class WaitingModeStateRegister;

// type definitions
/**
 * Get the properties of the VoiceCall Interface.
 *
 *         Possible errors:
 *         ---
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * This method allows the client to Mute / Unmute the playing ringtone.
 *         The updated change will be provided by the property - 'RingtoneMuteState'.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage MuteUnmuteRingtoneResponse;

/**
 * If the meaning of "MuteUnmuteRingtoneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MuteUnmuteRingtoneError;

/**
 * If the meaning of "DialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DialError;

/**
 * If the meaning of "AcceptCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AcceptCallError;

/**
 * This method could be invoked to:
 *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
 *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
 *              - Release the currently active call (0 or more) and activate any currently held calls.
 *
 *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
 *         calls exist.
 *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
 *         the case of Held, Active and Waiting calls.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SwapCallResponse;

/**
 * If the meaning of "SwapCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SwapCallError;

/**
 * If the meaning of "HangUpCallError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HangUpCallError;

/**
 * If the meaning of "SpeedDialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeedDialError;

/**
 * Sends DTMF tones to the network. The tones have a fixed duration.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendDTMFResponse;

/**
 * If the meaning of "SendDTMFError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendDTMFError;

/**
 * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartStopWaitingModeResponse;

/**
 * If the meaning of "StartStopWaitingModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartStopWaitingModeError;

/**
 * Transfers the audio to AG or HF.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage TransferAudioResponse;

/**
 * If the meaning of "TransferAudioError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TransferAudioError;

/**
 * Provides the status of the SCO establishment between AG and HF.
 *
 *         Status of the SCO establishment:
 *                 0x00 - No SCO establishment between AG & HF,
 *                 0x01 - SCO is established between AG and HF,
 *                 0xFF - Default.
 */
typedef SCOConnectionUpdate SCOConnectionSet;

/**
 * Provides the status of the SCO establishment between AG and HF.
 *
 *         Status of the SCO establishment:
 *                 0x00 - No SCO establishment between AG & HF,
 *                 0x01 - SCO is established between AG and HF,
 *                 0xFF - Default.
 */
typedef SCOConnectionUpdate SCOConnectionGet;

/**
 * If the meaning of "SCOConnectionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SCOConnectionError;

/**
 * Provides the current state of the ringtone mute.
 *
 *         TRUE - Ringtone mute enabled.
 *         FALSE - Ringtone mute disabled [Default].
 */
typedef RingtoneMuteStateUpdate RingtoneMuteStateSet;

/**
 * Provides the current state of the ringtone mute.
 *
 *         TRUE - Ringtone mute enabled.
 *         FALSE - Ringtone mute disabled [Default].
 */
typedef RingtoneMuteStateUpdate RingtoneMuteStateGet;

/**
 * If the meaning of "RingtoneMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RingtoneMuteStateError;

/**
 * Updates the current waiting mode state.
 *
 *         The possible waiting mode states are:
 *             0x00 : WAITING_MODE_IDLE [Default],
 *             0x01 : WAITING_MODE_STARTING,
 *             0x02 : WAITING_MODE_ACTIVE,
 *             0x03 : WAITING_MODE_ENDING.
 */
typedef WaitingModeStateUpdate WaitingModeStateSet;

/**
 * Updates the current waiting mode state.
 *
 *         The possible waiting mode states are:
 *             0x00 : WAITING_MODE_IDLE [Default],
 *             0x01 : WAITING_MODE_STARTING,
 *             0x02 : WAITING_MODE_ACTIVE,
 *             0x03 : WAITING_MODE_ENDING.
 */
typedef WaitingModeStateUpdate WaitingModeStateGet;

/**
 * If the meaning of "WaitingModeStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WaitingModeStateError;


/**
 * Get the properties of the VoiceCall Interface.
 *
 *         Possible errors:
 *         ---
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& VoiceCallProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoiceCallProperties"

    static const int kVoiceCallProperties = 0;

    /**
     * Clears the field "VoiceCallProperties".
     *
     * The field will be set to its default value. The hasVoiceCallProperties()
     * method will return false.
     */
    inline void clearVoiceCallProperties();

    /**
     * Checks whether the field "VoiceCallProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoiceCallProperties()). Otherwise it will return false.
     */
    inline bool hasVoiceCallProperties () const;

    /**
     * Returns the value of the member "VoiceCallProperties".
     *
     * Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SCOConnection" : 0x01},
     *                     {"RingtoneMuteState" : true},
     *                     {"WaitingModeState" : 0x01}
     *                   }
     *
     * @return The value of the field "VoiceCallProperties"
     */
    inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& getVoiceCallProperties () const;

    /**
     * Retrieves the value of the field "VoiceCallProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoiceCallProperties".
     */
    inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& getVoiceCallPropertiesMutable ();

    /**
     * Sets the value of the member "VoiceCallProperties".
     *
     * Type representation of the parameter- Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SCOConnection" : 0x01},
     *                     {"RingtoneMuteState" : true},
     *                     {"WaitingModeState" : 0x01}
     *                   }
     *
     * @param VoiceCallProperties The value which will be set
     */
    inline void setVoiceCallProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& VoiceCallProperties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& getStringToVoiceCallVariantMap_DefaultInstance ();

    inline void set_has_VoiceCallProperties ();

    inline void clear_has_VoiceCallProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant > _VoiceCallProperties;

};

/**
 * This method allows the client to Mute / Unmute the playing ringtone.
 *         The updated change will be provided by the property - 'RingtoneMuteState'.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 */
class MuteUnmuteRingtoneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MuteUnmuteRingtoneRequest ();

    /**
     * Copy constructor
     */
    inline  MuteUnmuteRingtoneRequest (const MuteUnmuteRingtoneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MuteUnmuteRingtoneRequest (bool MuteState_);

    /**
     * Destructor
     */
    inline virtual  ~MuteUnmuteRingtoneRequest();

    /**
     * Assignment operator
     */
    inline MuteUnmuteRingtoneRequest& operator = (const MuteUnmuteRingtoneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MuteUnmuteRingtoneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MuteUnmuteRingtoneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MuteUnmuteRingtoneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MuteUnmuteRingtoneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MuteState"

    static const int kMuteState = 0;

    /**
     * Clears the field "MuteState".
     *
     * The field will be set to its default value. The hasMuteState()
     * method will return false.
     */
    inline void clearMuteState();

    /**
     * Checks whether the field "MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMuteState()). Otherwise it will return false.
     */
    inline bool hasMuteState () const;

    /**
     * Returns the value of the member "MuteState".
     *
     * TRUE - Enable ringtone mute.
     *                 FALSE - Disable ringtone mute.
     *
     * @return The value of the field "MuteState"
     */
    inline bool getMuteState () const;

    /**
     * Sets the value of the member "MuteState".
     *
     * TRUE - Enable ringtone mute.
     *                 FALSE - Disable ringtone mute.
     *
     * @param MuteState The value which will be set
     */
    inline void setMuteState (bool MuteState_);

    static const MuteUnmuteRingtoneRequest &getDefaultInstance();

private:

    inline void set_has_MuteState ();

    inline void clear_has_MuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _MuteState;

};

/**
 * Initiates a new outgoing call.
 *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class DialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialRequest ();

    /**
     * Copy constructor
     */
    inline  DialRequest (const DialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DialRequest (const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo_);

    /**
     * Destructor
     */
    inline virtual  ~DialRequest();

    /**
     * Assignment operator
     */
    inline DialRequest& operator = (const DialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "dialInfo"

    static const int kDialInfo = 0;

    /**
     * Clears the field "dialInfo".
     *
     * The field will be set to its default value. The hasDialInfo()
     * method will return false.
     */
    inline void clearDialInfo();

    /**
     * Checks whether the field "dialInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDialInfo()). Otherwise it will return false.
     */
    inline bool hasDialInfo () const;

    /**
     * Returns the value of the member "dialInfo".
     *
     * Type representation of the parameter- Dict:
     *                   { ParamaterName : ParameterValue }
     *
     *                 Example:
     *                   {
     *                   {"TelephoneNumber:" : "9988774455"}
     *                   {"FirstName" : "AABBCCDD"}
     *                   {"LastName" : "EEFFGGHH"}
     *                   {"HideCallerID" : 0x01}
     *                   {"ContactId" : 0x56}
     *                 }
     *
     * @return The value of the field "dialInfo"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& getDialInfo () const;

    /**
     * Retrieves the value of the field "dialInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "dialInfo".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& getDialInfoMutable ();

    /**
     * Sets the value of the member "dialInfo".
     *
     * Type representation of the parameter- Dict:
     *                   { ParamaterName : ParameterValue }
     *
     *                 Example:
     *                   {
     *                   {"TelephoneNumber:" : "9988774455"}
     *                   {"FirstName" : "AABBCCDD"}
     *                   {"LastName" : "EEFFGGHH"}
     *                   {"HideCallerID" : 0x01}
     *                   {"ContactId" : 0x56}
     *                 }
     *
     * @param dialInfo The value which will be set
     */
    inline void setDialInfo (const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo_);

    static const DialRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::BaseTypesVariant >& getStringToBaseTypesVariantMap_DefaultInstance ();

    inline void set_has_dialInfo ();

    inline void clear_has_dialInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::DialInfo _dialInfo;

};

/**
 * Initiates a new outgoing call.
 *         The call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class DialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialResponse ();

    /**
     * Copy constructor
     */
    inline  DialResponse (const DialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DialResponse (uint8 CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~DialResponse();

    /**
     * Assignment operator
     */
    inline DialResponse& operator = (const DialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstance"

    static const int kCallInstance = 0;

    /**
     * Clears the field "CallInstance".
     *
     * The field will be set to its default value. The hasCallInstance()
     * method will return false.
     */
    inline void clearCallInstance();

    /**
     * Checks whether the field "CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstance()). Otherwise it will return false.
     */
    inline bool hasCallInstance () const;

    /**
     * Returns the value of the member "CallInstance".
     *
     * Instance of the outgoing call placed
     *
     * @return The value of the field "CallInstance"
     */
    inline uint8 getCallInstance () const;

    /**
     * Sets the value of the member "CallInstance".
     *
     * Instance of the outgoing call placed
     *
     * @param CallInstance The value which will be set
     */
    inline void setCallInstance (uint8 CallInstance_);

    static const DialResponse &getDefaultInstance();

private:

    inline void set_has_CallInstance ();

    inline void clear_has_CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallInstance;

};

/**
 * This method could be invoked to:
 *             - Answer an Incoming call (OR)
 *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
 *             - Put the current call on hold and answer the waiting call
 *
 *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class AcceptCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcceptCallRequest ();

    /**
     * Copy constructor
     */
    inline  AcceptCallRequest (const AcceptCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptCallRequest (uint8 CallInstanceIn_, uint8 Operation_);

    /**
     * Destructor
     */
    inline virtual  ~AcceptCallRequest();

    /**
     * Assignment operator
     */
    inline AcceptCallRequest& operator = (const AcceptCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstanceIn"

    static const int kCallInstanceIn = 0;

    /**
     * Clears the field "CallInstanceIn".
     *
     * The field will be set to its default value. The hasCallInstanceIn()
     * method will return false.
     */
    inline void clearCallInstanceIn();

    /**
     * Checks whether the field "CallInstanceIn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstanceIn()). Otherwise it will return false.
     */
    inline bool hasCallInstanceIn () const;

    /**
     * Returns the value of the member "CallInstanceIn".
     *
     * Instance of the incoming call that shall be accepted
     *
     * @return The value of the field "CallInstanceIn"
     */
    inline uint8 getCallInstanceIn () const;

    /**
     * Sets the value of the member "CallInstanceIn".
     *
     * Instance of the incoming call that shall be accepted
     *
     * @param CallInstanceIn The value which will be set
     */
    inline void setCallInstanceIn (uint8 CallInstanceIn_);

    // API of field "Operation"

    static const int kOperation = 1;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * The possible values are:
     *                     0x00 : ACCEPT - Answers the incoming call,
     *                     0x01 : RELEASE_AND_ACCEPT - Releases current active call (0 or more) and answer the
     *                     currently waiting call,
     *                     0x02 : HOLD_AND_ACCEPT - Puts the current call (including multi-party calls) on hold and
     *                     answers the currently waiting call.
     *
     *                 When there exists an active call and then arrives a waiting call and if client invokes AcceptCall API
     *                 with the attribute - Operation as ACCEPT (0x00), then the accept request will be posted to stack for
     *                 the waiting call and the behavior would be: current active call will be put on hold and the waiting
     *                 call will be switched to active.
     *
     * @return The value of the field "Operation"
     */
    inline uint8 getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * The possible values are:
     *                     0x00 : ACCEPT - Answers the incoming call,
     *                     0x01 : RELEASE_AND_ACCEPT - Releases current active call (0 or more) and answer the
     *                     currently waiting call,
     *                     0x02 : HOLD_AND_ACCEPT - Puts the current call (including multi-party calls) on hold and
     *                     answers the currently waiting call.
     *
     *                 When there exists an active call and then arrives a waiting call and if client invokes AcceptCall API
     *                 with the attribute - Operation as ACCEPT (0x00), then the accept request will be posted to stack for
     *                 the waiting call and the behavior would be: current active call will be put on hold and the waiting
     *                 call will be switched to active.
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (uint8 Operation_);

    static const AcceptCallRequest &getDefaultInstance();

private:

    inline void set_has_CallInstanceIn ();

    inline void clear_has_CallInstanceIn ();

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _CallInstanceIn;

    uint8 _Operation;

};

/**
 * This method could be invoked to:
 *             - Answer an Incoming call (OR)
 *             - Release currently active call (0 or more) and answer the currently waiting call (OR)
 *             - Put the current call on hold and answer the waiting call
 *
 *         The change in call state will be notified by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class AcceptCallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AcceptCallResponse ();

    /**
     * Copy constructor
     */
    inline  AcceptCallResponse (const AcceptCallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AcceptCallResponse (uint8 CallInstanceOut_);

    /**
     * Destructor
     */
    inline virtual  ~AcceptCallResponse();

    /**
     * Assignment operator
     */
    inline AcceptCallResponse& operator = (const AcceptCallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AcceptCallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AcceptCallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AcceptCallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AcceptCallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstanceOut"

    static const int kCallInstanceOut = 0;

    /**
     * Clears the field "CallInstanceOut".
     *
     * The field will be set to its default value. The hasCallInstanceOut()
     * method will return false.
     */
    inline void clearCallInstanceOut();

    /**
     * Checks whether the field "CallInstanceOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstanceOut()). Otherwise it will return false.
     */
    inline bool hasCallInstanceOut () const;

    /**
     * Returns the value of the member "CallInstanceOut".
     *
     * Instance of the accepted call.
     *
     * @return The value of the field "CallInstanceOut"
     */
    inline uint8 getCallInstanceOut () const;

    /**
     * Sets the value of the member "CallInstanceOut".
     *
     * Instance of the accepted call.
     *
     * @param CallInstanceOut The value which will be set
     */
    inline void setCallInstanceOut (uint8 CallInstanceOut_);

    static const AcceptCallResponse &getDefaultInstance();

private:

    inline void set_has_CallInstanceOut ();

    inline void clear_has_CallInstanceOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallInstanceOut;

};

/**
 * This method could be invoked to:
 *              - Place all the calls (0 or more including calls in a multi-party conversation) that are
 *             Active to Held, and all calls (0 or more) that are Held to Active (OR)
 *              - Release the currently active call (0 or more) and activate any currently held calls.
 *
 *          After successful swapping, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Note:- GSM specification does not allow calls to be swapped in the case where Held, Active and Waiting
 *         calls exist.
 *         Some modems implement this anyway, thus it is manufacturer specific whether this method will succeed in
 *         the case of Held, Active and Waiting calls.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SwapCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwapCallRequest ();

    /**
     * Copy constructor
     */
    inline  SwapCallRequest (const SwapCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SwapCallRequest (uint8 Operation_);

    /**
     * Destructor
     */
    inline virtual  ~SwapCallRequest();

    /**
     * Assignment operator
     */
    inline SwapCallRequest& operator = (const SwapCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwapCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwapCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwapCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwapCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Operation"

    static const int kOperation = 0;

    /**
     * Clears the field "Operation".
     *
     * The field will be set to its default value. The hasOperation()
     * method will return false.
     */
    inline void clearOperation();

    /**
     * Checks whether the field "Operation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperation()). Otherwise it will return false.
     */
    inline bool hasOperation () const;

    /**
     * Returns the value of the member "Operation".
     *
     * The possible values of the parameter are:
     *                     0x00 - SWAP_CALLS - Swaps Active and Held calls,
     *                     0x01 - RELEASE_AND_SWAP - Releases currently active call (0 or more) and activates any currently held calls.
     *                     If the current active call is a multiparty call, then all parties in the multi-party call will be released.
     *
     * @return The value of the field "Operation"
     */
    inline uint8 getOperation () const;

    /**
     * Sets the value of the member "Operation".
     *
     * The possible values of the parameter are:
     *                     0x00 - SWAP_CALLS - Swaps Active and Held calls,
     *                     0x01 - RELEASE_AND_SWAP - Releases currently active call (0 or more) and activates any currently held calls.
     *                     If the current active call is a multiparty call, then all parties in the multi-party call will be released.
     *
     * @param Operation The value which will be set
     */
    inline void setOperation (uint8 Operation_);

    static const SwapCallRequest &getDefaultInstance();

private:

    inline void set_has_Operation ();

    inline void clear_has_Operation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Operation;

};

/**
 * This method is used to hangup a specific call in the device.
 *
 *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class HangUpCallRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HangUpCallRequest ();

    /**
     * Copy constructor
     */
    inline  HangUpCallRequest (const HangUpCallRequest &rhs);

    /**
     * All fields constructor
     */
    inline  HangUpCallRequest (uint8 CallInstanceIn_);

    /**
     * Destructor
     */
    inline virtual  ~HangUpCallRequest();

    /**
     * Assignment operator
     */
    inline HangUpCallRequest& operator = (const HangUpCallRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstanceIn"

    static const int kCallInstanceIn = 0;

    /**
     * Clears the field "CallInstanceIn".
     *
     * The field will be set to its default value. The hasCallInstanceIn()
     * method will return false.
     */
    inline void clearCallInstanceIn();

    /**
     * Checks whether the field "CallInstanceIn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstanceIn()). Otherwise it will return false.
     */
    inline bool hasCallInstanceIn () const;

    /**
     * Returns the value of the member "CallInstanceIn".
     *
     * Instance of the call that shall be terminated
     *
     * @return The value of the field "CallInstanceIn"
     */
    inline uint8 getCallInstanceIn () const;

    /**
     * Sets the value of the member "CallInstanceIn".
     *
     * Instance of the call that shall be terminated
     *
     * @param CallInstanceIn The value which will be set
     */
    inline void setCallInstanceIn (uint8 CallInstanceIn_);

    static const HangUpCallRequest &getDefaultInstance();

private:

    inline void set_has_CallInstanceIn ();

    inline void clear_has_CallInstanceIn ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallInstanceIn;

};

/**
 * This method is used to hangup a specific call in the device.
 *
 *         After successful termination, new call status will be updated by the CallStatusList attribute(property) of the VoiceCallManager interface.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.NotImplemented
 */
class HangUpCallResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HangUpCallResponse ();

    /**
     * Copy constructor
     */
    inline  HangUpCallResponse (const HangUpCallResponse &rhs);

    /**
     * All fields constructor
     */
    inline  HangUpCallResponse (uint8 CallInstanceOut_);

    /**
     * Destructor
     */
    inline virtual  ~HangUpCallResponse();

    /**
     * Assignment operator
     */
    inline HangUpCallResponse& operator = (const HangUpCallResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HangUpCallResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HangUpCallResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HangUpCallResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HangUpCallResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstanceOut"

    static const int kCallInstanceOut = 0;

    /**
     * Clears the field "CallInstanceOut".
     *
     * The field will be set to its default value. The hasCallInstanceOut()
     * method will return false.
     */
    inline void clearCallInstanceOut();

    /**
     * Checks whether the field "CallInstanceOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstanceOut()). Otherwise it will return false.
     */
    inline bool hasCallInstanceOut () const;

    /**
     * Returns the value of the member "CallInstanceOut".
     *
     * Instance of the call that is terminated.
     *
     * @return The value of the field "CallInstanceOut"
     */
    inline uint8 getCallInstanceOut () const;

    /**
     * Sets the value of the member "CallInstanceOut".
     *
     * Instance of the call that is terminated.
     *
     * @param CallInstanceOut The value which will be set
     */
    inline void setCallInstanceOut (uint8 CallInstanceOut_);

    static const HangUpCallResponse &getDefaultInstance();

private:

    inline void set_has_CallInstanceOut ();

    inline void clear_has_CallInstanceOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallInstanceOut;

};

/**
 * Initiates a new outgoing call by number index.
 *
 *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SpeedDialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedDialRequest ();

    /**
     * Copy constructor
     */
    inline  SpeedDialRequest (const SpeedDialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedDialRequest (uint8 MemDialIndex_, uint8 HideCallerID_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedDialRequest();

    /**
     * Assignment operator
     */
    inline SpeedDialRequest& operator = (const SpeedDialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MemDialIndex"

    static const int kMemDialIndex = 0;

    /**
     * Clears the field "MemDialIndex".
     *
     * The field will be set to its default value. The hasMemDialIndex()
     * method will return false.
     */
    inline void clearMemDialIndex();

    /**
     * Checks whether the field "MemDialIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMemDialIndex()). Otherwise it will return false.
     */
    inline bool hasMemDialIndex () const;

    /**
     * Returns the value of the member "MemDialIndex".
     *
     * The number index which stands for the quick dial key in the cellphone.
     *
     * @return The value of the field "MemDialIndex"
     */
    inline uint8 getMemDialIndex () const;

    /**
     * Sets the value of the member "MemDialIndex".
     *
     * The number index which stands for the quick dial key in the cellphone.
     *
     * @param MemDialIndex The value which will be set
     */
    inline void setMemDialIndex (uint8 MemDialIndex_);

    // API of field "HideCallerID"

    static const int kHideCallerID = 1;

    /**
     * Clears the field "HideCallerID".
     *
     * The field will be set to its default value. The hasHideCallerID()
     * method will return false.
     */
    inline void clearHideCallerID();

    /**
     * Checks whether the field "HideCallerID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHideCallerID()). Otherwise it will return false.
     */
    inline bool hasHideCallerID () const;

    /**
     * Returns the value of the member "HideCallerID".
     *
     * The possible values are:
     *                     0x00- Shows the CallerID,
     *                     0x01- Hides the CallerID,
     *                     0xFF- Default (Network) mode is used.
     *
     * @return The value of the field "HideCallerID"
     */
    inline uint8 getHideCallerID () const;

    /**
     * Sets the value of the member "HideCallerID".
     *
     * The possible values are:
     *                     0x00- Shows the CallerID,
     *                     0x01- Hides the CallerID,
     *                     0xFF- Default (Network) mode is used.
     *
     * @param HideCallerID The value which will be set
     */
    inline void setHideCallerID (uint8 HideCallerID_);

    static const SpeedDialRequest &getDefaultInstance();

private:

    inline void set_has_MemDialIndex ();

    inline void clear_has_MemDialIndex ();

    inline void set_has_HideCallerID ();

    inline void clear_has_HideCallerID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _MemDialIndex;

    uint8 _HideCallerID;

};

/**
 * Initiates a new outgoing call by number index.
 *
 *         Note: If an active call (single or multiparty) exists, then it is automatically put on hold if the dial procedure is successful.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SpeedDialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeedDialResponse ();

    /**
     * Copy constructor
     */
    inline  SpeedDialResponse (const SpeedDialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SpeedDialResponse (uint8 CallInstance_);

    /**
     * Destructor
     */
    inline virtual  ~SpeedDialResponse();

    /**
     * Assignment operator
     */
    inline SpeedDialResponse& operator = (const SpeedDialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeedDialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeedDialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeedDialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeedDialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CallInstance"

    static const int kCallInstance = 0;

    /**
     * Clears the field "CallInstance".
     *
     * The field will be set to its default value. The hasCallInstance()
     * method will return false.
     */
    inline void clearCallInstance();

    /**
     * Checks whether the field "CallInstance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallInstance()). Otherwise it will return false.
     */
    inline bool hasCallInstance () const;

    /**
     * Returns the value of the member "CallInstance".
     *
     * Instance of the speed - dialed call.
     *
     * @return The value of the field "CallInstance"
     */
    inline uint8 getCallInstance () const;

    /**
     * Sets the value of the member "CallInstance".
     *
     * Instance of the speed - dialed call.
     *
     * @param CallInstance The value which will be set
     */
    inline void setCallInstance (uint8 CallInstance_);

    static const SpeedDialResponse &getDefaultInstance();

private:

    inline void set_has_CallInstance ();

    inline void clear_has_CallInstance ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _CallInstance;

};

/**
 * Sends DTMF tones to the network. The tones have a fixed duration.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 *         com.bosch.pmapp.Error.InvalidFormat
 *         com.bosch.pmapp.Error.NotImplemented
 */
class SendDTMFRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendDTMFRequest ();

    /**
     * Copy constructor
     */
    inline  SendDTMFRequest (const SendDTMFRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendDTMFRequest (const ::std::string& Tones_);

    /**
     * Destructor
     */
    inline virtual  ~SendDTMFRequest();

    /**
     * Assignment operator
     */
    inline SendDTMFRequest& operator = (const SendDTMFRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendDTMFRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendDTMFRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendDTMFRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendDTMFRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Tones"

    static const int kTones = 0;

    /**
     * Clears the field "Tones".
     *
     * The field will be set to its default value. The hasTones()
     * method will return false.
     */
    inline void clearTones();

    /**
     * Checks whether the field "Tones" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTones()). Otherwise it will return false.
     */
    inline bool hasTones () const;

    /**
     * Returns the value of the member "Tones".
     *
     * Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.
     *                 Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in
     *                 the description section.
     *                 Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.
     *
     * @return The value of the field "Tones"
     */
    inline const ::std::string& getTones () const;

    /**
     * Retrieves the value of the field "Tones" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Tones".
     */
    inline ::std::string& getTonesMutable ();

    /**
     * Sets the value of the member "Tones".
     *
     * Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.
     *                 Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in
     *                 the description section.
     *                 Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.
     *
     * @param Tones The value which will be set
     */
    inline void setTones (const ::std::string& Tones_);

    /**
     * Sets the value of the member "Tones".
     *
     * Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.
     *                 Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in
     *                 the description section.
     *                 Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.
     *
     * @param Tones The value which will be set
     */
    inline void setTones (const char* Tones_);

    /**
     * Sets the value of the member "Tones".
     *
     * Tones can be one of: '0'-'9', '(Asterisk symbol)', '#', 'A', 'B', 'C', 'D'.
     *                 Attention: There is an issue in generating the DBus introspection file if asterisk symbol is used in
     *                 the description section.
     *                 Note: The lettered keys ('A'-'D') were dropped from most phones, and typically not used in normal circumstances.
     *
     * @param Tones The value which will be set
     */
    inline void setTones (const char* value, size_t size);

    static const SendDTMFRequest &getDefaultInstance();

private:

    inline void set_has_Tones ();

    inline void clear_has_Tones ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Tones;

};

/**
 * Start or stop the waiting mode. Waiting mode status would be updated by the WaitingModeState property.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class StartStopWaitingModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartStopWaitingModeRequest ();

    /**
     * Copy constructor
     */
    inline  StartStopWaitingModeRequest (const StartStopWaitingModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartStopWaitingModeRequest (uint8 WaitingModeAction_);

    /**
     * Destructor
     */
    inline virtual  ~StartStopWaitingModeRequest();

    /**
     * Assignment operator
     */
    inline StartStopWaitingModeRequest& operator = (const StartStopWaitingModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartStopWaitingModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartStopWaitingModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartStopWaitingModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartStopWaitingModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WaitingModeAction"

    static const int kWaitingModeAction = 0;

    /**
     * Clears the field "WaitingModeAction".
     *
     * The field will be set to its default value. The hasWaitingModeAction()
     * method will return false.
     */
    inline void clearWaitingModeAction();

    /**
     * Checks whether the field "WaitingModeAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWaitingModeAction()). Otherwise it will return false.
     */
    inline bool hasWaitingModeAction () const;

    /**
     * Returns the value of the member "WaitingModeAction".
     *
     * The possible values are:
     *                 0x00 - Start waiting mode
     *                 0x01 - Stop waiting mode.
     *
     * @return The value of the field "WaitingModeAction"
     */
    inline uint8 getWaitingModeAction () const;

    /**
     * Sets the value of the member "WaitingModeAction".
     *
     * The possible values are:
     *                 0x00 - Start waiting mode
     *                 0x01 - Stop waiting mode.
     *
     * @param WaitingModeAction The value which will be set
     */
    inline void setWaitingModeAction (uint8 WaitingModeAction_);

    static const StartStopWaitingModeRequest &getDefaultInstance();

private:

    inline void set_has_WaitingModeAction ();

    inline void clear_has_WaitingModeAction ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _WaitingModeAction;

};

/**
 * Transfers the audio to AG or HF.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.AG.XXX
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class TransferAudioRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferAudioRequest ();

    /**
     * Copy constructor
     */
    inline  TransferAudioRequest (const TransferAudioRequest &rhs);

    /**
     * All fields constructor
     */
    inline  TransferAudioRequest (uint8 Path_);

    /**
     * Destructor
     */
    inline virtual  ~TransferAudioRequest();

    /**
     * Assignment operator
     */
    inline TransferAudioRequest& operator = (const TransferAudioRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferAudioRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferAudioRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferAudioRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferAudioRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Path"

    static const int kPath = 0;

    /**
     * Clears the field "Path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "Path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "Path".
     *
     * The possible values are:
     *                 0x00 - Transfer the call to Handsfree(Vehicle)
     *                 0x01 - Transfer the call to Audio Gateway.
     *
     * @return The value of the field "Path"
     */
    inline uint8 getPath () const;

    /**
     * Sets the value of the member "Path".
     *
     * The possible values are:
     *                 0x00 - Transfer the call to Handsfree(Vehicle)
     *                 0x01 - Transfer the call to Audio Gateway.
     *
     * @param Path The value which will be set
     */
    inline void setPath (uint8 Path_);

    static const TransferAudioRequest &getDefaultInstance();

private:

    inline void set_has_Path ();

    inline void clear_has_Path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Path;

};

/**
 * Provides the status of the SCO establishment between AG and HF.
 *
 *         Status of the SCO establishment:
 *                 0x00 - No SCO establishment between AG & HF,
 *                 0x01 - SCO is established between AG and HF,
 *                 0xFF - Default.
 */
class SCOConnectionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCOConnectionUpdate ();

    /**
     * Copy constructor
     */
    inline  SCOConnectionUpdate (const SCOConnectionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SCOConnectionUpdate (uint8 SCOConnection_);

    /**
     * Destructor
     */
    inline virtual  ~SCOConnectionUpdate();

    /**
     * Assignment operator
     */
    inline SCOConnectionUpdate& operator = (const SCOConnectionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCOConnectionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCOConnectionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCOConnectionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCOConnectionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SCOConnection"

    static const int kSCOConnection = 0;

    /**
     * Clears the field "SCOConnection".
     *
     * The field will be set to its default value. The hasSCOConnection()
     * method will return false.
     */
    inline void clearSCOConnection();

    /**
     * Checks whether the field "SCOConnection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCOConnection()). Otherwise it will return false.
     */
    inline bool hasSCOConnection () const;

    /**
     * Returns the value of the member "SCOConnection".
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @return The value of the field "SCOConnection"
     */
    inline uint8 getSCOConnection () const;

    /**
     * Sets the value of the member "SCOConnection".
     *
     * Provides the status of the SCO establishment between AG and HF.
     *
     *         Status of the SCO establishment:
     *                 0x00 - No SCO establishment between AG & HF,
     *                 0x01 - SCO is established between AG and HF,
     *                 0xFF - Default.
     *
     * @param SCOConnection The value which will be set
     */
    inline void setSCOConnection (uint8 SCOConnection_);

    static const SCOConnectionUpdate &getDefaultInstance();

private:

    inline void set_has_SCOConnection ();

    inline void clear_has_SCOConnection ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _SCOConnection;

};

/**
 * Provides the status of the SCO establishment between AG and HF.
 *
 *         Status of the SCO establishment:
 *                 0x00 - No SCO establishment between AG & HF,
 *                 0x01 - SCO is established between AG and HF,
 *                 0xFF - Default.
 */
class SCOConnectionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SCOConnectionRegister ();

    /**
     * Copy constructor
     */
    inline  SCOConnectionRegister (const SCOConnectionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SCOConnectionRegister();

    /**
     * Assignment operator
     */
    inline SCOConnectionRegister& operator = (const SCOConnectionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SCOConnectionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SCOConnectionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SCOConnectionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SCOConnectionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SCOConnectionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current state of the ringtone mute.
 *
 *         TRUE - Ringtone mute enabled.
 *         FALSE - Ringtone mute disabled [Default].
 */
class RingtoneMuteStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RingtoneMuteStateUpdate ();

    /**
     * Copy constructor
     */
    inline  RingtoneMuteStateUpdate (const RingtoneMuteStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RingtoneMuteStateUpdate (bool RingtoneMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~RingtoneMuteStateUpdate();

    /**
     * Assignment operator
     */
    inline RingtoneMuteStateUpdate& operator = (const RingtoneMuteStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RingtoneMuteState"

    static const int kRingtoneMuteState = 0;

    /**
     * Clears the field "RingtoneMuteState".
     *
     * The field will be set to its default value. The hasRingtoneMuteState()
     * method will return false.
     */
    inline void clearRingtoneMuteState();

    /**
     * Checks whether the field "RingtoneMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRingtoneMuteState()). Otherwise it will return false.
     */
    inline bool hasRingtoneMuteState () const;

    /**
     * Returns the value of the member "RingtoneMuteState".
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @return The value of the field "RingtoneMuteState"
     */
    inline bool getRingtoneMuteState () const;

    /**
     * Sets the value of the member "RingtoneMuteState".
     *
     * Provides the current state of the ringtone mute.
     *
     *         TRUE - Ringtone mute enabled.
     *         FALSE - Ringtone mute disabled [Default].
     *
     * @param RingtoneMuteState The value which will be set
     */
    inline void setRingtoneMuteState (bool RingtoneMuteState_);

    static const RingtoneMuteStateUpdate &getDefaultInstance();

private:

    inline void set_has_RingtoneMuteState ();

    inline void clear_has_RingtoneMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _RingtoneMuteState;

};

/**
 * Provides the current state of the ringtone mute.
 *
 *         TRUE - Ringtone mute enabled.
 *         FALSE - Ringtone mute disabled [Default].
 */
class RingtoneMuteStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RingtoneMuteStateRegister ();

    /**
     * Copy constructor
     */
    inline  RingtoneMuteStateRegister (const RingtoneMuteStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RingtoneMuteStateRegister();

    /**
     * Assignment operator
     */
    inline RingtoneMuteStateRegister& operator = (const RingtoneMuteStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RingtoneMuteStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RingtoneMuteStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RingtoneMuteStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RingtoneMuteStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RingtoneMuteStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Updates the current waiting mode state.
 *
 *         The possible waiting mode states are:
 *             0x00 : WAITING_MODE_IDLE [Default],
 *             0x01 : WAITING_MODE_STARTING,
 *             0x02 : WAITING_MODE_ACTIVE,
 *             0x03 : WAITING_MODE_ENDING.
 */
class WaitingModeStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaitingModeStateUpdate ();

    /**
     * Copy constructor
     */
    inline  WaitingModeStateUpdate (const WaitingModeStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WaitingModeStateUpdate (uint8 WaitingModeState_);

    /**
     * Destructor
     */
    inline virtual  ~WaitingModeStateUpdate();

    /**
     * Assignment operator
     */
    inline WaitingModeStateUpdate& operator = (const WaitingModeStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaitingModeStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaitingModeStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaitingModeStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaitingModeStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WaitingModeState"

    static const int kWaitingModeState = 0;

    /**
     * Clears the field "WaitingModeState".
     *
     * The field will be set to its default value. The hasWaitingModeState()
     * method will return false.
     */
    inline void clearWaitingModeState();

    /**
     * Checks whether the field "WaitingModeState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWaitingModeState()). Otherwise it will return false.
     */
    inline bool hasWaitingModeState () const;

    /**
     * Returns the value of the member "WaitingModeState".
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @return The value of the field "WaitingModeState"
     */
    inline uint8 getWaitingModeState () const;

    /**
     * Sets the value of the member "WaitingModeState".
     *
     * Updates the current waiting mode state.
     *
     *         The possible waiting mode states are:
     *             0x00 : WAITING_MODE_IDLE [Default],
     *             0x01 : WAITING_MODE_STARTING,
     *             0x02 : WAITING_MODE_ACTIVE,
     *             0x03 : WAITING_MODE_ENDING.
     *
     * @param WaitingModeState The value which will be set
     */
    inline void setWaitingModeState (uint8 WaitingModeState_);

    static const WaitingModeStateUpdate &getDefaultInstance();

private:

    inline void set_has_WaitingModeState ();

    inline void clear_has_WaitingModeState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _WaitingModeState;

};

/**
 * Updates the current waiting mode state.
 *
 *         The possible waiting mode states are:
 *             0x00 : WAITING_MODE_IDLE [Default],
 *             0x01 : WAITING_MODE_STARTING,
 *             0x02 : WAITING_MODE_ACTIVE,
 *             0x03 : WAITING_MODE_ENDING.
 */
class WaitingModeStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaitingModeStateRegister ();

    /**
     * Copy constructor
     */
    inline  WaitingModeStateRegister (const WaitingModeStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WaitingModeStateRegister();

    /**
     * Assignment operator
     */
    inline WaitingModeStateRegister& operator = (const WaitingModeStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaitingModeStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaitingModeStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaitingModeStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaitingModeStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WaitingModeStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _VoiceCallProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _VoiceCallProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& VoiceCallProperties_)  :
    _VoiceCallProperties (VoiceCallProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVoiceCallProperties()) {
            setVoiceCallProperties(rhs.getVoiceCallProperties());
        } else {
            clearVoiceCallProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasVoiceCallProperties() && !rhs.hasVoiceCallProperties()) || getVoiceCallProperties() == rhs.getVoiceCallProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasVoiceCallProperties() || rhs.hasVoiceCallProperties()) {
        if (getVoiceCallProperties() < rhs.getVoiceCallProperties()) return true;
        if (getVoiceCallProperties() > rhs.getVoiceCallProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearVoiceCallProperties();
}

inline void GetPropertiesResponse::clearVoiceCallProperties() {
    if (hasVoiceCallProperties()) {
         clear_has_VoiceCallProperties();
        _VoiceCallProperties.clear();
     }
}

inline bool GetPropertiesResponse::hasVoiceCallProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& GetPropertiesResponse::getVoiceCallProperties () const {
    return _VoiceCallProperties;
}

inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& GetPropertiesResponse::getVoiceCallPropertiesMutable () {
    set_has_VoiceCallProperties();
    return _VoiceCallProperties;
}

inline void GetPropertiesResponse::setVoiceCallProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::VoiceCallVariant >& VoiceCallProperties_) {
    set_has_VoiceCallProperties();
    this->_VoiceCallProperties = VoiceCallProperties_;
}

inline void GetPropertiesResponse::set_has_VoiceCallProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_VoiceCallProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MuteUnmuteRingtoneRequest::MuteUnmuteRingtoneRequest ()  :
    _MuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MuteUnmuteRingtoneRequest::MuteUnmuteRingtoneRequest (const MuteUnmuteRingtoneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _MuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MuteUnmuteRingtoneRequest::MuteUnmuteRingtoneRequest (bool MuteState_)  :
    _MuteState (MuteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MuteUnmuteRingtoneRequest::~MuteUnmuteRingtoneRequest() {
}

inline MuteUnmuteRingtoneRequest& MuteUnmuteRingtoneRequest::operator = (const MuteUnmuteRingtoneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMuteState()) {
            setMuteState(rhs.getMuteState());
        } else {
            clearMuteState();
        }
    }
    return *this;
}

inline bool MuteUnmuteRingtoneRequest::operator == (const MuteUnmuteRingtoneRequest& rhs) const {
    return (((!hasMuteState() && !rhs.hasMuteState()) || getMuteState() == rhs.getMuteState()));
}

inline bool MuteUnmuteRingtoneRequest::operator != (const MuteUnmuteRingtoneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MuteUnmuteRingtoneRequest::operator < (const MuteUnmuteRingtoneRequest& rhs) const {
    if (hasMuteState() || rhs.hasMuteState()) {
        if (getMuteState() < rhs.getMuteState()) return true;
        if (getMuteState() > rhs.getMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MuteUnmuteRingtoneRequest::clone() {
    return new MuteUnmuteRingtoneRequest(*this);
}

inline bool MuteUnmuteRingtoneRequest::operator > (const MuteUnmuteRingtoneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MuteUnmuteRingtoneRequest::clear() {
    clearMuteState();
}

inline void MuteUnmuteRingtoneRequest::clearMuteState() {
    if (hasMuteState()) {
         clear_has_MuteState();
        _MuteState = false;
     }
}

inline bool MuteUnmuteRingtoneRequest::hasMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool MuteUnmuteRingtoneRequest::getMuteState () const {
    return _MuteState;
}

inline void MuteUnmuteRingtoneRequest::setMuteState (bool MuteState_) {
    set_has_MuteState();
    this->_MuteState = MuteState_;
}

inline void MuteUnmuteRingtoneRequest::set_has_MuteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void MuteUnmuteRingtoneRequest::clear_has_MuteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DialRequest::DialRequest ()  :
    _dialInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DialRequest::DialRequest (const DialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _dialInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DialRequest::DialRequest (const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo_)  :
    _dialInfo (dialInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DialRequest::~DialRequest() {
}

inline DialRequest& DialRequest::operator = (const DialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDialInfo()) {
            setDialInfo(rhs.getDialInfo());
        } else {
            clearDialInfo();
        }
    }
    return *this;
}

inline bool DialRequest::operator == (const DialRequest& rhs) const {
    return (((!hasDialInfo() && !rhs.hasDialInfo()) || getDialInfo() == rhs.getDialInfo()));
}

inline bool DialRequest::operator != (const DialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DialRequest::operator < (const DialRequest& rhs) const {
    if (hasDialInfo() || rhs.hasDialInfo()) {
        if (getDialInfo() < rhs.getDialInfo()) return true;
        if (getDialInfo() > rhs.getDialInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DialRequest::clone() {
    return new DialRequest(*this);
}

inline bool DialRequest::operator > (const DialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DialRequest::clear() {
    clearDialInfo();
}

inline void DialRequest::clearDialInfo() {
    if (hasDialInfo()) {
         clear_has_dialInfo();
        _dialInfo.clear();
     }
}

inline bool DialRequest::hasDialInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& DialRequest::getDialInfo () const {
    return _dialInfo;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& DialRequest::getDialInfoMutable () {
    set_has_dialInfo();
    return _dialInfo;
}

inline void DialRequest::setDialInfo (const ::com::bosch::pmapp::PMAppTypeCollections::DialInfo& dialInfo_) {
    set_has_dialInfo();
    this->_dialInfo = dialInfo_;
}

inline void DialRequest::set_has_dialInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void DialRequest::clear_has_dialInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DialResponse::DialResponse ()  :
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DialResponse::DialResponse (const DialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DialResponse::DialResponse (uint8 CallInstance_)  :
    _CallInstance (CallInstance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DialResponse::~DialResponse() {
}

inline DialResponse& DialResponse::operator = (const DialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstance()) {
            setCallInstance(rhs.getCallInstance());
        } else {
            clearCallInstance();
        }
    }
    return *this;
}

inline bool DialResponse::operator == (const DialResponse& rhs) const {
    return (((!hasCallInstance() && !rhs.hasCallInstance()) || getCallInstance() == rhs.getCallInstance()));
}

inline bool DialResponse::operator != (const DialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DialResponse::operator < (const DialResponse& rhs) const {
    if (hasCallInstance() || rhs.hasCallInstance()) {
        if (getCallInstance() < rhs.getCallInstance()) return true;
        if (getCallInstance() > rhs.getCallInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DialResponse::clone() {
    return new DialResponse(*this);
}

inline bool DialResponse::operator > (const DialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DialResponse::clear() {
    clearCallInstance();
}

inline void DialResponse::clearCallInstance() {
    if (hasCallInstance()) {
         clear_has_CallInstance();
        _CallInstance = 0u;
     }
}

inline bool DialResponse::hasCallInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DialResponse::getCallInstance () const {
    return _CallInstance;
}

inline void DialResponse::setCallInstance (uint8 CallInstance_) {
    set_has_CallInstance();
    this->_CallInstance = CallInstance_;
}

inline void DialResponse::set_has_CallInstance () {
    _has_bits_[0] |= 1u << 0;
}

inline void DialResponse::clear_has_CallInstance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AcceptCallRequest::AcceptCallRequest ()  :
    _CallInstanceIn (0u),
    _Operation (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AcceptCallRequest::AcceptCallRequest (const AcceptCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstanceIn (0u),
    _Operation (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AcceptCallRequest::AcceptCallRequest (uint8 CallInstanceIn_, uint8 Operation_)  :
    _CallInstanceIn (CallInstanceIn_),
    _Operation (Operation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AcceptCallRequest::~AcceptCallRequest() {
}

inline AcceptCallRequest& AcceptCallRequest::operator = (const AcceptCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstanceIn()) {
            setCallInstanceIn(rhs.getCallInstanceIn());
        } else {
            clearCallInstanceIn();
        }
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
    }
    return *this;
}

inline bool AcceptCallRequest::operator == (const AcceptCallRequest& rhs) const {
    return (((!hasCallInstanceIn() && !rhs.hasCallInstanceIn()) || getCallInstanceIn() == rhs.getCallInstanceIn()) &&
        ((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()));
}

inline bool AcceptCallRequest::operator != (const AcceptCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AcceptCallRequest::operator < (const AcceptCallRequest& rhs) const {
    if (hasCallInstanceIn() || rhs.hasCallInstanceIn()) {
        if (getCallInstanceIn() < rhs.getCallInstanceIn()) return true;
        if (getCallInstanceIn() > rhs.getCallInstanceIn()) return false;
    }
    if (hasOperation() || rhs.hasOperation()) {
        if (getOperation() < rhs.getOperation()) return true;
        if (getOperation() > rhs.getOperation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AcceptCallRequest::clone() {
    return new AcceptCallRequest(*this);
}

inline bool AcceptCallRequest::operator > (const AcceptCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AcceptCallRequest::clear() {
    clearCallInstanceIn();
    clearOperation();
}

inline void AcceptCallRequest::clearCallInstanceIn() {
    if (hasCallInstanceIn()) {
         clear_has_CallInstanceIn();
        _CallInstanceIn = 0u;
     }
}

inline bool AcceptCallRequest::hasCallInstanceIn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AcceptCallRequest::getCallInstanceIn () const {
    return _CallInstanceIn;
}

inline void AcceptCallRequest::setCallInstanceIn (uint8 CallInstanceIn_) {
    set_has_CallInstanceIn();
    this->_CallInstanceIn = CallInstanceIn_;
}

inline void AcceptCallRequest::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = 0u;
     }
}

inline bool AcceptCallRequest::hasOperation () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AcceptCallRequest::getOperation () const {
    return _Operation;
}

inline void AcceptCallRequest::setOperation (uint8 Operation_) {
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void AcceptCallRequest::set_has_CallInstanceIn () {
    _has_bits_[0] |= 1u << 0;
}

inline void AcceptCallRequest::clear_has_CallInstanceIn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AcceptCallRequest::set_has_Operation () {
    _has_bits_[0] |= 1u << 1;
}

inline void AcceptCallRequest::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  AcceptCallResponse::AcceptCallResponse ()  :
    _CallInstanceOut (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AcceptCallResponse::AcceptCallResponse (const AcceptCallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstanceOut (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AcceptCallResponse::AcceptCallResponse (uint8 CallInstanceOut_)  :
    _CallInstanceOut (CallInstanceOut_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AcceptCallResponse::~AcceptCallResponse() {
}

inline AcceptCallResponse& AcceptCallResponse::operator = (const AcceptCallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstanceOut()) {
            setCallInstanceOut(rhs.getCallInstanceOut());
        } else {
            clearCallInstanceOut();
        }
    }
    return *this;
}

inline bool AcceptCallResponse::operator == (const AcceptCallResponse& rhs) const {
    return (((!hasCallInstanceOut() && !rhs.hasCallInstanceOut()) || getCallInstanceOut() == rhs.getCallInstanceOut()));
}

inline bool AcceptCallResponse::operator != (const AcceptCallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool AcceptCallResponse::operator < (const AcceptCallResponse& rhs) const {
    if (hasCallInstanceOut() || rhs.hasCallInstanceOut()) {
        if (getCallInstanceOut() < rhs.getCallInstanceOut()) return true;
        if (getCallInstanceOut() > rhs.getCallInstanceOut()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AcceptCallResponse::clone() {
    return new AcceptCallResponse(*this);
}

inline bool AcceptCallResponse::operator > (const AcceptCallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AcceptCallResponse::clear() {
    clearCallInstanceOut();
}

inline void AcceptCallResponse::clearCallInstanceOut() {
    if (hasCallInstanceOut()) {
         clear_has_CallInstanceOut();
        _CallInstanceOut = 0u;
     }
}

inline bool AcceptCallResponse::hasCallInstanceOut () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AcceptCallResponse::getCallInstanceOut () const {
    return _CallInstanceOut;
}

inline void AcceptCallResponse::setCallInstanceOut (uint8 CallInstanceOut_) {
    set_has_CallInstanceOut();
    this->_CallInstanceOut = CallInstanceOut_;
}

inline void AcceptCallResponse::set_has_CallInstanceOut () {
    _has_bits_[0] |= 1u << 0;
}

inline void AcceptCallResponse::clear_has_CallInstanceOut () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SwapCallRequest::SwapCallRequest ()  :
    _Operation (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SwapCallRequest::SwapCallRequest (const SwapCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Operation (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SwapCallRequest::SwapCallRequest (uint8 Operation_)  :
    _Operation (Operation_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SwapCallRequest::~SwapCallRequest() {
}

inline SwapCallRequest& SwapCallRequest::operator = (const SwapCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOperation()) {
            setOperation(rhs.getOperation());
        } else {
            clearOperation();
        }
    }
    return *this;
}

inline bool SwapCallRequest::operator == (const SwapCallRequest& rhs) const {
    return (((!hasOperation() && !rhs.hasOperation()) || getOperation() == rhs.getOperation()));
}

inline bool SwapCallRequest::operator != (const SwapCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SwapCallRequest::operator < (const SwapCallRequest& rhs) const {
    if (hasOperation() || rhs.hasOperation()) {
        if (getOperation() < rhs.getOperation()) return true;
        if (getOperation() > rhs.getOperation()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SwapCallRequest::clone() {
    return new SwapCallRequest(*this);
}

inline bool SwapCallRequest::operator > (const SwapCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SwapCallRequest::clear() {
    clearOperation();
}

inline void SwapCallRequest::clearOperation() {
    if (hasOperation()) {
         clear_has_Operation();
        _Operation = 0u;
     }
}

inline bool SwapCallRequest::hasOperation () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SwapCallRequest::getOperation () const {
    return _Operation;
}

inline void SwapCallRequest::setOperation (uint8 Operation_) {
    set_has_Operation();
    this->_Operation = Operation_;
}

inline void SwapCallRequest::set_has_Operation () {
    _has_bits_[0] |= 1u << 0;
}

inline void SwapCallRequest::clear_has_Operation () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HangUpCallRequest::HangUpCallRequest ()  :
    _CallInstanceIn (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HangUpCallRequest::HangUpCallRequest (const HangUpCallRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstanceIn (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HangUpCallRequest::HangUpCallRequest (uint8 CallInstanceIn_)  :
    _CallInstanceIn (CallInstanceIn_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HangUpCallRequest::~HangUpCallRequest() {
}

inline HangUpCallRequest& HangUpCallRequest::operator = (const HangUpCallRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstanceIn()) {
            setCallInstanceIn(rhs.getCallInstanceIn());
        } else {
            clearCallInstanceIn();
        }
    }
    return *this;
}

inline bool HangUpCallRequest::operator == (const HangUpCallRequest& rhs) const {
    return (((!hasCallInstanceIn() && !rhs.hasCallInstanceIn()) || getCallInstanceIn() == rhs.getCallInstanceIn()));
}

inline bool HangUpCallRequest::operator != (const HangUpCallRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool HangUpCallRequest::operator < (const HangUpCallRequest& rhs) const {
    if (hasCallInstanceIn() || rhs.hasCallInstanceIn()) {
        if (getCallInstanceIn() < rhs.getCallInstanceIn()) return true;
        if (getCallInstanceIn() > rhs.getCallInstanceIn()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HangUpCallRequest::clone() {
    return new HangUpCallRequest(*this);
}

inline bool HangUpCallRequest::operator > (const HangUpCallRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HangUpCallRequest::clear() {
    clearCallInstanceIn();
}

inline void HangUpCallRequest::clearCallInstanceIn() {
    if (hasCallInstanceIn()) {
         clear_has_CallInstanceIn();
        _CallInstanceIn = 0u;
     }
}

inline bool HangUpCallRequest::hasCallInstanceIn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 HangUpCallRequest::getCallInstanceIn () const {
    return _CallInstanceIn;
}

inline void HangUpCallRequest::setCallInstanceIn (uint8 CallInstanceIn_) {
    set_has_CallInstanceIn();
    this->_CallInstanceIn = CallInstanceIn_;
}

inline void HangUpCallRequest::set_has_CallInstanceIn () {
    _has_bits_[0] |= 1u << 0;
}

inline void HangUpCallRequest::clear_has_CallInstanceIn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  HangUpCallResponse::HangUpCallResponse ()  :
    _CallInstanceOut (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HangUpCallResponse::HangUpCallResponse (const HangUpCallResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstanceOut (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HangUpCallResponse::HangUpCallResponse (uint8 CallInstanceOut_)  :
    _CallInstanceOut (CallInstanceOut_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HangUpCallResponse::~HangUpCallResponse() {
}

inline HangUpCallResponse& HangUpCallResponse::operator = (const HangUpCallResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstanceOut()) {
            setCallInstanceOut(rhs.getCallInstanceOut());
        } else {
            clearCallInstanceOut();
        }
    }
    return *this;
}

inline bool HangUpCallResponse::operator == (const HangUpCallResponse& rhs) const {
    return (((!hasCallInstanceOut() && !rhs.hasCallInstanceOut()) || getCallInstanceOut() == rhs.getCallInstanceOut()));
}

inline bool HangUpCallResponse::operator != (const HangUpCallResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool HangUpCallResponse::operator < (const HangUpCallResponse& rhs) const {
    if (hasCallInstanceOut() || rhs.hasCallInstanceOut()) {
        if (getCallInstanceOut() < rhs.getCallInstanceOut()) return true;
        if (getCallInstanceOut() > rhs.getCallInstanceOut()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HangUpCallResponse::clone() {
    return new HangUpCallResponse(*this);
}

inline bool HangUpCallResponse::operator > (const HangUpCallResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HangUpCallResponse::clear() {
    clearCallInstanceOut();
}

inline void HangUpCallResponse::clearCallInstanceOut() {
    if (hasCallInstanceOut()) {
         clear_has_CallInstanceOut();
        _CallInstanceOut = 0u;
     }
}

inline bool HangUpCallResponse::hasCallInstanceOut () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 HangUpCallResponse::getCallInstanceOut () const {
    return _CallInstanceOut;
}

inline void HangUpCallResponse::setCallInstanceOut (uint8 CallInstanceOut_) {
    set_has_CallInstanceOut();
    this->_CallInstanceOut = CallInstanceOut_;
}

inline void HangUpCallResponse::set_has_CallInstanceOut () {
    _has_bits_[0] |= 1u << 0;
}

inline void HangUpCallResponse::clear_has_CallInstanceOut () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeedDialRequest::SpeedDialRequest ()  :
    _MemDialIndex (0u),
    _HideCallerID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedDialRequest::SpeedDialRequest (const SpeedDialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _MemDialIndex (0u),
    _HideCallerID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedDialRequest::SpeedDialRequest (uint8 MemDialIndex_, uint8 HideCallerID_)  :
    _MemDialIndex (MemDialIndex_),
    _HideCallerID (HideCallerID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeedDialRequest::~SpeedDialRequest() {
}

inline SpeedDialRequest& SpeedDialRequest::operator = (const SpeedDialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMemDialIndex()) {
            setMemDialIndex(rhs.getMemDialIndex());
        } else {
            clearMemDialIndex();
        }
        if (rhs.hasHideCallerID()) {
            setHideCallerID(rhs.getHideCallerID());
        } else {
            clearHideCallerID();
        }
    }
    return *this;
}

inline bool SpeedDialRequest::operator == (const SpeedDialRequest& rhs) const {
    return (((!hasMemDialIndex() && !rhs.hasMemDialIndex()) || getMemDialIndex() == rhs.getMemDialIndex()) &&
        ((!hasHideCallerID() && !rhs.hasHideCallerID()) || getHideCallerID() == rhs.getHideCallerID()));
}

inline bool SpeedDialRequest::operator != (const SpeedDialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedDialRequest::operator < (const SpeedDialRequest& rhs) const {
    if (hasMemDialIndex() || rhs.hasMemDialIndex()) {
        if (getMemDialIndex() < rhs.getMemDialIndex()) return true;
        if (getMemDialIndex() > rhs.getMemDialIndex()) return false;
    }
    if (hasHideCallerID() || rhs.hasHideCallerID()) {
        if (getHideCallerID() < rhs.getHideCallerID()) return true;
        if (getHideCallerID() > rhs.getHideCallerID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeedDialRequest::clone() {
    return new SpeedDialRequest(*this);
}

inline bool SpeedDialRequest::operator > (const SpeedDialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedDialRequest::clear() {
    clearMemDialIndex();
    clearHideCallerID();
}

inline void SpeedDialRequest::clearMemDialIndex() {
    if (hasMemDialIndex()) {
         clear_has_MemDialIndex();
        _MemDialIndex = 0u;
     }
}

inline bool SpeedDialRequest::hasMemDialIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SpeedDialRequest::getMemDialIndex () const {
    return _MemDialIndex;
}

inline void SpeedDialRequest::setMemDialIndex (uint8 MemDialIndex_) {
    set_has_MemDialIndex();
    this->_MemDialIndex = MemDialIndex_;
}

inline void SpeedDialRequest::clearHideCallerID() {
    if (hasHideCallerID()) {
         clear_has_HideCallerID();
        _HideCallerID = 0u;
     }
}

inline bool SpeedDialRequest::hasHideCallerID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SpeedDialRequest::getHideCallerID () const {
    return _HideCallerID;
}

inline void SpeedDialRequest::setHideCallerID (uint8 HideCallerID_) {
    set_has_HideCallerID();
    this->_HideCallerID = HideCallerID_;
}

inline void SpeedDialRequest::set_has_MemDialIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeedDialRequest::clear_has_MemDialIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SpeedDialRequest::set_has_HideCallerID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SpeedDialRequest::clear_has_HideCallerID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SpeedDialResponse::SpeedDialResponse ()  :
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeedDialResponse::SpeedDialResponse (const SpeedDialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _CallInstance (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeedDialResponse::SpeedDialResponse (uint8 CallInstance_)  :
    _CallInstance (CallInstance_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeedDialResponse::~SpeedDialResponse() {
}

inline SpeedDialResponse& SpeedDialResponse::operator = (const SpeedDialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCallInstance()) {
            setCallInstance(rhs.getCallInstance());
        } else {
            clearCallInstance();
        }
    }
    return *this;
}

inline bool SpeedDialResponse::operator == (const SpeedDialResponse& rhs) const {
    return (((!hasCallInstance() && !rhs.hasCallInstance()) || getCallInstance() == rhs.getCallInstance()));
}

inline bool SpeedDialResponse::operator != (const SpeedDialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeedDialResponse::operator < (const SpeedDialResponse& rhs) const {
    if (hasCallInstance() || rhs.hasCallInstance()) {
        if (getCallInstance() < rhs.getCallInstance()) return true;
        if (getCallInstance() > rhs.getCallInstance()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeedDialResponse::clone() {
    return new SpeedDialResponse(*this);
}

inline bool SpeedDialResponse::operator > (const SpeedDialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeedDialResponse::clear() {
    clearCallInstance();
}

inline void SpeedDialResponse::clearCallInstance() {
    if (hasCallInstance()) {
         clear_has_CallInstance();
        _CallInstance = 0u;
     }
}

inline bool SpeedDialResponse::hasCallInstance () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SpeedDialResponse::getCallInstance () const {
    return _CallInstance;
}

inline void SpeedDialResponse::setCallInstance (uint8 CallInstance_) {
    set_has_CallInstance();
    this->_CallInstance = CallInstance_;
}

inline void SpeedDialResponse::set_has_CallInstance () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeedDialResponse::clear_has_CallInstance () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendDTMFRequest::SendDTMFRequest ()  :
    _Tones ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendDTMFRequest::SendDTMFRequest (const SendDTMFRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Tones ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendDTMFRequest::SendDTMFRequest (const ::std::string& Tones_)  :
    _Tones (Tones_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tones_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendDTMFRequest::~SendDTMFRequest() {
}

inline SendDTMFRequest& SendDTMFRequest::operator = (const SendDTMFRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTones()) {
            setTones(rhs.getTones());
        } else {
            clearTones();
        }
    }
    return *this;
}

inline bool SendDTMFRequest::operator == (const SendDTMFRequest& rhs) const {
    return (((!hasTones() && !rhs.hasTones()) || getTones() == rhs.getTones()));
}

inline bool SendDTMFRequest::operator != (const SendDTMFRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendDTMFRequest::operator < (const SendDTMFRequest& rhs) const {
    if (hasTones() || rhs.hasTones()) {
        if (getTones() < rhs.getTones()) return true;
        if (getTones() > rhs.getTones()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendDTMFRequest::clone() {
    return new SendDTMFRequest(*this);
}

inline bool SendDTMFRequest::operator > (const SendDTMFRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendDTMFRequest::clear() {
    clearTones();
}

inline void SendDTMFRequest::clearTones() {
    if (hasTones()) {
         clear_has_Tones();
        _Tones.clear();
     }
}

inline bool SendDTMFRequest::hasTones () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SendDTMFRequest::getTones () const {
    return _Tones;
}

inline ::std::string& SendDTMFRequest::getTonesMutable () {
    set_has_Tones();
    return _Tones;
}

inline void SendDTMFRequest::setTones (const ::std::string& Tones_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tones_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tones();
    this->_Tones = Tones_;
}

inline void SendDTMFRequest::setTones (const char* Tones_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Tones_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tones();
    this->_Tones.assign(Tones_);
}

inline void SendDTMFRequest::setTones (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Tones();
    this->_Tones.assign(value, size);
}

inline void SendDTMFRequest::set_has_Tones () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendDTMFRequest::clear_has_Tones () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartStopWaitingModeRequest::StartStopWaitingModeRequest ()  :
    _WaitingModeAction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartStopWaitingModeRequest::StartStopWaitingModeRequest (const StartStopWaitingModeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _WaitingModeAction (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartStopWaitingModeRequest::StartStopWaitingModeRequest (uint8 WaitingModeAction_)  :
    _WaitingModeAction (WaitingModeAction_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartStopWaitingModeRequest::~StartStopWaitingModeRequest() {
}

inline StartStopWaitingModeRequest& StartStopWaitingModeRequest::operator = (const StartStopWaitingModeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWaitingModeAction()) {
            setWaitingModeAction(rhs.getWaitingModeAction());
        } else {
            clearWaitingModeAction();
        }
    }
    return *this;
}

inline bool StartStopWaitingModeRequest::operator == (const StartStopWaitingModeRequest& rhs) const {
    return (((!hasWaitingModeAction() && !rhs.hasWaitingModeAction()) || getWaitingModeAction() == rhs.getWaitingModeAction()));
}

inline bool StartStopWaitingModeRequest::operator != (const StartStopWaitingModeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartStopWaitingModeRequest::operator < (const StartStopWaitingModeRequest& rhs) const {
    if (hasWaitingModeAction() || rhs.hasWaitingModeAction()) {
        if (getWaitingModeAction() < rhs.getWaitingModeAction()) return true;
        if (getWaitingModeAction() > rhs.getWaitingModeAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartStopWaitingModeRequest::clone() {
    return new StartStopWaitingModeRequest(*this);
}

inline bool StartStopWaitingModeRequest::operator > (const StartStopWaitingModeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartStopWaitingModeRequest::clear() {
    clearWaitingModeAction();
}

inline void StartStopWaitingModeRequest::clearWaitingModeAction() {
    if (hasWaitingModeAction()) {
         clear_has_WaitingModeAction();
        _WaitingModeAction = 0u;
     }
}

inline bool StartStopWaitingModeRequest::hasWaitingModeAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 StartStopWaitingModeRequest::getWaitingModeAction () const {
    return _WaitingModeAction;
}

inline void StartStopWaitingModeRequest::setWaitingModeAction (uint8 WaitingModeAction_) {
    set_has_WaitingModeAction();
    this->_WaitingModeAction = WaitingModeAction_;
}

inline void StartStopWaitingModeRequest::set_has_WaitingModeAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartStopWaitingModeRequest::clear_has_WaitingModeAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TransferAudioRequest::TransferAudioRequest ()  :
    _Path (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TransferAudioRequest::TransferAudioRequest (const TransferAudioRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Path (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TransferAudioRequest::TransferAudioRequest (uint8 Path_)  :
    _Path (Path_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TransferAudioRequest::~TransferAudioRequest() {
}

inline TransferAudioRequest& TransferAudioRequest::operator = (const TransferAudioRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool TransferAudioRequest::operator == (const TransferAudioRequest& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool TransferAudioRequest::operator != (const TransferAudioRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool TransferAudioRequest::operator < (const TransferAudioRequest& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TransferAudioRequest::clone() {
    return new TransferAudioRequest(*this);
}

inline bool TransferAudioRequest::operator > (const TransferAudioRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TransferAudioRequest::clear() {
    clearPath();
}

inline void TransferAudioRequest::clearPath() {
    if (hasPath()) {
         clear_has_Path();
        _Path = 0u;
     }
}

inline bool TransferAudioRequest::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TransferAudioRequest::getPath () const {
    return _Path;
}

inline void TransferAudioRequest::setPath (uint8 Path_) {
    set_has_Path();
    this->_Path = Path_;
}

inline void TransferAudioRequest::set_has_Path () {
    _has_bits_[0] |= 1u << 0;
}

inline void TransferAudioRequest::clear_has_Path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SCOConnectionUpdate::SCOConnectionUpdate ()  :
    _SCOConnection (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SCOConnectionUpdate::SCOConnectionUpdate (const SCOConnectionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SCOConnection (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SCOConnectionUpdate::SCOConnectionUpdate (uint8 SCOConnection_)  :
    _SCOConnection (SCOConnection_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SCOConnectionUpdate::~SCOConnectionUpdate() {
}

inline SCOConnectionUpdate& SCOConnectionUpdate::operator = (const SCOConnectionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSCOConnection()) {
            setSCOConnection(rhs.getSCOConnection());
        } else {
            clearSCOConnection();
        }
    }
    return *this;
}

inline bool SCOConnectionUpdate::operator == (const SCOConnectionUpdate& rhs) const {
    return (((!hasSCOConnection() && !rhs.hasSCOConnection()) || getSCOConnection() == rhs.getSCOConnection()));
}

inline bool SCOConnectionUpdate::operator != (const SCOConnectionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SCOConnectionUpdate::operator < (const SCOConnectionUpdate& rhs) const {
    if (hasSCOConnection() || rhs.hasSCOConnection()) {
        if (getSCOConnection() < rhs.getSCOConnection()) return true;
        if (getSCOConnection() > rhs.getSCOConnection()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SCOConnectionUpdate::clone() {
    return new SCOConnectionUpdate(*this);
}

inline bool SCOConnectionUpdate::operator > (const SCOConnectionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SCOConnectionUpdate::clear() {
    clearSCOConnection();
}

inline void SCOConnectionUpdate::clearSCOConnection() {
    if (hasSCOConnection()) {
         clear_has_SCOConnection();
        _SCOConnection = 0u;
     }
}

inline bool SCOConnectionUpdate::hasSCOConnection () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SCOConnectionUpdate::getSCOConnection () const {
    return _SCOConnection;
}

inline void SCOConnectionUpdate::setSCOConnection (uint8 SCOConnection_) {
    set_has_SCOConnection();
    this->_SCOConnection = SCOConnection_;
}

inline void SCOConnectionUpdate::set_has_SCOConnection () {
    _has_bits_[0] |= 1u << 0;
}

inline void SCOConnectionUpdate::clear_has_SCOConnection () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SCOConnectionRegister::SCOConnectionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SCOConnectionRegister::SCOConnectionRegister (const SCOConnectionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SCOConnectionRegister::~SCOConnectionRegister() {
}

inline SCOConnectionRegister& SCOConnectionRegister::operator = (const SCOConnectionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SCOConnectionRegister::operator == (const SCOConnectionRegister& ) const {
    return true;
}

inline bool SCOConnectionRegister::operator != (const SCOConnectionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SCOConnectionRegister::operator < (const SCOConnectionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SCOConnectionRegister::clone() {
    return new SCOConnectionRegister(*this);
}

inline bool SCOConnectionRegister::operator > (const SCOConnectionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SCOConnectionRegister::clear() {
}

inline  RingtoneMuteStateUpdate::RingtoneMuteStateUpdate ()  :
    _RingtoneMuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RingtoneMuteStateUpdate::RingtoneMuteStateUpdate (const RingtoneMuteStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RingtoneMuteState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RingtoneMuteStateUpdate::RingtoneMuteStateUpdate (bool RingtoneMuteState_)  :
    _RingtoneMuteState (RingtoneMuteState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RingtoneMuteStateUpdate::~RingtoneMuteStateUpdate() {
}

inline RingtoneMuteStateUpdate& RingtoneMuteStateUpdate::operator = (const RingtoneMuteStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRingtoneMuteState()) {
            setRingtoneMuteState(rhs.getRingtoneMuteState());
        } else {
            clearRingtoneMuteState();
        }
    }
    return *this;
}

inline bool RingtoneMuteStateUpdate::operator == (const RingtoneMuteStateUpdate& rhs) const {
    return (((!hasRingtoneMuteState() && !rhs.hasRingtoneMuteState()) || getRingtoneMuteState() == rhs.getRingtoneMuteState()));
}

inline bool RingtoneMuteStateUpdate::operator != (const RingtoneMuteStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RingtoneMuteStateUpdate::operator < (const RingtoneMuteStateUpdate& rhs) const {
    if (hasRingtoneMuteState() || rhs.hasRingtoneMuteState()) {
        if (getRingtoneMuteState() < rhs.getRingtoneMuteState()) return true;
        if (getRingtoneMuteState() > rhs.getRingtoneMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RingtoneMuteStateUpdate::clone() {
    return new RingtoneMuteStateUpdate(*this);
}

inline bool RingtoneMuteStateUpdate::operator > (const RingtoneMuteStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RingtoneMuteStateUpdate::clear() {
    clearRingtoneMuteState();
}

inline void RingtoneMuteStateUpdate::clearRingtoneMuteState() {
    if (hasRingtoneMuteState()) {
         clear_has_RingtoneMuteState();
        _RingtoneMuteState = false;
     }
}

inline bool RingtoneMuteStateUpdate::hasRingtoneMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RingtoneMuteStateUpdate::getRingtoneMuteState () const {
    return _RingtoneMuteState;
}

inline void RingtoneMuteStateUpdate::setRingtoneMuteState (bool RingtoneMuteState_) {
    set_has_RingtoneMuteState();
    this->_RingtoneMuteState = RingtoneMuteState_;
}

inline void RingtoneMuteStateUpdate::set_has_RingtoneMuteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void RingtoneMuteStateUpdate::clear_has_RingtoneMuteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RingtoneMuteStateRegister::RingtoneMuteStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RingtoneMuteStateRegister::RingtoneMuteStateRegister (const RingtoneMuteStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RingtoneMuteStateRegister::~RingtoneMuteStateRegister() {
}

inline RingtoneMuteStateRegister& RingtoneMuteStateRegister::operator = (const RingtoneMuteStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RingtoneMuteStateRegister::operator == (const RingtoneMuteStateRegister& ) const {
    return true;
}

inline bool RingtoneMuteStateRegister::operator != (const RingtoneMuteStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RingtoneMuteStateRegister::operator < (const RingtoneMuteStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RingtoneMuteStateRegister::clone() {
    return new RingtoneMuteStateRegister(*this);
}

inline bool RingtoneMuteStateRegister::operator > (const RingtoneMuteStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RingtoneMuteStateRegister::clear() {
}

inline  WaitingModeStateUpdate::WaitingModeStateUpdate ()  :
    _WaitingModeState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WaitingModeStateUpdate::WaitingModeStateUpdate (const WaitingModeStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WaitingModeState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WaitingModeStateUpdate::WaitingModeStateUpdate (uint8 WaitingModeState_)  :
    _WaitingModeState (WaitingModeState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WaitingModeStateUpdate::~WaitingModeStateUpdate() {
}

inline WaitingModeStateUpdate& WaitingModeStateUpdate::operator = (const WaitingModeStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWaitingModeState()) {
            setWaitingModeState(rhs.getWaitingModeState());
        } else {
            clearWaitingModeState();
        }
    }
    return *this;
}

inline bool WaitingModeStateUpdate::operator == (const WaitingModeStateUpdate& rhs) const {
    return (((!hasWaitingModeState() && !rhs.hasWaitingModeState()) || getWaitingModeState() == rhs.getWaitingModeState()));
}

inline bool WaitingModeStateUpdate::operator != (const WaitingModeStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WaitingModeStateUpdate::operator < (const WaitingModeStateUpdate& rhs) const {
    if (hasWaitingModeState() || rhs.hasWaitingModeState()) {
        if (getWaitingModeState() < rhs.getWaitingModeState()) return true;
        if (getWaitingModeState() > rhs.getWaitingModeState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WaitingModeStateUpdate::clone() {
    return new WaitingModeStateUpdate(*this);
}

inline bool WaitingModeStateUpdate::operator > (const WaitingModeStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WaitingModeStateUpdate::clear() {
    clearWaitingModeState();
}

inline void WaitingModeStateUpdate::clearWaitingModeState() {
    if (hasWaitingModeState()) {
         clear_has_WaitingModeState();
        _WaitingModeState = 0u;
     }
}

inline bool WaitingModeStateUpdate::hasWaitingModeState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 WaitingModeStateUpdate::getWaitingModeState () const {
    return _WaitingModeState;
}

inline void WaitingModeStateUpdate::setWaitingModeState (uint8 WaitingModeState_) {
    set_has_WaitingModeState();
    this->_WaitingModeState = WaitingModeState_;
}

inline void WaitingModeStateUpdate::set_has_WaitingModeState () {
    _has_bits_[0] |= 1u << 0;
}

inline void WaitingModeStateUpdate::clear_has_WaitingModeState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WaitingModeStateRegister::WaitingModeStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WaitingModeStateRegister::WaitingModeStateRegister (const WaitingModeStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WaitingModeStateRegister::~WaitingModeStateRegister() {
}

inline WaitingModeStateRegister& WaitingModeStateRegister::operator = (const WaitingModeStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WaitingModeStateRegister::operator == (const WaitingModeStateRegister& ) const {
    return true;
}

inline bool WaitingModeStateRegister::operator != (const WaitingModeStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WaitingModeStateRegister::operator < (const WaitingModeStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WaitingModeStateRegister::clone() {
    return new WaitingModeStateRegister(*this);
}

inline bool WaitingModeStateRegister::operator > (const WaitingModeStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WaitingModeStateRegister::clear() {
}

} // namespace VoiceCall
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_VOICECALL_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
