#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_PMAPPTYPECOLLECTIONS_H
#define COM_BOSCH_PMAPP_PMAPPTYPECOLLECTIONS_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * PMAppTypeCollections include all the user-defined types that are used in the fidl files of PM Application.
 *
 *     Note:
 *     [1]
 *         TODO: Definition of the "Paired device" to be rephrased.
 *         - Paired device:
 *             From Phone Call Manager perspective, the paired device is the one which is paired and
 *             was HFP connected at least once with the vehicle HU.
 *     [2]
 *         - Active device:
 *             It is a HFP connected device for which
 *               -the SCO(Synchronous Connection Oriented) link could be established and
 *               -the phone call audio or Bluetooth Voice Recognition(BT-VR) audio shall be streamed
 *             between the AG and the HU speakers.
 *         - Passive device:
 *             It is a HFP connected device for which the SCO link shall not be established between AG and vehicle HU and
 *             hence the audio streaming is not possible.
 *     [3]- The string "All" is case-insensitive.
 *
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 *
 *     Limitations:
 *     1. The union inheritance is not supported by ASF Franca generator as of now. Hence the union types are redefined in certain cases.
 *     2. Multiple variants (unions) are defined in the same file instead of defining all the variants(unions) collectively under one single union.
 *        This is due to the cyclic dependency error that occurred when generating D-Bus files.
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace PMAppTypeCollections {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class StructofStringUInt8;

class SystemWideRingtonesListType;

class DeviceRingtoneInfo;

class OnOffSetting;

class DeviceObjectPathInfo;

class HfpManagerVariant;

class DeviceInfoVariant;

class BaseTypesVariant;

class DeviceCallsList;

class CallStatusVariant;

class VoiceCallManagerVariant;

class VoiceCallVariant;

class VoiceRecognitionVariant;

// type definitions
/**
 * This struct has the Ringtone ID and the corresponding name of the ringtone.
 *         Parameters description:
 *             -UInt8Value:-
 *                 Unique ID of the Ringtone.
 *                 RingtoneID Range - 0x01 - 0xFF.
 *                   0x00 - Reserved,
 *                   0x01 - InbandRingtone,
 *                   0x02 - 0xFF - SystemRingtones.
 *             -StringValue:-
 *                 Name of the Ringtone.
 */
typedef StructofStringUInt8 RingtoneInfo;

/**
 * The possible keys and their description are:
 *         "FilePathNB": String
 *             Waiting Mode Narrow Band audio file path
 *         "FilePathWB": String
 *             Waiting Mode Wide Band audio file path
 */
typedef ::std::map< ::std::string, ::std::string > WaitingModeFilePathType;

/**
 * This struct gives information about the HFP role(Active or Passive) of the HFP connected device.
 *         Parameters description:
 *             -UInt8Value:-
 *                  Current HFP role of the device.
 *                    0x00 - Passive Device[2]
 *                    0x01 - Active Device[2]
 *                    0xFF - Default
 *             -StringValue:-
 *                 BT Address of the HFP connected device.
 */
typedef StructofStringUInt8 HfpRoleInfo;

/**
 * This dict describes a HFP Manager event.
 *         EventDetailName(Event parameter name) is mapped to EventDetailInformation(Event parameter value).
 *
 *         The possible parameters are listed:
 *         -"EventName": String
 *             (eg. IncomingCallRejected, OutgoingCallFailed)
 *         -"Reason": String
 *             (E.X. WaitingModeIsActive,..)
 *         -"DeviceAddress": String
 *             (BT address of the HFP connected device)
 *         -"FirstName": String
 *             (First Name string associated with the telephone number. For Outgoing calls this Name is the one which
 *             	has been provided in Dial interface)
 *         -"LastName": String
 *             (Last Name string associated with the telephone number. For Outgoing calls this Name is the one which
 *             	has been provided in Dial interface)
 *         -"TelephoneNumber": String
 *             (Dialed or received contact number)
 */
typedef ::std::map< ::std::string, ::std::string > EventDetailsType;

/**
 * This is a structure containing voice mail number and its type.
 *         Parameters description:
 *             -UInt8Value:-
 *                 The type of subscriber number
 *                   0x00 : Unknown,
 *                   0x01 : International,
 *                   0x02 : National,
 *                   0x03 : Network,
 *                   0x04 : Dedicated.
 *             -StringValue:-
 *                 Subscriber Phone Number.
 */
typedef StructofStringUInt8 VoiceMail;

/**
 * This will give information about a call in the HFP connected device.
 *
 *         This dict(map) will have the following key and value-
 *         "String"- Name of the CallInfo parameter.
 *         BaseTypesVariant- Value of that parameter.
 *             The matching type for a "BaseTypesVariant" in DBus introspection is Union in FIDL.
 *             The union "BaseTypesVariant" defined in this file includes all the basic types supported by FIDL.
 *             The possible "BaseTypesVariant" elements are the types of the "CallInfo" parameters.
 *
 *         The possible parameters(keys) of CallInfo and it corresponding types are:
 *             "Instance": UInt8
 *             "Status": String
 *                 The possible values of "Status" are "Idle", "Alerting", "Dialing", "Active", "Held", "Incoming", "Waiting", "Conference", "Disconnecting"
 *             "DurationHr": UInt8
 *                 Hour component of call duration, call duration is updated for the states - Active, held, conference till IDLE.
 *             "DurationMin": UInt8
 *                 Minute component of call duration, call duration is updated for the states - Active, held, conference till IDLE.
 *             "DurationSec": UInt8
 *                 Seconds component of call duration, call duration is updated for the states - Active, held, conference till IDLE.
 *             "TelephoneNumber": String
 *             "FirstName": String
 *                 First Name string associated with the telephone number. For Outgoing calls this Name is the one which has been provided in Dial interface.
 *             "LastName": String
 *                 Last Name string associated with the telephone number. For Outgoing calls this Name is the one which has been provided in Dial interface.
 *             "ContactId": UInt64
 *                 This is the globally unique ID for a particular contact. The ID is unique across all currently HFP connected devices.
 *             "Mode": UInt8
 *                 The possible values of "Mode" are :
 *                   0x00 - PM_CALL_MODE_UNKNOWN,
 *                   0x01 - PM_CALL_MODE_VOICE,
 *                   0x02 - PM_CALL_MODE_DATA,
 *                   0x03 - PM_CALL_MODE_FAX.
 *             "Type": UInt8
 *                 The possible values of "Type" are :
 *                   0x00 - PM_CALL_TYPE_UNKNOWN,
 *                   0x01 - PM_CALL_TYPE_INTERNATIONAL,
 *                   0x02 - PM_CALL_TYPE_NATIONAL,
 *                   0x03 - PM_CALL_TYPE_NETWORK,
 *                   0x04 - PM_CALL_TYPE_DEDICATED.
 *             "Direction": UInt8
 *                 The possible values of "Direction" are :
 *                   0x00 - PM_CALL_DIRECTION_UNKNOWN,
 *                   0x01 - PM_CALL_DIRECTION_INCOMING,
 *                   0x02 - PM_CALL_DIRECTION_OUTGOING.
 */
typedef ::std::map< ::std::string, BaseTypesVariant > CallInfo;

/**
 * This map contains information about the input parameters of the "Dial" method.
 *
 *         The dict will have the following key and value:-
 *           String - Name of the DialInfo parameter.
 *           Variant - Value of the DialInfo parameter
 *
 *         The DialInfo parameters(keys) with their corresponding types(of values) are:
 *              - TelephoneNumber: String
 *                  Phone number which is dialed.
 *              - FirstName: String
 *                  FirstName parameter can be set by the client if required or can be left empty. If set, this
 *                  name shall be used in the CallStatusList attribute (of the VoiceCallManager interface) update.
 *              - LastName: String
 *                  LastName parameter can be set by the client if required or can be left empty. If set, this
 *                  name shall be used in the CallStatusList attribute (of the VoiceCallManager interface) update.
 *              - HideCallerID: UInt8
 *                  The possible values are:
 *                    0x00- Shows the CallerID,
 *                    0x01- Hides the CallerID,
 *                    0xFF- Default (Network) mode is used.
 *              - ContactId: UInt64
 *                  This is the globally unique ID for a particular contact. The ID is unique across all currently
 *                  HFP connected devices.
 *
 *         Note:
 *          - The matching to a "Variant" type in DBus introspection is type - Union in FIDL.
 *          - The union "Variant" defined in this file includes all the basic types supported by FIDL
 *             along with user defined types.
 *          - The possible Variant elements shall be any of the "DialInfo" parameter's type.
 */
typedef ::std::map< ::std::string, BaseTypesVariant > DialInfo;

/**
 * This map contains information about the parameters of "EnhancedVoiceRecognitionFeature" attribute.
 *
 *         The Dict will have the following key and value:
 *           String- Name of the EnhancedVoiceRecognitionFeature's parameter.
 *           BaseTypesVariant- Value of that parameter
 *
 *         The possible "EnhancedVoiceRecognitionFeature" parameters(keys) and the corresponding types are:
 *
 *             Feature: String
 *               -The possible values are:
 *                 "Siri"
 *                 "Google Voice"
 *                 "Windows Speech Recognition"
 *                 "Amazon Alexa"
 *                 "" [Default]
 *                   Note:-The values other than Siri are currently not updated from AG and therefore are reserved values.
 *                   In future if AG updates the feature availability, PM shall notify the clients.
 *
 *             AvailabilityStatus: UInt8
 *               -Availability state of the Enhanced Voice Recognition Feature on the Audio Gateway.
 *               -The possible values are:
 *                 0x00 - Default
 *                 0x01 - Feature is available but disabled in Audio Gateway.
 *
 *         Note:
 *           - The matching type to "BaseTypesVariant" type in DBus introspection is Union in FIDL
 *           - The union "BaseTypesVariant" defined in this file includes all the basic types supported by FIDL
 *           - The possible "BaseTypesVariant" elements shall be any of the "EnhancedVoiceRecognitionFeature" parameter's type.
 */
typedef ::std::map< ::std::string, BaseTypesVariant > EnhancedVoiceRecognitionFeatureType;


/**
 * This struct is a generic type and shall be used for the user-defined types.
 */
class StructofStringUInt8 {
public:

    /**
     * Default constructor
     */
    inline  StructofStringUInt8 ();

    /**
     * Copy constructor
     */
    inline  StructofStringUInt8 (const StructofStringUInt8 &rhs);

    /**
     * All fields constructor
     */
    inline  StructofStringUInt8 (uint8 UInt8Value_, const ::std::string& StringValue_);

    /**
     * Destructor
     */
    inline  ~StructofStringUInt8();

    /**
     * Assignment operator
     */
    inline StructofStringUInt8& operator = (const StructofStringUInt8& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StructofStringUInt8& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StructofStringUInt8& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StructofStringUInt8& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StructofStringUInt8& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UInt8Value"

    static const int kUInt8Value = 0;

    /**
     * Clears the field "UInt8Value".
     *
     * The field will be set to its default value. The hasUInt8Value()
     * method will return false.
     */
    inline void clearUInt8Value();

    /**
     * Checks whether the field "UInt8Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUInt8Value()). Otherwise it will return false.
     */
    inline bool hasUInt8Value () const;

    /**
     * Returns the value of the member "UInt8Value".
     *
     * If the meaning of "UInt8Value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UInt8Value"
     */
    inline uint8 getUInt8Value () const;

    /**
     * Sets the value of the member "UInt8Value".
     *
     * If the meaning of "UInt8Value" isn't clear, then there should be a description here.
     *
     * @param UInt8Value The value which will be set
     */
    inline void setUInt8Value (uint8 UInt8Value_);

    // API of field "StringValue"

    static const int kStringValue = 1;

    /**
     * Clears the field "StringValue".
     *
     * The field will be set to its default value. The hasStringValue()
     * method will return false.
     */
    inline void clearStringValue();

    /**
     * Checks whether the field "StringValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStringValue()). Otherwise it will return false.
     */
    inline bool hasStringValue () const;

    /**
     * Returns the value of the member "StringValue".
     *
     * If the meaning of "StringValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "StringValue"
     */
    inline const ::std::string& getStringValue () const;

    /**
     * Retrieves the value of the field "StringValue" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StringValue".
     */
    inline ::std::string& getStringValueMutable ();

    /**
     * Sets the value of the member "StringValue".
     *
     * If the meaning of "StringValue" isn't clear, then there should be a description here.
     *
     * @param StringValue The value which will be set
     */
    inline void setStringValue (const ::std::string& StringValue_);

    /**
     * Sets the value of the member "StringValue".
     *
     * If the meaning of "StringValue" isn't clear, then there should be a description here.
     *
     * @param StringValue The value which will be set
     */
    inline void setStringValue (const char* StringValue_);

    /**
     * Sets the value of the member "StringValue".
     *
     * If the meaning of "StringValue" isn't clear, then there should be a description here.
     *
     * @param StringValue The value which will be set
     */
    inline void setStringValue (const char* value, size_t size);

    static const StructofStringUInt8 &getDefaultInstance();

private:

    inline void set_has_UInt8Value ();

    inline void clear_has_UInt8Value ();

    inline void set_has_StringValue ();

    inline void clear_has_StringValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _UInt8Value;

    ::std::string _StringValue;

};

/**
 * This structure contains the ActiveSystemRingtoneID set and the list of available system ringtones.
 */
class SystemWideRingtonesListType {
public:

    /**
     * Default constructor
     */
    inline  SystemWideRingtonesListType ();

    /**
     * Copy constructor
     */
    inline  SystemWideRingtonesListType (const SystemWideRingtonesListType &rhs);

    /**
     * All fields constructor
     */
    inline  SystemWideRingtonesListType (uint8 ActiveSystemRingtoneID_, const ::std::vector< RingtoneInfo >& systemRingtoneList_);

    /**
     * Destructor
     */
    inline  ~SystemWideRingtonesListType();

    /**
     * Assignment operator
     */
    inline SystemWideRingtonesListType& operator = (const SystemWideRingtonesListType& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemWideRingtonesListType& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemWideRingtonesListType& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemWideRingtonesListType& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemWideRingtonesListType& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveSystemRingtoneID"

    static const int kActiveSystemRingtoneID = 0;

    /**
     * Clears the field "ActiveSystemRingtoneID".
     *
     * The field will be set to its default value. The hasActiveSystemRingtoneID()
     * method will return false.
     */
    inline void clearActiveSystemRingtoneID();

    /**
     * Checks whether the field "ActiveSystemRingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveSystemRingtoneID()). Otherwise it will return false.
     */
    inline bool hasActiveSystemRingtoneID () const;

    /**
     * Returns the value of the member "ActiveSystemRingtoneID".
     *
     * Ringtone which is set as system wide.
     *
     * @return The value of the field "ActiveSystemRingtoneID"
     */
    inline uint8 getActiveSystemRingtoneID () const;

    /**
     * Sets the value of the member "ActiveSystemRingtoneID".
     *
     * Ringtone which is set as system wide.
     *
     * @param ActiveSystemRingtoneID The value which will be set
     */
    inline void setActiveSystemRingtoneID (uint8 ActiveSystemRingtoneID_);

    // API of field "systemRingtoneList"

    static const int kSystemRingtoneList = 1;

    /**
     * Clears the field "systemRingtoneList".
     *
     * The field will be set to its default value. The hasSystemRingtoneList()
     * method will return false.
     */
    inline void clearSystemRingtoneList();

    /**
     * Checks whether the field "systemRingtoneList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemRingtoneList()). Otherwise it will return false.
     */
    inline bool hasSystemRingtoneList () const;

    /**
     * Returns the value of the member "systemRingtoneList".
     *
     * A list of available system ringtones.
     *
     * @return The value of the field "systemRingtoneList"
     */
    inline const ::std::vector< RingtoneInfo >& getSystemRingtoneList () const;

    /**
     * Retrieves the value of the field "systemRingtoneList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "systemRingtoneList".
     */
    inline ::std::vector< RingtoneInfo >& getSystemRingtoneListMutable ();

    /**
     * Sets the value of the member "systemRingtoneList".
     *
     * A list of available system ringtones.
     *
     * @param systemRingtoneList The value which will be set
     */
    inline void setSystemRingtoneList (const ::std::vector< RingtoneInfo >& systemRingtoneList_);

    static const SystemWideRingtonesListType &getDefaultInstance();

private:

    static const ::std::vector< RingtoneInfo >& getRingtoneInfoList_DefaultInstance ();

    inline void set_has_ActiveSystemRingtoneID ();

    inline void clear_has_ActiveSystemRingtoneID ();

    inline void set_has_systemRingtoneList ();

    inline void clear_has_systemRingtoneList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ActiveSystemRingtoneID;

    ::std::vector< RingtoneInfo > _systemRingtoneList;

};

/**
 * This structure contains Device address and its corresponding ringtone information set for the device.
 */
class DeviceRingtoneInfo {
public:

    /**
     * Default constructor
     */
    inline  DeviceRingtoneInfo ();

    /**
     * Copy constructor
     */
    inline  DeviceRingtoneInfo (const DeviceRingtoneInfo &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceRingtoneInfo (const ::std::string& DeviceAddress_, const RingtoneInfo& ringtoneInfo_);

    /**
     * Destructor
     */
    inline  ~DeviceRingtoneInfo();

    /**
     * Assignment operator
     */
    inline DeviceRingtoneInfo& operator = (const DeviceRingtoneInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRingtoneInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRingtoneInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRingtoneInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRingtoneInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    // API of field "ringtoneInfo"

    static const int kRingtoneInfo = 1;

    /**
     * Clears the field "ringtoneInfo".
     *
     * The field will be set to its default value. The hasRingtoneInfo()
     * method will return false.
     */
    inline void clearRingtoneInfo();

    /**
     * Checks whether the field "ringtoneInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRingtoneInfo()). Otherwise it will return false.
     */
    inline bool hasRingtoneInfo () const;

    /**
     * Returns the value of the member "ringtoneInfo".
     *
     * This struct has the Ringtone ID and the corresponding name of the ringtone.
     *
     * @return The value of the field "ringtoneInfo"
     */
    inline const RingtoneInfo& getRingtoneInfo () const;

    /**
     * Retrieves the value of the field "ringtoneInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ringtoneInfo".
     */
    inline RingtoneInfo& getRingtoneInfoMutable ();

    /**
     * Sets the value of the member "ringtoneInfo".
     *
     * This struct has the Ringtone ID and the corresponding name of the ringtone.
     *
     * @param ringtoneInfo The value which will be set
     */
    inline void setRingtoneInfo (const RingtoneInfo& ringtoneInfo_);

    static const DeviceRingtoneInfo &getDefaultInstance();

private:

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    inline void set_has_ringtoneInfo ();

    inline void clear_has_ringtoneInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddress;

    RingtoneInfo _ringtoneInfo;

};

/**
 * This structure has the device address and the On/Off value of the setting (AutoWaitingMode, SuppressRingtone,..).
 */
class OnOffSetting {
public:

    /**
     * Default constructor
     */
    inline  OnOffSetting ();

    /**
     * Copy constructor
     */
    inline  OnOffSetting (const OnOffSetting &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffSetting (const ::std::string& DeviceAddress_, bool OnOffValue_);

    /**
     * Destructor
     */
    inline  ~OnOffSetting();

    /**
     * Assignment operator
     */
    inline OnOffSetting& operator = (const OnOffSetting& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffSetting& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffSetting& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffSetting& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffSetting& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    // API of field "OnOffValue"

    static const int kOnOffValue = 1;

    /**
     * Clears the field "OnOffValue".
     *
     * The field will be set to its default value. The hasOnOffValue()
     * method will return false.
     */
    inline void clearOnOffValue();

    /**
     * Checks whether the field "OnOffValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffValue()). Otherwise it will return false.
     */
    inline bool hasOnOffValue () const;

    /**
     * Returns the value of the member "OnOffValue".
     *
     * TRUE - Enable / Enabled
     *             FALSE - Disable / Disabled
     *
     * @return The value of the field "OnOffValue"
     */
    inline bool getOnOffValue () const;

    /**
     * Sets the value of the member "OnOffValue".
     *
     * TRUE - Enable / Enabled
     *             FALSE - Disable / Disabled
     *
     * @param OnOffValue The value which will be set
     */
    inline void setOnOffValue (bool OnOffValue_);

    static const OnOffSetting &getDefaultInstance();

private:

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    inline void set_has_OnOffValue ();

    inline void clear_has_OnOffValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddress;

    bool _OnOffValue;

};

/**
 * This is a structure which gives information about the Device Address and its corresponding object path.
 */
class DeviceObjectPathInfo {
public:

    /**
     * Default constructor
     */
    inline  DeviceObjectPathInfo ();

    /**
     * Copy constructor
     */
    inline  DeviceObjectPathInfo (const DeviceObjectPathInfo &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceObjectPathInfo (const ::std::string& DeviceAddress_, const ::std::string& ObjectPath_);

    /**
     * Destructor
     */
    inline  ~DeviceObjectPathInfo();

    /**
     * Assignment operator
     */
    inline DeviceObjectPathInfo& operator = (const DeviceObjectPathInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceObjectPathInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceObjectPathInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceObjectPathInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceObjectPathInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    // API of field "ObjectPath"

    static const int kObjectPath = 1;

    /**
     * Clears the field "ObjectPath".
     *
     * The field will be set to its default value. The hasObjectPath()
     * method will return false.
     */
    inline void clearObjectPath();

    /**
     * Checks whether the field "ObjectPath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjectPath()). Otherwise it will return false.
     */
    inline bool hasObjectPath () const;

    /**
     * Returns the value of the member "ObjectPath".
     *
     * Object path for the DeviceInfo, VoiceCall and VoiceRecognition interfaces.
     *
     * @return The value of the field "ObjectPath"
     */
    inline const ::std::string& getObjectPath () const;

    /**
     * Retrieves the value of the field "ObjectPath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ObjectPath".
     */
    inline ::std::string& getObjectPathMutable ();

    /**
     * Sets the value of the member "ObjectPath".
     *
     * Object path for the DeviceInfo, VoiceCall and VoiceRecognition interfaces.
     *
     * @param ObjectPath The value which will be set
     */
    inline void setObjectPath (const ::std::string& ObjectPath_);

    /**
     * Sets the value of the member "ObjectPath".
     *
     * Object path for the DeviceInfo, VoiceCall and VoiceRecognition interfaces.
     *
     * @param ObjectPath The value which will be set
     */
    inline void setObjectPath (const char* ObjectPath_);

    /**
     * Sets the value of the member "ObjectPath".
     *
     * Object path for the DeviceInfo, VoiceCall and VoiceRecognition interfaces.
     *
     * @param ObjectPath The value which will be set
     */
    inline void setObjectPath (const char* value, size_t size);

    static const DeviceObjectPathInfo &getDefaultInstance();

private:

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    inline void set_has_ObjectPath ();

    inline void clear_has_ObjectPath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddress;

    ::std::string _ObjectPath;

};

/**
 * If the meaning of "HfpManagerVariant" isn't clear, then there should be a description here.
 */
class HfpManagerVariant {
public:

    enum HfpManagerVariantField {
        E_BOOLEAN,
        E_SYSTEM_WIDE_RINGTONES_LIST_TYPE,
        E_DEVICE_RINGTONE_LIST_TYPE,
        E_SUPPRESS_RINGTONE_LIST_TYPE,
        E_AUTO_WAITING_MODE_LIST_TYPE,
        E_WAITING_MODE_FILE_PATH_TYPE,
        E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE,
        E_DEVICE_OBJECT_PATH_LIST_TYPE
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "boolean".
     */
    inline  HfpManagerVariant ();

   /**
     * Copy constructor
     */
    inline  HfpManagerVariant (const HfpManagerVariant& rhs);

    /**
     * Destructor
     */
    inline  ~HfpManagerVariant();

    /**
     * Assigns a new value to this object.
     */
    inline HfpManagerVariant& operator = (const HfpManagerVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HfpManagerVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HfpManagerVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HfpManagerVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HfpManagerVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline HfpManagerVariant::HfpManagerVariantField getField () const;

    inline void setField(HfpManagerVariant::HfpManagerVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "boolean"

    static const int kBoolean = 0;

    /**
     * Returns true if the field "boolean" has a value.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "boolean", otherwise false
     */
    inline bool hasBoolean () const;

    /**
     * Returns the value of field "boolean".It is only valid to call this
     * method if hasBoolean() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline bool getBoolean() const ;

    /**
     * Sets the value of the field "boolean". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setBoolean (bool value);

    // API of field "systemWideRingtonesListType"

    static const int kSystemWideRingtonesListType = 1;

    /**
     * Returns true if the field "systemWideRingtonesListType" has a value.
     *
     * If the meaning of "systemWideRingtonesListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemWideRingtonesListType", otherwise false
     */
    inline bool hasSystemWideRingtonesListType () const;

    /**
     * Returns the value of field "systemWideRingtonesListType".It is only
     * valid to call this method if hasSystemWideRingtonesListType() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "systemWideRingtonesListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const SystemWideRingtonesListType& getSystemWideRingtonesListType() const ;

    /**
     * Retrieves the value of the field "systemWideRingtonesListType" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isSystemWideRingtonesListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline SystemWideRingtonesListType& getSystemWideRingtonesListTypeMutable();

    /**
     * Release the object stored in the field "systemWideRingtonesListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "systemWideRingtonesListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "systemWideRingtonesListType"
     */
    inline SystemWideRingtonesListType* releaseSystemWideRingtonesListType();

    /**
     * Replace the field "systemWideRingtonesListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSystemWideRingtonesListType (SystemWideRingtonesListType* systemWideRingtonesListType);

    /**
     * Sets the value of the field "systemWideRingtonesListType". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "systemWideRingtonesListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemWideRingtonesListType (const SystemWideRingtonesListType& value);

    // API of field "deviceRingtoneListType"

    static const int kDeviceRingtoneListType = 2;

    /**
     * Returns true if the field "deviceRingtoneListType" has a value.
     *
     * If the meaning of "deviceRingtoneListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "deviceRingtoneListType", otherwise false
     */
    inline bool hasDeviceRingtoneListType () const;

    /**
     * Returns the value of field "deviceRingtoneListType".It is only valid to
     * call this method if hasDeviceRingtoneListType() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "deviceRingtoneListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< DeviceRingtoneInfo >& getDeviceRingtoneListType() const ;

    /**
     * Retrieves the value of the field "deviceRingtoneListType" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isDeviceRingtoneListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< DeviceRingtoneInfo >& getDeviceRingtoneListTypeMutable();

    /**
     * Release the object stored in the field "deviceRingtoneListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "deviceRingtoneListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "deviceRingtoneListType"
     */
    inline ::std::vector< DeviceRingtoneInfo >* releaseDeviceRingtoneListType();

    /**
     * Replace the field "deviceRingtoneListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDeviceRingtoneListType (::std::vector< DeviceRingtoneInfo >* deviceRingtoneListType);

    /**
     * Sets the value of the field "deviceRingtoneListType". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "deviceRingtoneListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setDeviceRingtoneListType (const ::std::vector< DeviceRingtoneInfo >& value);

    // API of field "suppressRingtoneListType"

    static const int kSuppressRingtoneListType = 3;

    /**
     * Returns true if the field "suppressRingtoneListType" has a value.
     *
     * If the meaning of "suppressRingtoneListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "suppressRingtoneListType", otherwise false
     */
    inline bool hasSuppressRingtoneListType () const;

    /**
     * Returns the value of field "suppressRingtoneListType".It is only valid
     * to call this method if hasSuppressRingtoneListType() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "suppressRingtoneListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< OnOffSetting >& getSuppressRingtoneListType() const ;

    /**
     * Retrieves the value of the field "suppressRingtoneListType" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isSuppressRingtoneListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< OnOffSetting >& getSuppressRingtoneListTypeMutable();

    /**
     * Release the object stored in the field "suppressRingtoneListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "suppressRingtoneListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "suppressRingtoneListType"
     */
    inline ::std::vector< OnOffSetting >* releaseSuppressRingtoneListType();

    /**
     * Replace the field "suppressRingtoneListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSuppressRingtoneListType (::std::vector< OnOffSetting >* suppressRingtoneListType);

    /**
     * Sets the value of the field "suppressRingtoneListType". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "suppressRingtoneListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSuppressRingtoneListType (const ::std::vector< OnOffSetting >& value);

    // API of field "autoWaitingModeListType"

    static const int kAutoWaitingModeListType = 4;

    /**
     * Returns true if the field "autoWaitingModeListType" has a value.
     *
     * If the meaning of "autoWaitingModeListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "autoWaitingModeListType", otherwise false
     */
    inline bool hasAutoWaitingModeListType () const;

    /**
     * Returns the value of field "autoWaitingModeListType".It is only valid
     * to call this method if hasAutoWaitingModeListType() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "autoWaitingModeListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< OnOffSetting >& getAutoWaitingModeListType() const ;

    /**
     * Retrieves the value of the field "autoWaitingModeListType" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isAutoWaitingModeListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< OnOffSetting >& getAutoWaitingModeListTypeMutable();

    /**
     * Release the object stored in the field "autoWaitingModeListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "autoWaitingModeListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "autoWaitingModeListType"
     */
    inline ::std::vector< OnOffSetting >* releaseAutoWaitingModeListType();

    /**
     * Replace the field "autoWaitingModeListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceAutoWaitingModeListType (::std::vector< OnOffSetting >* autoWaitingModeListType);

    /**
     * Sets the value of the field "autoWaitingModeListType". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "autoWaitingModeListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setAutoWaitingModeListType (const ::std::vector< OnOffSetting >& value);

    // API of field "waitingModeFilePathType"

    static const int kWaitingModeFilePathType = 5;

    /**
     * Returns true if the field "waitingModeFilePathType" has a value.
     *
     * If the meaning of "waitingModeFilePathType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "waitingModeFilePathType", otherwise false
     */
    inline bool hasWaitingModeFilePathType () const;

    /**
     * Returns the value of field "waitingModeFilePathType".It is only valid
     * to call this method if hasWaitingModeFilePathType() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "waitingModeFilePathType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const WaitingModeFilePathType& getWaitingModeFilePathType() const ;

    /**
     * Retrieves the value of the field "waitingModeFilePathType" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isWaitingModeFilePathType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline WaitingModeFilePathType& getWaitingModeFilePathTypeMutable();

    /**
     * Release the object stored in the field "waitingModeFilePathType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "waitingModeFilePathType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "waitingModeFilePathType"
     */
    inline WaitingModeFilePathType* releaseWaitingModeFilePathType();

    /**
     * Replace the field "waitingModeFilePathType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceWaitingModeFilePathType (WaitingModeFilePathType* waitingModeFilePathType);

    /**
     * Sets the value of the field "waitingModeFilePathType". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "waitingModeFilePathType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setWaitingModeFilePathType (const WaitingModeFilePathType& value);

    // API of field "activePassiveDeviceListType"

    static const int kActivePassiveDeviceListType = 6;

    /**
     * Returns true if the field "activePassiveDeviceListType" has a value.
     *
     * If the meaning of "activePassiveDeviceListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "activePassiveDeviceListType", otherwise false
     */
    inline bool hasActivePassiveDeviceListType () const;

    /**
     * Returns the value of field "activePassiveDeviceListType".It is only
     * valid to call this method if hasActivePassiveDeviceListType() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "activePassiveDeviceListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< HfpRoleInfo >& getActivePassiveDeviceListType() const ;

    /**
     * Retrieves the value of the field "activePassiveDeviceListType" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isActivePassiveDeviceListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< HfpRoleInfo >& getActivePassiveDeviceListTypeMutable();

    /**
     * Release the object stored in the field "activePassiveDeviceListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "activePassiveDeviceListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "activePassiveDeviceListType"
     */
    inline ::std::vector< HfpRoleInfo >* releaseActivePassiveDeviceListType();

    /**
     * Replace the field "activePassiveDeviceListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceActivePassiveDeviceListType (::std::vector< HfpRoleInfo >* activePassiveDeviceListType);

    /**
     * Sets the value of the field "activePassiveDeviceListType". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "activePassiveDeviceListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setActivePassiveDeviceListType (const ::std::vector< HfpRoleInfo >& value);

    // API of field "deviceObjectPathListType"

    static const int kDeviceObjectPathListType = 7;

    /**
     * Returns true if the field "deviceObjectPathListType" has a value.
     *
     * If the meaning of "deviceObjectPathListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "deviceObjectPathListType", otherwise false
     */
    inline bool hasDeviceObjectPathListType () const;

    /**
     * Returns the value of field "deviceObjectPathListType".It is only valid
     * to call this method if hasDeviceObjectPathListType() returns true.
     * Otherwise the behavior is not specified.
     *
     * If the meaning of "deviceObjectPathListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< DeviceObjectPathInfo >& getDeviceObjectPathListType() const ;

    /**
     * Retrieves the value of the field "deviceObjectPathListType" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if isDeviceObjectPathListType()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< DeviceObjectPathInfo >& getDeviceObjectPathListTypeMutable();

    /**
     * Release the object stored in the field "deviceObjectPathListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "deviceObjectPathListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "deviceObjectPathListType"
     */
    inline ::std::vector< DeviceObjectPathInfo >* releaseDeviceObjectPathListType();

    /**
     * Replace the field "deviceObjectPathListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDeviceObjectPathListType (::std::vector< DeviceObjectPathInfo >* deviceObjectPathListType);

    /**
     * Sets the value of the field "deviceObjectPathListType". A field which
     * was previously set will be cleared.
     *
     * If the meaning of "deviceObjectPathListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setDeviceObjectPathListType (const ::std::vector< DeviceObjectPathInfo >& value);

    static const HfpManagerVariant &getDefaultInstance();

private:

    static const ::std::vector< DeviceRingtoneInfo >& getDeviceRingtoneInfoList_DefaultInstance ();

    static const ::std::vector< OnOffSetting >& getOnOffSettingList_DefaultInstance ();

    static const ::std::map< ::std::string, ::std::string >& getStringToStringMap_DefaultInstance ();

    static const ::std::vector< HfpRoleInfo >& getHfpRoleInfoList_DefaultInstance ();

    static const ::std::vector< DeviceObjectPathInfo >& getDeviceObjectPathInfoList_DefaultInstance ();

    inline void cloneData (const HfpManagerVariant& rhs);

    inline void deleteData ();

    HfpManagerVariantField __field;

    union {
        bool boolean_;
        SystemWideRingtonesListType* systemWideRingtonesListType_;
        ::std::vector< DeviceRingtoneInfo >* deviceRingtoneListType_;
        ::std::vector< OnOffSetting >* suppressRingtoneListType_;
        ::std::vector< OnOffSetting >* autoWaitingModeListType_;
        ::std::map< ::std::string, ::std::string >* waitingModeFilePathType_;
        ::std::vector< HfpRoleInfo >* activePassiveDeviceListType_;
        ::std::vector< DeviceObjectPathInfo >* deviceObjectPathListType_;
    } _data;

};

/**
 * If the meaning of "DeviceInfoVariant" isn't clear, then there should be a description here.
 */
class DeviceInfoVariant {
public:

    enum DeviceInfoVariantField {
        E_UINT8,
        E_STRING,
        E_SUPPORTED_FEATURES_LIST
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "uint8".
     */
    inline  DeviceInfoVariant ();

   /**
     * Copy constructor
     */
    inline  DeviceInfoVariant (const DeviceInfoVariant& rhs);

    /**
     * Destructor
     */
    inline  ~DeviceInfoVariant();

    /**
     * Assigns a new value to this object.
     */
    inline DeviceInfoVariant& operator = (const DeviceInfoVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceInfoVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceInfoVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceInfoVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceInfoVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline DeviceInfoVariant::DeviceInfoVariantField getField () const;

    inline void setField(DeviceInfoVariant::DeviceInfoVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "uint8"

    static const int kUint8 = 0;

    /**
     * Returns true if the field "uint8" has a value.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint8", otherwise false
     */
    inline bool hasUint8 () const;

    /**
     * Returns the value of field "uint8".It is only valid to call this method
     * if hasUint8() returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint8 getUint8() const ;

    /**
     * Sets the value of the field "uint8". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint8 (uint8 value);

    // API of field "string"

    static const int kString = 1;

    /**
     * Returns true if the field "string" has a value.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "string", otherwise false
     */
    inline bool hasString () const;

    /**
     * Returns the value of field "string".It is only valid to call this
     * method if hasString() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::string& getString() const ;

    /**
     * Retrieves the value of the field "string" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if isString() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::string& getStringMutable();

    /**
     * Release the object stored in the field "string".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "string" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "string"
     */
    inline ::std::string* releaseString();

    /**
     * Replace the field "string".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceString (::std::string* string);

    /**
     * Sets the value of the field "string". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setString (const ::std::string& string);

    inline void setString (const char* value);

    inline void setString (const char* value, size_t size);

    // API of field "supportedFeaturesList"

    static const int kSupportedFeaturesList = 2;

    /**
     * Returns true if the field "supportedFeaturesList" has a value.
     *
     * If the meaning of "supportedFeaturesList" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "supportedFeaturesList", otherwise false
     */
    inline bool hasSupportedFeaturesList () const;

    /**
     * Returns the value of field "supportedFeaturesList".It is only valid to
     * call this method if hasSupportedFeaturesList() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "supportedFeaturesList" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< ::std::string >& getSupportedFeaturesList() const ;

    /**
     * Retrieves the value of the field "supportedFeaturesList" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isSupportedFeaturesList()
     * returns true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< ::std::string >& getSupportedFeaturesListMutable();

    /**
     * Release the object stored in the field "supportedFeaturesList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "supportedFeaturesList" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "supportedFeaturesList"
     */
    inline ::std::vector< ::std::string >* releaseSupportedFeaturesList();

    /**
     * Replace the field "supportedFeaturesList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSupportedFeaturesList (::std::vector< ::std::string >* supportedFeaturesList);

    /**
     * Sets the value of the field "supportedFeaturesList". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "supportedFeaturesList" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSupportedFeaturesList (const ::std::vector< ::std::string >& value);

    static const DeviceInfoVariant &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void cloneData (const DeviceInfoVariant& rhs);

    inline void deleteData ();

    DeviceInfoVariantField __field;

    union {
        uint8 uint8__;
        std::string* string_;
        ::std::vector< ::std::string >* supportedFeaturesList_;
    } _data;

};

/**
 * If the meaning of "BaseTypesVariant" isn't clear, then there should be a description here.
 */
class BaseTypesVariant {
public:

    enum BaseTypesVariantField {
        E_UINT8,
        E_UINT64,
        E_BOOLEAN,
        E_STRING
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "uint8".
     */
    inline  BaseTypesVariant ();

   /**
     * Copy constructor
     */
    inline  BaseTypesVariant (const BaseTypesVariant& rhs);

    /**
     * Destructor
     */
    inline  ~BaseTypesVariant();

    /**
     * Assigns a new value to this object.
     */
    inline BaseTypesVariant& operator = (const BaseTypesVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BaseTypesVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BaseTypesVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BaseTypesVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BaseTypesVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline BaseTypesVariant::BaseTypesVariantField getField () const;

    inline void setField(BaseTypesVariant::BaseTypesVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "uint8"

    static const int kUint8 = 0;

    /**
     * Returns true if the field "uint8" has a value.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint8", otherwise false
     */
    inline bool hasUint8 () const;

    /**
     * Returns the value of field "uint8".It is only valid to call this method
     * if hasUint8() returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint8 getUint8() const ;

    /**
     * Sets the value of the field "uint8". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint8 (uint8 value);

    // API of field "uint64"

    static const int kUint64 = 1;

    /**
     * Returns true if the field "uint64" has a value.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint64", otherwise false
     */
    inline bool hasUint64 () const;

    /**
     * Returns the value of field "uint64".It is only valid to call this
     * method if hasUint64() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint64 getUint64() const ;

    /**
     * Sets the value of the field "uint64". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint64 (uint64 value);

    // API of field "boolean"

    static const int kBoolean = 2;

    /**
     * Returns true if the field "boolean" has a value.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "boolean", otherwise false
     */
    inline bool hasBoolean () const;

    /**
     * Returns the value of field "boolean".It is only valid to call this
     * method if hasBoolean() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline bool getBoolean() const ;

    /**
     * Sets the value of the field "boolean". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setBoolean (bool value);

    // API of field "string"

    static const int kString = 3;

    /**
     * Returns true if the field "string" has a value.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "string", otherwise false
     */
    inline bool hasString () const;

    /**
     * Returns the value of field "string".It is only valid to call this
     * method if hasString() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::string& getString() const ;

    /**
     * Retrieves the value of the field "string" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if isString() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::string& getStringMutable();

    /**
     * Release the object stored in the field "string".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "string" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "string"
     */
    inline ::std::string* releaseString();

    /**
     * Replace the field "string".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceString (::std::string* string);

    /**
     * Sets the value of the field "string". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setString (const ::std::string& string);

    inline void setString (const char* value);

    inline void setString (const char* value, size_t size);

    static const BaseTypesVariant &getDefaultInstance();

private:

    inline void cloneData (const BaseTypesVariant& rhs);

    inline void deleteData ();

    BaseTypesVariantField __field;

    union {
        uint8 uint8__;
        uint64 uint64__;
        bool boolean_;
        std::string* string_;
    } _data;

};

/**
 * This structure includes the device address and an array of call instances specific to that device.
 */
class DeviceCallsList {
public:

    /**
     * Default constructor
     */
    inline  DeviceCallsList ();

    /**
     * Copy constructor
     */
    inline  DeviceCallsList (const DeviceCallsList &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceCallsList (const ::std::string& DeviceAddress_, const ::std::vector< uint8 >& callsList_);

    /**
     * Destructor
     */
    inline  ~DeviceCallsList();

    /**
     * Assignment operator
     */
    inline DeviceCallsList& operator = (const DeviceCallsList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceCallsList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceCallsList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceCallsList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceCallsList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device.
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the HFP connected device.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    // API of field "callsList"

    static const int kCallsList = 1;

    /**
     * Clears the field "callsList".
     *
     * The field will be set to its default value. The hasCallsList()
     * method will return false.
     */
    inline void clearCallsList();

    /**
     * Checks whether the field "callsList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallsList()). Otherwise it will return false.
     */
    inline bool hasCallsList () const;

    /**
     * Returns the value of the member "callsList".
     *
     * Array of call instances.
     *
     * @return The value of the field "callsList"
     */
    inline const ::std::vector< uint8 >& getCallsList () const;

    /**
     * Retrieves the value of the field "callsList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "callsList".
     */
    inline ::std::vector< uint8 >& getCallsListMutable ();

    /**
     * Sets the value of the member "callsList".
     *
     * Array of call instances.
     *
     * @param callsList The value which will be set
     */
    inline void setCallsList (const ::std::vector< uint8 >& callsList_);

    static const DeviceCallsList &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    inline void set_has_callsList ();

    inline void clear_has_callsList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddress;

    ::std::vector< uint8 > _callsList;

};

/**
 * If the meaning of "CallStatusVariant" isn't clear, then there should be a description here.
 */
class CallStatusVariant {
public:

    enum CallStatusVariantField {
        E_UINT8,
        E_UINT64,
        E_BOOLEAN,
        E_STRING,
        E_CALL_INFO_LIST
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "uint8".
     */
    inline  CallStatusVariant ();

   /**
     * Copy constructor
     */
    inline  CallStatusVariant (const CallStatusVariant& rhs);

    /**
     * Destructor
     */
    inline  ~CallStatusVariant();

    /**
     * Assigns a new value to this object.
     */
    inline CallStatusVariant& operator = (const CallStatusVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallStatusVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallStatusVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallStatusVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallStatusVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline CallStatusVariant::CallStatusVariantField getField () const;

    inline void setField(CallStatusVariant::CallStatusVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "uint8"

    static const int kUint8 = 0;

    /**
     * Returns true if the field "uint8" has a value.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint8", otherwise false
     */
    inline bool hasUint8 () const;

    /**
     * Returns the value of field "uint8".It is only valid to call this method
     * if hasUint8() returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint8 getUint8() const ;

    /**
     * Sets the value of the field "uint8". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint8 (uint8 value);

    // API of field "uint64"

    static const int kUint64 = 1;

    /**
     * Returns true if the field "uint64" has a value.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint64", otherwise false
     */
    inline bool hasUint64 () const;

    /**
     * Returns the value of field "uint64".It is only valid to call this
     * method if hasUint64() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint64 getUint64() const ;

    /**
     * Sets the value of the field "uint64". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint64" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint64 (uint64 value);

    // API of field "boolean"

    static const int kBoolean = 2;

    /**
     * Returns true if the field "boolean" has a value.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "boolean", otherwise false
     */
    inline bool hasBoolean () const;

    /**
     * Returns the value of field "boolean".It is only valid to call this
     * method if hasBoolean() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline bool getBoolean() const ;

    /**
     * Sets the value of the field "boolean". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setBoolean (bool value);

    // API of field "string"

    static const int kString = 3;

    /**
     * Returns true if the field "string" has a value.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "string", otherwise false
     */
    inline bool hasString () const;

    /**
     * Returns the value of field "string".It is only valid to call this
     * method if hasString() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::string& getString() const ;

    /**
     * Retrieves the value of the field "string" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if isString() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::string& getStringMutable();

    /**
     * Release the object stored in the field "string".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "string" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "string"
     */
    inline ::std::string* releaseString();

    /**
     * Replace the field "string".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceString (::std::string* string);

    /**
     * Sets the value of the field "string". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "string" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setString (const ::std::string& string);

    inline void setString (const char* value);

    inline void setString (const char* value, size_t size);

    // API of field "callInfoList"

    static const int kCallInfoList = 4;

    /**
     * Returns true if the field "callInfoList" has a value.
     *
     * If the meaning of "callInfoList" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "callInfoList", otherwise false
     */
    inline bool hasCallInfoList () const;

    /**
     * Returns the value of field "callInfoList".It is only valid to call this
     * method if hasCallInfoList() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "callInfoList" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< CallInfo >& getCallInfoList() const ;

    /**
     * Retrieves the value of the field "callInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCallInfoList() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< CallInfo >& getCallInfoListMutable();

    /**
     * Release the object stored in the field "callInfoList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "callInfoList" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "callInfoList"
     */
    inline ::std::vector< CallInfo >* releaseCallInfoList();

    /**
     * Replace the field "callInfoList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCallInfoList (::std::vector< CallInfo >* callInfoList);

    /**
     * Sets the value of the field "callInfoList". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "callInfoList" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCallInfoList (const ::std::vector< CallInfo >& value);

    static const CallStatusVariant &getDefaultInstance();

private:

    static const ::std::vector< CallInfo >& getCallInfoList_DefaultInstance ();

    inline void cloneData (const CallStatusVariant& rhs);

    inline void deleteData ();

    CallStatusVariantField __field;

    union {
        uint8 uint8__;
        uint64 uint64__;
        bool boolean_;
        std::string* string_;
        ::std::vector< CallInfo >* callInfoList_;
    } _data;

};

/**
 * If the meaning of "VoiceCallManagerVariant" isn't clear, then there should be a description here.
 */
class VoiceCallManagerVariant {
public:

    enum VoiceCallManagerVariantField {
        E_BOOLEAN,
        E_CALL_STATUS_LIST_TYPE
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "boolean".
     */
    inline  VoiceCallManagerVariant ();

   /**
     * Copy constructor
     */
    inline  VoiceCallManagerVariant (const VoiceCallManagerVariant& rhs);

    /**
     * Destructor
     */
    inline  ~VoiceCallManagerVariant();

    /**
     * Assigns a new value to this object.
     */
    inline VoiceCallManagerVariant& operator = (const VoiceCallManagerVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceCallManagerVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceCallManagerVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceCallManagerVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceCallManagerVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VoiceCallManagerVariant::VoiceCallManagerVariantField getField () const;

    inline void setField(VoiceCallManagerVariant::VoiceCallManagerVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "boolean"

    static const int kBoolean = 0;

    /**
     * Returns true if the field "boolean" has a value.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "boolean", otherwise false
     */
    inline bool hasBoolean () const;

    /**
     * Returns the value of field "boolean".It is only valid to call this
     * method if hasBoolean() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline bool getBoolean() const ;

    /**
     * Sets the value of the field "boolean". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setBoolean (bool value);

    // API of field "callStatusListType"

    static const int kCallStatusListType = 1;

    /**
     * Returns true if the field "callStatusListType" has a value.
     *
     * If the meaning of "callStatusListType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "callStatusListType", otherwise false
     */
    inline bool hasCallStatusListType () const;

    /**
     * Returns the value of field "callStatusListType".It is only valid to
     * call this method if hasCallStatusListType() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "callStatusListType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& getCallStatusListType() const ;

    /**
     * Retrieves the value of the field "callStatusListType" as a mutable
     * object. Any modifications on the returned object will affect the
     * containing object.
     *
     * It is only valid to call this method if isCallStatusListType() returns
     * true. Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& getCallStatusListTypeMutable();

    /**
     * Release the object stored in the field "callStatusListType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "callStatusListType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "callStatusListType"
     */
    inline ::std::vector< ::std::map< ::std::string, CallStatusVariant > >* releaseCallStatusListType();

    /**
     * Replace the field "callStatusListType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCallStatusListType (::std::vector< ::std::map< ::std::string, CallStatusVariant > >* callStatusListType);

    /**
     * Sets the value of the field "callStatusListType". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "callStatusListType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCallStatusListType (const ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& value);

    static const VoiceCallManagerVariant &getDefaultInstance();

private:

    static const ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& getStringToCallStatusVariantMap_List_DefaultInstance ();

    inline void cloneData (const VoiceCallManagerVariant& rhs);

    inline void deleteData ();

    VoiceCallManagerVariantField __field;

    union {
        bool boolean_;
        ::std::vector< ::std::map< ::std::string, CallStatusVariant > >* callStatusListType_;
    } _data;

};

/**
 * If the meaning of "VoiceCallVariant" isn't clear, then there should be a description here.
 */
class VoiceCallVariant {
public:

    enum VoiceCallVariantField {
        E_UINT8,
        E_BOOLEAN
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "uint8".
     */
    inline  VoiceCallVariant ();

   /**
     * Copy constructor
     */
    inline  VoiceCallVariant (const VoiceCallVariant& rhs);

    /**
     * Destructor
     */
    inline  ~VoiceCallVariant();

    /**
     * Assigns a new value to this object.
     */
    inline VoiceCallVariant& operator = (const VoiceCallVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceCallVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceCallVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceCallVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceCallVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VoiceCallVariant::VoiceCallVariantField getField () const;

    inline void setField(VoiceCallVariant::VoiceCallVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "uint8"

    static const int kUint8 = 0;

    /**
     * Returns true if the field "uint8" has a value.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint8", otherwise false
     */
    inline bool hasUint8 () const;

    /**
     * Returns the value of field "uint8".It is only valid to call this method
     * if hasUint8() returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint8 getUint8() const ;

    /**
     * Sets the value of the field "uint8". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint8 (uint8 value);

    // API of field "boolean"

    static const int kBoolean = 1;

    /**
     * Returns true if the field "boolean" has a value.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "boolean", otherwise false
     */
    inline bool hasBoolean () const;

    /**
     * Returns the value of field "boolean".It is only valid to call this
     * method if hasBoolean() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline bool getBoolean() const ;

    /**
     * Sets the value of the field "boolean". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "boolean" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setBoolean (bool value);

    static const VoiceCallVariant &getDefaultInstance();

private:

    inline void cloneData (const VoiceCallVariant& rhs);

    inline void deleteData ();

    VoiceCallVariantField __field;

    union {
        uint8 uint8__;
        bool boolean_;
    } _data;

};

/**
 * If the meaning of "VoiceRecognitionVariant" isn't clear, then there should be a description here.
 */
class VoiceRecognitionVariant {
public:

    enum VoiceRecognitionVariantField {
        E_UINT8,
        E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "uint8".
     */
    inline  VoiceRecognitionVariant ();

   /**
     * Copy constructor
     */
    inline  VoiceRecognitionVariant (const VoiceRecognitionVariant& rhs);

    /**
     * Destructor
     */
    inline  ~VoiceRecognitionVariant();

    /**
     * Assigns a new value to this object.
     */
    inline VoiceRecognitionVariant& operator = (const VoiceRecognitionVariant& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoiceRecognitionVariant& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoiceRecognitionVariant& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoiceRecognitionVariant& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoiceRecognitionVariant& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline VoiceRecognitionVariant::VoiceRecognitionVariantField getField () const;

    inline void setField(VoiceRecognitionVariant::VoiceRecognitionVariantField field);

    // ---- Field accessors -------------------------------------------

    // API of field "uint8"

    static const int kUint8 = 0;

    /**
     * Returns true if the field "uint8" has a value.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "uint8", otherwise false
     */
    inline bool hasUint8 () const;

    /**
     * Returns the value of field "uint8".It is only valid to call this method
     * if hasUint8() returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline uint8 getUint8() const ;

    /**
     * Sets the value of the field "uint8". A field which was previously set
     * will be cleared.
     *
     * If the meaning of "uint8" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setUint8 (uint8 value);

    // API of field "enhancedVoiceRecognitionFeatureType"

    static const int kEnhancedVoiceRecognitionFeatureType = 1;

    /**
     * Returns true if the field "enhancedVoiceRecognitionFeatureType" has a value.
     *
     * If the meaning of "enhancedVoiceRecognitionFeatureType" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "enhancedVoiceRecognitionFeatureType", otherwise false
     */
    inline bool hasEnhancedVoiceRecognitionFeatureType () const;

    /**
     * Returns the value of field "enhancedVoiceRecognitionFeatureType".It is
     * only valid to call this method if
     * hasEnhancedVoiceRecognitionFeatureType() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "enhancedVoiceRecognitionFeatureType" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeatureType() const ;

    /**
     * Retrieves the value of the field "enhancedVoiceRecognitionFeatureType"
     * as a mutable object. Any modifications on the returned object will
     * affect the containing object.
     *
     * It is only valid to call this method if
     * isEnhancedVoiceRecognitionFeatureType() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline EnhancedVoiceRecognitionFeatureType& getEnhancedVoiceRecognitionFeatureTypeMutable();

    /**
     * Release the object stored in the field "enhancedVoiceRecognitionFeatureType".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "enhancedVoiceRecognitionFeatureType" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "enhancedVoiceRecognitionFeatureType"
     */
    inline EnhancedVoiceRecognitionFeatureType* releaseEnhancedVoiceRecognitionFeatureType();

    /**
     * Replace the field "enhancedVoiceRecognitionFeatureType".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceEnhancedVoiceRecognitionFeatureType (EnhancedVoiceRecognitionFeatureType* enhancedVoiceRecognitionFeatureType);

    /**
     * Sets the value of the field "enhancedVoiceRecognitionFeatureType". A
     * field which was previously set will be cleared.
     *
     * If the meaning of "enhancedVoiceRecognitionFeatureType" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setEnhancedVoiceRecognitionFeatureType (const EnhancedVoiceRecognitionFeatureType& value);

    static const VoiceRecognitionVariant &getDefaultInstance();

private:

    static const ::std::map< ::std::string, BaseTypesVariant >& getStringToBaseTypesVariantMap_DefaultInstance ();

    inline void cloneData (const VoiceRecognitionVariant& rhs);

    inline void deleteData ();

    VoiceRecognitionVariantField __field;

    union {
        uint8 uint8__;
        ::std::map< ::std::string, BaseTypesVariant >* enhancedVoiceRecognitionFeatureType_;
    } _data;

};

inline  StructofStringUInt8::StructofStringUInt8 ()  :
    _UInt8Value (0u),
    _StringValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StructofStringUInt8::StructofStringUInt8 (const StructofStringUInt8 &rhs)  :
    _UInt8Value (0u),
    _StringValue ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StructofStringUInt8::StructofStringUInt8 (uint8 UInt8Value_, const ::std::string& StringValue_)  :
    _UInt8Value (UInt8Value_),
    _StringValue (StringValue_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StringValue_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StructofStringUInt8::~StructofStringUInt8() {
}

inline StructofStringUInt8& StructofStringUInt8::operator = (const StructofStringUInt8& rhs) {
    if( this != &rhs ) {
        if (rhs.hasUInt8Value()) {
            setUInt8Value(rhs.getUInt8Value());
        } else {
            clearUInt8Value();
        }
        if (rhs.hasStringValue()) {
            setStringValue(rhs.getStringValue());
        } else {
            clearStringValue();
        }
    }
    return *this;
}

inline bool StructofStringUInt8::operator == (const StructofStringUInt8& rhs) const {
    return (((!hasUInt8Value() && !rhs.hasUInt8Value()) || getUInt8Value() == rhs.getUInt8Value()) &&
        ((!hasStringValue() && !rhs.hasStringValue()) || getStringValue() == rhs.getStringValue()));
}

inline bool StructofStringUInt8::operator != (const StructofStringUInt8& rhs) const {
    return ! (*this == rhs);
}

inline bool StructofStringUInt8::operator < (const StructofStringUInt8& rhs) const {
    if (hasUInt8Value() || rhs.hasUInt8Value()) {
        if (getUInt8Value() < rhs.getUInt8Value()) return true;
        if (getUInt8Value() > rhs.getUInt8Value()) return false;
    }
    if (hasStringValue() || rhs.hasStringValue()) {
        if (getStringValue() < rhs.getStringValue()) return true;
        if (getStringValue() > rhs.getStringValue()) return false;
    }
    return false;
}

inline bool StructofStringUInt8::operator > (const StructofStringUInt8& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StructofStringUInt8::clear() {
    clearUInt8Value();
    clearStringValue();
}

inline void StructofStringUInt8::clearUInt8Value() {
    if (hasUInt8Value()) {
         clear_has_UInt8Value();
        _UInt8Value = 0u;
     }
}

inline bool StructofStringUInt8::hasUInt8Value () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 StructofStringUInt8::getUInt8Value () const {
    return _UInt8Value;
}

inline void StructofStringUInt8::setUInt8Value (uint8 UInt8Value_) {
    set_has_UInt8Value();
    this->_UInt8Value = UInt8Value_;
}

inline void StructofStringUInt8::clearStringValue() {
    if (hasStringValue()) {
         clear_has_StringValue();
        _StringValue.clear();
     }
}

inline bool StructofStringUInt8::hasStringValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& StructofStringUInt8::getStringValue () const {
    return _StringValue;
}

inline ::std::string& StructofStringUInt8::getStringValueMutable () {
    set_has_StringValue();
    return _StringValue;
}

inline void StructofStringUInt8::setStringValue (const ::std::string& StringValue_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StringValue_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StringValue();
    this->_StringValue = StringValue_;
}

inline void StructofStringUInt8::setStringValue (const char* StringValue_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (StringValue_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StringValue();
    this->_StringValue.assign(StringValue_);
}

inline void StructofStringUInt8::setStringValue (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_StringValue();
    this->_StringValue.assign(value, size);
}

inline void StructofStringUInt8::set_has_UInt8Value () {
    _has_bits_[0] |= 1u << 0;
}

inline void StructofStringUInt8::clear_has_UInt8Value () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StructofStringUInt8::set_has_StringValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void StructofStringUInt8::clear_has_StringValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SystemWideRingtonesListType::SystemWideRingtonesListType ()  :
    _ActiveSystemRingtoneID (0u),
    _systemRingtoneList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemWideRingtonesListType::SystemWideRingtonesListType (const SystemWideRingtonesListType &rhs)  :
    _ActiveSystemRingtoneID (0u),
    _systemRingtoneList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemWideRingtonesListType::SystemWideRingtonesListType (uint8 ActiveSystemRingtoneID_, const ::std::vector< RingtoneInfo >& systemRingtoneList_)  :
    _ActiveSystemRingtoneID (ActiveSystemRingtoneID_),
    _systemRingtoneList (systemRingtoneList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemWideRingtonesListType::~SystemWideRingtonesListType() {
}

inline SystemWideRingtonesListType& SystemWideRingtonesListType::operator = (const SystemWideRingtonesListType& rhs) {
    if( this != &rhs ) {
        if (rhs.hasActiveSystemRingtoneID()) {
            setActiveSystemRingtoneID(rhs.getActiveSystemRingtoneID());
        } else {
            clearActiveSystemRingtoneID();
        }
        if (rhs.hasSystemRingtoneList()) {
            setSystemRingtoneList(rhs.getSystemRingtoneList());
        } else {
            clearSystemRingtoneList();
        }
    }
    return *this;
}

inline bool SystemWideRingtonesListType::operator == (const SystemWideRingtonesListType& rhs) const {
    return (((!hasActiveSystemRingtoneID() && !rhs.hasActiveSystemRingtoneID()) || getActiveSystemRingtoneID() == rhs.getActiveSystemRingtoneID()) &&
        ((!hasSystemRingtoneList() && !rhs.hasSystemRingtoneList()) || getSystemRingtoneList() == rhs.getSystemRingtoneList()));
}

inline bool SystemWideRingtonesListType::operator != (const SystemWideRingtonesListType& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemWideRingtonesListType::operator < (const SystemWideRingtonesListType& rhs) const {
    if (hasActiveSystemRingtoneID() || rhs.hasActiveSystemRingtoneID()) {
        if (getActiveSystemRingtoneID() < rhs.getActiveSystemRingtoneID()) return true;
        if (getActiveSystemRingtoneID() > rhs.getActiveSystemRingtoneID()) return false;
    }
    if (hasSystemRingtoneList() || rhs.hasSystemRingtoneList()) {
        if (getSystemRingtoneList() < rhs.getSystemRingtoneList()) return true;
        if (getSystemRingtoneList() > rhs.getSystemRingtoneList()) return false;
    }
    return false;
}

inline bool SystemWideRingtonesListType::operator > (const SystemWideRingtonesListType& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemWideRingtonesListType::clear() {
    clearActiveSystemRingtoneID();
    clearSystemRingtoneList();
}

inline void SystemWideRingtonesListType::clearActiveSystemRingtoneID() {
    if (hasActiveSystemRingtoneID()) {
         clear_has_ActiveSystemRingtoneID();
        _ActiveSystemRingtoneID = 0u;
     }
}

inline bool SystemWideRingtonesListType::hasActiveSystemRingtoneID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SystemWideRingtonesListType::getActiveSystemRingtoneID () const {
    return _ActiveSystemRingtoneID;
}

inline void SystemWideRingtonesListType::setActiveSystemRingtoneID (uint8 ActiveSystemRingtoneID_) {
    set_has_ActiveSystemRingtoneID();
    this->_ActiveSystemRingtoneID = ActiveSystemRingtoneID_;
}

inline void SystemWideRingtonesListType::clearSystemRingtoneList() {
    if (hasSystemRingtoneList()) {
         clear_has_systemRingtoneList();
        _systemRingtoneList.clear();
     }
}

inline bool SystemWideRingtonesListType::hasSystemRingtoneList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< RingtoneInfo >& SystemWideRingtonesListType::getSystemRingtoneList () const {
    return _systemRingtoneList;
}

inline ::std::vector< RingtoneInfo >& SystemWideRingtonesListType::getSystemRingtoneListMutable () {
    set_has_systemRingtoneList();
    return _systemRingtoneList;
}

inline void SystemWideRingtonesListType::setSystemRingtoneList (const ::std::vector< RingtoneInfo >& systemRingtoneList_) {
    set_has_systemRingtoneList();
    this->_systemRingtoneList = systemRingtoneList_;
}

inline void SystemWideRingtonesListType::set_has_ActiveSystemRingtoneID () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemWideRingtonesListType::clear_has_ActiveSystemRingtoneID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SystemWideRingtonesListType::set_has_systemRingtoneList () {
    _has_bits_[0] |= 1u << 1;
}

inline void SystemWideRingtonesListType::clear_has_systemRingtoneList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DeviceRingtoneInfo::DeviceRingtoneInfo ()  :
    _DeviceAddress (),
    _ringtoneInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceRingtoneInfo::DeviceRingtoneInfo (const DeviceRingtoneInfo &rhs)  :
    _DeviceAddress (),
    _ringtoneInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceRingtoneInfo::DeviceRingtoneInfo (const ::std::string& DeviceAddress_, const RingtoneInfo& ringtoneInfo_)  :
    _DeviceAddress (DeviceAddress_),
    _ringtoneInfo (ringtoneInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceRingtoneInfo::~DeviceRingtoneInfo() {
}

inline DeviceRingtoneInfo& DeviceRingtoneInfo::operator = (const DeviceRingtoneInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
        if (rhs.hasRingtoneInfo()) {
            setRingtoneInfo(rhs.getRingtoneInfo());
        } else {
            clearRingtoneInfo();
        }
    }
    return *this;
}

inline bool DeviceRingtoneInfo::operator == (const DeviceRingtoneInfo& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()) &&
        ((!hasRingtoneInfo() && !rhs.hasRingtoneInfo()) || getRingtoneInfo() == rhs.getRingtoneInfo()));
}

inline bool DeviceRingtoneInfo::operator != (const DeviceRingtoneInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceRingtoneInfo::operator < (const DeviceRingtoneInfo& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    if (hasRingtoneInfo() || rhs.hasRingtoneInfo()) {
        if (getRingtoneInfo() < rhs.getRingtoneInfo()) return true;
        if (getRingtoneInfo() > rhs.getRingtoneInfo()) return false;
    }
    return false;
}

inline bool DeviceRingtoneInfo::operator > (const DeviceRingtoneInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceRingtoneInfo::clear() {
    clearDeviceAddress();
    clearRingtoneInfo();
}

inline void DeviceRingtoneInfo::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool DeviceRingtoneInfo::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceRingtoneInfo::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& DeviceRingtoneInfo::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void DeviceRingtoneInfo::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void DeviceRingtoneInfo::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void DeviceRingtoneInfo::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void DeviceRingtoneInfo::clearRingtoneInfo() {
    if (hasRingtoneInfo()) {
         clear_has_ringtoneInfo();
        _ringtoneInfo.clear();
     }
}

inline bool DeviceRingtoneInfo::hasRingtoneInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const RingtoneInfo& DeviceRingtoneInfo::getRingtoneInfo () const {
    return _ringtoneInfo;
}

inline RingtoneInfo& DeviceRingtoneInfo::getRingtoneInfoMutable () {
    set_has_ringtoneInfo();
    return _ringtoneInfo;
}

inline void DeviceRingtoneInfo::setRingtoneInfo (const RingtoneInfo& ringtoneInfo_) {
    set_has_ringtoneInfo();
    this->_ringtoneInfo = ringtoneInfo_;
}

inline void DeviceRingtoneInfo::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceRingtoneInfo::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeviceRingtoneInfo::set_has_ringtoneInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeviceRingtoneInfo::clear_has_ringtoneInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  OnOffSetting::OnOffSetting ()  :
    _DeviceAddress (),
    _OnOffValue (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnOffSetting::OnOffSetting (const OnOffSetting &rhs)  :
    _DeviceAddress (),
    _OnOffValue (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnOffSetting::OnOffSetting (const ::std::string& DeviceAddress_, bool OnOffValue_)  :
    _DeviceAddress (DeviceAddress_),
    _OnOffValue (OnOffValue_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnOffSetting::~OnOffSetting() {
}

inline OnOffSetting& OnOffSetting::operator = (const OnOffSetting& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
        if (rhs.hasOnOffValue()) {
            setOnOffValue(rhs.getOnOffValue());
        } else {
            clearOnOffValue();
        }
    }
    return *this;
}

inline bool OnOffSetting::operator == (const OnOffSetting& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()) &&
        ((!hasOnOffValue() && !rhs.hasOnOffValue()) || getOnOffValue() == rhs.getOnOffValue()));
}

inline bool OnOffSetting::operator != (const OnOffSetting& rhs) const {
    return ! (*this == rhs);
}

inline bool OnOffSetting::operator < (const OnOffSetting& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    if (hasOnOffValue() || rhs.hasOnOffValue()) {
        if (getOnOffValue() < rhs.getOnOffValue()) return true;
        if (getOnOffValue() > rhs.getOnOffValue()) return false;
    }
    return false;
}

inline bool OnOffSetting::operator > (const OnOffSetting& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnOffSetting::clear() {
    clearDeviceAddress();
    clearOnOffValue();
}

inline void OnOffSetting::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool OnOffSetting::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& OnOffSetting::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& OnOffSetting::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void OnOffSetting::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void OnOffSetting::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void OnOffSetting::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void OnOffSetting::clearOnOffValue() {
    if (hasOnOffValue()) {
         clear_has_OnOffValue();
        _OnOffValue = false;
     }
}

inline bool OnOffSetting::hasOnOffValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool OnOffSetting::getOnOffValue () const {
    return _OnOffValue;
}

inline void OnOffSetting::setOnOffValue (bool OnOffValue_) {
    set_has_OnOffValue();
    this->_OnOffValue = OnOffValue_;
}

inline void OnOffSetting::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnOffSetting::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnOffSetting::set_has_OnOffValue () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnOffSetting::clear_has_OnOffValue () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DeviceObjectPathInfo::DeviceObjectPathInfo ()  :
    _DeviceAddress (),
    _ObjectPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceObjectPathInfo::DeviceObjectPathInfo (const DeviceObjectPathInfo &rhs)  :
    _DeviceAddress (),
    _ObjectPath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceObjectPathInfo::DeviceObjectPathInfo (const ::std::string& DeviceAddress_, const ::std::string& ObjectPath_)  :
    _DeviceAddress (DeviceAddress_),
    _ObjectPath (ObjectPath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjectPath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceObjectPathInfo::~DeviceObjectPathInfo() {
}

inline DeviceObjectPathInfo& DeviceObjectPathInfo::operator = (const DeviceObjectPathInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
        if (rhs.hasObjectPath()) {
            setObjectPath(rhs.getObjectPath());
        } else {
            clearObjectPath();
        }
    }
    return *this;
}

inline bool DeviceObjectPathInfo::operator == (const DeviceObjectPathInfo& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()) &&
        ((!hasObjectPath() && !rhs.hasObjectPath()) || getObjectPath() == rhs.getObjectPath()));
}

inline bool DeviceObjectPathInfo::operator != (const DeviceObjectPathInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceObjectPathInfo::operator < (const DeviceObjectPathInfo& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    if (hasObjectPath() || rhs.hasObjectPath()) {
        if (getObjectPath() < rhs.getObjectPath()) return true;
        if (getObjectPath() > rhs.getObjectPath()) return false;
    }
    return false;
}

inline bool DeviceObjectPathInfo::operator > (const DeviceObjectPathInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceObjectPathInfo::clear() {
    clearDeviceAddress();
    clearObjectPath();
}

inline void DeviceObjectPathInfo::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool DeviceObjectPathInfo::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceObjectPathInfo::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& DeviceObjectPathInfo::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void DeviceObjectPathInfo::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void DeviceObjectPathInfo::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void DeviceObjectPathInfo::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void DeviceObjectPathInfo::clearObjectPath() {
    if (hasObjectPath()) {
         clear_has_ObjectPath();
        _ObjectPath.clear();
     }
}

inline bool DeviceObjectPathInfo::hasObjectPath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DeviceObjectPathInfo::getObjectPath () const {
    return _ObjectPath;
}

inline ::std::string& DeviceObjectPathInfo::getObjectPathMutable () {
    set_has_ObjectPath();
    return _ObjectPath;
}

inline void DeviceObjectPathInfo::setObjectPath (const ::std::string& ObjectPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjectPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjectPath();
    this->_ObjectPath = ObjectPath_;
}

inline void DeviceObjectPathInfo::setObjectPath (const char* ObjectPath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ObjectPath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjectPath();
    this->_ObjectPath.assign(ObjectPath_);
}

inline void DeviceObjectPathInfo::setObjectPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ObjectPath();
    this->_ObjectPath.assign(value, size);
}

inline void DeviceObjectPathInfo::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceObjectPathInfo::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeviceObjectPathInfo::set_has_ObjectPath () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeviceObjectPathInfo::clear_has_ObjectPath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  HfpManagerVariant::HfpManagerVariant () :
    __field (E_BOOLEAN),
    _data()
{
    _data.boolean_ = false;
}

inline  HfpManagerVariant::HfpManagerVariant (const HfpManagerVariant& rhs) :
    __field (E_BOOLEAN),
    _data()
{
    _data.boolean_ = false;
    *this = rhs;
}

inline  HfpManagerVariant::~HfpManagerVariant() {
    deleteData ();
}

inline HfpManagerVariant& HfpManagerVariant::operator = (const HfpManagerVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool HfpManagerVariant::operator == (const HfpManagerVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_BOOLEAN:
            return (getBoolean() == rhs.getBoolean());
        case E_SYSTEM_WIDE_RINGTONES_LIST_TYPE:
            if (_data.systemWideRingtonesListType_ == NULL && rhs._data.systemWideRingtonesListType_ == NULL) {
                return true;
            }
            return (getSystemWideRingtonesListType() == rhs.getSystemWideRingtonesListType());
        case E_DEVICE_RINGTONE_LIST_TYPE:
            if (_data.deviceRingtoneListType_ == NULL && rhs._data.deviceRingtoneListType_ == NULL) {
                return true;
            }
            return (getDeviceRingtoneListType() == rhs.getDeviceRingtoneListType());
        case E_SUPPRESS_RINGTONE_LIST_TYPE:
            if (_data.suppressRingtoneListType_ == NULL && rhs._data.suppressRingtoneListType_ == NULL) {
                return true;
            }
            return (getSuppressRingtoneListType() == rhs.getSuppressRingtoneListType());
        case E_AUTO_WAITING_MODE_LIST_TYPE:
            if (_data.autoWaitingModeListType_ == NULL && rhs._data.autoWaitingModeListType_ == NULL) {
                return true;
            }
            return (getAutoWaitingModeListType() == rhs.getAutoWaitingModeListType());
        case E_WAITING_MODE_FILE_PATH_TYPE:
            if (_data.waitingModeFilePathType_ == NULL && rhs._data.waitingModeFilePathType_ == NULL) {
                return true;
            }
            return (getWaitingModeFilePathType() == rhs.getWaitingModeFilePathType());
        case E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE:
            if (_data.activePassiveDeviceListType_ == NULL && rhs._data.activePassiveDeviceListType_ == NULL) {
                return true;
            }
            return (getActivePassiveDeviceListType() == rhs.getActivePassiveDeviceListType());
        case E_DEVICE_OBJECT_PATH_LIST_TYPE:
            if (_data.deviceObjectPathListType_ == NULL && rhs._data.deviceObjectPathListType_ == NULL) {
                return true;
            }
            return (getDeviceObjectPathListType() == rhs.getDeviceObjectPathListType());
        default:
            return false;
        }
    }
    return false;
}

inline bool HfpManagerVariant::operator != (const HfpManagerVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool HfpManagerVariant::operator < (const HfpManagerVariant& rhs) const  {
    if (hasBoolean() && rhs.hasBoolean()) {
        if (getBoolean() < rhs.getBoolean()) return true;
        if (getBoolean() > rhs.getBoolean()) return false;
    } else {
        if (hasBoolean() && !rhs.hasBoolean())
            return true;
        else if (!hasBoolean() && rhs.hasBoolean())
            return false;
    }

    if (hasSystemWideRingtonesListType() && rhs.hasSystemWideRingtonesListType()) {
        if (getSystemWideRingtonesListType() < rhs.getSystemWideRingtonesListType()) return true;
        if (getSystemWideRingtonesListType() > rhs.getSystemWideRingtonesListType()) return false;
    } else {
        if (hasSystemWideRingtonesListType() && !rhs.hasSystemWideRingtonesListType())
            return true;
        else if (!hasSystemWideRingtonesListType() && rhs.hasSystemWideRingtonesListType())
            return false;
    }

    if (hasDeviceRingtoneListType() && rhs.hasDeviceRingtoneListType()) {
        if (getDeviceRingtoneListType() < rhs.getDeviceRingtoneListType()) return true;
        if (getDeviceRingtoneListType() > rhs.getDeviceRingtoneListType()) return false;
    } else {
        if (hasDeviceRingtoneListType() && !rhs.hasDeviceRingtoneListType())
            return true;
        else if (!hasDeviceRingtoneListType() && rhs.hasDeviceRingtoneListType())
            return false;
    }

    if (hasSuppressRingtoneListType() && rhs.hasSuppressRingtoneListType()) {
        if (getSuppressRingtoneListType() < rhs.getSuppressRingtoneListType()) return true;
        if (getSuppressRingtoneListType() > rhs.getSuppressRingtoneListType()) return false;
    } else {
        if (hasSuppressRingtoneListType() && !rhs.hasSuppressRingtoneListType())
            return true;
        else if (!hasSuppressRingtoneListType() && rhs.hasSuppressRingtoneListType())
            return false;
    }

    if (hasAutoWaitingModeListType() && rhs.hasAutoWaitingModeListType()) {
        if (getAutoWaitingModeListType() < rhs.getAutoWaitingModeListType()) return true;
        if (getAutoWaitingModeListType() > rhs.getAutoWaitingModeListType()) return false;
    } else {
        if (hasAutoWaitingModeListType() && !rhs.hasAutoWaitingModeListType())
            return true;
        else if (!hasAutoWaitingModeListType() && rhs.hasAutoWaitingModeListType())
            return false;
    }

    if (hasWaitingModeFilePathType() && rhs.hasWaitingModeFilePathType()) {
        if (getWaitingModeFilePathType() < rhs.getWaitingModeFilePathType()) return true;
        if (getWaitingModeFilePathType() > rhs.getWaitingModeFilePathType()) return false;
    } else {
        if (hasWaitingModeFilePathType() && !rhs.hasWaitingModeFilePathType())
            return true;
        else if (!hasWaitingModeFilePathType() && rhs.hasWaitingModeFilePathType())
            return false;
    }

    if (hasActivePassiveDeviceListType() && rhs.hasActivePassiveDeviceListType()) {
        if (getActivePassiveDeviceListType() < rhs.getActivePassiveDeviceListType()) return true;
        if (getActivePassiveDeviceListType() > rhs.getActivePassiveDeviceListType()) return false;
    } else {
        if (hasActivePassiveDeviceListType() && !rhs.hasActivePassiveDeviceListType())
            return true;
        else if (!hasActivePassiveDeviceListType() && rhs.hasActivePassiveDeviceListType())
            return false;
    }

    if (hasDeviceObjectPathListType() && rhs.hasDeviceObjectPathListType()) {
        if (getDeviceObjectPathListType() < rhs.getDeviceObjectPathListType()) return true;
        if (getDeviceObjectPathListType() > rhs.getDeviceObjectPathListType()) return false;
    } else {
        if (hasDeviceObjectPathListType() && !rhs.hasDeviceObjectPathListType())
            return true;
        else if (!hasDeviceObjectPathListType() && rhs.hasDeviceObjectPathListType())
            return false;
    }

    return false;
}

inline bool HfpManagerVariant::operator > (const HfpManagerVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline HfpManagerVariant::HfpManagerVariantField HfpManagerVariant::getField () const {
    return __field;
}

inline void HfpManagerVariant::setField(HfpManagerVariant::HfpManagerVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_BOOLEAN:
        _data.boolean_ = false;
        break;
    case E_SYSTEM_WIDE_RINGTONES_LIST_TYPE:
        _data.systemWideRingtonesListType_ = NULL;
        break;
    case E_DEVICE_RINGTONE_LIST_TYPE:
        _data.deviceRingtoneListType_ = NULL;
        break;
    case E_SUPPRESS_RINGTONE_LIST_TYPE:
        _data.suppressRingtoneListType_ = NULL;
        break;
    case E_AUTO_WAITING_MODE_LIST_TYPE:
        _data.autoWaitingModeListType_ = NULL;
        break;
    case E_WAITING_MODE_FILE_PATH_TYPE:
        _data.waitingModeFilePathType_ = NULL;
        break;
    case E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE:
        _data.activePassiveDeviceListType_ = NULL;
        break;
    case E_DEVICE_OBJECT_PATH_LIST_TYPE:
        _data.deviceObjectPathListType_ = NULL;
        break;
    default:
        break;
    }
}

inline bool HfpManagerVariant::hasBoolean () const {
    return __field == E_BOOLEAN;
}

inline bool HfpManagerVariant::getBoolean() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasBoolean(), "Can't provide value for union field '%s' of union '%s', have field %d", "boolean", "HfpManagerVariant", getField());
    }
    return _data.boolean_;
}

inline void HfpManagerVariant::setBoolean (bool value) {
    if (__field != E_BOOLEAN) {
        deleteData ();
        __field = E_BOOLEAN;
    }
    _data.boolean_ = (bool)value;
}

inline bool HfpManagerVariant::hasSystemWideRingtonesListType () const {
    return __field == E_SYSTEM_WIDE_RINGTONES_LIST_TYPE;
}

inline const SystemWideRingtonesListType& HfpManagerVariant::getSystemWideRingtonesListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemWideRingtonesListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemWideRingtonesListType", "HfpManagerVariant", getField());
    }
    if (hasSystemWideRingtonesListType()) {
        if (_data.systemWideRingtonesListType_ == NULL) {
            return SystemWideRingtonesListType::getDefaultInstance();
        }
        return *_data.systemWideRingtonesListType_;
    }
    abort();
}

inline SystemWideRingtonesListType& HfpManagerVariant::getSystemWideRingtonesListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemWideRingtonesListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemWideRingtonesListType", "HfpManagerVariant", getField());
    }
    if (hasSystemWideRingtonesListType()) {
        if (_data.systemWideRingtonesListType_ == NULL) {
            _data.systemWideRingtonesListType_ = new SystemWideRingtonesListType();
            CHECK_ALLOCATION( _data.systemWideRingtonesListType_ );
        }
        return *_data.systemWideRingtonesListType_;
    }
    abort();
}

inline SystemWideRingtonesListType* HfpManagerVariant::releaseSystemWideRingtonesListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSystemWideRingtonesListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasSystemWideRingtonesListType()) {
        if (_data.systemWideRingtonesListType_ == NULL) {
            _data.systemWideRingtonesListType_ = new SystemWideRingtonesListType();
            CHECK_ALLOCATION( _data.systemWideRingtonesListType_ );
        }
        SystemWideRingtonesListType* temp = _data.systemWideRingtonesListType_;
        _data.systemWideRingtonesListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceSystemWideRingtonesListType (SystemWideRingtonesListType* systemWideRingtonesListType) {
    if (__field != E_SYSTEM_WIDE_RINGTONES_LIST_TYPE || _data.systemWideRingtonesListType_ != systemWideRingtonesListType) {
        deleteData ();
        __field = E_SYSTEM_WIDE_RINGTONES_LIST_TYPE;
        _data.systemWideRingtonesListType_ = systemWideRingtonesListType;
    }
}

inline void HfpManagerVariant::setSystemWideRingtonesListType (const SystemWideRingtonesListType& value) {
    if (__field == E_SYSTEM_WIDE_RINGTONES_LIST_TYPE && _data.systemWideRingtonesListType_ != NULL) {
        *_data.systemWideRingtonesListType_ = value;
    } else {
        deleteData ();
        __field = E_SYSTEM_WIDE_RINGTONES_LIST_TYPE;
        _data.systemWideRingtonesListType_ = new SystemWideRingtonesListType(value);
    }
}

inline bool HfpManagerVariant::hasDeviceRingtoneListType () const {
    return __field == E_DEVICE_RINGTONE_LIST_TYPE;
}

inline const ::std::vector< DeviceRingtoneInfo >& HfpManagerVariant::getDeviceRingtoneListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasDeviceRingtoneListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "deviceRingtoneListType", "HfpManagerVariant", getField());
    }
    if (hasDeviceRingtoneListType()) {
        if (_data.deviceRingtoneListType_ == NULL) {
            return getDeviceRingtoneInfoList_DefaultInstance();
        }
        return *_data.deviceRingtoneListType_;
    }
    abort();
}

inline ::std::vector< DeviceRingtoneInfo >& HfpManagerVariant::getDeviceRingtoneListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasDeviceRingtoneListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "deviceRingtoneListType", "HfpManagerVariant", getField());
    }
    if (hasDeviceRingtoneListType()) {
        if (_data.deviceRingtoneListType_ == NULL) {
            _data.deviceRingtoneListType_ = new ::std::vector< DeviceRingtoneInfo >();
            CHECK_ALLOCATION( _data.deviceRingtoneListType_ );
        }
        return *_data.deviceRingtoneListType_;
    }
    abort();
}

inline ::std::vector< DeviceRingtoneInfo >* HfpManagerVariant::releaseDeviceRingtoneListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasDeviceRingtoneListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasDeviceRingtoneListType()) {
        if (_data.deviceRingtoneListType_ == NULL) {
            _data.deviceRingtoneListType_ = new ::std::vector< DeviceRingtoneInfo >();
            CHECK_ALLOCATION( _data.deviceRingtoneListType_ );
        }
        ::std::vector< DeviceRingtoneInfo >* temp = _data.deviceRingtoneListType_;
        _data.deviceRingtoneListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceDeviceRingtoneListType (::std::vector< DeviceRingtoneInfo >* deviceRingtoneListType) {
    if (__field != E_DEVICE_RINGTONE_LIST_TYPE || _data.deviceRingtoneListType_ != deviceRingtoneListType) {
        deleteData ();
        __field = E_DEVICE_RINGTONE_LIST_TYPE;
        _data.deviceRingtoneListType_ = deviceRingtoneListType;
    }
}

inline void HfpManagerVariant::setDeviceRingtoneListType (const ::std::vector< DeviceRingtoneInfo >& value) {
    if (__field == E_DEVICE_RINGTONE_LIST_TYPE && _data.deviceRingtoneListType_ != NULL) {
        *_data.deviceRingtoneListType_ = value;
    } else {
        deleteData ();
        __field = E_DEVICE_RINGTONE_LIST_TYPE;
        _data.deviceRingtoneListType_ = new ::std::vector< DeviceRingtoneInfo >(value);
    }
}

inline bool HfpManagerVariant::hasSuppressRingtoneListType () const {
    return __field == E_SUPPRESS_RINGTONE_LIST_TYPE;
}

inline const ::std::vector< OnOffSetting >& HfpManagerVariant::getSuppressRingtoneListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSuppressRingtoneListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "suppressRingtoneListType", "HfpManagerVariant", getField());
    }
    if (hasSuppressRingtoneListType()) {
        if (_data.suppressRingtoneListType_ == NULL) {
            return getOnOffSettingList_DefaultInstance();
        }
        return *_data.suppressRingtoneListType_;
    }
    abort();
}

inline ::std::vector< OnOffSetting >& HfpManagerVariant::getSuppressRingtoneListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSuppressRingtoneListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "suppressRingtoneListType", "HfpManagerVariant", getField());
    }
    if (hasSuppressRingtoneListType()) {
        if (_data.suppressRingtoneListType_ == NULL) {
            _data.suppressRingtoneListType_ = new ::std::vector< OnOffSetting >();
            CHECK_ALLOCATION( _data.suppressRingtoneListType_ );
        }
        return *_data.suppressRingtoneListType_;
    }
    abort();
}

inline ::std::vector< OnOffSetting >* HfpManagerVariant::releaseSuppressRingtoneListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSuppressRingtoneListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasSuppressRingtoneListType()) {
        if (_data.suppressRingtoneListType_ == NULL) {
            _data.suppressRingtoneListType_ = new ::std::vector< OnOffSetting >();
            CHECK_ALLOCATION( _data.suppressRingtoneListType_ );
        }
        ::std::vector< OnOffSetting >* temp = _data.suppressRingtoneListType_;
        _data.suppressRingtoneListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceSuppressRingtoneListType (::std::vector< OnOffSetting >* suppressRingtoneListType) {
    if (__field != E_SUPPRESS_RINGTONE_LIST_TYPE || _data.suppressRingtoneListType_ != suppressRingtoneListType) {
        deleteData ();
        __field = E_SUPPRESS_RINGTONE_LIST_TYPE;
        _data.suppressRingtoneListType_ = suppressRingtoneListType;
    }
}

inline void HfpManagerVariant::setSuppressRingtoneListType (const ::std::vector< OnOffSetting >& value) {
    if (__field == E_SUPPRESS_RINGTONE_LIST_TYPE && _data.suppressRingtoneListType_ != NULL) {
        *_data.suppressRingtoneListType_ = value;
    } else {
        deleteData ();
        __field = E_SUPPRESS_RINGTONE_LIST_TYPE;
        _data.suppressRingtoneListType_ = new ::std::vector< OnOffSetting >(value);
    }
}

inline bool HfpManagerVariant::hasAutoWaitingModeListType () const {
    return __field == E_AUTO_WAITING_MODE_LIST_TYPE;
}

inline const ::std::vector< OnOffSetting >& HfpManagerVariant::getAutoWaitingModeListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAutoWaitingModeListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "autoWaitingModeListType", "HfpManagerVariant", getField());
    }
    if (hasAutoWaitingModeListType()) {
        if (_data.autoWaitingModeListType_ == NULL) {
            return getOnOffSettingList_DefaultInstance();
        }
        return *_data.autoWaitingModeListType_;
    }
    abort();
}

inline ::std::vector< OnOffSetting >& HfpManagerVariant::getAutoWaitingModeListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasAutoWaitingModeListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "autoWaitingModeListType", "HfpManagerVariant", getField());
    }
    if (hasAutoWaitingModeListType()) {
        if (_data.autoWaitingModeListType_ == NULL) {
            _data.autoWaitingModeListType_ = new ::std::vector< OnOffSetting >();
            CHECK_ALLOCATION( _data.autoWaitingModeListType_ );
        }
        return *_data.autoWaitingModeListType_;
    }
    abort();
}

inline ::std::vector< OnOffSetting >* HfpManagerVariant::releaseAutoWaitingModeListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasAutoWaitingModeListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasAutoWaitingModeListType()) {
        if (_data.autoWaitingModeListType_ == NULL) {
            _data.autoWaitingModeListType_ = new ::std::vector< OnOffSetting >();
            CHECK_ALLOCATION( _data.autoWaitingModeListType_ );
        }
        ::std::vector< OnOffSetting >* temp = _data.autoWaitingModeListType_;
        _data.autoWaitingModeListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceAutoWaitingModeListType (::std::vector< OnOffSetting >* autoWaitingModeListType) {
    if (__field != E_AUTO_WAITING_MODE_LIST_TYPE || _data.autoWaitingModeListType_ != autoWaitingModeListType) {
        deleteData ();
        __field = E_AUTO_WAITING_MODE_LIST_TYPE;
        _data.autoWaitingModeListType_ = autoWaitingModeListType;
    }
}

inline void HfpManagerVariant::setAutoWaitingModeListType (const ::std::vector< OnOffSetting >& value) {
    if (__field == E_AUTO_WAITING_MODE_LIST_TYPE && _data.autoWaitingModeListType_ != NULL) {
        *_data.autoWaitingModeListType_ = value;
    } else {
        deleteData ();
        __field = E_AUTO_WAITING_MODE_LIST_TYPE;
        _data.autoWaitingModeListType_ = new ::std::vector< OnOffSetting >(value);
    }
}

inline bool HfpManagerVariant::hasWaitingModeFilePathType () const {
    return __field == E_WAITING_MODE_FILE_PATH_TYPE;
}

inline const WaitingModeFilePathType& HfpManagerVariant::getWaitingModeFilePathType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasWaitingModeFilePathType(), "Can't provide value for union field '%s' of union '%s', have field %d", "waitingModeFilePathType", "HfpManagerVariant", getField());
    }
    if (hasWaitingModeFilePathType()) {
        if (_data.waitingModeFilePathType_ == NULL) {
            return getStringToStringMap_DefaultInstance();
        }
        return *_data.waitingModeFilePathType_;
    }
    abort();
}

inline WaitingModeFilePathType& HfpManagerVariant::getWaitingModeFilePathTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasWaitingModeFilePathType(), "Can't provide value for union field '%s' of union '%s', have field %d", "waitingModeFilePathType", "HfpManagerVariant", getField());
    }
    if (hasWaitingModeFilePathType()) {
        if (_data.waitingModeFilePathType_ == NULL) {
            _data.waitingModeFilePathType_ = new WaitingModeFilePathType();
            CHECK_ALLOCATION( _data.waitingModeFilePathType_ );
        }
        return *_data.waitingModeFilePathType_;
    }
    abort();
}

inline WaitingModeFilePathType* HfpManagerVariant::releaseWaitingModeFilePathType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasWaitingModeFilePathType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasWaitingModeFilePathType()) {
        if (_data.waitingModeFilePathType_ == NULL) {
            _data.waitingModeFilePathType_ = new WaitingModeFilePathType();
            CHECK_ALLOCATION( _data.waitingModeFilePathType_ );
        }
        WaitingModeFilePathType* temp = _data.waitingModeFilePathType_;
        _data.waitingModeFilePathType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceWaitingModeFilePathType (WaitingModeFilePathType* waitingModeFilePathType) {
    if (__field != E_WAITING_MODE_FILE_PATH_TYPE || _data.waitingModeFilePathType_ != waitingModeFilePathType) {
        deleteData ();
        __field = E_WAITING_MODE_FILE_PATH_TYPE;
        _data.waitingModeFilePathType_ = waitingModeFilePathType;
    }
}

inline void HfpManagerVariant::setWaitingModeFilePathType (const WaitingModeFilePathType& value) {
    if (__field == E_WAITING_MODE_FILE_PATH_TYPE && _data.waitingModeFilePathType_ != NULL) {
        *_data.waitingModeFilePathType_ = value;
    } else {
        deleteData ();
        __field = E_WAITING_MODE_FILE_PATH_TYPE;
        _data.waitingModeFilePathType_ = new WaitingModeFilePathType(value);
    }
}

inline bool HfpManagerVariant::hasActivePassiveDeviceListType () const {
    return __field == E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE;
}

inline const ::std::vector< HfpRoleInfo >& HfpManagerVariant::getActivePassiveDeviceListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasActivePassiveDeviceListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "activePassiveDeviceListType", "HfpManagerVariant", getField());
    }
    if (hasActivePassiveDeviceListType()) {
        if (_data.activePassiveDeviceListType_ == NULL) {
            return getHfpRoleInfoList_DefaultInstance();
        }
        return *_data.activePassiveDeviceListType_;
    }
    abort();
}

inline ::std::vector< HfpRoleInfo >& HfpManagerVariant::getActivePassiveDeviceListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasActivePassiveDeviceListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "activePassiveDeviceListType", "HfpManagerVariant", getField());
    }
    if (hasActivePassiveDeviceListType()) {
        if (_data.activePassiveDeviceListType_ == NULL) {
            _data.activePassiveDeviceListType_ = new ::std::vector< HfpRoleInfo >();
            CHECK_ALLOCATION( _data.activePassiveDeviceListType_ );
        }
        return *_data.activePassiveDeviceListType_;
    }
    abort();
}

inline ::std::vector< HfpRoleInfo >* HfpManagerVariant::releaseActivePassiveDeviceListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasActivePassiveDeviceListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasActivePassiveDeviceListType()) {
        if (_data.activePassiveDeviceListType_ == NULL) {
            _data.activePassiveDeviceListType_ = new ::std::vector< HfpRoleInfo >();
            CHECK_ALLOCATION( _data.activePassiveDeviceListType_ );
        }
        ::std::vector< HfpRoleInfo >* temp = _data.activePassiveDeviceListType_;
        _data.activePassiveDeviceListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceActivePassiveDeviceListType (::std::vector< HfpRoleInfo >* activePassiveDeviceListType) {
    if (__field != E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE || _data.activePassiveDeviceListType_ != activePassiveDeviceListType) {
        deleteData ();
        __field = E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE;
        _data.activePassiveDeviceListType_ = activePassiveDeviceListType;
    }
}

inline void HfpManagerVariant::setActivePassiveDeviceListType (const ::std::vector< HfpRoleInfo >& value) {
    if (__field == E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE && _data.activePassiveDeviceListType_ != NULL) {
        *_data.activePassiveDeviceListType_ = value;
    } else {
        deleteData ();
        __field = E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE;
        _data.activePassiveDeviceListType_ = new ::std::vector< HfpRoleInfo >(value);
    }
}

inline bool HfpManagerVariant::hasDeviceObjectPathListType () const {
    return __field == E_DEVICE_OBJECT_PATH_LIST_TYPE;
}

inline const ::std::vector< DeviceObjectPathInfo >& HfpManagerVariant::getDeviceObjectPathListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasDeviceObjectPathListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "deviceObjectPathListType", "HfpManagerVariant", getField());
    }
    if (hasDeviceObjectPathListType()) {
        if (_data.deviceObjectPathListType_ == NULL) {
            return getDeviceObjectPathInfoList_DefaultInstance();
        }
        return *_data.deviceObjectPathListType_;
    }
    abort();
}

inline ::std::vector< DeviceObjectPathInfo >& HfpManagerVariant::getDeviceObjectPathListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasDeviceObjectPathListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "deviceObjectPathListType", "HfpManagerVariant", getField());
    }
    if (hasDeviceObjectPathListType()) {
        if (_data.deviceObjectPathListType_ == NULL) {
            _data.deviceObjectPathListType_ = new ::std::vector< DeviceObjectPathInfo >();
            CHECK_ALLOCATION( _data.deviceObjectPathListType_ );
        }
        return *_data.deviceObjectPathListType_;
    }
    abort();
}

inline ::std::vector< DeviceObjectPathInfo >* HfpManagerVariant::releaseDeviceObjectPathListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasDeviceObjectPathListType(), "Can't release value for field 'HfpManagerVariant', have field %d", getField());
    }
    if (hasDeviceObjectPathListType()) {
        if (_data.deviceObjectPathListType_ == NULL) {
            _data.deviceObjectPathListType_ = new ::std::vector< DeviceObjectPathInfo >();
            CHECK_ALLOCATION( _data.deviceObjectPathListType_ );
        }
        ::std::vector< DeviceObjectPathInfo >* temp = _data.deviceObjectPathListType_;
        _data.deviceObjectPathListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void HfpManagerVariant::replaceDeviceObjectPathListType (::std::vector< DeviceObjectPathInfo >* deviceObjectPathListType) {
    if (__field != E_DEVICE_OBJECT_PATH_LIST_TYPE || _data.deviceObjectPathListType_ != deviceObjectPathListType) {
        deleteData ();
        __field = E_DEVICE_OBJECT_PATH_LIST_TYPE;
        _data.deviceObjectPathListType_ = deviceObjectPathListType;
    }
}

inline void HfpManagerVariant::setDeviceObjectPathListType (const ::std::vector< DeviceObjectPathInfo >& value) {
    if (__field == E_DEVICE_OBJECT_PATH_LIST_TYPE && _data.deviceObjectPathListType_ != NULL) {
        *_data.deviceObjectPathListType_ = value;
    } else {
        deleteData ();
        __field = E_DEVICE_OBJECT_PATH_LIST_TYPE;
        _data.deviceObjectPathListType_ = new ::std::vector< DeviceObjectPathInfo >(value);
    }
}

inline void HfpManagerVariant::cloneData (const HfpManagerVariant& rhs) {
    switch (rhs.__field) {
    case E_BOOLEAN:
        _data.boolean_ = rhs._data.boolean_;
        break;
    case E_SYSTEM_WIDE_RINGTONES_LIST_TYPE:
        if (__field == E_SYSTEM_WIDE_RINGTONES_LIST_TYPE) {
            if (rhs._data.systemWideRingtonesListType_ == NULL)
                deleteData ();
            else {
                if (_data.systemWideRingtonesListType_ != NULL) {
                    *_data.systemWideRingtonesListType_ =  *rhs._data.systemWideRingtonesListType_;
                } else {
                    _data.systemWideRingtonesListType_ = new SystemWideRingtonesListType(*rhs._data.systemWideRingtonesListType_);
                }
            }
        } else {
            if (_data.systemWideRingtonesListType_ != 0) deleteData ();
            if (rhs._data.systemWideRingtonesListType_ != NULL) {
                _data.systemWideRingtonesListType_ = new SystemWideRingtonesListType(*rhs._data.systemWideRingtonesListType_);
            }
        }
        break;
    case E_DEVICE_RINGTONE_LIST_TYPE:
        if (__field == E_DEVICE_RINGTONE_LIST_TYPE) {
            if (rhs._data.deviceRingtoneListType_ == NULL)
                deleteData ();
            else {
                if (_data.deviceRingtoneListType_ != NULL) {
                    *_data.deviceRingtoneListType_ =  *rhs._data.deviceRingtoneListType_;
                } else {
                    _data.deviceRingtoneListType_ = new ::std::vector< DeviceRingtoneInfo >(*rhs._data.deviceRingtoneListType_);
                }
            }
        } else {
            if (_data.deviceRingtoneListType_ != 0) deleteData ();
            if (rhs._data.deviceRingtoneListType_ != NULL) {
                _data.deviceRingtoneListType_ = new ::std::vector< DeviceRingtoneInfo >(*rhs._data.deviceRingtoneListType_);
            }
        }
        break;
    case E_SUPPRESS_RINGTONE_LIST_TYPE:
        if (__field == E_SUPPRESS_RINGTONE_LIST_TYPE) {
            if (rhs._data.suppressRingtoneListType_ == NULL)
                deleteData ();
            else {
                if (_data.suppressRingtoneListType_ != NULL) {
                    *_data.suppressRingtoneListType_ =  *rhs._data.suppressRingtoneListType_;
                } else {
                    _data.suppressRingtoneListType_ = new ::std::vector< OnOffSetting >(*rhs._data.suppressRingtoneListType_);
                }
            }
        } else {
            if (_data.suppressRingtoneListType_ != 0) deleteData ();
            if (rhs._data.suppressRingtoneListType_ != NULL) {
                _data.suppressRingtoneListType_ = new ::std::vector< OnOffSetting >(*rhs._data.suppressRingtoneListType_);
            }
        }
        break;
    case E_AUTO_WAITING_MODE_LIST_TYPE:
        if (__field == E_AUTO_WAITING_MODE_LIST_TYPE) {
            if (rhs._data.autoWaitingModeListType_ == NULL)
                deleteData ();
            else {
                if (_data.autoWaitingModeListType_ != NULL) {
                    *_data.autoWaitingModeListType_ =  *rhs._data.autoWaitingModeListType_;
                } else {
                    _data.autoWaitingModeListType_ = new ::std::vector< OnOffSetting >(*rhs._data.autoWaitingModeListType_);
                }
            }
        } else {
            if (_data.autoWaitingModeListType_ != 0) deleteData ();
            if (rhs._data.autoWaitingModeListType_ != NULL) {
                _data.autoWaitingModeListType_ = new ::std::vector< OnOffSetting >(*rhs._data.autoWaitingModeListType_);
            }
        }
        break;
    case E_WAITING_MODE_FILE_PATH_TYPE:
        if (__field == E_WAITING_MODE_FILE_PATH_TYPE) {
            if (rhs._data.waitingModeFilePathType_ == NULL)
                deleteData ();
            else {
                if (_data.waitingModeFilePathType_ != NULL) {
                    *_data.waitingModeFilePathType_ =  *rhs._data.waitingModeFilePathType_;
                } else {
                    _data.waitingModeFilePathType_ = new WaitingModeFilePathType(*rhs._data.waitingModeFilePathType_);
                }
            }
        } else {
            if (_data.waitingModeFilePathType_ != 0) deleteData ();
            if (rhs._data.waitingModeFilePathType_ != NULL) {
                _data.waitingModeFilePathType_ = new WaitingModeFilePathType(*rhs._data.waitingModeFilePathType_);
            }
        }
        break;
    case E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE:
        if (__field == E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE) {
            if (rhs._data.activePassiveDeviceListType_ == NULL)
                deleteData ();
            else {
                if (_data.activePassiveDeviceListType_ != NULL) {
                    *_data.activePassiveDeviceListType_ =  *rhs._data.activePassiveDeviceListType_;
                } else {
                    _data.activePassiveDeviceListType_ = new ::std::vector< HfpRoleInfo >(*rhs._data.activePassiveDeviceListType_);
                }
            }
        } else {
            if (_data.activePassiveDeviceListType_ != 0) deleteData ();
            if (rhs._data.activePassiveDeviceListType_ != NULL) {
                _data.activePassiveDeviceListType_ = new ::std::vector< HfpRoleInfo >(*rhs._data.activePassiveDeviceListType_);
            }
        }
        break;
    case E_DEVICE_OBJECT_PATH_LIST_TYPE:
        if (__field == E_DEVICE_OBJECT_PATH_LIST_TYPE) {
            if (rhs._data.deviceObjectPathListType_ == NULL)
                deleteData ();
            else {
                if (_data.deviceObjectPathListType_ != NULL) {
                    *_data.deviceObjectPathListType_ =  *rhs._data.deviceObjectPathListType_;
                } else {
                    _data.deviceObjectPathListType_ = new ::std::vector< DeviceObjectPathInfo >(*rhs._data.deviceObjectPathListType_);
                }
            }
        } else {
            if (_data.deviceObjectPathListType_ != 0) deleteData ();
            if (rhs._data.deviceObjectPathListType_ != NULL) {
                _data.deviceObjectPathListType_ = new ::std::vector< DeviceObjectPathInfo >(*rhs._data.deviceObjectPathListType_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void HfpManagerVariant::deleteData () {
    switch (__field) {
    case E_SYSTEM_WIDE_RINGTONES_LIST_TYPE:
        delete _data.systemWideRingtonesListType_;
        _data.systemWideRingtonesListType_ = NULL;
        break;
    case E_DEVICE_RINGTONE_LIST_TYPE:
        delete _data.deviceRingtoneListType_;
        _data.deviceRingtoneListType_ = NULL;
        break;
    case E_SUPPRESS_RINGTONE_LIST_TYPE:
        delete _data.suppressRingtoneListType_;
        _data.suppressRingtoneListType_ = NULL;
        break;
    case E_AUTO_WAITING_MODE_LIST_TYPE:
        delete _data.autoWaitingModeListType_;
        _data.autoWaitingModeListType_ = NULL;
        break;
    case E_WAITING_MODE_FILE_PATH_TYPE:
        delete _data.waitingModeFilePathType_;
        _data.waitingModeFilePathType_ = NULL;
        break;
    case E_ACTIVE_PASSIVE_DEVICE_LIST_TYPE:
        delete _data.activePassiveDeviceListType_;
        _data.activePassiveDeviceListType_ = NULL;
        break;
    case E_DEVICE_OBJECT_PATH_LIST_TYPE:
        delete _data.deviceObjectPathListType_;
        _data.deviceObjectPathListType_ = NULL;
        break;
    default:
        break;
    }
}

inline  DeviceInfoVariant::DeviceInfoVariant () :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
}

inline  DeviceInfoVariant::DeviceInfoVariant (const DeviceInfoVariant& rhs) :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
    *this = rhs;
}

inline  DeviceInfoVariant::~DeviceInfoVariant() {
    deleteData ();
}

inline DeviceInfoVariant& DeviceInfoVariant::operator = (const DeviceInfoVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool DeviceInfoVariant::operator == (const DeviceInfoVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_UINT8:
            return (getUint8() == rhs.getUint8());
        case E_STRING:
            if (_data.string_ == NULL && rhs._data.string_ == NULL) {
                return true;
            }
            return (getString() == rhs.getString());
        case E_SUPPORTED_FEATURES_LIST:
            if (_data.supportedFeaturesList_ == NULL && rhs._data.supportedFeaturesList_ == NULL) {
                return true;
            }
            return (getSupportedFeaturesList() == rhs.getSupportedFeaturesList());
        default:
            return false;
        }
    }
    return false;
}

inline bool DeviceInfoVariant::operator != (const DeviceInfoVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceInfoVariant::operator < (const DeviceInfoVariant& rhs) const  {
    if (hasUint8() && rhs.hasUint8()) {
        if (getUint8() < rhs.getUint8()) return true;
        if (getUint8() > rhs.getUint8()) return false;
    } else {
        if (hasUint8() && !rhs.hasUint8())
            return true;
        else if (!hasUint8() && rhs.hasUint8())
            return false;
    }

    if (hasString() && rhs.hasString()) {
        if (getString() < rhs.getString()) return true;
        if (getString() > rhs.getString()) return false;
    } else {
        if (hasString() && !rhs.hasString())
            return true;
        else if (!hasString() && rhs.hasString())
            return false;
    }

    if (hasSupportedFeaturesList() && rhs.hasSupportedFeaturesList()) {
        if (getSupportedFeaturesList() < rhs.getSupportedFeaturesList()) return true;
        if (getSupportedFeaturesList() > rhs.getSupportedFeaturesList()) return false;
    } else {
        if (hasSupportedFeaturesList() && !rhs.hasSupportedFeaturesList())
            return true;
        else if (!hasSupportedFeaturesList() && rhs.hasSupportedFeaturesList())
            return false;
    }

    return false;
}

inline bool DeviceInfoVariant::operator > (const DeviceInfoVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline DeviceInfoVariant::DeviceInfoVariantField DeviceInfoVariant::getField () const {
    return __field;
}

inline void DeviceInfoVariant::setField(DeviceInfoVariant::DeviceInfoVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_UINT8:
        _data.uint8__ = 0u;
        break;
    case E_STRING:
        _data.string_ = NULL;
        break;
    case E_SUPPORTED_FEATURES_LIST:
        _data.supportedFeaturesList_ = NULL;
        break;
    default:
        break;
    }
}

inline bool DeviceInfoVariant::hasUint8 () const {
    return __field == E_UINT8;
}

inline uint8 DeviceInfoVariant::getUint8() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint8(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint8", "DeviceInfoVariant", getField());
    }
    return _data.uint8__;
}

inline void DeviceInfoVariant::setUint8 (uint8 value) {
    if (__field != E_UINT8) {
        deleteData ();
        __field = E_UINT8;
    }
    _data.uint8__ = (uint8)value;
}

inline bool DeviceInfoVariant::hasString () const {
    return __field == E_STRING;
}

inline const ::std::string& DeviceInfoVariant::getString() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "DeviceInfoVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            return ::asf::core::theEmptyString;
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string& DeviceInfoVariant::getStringMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "DeviceInfoVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string* DeviceInfoVariant::releaseString() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasString(), "Can't release value for field 'DeviceInfoVariant', have field %d", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        ::std::string* temp = _data.string_;
        _data.string_ = NULL;
        return temp;
    }
    return 0;
}

inline void DeviceInfoVariant::replaceString (::std::string* string) {
    if (__field != E_STRING || _data.string_ != string) {
        deleteData ();
        __field = E_STRING;
        _data.string_ = string;
    }
}

inline void DeviceInfoVariant::setString (const ::std::string& string) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (string);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(string);
        CHECK_ALLOCATION( _data.string_ );
    }
}

inline void DeviceInfoVariant::setString (const char* value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (value);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(value);
    }
}

inline void DeviceInfoVariant::setString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (reinterpret_cast<const char*>(value), size);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(reinterpret_cast<const char*>(value), size);
    }
}

inline bool DeviceInfoVariant::hasSupportedFeaturesList () const {
    return __field == E_SUPPORTED_FEATURES_LIST;
}

inline const ::std::vector< ::std::string >& DeviceInfoVariant::getSupportedFeaturesList() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSupportedFeaturesList(), "Can't provide value for union field '%s' of union '%s', have field %d", "supportedFeaturesList", "DeviceInfoVariant", getField());
    }
    if (hasSupportedFeaturesList()) {
        if (_data.supportedFeaturesList_ == NULL) {
            return getStringList_DefaultInstance();
        }
        return *_data.supportedFeaturesList_;
    }
    abort();
}

inline ::std::vector< ::std::string >& DeviceInfoVariant::getSupportedFeaturesListMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSupportedFeaturesList(), "Can't provide value for union field '%s' of union '%s', have field %d", "supportedFeaturesList", "DeviceInfoVariant", getField());
    }
    if (hasSupportedFeaturesList()) {
        if (_data.supportedFeaturesList_ == NULL) {
            _data.supportedFeaturesList_ = new ::std::vector< ::std::string >();
            CHECK_ALLOCATION( _data.supportedFeaturesList_ );
        }
        return *_data.supportedFeaturesList_;
    }
    abort();
}

inline ::std::vector< ::std::string >* DeviceInfoVariant::releaseSupportedFeaturesList() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasSupportedFeaturesList(), "Can't release value for field 'DeviceInfoVariant', have field %d", getField());
    }
    if (hasSupportedFeaturesList()) {
        if (_data.supportedFeaturesList_ == NULL) {
            _data.supportedFeaturesList_ = new ::std::vector< ::std::string >();
            CHECK_ALLOCATION( _data.supportedFeaturesList_ );
        }
        ::std::vector< ::std::string >* temp = _data.supportedFeaturesList_;
        _data.supportedFeaturesList_ = NULL;
        return temp;
    }
    return 0;
}

inline void DeviceInfoVariant::replaceSupportedFeaturesList (::std::vector< ::std::string >* supportedFeaturesList) {
    if (__field != E_SUPPORTED_FEATURES_LIST || _data.supportedFeaturesList_ != supportedFeaturesList) {
        deleteData ();
        __field = E_SUPPORTED_FEATURES_LIST;
        _data.supportedFeaturesList_ = supportedFeaturesList;
    }
}

inline void DeviceInfoVariant::setSupportedFeaturesList (const ::std::vector< ::std::string >& value) {
    if (__field == E_SUPPORTED_FEATURES_LIST && _data.supportedFeaturesList_ != NULL) {
        *_data.supportedFeaturesList_ = value;
    } else {
        deleteData ();
        __field = E_SUPPORTED_FEATURES_LIST;
        _data.supportedFeaturesList_ = new ::std::vector< ::std::string >(value);
    }
}

inline void DeviceInfoVariant::cloneData (const DeviceInfoVariant& rhs) {
    switch (rhs.__field) {
    case E_UINT8:
        _data.uint8__ = rhs._data.uint8__;
        break;
    case E_STRING:
        if (__field == E_STRING) {
            if (rhs._data.string_ == NULL)
                deleteData ();
            else {
                if (_data.string_ != NULL) {
                    *_data.string_ =  *rhs._data.string_;
                } else {
                    _data.string_ = new ::std::string(*rhs._data.string_);
                }
            }
        } else {
            if (_data.string_ != 0) deleteData ();
            if (rhs._data.string_ != NULL) {
                _data.string_ = new ::std::string(*rhs._data.string_);
            }
        }
        break;
    case E_SUPPORTED_FEATURES_LIST:
        if (__field == E_SUPPORTED_FEATURES_LIST) {
            if (rhs._data.supportedFeaturesList_ == NULL)
                deleteData ();
            else {
                if (_data.supportedFeaturesList_ != NULL) {
                    *_data.supportedFeaturesList_ =  *rhs._data.supportedFeaturesList_;
                } else {
                    _data.supportedFeaturesList_ = new ::std::vector< ::std::string >(*rhs._data.supportedFeaturesList_);
                }
            }
        } else {
            if (_data.supportedFeaturesList_ != 0) deleteData ();
            if (rhs._data.supportedFeaturesList_ != NULL) {
                _data.supportedFeaturesList_ = new ::std::vector< ::std::string >(*rhs._data.supportedFeaturesList_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void DeviceInfoVariant::deleteData () {
    switch (__field) {
    case E_STRING:
        delete _data.string_;
        _data.string_ = NULL;
        break;
    case E_SUPPORTED_FEATURES_LIST:
        delete _data.supportedFeaturesList_;
        _data.supportedFeaturesList_ = NULL;
        break;
    default:
        break;
    }
}

inline  BaseTypesVariant::BaseTypesVariant () :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
}

inline  BaseTypesVariant::BaseTypesVariant (const BaseTypesVariant& rhs) :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
    *this = rhs;
}

inline  BaseTypesVariant::~BaseTypesVariant() {
    deleteData ();
}

inline BaseTypesVariant& BaseTypesVariant::operator = (const BaseTypesVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool BaseTypesVariant::operator == (const BaseTypesVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_UINT8:
            return (getUint8() == rhs.getUint8());
        case E_UINT64:
            return (getUint64() == rhs.getUint64());
        case E_BOOLEAN:
            return (getBoolean() == rhs.getBoolean());
        case E_STRING:
            if (_data.string_ == NULL && rhs._data.string_ == NULL) {
                return true;
            }
            return (getString() == rhs.getString());
        default:
            return false;
        }
    }
    return false;
}

inline bool BaseTypesVariant::operator != (const BaseTypesVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool BaseTypesVariant::operator < (const BaseTypesVariant& rhs) const  {
    if (hasUint8() && rhs.hasUint8()) {
        if (getUint8() < rhs.getUint8()) return true;
        if (getUint8() > rhs.getUint8()) return false;
    } else {
        if (hasUint8() && !rhs.hasUint8())
            return true;
        else if (!hasUint8() && rhs.hasUint8())
            return false;
    }

    if (hasUint64() && rhs.hasUint64()) {
        if (getUint64() < rhs.getUint64()) return true;
        if (getUint64() > rhs.getUint64()) return false;
    } else {
        if (hasUint64() && !rhs.hasUint64())
            return true;
        else if (!hasUint64() && rhs.hasUint64())
            return false;
    }

    if (hasBoolean() && rhs.hasBoolean()) {
        if (getBoolean() < rhs.getBoolean()) return true;
        if (getBoolean() > rhs.getBoolean()) return false;
    } else {
        if (hasBoolean() && !rhs.hasBoolean())
            return true;
        else if (!hasBoolean() && rhs.hasBoolean())
            return false;
    }

    if (hasString() && rhs.hasString()) {
        if (getString() < rhs.getString()) return true;
        if (getString() > rhs.getString()) return false;
    } else {
        if (hasString() && !rhs.hasString())
            return true;
        else if (!hasString() && rhs.hasString())
            return false;
    }

    return false;
}

inline bool BaseTypesVariant::operator > (const BaseTypesVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline BaseTypesVariant::BaseTypesVariantField BaseTypesVariant::getField () const {
    return __field;
}

inline void BaseTypesVariant::setField(BaseTypesVariant::BaseTypesVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_UINT8:
        _data.uint8__ = 0u;
        break;
    case E_UINT64:
        _data.uint64__ = 0u;
        break;
    case E_BOOLEAN:
        _data.boolean_ = false;
        break;
    case E_STRING:
        _data.string_ = NULL;
        break;
    default:
        break;
    }
}

inline bool BaseTypesVariant::hasUint8 () const {
    return __field == E_UINT8;
}

inline uint8 BaseTypesVariant::getUint8() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint8(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint8", "BaseTypesVariant", getField());
    }
    return _data.uint8__;
}

inline void BaseTypesVariant::setUint8 (uint8 value) {
    if (__field != E_UINT8) {
        deleteData ();
        __field = E_UINT8;
    }
    _data.uint8__ = (uint8)value;
}

inline bool BaseTypesVariant::hasUint64 () const {
    return __field == E_UINT64;
}

inline uint64 BaseTypesVariant::getUint64() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint64(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint64", "BaseTypesVariant", getField());
    }
    return _data.uint64__;
}

inline void BaseTypesVariant::setUint64 (uint64 value) {
    if (__field != E_UINT64) {
        deleteData ();
        __field = E_UINT64;
    }
    _data.uint64__ = (uint64)value;
}

inline bool BaseTypesVariant::hasBoolean () const {
    return __field == E_BOOLEAN;
}

inline bool BaseTypesVariant::getBoolean() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasBoolean(), "Can't provide value for union field '%s' of union '%s', have field %d", "boolean", "BaseTypesVariant", getField());
    }
    return _data.boolean_;
}

inline void BaseTypesVariant::setBoolean (bool value) {
    if (__field != E_BOOLEAN) {
        deleteData ();
        __field = E_BOOLEAN;
    }
    _data.boolean_ = (bool)value;
}

inline bool BaseTypesVariant::hasString () const {
    return __field == E_STRING;
}

inline const ::std::string& BaseTypesVariant::getString() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "BaseTypesVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            return ::asf::core::theEmptyString;
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string& BaseTypesVariant::getStringMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "BaseTypesVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string* BaseTypesVariant::releaseString() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasString(), "Can't release value for field 'BaseTypesVariant', have field %d", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        ::std::string* temp = _data.string_;
        _data.string_ = NULL;
        return temp;
    }
    return 0;
}

inline void BaseTypesVariant::replaceString (::std::string* string) {
    if (__field != E_STRING || _data.string_ != string) {
        deleteData ();
        __field = E_STRING;
        _data.string_ = string;
    }
}

inline void BaseTypesVariant::setString (const ::std::string& string) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (string);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(string);
        CHECK_ALLOCATION( _data.string_ );
    }
}

inline void BaseTypesVariant::setString (const char* value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (value);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(value);
    }
}

inline void BaseTypesVariant::setString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (reinterpret_cast<const char*>(value), size);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(reinterpret_cast<const char*>(value), size);
    }
}

inline void BaseTypesVariant::cloneData (const BaseTypesVariant& rhs) {
    switch (rhs.__field) {
    case E_UINT8:
        _data.uint8__ = rhs._data.uint8__;
        break;
    case E_UINT64:
        _data.uint64__ = rhs._data.uint64__;
        break;
    case E_BOOLEAN:
        _data.boolean_ = rhs._data.boolean_;
        break;
    case E_STRING:
        if (__field == E_STRING) {
            if (rhs._data.string_ == NULL)
                deleteData ();
            else {
                if (_data.string_ != NULL) {
                    *_data.string_ =  *rhs._data.string_;
                } else {
                    _data.string_ = new ::std::string(*rhs._data.string_);
                }
            }
        } else {
            if (_data.string_ != 0) deleteData ();
            if (rhs._data.string_ != NULL) {
                _data.string_ = new ::std::string(*rhs._data.string_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void BaseTypesVariant::deleteData () {
    switch (__field) {
    case E_STRING:
        delete _data.string_;
        _data.string_ = NULL;
        break;
    default:
        break;
    }
}

inline  DeviceCallsList::DeviceCallsList ()  :
    _DeviceAddress (),
    _callsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceCallsList::DeviceCallsList (const DeviceCallsList &rhs)  :
    _DeviceAddress (),
    _callsList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceCallsList::DeviceCallsList (const ::std::string& DeviceAddress_, const ::std::vector< uint8 >& callsList_)  :
    _DeviceAddress (DeviceAddress_),
    _callsList (callsList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceCallsList::~DeviceCallsList() {
}

inline DeviceCallsList& DeviceCallsList::operator = (const DeviceCallsList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
        if (rhs.hasCallsList()) {
            setCallsList(rhs.getCallsList());
        } else {
            clearCallsList();
        }
    }
    return *this;
}

inline bool DeviceCallsList::operator == (const DeviceCallsList& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()) &&
        ((!hasCallsList() && !rhs.hasCallsList()) || getCallsList() == rhs.getCallsList()));
}

inline bool DeviceCallsList::operator != (const DeviceCallsList& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceCallsList::operator < (const DeviceCallsList& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    if (hasCallsList() || rhs.hasCallsList()) {
        if (getCallsList() < rhs.getCallsList()) return true;
        if (getCallsList() > rhs.getCallsList()) return false;
    }
    return false;
}

inline bool DeviceCallsList::operator > (const DeviceCallsList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceCallsList::clear() {
    clearDeviceAddress();
    clearCallsList();
}

inline void DeviceCallsList::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool DeviceCallsList::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceCallsList::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& DeviceCallsList::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void DeviceCallsList::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void DeviceCallsList::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void DeviceCallsList::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void DeviceCallsList::clearCallsList() {
    if (hasCallsList()) {
         clear_has_callsList();
        _callsList.clear();
     }
}

inline bool DeviceCallsList::hasCallsList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& DeviceCallsList::getCallsList () const {
    return _callsList;
}

inline ::std::vector< uint8 >& DeviceCallsList::getCallsListMutable () {
    set_has_callsList();
    return _callsList;
}

inline void DeviceCallsList::setCallsList (const ::std::vector< uint8 >& callsList_) {
    set_has_callsList();
    this->_callsList = callsList_;
}

inline void DeviceCallsList::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceCallsList::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DeviceCallsList::set_has_callsList () {
    _has_bits_[0] |= 1u << 1;
}

inline void DeviceCallsList::clear_has_callsList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CallStatusVariant::CallStatusVariant () :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
}

inline  CallStatusVariant::CallStatusVariant (const CallStatusVariant& rhs) :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
    *this = rhs;
}

inline  CallStatusVariant::~CallStatusVariant() {
    deleteData ();
}

inline CallStatusVariant& CallStatusVariant::operator = (const CallStatusVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool CallStatusVariant::operator == (const CallStatusVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_UINT8:
            return (getUint8() == rhs.getUint8());
        case E_UINT64:
            return (getUint64() == rhs.getUint64());
        case E_BOOLEAN:
            return (getBoolean() == rhs.getBoolean());
        case E_STRING:
            if (_data.string_ == NULL && rhs._data.string_ == NULL) {
                return true;
            }
            return (getString() == rhs.getString());
        case E_CALL_INFO_LIST:
            if (_data.callInfoList_ == NULL && rhs._data.callInfoList_ == NULL) {
                return true;
            }
            return (getCallInfoList() == rhs.getCallInfoList());
        default:
            return false;
        }
    }
    return false;
}

inline bool CallStatusVariant::operator != (const CallStatusVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool CallStatusVariant::operator < (const CallStatusVariant& rhs) const  {
    if (hasUint8() && rhs.hasUint8()) {
        if (getUint8() < rhs.getUint8()) return true;
        if (getUint8() > rhs.getUint8()) return false;
    } else {
        if (hasUint8() && !rhs.hasUint8())
            return true;
        else if (!hasUint8() && rhs.hasUint8())
            return false;
    }

    if (hasUint64() && rhs.hasUint64()) {
        if (getUint64() < rhs.getUint64()) return true;
        if (getUint64() > rhs.getUint64()) return false;
    } else {
        if (hasUint64() && !rhs.hasUint64())
            return true;
        else if (!hasUint64() && rhs.hasUint64())
            return false;
    }

    if (hasBoolean() && rhs.hasBoolean()) {
        if (getBoolean() < rhs.getBoolean()) return true;
        if (getBoolean() > rhs.getBoolean()) return false;
    } else {
        if (hasBoolean() && !rhs.hasBoolean())
            return true;
        else if (!hasBoolean() && rhs.hasBoolean())
            return false;
    }

    if (hasString() && rhs.hasString()) {
        if (getString() < rhs.getString()) return true;
        if (getString() > rhs.getString()) return false;
    } else {
        if (hasString() && !rhs.hasString())
            return true;
        else if (!hasString() && rhs.hasString())
            return false;
    }

    if (hasCallInfoList() && rhs.hasCallInfoList()) {
        if (getCallInfoList() < rhs.getCallInfoList()) return true;
        if (getCallInfoList() > rhs.getCallInfoList()) return false;
    } else {
        if (hasCallInfoList() && !rhs.hasCallInfoList())
            return true;
        else if (!hasCallInfoList() && rhs.hasCallInfoList())
            return false;
    }

    return false;
}

inline bool CallStatusVariant::operator > (const CallStatusVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline CallStatusVariant::CallStatusVariantField CallStatusVariant::getField () const {
    return __field;
}

inline void CallStatusVariant::setField(CallStatusVariant::CallStatusVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_UINT8:
        _data.uint8__ = 0u;
        break;
    case E_UINT64:
        _data.uint64__ = 0u;
        break;
    case E_BOOLEAN:
        _data.boolean_ = false;
        break;
    case E_STRING:
        _data.string_ = NULL;
        break;
    case E_CALL_INFO_LIST:
        _data.callInfoList_ = NULL;
        break;
    default:
        break;
    }
}

inline bool CallStatusVariant::hasUint8 () const {
    return __field == E_UINT8;
}

inline uint8 CallStatusVariant::getUint8() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint8(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint8", "CallStatusVariant", getField());
    }
    return _data.uint8__;
}

inline void CallStatusVariant::setUint8 (uint8 value) {
    if (__field != E_UINT8) {
        deleteData ();
        __field = E_UINT8;
    }
    _data.uint8__ = (uint8)value;
}

inline bool CallStatusVariant::hasUint64 () const {
    return __field == E_UINT64;
}

inline uint64 CallStatusVariant::getUint64() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint64(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint64", "CallStatusVariant", getField());
    }
    return _data.uint64__;
}

inline void CallStatusVariant::setUint64 (uint64 value) {
    if (__field != E_UINT64) {
        deleteData ();
        __field = E_UINT64;
    }
    _data.uint64__ = (uint64)value;
}

inline bool CallStatusVariant::hasBoolean () const {
    return __field == E_BOOLEAN;
}

inline bool CallStatusVariant::getBoolean() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasBoolean(), "Can't provide value for union field '%s' of union '%s', have field %d", "boolean", "CallStatusVariant", getField());
    }
    return _data.boolean_;
}

inline void CallStatusVariant::setBoolean (bool value) {
    if (__field != E_BOOLEAN) {
        deleteData ();
        __field = E_BOOLEAN;
    }
    _data.boolean_ = (bool)value;
}

inline bool CallStatusVariant::hasString () const {
    return __field == E_STRING;
}

inline const ::std::string& CallStatusVariant::getString() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "CallStatusVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            return ::asf::core::theEmptyString;
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string& CallStatusVariant::getStringMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasString(), "Can't provide value for union field '%s' of union '%s', have field %d", "string", "CallStatusVariant", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        return *_data.string_;
    }
    abort();
}

inline ::std::string* CallStatusVariant::releaseString() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasString(), "Can't release value for field 'CallStatusVariant', have field %d", getField());
    }
    if (hasString()) {
        if (_data.string_ == NULL) {
            _data.string_ = new ::std::string();
            CHECK_ALLOCATION( _data.string_ );
        }
        ::std::string* temp = _data.string_;
        _data.string_ = NULL;
        return temp;
    }
    return 0;
}

inline void CallStatusVariant::replaceString (::std::string* string) {
    if (__field != E_STRING || _data.string_ != string) {
        deleteData ();
        __field = E_STRING;
        _data.string_ = string;
    }
}

inline void CallStatusVariant::setString (const ::std::string& string) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (string), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (string);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(string);
        CHECK_ALLOCATION( _data.string_ );
    }
}

inline void CallStatusVariant::setString (const char* value) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (value);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(value);
    }
}

inline void CallStatusVariant::setString (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    if (__field == E_STRING && _data.string_ != NULL) {
        _data.string_->assign (reinterpret_cast<const char*>(value), size);
    } else {
        deleteData ();
        __field = E_STRING;
        _data.string_ = new ::std::string(reinterpret_cast<const char*>(value), size);
    }
}

inline bool CallStatusVariant::hasCallInfoList () const {
    return __field == E_CALL_INFO_LIST;
}

inline const ::std::vector< CallInfo >& CallStatusVariant::getCallInfoList() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCallInfoList(), "Can't provide value for union field '%s' of union '%s', have field %d", "callInfoList", "CallStatusVariant", getField());
    }
    if (hasCallInfoList()) {
        if (_data.callInfoList_ == NULL) {
            return getCallInfoList_DefaultInstance();
        }
        return *_data.callInfoList_;
    }
    abort();
}

inline ::std::vector< CallInfo >& CallStatusVariant::getCallInfoListMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCallInfoList(), "Can't provide value for union field '%s' of union '%s', have field %d", "callInfoList", "CallStatusVariant", getField());
    }
    if (hasCallInfoList()) {
        if (_data.callInfoList_ == NULL) {
            _data.callInfoList_ = new ::std::vector< CallInfo >();
            CHECK_ALLOCATION( _data.callInfoList_ );
        }
        return *_data.callInfoList_;
    }
    abort();
}

inline ::std::vector< CallInfo >* CallStatusVariant::releaseCallInfoList() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCallInfoList(), "Can't release value for field 'CallStatusVariant', have field %d", getField());
    }
    if (hasCallInfoList()) {
        if (_data.callInfoList_ == NULL) {
            _data.callInfoList_ = new ::std::vector< CallInfo >();
            CHECK_ALLOCATION( _data.callInfoList_ );
        }
        ::std::vector< CallInfo >* temp = _data.callInfoList_;
        _data.callInfoList_ = NULL;
        return temp;
    }
    return 0;
}

inline void CallStatusVariant::replaceCallInfoList (::std::vector< CallInfo >* callInfoList) {
    if (__field != E_CALL_INFO_LIST || _data.callInfoList_ != callInfoList) {
        deleteData ();
        __field = E_CALL_INFO_LIST;
        _data.callInfoList_ = callInfoList;
    }
}

inline void CallStatusVariant::setCallInfoList (const ::std::vector< CallInfo >& value) {
    if (__field == E_CALL_INFO_LIST && _data.callInfoList_ != NULL) {
        *_data.callInfoList_ = value;
    } else {
        deleteData ();
        __field = E_CALL_INFO_LIST;
        _data.callInfoList_ = new ::std::vector< CallInfo >(value);
    }
}

inline void CallStatusVariant::cloneData (const CallStatusVariant& rhs) {
    switch (rhs.__field) {
    case E_UINT8:
        _data.uint8__ = rhs._data.uint8__;
        break;
    case E_UINT64:
        _data.uint64__ = rhs._data.uint64__;
        break;
    case E_BOOLEAN:
        _data.boolean_ = rhs._data.boolean_;
        break;
    case E_STRING:
        if (__field == E_STRING) {
            if (rhs._data.string_ == NULL)
                deleteData ();
            else {
                if (_data.string_ != NULL) {
                    *_data.string_ =  *rhs._data.string_;
                } else {
                    _data.string_ = new ::std::string(*rhs._data.string_);
                }
            }
        } else {
            if (_data.string_ != 0) deleteData ();
            if (rhs._data.string_ != NULL) {
                _data.string_ = new ::std::string(*rhs._data.string_);
            }
        }
        break;
    case E_CALL_INFO_LIST:
        if (__field == E_CALL_INFO_LIST) {
            if (rhs._data.callInfoList_ == NULL)
                deleteData ();
            else {
                if (_data.callInfoList_ != NULL) {
                    *_data.callInfoList_ =  *rhs._data.callInfoList_;
                } else {
                    _data.callInfoList_ = new ::std::vector< CallInfo >(*rhs._data.callInfoList_);
                }
            }
        } else {
            if (_data.callInfoList_ != 0) deleteData ();
            if (rhs._data.callInfoList_ != NULL) {
                _data.callInfoList_ = new ::std::vector< CallInfo >(*rhs._data.callInfoList_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void CallStatusVariant::deleteData () {
    switch (__field) {
    case E_STRING:
        delete _data.string_;
        _data.string_ = NULL;
        break;
    case E_CALL_INFO_LIST:
        delete _data.callInfoList_;
        _data.callInfoList_ = NULL;
        break;
    default:
        break;
    }
}

inline  VoiceCallManagerVariant::VoiceCallManagerVariant () :
    __field (E_BOOLEAN),
    _data()
{
    _data.boolean_ = false;
}

inline  VoiceCallManagerVariant::VoiceCallManagerVariant (const VoiceCallManagerVariant& rhs) :
    __field (E_BOOLEAN),
    _data()
{
    _data.boolean_ = false;
    *this = rhs;
}

inline  VoiceCallManagerVariant::~VoiceCallManagerVariant() {
    deleteData ();
}

inline VoiceCallManagerVariant& VoiceCallManagerVariant::operator = (const VoiceCallManagerVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool VoiceCallManagerVariant::operator == (const VoiceCallManagerVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_BOOLEAN:
            return (getBoolean() == rhs.getBoolean());
        case E_CALL_STATUS_LIST_TYPE:
            if (_data.callStatusListType_ == NULL && rhs._data.callStatusListType_ == NULL) {
                return true;
            }
            return (getCallStatusListType() == rhs.getCallStatusListType());
        default:
            return false;
        }
    }
    return false;
}

inline bool VoiceCallManagerVariant::operator != (const VoiceCallManagerVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceCallManagerVariant::operator < (const VoiceCallManagerVariant& rhs) const  {
    if (hasBoolean() && rhs.hasBoolean()) {
        if (getBoolean() < rhs.getBoolean()) return true;
        if (getBoolean() > rhs.getBoolean()) return false;
    } else {
        if (hasBoolean() && !rhs.hasBoolean())
            return true;
        else if (!hasBoolean() && rhs.hasBoolean())
            return false;
    }

    if (hasCallStatusListType() && rhs.hasCallStatusListType()) {
        if (getCallStatusListType() < rhs.getCallStatusListType()) return true;
        if (getCallStatusListType() > rhs.getCallStatusListType()) return false;
    } else {
        if (hasCallStatusListType() && !rhs.hasCallStatusListType())
            return true;
        else if (!hasCallStatusListType() && rhs.hasCallStatusListType())
            return false;
    }

    return false;
}

inline bool VoiceCallManagerVariant::operator > (const VoiceCallManagerVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline VoiceCallManagerVariant::VoiceCallManagerVariantField VoiceCallManagerVariant::getField () const {
    return __field;
}

inline void VoiceCallManagerVariant::setField(VoiceCallManagerVariant::VoiceCallManagerVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_BOOLEAN:
        _data.boolean_ = false;
        break;
    case E_CALL_STATUS_LIST_TYPE:
        _data.callStatusListType_ = NULL;
        break;
    default:
        break;
    }
}

inline bool VoiceCallManagerVariant::hasBoolean () const {
    return __field == E_BOOLEAN;
}

inline bool VoiceCallManagerVariant::getBoolean() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasBoolean(), "Can't provide value for union field '%s' of union '%s', have field %d", "boolean", "VoiceCallManagerVariant", getField());
    }
    return _data.boolean_;
}

inline void VoiceCallManagerVariant::setBoolean (bool value) {
    if (__field != E_BOOLEAN) {
        deleteData ();
        __field = E_BOOLEAN;
    }
    _data.boolean_ = (bool)value;
}

inline bool VoiceCallManagerVariant::hasCallStatusListType () const {
    return __field == E_CALL_STATUS_LIST_TYPE;
}

inline const ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& VoiceCallManagerVariant::getCallStatusListType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCallStatusListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "callStatusListType", "VoiceCallManagerVariant", getField());
    }
    if (hasCallStatusListType()) {
        if (_data.callStatusListType_ == NULL) {
            return getStringToCallStatusVariantMap_List_DefaultInstance();
        }
        return *_data.callStatusListType_;
    }
    abort();
}

inline ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& VoiceCallManagerVariant::getCallStatusListTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCallStatusListType(), "Can't provide value for union field '%s' of union '%s', have field %d", "callStatusListType", "VoiceCallManagerVariant", getField());
    }
    if (hasCallStatusListType()) {
        if (_data.callStatusListType_ == NULL) {
            _data.callStatusListType_ = new ::std::vector< ::std::map< ::std::string, CallStatusVariant > >();
            CHECK_ALLOCATION( _data.callStatusListType_ );
        }
        return *_data.callStatusListType_;
    }
    abort();
}

inline ::std::vector< ::std::map< ::std::string, CallStatusVariant > >* VoiceCallManagerVariant::releaseCallStatusListType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCallStatusListType(), "Can't release value for field 'VoiceCallManagerVariant', have field %d", getField());
    }
    if (hasCallStatusListType()) {
        if (_data.callStatusListType_ == NULL) {
            _data.callStatusListType_ = new ::std::vector< ::std::map< ::std::string, CallStatusVariant > >();
            CHECK_ALLOCATION( _data.callStatusListType_ );
        }
        ::std::vector< ::std::map< ::std::string, CallStatusVariant > >* temp = _data.callStatusListType_;
        _data.callStatusListType_ = NULL;
        return temp;
    }
    return 0;
}

inline void VoiceCallManagerVariant::replaceCallStatusListType (::std::vector< ::std::map< ::std::string, CallStatusVariant > >* callStatusListType) {
    if (__field != E_CALL_STATUS_LIST_TYPE || _data.callStatusListType_ != callStatusListType) {
        deleteData ();
        __field = E_CALL_STATUS_LIST_TYPE;
        _data.callStatusListType_ = callStatusListType;
    }
}

inline void VoiceCallManagerVariant::setCallStatusListType (const ::std::vector< ::std::map< ::std::string, CallStatusVariant > >& value) {
    if (__field == E_CALL_STATUS_LIST_TYPE && _data.callStatusListType_ != NULL) {
        *_data.callStatusListType_ = value;
    } else {
        deleteData ();
        __field = E_CALL_STATUS_LIST_TYPE;
        _data.callStatusListType_ = new ::std::vector< ::std::map< ::std::string, CallStatusVariant > >(value);
    }
}

inline void VoiceCallManagerVariant::cloneData (const VoiceCallManagerVariant& rhs) {
    switch (rhs.__field) {
    case E_BOOLEAN:
        _data.boolean_ = rhs._data.boolean_;
        break;
    case E_CALL_STATUS_LIST_TYPE:
        if (__field == E_CALL_STATUS_LIST_TYPE) {
            if (rhs._data.callStatusListType_ == NULL)
                deleteData ();
            else {
                if (_data.callStatusListType_ != NULL) {
                    *_data.callStatusListType_ =  *rhs._data.callStatusListType_;
                } else {
                    _data.callStatusListType_ = new ::std::vector< ::std::map< ::std::string, CallStatusVariant > >(*rhs._data.callStatusListType_);
                }
            }
        } else {
            if (_data.callStatusListType_ != 0) deleteData ();
            if (rhs._data.callStatusListType_ != NULL) {
                _data.callStatusListType_ = new ::std::vector< ::std::map< ::std::string, CallStatusVariant > >(*rhs._data.callStatusListType_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void VoiceCallManagerVariant::deleteData () {
    switch (__field) {
    case E_CALL_STATUS_LIST_TYPE:
        delete _data.callStatusListType_;
        _data.callStatusListType_ = NULL;
        break;
    default:
        break;
    }
}

inline  VoiceCallVariant::VoiceCallVariant () :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
}

inline  VoiceCallVariant::VoiceCallVariant (const VoiceCallVariant& rhs) :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
    *this = rhs;
}

inline  VoiceCallVariant::~VoiceCallVariant() {
    deleteData ();
}

inline VoiceCallVariant& VoiceCallVariant::operator = (const VoiceCallVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool VoiceCallVariant::operator == (const VoiceCallVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_UINT8:
            return (getUint8() == rhs.getUint8());
        case E_BOOLEAN:
            return (getBoolean() == rhs.getBoolean());
        default:
            return false;
        }
    }
    return false;
}

inline bool VoiceCallVariant::operator != (const VoiceCallVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceCallVariant::operator < (const VoiceCallVariant& rhs) const  {
    if (hasUint8() && rhs.hasUint8()) {
        if (getUint8() < rhs.getUint8()) return true;
        if (getUint8() > rhs.getUint8()) return false;
    } else {
        if (hasUint8() && !rhs.hasUint8())
            return true;
        else if (!hasUint8() && rhs.hasUint8())
            return false;
    }

    if (hasBoolean() && rhs.hasBoolean()) {
        if (getBoolean() < rhs.getBoolean()) return true;
        if (getBoolean() > rhs.getBoolean()) return false;
    } else {
        if (hasBoolean() && !rhs.hasBoolean())
            return true;
        else if (!hasBoolean() && rhs.hasBoolean())
            return false;
    }

    return false;
}

inline bool VoiceCallVariant::operator > (const VoiceCallVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline VoiceCallVariant::VoiceCallVariantField VoiceCallVariant::getField () const {
    return __field;
}

inline void VoiceCallVariant::setField(VoiceCallVariant::VoiceCallVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_UINT8:
        _data.uint8__ = 0u;
        break;
    case E_BOOLEAN:
        _data.boolean_ = false;
        break;
    default:
        break;
    }
}

inline bool VoiceCallVariant::hasUint8 () const {
    return __field == E_UINT8;
}

inline uint8 VoiceCallVariant::getUint8() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint8(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint8", "VoiceCallVariant", getField());
    }
    return _data.uint8__;
}

inline void VoiceCallVariant::setUint8 (uint8 value) {
    if (__field != E_UINT8) {
        deleteData ();
        __field = E_UINT8;
    }
    _data.uint8__ = (uint8)value;
}

inline bool VoiceCallVariant::hasBoolean () const {
    return __field == E_BOOLEAN;
}

inline bool VoiceCallVariant::getBoolean() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasBoolean(), "Can't provide value for union field '%s' of union '%s', have field %d", "boolean", "VoiceCallVariant", getField());
    }
    return _data.boolean_;
}

inline void VoiceCallVariant::setBoolean (bool value) {
    if (__field != E_BOOLEAN) {
        deleteData ();
        __field = E_BOOLEAN;
    }
    _data.boolean_ = (bool)value;
}

inline void VoiceCallVariant::cloneData (const VoiceCallVariant& rhs) {
    switch (rhs.__field) {
    case E_UINT8:
        _data.uint8__ = rhs._data.uint8__;
        break;
    case E_BOOLEAN:
        _data.boolean_ = rhs._data.boolean_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void VoiceCallVariant::deleteData () {
}

inline  VoiceRecognitionVariant::VoiceRecognitionVariant () :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
}

inline  VoiceRecognitionVariant::VoiceRecognitionVariant (const VoiceRecognitionVariant& rhs) :
    __field (E_UINT8),
    _data()
{
    _data.uint8__ = 0u;
    *this = rhs;
}

inline  VoiceRecognitionVariant::~VoiceRecognitionVariant() {
    deleteData ();
}

inline VoiceRecognitionVariant& VoiceRecognitionVariant::operator = (const VoiceRecognitionVariant& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool VoiceRecognitionVariant::operator == (const VoiceRecognitionVariant& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_UINT8:
            return (getUint8() == rhs.getUint8());
        case E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE:
            if (_data.enhancedVoiceRecognitionFeatureType_ == NULL && rhs._data.enhancedVoiceRecognitionFeatureType_ == NULL) {
                return true;
            }
            return (getEnhancedVoiceRecognitionFeatureType() == rhs.getEnhancedVoiceRecognitionFeatureType());
        default:
            return false;
        }
    }
    return false;
}

inline bool VoiceRecognitionVariant::operator != (const VoiceRecognitionVariant& rhs) const {
    return ! (*this == rhs);
}

inline bool VoiceRecognitionVariant::operator < (const VoiceRecognitionVariant& rhs) const  {
    if (hasUint8() && rhs.hasUint8()) {
        if (getUint8() < rhs.getUint8()) return true;
        if (getUint8() > rhs.getUint8()) return false;
    } else {
        if (hasUint8() && !rhs.hasUint8())
            return true;
        else if (!hasUint8() && rhs.hasUint8())
            return false;
    }

    if (hasEnhancedVoiceRecognitionFeatureType() && rhs.hasEnhancedVoiceRecognitionFeatureType()) {
        if (getEnhancedVoiceRecognitionFeatureType() < rhs.getEnhancedVoiceRecognitionFeatureType()) return true;
        if (getEnhancedVoiceRecognitionFeatureType() > rhs.getEnhancedVoiceRecognitionFeatureType()) return false;
    } else {
        if (hasEnhancedVoiceRecognitionFeatureType() && !rhs.hasEnhancedVoiceRecognitionFeatureType())
            return true;
        else if (!hasEnhancedVoiceRecognitionFeatureType() && rhs.hasEnhancedVoiceRecognitionFeatureType())
            return false;
    }

    return false;
}

inline bool VoiceRecognitionVariant::operator > (const VoiceRecognitionVariant& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline VoiceRecognitionVariant::VoiceRecognitionVariantField VoiceRecognitionVariant::getField () const {
    return __field;
}

inline void VoiceRecognitionVariant::setField(VoiceRecognitionVariant::VoiceRecognitionVariantField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_UINT8:
        _data.uint8__ = 0u;
        break;
    case E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE:
        _data.enhancedVoiceRecognitionFeatureType_ = NULL;
        break;
    default:
        break;
    }
}

inline bool VoiceRecognitionVariant::hasUint8 () const {
    return __field == E_UINT8;
}

inline uint8 VoiceRecognitionVariant::getUint8() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasUint8(), "Can't provide value for union field '%s' of union '%s', have field %d", "uint8", "VoiceRecognitionVariant", getField());
    }
    return _data.uint8__;
}

inline void VoiceRecognitionVariant::setUint8 (uint8 value) {
    if (__field != E_UINT8) {
        deleteData ();
        __field = E_UINT8;
    }
    _data.uint8__ = (uint8)value;
}

inline bool VoiceRecognitionVariant::hasEnhancedVoiceRecognitionFeatureType () const {
    return __field == E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE;
}

inline const EnhancedVoiceRecognitionFeatureType& VoiceRecognitionVariant::getEnhancedVoiceRecognitionFeatureType() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasEnhancedVoiceRecognitionFeatureType(), "Can't provide value for union field '%s' of union '%s', have field %d", "enhancedVoiceRecognitionFeatureType", "VoiceRecognitionVariant", getField());
    }
    if (hasEnhancedVoiceRecognitionFeatureType()) {
        if (_data.enhancedVoiceRecognitionFeatureType_ == NULL) {
            return getStringToBaseTypesVariantMap_DefaultInstance();
        }
        return *_data.enhancedVoiceRecognitionFeatureType_;
    }
    abort();
}

inline EnhancedVoiceRecognitionFeatureType& VoiceRecognitionVariant::getEnhancedVoiceRecognitionFeatureTypeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasEnhancedVoiceRecognitionFeatureType(), "Can't provide value for union field '%s' of union '%s', have field %d", "enhancedVoiceRecognitionFeatureType", "VoiceRecognitionVariant", getField());
    }
    if (hasEnhancedVoiceRecognitionFeatureType()) {
        if (_data.enhancedVoiceRecognitionFeatureType_ == NULL) {
            _data.enhancedVoiceRecognitionFeatureType_ = new EnhancedVoiceRecognitionFeatureType();
            CHECK_ALLOCATION( _data.enhancedVoiceRecognitionFeatureType_ );
        }
        return *_data.enhancedVoiceRecognitionFeatureType_;
    }
    abort();
}

inline EnhancedVoiceRecognitionFeatureType* VoiceRecognitionVariant::releaseEnhancedVoiceRecognitionFeatureType() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasEnhancedVoiceRecognitionFeatureType(), "Can't release value for field 'VoiceRecognitionVariant', have field %d", getField());
    }
    if (hasEnhancedVoiceRecognitionFeatureType()) {
        if (_data.enhancedVoiceRecognitionFeatureType_ == NULL) {
            _data.enhancedVoiceRecognitionFeatureType_ = new EnhancedVoiceRecognitionFeatureType();
            CHECK_ALLOCATION( _data.enhancedVoiceRecognitionFeatureType_ );
        }
        EnhancedVoiceRecognitionFeatureType* temp = _data.enhancedVoiceRecognitionFeatureType_;
        _data.enhancedVoiceRecognitionFeatureType_ = NULL;
        return temp;
    }
    return 0;
}

inline void VoiceRecognitionVariant::replaceEnhancedVoiceRecognitionFeatureType (EnhancedVoiceRecognitionFeatureType* enhancedVoiceRecognitionFeatureType) {
    if (__field != E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE || _data.enhancedVoiceRecognitionFeatureType_ != enhancedVoiceRecognitionFeatureType) {
        deleteData ();
        __field = E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE;
        _data.enhancedVoiceRecognitionFeatureType_ = enhancedVoiceRecognitionFeatureType;
    }
}

inline void VoiceRecognitionVariant::setEnhancedVoiceRecognitionFeatureType (const EnhancedVoiceRecognitionFeatureType& value) {
    if (__field == E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE && _data.enhancedVoiceRecognitionFeatureType_ != NULL) {
        *_data.enhancedVoiceRecognitionFeatureType_ = value;
    } else {
        deleteData ();
        __field = E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE;
        _data.enhancedVoiceRecognitionFeatureType_ = new EnhancedVoiceRecognitionFeatureType(value);
    }
}

inline void VoiceRecognitionVariant::cloneData (const VoiceRecognitionVariant& rhs) {
    switch (rhs.__field) {
    case E_UINT8:
        _data.uint8__ = rhs._data.uint8__;
        break;
    case E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE:
        if (__field == E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE) {
            if (rhs._data.enhancedVoiceRecognitionFeatureType_ == NULL)
                deleteData ();
            else {
                if (_data.enhancedVoiceRecognitionFeatureType_ != NULL) {
                    *_data.enhancedVoiceRecognitionFeatureType_ =  *rhs._data.enhancedVoiceRecognitionFeatureType_;
                } else {
                    _data.enhancedVoiceRecognitionFeatureType_ = new EnhancedVoiceRecognitionFeatureType(*rhs._data.enhancedVoiceRecognitionFeatureType_);
                }
            }
        } else {
            if (_data.enhancedVoiceRecognitionFeatureType_ != 0) deleteData ();
            if (rhs._data.enhancedVoiceRecognitionFeatureType_ != NULL) {
                _data.enhancedVoiceRecognitionFeatureType_ = new EnhancedVoiceRecognitionFeatureType(*rhs._data.enhancedVoiceRecognitionFeatureType_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void VoiceRecognitionVariant::deleteData () {
    switch (__field) {
    case E_ENHANCED_VOICE_RECOGNITION_FEATURE_TYPE:
        delete _data.enhancedVoiceRecognitionFeatureType_;
        _data.enhancedVoiceRecognitionFeatureType_ = NULL;
        break;
    default:
        break;
    }
}

} // namespace PMAppTypeCollections
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_PMAPPTYPECOLLECTIONS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
