/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/HfpManager.h"
#include "com/bosch/pmapp/HfpManagerDBus.h"
#include "com/bosch/pmapp/HfpManagerJson.h"
#include "com/bosch/pmapp/HfpManagerStub.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace HfpManager {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/HfpManager", HfpManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "SetRingtone", 2 },
    { 13, "GetProperties", 0 },
    { 14, "SetActivePhone", 5 },
    { 17, "StartStopRingtone", 1 },
    { 20, "AutoWaitingModeOnOff", 4 },
    { 21, "RestoreFactorySetting", 6 },
    { 21, "SuppressRingtoneOnOff", 3 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 18, "DeviceRingtoneList", 1 },
    { 19, "WaitingModeFilePath", 4 },
    { 20, "DeviceObjectPathList", 7 },
    { 20, "PhoneCallAudioActive", 5 },
    { 23, "ActivePassiveDeviceList", 6 },
    { 23, "SystemWideRingtonesList", 0 },
    { 24, "AutoWaitingModeOnOffList", 3 },
    { 25, "SuppressRingtoneOnOffList", 2 },
};

class HfpManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HfpManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HfpManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HfpManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.pmapp.HfpManager"),
          _logger(logger) {}

    virtual ~HfpManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HfpManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 7, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'StartStopRingtone'

            LOG_DEBUG_STUB("process method '%s'", "StartStopRingtone");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopRingtoneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartStopRingtone", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartStopRingtoneRequest > payload = ::boost::static_pointer_cast<StartStopRingtoneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onStartStopRingtoneRequest(payload);
            return;
        }
        case 2: {

            // method 'SetRingtone'

            LOG_DEBUG_STUB("process method '%s'", "SetRingtone");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRingtoneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetRingtone", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetRingtoneRequest > payload = ::boost::static_pointer_cast<SetRingtoneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onSetRingtoneRequest(payload);
            return;
        }
        case 3: {

            // method 'SuppressRingtoneOnOff'

            LOG_DEBUG_STUB("process method '%s'", "SuppressRingtoneOnOff");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SuppressRingtoneOnOffRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SuppressRingtoneOnOff", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SuppressRingtoneOnOffRequest > payload = ::boost::static_pointer_cast<SuppressRingtoneOnOffRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onSuppressRingtoneOnOffRequest(payload);
            return;
        }
        case 4: {

            // method 'AutoWaitingModeOnOff'

            LOG_DEBUG_STUB("process method '%s'", "AutoWaitingModeOnOff");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AutoWaitingModeOnOffRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AutoWaitingModeOnOff", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AutoWaitingModeOnOffRequest > payload = ::boost::static_pointer_cast<AutoWaitingModeOnOffRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onAutoWaitingModeOnOffRequest(payload);
            return;
        }
        case 5: {

            // method 'SetActivePhone'

            LOG_DEBUG_STUB("process method '%s'", "SetActivePhone");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetActivePhoneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetActivePhone", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetActivePhoneRequest > payload = ::boost::static_pointer_cast<SetActivePhoneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onSetActivePhoneRequest(payload);
            return;
        }
        case 6: {

            // method 'RestoreFactorySetting'

            LOG_DEBUG_STUB("process method '%s'", "RestoreFactorySetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestoreFactorySetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestoreFactorySettingRequest > payload = ::boost::static_pointer_cast<RestoreFactorySettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HfpManagerStub*>(getStub())->onRestoreFactorySettingRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HfpManagerStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.pmapp.HfpManager\">\n"
            "    <property access=\"read\" name=\"SystemWideRingtonesList\" type=\"(ya(ys))\"/>\n"
            "    <property access=\"read\" name=\"DeviceRingtoneList\" type=\"a(s(ys))\"/>\n"
            "    <property access=\"read\" name=\"SuppressRingtoneOnOffList\" type=\"a(sb)\"/>\n"
            "    <property access=\"read\" name=\"AutoWaitingModeOnOffList\" type=\"a(sb)\"/>\n"
            "    <property access=\"readwrite\" name=\"WaitingModeFilePath\" type=\"a{ss}\"/>\n"
            "    <property access=\"read\" name=\"PhoneCallAudioActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"ActivePassiveDeviceList\" type=\"a(ys)\"/>\n"
            "    <property access=\"read\" name=\"DeviceObjectPathList\" type=\"a(ss)\"/>\n"
            "    <method name=\"GetProperties\">\n"
            "      <doc>\n"
            "        <line>GetProperties = Get the properties of the HfpManager Interface.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>---</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"HfpManagerProperties\" type=\"a{s(uv)}\">\n"
            "        <doc>\n"
            "          <line>HfpManagerProperties (of type HfpManagerPropertiesList) = Type representation of the parameter - Dict:</line>\n"
            "          <line>{ PropertyName : PropertyValue }</line>\n"
            "          <line></line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;SystemWideRingtonesList&quot; : (0x02, [( 0x02, &quot;RingtoneA&quot; ), (0x03,&quot;RingtoneB&quot;)])}</line>\n"
            "          <line>{&quot;DeviceRingtoneList&quot; : [(&quot;aabbccddeeff&quot;, 0x02, &quot;RingtoneA&quot;), (&quot;ggggiijjkkll&quot;, 0x03, &quot;RingtoneB&quot;)]}</line>\n"
            "          <line>{&quot;SuppressRingtoneOnOffList&quot; : [(&quot;aabbccddeeff&quot;, false)(&quot;ggggiijjkkll&quot;, true)]}</line>\n"
            "          <line>{&quot;AutoWaitingModeOnOffList&quot; : [(&quot;aabbccddeeff&quot;, true)(&quot;ggggiijjkkll&quot;, false)]}</line>\n"
            "          <line>{&quot;WaitingModeFilePath&quot; : {&quot;FilePathNB&quot; : &quot;/path/to/file/waitingmodeNB.mp3&quot;, &quot;FilePathWB&quot; : &quot;/path/to/file/waitingmodeWB.mp3&quot;}}</line>\n"
            "          <line>{&quot;PhoneCallAudioActive&quot; : true}</line>\n"
            "          <line>{&quot;ActivePassiveDeviceList&quot; : [(&quot;aabbccddeeff&quot;, 0x01), (&quot;ggggiijjkkll&quot;, 0x00)]}</line>\n"
            "          <line>{&quot;DeviceObjectPathList&quot; : [(&quot;aabbccddeeff&quot;, &quot;/com/bosch/pmapp/device1&quot;), (&quot;ggggiijjkkll&quot;, &quot;/com/bosch/pmapp/device2&quot;)]}</line>\n"
            "          <line>}</line>\n"
            "          <line>HfpManagerPropertiesList = dictionary(key=STRING,value=HfpManagerVariant)</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartStopRingtone\">\n"
            "      <doc>\n"
            "        <line>StartStopRingtone = Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InProgress</line>\n"
            "        <line>com.bosch.pmapp.Error.InUse</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"StartStop\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>StartStop = TRUE - Start playing ringtone</line>\n"
            "          <line>FALSE - Stop playing the ringtone</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"RingtoneID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>RingtoneID = Unique ID of the Ringtone.</line>\n"
            "          <line>RingtoneID Range - 0x01 - 0xFF</line>\n"
            "          <line>0x00 - Reserved</line>\n"
            "          <line>0x01 - InbandRingtone</line>\n"
            "          <line>0x02 - 0xFF - SystemRingtones</line>\n"
            "          <line>Note:-</line>\n"
            "          <line>1. RingtoneID - 0x01 is forbidden for this method,</line>\n"
            "          <line>2. The clients need not set the ringtone ID, when the interface is invoked with the parameter StartStop as FALSE.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetRingtone\">\n"
            "      <doc>\n"
            "        <line>SetRingtone = Set the active ringtone for system wide or device specific.</line>\n"
            "        <line></line>\n"
            "        <line>The updated system wide ringtone will be available in the SystemWideRingtonesList property.</line>\n"
            "        <line>The updated device specific ringtone will be available in the DeviceRingtoneList property.</line>\n"
            "        <line></line>\n"
            "        <line>Note: - The setting will be retained persistently by Phone call Manager(PM).</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"DeviceAddress\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DeviceAddress = BT Address of the paired device[1].</line>\n"
            "          <line>If the DeviceAddress string is &quot;ALL&quot;[3], then the received RingtoneID is set for all the</line>\n"
            "          <line>paired devices[1] treating it as a system wide ringtone.</line>\n"
            "          <line></line>\n"
            "          <line>The setting will be applicable also for the devices that are paired[1] after the API is invoked.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"RingtoneID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>RingtoneID = Unique ID of the Ringtone.</line>\n"
            "          <line>RingtoneID Range - 0x01 - 0xFF</line>\n"
            "          <line>0x00 - Reserved</line>\n"
            "          <line>0x01 - InbandRingtone</line>\n"
            "          <line>0x02 - 0xFF - SystemRingtones</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SuppressRingtoneOnOff\">\n"
            "      <doc>\n"
            "        <line>SuppressRingtoneOnOff = Provides an option for the clients to change the ringtone setting- &quot;Suppress Ringtone&quot; to On/Off.</line>\n"
            "        <line>When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.</line>\n"
            "        <line></line>\n"
            "        <line>The updated changes will be available in the SuppressRingtoneOnOffList property.</line>\n"
            "        <line></line>\n"
            "        <line>Note: - The setting will be retained persistently by Phone call Manager(PM).</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"onOffSetting\" type=\"(sb)\">\n"
            "        <doc>\n"
            "          <line>onOffSetting (of type OnOffSetting) = Type representation of the parameter - (String, Boolean)</line>\n"
            "          <line></line>\n"
            "          <line>Note:</line>\n"
            "          <line>If the DeviceAddress string is &quot;ALL&quot;[3], then the received setting is set for all the</line>\n"
            "          <line>paired devices[1] treating it as a system wide setting.</line>\n"
            "          <line>The setting will be applicable also for the devices that are paired[1] after the API is invoked.</line>\n"
            "          <line>OnOffSetting struct[DeviceAddress, OnOffValue] = This structure has the device address and the On/Off value of the setting (AutoWaitingMode, SuppressRingtone,..).</line>\n"
            "          <line>0: OnOffSetting.DeviceAddress ('s') = BT Address of the paired device[1].</line>\n"
            "          <line>1: OnOffSetting.OnOffValue ('b') = TRUE - Enable / Enabled \n"
            "            FALSE - Disable / Disabled</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AutoWaitingModeOnOff\">\n"
            "      <doc>\n"
            "        <line>AutoWaitingModeOnOff = Provides the ability to enable or disable the auto waiting mode setting.</line>\n"
            "        <line>When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting</line>\n"
            "        <line>mode tone will be heard in the far end.</line>\n"
            "        <line></line>\n"
            "        <line>The updated changes will be available in the AutoWaitingModeOnOffList property.</line>\n"
            "        <line></line>\n"
            "        <line>Note: - The setting will be retained persistently by Phone call Manager(PM).</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"onOffSetting\" type=\"(sb)\">\n"
            "        <doc>\n"
            "          <line>onOffSetting (of type OnOffSetting) = Type representation of the parameter - (String, Boolean)</line>\n"
            "          <line></line>\n"
            "          <line>Note:</line>\n"
            "          <line>If the DeviceAddress string is &quot;ALL&quot;[3], then the received setting is set for all</line>\n"
            "          <line>paired devices[1] treating it as a system wide setting.</line>\n"
            "          <line>The setting will be applicable also for the devices that are paired[1] after the API is invoked.</line>\n"
            "          <line>OnOffSetting struct[DeviceAddress, OnOffValue] = This structure has the device address and the On/Off value of the setting (AutoWaitingMode, SuppressRingtone,..).</line>\n"
            "          <line>0: OnOffSetting.DeviceAddress ('s') = BT Address of the paired device[1].</line>\n"
            "          <line>1: OnOffSetting.OnOffValue ('b') = TRUE - Enable / Enabled \n"
            "            FALSE - Disable / Disabled</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetActivePhone\">\n"
            "      <doc>\n"
            "        <line>SetActivePhone = Provides the ability to set a device as an active device[2].</line>\n"
            "        <line>After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.</line>\n"
            "        <line></line>\n"
            "        <line>Note: - This API is meant to be invoked only for HFP connected devices.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"DeviceAddressList\" type=\"as\">\n"
            "        <doc>\n"
            "          <line>DeviceAddressList (of type DeviceAddressListType) = List of BT Addresses of the HFP connected devices that shall be made Active[2].</line>\n"
            "          <line>DeviceAddressListType = array[STRING]</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RestoreFactorySetting\">\n"
            "      <doc>\n"
            "        <line>RestoreFactorySetting = Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.</line>\n"
            "        <line></line>\n"
            "        <line>Possible errors:</line>\n"
            "        <line>com.bosch.pmapp.Error.Failed</line>\n"
            "        <line>com.bosch.pmapp.Error.InvalidArguments</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"DeviceAddress\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>DeviceAddress = BT Address of the paired device[1].</line>\n"
            "          <line>If the DeviceAddress string is &quot;ALL&quot;[3], then the settings for all the devices will be reset to default.</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"NotificationEvent\">\n"
            "      <doc>\n"
            "        <line>NotificationEvent = Indicate different phone call manager related events.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"EventDetails\" type=\"a{ss}\">\n"
            "        <doc>\n"
            "          <line>EventDetails (of type EventDetailsType) = Refer Type Definition and Comment of the parameter &quot;EventDetails&quot; for more information.</line>\n"
            "          <line>Example:</line>\n"
            "          <line>{</line>\n"
            "          <line>{&quot;EventName&quot; : &quot;OutgoingCallFailed&quot;}</line>\n"
            "          <line>{&quot;Reason&quot; : &quot;Operation not allowed&quot;}</line>\n"
            "          <line>{&quot;DeviceAddress&quot; : &quot;aabbccddeeff&quot;}</line>\n"
            "          <line>}</line>\n"
            "          <line>lineComment to be defined</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void HfpManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HfpManagerStub*>(getStub()))->onGetAll (properties);
}

void HfpManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SystemWideRingtonesList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceRingtoneList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "SuppressRingtoneOnOffList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "AutoWaitingModeOnOffList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "WaitingModeFilePath");
            ::boost::shared_ptr< WaitingModeFilePathSet > payload(new WaitingModeFilePathSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<HfpManagerStub*>(getStub())->onWaitingModeFilePathSet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneCallAudioActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "ActivePassiveDeviceList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceObjectPathList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HfpManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 8, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SystemWideRingtonesList");
            ::boost::shared_ptr< SystemWideRingtonesListGet > payload(new SystemWideRingtonesListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onSystemWideRingtonesListGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceRingtoneList");
            ::boost::shared_ptr< DeviceRingtoneListGet > payload(new DeviceRingtoneListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onDeviceRingtoneListGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "SuppressRingtoneOnOffList");
            ::boost::shared_ptr< SuppressRingtoneOnOffListGet > payload(new SuppressRingtoneOnOffListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onSuppressRingtoneOnOffListGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "AutoWaitingModeOnOffList");
            ::boost::shared_ptr< AutoWaitingModeOnOffListGet > payload(new AutoWaitingModeOnOffListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onAutoWaitingModeOnOffListGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "WaitingModeFilePath");
            ::boost::shared_ptr< WaitingModeFilePathGet > payload(new WaitingModeFilePathGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onWaitingModeFilePathGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneCallAudioActive");
            ::boost::shared_ptr< PhoneCallAudioActiveGet > payload(new PhoneCallAudioActiveGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onPhoneCallAudioActiveGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "ActivePassiveDeviceList");
            ::boost::shared_ptr< ActivePassiveDeviceListGet > payload(new ActivePassiveDeviceListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onActivePassiveDeviceListGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceObjectPathList");
            ::boost::shared_ptr< DeviceObjectPathListGet > payload(new DeviceObjectPathListGet());
            payload->setAct(act);
            static_cast<HfpManagerStub*>(getStub())->onDeviceObjectPathListGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HfpManagerStub::HfpManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HfpManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HfpManagerStub::HfpManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HfpManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HfpManagerStub::~HfpManagerStub() {
    delete _stubDelegate;
}

void HfpManagerStub::sendNotificationEventSignal(const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& eventDetails) {
    if (_stubDelegate->isConnected()) {
        NotificationEventSignal* payload = new NotificationEventSignal(eventDetails);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NotificationEvent", NotificationEventSignal, payload)
        LOG_INFO ("-> send%sSignal", "NotificationEvent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NotificationEvent");
    }
}

void HfpManagerStub::sendSystemWideRingtonesListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemWideRingtonesListUpdate payload(_SystemWideRingtonesListProperty);

        LOG_INFO ("-> send%s", "SystemWideRingtonesListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemWideRingtonesList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemWideRingtonesListUpdate");
    }
}

void HfpManagerStub::onSystemWideRingtonesListGet(const ::boost::shared_ptr< SystemWideRingtonesListGet >& systemWideRingtonesList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemWideRingtonesListGet", systemWideRingtonesList->getAct());
    sendSystemWideRingtonesListGetUpdate(_SystemWideRingtonesListProperty.getSystemWideRingtonesList(), systemWideRingtonesList->getAct());
}

void HfpManagerStub::sendSystemWideRingtonesListGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& systemWideRingtonesList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemWideRingtonesListGet payload(systemWideRingtonesList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemWideRingtonesListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setSystemWideRingtonesList(const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& systemWideRingtonesList) {
    if(systemWideRingtonesList!=_SystemWideRingtonesListProperty.getSystemWideRingtonesList()) {
        _SystemWideRingtonesListProperty.setSystemWideRingtonesList(systemWideRingtonesList);
        sendSystemWideRingtonesListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& HfpManagerStub::getSystemWideRingtonesList() const {
    return _SystemWideRingtonesListProperty.getSystemWideRingtonesList();
}

::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& HfpManagerStub::getSystemWideRingtonesListMutable() {
    return _SystemWideRingtonesListProperty.getSystemWideRingtonesListMutable();
}

void HfpManagerStub::sendDeviceRingtoneListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceRingtoneListUpdate payload(_DeviceRingtoneListProperty);

        LOG_INFO ("-> send%s", "DeviceRingtoneListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DeviceRingtoneList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceRingtoneListUpdate");
    }
}

void HfpManagerStub::onDeviceRingtoneListGet(const ::boost::shared_ptr< DeviceRingtoneListGet >& deviceRingtoneList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceRingtoneListGet", deviceRingtoneList->getAct());
    sendDeviceRingtoneListGetUpdate(_DeviceRingtoneListProperty.getDeviceRingtoneList(), deviceRingtoneList->getAct());
}

void HfpManagerStub::sendDeviceRingtoneListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& deviceRingtoneList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceRingtoneListGet payload(deviceRingtoneList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceRingtoneListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setDeviceRingtoneList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& deviceRingtoneList) {
    if(deviceRingtoneList!=_DeviceRingtoneListProperty.getDeviceRingtoneList()) {
        _DeviceRingtoneListProperty.setDeviceRingtoneList(deviceRingtoneList);
        sendDeviceRingtoneListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& HfpManagerStub::getDeviceRingtoneList() const {
    return _DeviceRingtoneListProperty.getDeviceRingtoneList();
}

::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& HfpManagerStub::getDeviceRingtoneListMutable() {
    return _DeviceRingtoneListProperty.getDeviceRingtoneListMutable();
}

void HfpManagerStub::sendSuppressRingtoneOnOffListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SuppressRingtoneOnOffListUpdate payload(_SuppressRingtoneOnOffListProperty);

        LOG_INFO ("-> send%s", "SuppressRingtoneOnOffListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SuppressRingtoneOnOffList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SuppressRingtoneOnOffListUpdate");
    }
}

void HfpManagerStub::onSuppressRingtoneOnOffListGet(const ::boost::shared_ptr< SuppressRingtoneOnOffListGet >& suppressRingtoneOnOffList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SuppressRingtoneOnOffListGet", suppressRingtoneOnOffList->getAct());
    sendSuppressRingtoneOnOffListGetUpdate(_SuppressRingtoneOnOffListProperty.getSuppressRingtoneOnOffList(), suppressRingtoneOnOffList->getAct());
}

void HfpManagerStub::sendSuppressRingtoneOnOffListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& suppressRingtoneOnOffList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SuppressRingtoneOnOffListGet payload(suppressRingtoneOnOffList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SuppressRingtoneOnOffListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setSuppressRingtoneOnOffList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& suppressRingtoneOnOffList) {
    if(suppressRingtoneOnOffList!=_SuppressRingtoneOnOffListProperty.getSuppressRingtoneOnOffList()) {
        _SuppressRingtoneOnOffListProperty.setSuppressRingtoneOnOffList(suppressRingtoneOnOffList);
        sendSuppressRingtoneOnOffListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerStub::getSuppressRingtoneOnOffList() const {
    return _SuppressRingtoneOnOffListProperty.getSuppressRingtoneOnOffList();
}

::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerStub::getSuppressRingtoneOnOffListMutable() {
    return _SuppressRingtoneOnOffListProperty.getSuppressRingtoneOnOffListMutable();
}

void HfpManagerStub::sendAutoWaitingModeOnOffListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AutoWaitingModeOnOffListUpdate payload(_AutoWaitingModeOnOffListProperty);

        LOG_INFO ("-> send%s", "AutoWaitingModeOnOffListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AutoWaitingModeOnOffList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AutoWaitingModeOnOffListUpdate");
    }
}

void HfpManagerStub::onAutoWaitingModeOnOffListGet(const ::boost::shared_ptr< AutoWaitingModeOnOffListGet >& autoWaitingModeOnOffList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AutoWaitingModeOnOffListGet", autoWaitingModeOnOffList->getAct());
    sendAutoWaitingModeOnOffListGetUpdate(_AutoWaitingModeOnOffListProperty.getAutoWaitingModeOnOffList(), autoWaitingModeOnOffList->getAct());
}

void HfpManagerStub::sendAutoWaitingModeOnOffListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& autoWaitingModeOnOffList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AutoWaitingModeOnOffListGet payload(autoWaitingModeOnOffList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AutoWaitingModeOnOffListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setAutoWaitingModeOnOffList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& autoWaitingModeOnOffList) {
    if(autoWaitingModeOnOffList!=_AutoWaitingModeOnOffListProperty.getAutoWaitingModeOnOffList()) {
        _AutoWaitingModeOnOffListProperty.setAutoWaitingModeOnOffList(autoWaitingModeOnOffList);
        sendAutoWaitingModeOnOffListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerStub::getAutoWaitingModeOnOffList() const {
    return _AutoWaitingModeOnOffListProperty.getAutoWaitingModeOnOffList();
}

::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerStub::getAutoWaitingModeOnOffListMutable() {
    return _AutoWaitingModeOnOffListProperty.getAutoWaitingModeOnOffListMutable();
}

void HfpManagerStub::sendWaitingModeFilePathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WaitingModeFilePathUpdate payload(_WaitingModeFilePathProperty);

        LOG_INFO ("-> send%s", "WaitingModeFilePathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WaitingModeFilePath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WaitingModeFilePathUpdate");
    }
}

void HfpManagerStub::onWaitingModeFilePathGet(const ::boost::shared_ptr< WaitingModeFilePathGet >& waitingModeFilePath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WaitingModeFilePathGet", waitingModeFilePath->getAct());
    sendWaitingModeFilePathGetUpdate(_WaitingModeFilePathProperty.getWaitingModeFilePath(), waitingModeFilePath->getAct());
}

void HfpManagerStub::sendWaitingModeFilePathGetUpdate(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WaitingModeFilePathGet payload(waitingModeFilePath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WaitingModeFilePathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::onWaitingModeFilePathSet(const ::boost::shared_ptr< WaitingModeFilePathSet >& waitingModeFilePath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WaitingModeFilePathSet", waitingModeFilePath->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*waitingModeFilePath, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setWaitingModeFilePath (waitingModeFilePath->getWaitingModeFilePath());
    sendWaitingModeFilePathSetUpdate(waitingModeFilePath->getAct());
}

void HfpManagerStub::sendWaitingModeFilePathSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WaitingModeFilePathSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void HfpManagerStub::setWaitingModeFilePath(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath) {
    if(waitingModeFilePath!=_WaitingModeFilePathProperty.getWaitingModeFilePath()) {
        _WaitingModeFilePathProperty.setWaitingModeFilePath(waitingModeFilePath);
        sendWaitingModeFilePathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& HfpManagerStub::getWaitingModeFilePath() const {
    return _WaitingModeFilePathProperty.getWaitingModeFilePath();
}

::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& HfpManagerStub::getWaitingModeFilePathMutable() {
    return _WaitingModeFilePathProperty.getWaitingModeFilePathMutable();
}

void HfpManagerStub::sendPhoneCallAudioActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PhoneCallAudioActiveUpdate payload(_PhoneCallAudioActiveProperty);

        LOG_INFO ("-> send%s", "PhoneCallAudioActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PhoneCallAudioActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PhoneCallAudioActiveUpdate");
    }
}

void HfpManagerStub::onPhoneCallAudioActiveGet(const ::boost::shared_ptr< PhoneCallAudioActiveGet >& phoneCallAudioActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PhoneCallAudioActiveGet", phoneCallAudioActive->getAct());
    sendPhoneCallAudioActiveGetUpdate(_PhoneCallAudioActiveProperty.getPhoneCallAudioActive(), phoneCallAudioActive->getAct());
}

void HfpManagerStub::sendPhoneCallAudioActiveGetUpdate(bool phoneCallAudioActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PhoneCallAudioActiveGet payload(phoneCallAudioActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PhoneCallAudioActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setPhoneCallAudioActive(bool phoneCallAudioActive) {
    if(phoneCallAudioActive!=_PhoneCallAudioActiveProperty.getPhoneCallAudioActive()) {
        _PhoneCallAudioActiveProperty.setPhoneCallAudioActive(phoneCallAudioActive);
        sendPhoneCallAudioActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool HfpManagerStub::getPhoneCallAudioActive() const {
    return _PhoneCallAudioActiveProperty.getPhoneCallAudioActive();
}

void HfpManagerStub::sendActivePassiveDeviceListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActivePassiveDeviceListUpdate payload(_ActivePassiveDeviceListProperty);

        LOG_INFO ("-> send%s", "ActivePassiveDeviceListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActivePassiveDeviceList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActivePassiveDeviceListUpdate");
    }
}

void HfpManagerStub::onActivePassiveDeviceListGet(const ::boost::shared_ptr< ActivePassiveDeviceListGet >& activePassiveDeviceList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActivePassiveDeviceListGet", activePassiveDeviceList->getAct());
    sendActivePassiveDeviceListGetUpdate(_ActivePassiveDeviceListProperty.getActivePassiveDeviceList(), activePassiveDeviceList->getAct());
}

void HfpManagerStub::sendActivePassiveDeviceListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& activePassiveDeviceList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActivePassiveDeviceListGet payload(activePassiveDeviceList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActivePassiveDeviceListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setActivePassiveDeviceList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& activePassiveDeviceList) {
    if(activePassiveDeviceList!=_ActivePassiveDeviceListProperty.getActivePassiveDeviceList()) {
        _ActivePassiveDeviceListProperty.setActivePassiveDeviceList(activePassiveDeviceList);
        sendActivePassiveDeviceListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& HfpManagerStub::getActivePassiveDeviceList() const {
    return _ActivePassiveDeviceListProperty.getActivePassiveDeviceList();
}

::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& HfpManagerStub::getActivePassiveDeviceListMutable() {
    return _ActivePassiveDeviceListProperty.getActivePassiveDeviceListMutable();
}

void HfpManagerStub::sendDeviceObjectPathListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceObjectPathListUpdate payload(_DeviceObjectPathListProperty);

        LOG_INFO ("-> send%s", "DeviceObjectPathListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DeviceObjectPathList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("com.bosch.pmapp.HfpManager", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceObjectPathListUpdate");
    }
}

void HfpManagerStub::onDeviceObjectPathListGet(const ::boost::shared_ptr< DeviceObjectPathListGet >& deviceObjectPathList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceObjectPathListGet", deviceObjectPathList->getAct());
    sendDeviceObjectPathListGetUpdate(_DeviceObjectPathListProperty.getDeviceObjectPathList(), deviceObjectPathList->getAct());
}

void HfpManagerStub::sendDeviceObjectPathListGetUpdate(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& deviceObjectPathList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceObjectPathListGet payload(deviceObjectPathList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceObjectPathListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HfpManagerStub::setDeviceObjectPathList(const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& deviceObjectPathList) {
    if(deviceObjectPathList!=_DeviceObjectPathListProperty.getDeviceObjectPathList()) {
        _DeviceObjectPathListProperty.setDeviceObjectPathList(deviceObjectPathList);
        sendDeviceObjectPathListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& HfpManagerStub::getDeviceObjectPathList() const {
    return _DeviceObjectPathListProperty.getDeviceObjectPathList();
}

::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& HfpManagerStub::getDeviceObjectPathListMutable() {
    return _DeviceObjectPathListProperty.getDeviceObjectPathListMutable();
}

void  HfpManagerStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& hfpManagerProperties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(hfpManagerProperties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendStartStopRingtoneResponse (act_t act) {
    StartStopRingtoneResponse* payload = new StartStopRingtoneResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "StartStopRingtone", StartStopRingtoneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartStopRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendStartStopRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartStopRingtoneError* payload = new StartStopRingtoneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartStopRingtone", StartStopRingtoneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartStopRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSetRingtoneResponse (act_t act) {
    SetRingtoneResponse* payload = new SetRingtoneResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetRingtone", SetRingtoneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSetRingtoneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetRingtoneError* payload = new SetRingtoneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetRingtone", SetRingtoneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetRingtone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSuppressRingtoneOnOffResponse (act_t act) {
    SuppressRingtoneOnOffResponse* payload = new SuppressRingtoneOnOffResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SuppressRingtoneOnOff", SuppressRingtoneOnOffResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SuppressRingtoneOnOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSuppressRingtoneOnOffError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SuppressRingtoneOnOffError* payload = new SuppressRingtoneOnOffError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SuppressRingtoneOnOff", SuppressRingtoneOnOffError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SuppressRingtoneOnOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendAutoWaitingModeOnOffResponse (act_t act) {
    AutoWaitingModeOnOffResponse* payload = new AutoWaitingModeOnOffResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "AutoWaitingModeOnOff", AutoWaitingModeOnOffResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AutoWaitingModeOnOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendAutoWaitingModeOnOffError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AutoWaitingModeOnOffError* payload = new AutoWaitingModeOnOffError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AutoWaitingModeOnOff", AutoWaitingModeOnOffError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AutoWaitingModeOnOff", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSetActivePhoneResponse (act_t act) {
    SetActivePhoneResponse* payload = new SetActivePhoneResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetActivePhone", SetActivePhoneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetActivePhone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendSetActivePhoneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetActivePhoneError* payload = new SetActivePhoneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetActivePhone", SetActivePhoneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetActivePhone", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendRestoreFactorySettingResponse (act_t act) {
    RestoreFactorySettingResponse* payload = new RestoreFactorySettingResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RestoreFactorySetting", RestoreFactorySettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestoreFactorySetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HfpManagerStub::sendRestoreFactorySettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestoreFactorySettingError* payload = new RestoreFactorySettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestoreFactorySetting", RestoreFactorySettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestoreFactorySetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HfpManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SystemWideRingtonesList'
    {
        ::asf::dbus::DBusVariant variant;
        SystemWideRingtonesListGet payload(_SystemWideRingtonesListProperty.getSystemWideRingtonesList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemWideRingtonesList", variant));
    }

    //property 'DeviceRingtoneList'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceRingtoneListGet payload(_DeviceRingtoneListProperty.getDeviceRingtoneList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DeviceRingtoneList", variant));
    }

    //property 'SuppressRingtoneOnOffList'
    {
        ::asf::dbus::DBusVariant variant;
        SuppressRingtoneOnOffListGet payload(_SuppressRingtoneOnOffListProperty.getSuppressRingtoneOnOffList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SuppressRingtoneOnOffList", variant));
    }

    //property 'AutoWaitingModeOnOffList'
    {
        ::asf::dbus::DBusVariant variant;
        AutoWaitingModeOnOffListGet payload(_AutoWaitingModeOnOffListProperty.getAutoWaitingModeOnOffList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AutoWaitingModeOnOffList", variant));
    }

    //property 'WaitingModeFilePath'
    {
        ::asf::dbus::DBusVariant variant;
        WaitingModeFilePathGet payload(_WaitingModeFilePathProperty.getWaitingModeFilePath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WaitingModeFilePath", variant));
    }

    //property 'PhoneCallAudioActive'
    {
        ::asf::dbus::DBusVariant variant;
        PhoneCallAudioActiveGet payload(_PhoneCallAudioActiveProperty.getPhoneCallAudioActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PhoneCallAudioActive", variant));
    }

    //property 'ActivePassiveDeviceList'
    {
        ::asf::dbus::DBusVariant variant;
        ActivePassiveDeviceListGet payload(_ActivePassiveDeviceListProperty.getActivePassiveDeviceList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActivePassiveDeviceList", variant));
    }

    //property 'DeviceObjectPathList'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceObjectPathListGet payload(_DeviceObjectPathListProperty.getDeviceObjectPathList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DeviceObjectPathList", variant));
    }
}

} // namespace HfpManager
} // namespace pmapp
} // namespace bosch
} // namespace com
