/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/pmapp/HfpManager.h"
#include "com/bosch/pmapp/HfpManagerDBus.h"
#include "com/bosch/pmapp/HfpManagerJson.h"
#include "com/bosch/pmapp/HfpManagerProxy.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace pmapp {
namespace HfpManager {

DEFINE_CLASS_LOGGER("/com/bosch/pmapp/com/bosch/pmapp/HfpManager", HfpManagerProxy);

class HfpManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    HfpManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< HfpManagerProxy >& proxyShared = ::boost::static_pointer_cast< HfpManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NotificationEvent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotificationEventSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NotificationEvent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NotificationEventSignal> payload = ::boost::static_pointer_cast<NotificationEventSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NotificationEventCallbackIF*) _callback)->onNotificationEventSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SystemWideRingtonesList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemWideRingtonesListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemWideRingtonesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemWideRingtonesListError> payload = ::boost::static_pointer_cast<SystemWideRingtonesListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SystemWideRingtonesListCallbackIF*) _callback)->onSystemWideRingtonesListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemWideRingtonesListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SystemWideRingtonesList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SystemWideRingtonesListUpdate> payload = ::boost::static_pointer_cast<SystemWideRingtonesListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SystemWideRingtonesListCallbackIF*) _callback)->onSystemWideRingtonesListUpdate(proxyShared, payload);
                        proxyShared->_systemWideRingtonesList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DeviceRingtoneList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceRingtoneListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceRingtoneList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceRingtoneListError> payload = ::boost::static_pointer_cast<DeviceRingtoneListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeviceRingtoneListCallbackIF*) _callback)->onDeviceRingtoneListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceRingtoneListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceRingtoneList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceRingtoneListUpdate> payload = ::boost::static_pointer_cast<DeviceRingtoneListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeviceRingtoneListCallbackIF*) _callback)->onDeviceRingtoneListUpdate(proxyShared, payload);
                        proxyShared->_deviceRingtoneList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SuppressRingtoneOnOffList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SuppressRingtoneOnOffListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SuppressRingtoneOnOffList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SuppressRingtoneOnOffListError> payload = ::boost::static_pointer_cast<SuppressRingtoneOnOffListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SuppressRingtoneOnOffListCallbackIF*) _callback)->onSuppressRingtoneOnOffListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SuppressRingtoneOnOffListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SuppressRingtoneOnOffList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SuppressRingtoneOnOffListUpdate> payload = ::boost::static_pointer_cast<SuppressRingtoneOnOffListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SuppressRingtoneOnOffListCallbackIF*) _callback)->onSuppressRingtoneOnOffListUpdate(proxyShared, payload);
                        proxyShared->_suppressRingtoneOnOffList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AutoWaitingModeOnOffList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AutoWaitingModeOnOffListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AutoWaitingModeOnOffList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AutoWaitingModeOnOffListError> payload = ::boost::static_pointer_cast<AutoWaitingModeOnOffListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AutoWaitingModeOnOffListCallbackIF*) _callback)->onAutoWaitingModeOnOffListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AutoWaitingModeOnOffListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AutoWaitingModeOnOffList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AutoWaitingModeOnOffListUpdate> payload = ::boost::static_pointer_cast<AutoWaitingModeOnOffListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AutoWaitingModeOnOffListCallbackIF*) _callback)->onAutoWaitingModeOnOffListUpdate(proxyShared, payload);
                        proxyShared->_autoWaitingModeOnOffList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WaitingModeFilePath:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaitingModeFilePathError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaitingModeFilePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaitingModeFilePathError> payload = ::boost::static_pointer_cast<WaitingModeFilePathError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WaitingModeFilePathCallbackIF*) _callback)->onWaitingModeFilePathError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WaitingModeFilePathUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WaitingModeFilePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WaitingModeFilePathUpdate> payload = ::boost::static_pointer_cast<WaitingModeFilePathUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WaitingModeFilePathCallbackIF*) _callback)->onWaitingModeFilePathUpdate(proxyShared, payload);
                        proxyShared->_waitingModeFilePath = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PhoneCallAudioActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PhoneCallAudioActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PhoneCallAudioActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PhoneCallAudioActiveError> payload = ::boost::static_pointer_cast<PhoneCallAudioActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PhoneCallAudioActiveCallbackIF*) _callback)->onPhoneCallAudioActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PhoneCallAudioActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PhoneCallAudioActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PhoneCallAudioActiveUpdate> payload = ::boost::static_pointer_cast<PhoneCallAudioActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PhoneCallAudioActiveCallbackIF*) _callback)->onPhoneCallAudioActiveUpdate(proxyShared, payload);
                        proxyShared->_phoneCallAudioActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ActivePassiveDeviceList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivePassiveDeviceListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActivePassiveDeviceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivePassiveDeviceListError> payload = ::boost::static_pointer_cast<ActivePassiveDeviceListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActivePassiveDeviceListCallbackIF*) _callback)->onActivePassiveDeviceListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivePassiveDeviceListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActivePassiveDeviceList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivePassiveDeviceListUpdate> payload = ::boost::static_pointer_cast<ActivePassiveDeviceListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActivePassiveDeviceListCallbackIF*) _callback)->onActivePassiveDeviceListUpdate(proxyShared, payload);
                        proxyShared->_activePassiveDeviceList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DeviceObjectPathList:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceObjectPathListError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceObjectPathList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceObjectPathListError> payload = ::boost::static_pointer_cast<DeviceObjectPathListError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeviceObjectPathListCallbackIF*) _callback)->onDeviceObjectPathListError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceObjectPathListUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceObjectPathList", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeviceObjectPathListUpdate> payload = ::boost::static_pointer_cast<DeviceObjectPathListUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeviceObjectPathListCallbackIF*) _callback)->onDeviceObjectPathListUpdate(proxyShared, payload);
                        proxyShared->_deviceObjectPathList = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StartStopRingtone:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartStopRingtoneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopRingtoneError> payload = ::boost::static_pointer_cast<StartStopRingtoneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopRingtoneCallbackIF*) _callback)->onStartStopRingtoneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartStopRingtoneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartStopRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartStopRingtoneResponse> payload = ::boost::static_pointer_cast<StartStopRingtoneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartStopRingtoneCallbackIF*) _callback)->onStartStopRingtoneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetRingtone:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetRingtoneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRingtoneError> payload = ::boost::static_pointer_cast<SetRingtoneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRingtoneCallbackIF*) _callback)->onSetRingtoneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetRingtoneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRingtone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetRingtoneResponse> payload = ::boost::static_pointer_cast<SetRingtoneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetRingtoneCallbackIF*) _callback)->onSetRingtoneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SuppressRingtoneOnOff:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SuppressRingtoneOnOffError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SuppressRingtoneOnOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SuppressRingtoneOnOffError> payload = ::boost::static_pointer_cast<SuppressRingtoneOnOffError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SuppressRingtoneOnOffCallbackIF*) _callback)->onSuppressRingtoneOnOffError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SuppressRingtoneOnOffResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SuppressRingtoneOnOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SuppressRingtoneOnOffResponse> payload = ::boost::static_pointer_cast<SuppressRingtoneOnOffResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SuppressRingtoneOnOffCallbackIF*) _callback)->onSuppressRingtoneOnOffResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AutoWaitingModeOnOff:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AutoWaitingModeOnOffError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AutoWaitingModeOnOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AutoWaitingModeOnOffError> payload = ::boost::static_pointer_cast<AutoWaitingModeOnOffError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AutoWaitingModeOnOffCallbackIF*) _callback)->onAutoWaitingModeOnOffError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AutoWaitingModeOnOffResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AutoWaitingModeOnOff", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AutoWaitingModeOnOffResponse> payload = ::boost::static_pointer_cast<AutoWaitingModeOnOffResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AutoWaitingModeOnOffCallbackIF*) _callback)->onAutoWaitingModeOnOffResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetActivePhone:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetActivePhoneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetActivePhone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetActivePhoneError> payload = ::boost::static_pointer_cast<SetActivePhoneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetActivePhoneCallbackIF*) _callback)->onSetActivePhoneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetActivePhoneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetActivePhone", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetActivePhoneResponse> payload = ::boost::static_pointer_cast<SetActivePhoneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetActivePhoneCallbackIF*) _callback)->onSetActivePhoneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RestoreFactorySetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestoreFactorySetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestoreFactorySettingError> payload = ::boost::static_pointer_cast<RestoreFactorySettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestoreFactorySettingCallbackIF*) _callback)->onRestoreFactorySettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestoreFactorySettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RestoreFactorySetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RestoreFactorySettingResponse> payload = ::boost::static_pointer_cast<RestoreFactorySettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RestoreFactorySettingCallbackIF*) _callback)->onRestoreFactorySettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NotificationEvent: {
                ::boost::shared_ptr< NotificationEventError > payload = ::boost::shared_ptr< NotificationEventError >
                (new NotificationEventError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NotificationEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NotificationEventCallbackIF*) _callback)->onNotificationEventError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SystemWideRingtonesList: {
                ::boost::shared_ptr< SystemWideRingtonesListError > payload = ::boost::shared_ptr< SystemWideRingtonesListError >
                (new SystemWideRingtonesListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SystemWideRingtonesList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SystemWideRingtonesListCallbackIF*) _callback)->onSystemWideRingtonesListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceRingtoneList: {
                ::boost::shared_ptr< DeviceRingtoneListError > payload = ::boost::shared_ptr< DeviceRingtoneListError >
                (new DeviceRingtoneListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceRingtoneList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceRingtoneListCallbackIF*) _callback)->onDeviceRingtoneListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SuppressRingtoneOnOffList: {
                ::boost::shared_ptr< SuppressRingtoneOnOffListError > payload = ::boost::shared_ptr< SuppressRingtoneOnOffListError >
                (new SuppressRingtoneOnOffListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SuppressRingtoneOnOffList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SuppressRingtoneOnOffListCallbackIF*) _callback)->onSuppressRingtoneOnOffListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AutoWaitingModeOnOffList: {
                ::boost::shared_ptr< AutoWaitingModeOnOffListError > payload = ::boost::shared_ptr< AutoWaitingModeOnOffListError >
                (new AutoWaitingModeOnOffListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AutoWaitingModeOnOffList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AutoWaitingModeOnOffListCallbackIF*) _callback)->onAutoWaitingModeOnOffListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WaitingModeFilePath: {
                ::boost::shared_ptr< WaitingModeFilePathError > payload = ::boost::shared_ptr< WaitingModeFilePathError >
                (new WaitingModeFilePathError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WaitingModeFilePath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WaitingModeFilePathCallbackIF*) _callback)->onWaitingModeFilePathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PhoneCallAudioActive: {
                ::boost::shared_ptr< PhoneCallAudioActiveError > payload = ::boost::shared_ptr< PhoneCallAudioActiveError >
                (new PhoneCallAudioActiveError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PhoneCallAudioActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PhoneCallAudioActiveCallbackIF*) _callback)->onPhoneCallAudioActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ActivePassiveDeviceList: {
                ::boost::shared_ptr< ActivePassiveDeviceListError > payload = ::boost::shared_ptr< ActivePassiveDeviceListError >
                (new ActivePassiveDeviceListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivePassiveDeviceList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivePassiveDeviceListCallbackIF*) _callback)->onActivePassiveDeviceListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceObjectPathList: {
                ::boost::shared_ptr< DeviceObjectPathListError > payload = ::boost::shared_ptr< DeviceObjectPathListError >
                (new DeviceObjectPathListError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceObjectPathList", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceObjectPathListCallbackIF*) _callback)->onDeviceObjectPathListError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartStopRingtone: {
                ::boost::shared_ptr< StartStopRingtoneError > payload = ::boost::shared_ptr< StartStopRingtoneError >
                (new StartStopRingtoneError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartStopRingtone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartStopRingtoneCallbackIF*) _callback)->onStartStopRingtoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetRingtone: {
                ::boost::shared_ptr< SetRingtoneError > payload = ::boost::shared_ptr< SetRingtoneError >
                (new SetRingtoneError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetRingtone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetRingtoneCallbackIF*) _callback)->onSetRingtoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SuppressRingtoneOnOff: {
                ::boost::shared_ptr< SuppressRingtoneOnOffError > payload = ::boost::shared_ptr< SuppressRingtoneOnOffError >
                (new SuppressRingtoneOnOffError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SuppressRingtoneOnOff", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SuppressRingtoneOnOffCallbackIF*) _callback)->onSuppressRingtoneOnOffError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AutoWaitingModeOnOff: {
                ::boost::shared_ptr< AutoWaitingModeOnOffError > payload = ::boost::shared_ptr< AutoWaitingModeOnOffError >
                (new AutoWaitingModeOnOffError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AutoWaitingModeOnOff", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AutoWaitingModeOnOffCallbackIF*) _callback)->onAutoWaitingModeOnOffError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetActivePhone: {
                ::boost::shared_ptr< SetActivePhoneError > payload = ::boost::shared_ptr< SetActivePhoneError >
                (new SetActivePhoneError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetActivePhone", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetActivePhoneCallbackIF*) _callback)->onSetActivePhoneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RestoreFactorySetting: {
                ::boost::shared_ptr< RestoreFactorySettingError > payload = ::boost::shared_ptr< RestoreFactorySettingError >
                (new RestoreFactorySettingError(DBUS_ERROR_NO_SERVER, "The DBus service HfpManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RestoreFactorySetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<HfpManagerProxy> proxyShared = ::boost::static_pointer_cast<HfpManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RestoreFactorySettingCallbackIF*) _callback)->onRestoreFactorySettingError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& HfpManagerProxyCallback::_logger (HfpManagerProxy::_logger);

HfpManagerProxy::HfpManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.pmapp.HfpManager", serviceAvailable, _logger) {
}

HfpManagerProxy::~HfpManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< HfpManagerProxy > HfpManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<HfpManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< HfpManagerProxy > proxyNew(new HfpManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t HfpManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t HfpManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HfpManagerProxy::clearAllProperties ()
{
    _systemWideRingtonesList = ::asf::core::nullable< SystemWideRingtonesListUpdate >();
    _deviceRingtoneList = ::asf::core::nullable< DeviceRingtoneListUpdate >();
    _suppressRingtoneOnOffList = ::asf::core::nullable< SuppressRingtoneOnOffListUpdate >();
    _autoWaitingModeOnOffList = ::asf::core::nullable< AutoWaitingModeOnOffListUpdate >();
    _waitingModeFilePath = ::asf::core::nullable< WaitingModeFilePathUpdate >();
    _phoneCallAudioActive = ::asf::core::nullable< PhoneCallAudioActiveUpdate >();
    _activePassiveDeviceList = ::asf::core::nullable< ActivePassiveDeviceListUpdate >();
    _deviceObjectPathList = ::asf::core::nullable< DeviceObjectPathListUpdate >();
}

void HfpManagerProxy::sendDeregisterAll () const
{
    sendSystemWideRingtonesListDeregisterAll();
    sendDeviceRingtoneListDeregisterAll();
    sendSuppressRingtoneOnOffListDeregisterAll();
    sendAutoWaitingModeOnOffListDeregisterAll();
    sendWaitingModeFilePathDeregisterAll();
    sendPhoneCallAudioActiveDeregisterAll();
    sendActivePassiveDeviceListDeregisterAll();
    sendDeviceObjectPathListDeregisterAll();
    sendNotificationEventDeregisterAll();
}

act_t HfpManagerProxy::sendNotificationEventRegister(NotificationEventCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NotificationEvent");
    act_t act = addSignalCallback(ID_NotificationEvent, "NotificationEvent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NotificationEvent", &cb, act);
    return act;
}

bool HfpManagerProxy::sendNotificationEventDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NotificationEvent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NotificationEvent", act, static_cast<int>(rv));
    return rv;
}

void HfpManagerProxy::sendNotificationEventDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NotificationEvent");
    _dbusProxyDelegate->deregisterSignalCallback("NotificationEvent", 0, _dbusDaemonProxy.get(), false);
}

act_t HfpManagerProxy::sendSystemWideRingtonesListRegister(SystemWideRingtonesListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SystemWideRingtonesList, "SystemWideRingtonesList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SystemWideRingtonesList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendSystemWideRingtonesListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SystemWideRingtonesList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SystemWideRingtonesList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendSystemWideRingtonesListGet(SystemWideRingtonesListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_SystemWideRingtonesList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SystemWideRingtonesList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SystemWideRingtonesList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& HfpManagerProxy::getSystemWideRingtonesList() const {
    return _systemWideRingtonesList.get().getSystemWideRingtonesList();
}

bool HfpManagerProxy::hasSystemWideRingtonesList() const {
    return _systemWideRingtonesList.hasValue();
}

void HfpManagerProxy::sendSystemWideRingtonesListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SystemWideRingtonesList");
    _dbusProxyDelegate->deregisterSignalCallback("SystemWideRingtonesList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendDeviceRingtoneListRegister(DeviceRingtoneListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DeviceRingtoneList, "DeviceRingtoneList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceRingtoneList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendDeviceRingtoneListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceRingtoneList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceRingtoneList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendDeviceRingtoneListGet(DeviceRingtoneListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_DeviceRingtoneList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeviceRingtoneList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DeviceRingtoneList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& HfpManagerProxy::getDeviceRingtoneList() const {
    return _deviceRingtoneList.get().getDeviceRingtoneList();
}

bool HfpManagerProxy::hasDeviceRingtoneList() const {
    return _deviceRingtoneList.hasValue();
}

void HfpManagerProxy::sendDeviceRingtoneListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceRingtoneList");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceRingtoneList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendSuppressRingtoneOnOffListRegister(SuppressRingtoneOnOffListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SuppressRingtoneOnOffList, "SuppressRingtoneOnOffList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SuppressRingtoneOnOffList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendSuppressRingtoneOnOffListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SuppressRingtoneOnOffList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SuppressRingtoneOnOffList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendSuppressRingtoneOnOffListGet(SuppressRingtoneOnOffListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_SuppressRingtoneOnOffList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SuppressRingtoneOnOffList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SuppressRingtoneOnOffList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerProxy::getSuppressRingtoneOnOffList() const {
    return _suppressRingtoneOnOffList.get().getSuppressRingtoneOnOffList();
}

bool HfpManagerProxy::hasSuppressRingtoneOnOffList() const {
    return _suppressRingtoneOnOffList.hasValue();
}

void HfpManagerProxy::sendSuppressRingtoneOnOffListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SuppressRingtoneOnOffList");
    _dbusProxyDelegate->deregisterSignalCallback("SuppressRingtoneOnOffList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendAutoWaitingModeOnOffListRegister(AutoWaitingModeOnOffListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AutoWaitingModeOnOffList, "AutoWaitingModeOnOffList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AutoWaitingModeOnOffList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendAutoWaitingModeOnOffListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AutoWaitingModeOnOffList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AutoWaitingModeOnOffList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendAutoWaitingModeOnOffListGet(AutoWaitingModeOnOffListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_AutoWaitingModeOnOffList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AutoWaitingModeOnOffList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AutoWaitingModeOnOffList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& HfpManagerProxy::getAutoWaitingModeOnOffList() const {
    return _autoWaitingModeOnOffList.get().getAutoWaitingModeOnOffList();
}

bool HfpManagerProxy::hasAutoWaitingModeOnOffList() const {
    return _autoWaitingModeOnOffList.hasValue();
}

void HfpManagerProxy::sendAutoWaitingModeOnOffListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AutoWaitingModeOnOffList");
    _dbusProxyDelegate->deregisterSignalCallback("AutoWaitingModeOnOffList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendWaitingModeFilePathRegister(WaitingModeFilePathCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WaitingModeFilePath, "WaitingModeFilePath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WaitingModeFilePath", &cb, act);
    return act;
}

bool HfpManagerProxy::sendWaitingModeFilePathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WaitingModeFilePath", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WaitingModeFilePath", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendWaitingModeFilePathGet(WaitingModeFilePathCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_WaitingModeFilePath, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WaitingModeFilePath", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WaitingModeFilePath", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void HfpManagerProxy::sendWaitingModeFilePathSet(const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath) {
    WaitingModeFilePathSet parameter(waitingModeFilePath);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "WaitingModeFilePath");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WaitingModeFilePath", propertyContent);
}

act_t HfpManagerProxy::sendWaitingModeFilePathSet(WaitingModeFilePathCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& waitingModeFilePath) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_WaitingModeFilePath, &cb);
    WaitingModeFilePathSet parameter(waitingModeFilePath);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "WaitingModeFilePath", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WaitingModeFilePath", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& HfpManagerProxy::getWaitingModeFilePath() const {
    return _waitingModeFilePath.get().getWaitingModeFilePath();
}

bool HfpManagerProxy::hasWaitingModeFilePath() const {
    return _waitingModeFilePath.hasValue();
}

void HfpManagerProxy::sendWaitingModeFilePathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WaitingModeFilePath");
    _dbusProxyDelegate->deregisterSignalCallback("WaitingModeFilePath", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendPhoneCallAudioActiveRegister(PhoneCallAudioActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PhoneCallAudioActive, "PhoneCallAudioActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PhoneCallAudioActive", &cb, act);
    return act;
}

bool HfpManagerProxy::sendPhoneCallAudioActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PhoneCallAudioActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PhoneCallAudioActive", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendPhoneCallAudioActiveGet(PhoneCallAudioActiveCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_PhoneCallAudioActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PhoneCallAudioActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PhoneCallAudioActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool HfpManagerProxy::getPhoneCallAudioActive() const {
    return _phoneCallAudioActive.get().getPhoneCallAudioActive();
}

bool HfpManagerProxy::hasPhoneCallAudioActive() const {
    return _phoneCallAudioActive.hasValue();
}

void HfpManagerProxy::sendPhoneCallAudioActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PhoneCallAudioActive");
    _dbusProxyDelegate->deregisterSignalCallback("PhoneCallAudioActive", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendActivePassiveDeviceListRegister(ActivePassiveDeviceListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ActivePassiveDeviceList, "ActivePassiveDeviceList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActivePassiveDeviceList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendActivePassiveDeviceListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ActivePassiveDeviceList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActivePassiveDeviceList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendActivePassiveDeviceListGet(ActivePassiveDeviceListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_ActivePassiveDeviceList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActivePassiveDeviceList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ActivePassiveDeviceList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& HfpManagerProxy::getActivePassiveDeviceList() const {
    return _activePassiveDeviceList.get().getActivePassiveDeviceList();
}

bool HfpManagerProxy::hasActivePassiveDeviceList() const {
    return _activePassiveDeviceList.hasValue();
}

void HfpManagerProxy::sendActivePassiveDeviceListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActivePassiveDeviceList");
    _dbusProxyDelegate->deregisterSignalCallback("ActivePassiveDeviceList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendDeviceObjectPathListRegister(DeviceObjectPathListCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DeviceObjectPathList, "DeviceObjectPathList", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceObjectPathList", &cb, act);
    return act;
}

bool HfpManagerProxy::sendDeviceObjectPathListDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceObjectPathList", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceObjectPathList", act, static_cast<int>(rv));
    return rv;
}

act_t HfpManagerProxy::sendDeviceObjectPathListGet(DeviceObjectPathListCallbackIF& cb) {
    HfpManagerProxyCallback* callback = new HfpManagerProxyCallback(ID_DeviceObjectPathList, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DeviceObjectPathList", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DeviceObjectPathList", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& HfpManagerProxy::getDeviceObjectPathList() const {
    return _deviceObjectPathList.get().getDeviceObjectPathList();
}

bool HfpManagerProxy::hasDeviceObjectPathList() const {
    return _deviceObjectPathList.hasValue();
}

void HfpManagerProxy::sendDeviceObjectPathListDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceObjectPathList");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceObjectPathList", 0, _dbusDaemonProxy.get(), true);
}

act_t HfpManagerProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendStartStopRingtoneRequest(StartStopRingtoneCallbackIF& cb, bool startStop, uint8 ringtoneID) const {
    StartStopRingtoneRequest* payload = new StartStopRingtoneRequest();
    CHECK_ALLOCATION(payload);
    payload->setStartStop(startStop);
    payload->setRingtoneID(ringtoneID);
    DBUS_MESSAGE_CALL(dbusMessage, "StartStopRingtone", StartStopRingtoneRequest, payload, true)
    act_t act = addMethodCallback(ID_StartStopRingtone, dbusMessage.getUniqueSerial(), "StartStopRingtone", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartStopRingtone", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendSetRingtoneRequest(SetRingtoneCallbackIF& cb, const ::std::string& deviceAddress, uint8 ringtoneID) const {
    SetRingtoneRequest* payload = new SetRingtoneRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceAddress(deviceAddress);
    payload->setRingtoneID(ringtoneID);
    DBUS_MESSAGE_CALL(dbusMessage, "SetRingtone", SetRingtoneRequest, payload, true)
    act_t act = addMethodCallback(ID_SetRingtone, dbusMessage.getUniqueSerial(), "SetRingtone", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetRingtone", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendSuppressRingtoneOnOffRequest(SuppressRingtoneOnOffCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting) const {
    SuppressRingtoneOnOffRequest* payload = new SuppressRingtoneOnOffRequest();
    CHECK_ALLOCATION(payload);
    payload->setOnOffSetting(onOffSetting);
    DBUS_MESSAGE_CALL(dbusMessage, "SuppressRingtoneOnOff", SuppressRingtoneOnOffRequest, payload, true)
    act_t act = addMethodCallback(ID_SuppressRingtoneOnOff, dbusMessage.getUniqueSerial(), "SuppressRingtoneOnOff", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SuppressRingtoneOnOff", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendAutoWaitingModeOnOffRequest(AutoWaitingModeOnOffCallbackIF& cb, const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting) const {
    AutoWaitingModeOnOffRequest* payload = new AutoWaitingModeOnOffRequest();
    CHECK_ALLOCATION(payload);
    payload->setOnOffSetting(onOffSetting);
    DBUS_MESSAGE_CALL(dbusMessage, "AutoWaitingModeOnOff", AutoWaitingModeOnOffRequest, payload, true)
    act_t act = addMethodCallback(ID_AutoWaitingModeOnOff, dbusMessage.getUniqueSerial(), "AutoWaitingModeOnOff", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AutoWaitingModeOnOff", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendSetActivePhoneRequest(SetActivePhoneCallbackIF& cb, const ::std::vector< ::std::string >& deviceAddressList) const {
    SetActivePhoneRequest* payload = new SetActivePhoneRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceAddressList(deviceAddressList);
    DBUS_MESSAGE_CALL(dbusMessage, "SetActivePhone", SetActivePhoneRequest, payload, true)
    act_t act = addMethodCallback(ID_SetActivePhone, dbusMessage.getUniqueSerial(), "SetActivePhone", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetActivePhone", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t HfpManagerProxy::sendRestoreFactorySettingRequest(RestoreFactorySettingCallbackIF& cb, const ::std::string& deviceAddress) const {
    RestoreFactorySettingRequest* payload = new RestoreFactorySettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setDeviceAddress(deviceAddress);
    DBUS_MESSAGE_CALL(dbusMessage, "RestoreFactorySetting", RestoreFactorySettingRequest, payload, true)
    act_t act = addMethodCallback(ID_RestoreFactorySetting, dbusMessage.getUniqueSerial(), "RestoreFactorySetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RestoreFactorySetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace HfpManager
} // namespace pmapp
} // namespace bosch
} // namespace com
