#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_HFPMANAGER_H
#define COM_BOSCH_PMAPP_HFPMANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "com/bosch/pmapp/PMAppTypeCollections.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/
 *
 *     Note:
 *     [1]
 *         TODO: Definition of the "Paired device" to be rephrased.
 *         - Paired device:
 *             From Phone Call Manager perspective, the paired device is the one which is paired and
 *             was HFP connected at least once with the vehicle HU.
 *     [2]
 *         - Active device:
 *             It is a HFP connected device for which
 *               -the SCO(Synchronous Connection Oriented) link could be established and
 *               -the phone call audio or Bluetooth Voice Recognition(BT-VR) audio shall be streamed
 *             between the AG and the HU speakers.
 *         - Passive device:
 *             It is a HFP connected device for which the SCO link shall not be established between AG and vehicle HU and
 *             hence the audio streaming is not possible.
 *     [3]- The string "All" is case-insensitive.
 *
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */

namespace com {
namespace bosch {
namespace pmapp {
namespace HfpManager {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_StartStopRingtone = 1;
static const uint16 ID_SetRingtone = 2;
static const uint16 ID_SuppressRingtoneOnOff = 3;
static const uint16 ID_AutoWaitingModeOnOff = 4;
static const uint16 ID_SetActivePhone = 5;
static const uint16 ID_RestoreFactorySetting = 6;

// signal IDs
static const uint16 ID_NotificationEvent = 7;

// property IDs
static const uint16 ID_SystemWideRingtonesList = 8;
static const uint16 ID_DeviceRingtoneList = 9;
static const uint16 ID_SuppressRingtoneOnOffList = 10;
static const uint16 ID_AutoWaitingModeOnOffList = 11;
static const uint16 ID_WaitingModeFilePath = 12;
static const uint16 ID_PhoneCallAudioActive = 13;
static const uint16 ID_ActivePassiveDeviceList = 14;
static const uint16 ID_DeviceObjectPathList = 15;

ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class GetPropertiesResponse;

class StartStopRingtoneRequest;

class SetRingtoneRequest;

class SuppressRingtoneOnOffRequest;

class AutoWaitingModeOnOffRequest;

class SetActivePhoneRequest;

class RestoreFactorySettingRequest;

class SystemWideRingtonesListUpdate;

class SystemWideRingtonesListRegister;

class DeviceRingtoneListUpdate;

class DeviceRingtoneListRegister;

class SuppressRingtoneOnOffListUpdate;

class SuppressRingtoneOnOffListRegister;

class AutoWaitingModeOnOffListUpdate;

class AutoWaitingModeOnOffListRegister;

class WaitingModeFilePathUpdate;

class WaitingModeFilePathRegister;

class PhoneCallAudioActiveUpdate;

class PhoneCallAudioActiveRegister;

class ActivePassiveDeviceListUpdate;

class ActivePassiveDeviceListRegister;

class DeviceObjectPathListUpdate;

class DeviceObjectPathListRegister;

class NotificationEventSignal;

// type definitions
/**
 * Get the properties of the HfpManager Interface.
 *
 *         Possible errors:
 *         ---
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InUse
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage StartStopRingtoneResponse;

/**
 * If the meaning of "StartStopRingtoneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartStopRingtoneError;

/**
 * Set the active ringtone for system wide or device specific.
 *
 *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
 *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetRingtoneResponse;

/**
 * If the meaning of "SetRingtoneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetRingtoneError;

/**
 * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
 *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
 *
 *         The updated changes will be available in the SuppressRingtoneOnOffList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SuppressRingtoneOnOffResponse;

/**
 * If the meaning of "SuppressRingtoneOnOffError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SuppressRingtoneOnOffError;

/**
 * Provides the ability to enable or disable the auto waiting mode setting.
 *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
 *         mode tone will be heard in the far end.
 *
 *         The updated changes will be available in the AutoWaitingModeOnOffList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AutoWaitingModeOnOffResponse;

/**
 * If the meaning of "AutoWaitingModeOnOffError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AutoWaitingModeOnOffError;

/**
 * Provides the ability to set a device as an active device[2].
 *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
 *
 *         Note: - This API is meant to be invoked only for HFP connected devices.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetActivePhoneResponse;

/**
 * If the meaning of "SetActivePhoneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetActivePhoneError;

/**
 * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RestoreFactorySettingResponse;

/**
 * If the meaning of "RestoreFactorySettingError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestoreFactorySettingError;

/**
 * Provides the system wide ringtone list with the currently selected ringtone.
 *
 *             Type Representation- Struct:
 *             ( UInt8, [(UInt8, String)] )
 *
 *             Example:
 *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
 */
typedef SystemWideRingtonesListUpdate SystemWideRingtonesListSet;

/**
 * Provides the system wide ringtone list with the currently selected ringtone.
 *
 *             Type Representation- Struct:
 *             ( UInt8, [(UInt8, String)] )
 *
 *             Example:
 *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
 */
typedef SystemWideRingtonesListUpdate SystemWideRingtonesListGet;

/**
 * If the meaning of "SystemWideRingtonesListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemWideRingtonesListError;

/**
 * Provides a list of paired devices[1] with its currently selected ringtone
 *
 *             Type Representation - Array of Struct - [(String, (UInt8, String))]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", (0x02, "RingtoneA")),
 *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
 *               ]
 */
typedef DeviceRingtoneListUpdate DeviceRingtoneListSet;

/**
 * Provides a list of paired devices[1] with its currently selected ringtone
 *
 *             Type Representation - Array of Struct - [(String, (UInt8, String))]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", (0x02, "RingtoneA")),
 *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
 *               ]
 */
typedef DeviceRingtoneListUpdate DeviceRingtoneListGet;

/**
 * If the meaning of "DeviceRingtoneListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceRingtoneListError;

/**
 * Provides the suppress ringtone setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
typedef SuppressRingtoneOnOffListUpdate SuppressRingtoneOnOffListSet;

/**
 * Provides the suppress ringtone setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
typedef SuppressRingtoneOnOffListUpdate SuppressRingtoneOnOffListGet;

/**
 * If the meaning of "SuppressRingtoneOnOffListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SuppressRingtoneOnOffListError;

/**
 * Provides the auto waiting mode setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
typedef AutoWaitingModeOnOffListUpdate AutoWaitingModeOnOffListSet;

/**
 * Provides the auto waiting mode setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
typedef AutoWaitingModeOnOffListUpdate AutoWaitingModeOnOffListGet;

/**
 * If the meaning of "AutoWaitingModeOnOffListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AutoWaitingModeOnOffListError;

/**
 * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
 *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
 *         supported by the connected device.
 *
 *             Type representation - Dict:
 *               { String : String }
 *
 *             Example:
 *               {
 *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
 *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
 *               }
 */
typedef WaitingModeFilePathUpdate WaitingModeFilePathSet;

/**
 * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
 *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
 *         supported by the connected device.
 *
 *             Type representation - Dict:
 *               { String : String }
 *
 *             Example:
 *               {
 *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
 *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
 *               }
 */
typedef WaitingModeFilePathUpdate WaitingModeFilePathGet;

/**
 * If the meaning of "WaitingModeFilePathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WaitingModeFilePathError;

/**
 * Provides the state of phone call audio streaming.
 *         The value will be set as TRUE when:
 *             - SCO is established between AG and HF AND
 *             - Audio channel is available AND
 *             - ECNR session is started.
 *         In all other cases the Status will be reported as FALSE.
 */
typedef PhoneCallAudioActiveUpdate PhoneCallAudioActiveSet;

/**
 * Provides the state of phone call audio streaming.
 *         The value will be set as TRUE when:
 *             - SCO is established between AG and HF AND
 *             - Audio channel is available AND
 *             - ECNR session is started.
 *         In all other cases the Status will be reported as FALSE.
 */
typedef PhoneCallAudioActiveUpdate PhoneCallAudioActiveGet;

/**
 * If the meaning of "PhoneCallAudioActiveError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PhoneCallAudioActiveError;

/**
 * Provides the current role of the HFP connected devices (Active/Passive)[2].
 *
 *             Type representation- Array of struct - [(String, UInt8)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", 0x01),
 *                 ("ggggiijjkkll", 0x00)
 *               ]
 */
typedef ActivePassiveDeviceListUpdate ActivePassiveDeviceListSet;

/**
 * Provides the current role of the HFP connected devices (Active/Passive)[2].
 *
 *             Type representation- Array of struct - [(String, UInt8)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", 0x01),
 *                 ("ggggiijjkkll", 0x00)
 *               ]
 */
typedef ActivePassiveDeviceListUpdate ActivePassiveDeviceListGet;

/**
 * If the meaning of "ActivePassiveDeviceListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivePassiveDeviceListError;

/**
 * Provides a list of object paths for each HFP connected device.
 *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
 *
 *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
 *         Clients shall no longer rely on the removed object path.
 *
 *             Type representation- Array of Struct - [(String, String)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
 *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
 *               ]
 *
 *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
 */
typedef DeviceObjectPathListUpdate DeviceObjectPathListSet;

/**
 * Provides a list of object paths for each HFP connected device.
 *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
 *
 *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
 *         Clients shall no longer rely on the removed object path.
 *
 *             Type representation- Array of Struct - [(String, String)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
 *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
 *               ]
 *
 *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
 */
typedef DeviceObjectPathListUpdate DeviceObjectPathListGet;

/**
 * If the meaning of "DeviceObjectPathListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceObjectPathListError;

/**
 * If the meaning of "NotificationEventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NotificationEventError;


/**
 * Get the properties of the HfpManager Interface.
 *
 *         Possible errors:
 *         ---
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& HfpManagerProperties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HfpManagerProperties"

    static const int kHfpManagerProperties = 0;

    /**
     * Clears the field "HfpManagerProperties".
     *
     * The field will be set to its default value. The hasHfpManagerProperties()
     * method will return false.
     */
    inline void clearHfpManagerProperties();

    /**
     * Checks whether the field "HfpManagerProperties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHfpManagerProperties()). Otherwise it will return false.
     */
    inline bool hasHfpManagerProperties () const;

    /**
     * Returns the value of the member "HfpManagerProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SystemWideRingtonesList" : (0x02, [( 0x02, "RingtoneA" ), (0x03,"RingtoneB")])}
     *                     {"DeviceRingtoneList" : [("aabbccddeeff", 0x02, "RingtoneA"), ("ggggiijjkkll", 0x03, "RingtoneB")]}
     *                     {"SuppressRingtoneOnOffList" : [("aabbccddeeff", false)("ggggiijjkkll", true)]}
     *                     {"AutoWaitingModeOnOffList" : [("aabbccddeeff", true)("ggggiijjkkll", false)]}
     *                     {"WaitingModeFilePath" : {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3", "FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}}
     *                     {"PhoneCallAudioActive" : true}
     *                     {"ActivePassiveDeviceList" : [("aabbccddeeff", 0x01), ("ggggiijjkkll", 0x00)]}
     *                     {"DeviceObjectPathList" : [("aabbccddeeff", "/com/bosch/pmapp/device1"), ("ggggiijjkkll", "/com/bosch/pmapp/device2")]}
     *                   }
     *
     * @return The value of the field "HfpManagerProperties"
     */
    inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& getHfpManagerProperties () const;

    /**
     * Retrieves the value of the field "HfpManagerProperties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HfpManagerProperties".
     */
    inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& getHfpManagerPropertiesMutable ();

    /**
     * Sets the value of the member "HfpManagerProperties".
     *
     * Type representation of the parameter - Dict:
     *                 { PropertyName : PropertyValue }
     *
     *                 Example:
     *                   {
     *                     {"SystemWideRingtonesList" : (0x02, [( 0x02, "RingtoneA" ), (0x03,"RingtoneB")])}
     *                     {"DeviceRingtoneList" : [("aabbccddeeff", 0x02, "RingtoneA"), ("ggggiijjkkll", 0x03, "RingtoneB")]}
     *                     {"SuppressRingtoneOnOffList" : [("aabbccddeeff", false)("ggggiijjkkll", true)]}
     *                     {"AutoWaitingModeOnOffList" : [("aabbccddeeff", true)("ggggiijjkkll", false)]}
     *                     {"WaitingModeFilePath" : {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3", "FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}}
     *                     {"PhoneCallAudioActive" : true}
     *                     {"ActivePassiveDeviceList" : [("aabbccddeeff", 0x01), ("ggggiijjkkll", 0x00)]}
     *                     {"DeviceObjectPathList" : [("aabbccddeeff", "/com/bosch/pmapp/device1"), ("ggggiijjkkll", "/com/bosch/pmapp/device2")]}
     *                   }
     *
     * @param HfpManagerProperties The value which will be set
     */
    inline void setHfpManagerProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& HfpManagerProperties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& getStringToHfpManagerVariantMap_DefaultInstance ();

    inline void set_has_HfpManagerProperties ();

    inline void clear_has_HfpManagerProperties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant > _HfpManagerProperties;

};

/**
 * Plays the ringtone(based on RingtoneID) or stops the ringtone that is currently playing.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InProgress
 *         com.bosch.pmapp.Error.InUse
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class StartStopRingtoneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartStopRingtoneRequest ();

    /**
     * Copy constructor
     */
    inline  StartStopRingtoneRequest (const StartStopRingtoneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartStopRingtoneRequest (bool StartStop_, uint8 RingtoneID_);

    /**
     * Destructor
     */
    inline virtual  ~StartStopRingtoneRequest();

    /**
     * Assignment operator
     */
    inline StartStopRingtoneRequest& operator = (const StartStopRingtoneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartStopRingtoneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartStopRingtoneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartStopRingtoneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartStopRingtoneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartStop"

    static const int kStartStop = 0;

    /**
     * Clears the field "StartStop".
     *
     * The field will be set to its default value. The hasStartStop()
     * method will return false.
     */
    inline void clearStartStop();

    /**
     * Checks whether the field "StartStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartStop()). Otherwise it will return false.
     */
    inline bool hasStartStop () const;

    /**
     * Returns the value of the member "StartStop".
     *
     * TRUE - Start playing ringtone
     *                 FALSE - Stop playing the ringtone
     *
     * @return The value of the field "StartStop"
     */
    inline bool getStartStop () const;

    /**
     * Sets the value of the member "StartStop".
     *
     * TRUE - Start playing ringtone
     *                 FALSE - Stop playing the ringtone
     *
     * @param StartStop The value which will be set
     */
    inline void setStartStop (bool StartStop_);

    // API of field "RingtoneID"

    static const int kRingtoneID = 1;

    /**
     * Clears the field "RingtoneID".
     *
     * The field will be set to its default value. The hasRingtoneID()
     * method will return false.
     */
    inline void clearRingtoneID();

    /**
     * Checks whether the field "RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRingtoneID()). Otherwise it will return false.
     */
    inline bool hasRingtoneID () const;

    /**
     * Returns the value of the member "RingtoneID".
     *
     * Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *                 Note:-
     *                 1. RingtoneID - 0x01 is forbidden for this method,
     *                 2. The clients need not set the ringtone ID, when the interface is invoked with the parameter StartStop as FALSE.
     *
     * @return The value of the field "RingtoneID"
     */
    inline uint8 getRingtoneID () const;

    /**
     * Sets the value of the member "RingtoneID".
     *
     * Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *                 Note:-
     *                 1. RingtoneID - 0x01 is forbidden for this method,
     *                 2. The clients need not set the ringtone ID, when the interface is invoked with the parameter StartStop as FALSE.
     *
     * @param RingtoneID The value which will be set
     */
    inline void setRingtoneID (uint8 RingtoneID_);

    static const StartStopRingtoneRequest &getDefaultInstance();

private:

    inline void set_has_StartStop ();

    inline void clear_has_StartStop ();

    inline void set_has_RingtoneID ();

    inline void clear_has_RingtoneID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _StartStop;

    uint8 _RingtoneID;

};

/**
 * Set the active ringtone for system wide or device specific.
 *
 *         The updated system wide ringtone will be available in the SystemWideRingtonesList property.
 *         The updated device specific ringtone will be available in the DeviceRingtoneList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class SetRingtoneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetRingtoneRequest ();

    /**
     * Copy constructor
     */
    inline  SetRingtoneRequest (const SetRingtoneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetRingtoneRequest (const ::std::string& DeviceAddress_, uint8 RingtoneID_);

    /**
     * Destructor
     */
    inline virtual  ~SetRingtoneRequest();

    /**
     * Assignment operator
     */
    inline SetRingtoneRequest& operator = (const SetRingtoneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetRingtoneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetRingtoneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetRingtoneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetRingtoneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the received RingtoneID is set for all the
     *                 paired devices[1] treating it as a system wide ringtone.
     *
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the received RingtoneID is set for all the
     *                 paired devices[1] treating it as a system wide ringtone.
     *
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the received RingtoneID is set for all the
     *                 paired devices[1] treating it as a system wide ringtone.
     *
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the received RingtoneID is set for all the
     *                 paired devices[1] treating it as a system wide ringtone.
     *
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    // API of field "RingtoneID"

    static const int kRingtoneID = 1;

    /**
     * Clears the field "RingtoneID".
     *
     * The field will be set to its default value. The hasRingtoneID()
     * method will return false.
     */
    inline void clearRingtoneID();

    /**
     * Checks whether the field "RingtoneID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRingtoneID()). Otherwise it will return false.
     */
    inline bool hasRingtoneID () const;

    /**
     * Returns the value of the member "RingtoneID".
     *
     * Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *
     * @return The value of the field "RingtoneID"
     */
    inline uint8 getRingtoneID () const;

    /**
     * Sets the value of the member "RingtoneID".
     *
     * Unique ID of the Ringtone.
     *                 RingtoneID Range - 0x01 - 0xFF
     *                     0x00 - Reserved
     *                     0x01 - InbandRingtone
     *                     0x02 - 0xFF - SystemRingtones
     *
     * @param RingtoneID The value which will be set
     */
    inline void setRingtoneID (uint8 RingtoneID_);

    static const SetRingtoneRequest &getDefaultInstance();

private:

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    inline void set_has_RingtoneID ();

    inline void clear_has_RingtoneID ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _DeviceAddress;

    uint8 _RingtoneID;

};

/**
 * Provides an option for the clients to change the ringtone setting- "Suppress Ringtone" to On/Off.
 *         When the setting is enabled, the incoming call ringtone will not be heard in the vehicle HU speakers.
 *
 *         The updated changes will be available in the SuppressRingtoneOnOffList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class SuppressRingtoneOnOffRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffRequest ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffRequest (const SuppressRingtoneOnOffRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SuppressRingtoneOnOffRequest (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_);

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffRequest();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffRequest& operator = (const SuppressRingtoneOnOffRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "onOffSetting"

    static const int kOnOffSetting = 0;

    /**
     * Clears the field "onOffSetting".
     *
     * The field will be set to its default value. The hasOnOffSetting()
     * method will return false.
     */
    inline void clearOnOffSetting();

    /**
     * Checks whether the field "onOffSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffSetting()). Otherwise it will return false.
     */
    inline bool hasOnOffSetting () const;

    /**
     * Returns the value of the member "onOffSetting".
     *
     * Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all the
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @return The value of the field "onOffSetting"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& getOnOffSetting () const;

    /**
     * Retrieves the value of the field "onOffSetting" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "onOffSetting".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& getOnOffSettingMutable ();

    /**
     * Sets the value of the member "onOffSetting".
     *
     * Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all the
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param onOffSetting The value which will be set
     */
    inline void setOnOffSetting (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_);

    static const SuppressRingtoneOnOffRequest &getDefaultInstance();

private:

    inline void set_has_onOffSetting ();

    inline void clear_has_onOffSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting _onOffSetting;

};

/**
 * Provides the ability to enable or disable the auto waiting mode setting.
 *         When the setting is enabled, an incoming call will be automatically put on waiting mode and the waiting
 *         mode tone will be heard in the far end.
 *
 *         The updated changes will be available in the AutoWaitingModeOnOffList property.
 *
 *         Note: - The setting will be retained persistently by Phone call Manager(PM).
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class AutoWaitingModeOnOffRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffRequest ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffRequest (const AutoWaitingModeOnOffRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AutoWaitingModeOnOffRequest (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_);

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffRequest();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffRequest& operator = (const AutoWaitingModeOnOffRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "onOffSetting"

    static const int kOnOffSetting = 0;

    /**
     * Clears the field "onOffSetting".
     *
     * The field will be set to its default value. The hasOnOffSetting()
     * method will return false.
     */
    inline void clearOnOffSetting();

    /**
     * Checks whether the field "onOffSetting" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffSetting()). Otherwise it will return false.
     */
    inline bool hasOnOffSetting () const;

    /**
     * Returns the value of the member "onOffSetting".
     *
     * Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @return The value of the field "onOffSetting"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& getOnOffSetting () const;

    /**
     * Retrieves the value of the field "onOffSetting" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "onOffSetting".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& getOnOffSettingMutable ();

    /**
     * Sets the value of the member "onOffSetting".
     *
     * Type representation of the parameter - (String, Boolean)
     *
     *                 Note:
     *                 If the DeviceAddress string is "ALL"[3], then the received setting is set for all
     *                 paired devices[1] treating it as a system wide setting.
     *                 The setting will be applicable also for the devices that are paired[1] after the API is invoked.
     *
     * @param onOffSetting The value which will be set
     */
    inline void setOnOffSetting (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_);

    static const AutoWaitingModeOnOffRequest &getDefaultInstance();

private:

    inline void set_has_onOffSetting ();

    inline void clear_has_onOffSetting ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting _onOffSetting;

};

/**
 * Provides the ability to set a device as an active device[2].
 *         After successful switching, ActivePassiveDeviceList property will be updated with current role of the device.
 *
 *         Note: - This API is meant to be invoked only for HFP connected devices.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class SetActivePhoneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetActivePhoneRequest ();

    /**
     * Copy constructor
     */
    inline  SetActivePhoneRequest (const SetActivePhoneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetActivePhoneRequest (const ::std::vector< ::std::string >& DeviceAddressList_);

    /**
     * Destructor
     */
    inline virtual  ~SetActivePhoneRequest();

    /**
     * Assignment operator
     */
    inline SetActivePhoneRequest& operator = (const SetActivePhoneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetActivePhoneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetActivePhoneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetActivePhoneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetActivePhoneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddressList"

    static const int kDeviceAddressList = 0;

    /**
     * Clears the field "DeviceAddressList".
     *
     * The field will be set to its default value. The hasDeviceAddressList()
     * method will return false.
     */
    inline void clearDeviceAddressList();

    /**
     * Checks whether the field "DeviceAddressList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddressList()). Otherwise it will return false.
     */
    inline bool hasDeviceAddressList () const;

    /**
     * Returns the value of the member "DeviceAddressList".
     *
     * List of BT Addresses of the HFP connected devices that shall be made Active[2].
     *
     * @return The value of the field "DeviceAddressList"
     */
    inline const ::std::vector< ::std::string >& getDeviceAddressList () const;

    /**
     * Retrieves the value of the field "DeviceAddressList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddressList".
     */
    inline ::std::vector< ::std::string >& getDeviceAddressListMutable ();

    /**
     * Sets the value of the member "DeviceAddressList".
     *
     * List of BT Addresses of the HFP connected devices that shall be made Active[2].
     *
     * @param DeviceAddressList The value which will be set
     */
    inline void setDeviceAddressList (const ::std::vector< ::std::string >& DeviceAddressList_);

    static const SetActivePhoneRequest &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_DeviceAddressList ();

    inline void clear_has_DeviceAddressList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _DeviceAddressList;

};

/**
 * Restores the settings - AutoWaitingMode, SuppressRingtone, DeviceRingtone to its default values.
 *
 *         Possible errors:
 *         com.bosch.pmapp.Error.Failed
 *         com.bosch.pmapp.Error.InvalidArguments
 */
class RestoreFactorySettingRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestoreFactorySettingRequest ();

    /**
     * Copy constructor
     */
    inline  RestoreFactorySettingRequest (const RestoreFactorySettingRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RestoreFactorySettingRequest (const ::std::string& DeviceAddress_);

    /**
     * Destructor
     */
    inline virtual  ~RestoreFactorySettingRequest();

    /**
     * Assignment operator
     */
    inline RestoreFactorySettingRequest& operator = (const RestoreFactorySettingRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestoreFactorySettingRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestoreFactorySettingRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestoreFactorySettingRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestoreFactorySettingRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceAddress"

    static const int kDeviceAddress = 0;

    /**
     * Clears the field "DeviceAddress".
     *
     * The field will be set to its default value. The hasDeviceAddress()
     * method will return false.
     */
    inline void clearDeviceAddress();

    /**
     * Checks whether the field "DeviceAddress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceAddress()). Otherwise it will return false.
     */
    inline bool hasDeviceAddress () const;

    /**
     * Returns the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the settings for all the devices will be reset to default.
     *
     * @return The value of the field "DeviceAddress"
     */
    inline const ::std::string& getDeviceAddress () const;

    /**
     * Retrieves the value of the field "DeviceAddress" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceAddress".
     */
    inline ::std::string& getDeviceAddressMutable ();

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the settings for all the devices will be reset to default.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const ::std::string& DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the settings for all the devices will be reset to default.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* DeviceAddress_);

    /**
     * Sets the value of the member "DeviceAddress".
     *
     * BT Address of the paired device[1].
     *                 If the DeviceAddress string is "ALL"[3], then the settings for all the devices will be reset to default.
     *
     * @param DeviceAddress The value which will be set
     */
    inline void setDeviceAddress (const char* value, size_t size);

    static const RestoreFactorySettingRequest &getDefaultInstance();

private:

    inline void set_has_DeviceAddress ();

    inline void clear_has_DeviceAddress ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _DeviceAddress;

};

/**
 * Provides the system wide ringtone list with the currently selected ringtone.
 *
 *             Type Representation- Struct:
 *             ( UInt8, [(UInt8, String)] )
 *
 *             Example:
 *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
 */
class SystemWideRingtonesListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemWideRingtonesListUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemWideRingtonesListUpdate (const SystemWideRingtonesListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemWideRingtonesListUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesList_);

    /**
     * Destructor
     */
    inline virtual  ~SystemWideRingtonesListUpdate();

    /**
     * Assignment operator
     */
    inline SystemWideRingtonesListUpdate& operator = (const SystemWideRingtonesListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemWideRingtonesListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemWideRingtonesListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemWideRingtonesListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemWideRingtonesListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemWideRingtonesList"

    static const int kSystemWideRingtonesList = 0;

    /**
     * Clears the field "SystemWideRingtonesList".
     *
     * The field will be set to its default value. The hasSystemWideRingtonesList()
     * method will return false.
     */
    inline void clearSystemWideRingtonesList();

    /**
     * Checks whether the field "SystemWideRingtonesList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemWideRingtonesList()). Otherwise it will return false.
     */
    inline bool hasSystemWideRingtonesList () const;

    /**
     * Returns the value of the member "SystemWideRingtonesList".
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @return The value of the field "SystemWideRingtonesList"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& getSystemWideRingtonesList () const;

    /**
     * Retrieves the value of the field "SystemWideRingtonesList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SystemWideRingtonesList".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& getSystemWideRingtonesListMutable ();

    /**
     * Sets the value of the member "SystemWideRingtonesList".
     *
     * Provides the system wide ringtone list with the currently selected ringtone.
     *
     *             Type Representation- Struct:
     *             ( UInt8, [(UInt8, String)] )
     *
     *             Example:
     *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
     *
     * @param SystemWideRingtonesList The value which will be set
     */
    inline void setSystemWideRingtonesList (const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesList_);

    static const SystemWideRingtonesListUpdate &getDefaultInstance();

private:

    inline void set_has_SystemWideRingtonesList ();

    inline void clear_has_SystemWideRingtonesList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType _SystemWideRingtonesList;

};

/**
 * Provides the system wide ringtone list with the currently selected ringtone.
 *
 *             Type Representation- Struct:
 *             ( UInt8, [(UInt8, String)] )
 *
 *             Example:
 *             (0x02, [ ( 0x02, "RingtoneA" ), ( 0x03, "RingtoneB" ), ..] )
 */
class SystemWideRingtonesListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemWideRingtonesListRegister ();

    /**
     * Copy constructor
     */
    inline  SystemWideRingtonesListRegister (const SystemWideRingtonesListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemWideRingtonesListRegister();

    /**
     * Assignment operator
     */
    inline SystemWideRingtonesListRegister& operator = (const SystemWideRingtonesListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemWideRingtonesListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemWideRingtonesListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemWideRingtonesListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemWideRingtonesListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemWideRingtonesListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides a list of paired devices[1] with its currently selected ringtone
 *
 *             Type Representation - Array of Struct - [(String, (UInt8, String))]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", (0x02, "RingtoneA")),
 *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
 *               ]
 */
class DeviceRingtoneListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceRingtoneListUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceRingtoneListUpdate (const DeviceRingtoneListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceRingtoneListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneList_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceRingtoneListUpdate();

    /**
     * Assignment operator
     */
    inline DeviceRingtoneListUpdate& operator = (const DeviceRingtoneListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRingtoneListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRingtoneListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRingtoneListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRingtoneListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceRingtoneList"

    static const int kDeviceRingtoneList = 0;

    /**
     * Clears the field "DeviceRingtoneList".
     *
     * The field will be set to its default value. The hasDeviceRingtoneList()
     * method will return false.
     */
    inline void clearDeviceRingtoneList();

    /**
     * Checks whether the field "DeviceRingtoneList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceRingtoneList()). Otherwise it will return false.
     */
    inline bool hasDeviceRingtoneList () const;

    /**
     * Returns the value of the member "DeviceRingtoneList".
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @return The value of the field "DeviceRingtoneList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneList () const;

    /**
     * Retrieves the value of the field "DeviceRingtoneList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceRingtoneList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneListMutable ();

    /**
     * Sets the value of the member "DeviceRingtoneList".
     *
     * Provides a list of paired devices[1] with its currently selected ringtone
     *
     *             Type Representation - Array of Struct - [(String, (UInt8, String))]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", (0x02, "RingtoneA")),
     *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
     *               ]
     *
     * @param DeviceRingtoneList The value which will be set
     */
    inline void setDeviceRingtoneList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneList_);

    static const DeviceRingtoneListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& getDeviceRingtoneInfoList_DefaultInstance ();

    inline void set_has_DeviceRingtoneList ();

    inline void clear_has_DeviceRingtoneList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo > _DeviceRingtoneList;

};

/**
 * Provides a list of paired devices[1] with its currently selected ringtone
 *
 *             Type Representation - Array of Struct - [(String, (UInt8, String))]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", (0x02, "RingtoneA")),
 *                 ("ggggiijjkkll", (0x03, "RingtoneB"))
 *               ]
 */
class DeviceRingtoneListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceRingtoneListRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceRingtoneListRegister (const DeviceRingtoneListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceRingtoneListRegister();

    /**
     * Assignment operator
     */
    inline DeviceRingtoneListRegister& operator = (const DeviceRingtoneListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRingtoneListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRingtoneListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRingtoneListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRingtoneListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceRingtoneListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the suppress ringtone setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
class SuppressRingtoneOnOffListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffListUpdate ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffListUpdate (const SuppressRingtoneOnOffListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SuppressRingtoneOnOffListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffList_);

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffListUpdate();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffListUpdate& operator = (const SuppressRingtoneOnOffListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SuppressRingtoneOnOffList"

    static const int kSuppressRingtoneOnOffList = 0;

    /**
     * Clears the field "SuppressRingtoneOnOffList".
     *
     * The field will be set to its default value. The hasSuppressRingtoneOnOffList()
     * method will return false.
     */
    inline void clearSuppressRingtoneOnOffList();

    /**
     * Checks whether the field "SuppressRingtoneOnOffList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuppressRingtoneOnOffList()). Otherwise it will return false.
     */
    inline bool hasSuppressRingtoneOnOffList () const;

    /**
     * Returns the value of the member "SuppressRingtoneOnOffList".
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @return The value of the field "SuppressRingtoneOnOffList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getSuppressRingtoneOnOffList () const;

    /**
     * Retrieves the value of the field "SuppressRingtoneOnOffList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SuppressRingtoneOnOffList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getSuppressRingtoneOnOffListMutable ();

    /**
     * Sets the value of the member "SuppressRingtoneOnOffList".
     *
     * Provides the suppress ringtone setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param SuppressRingtoneOnOffList The value which will be set
     */
    inline void setSuppressRingtoneOnOffList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffList_);

    static const SuppressRingtoneOnOffListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getOnOffSettingList_DefaultInstance ();

    inline void set_has_SuppressRingtoneOnOffList ();

    inline void clear_has_SuppressRingtoneOnOffList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting > _SuppressRingtoneOnOffList;

};

/**
 * Provides the suppress ringtone setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
class SuppressRingtoneOnOffListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SuppressRingtoneOnOffListRegister ();

    /**
     * Copy constructor
     */
    inline  SuppressRingtoneOnOffListRegister (const SuppressRingtoneOnOffListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SuppressRingtoneOnOffListRegister();

    /**
     * Assignment operator
     */
    inline SuppressRingtoneOnOffListRegister& operator = (const SuppressRingtoneOnOffListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SuppressRingtoneOnOffListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SuppressRingtoneOnOffListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SuppressRingtoneOnOffListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SuppressRingtoneOnOffListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SuppressRingtoneOnOffListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the auto waiting mode setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
class AutoWaitingModeOnOffListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffListUpdate ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffListUpdate (const AutoWaitingModeOnOffListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AutoWaitingModeOnOffListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffList_);

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffListUpdate();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffListUpdate& operator = (const AutoWaitingModeOnOffListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AutoWaitingModeOnOffList"

    static const int kAutoWaitingModeOnOffList = 0;

    /**
     * Clears the field "AutoWaitingModeOnOffList".
     *
     * The field will be set to its default value. The hasAutoWaitingModeOnOffList()
     * method will return false.
     */
    inline void clearAutoWaitingModeOnOffList();

    /**
     * Checks whether the field "AutoWaitingModeOnOffList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAutoWaitingModeOnOffList()). Otherwise it will return false.
     */
    inline bool hasAutoWaitingModeOnOffList () const;

    /**
     * Returns the value of the member "AutoWaitingModeOnOffList".
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @return The value of the field "AutoWaitingModeOnOffList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getAutoWaitingModeOnOffList () const;

    /**
     * Retrieves the value of the field "AutoWaitingModeOnOffList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AutoWaitingModeOnOffList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getAutoWaitingModeOnOffListMutable ();

    /**
     * Sets the value of the member "AutoWaitingModeOnOffList".
     *
     * Provides the auto waiting mode setting state for all paired devices[1].
     *
     *             Type Representation- Array of struct - [(String, Boolean)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", false)
     *                 ("ggggiijjkkll", true)
     *               ]
     *
     * @param AutoWaitingModeOnOffList The value which will be set
     */
    inline void setAutoWaitingModeOnOffList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffList_);

    static const AutoWaitingModeOnOffListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& getOnOffSettingList_DefaultInstance ();

    inline void set_has_AutoWaitingModeOnOffList ();

    inline void clear_has_AutoWaitingModeOnOffList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting > _AutoWaitingModeOnOffList;

};

/**
 * Provides the auto waiting mode setting state for all paired devices[1].
 *
 *             Type Representation- Array of struct - [(String, Boolean)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", false)
 *                 ("ggggiijjkkll", true)
 *               ]
 */
class AutoWaitingModeOnOffListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AutoWaitingModeOnOffListRegister ();

    /**
     * Copy constructor
     */
    inline  AutoWaitingModeOnOffListRegister (const AutoWaitingModeOnOffListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AutoWaitingModeOnOffListRegister();

    /**
     * Assignment operator
     */
    inline AutoWaitingModeOnOffListRegister& operator = (const AutoWaitingModeOnOffListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AutoWaitingModeOnOffListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AutoWaitingModeOnOffListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AutoWaitingModeOnOffListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AutoWaitingModeOnOffListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AutoWaitingModeOnOffListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
 *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
 *         supported by the connected device.
 *
 *             Type representation - Dict:
 *               { String : String }
 *
 *             Example:
 *               {
 *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
 *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
 *               }
 */
class WaitingModeFilePathUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaitingModeFilePathUpdate ();

    /**
     * Copy constructor
     */
    inline  WaitingModeFilePathUpdate (const WaitingModeFilePathUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WaitingModeFilePathUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePath_);

    /**
     * Destructor
     */
    inline virtual  ~WaitingModeFilePathUpdate();

    /**
     * Assignment operator
     */
    inline WaitingModeFilePathUpdate& operator = (const WaitingModeFilePathUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaitingModeFilePathUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaitingModeFilePathUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaitingModeFilePathUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaitingModeFilePathUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WaitingModeFilePath"

    static const int kWaitingModeFilePath = 0;

    /**
     * Clears the field "WaitingModeFilePath".
     *
     * The field will be set to its default value. The hasWaitingModeFilePath()
     * method will return false.
     */
    inline void clearWaitingModeFilePath();

    /**
     * Checks whether the field "WaitingModeFilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWaitingModeFilePath()). Otherwise it will return false.
     */
    inline bool hasWaitingModeFilePath () const;

    /**
     * Returns the value of the member "WaitingModeFilePath".
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @return The value of the field "WaitingModeFilePath"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& getWaitingModeFilePath () const;

    /**
     * Retrieves the value of the field "WaitingModeFilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WaitingModeFilePath".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& getWaitingModeFilePathMutable ();

    /**
     * Sets the value of the member "WaitingModeFilePath".
     *
     * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
     *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
     *         supported by the connected device.
     *
     *             Type representation - Dict:
     *               { String : String }
     *
     *             Example:
     *               {
     *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
     *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
     *               }
     *
     * @param WaitingModeFilePath The value which will be set
     */
    inline void setWaitingModeFilePath (const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePath_);

    static const WaitingModeFilePathUpdate &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::string >& getStringToStringMap_DefaultInstance ();

    inline void set_has_WaitingModeFilePath ();

    inline void clear_has_WaitingModeFilePath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType _WaitingModeFilePath;

};

/**
 * Provides the ability to Get and Set the filepath for NarrowBand and WideBand audio files.
 *         One of these files will be played during active waiting mode state based on the audio codec (NarrowBand/Wideband)
 *         supported by the connected device.
 *
 *             Type representation - Dict:
 *               { String : String }
 *
 *             Example:
 *               {
 *                 {"FilePathNB" : "/path/to/file/waitingmodeNB.mp3"}
 *                 {"FilePathWB" : "/path/to/file/waitingmodeWB.mp3"}
 *               }
 */
class WaitingModeFilePathRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WaitingModeFilePathRegister ();

    /**
     * Copy constructor
     */
    inline  WaitingModeFilePathRegister (const WaitingModeFilePathRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WaitingModeFilePathRegister();

    /**
     * Assignment operator
     */
    inline WaitingModeFilePathRegister& operator = (const WaitingModeFilePathRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WaitingModeFilePathRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WaitingModeFilePathRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WaitingModeFilePathRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WaitingModeFilePathRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WaitingModeFilePathRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the state of phone call audio streaming.
 *         The value will be set as TRUE when:
 *             - SCO is established between AG and HF AND
 *             - Audio channel is available AND
 *             - ECNR session is started.
 *         In all other cases the Status will be reported as FALSE.
 */
class PhoneCallAudioActiveUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneCallAudioActiveUpdate ();

    /**
     * Copy constructor
     */
    inline  PhoneCallAudioActiveUpdate (const PhoneCallAudioActiveUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneCallAudioActiveUpdate (bool PhoneCallAudioActive_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneCallAudioActiveUpdate();

    /**
     * Assignment operator
     */
    inline PhoneCallAudioActiveUpdate& operator = (const PhoneCallAudioActiveUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneCallAudioActiveUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneCallAudioActiveUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneCallAudioActiveUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneCallAudioActiveUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneCallAudioActive"

    static const int kPhoneCallAudioActive = 0;

    /**
     * Clears the field "PhoneCallAudioActive".
     *
     * The field will be set to its default value. The hasPhoneCallAudioActive()
     * method will return false.
     */
    inline void clearPhoneCallAudioActive();

    /**
     * Checks whether the field "PhoneCallAudioActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneCallAudioActive()). Otherwise it will return false.
     */
    inline bool hasPhoneCallAudioActive () const;

    /**
     * Returns the value of the member "PhoneCallAudioActive".
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @return The value of the field "PhoneCallAudioActive"
     */
    inline bool getPhoneCallAudioActive () const;

    /**
     * Sets the value of the member "PhoneCallAudioActive".
     *
     * Provides the state of phone call audio streaming.
     *         The value will be set as TRUE when:
     *             - SCO is established between AG and HF AND
     *             - Audio channel is available AND
     *             - ECNR session is started.
     *         In all other cases the Status will be reported as FALSE.
     *
     * @param PhoneCallAudioActive The value which will be set
     */
    inline void setPhoneCallAudioActive (bool PhoneCallAudioActive_);

    static const PhoneCallAudioActiveUpdate &getDefaultInstance();

private:

    inline void set_has_PhoneCallAudioActive ();

    inline void clear_has_PhoneCallAudioActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _PhoneCallAudioActive;

};

/**
 * Provides the state of phone call audio streaming.
 *         The value will be set as TRUE when:
 *             - SCO is established between AG and HF AND
 *             - Audio channel is available AND
 *             - ECNR session is started.
 *         In all other cases the Status will be reported as FALSE.
 */
class PhoneCallAudioActiveRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneCallAudioActiveRegister ();

    /**
     * Copy constructor
     */
    inline  PhoneCallAudioActiveRegister (const PhoneCallAudioActiveRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PhoneCallAudioActiveRegister();

    /**
     * Assignment operator
     */
    inline PhoneCallAudioActiveRegister& operator = (const PhoneCallAudioActiveRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneCallAudioActiveRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneCallAudioActiveRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneCallAudioActiveRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneCallAudioActiveRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PhoneCallAudioActiveRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides the current role of the HFP connected devices (Active/Passive)[2].
 *
 *             Type representation- Array of struct - [(String, UInt8)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", 0x01),
 *                 ("ggggiijjkkll", 0x00)
 *               ]
 */
class ActivePassiveDeviceListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivePassiveDeviceListUpdate ();

    /**
     * Copy constructor
     */
    inline  ActivePassiveDeviceListUpdate (const ActivePassiveDeviceListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActivePassiveDeviceListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceList_);

    /**
     * Destructor
     */
    inline virtual  ~ActivePassiveDeviceListUpdate();

    /**
     * Assignment operator
     */
    inline ActivePassiveDeviceListUpdate& operator = (const ActivePassiveDeviceListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivePassiveDeviceListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivePassiveDeviceListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivePassiveDeviceListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivePassiveDeviceListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActivePassiveDeviceList"

    static const int kActivePassiveDeviceList = 0;

    /**
     * Clears the field "ActivePassiveDeviceList".
     *
     * The field will be set to its default value. The hasActivePassiveDeviceList()
     * method will return false.
     */
    inline void clearActivePassiveDeviceList();

    /**
     * Checks whether the field "ActivePassiveDeviceList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActivePassiveDeviceList()). Otherwise it will return false.
     */
    inline bool hasActivePassiveDeviceList () const;

    /**
     * Returns the value of the member "ActivePassiveDeviceList".
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @return The value of the field "ActivePassiveDeviceList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getActivePassiveDeviceList () const;

    /**
     * Retrieves the value of the field "ActivePassiveDeviceList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActivePassiveDeviceList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getActivePassiveDeviceListMutable ();

    /**
     * Sets the value of the member "ActivePassiveDeviceList".
     *
     * Provides the current role of the HFP connected devices (Active/Passive)[2].
     *
     *             Type representation- Array of struct - [(String, UInt8)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", 0x01),
     *                 ("ggggiijjkkll", 0x00)
     *               ]
     *
     * @param ActivePassiveDeviceList The value which will be set
     */
    inline void setActivePassiveDeviceList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceList_);

    static const ActivePassiveDeviceListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& getHfpRoleInfoList_DefaultInstance ();

    inline void set_has_ActivePassiveDeviceList ();

    inline void clear_has_ActivePassiveDeviceList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo > _ActivePassiveDeviceList;

};

/**
 * Provides the current role of the HFP connected devices (Active/Passive)[2].
 *
 *             Type representation- Array of struct - [(String, UInt8)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", 0x01),
 *                 ("ggggiijjkkll", 0x00)
 *               ]
 */
class ActivePassiveDeviceListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivePassiveDeviceListRegister ();

    /**
     * Copy constructor
     */
    inline  ActivePassiveDeviceListRegister (const ActivePassiveDeviceListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActivePassiveDeviceListRegister();

    /**
     * Assignment operator
     */
    inline ActivePassiveDeviceListRegister& operator = (const ActivePassiveDeviceListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivePassiveDeviceListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivePassiveDeviceListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivePassiveDeviceListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivePassiveDeviceListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActivePassiveDeviceListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Provides a list of object paths for each HFP connected device.
 *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
 *
 *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
 *         Clients shall no longer rely on the removed object path.
 *
 *             Type representation- Array of Struct - [(String, String)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
 *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
 *               ]
 *
 *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
 */
class DeviceObjectPathListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceObjectPathListUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceObjectPathListUpdate (const DeviceObjectPathListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceObjectPathListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathList_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceObjectPathListUpdate();

    /**
     * Assignment operator
     */
    inline DeviceObjectPathListUpdate& operator = (const DeviceObjectPathListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceObjectPathListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceObjectPathListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceObjectPathListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceObjectPathListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceObjectPathList"

    static const int kDeviceObjectPathList = 0;

    /**
     * Clears the field "DeviceObjectPathList".
     *
     * The field will be set to its default value. The hasDeviceObjectPathList()
     * method will return false.
     */
    inline void clearDeviceObjectPathList();

    /**
     * Checks whether the field "DeviceObjectPathList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceObjectPathList()). Otherwise it will return false.
     */
    inline bool hasDeviceObjectPathList () const;

    /**
     * Returns the value of the member "DeviceObjectPathList".
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @return The value of the field "DeviceObjectPathList"
     */
    inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathList () const;

    /**
     * Retrieves the value of the field "DeviceObjectPathList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceObjectPathList".
     */
    inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathListMutable ();

    /**
     * Sets the value of the member "DeviceObjectPathList".
     *
     * Provides a list of object paths for each HFP connected device.
     *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
     *
     *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
     *         Clients shall no longer rely on the removed object path.
     *
     *             Type representation- Array of Struct - [(String, String)]
     *
     *             Example:
     *               [
     *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
     *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
     *               ]
     *
     *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
     *
     * @param DeviceObjectPathList The value which will be set
     */
    inline void setDeviceObjectPathList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathList_);

    static const DeviceObjectPathListUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& getDeviceObjectPathInfoList_DefaultInstance ();

    inline void set_has_DeviceObjectPathList ();

    inline void clear_has_DeviceObjectPathList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo > _DeviceObjectPathList;

};

/**
 * Provides a list of object paths for each HFP connected device.
 *         Clients shall rely upon this object path for the phone call manager interfaces - "DeviceInfo, VoiceCall and VoiceRecognition"
 *
 *         When the Connected HFP device is disconnected then the item (Device address and relevant object path) shall be removed from the list.
 *         Clients shall no longer rely on the removed object path.
 *
 *             Type representation- Array of Struct - [(String, String)]
 *
 *             Example:
 *               [
 *                 ("aabbccddeeff", "/com/bosch/pmapp/device1")
 *                 ("ggggiijjkkll", "/com/bosch/pmapp/device2")
 *               ]
 *
 *         Attention: This attribute will be deprecated once ASF supports the dynamic object path for server side.
 */
class DeviceObjectPathListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceObjectPathListRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceObjectPathListRegister (const DeviceObjectPathListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceObjectPathListRegister();

    /**
     * Assignment operator
     */
    inline DeviceObjectPathListRegister& operator = (const DeviceObjectPathListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceObjectPathListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceObjectPathListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceObjectPathListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceObjectPathListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceObjectPathListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Indicate different phone call manager related events.
 */
class NotificationEventSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NotificationEventSignal ();

    /**
     * Copy constructor
     */
    inline  NotificationEventSignal (const NotificationEventSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NotificationEventSignal (const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& EventDetails_);

    /**
     * Destructor
     */
    inline virtual  ~NotificationEventSignal();

    /**
     * Assignment operator
     */
    inline NotificationEventSignal& operator = (const NotificationEventSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NotificationEventSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NotificationEventSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NotificationEventSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NotificationEventSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EventDetails"

    static const int kEventDetails = 0;

    /**
     * Clears the field "EventDetails".
     *
     * The field will be set to its default value. The hasEventDetails()
     * method will return false.
     */
    inline void clearEventDetails();

    /**
     * Checks whether the field "EventDetails" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEventDetails()). Otherwise it will return false.
     */
    inline bool hasEventDetails () const;

    /**
     * Returns the value of the member "EventDetails".
     *
     * Refer Type Definition and Comment of the parameter "EventDetails" for more information.
     *                 Example:
     *                 {
     *                   {"EventName" : "OutgoingCallFailed"}
     *                   {"Reason" : "Operation not allowed"}
     *                   {"DeviceAddress" : "aabbccddeeff"}
     *                 }
     *
     * @return The value of the field "EventDetails"
     */
    inline const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& getEventDetails () const;

    /**
     * Retrieves the value of the field "EventDetails" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EventDetails".
     */
    inline ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& getEventDetailsMutable ();

    /**
     * Sets the value of the member "EventDetails".
     *
     * Refer Type Definition and Comment of the parameter "EventDetails" for more information.
     *                 Example:
     *                 {
     *                   {"EventName" : "OutgoingCallFailed"}
     *                   {"Reason" : "Operation not allowed"}
     *                   {"DeviceAddress" : "aabbccddeeff"}
     *                 }
     *
     * @param EventDetails The value which will be set
     */
    inline void setEventDetails (const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& EventDetails_);

    static const NotificationEventSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::string >& getStringToStringMap_DefaultInstance ();

    inline void set_has_EventDetails ();

    inline void clear_has_EventDetails ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType _EventDetails;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _HfpManagerProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _HfpManagerProperties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& HfpManagerProperties_)  :
    _HfpManagerProperties (HfpManagerProperties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHfpManagerProperties()) {
            setHfpManagerProperties(rhs.getHfpManagerProperties());
        } else {
            clearHfpManagerProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasHfpManagerProperties() && !rhs.hasHfpManagerProperties()) || getHfpManagerProperties() == rhs.getHfpManagerProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasHfpManagerProperties() || rhs.hasHfpManagerProperties()) {
        if (getHfpManagerProperties() < rhs.getHfpManagerProperties()) return true;
        if (getHfpManagerProperties() > rhs.getHfpManagerProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearHfpManagerProperties();
}

inline void GetPropertiesResponse::clearHfpManagerProperties() {
    if (hasHfpManagerProperties()) {
         clear_has_HfpManagerProperties();
        _HfpManagerProperties.clear();
     }
}

inline bool GetPropertiesResponse::hasHfpManagerProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& GetPropertiesResponse::getHfpManagerProperties () const {
    return _HfpManagerProperties;
}

inline ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& GetPropertiesResponse::getHfpManagerPropertiesMutable () {
    set_has_HfpManagerProperties();
    return _HfpManagerProperties;
}

inline void GetPropertiesResponse::setHfpManagerProperties (const ::std::map< ::std::string, ::com::bosch::pmapp::PMAppTypeCollections::HfpManagerVariant >& HfpManagerProperties_) {
    set_has_HfpManagerProperties();
    this->_HfpManagerProperties = HfpManagerProperties_;
}

inline void GetPropertiesResponse::set_has_HfpManagerProperties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_HfpManagerProperties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StartStopRingtoneRequest::StartStopRingtoneRequest ()  :
    _StartStop (false),
    _RingtoneID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StartStopRingtoneRequest::StartStopRingtoneRequest (const StartStopRingtoneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _StartStop (false),
    _RingtoneID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StartStopRingtoneRequest::StartStopRingtoneRequest (bool StartStop_, uint8 RingtoneID_)  :
    _StartStop (StartStop_),
    _RingtoneID (RingtoneID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StartStopRingtoneRequest::~StartStopRingtoneRequest() {
}

inline StartStopRingtoneRequest& StartStopRingtoneRequest::operator = (const StartStopRingtoneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStartStop()) {
            setStartStop(rhs.getStartStop());
        } else {
            clearStartStop();
        }
        if (rhs.hasRingtoneID()) {
            setRingtoneID(rhs.getRingtoneID());
        } else {
            clearRingtoneID();
        }
    }
    return *this;
}

inline bool StartStopRingtoneRequest::operator == (const StartStopRingtoneRequest& rhs) const {
    return (((!hasStartStop() && !rhs.hasStartStop()) || getStartStop() == rhs.getStartStop()) &&
        ((!hasRingtoneID() && !rhs.hasRingtoneID()) || getRingtoneID() == rhs.getRingtoneID()));
}

inline bool StartStopRingtoneRequest::operator != (const StartStopRingtoneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool StartStopRingtoneRequest::operator < (const StartStopRingtoneRequest& rhs) const {
    if (hasStartStop() || rhs.hasStartStop()) {
        if (getStartStop() < rhs.getStartStop()) return true;
        if (getStartStop() > rhs.getStartStop()) return false;
    }
    if (hasRingtoneID() || rhs.hasRingtoneID()) {
        if (getRingtoneID() < rhs.getRingtoneID()) return true;
        if (getRingtoneID() > rhs.getRingtoneID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StartStopRingtoneRequest::clone() {
    return new StartStopRingtoneRequest(*this);
}

inline bool StartStopRingtoneRequest::operator > (const StartStopRingtoneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StartStopRingtoneRequest::clear() {
    clearStartStop();
    clearRingtoneID();
}

inline void StartStopRingtoneRequest::clearStartStop() {
    if (hasStartStop()) {
         clear_has_StartStop();
        _StartStop = false;
     }
}

inline bool StartStopRingtoneRequest::hasStartStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool StartStopRingtoneRequest::getStartStop () const {
    return _StartStop;
}

inline void StartStopRingtoneRequest::setStartStop (bool StartStop_) {
    set_has_StartStop();
    this->_StartStop = StartStop_;
}

inline void StartStopRingtoneRequest::clearRingtoneID() {
    if (hasRingtoneID()) {
         clear_has_RingtoneID();
        _RingtoneID = 0u;
     }
}

inline bool StartStopRingtoneRequest::hasRingtoneID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 StartStopRingtoneRequest::getRingtoneID () const {
    return _RingtoneID;
}

inline void StartStopRingtoneRequest::setRingtoneID (uint8 RingtoneID_) {
    set_has_RingtoneID();
    this->_RingtoneID = RingtoneID_;
}

inline void StartStopRingtoneRequest::set_has_StartStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void StartStopRingtoneRequest::clear_has_StartStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void StartStopRingtoneRequest::set_has_RingtoneID () {
    _has_bits_[0] |= 1u << 1;
}

inline void StartStopRingtoneRequest::clear_has_RingtoneID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetRingtoneRequest::SetRingtoneRequest ()  :
    _DeviceAddress (),
    _RingtoneID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetRingtoneRequest::SetRingtoneRequest (const SetRingtoneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceAddress (),
    _RingtoneID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetRingtoneRequest::SetRingtoneRequest (const ::std::string& DeviceAddress_, uint8 RingtoneID_)  :
    _DeviceAddress (DeviceAddress_),
    _RingtoneID (RingtoneID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetRingtoneRequest::~SetRingtoneRequest() {
}

inline SetRingtoneRequest& SetRingtoneRequest::operator = (const SetRingtoneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
        if (rhs.hasRingtoneID()) {
            setRingtoneID(rhs.getRingtoneID());
        } else {
            clearRingtoneID();
        }
    }
    return *this;
}

inline bool SetRingtoneRequest::operator == (const SetRingtoneRequest& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()) &&
        ((!hasRingtoneID() && !rhs.hasRingtoneID()) || getRingtoneID() == rhs.getRingtoneID()));
}

inline bool SetRingtoneRequest::operator != (const SetRingtoneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetRingtoneRequest::operator < (const SetRingtoneRequest& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    if (hasRingtoneID() || rhs.hasRingtoneID()) {
        if (getRingtoneID() < rhs.getRingtoneID()) return true;
        if (getRingtoneID() > rhs.getRingtoneID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetRingtoneRequest::clone() {
    return new SetRingtoneRequest(*this);
}

inline bool SetRingtoneRequest::operator > (const SetRingtoneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetRingtoneRequest::clear() {
    clearDeviceAddress();
    clearRingtoneID();
}

inline void SetRingtoneRequest::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool SetRingtoneRequest::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetRingtoneRequest::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& SetRingtoneRequest::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void SetRingtoneRequest::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void SetRingtoneRequest::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void SetRingtoneRequest::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void SetRingtoneRequest::clearRingtoneID() {
    if (hasRingtoneID()) {
         clear_has_RingtoneID();
        _RingtoneID = 0u;
     }
}

inline bool SetRingtoneRequest::hasRingtoneID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SetRingtoneRequest::getRingtoneID () const {
    return _RingtoneID;
}

inline void SetRingtoneRequest::setRingtoneID (uint8 RingtoneID_) {
    set_has_RingtoneID();
    this->_RingtoneID = RingtoneID_;
}

inline void SetRingtoneRequest::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetRingtoneRequest::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetRingtoneRequest::set_has_RingtoneID () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetRingtoneRequest::clear_has_RingtoneID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SuppressRingtoneOnOffRequest::SuppressRingtoneOnOffRequest ()  :
    _onOffSetting ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SuppressRingtoneOnOffRequest::SuppressRingtoneOnOffRequest (const SuppressRingtoneOnOffRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _onOffSetting ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SuppressRingtoneOnOffRequest::SuppressRingtoneOnOffRequest (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_)  :
    _onOffSetting (onOffSetting_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SuppressRingtoneOnOffRequest::~SuppressRingtoneOnOffRequest() {
}

inline SuppressRingtoneOnOffRequest& SuppressRingtoneOnOffRequest::operator = (const SuppressRingtoneOnOffRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOnOffSetting()) {
            setOnOffSetting(rhs.getOnOffSetting());
        } else {
            clearOnOffSetting();
        }
    }
    return *this;
}

inline bool SuppressRingtoneOnOffRequest::operator == (const SuppressRingtoneOnOffRequest& rhs) const {
    return (((!hasOnOffSetting() && !rhs.hasOnOffSetting()) || getOnOffSetting() == rhs.getOnOffSetting()));
}

inline bool SuppressRingtoneOnOffRequest::operator != (const SuppressRingtoneOnOffRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SuppressRingtoneOnOffRequest::operator < (const SuppressRingtoneOnOffRequest& rhs) const {
    if (hasOnOffSetting() || rhs.hasOnOffSetting()) {
        if (getOnOffSetting() < rhs.getOnOffSetting()) return true;
        if (getOnOffSetting() > rhs.getOnOffSetting()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SuppressRingtoneOnOffRequest::clone() {
    return new SuppressRingtoneOnOffRequest(*this);
}

inline bool SuppressRingtoneOnOffRequest::operator > (const SuppressRingtoneOnOffRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SuppressRingtoneOnOffRequest::clear() {
    clearOnOffSetting();
}

inline void SuppressRingtoneOnOffRequest::clearOnOffSetting() {
    if (hasOnOffSetting()) {
         clear_has_onOffSetting();
        _onOffSetting.clear();
     }
}

inline bool SuppressRingtoneOnOffRequest::hasOnOffSetting () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& SuppressRingtoneOnOffRequest::getOnOffSetting () const {
    return _onOffSetting;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& SuppressRingtoneOnOffRequest::getOnOffSettingMutable () {
    set_has_onOffSetting();
    return _onOffSetting;
}

inline void SuppressRingtoneOnOffRequest::setOnOffSetting (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_) {
    set_has_onOffSetting();
    this->_onOffSetting = onOffSetting_;
}

inline void SuppressRingtoneOnOffRequest::set_has_onOffSetting () {
    _has_bits_[0] |= 1u << 0;
}

inline void SuppressRingtoneOnOffRequest::clear_has_onOffSetting () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AutoWaitingModeOnOffRequest::AutoWaitingModeOnOffRequest ()  :
    _onOffSetting ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AutoWaitingModeOnOffRequest::AutoWaitingModeOnOffRequest (const AutoWaitingModeOnOffRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _onOffSetting ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AutoWaitingModeOnOffRequest::AutoWaitingModeOnOffRequest (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_)  :
    _onOffSetting (onOffSetting_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AutoWaitingModeOnOffRequest::~AutoWaitingModeOnOffRequest() {
}

inline AutoWaitingModeOnOffRequest& AutoWaitingModeOnOffRequest::operator = (const AutoWaitingModeOnOffRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOnOffSetting()) {
            setOnOffSetting(rhs.getOnOffSetting());
        } else {
            clearOnOffSetting();
        }
    }
    return *this;
}

inline bool AutoWaitingModeOnOffRequest::operator == (const AutoWaitingModeOnOffRequest& rhs) const {
    return (((!hasOnOffSetting() && !rhs.hasOnOffSetting()) || getOnOffSetting() == rhs.getOnOffSetting()));
}

inline bool AutoWaitingModeOnOffRequest::operator != (const AutoWaitingModeOnOffRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AutoWaitingModeOnOffRequest::operator < (const AutoWaitingModeOnOffRequest& rhs) const {
    if (hasOnOffSetting() || rhs.hasOnOffSetting()) {
        if (getOnOffSetting() < rhs.getOnOffSetting()) return true;
        if (getOnOffSetting() > rhs.getOnOffSetting()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AutoWaitingModeOnOffRequest::clone() {
    return new AutoWaitingModeOnOffRequest(*this);
}

inline bool AutoWaitingModeOnOffRequest::operator > (const AutoWaitingModeOnOffRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AutoWaitingModeOnOffRequest::clear() {
    clearOnOffSetting();
}

inline void AutoWaitingModeOnOffRequest::clearOnOffSetting() {
    if (hasOnOffSetting()) {
         clear_has_onOffSetting();
        _onOffSetting.clear();
     }
}

inline bool AutoWaitingModeOnOffRequest::hasOnOffSetting () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& AutoWaitingModeOnOffRequest::getOnOffSetting () const {
    return _onOffSetting;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& AutoWaitingModeOnOffRequest::getOnOffSettingMutable () {
    set_has_onOffSetting();
    return _onOffSetting;
}

inline void AutoWaitingModeOnOffRequest::setOnOffSetting (const ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting& onOffSetting_) {
    set_has_onOffSetting();
    this->_onOffSetting = onOffSetting_;
}

inline void AutoWaitingModeOnOffRequest::set_has_onOffSetting () {
    _has_bits_[0] |= 1u << 0;
}

inline void AutoWaitingModeOnOffRequest::clear_has_onOffSetting () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetActivePhoneRequest::SetActivePhoneRequest ()  :
    _DeviceAddressList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetActivePhoneRequest::SetActivePhoneRequest (const SetActivePhoneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceAddressList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetActivePhoneRequest::SetActivePhoneRequest (const ::std::vector< ::std::string >& DeviceAddressList_)  :
    _DeviceAddressList (DeviceAddressList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetActivePhoneRequest::~SetActivePhoneRequest() {
}

inline SetActivePhoneRequest& SetActivePhoneRequest::operator = (const SetActivePhoneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddressList()) {
            setDeviceAddressList(rhs.getDeviceAddressList());
        } else {
            clearDeviceAddressList();
        }
    }
    return *this;
}

inline bool SetActivePhoneRequest::operator == (const SetActivePhoneRequest& rhs) const {
    return (((!hasDeviceAddressList() && !rhs.hasDeviceAddressList()) || getDeviceAddressList() == rhs.getDeviceAddressList()));
}

inline bool SetActivePhoneRequest::operator != (const SetActivePhoneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetActivePhoneRequest::operator < (const SetActivePhoneRequest& rhs) const {
    if (hasDeviceAddressList() || rhs.hasDeviceAddressList()) {
        if (getDeviceAddressList() < rhs.getDeviceAddressList()) return true;
        if (getDeviceAddressList() > rhs.getDeviceAddressList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetActivePhoneRequest::clone() {
    return new SetActivePhoneRequest(*this);
}

inline bool SetActivePhoneRequest::operator > (const SetActivePhoneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetActivePhoneRequest::clear() {
    clearDeviceAddressList();
}

inline void SetActivePhoneRequest::clearDeviceAddressList() {
    if (hasDeviceAddressList()) {
         clear_has_DeviceAddressList();
        _DeviceAddressList.clear();
     }
}

inline bool SetActivePhoneRequest::hasDeviceAddressList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& SetActivePhoneRequest::getDeviceAddressList () const {
    return _DeviceAddressList;
}

inline ::std::vector< ::std::string >& SetActivePhoneRequest::getDeviceAddressListMutable () {
    set_has_DeviceAddressList();
    return _DeviceAddressList;
}

inline void SetActivePhoneRequest::setDeviceAddressList (const ::std::vector< ::std::string >& DeviceAddressList_) {
    set_has_DeviceAddressList();
    this->_DeviceAddressList = DeviceAddressList_;
}

inline void SetActivePhoneRequest::set_has_DeviceAddressList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetActivePhoneRequest::clear_has_DeviceAddressList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RestoreFactorySettingRequest::RestoreFactorySettingRequest ()  :
    _DeviceAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RestoreFactorySettingRequest::RestoreFactorySettingRequest (const RestoreFactorySettingRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceAddress ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RestoreFactorySettingRequest::RestoreFactorySettingRequest (const ::std::string& DeviceAddress_)  :
    _DeviceAddress (DeviceAddress_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RestoreFactorySettingRequest::~RestoreFactorySettingRequest() {
}

inline RestoreFactorySettingRequest& RestoreFactorySettingRequest::operator = (const RestoreFactorySettingRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceAddress()) {
            setDeviceAddress(rhs.getDeviceAddress());
        } else {
            clearDeviceAddress();
        }
    }
    return *this;
}

inline bool RestoreFactorySettingRequest::operator == (const RestoreFactorySettingRequest& rhs) const {
    return (((!hasDeviceAddress() && !rhs.hasDeviceAddress()) || getDeviceAddress() == rhs.getDeviceAddress()));
}

inline bool RestoreFactorySettingRequest::operator != (const RestoreFactorySettingRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RestoreFactorySettingRequest::operator < (const RestoreFactorySettingRequest& rhs) const {
    if (hasDeviceAddress() || rhs.hasDeviceAddress()) {
        if (getDeviceAddress() < rhs.getDeviceAddress()) return true;
        if (getDeviceAddress() > rhs.getDeviceAddress()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RestoreFactorySettingRequest::clone() {
    return new RestoreFactorySettingRequest(*this);
}

inline bool RestoreFactorySettingRequest::operator > (const RestoreFactorySettingRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RestoreFactorySettingRequest::clear() {
    clearDeviceAddress();
}

inline void RestoreFactorySettingRequest::clearDeviceAddress() {
    if (hasDeviceAddress()) {
         clear_has_DeviceAddress();
        _DeviceAddress.clear();
     }
}

inline bool RestoreFactorySettingRequest::hasDeviceAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RestoreFactorySettingRequest::getDeviceAddress () const {
    return _DeviceAddress;
}

inline ::std::string& RestoreFactorySettingRequest::getDeviceAddressMutable () {
    set_has_DeviceAddress();
    return _DeviceAddress;
}

inline void RestoreFactorySettingRequest::setDeviceAddress (const ::std::string& DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress = DeviceAddress_;
}

inline void RestoreFactorySettingRequest::setDeviceAddress (const char* DeviceAddress_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceAddress_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(DeviceAddress_);
}

inline void RestoreFactorySettingRequest::setDeviceAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceAddress();
    this->_DeviceAddress.assign(value, size);
}

inline void RestoreFactorySettingRequest::set_has_DeviceAddress () {
    _has_bits_[0] |= 1u << 0;
}

inline void RestoreFactorySettingRequest::clear_has_DeviceAddress () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SystemWideRingtonesListUpdate::SystemWideRingtonesListUpdate ()  :
    _SystemWideRingtonesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemWideRingtonesListUpdate::SystemWideRingtonesListUpdate (const SystemWideRingtonesListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SystemWideRingtonesList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemWideRingtonesListUpdate::SystemWideRingtonesListUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesList_)  :
    _SystemWideRingtonesList (SystemWideRingtonesList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemWideRingtonesListUpdate::~SystemWideRingtonesListUpdate() {
}

inline SystemWideRingtonesListUpdate& SystemWideRingtonesListUpdate::operator = (const SystemWideRingtonesListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSystemWideRingtonesList()) {
            setSystemWideRingtonesList(rhs.getSystemWideRingtonesList());
        } else {
            clearSystemWideRingtonesList();
        }
    }
    return *this;
}

inline bool SystemWideRingtonesListUpdate::operator == (const SystemWideRingtonesListUpdate& rhs) const {
    return (((!hasSystemWideRingtonesList() && !rhs.hasSystemWideRingtonesList()) || getSystemWideRingtonesList() == rhs.getSystemWideRingtonesList()));
}

inline bool SystemWideRingtonesListUpdate::operator != (const SystemWideRingtonesListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemWideRingtonesListUpdate::operator < (const SystemWideRingtonesListUpdate& rhs) const {
    if (hasSystemWideRingtonesList() || rhs.hasSystemWideRingtonesList()) {
        if (getSystemWideRingtonesList() < rhs.getSystemWideRingtonesList()) return true;
        if (getSystemWideRingtonesList() > rhs.getSystemWideRingtonesList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemWideRingtonesListUpdate::clone() {
    return new SystemWideRingtonesListUpdate(*this);
}

inline bool SystemWideRingtonesListUpdate::operator > (const SystemWideRingtonesListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemWideRingtonesListUpdate::clear() {
    clearSystemWideRingtonesList();
}

inline void SystemWideRingtonesListUpdate::clearSystemWideRingtonesList() {
    if (hasSystemWideRingtonesList()) {
         clear_has_SystemWideRingtonesList();
        _SystemWideRingtonesList.clear();
     }
}

inline bool SystemWideRingtonesListUpdate::hasSystemWideRingtonesList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesListUpdate::getSystemWideRingtonesList () const {
    return _SystemWideRingtonesList;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesListUpdate::getSystemWideRingtonesListMutable () {
    set_has_SystemWideRingtonesList();
    return _SystemWideRingtonesList;
}

inline void SystemWideRingtonesListUpdate::setSystemWideRingtonesList (const ::com::bosch::pmapp::PMAppTypeCollections::SystemWideRingtonesListType& SystemWideRingtonesList_) {
    set_has_SystemWideRingtonesList();
    this->_SystemWideRingtonesList = SystemWideRingtonesList_;
}

inline void SystemWideRingtonesListUpdate::set_has_SystemWideRingtonesList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemWideRingtonesListUpdate::clear_has_SystemWideRingtonesList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SystemWideRingtonesListRegister::SystemWideRingtonesListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemWideRingtonesListRegister::SystemWideRingtonesListRegister (const SystemWideRingtonesListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemWideRingtonesListRegister::~SystemWideRingtonesListRegister() {
}

inline SystemWideRingtonesListRegister& SystemWideRingtonesListRegister::operator = (const SystemWideRingtonesListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SystemWideRingtonesListRegister::operator == (const SystemWideRingtonesListRegister& ) const {
    return true;
}

inline bool SystemWideRingtonesListRegister::operator != (const SystemWideRingtonesListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemWideRingtonesListRegister::operator < (const SystemWideRingtonesListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SystemWideRingtonesListRegister::clone() {
    return new SystemWideRingtonesListRegister(*this);
}

inline bool SystemWideRingtonesListRegister::operator > (const SystemWideRingtonesListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemWideRingtonesListRegister::clear() {
}

inline  DeviceRingtoneListUpdate::DeviceRingtoneListUpdate ()  :
    _DeviceRingtoneList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceRingtoneListUpdate::DeviceRingtoneListUpdate (const DeviceRingtoneListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceRingtoneList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceRingtoneListUpdate::DeviceRingtoneListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneList_)  :
    _DeviceRingtoneList (DeviceRingtoneList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceRingtoneListUpdate::~DeviceRingtoneListUpdate() {
}

inline DeviceRingtoneListUpdate& DeviceRingtoneListUpdate::operator = (const DeviceRingtoneListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceRingtoneList()) {
            setDeviceRingtoneList(rhs.getDeviceRingtoneList());
        } else {
            clearDeviceRingtoneList();
        }
    }
    return *this;
}

inline bool DeviceRingtoneListUpdate::operator == (const DeviceRingtoneListUpdate& rhs) const {
    return (((!hasDeviceRingtoneList() && !rhs.hasDeviceRingtoneList()) || getDeviceRingtoneList() == rhs.getDeviceRingtoneList()));
}

inline bool DeviceRingtoneListUpdate::operator != (const DeviceRingtoneListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceRingtoneListUpdate::operator < (const DeviceRingtoneListUpdate& rhs) const {
    if (hasDeviceRingtoneList() || rhs.hasDeviceRingtoneList()) {
        if (getDeviceRingtoneList() < rhs.getDeviceRingtoneList()) return true;
        if (getDeviceRingtoneList() > rhs.getDeviceRingtoneList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceRingtoneListUpdate::clone() {
    return new DeviceRingtoneListUpdate(*this);
}

inline bool DeviceRingtoneListUpdate::operator > (const DeviceRingtoneListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceRingtoneListUpdate::clear() {
    clearDeviceRingtoneList();
}

inline void DeviceRingtoneListUpdate::clearDeviceRingtoneList() {
    if (hasDeviceRingtoneList()) {
         clear_has_DeviceRingtoneList();
        _DeviceRingtoneList.clear();
     }
}

inline bool DeviceRingtoneListUpdate::hasDeviceRingtoneList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneListUpdate::getDeviceRingtoneList () const {
    return _DeviceRingtoneList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneListUpdate::getDeviceRingtoneListMutable () {
    set_has_DeviceRingtoneList();
    return _DeviceRingtoneList;
}

inline void DeviceRingtoneListUpdate::setDeviceRingtoneList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceRingtoneInfo >& DeviceRingtoneList_) {
    set_has_DeviceRingtoneList();
    this->_DeviceRingtoneList = DeviceRingtoneList_;
}

inline void DeviceRingtoneListUpdate::set_has_DeviceRingtoneList () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceRingtoneListUpdate::clear_has_DeviceRingtoneList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceRingtoneListRegister::DeviceRingtoneListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceRingtoneListRegister::DeviceRingtoneListRegister (const DeviceRingtoneListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceRingtoneListRegister::~DeviceRingtoneListRegister() {
}

inline DeviceRingtoneListRegister& DeviceRingtoneListRegister::operator = (const DeviceRingtoneListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeviceRingtoneListRegister::operator == (const DeviceRingtoneListRegister& ) const {
    return true;
}

inline bool DeviceRingtoneListRegister::operator != (const DeviceRingtoneListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceRingtoneListRegister::operator < (const DeviceRingtoneListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeviceRingtoneListRegister::clone() {
    return new DeviceRingtoneListRegister(*this);
}

inline bool DeviceRingtoneListRegister::operator > (const DeviceRingtoneListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceRingtoneListRegister::clear() {
}

inline  SuppressRingtoneOnOffListUpdate::SuppressRingtoneOnOffListUpdate ()  :
    _SuppressRingtoneOnOffList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SuppressRingtoneOnOffListUpdate::SuppressRingtoneOnOffListUpdate (const SuppressRingtoneOnOffListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _SuppressRingtoneOnOffList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SuppressRingtoneOnOffListUpdate::SuppressRingtoneOnOffListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffList_)  :
    _SuppressRingtoneOnOffList (SuppressRingtoneOnOffList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SuppressRingtoneOnOffListUpdate::~SuppressRingtoneOnOffListUpdate() {
}

inline SuppressRingtoneOnOffListUpdate& SuppressRingtoneOnOffListUpdate::operator = (const SuppressRingtoneOnOffListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSuppressRingtoneOnOffList()) {
            setSuppressRingtoneOnOffList(rhs.getSuppressRingtoneOnOffList());
        } else {
            clearSuppressRingtoneOnOffList();
        }
    }
    return *this;
}

inline bool SuppressRingtoneOnOffListUpdate::operator == (const SuppressRingtoneOnOffListUpdate& rhs) const {
    return (((!hasSuppressRingtoneOnOffList() && !rhs.hasSuppressRingtoneOnOffList()) || getSuppressRingtoneOnOffList() == rhs.getSuppressRingtoneOnOffList()));
}

inline bool SuppressRingtoneOnOffListUpdate::operator != (const SuppressRingtoneOnOffListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SuppressRingtoneOnOffListUpdate::operator < (const SuppressRingtoneOnOffListUpdate& rhs) const {
    if (hasSuppressRingtoneOnOffList() || rhs.hasSuppressRingtoneOnOffList()) {
        if (getSuppressRingtoneOnOffList() < rhs.getSuppressRingtoneOnOffList()) return true;
        if (getSuppressRingtoneOnOffList() > rhs.getSuppressRingtoneOnOffList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SuppressRingtoneOnOffListUpdate::clone() {
    return new SuppressRingtoneOnOffListUpdate(*this);
}

inline bool SuppressRingtoneOnOffListUpdate::operator > (const SuppressRingtoneOnOffListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SuppressRingtoneOnOffListUpdate::clear() {
    clearSuppressRingtoneOnOffList();
}

inline void SuppressRingtoneOnOffListUpdate::clearSuppressRingtoneOnOffList() {
    if (hasSuppressRingtoneOnOffList()) {
         clear_has_SuppressRingtoneOnOffList();
        _SuppressRingtoneOnOffList.clear();
     }
}

inline bool SuppressRingtoneOnOffListUpdate::hasSuppressRingtoneOnOffList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffListUpdate::getSuppressRingtoneOnOffList () const {
    return _SuppressRingtoneOnOffList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffListUpdate::getSuppressRingtoneOnOffListMutable () {
    set_has_SuppressRingtoneOnOffList();
    return _SuppressRingtoneOnOffList;
}

inline void SuppressRingtoneOnOffListUpdate::setSuppressRingtoneOnOffList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& SuppressRingtoneOnOffList_) {
    set_has_SuppressRingtoneOnOffList();
    this->_SuppressRingtoneOnOffList = SuppressRingtoneOnOffList_;
}

inline void SuppressRingtoneOnOffListUpdate::set_has_SuppressRingtoneOnOffList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SuppressRingtoneOnOffListUpdate::clear_has_SuppressRingtoneOnOffList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SuppressRingtoneOnOffListRegister::SuppressRingtoneOnOffListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SuppressRingtoneOnOffListRegister::SuppressRingtoneOnOffListRegister (const SuppressRingtoneOnOffListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SuppressRingtoneOnOffListRegister::~SuppressRingtoneOnOffListRegister() {
}

inline SuppressRingtoneOnOffListRegister& SuppressRingtoneOnOffListRegister::operator = (const SuppressRingtoneOnOffListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SuppressRingtoneOnOffListRegister::operator == (const SuppressRingtoneOnOffListRegister& ) const {
    return true;
}

inline bool SuppressRingtoneOnOffListRegister::operator != (const SuppressRingtoneOnOffListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SuppressRingtoneOnOffListRegister::operator < (const SuppressRingtoneOnOffListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SuppressRingtoneOnOffListRegister::clone() {
    return new SuppressRingtoneOnOffListRegister(*this);
}

inline bool SuppressRingtoneOnOffListRegister::operator > (const SuppressRingtoneOnOffListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SuppressRingtoneOnOffListRegister::clear() {
}

inline  AutoWaitingModeOnOffListUpdate::AutoWaitingModeOnOffListUpdate ()  :
    _AutoWaitingModeOnOffList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AutoWaitingModeOnOffListUpdate::AutoWaitingModeOnOffListUpdate (const AutoWaitingModeOnOffListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _AutoWaitingModeOnOffList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AutoWaitingModeOnOffListUpdate::AutoWaitingModeOnOffListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffList_)  :
    _AutoWaitingModeOnOffList (AutoWaitingModeOnOffList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AutoWaitingModeOnOffListUpdate::~AutoWaitingModeOnOffListUpdate() {
}

inline AutoWaitingModeOnOffListUpdate& AutoWaitingModeOnOffListUpdate::operator = (const AutoWaitingModeOnOffListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAutoWaitingModeOnOffList()) {
            setAutoWaitingModeOnOffList(rhs.getAutoWaitingModeOnOffList());
        } else {
            clearAutoWaitingModeOnOffList();
        }
    }
    return *this;
}

inline bool AutoWaitingModeOnOffListUpdate::operator == (const AutoWaitingModeOnOffListUpdate& rhs) const {
    return (((!hasAutoWaitingModeOnOffList() && !rhs.hasAutoWaitingModeOnOffList()) || getAutoWaitingModeOnOffList() == rhs.getAutoWaitingModeOnOffList()));
}

inline bool AutoWaitingModeOnOffListUpdate::operator != (const AutoWaitingModeOnOffListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool AutoWaitingModeOnOffListUpdate::operator < (const AutoWaitingModeOnOffListUpdate& rhs) const {
    if (hasAutoWaitingModeOnOffList() || rhs.hasAutoWaitingModeOnOffList()) {
        if (getAutoWaitingModeOnOffList() < rhs.getAutoWaitingModeOnOffList()) return true;
        if (getAutoWaitingModeOnOffList() > rhs.getAutoWaitingModeOnOffList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AutoWaitingModeOnOffListUpdate::clone() {
    return new AutoWaitingModeOnOffListUpdate(*this);
}

inline bool AutoWaitingModeOnOffListUpdate::operator > (const AutoWaitingModeOnOffListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AutoWaitingModeOnOffListUpdate::clear() {
    clearAutoWaitingModeOnOffList();
}

inline void AutoWaitingModeOnOffListUpdate::clearAutoWaitingModeOnOffList() {
    if (hasAutoWaitingModeOnOffList()) {
         clear_has_AutoWaitingModeOnOffList();
        _AutoWaitingModeOnOffList.clear();
     }
}

inline bool AutoWaitingModeOnOffListUpdate::hasAutoWaitingModeOnOffList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffListUpdate::getAutoWaitingModeOnOffList () const {
    return _AutoWaitingModeOnOffList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffListUpdate::getAutoWaitingModeOnOffListMutable () {
    set_has_AutoWaitingModeOnOffList();
    return _AutoWaitingModeOnOffList;
}

inline void AutoWaitingModeOnOffListUpdate::setAutoWaitingModeOnOffList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::OnOffSetting >& AutoWaitingModeOnOffList_) {
    set_has_AutoWaitingModeOnOffList();
    this->_AutoWaitingModeOnOffList = AutoWaitingModeOnOffList_;
}

inline void AutoWaitingModeOnOffListUpdate::set_has_AutoWaitingModeOnOffList () {
    _has_bits_[0] |= 1u << 0;
}

inline void AutoWaitingModeOnOffListUpdate::clear_has_AutoWaitingModeOnOffList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AutoWaitingModeOnOffListRegister::AutoWaitingModeOnOffListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AutoWaitingModeOnOffListRegister::AutoWaitingModeOnOffListRegister (const AutoWaitingModeOnOffListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AutoWaitingModeOnOffListRegister::~AutoWaitingModeOnOffListRegister() {
}

inline AutoWaitingModeOnOffListRegister& AutoWaitingModeOnOffListRegister::operator = (const AutoWaitingModeOnOffListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool AutoWaitingModeOnOffListRegister::operator == (const AutoWaitingModeOnOffListRegister& ) const {
    return true;
}

inline bool AutoWaitingModeOnOffListRegister::operator != (const AutoWaitingModeOnOffListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool AutoWaitingModeOnOffListRegister::operator < (const AutoWaitingModeOnOffListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* AutoWaitingModeOnOffListRegister::clone() {
    return new AutoWaitingModeOnOffListRegister(*this);
}

inline bool AutoWaitingModeOnOffListRegister::operator > (const AutoWaitingModeOnOffListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AutoWaitingModeOnOffListRegister::clear() {
}

inline  WaitingModeFilePathUpdate::WaitingModeFilePathUpdate ()  :
    _WaitingModeFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WaitingModeFilePathUpdate::WaitingModeFilePathUpdate (const WaitingModeFilePathUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _WaitingModeFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WaitingModeFilePathUpdate::WaitingModeFilePathUpdate (const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePath_)  :
    _WaitingModeFilePath (WaitingModeFilePath_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WaitingModeFilePathUpdate::~WaitingModeFilePathUpdate() {
}

inline WaitingModeFilePathUpdate& WaitingModeFilePathUpdate::operator = (const WaitingModeFilePathUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasWaitingModeFilePath()) {
            setWaitingModeFilePath(rhs.getWaitingModeFilePath());
        } else {
            clearWaitingModeFilePath();
        }
    }
    return *this;
}

inline bool WaitingModeFilePathUpdate::operator == (const WaitingModeFilePathUpdate& rhs) const {
    return (((!hasWaitingModeFilePath() && !rhs.hasWaitingModeFilePath()) || getWaitingModeFilePath() == rhs.getWaitingModeFilePath()));
}

inline bool WaitingModeFilePathUpdate::operator != (const WaitingModeFilePathUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool WaitingModeFilePathUpdate::operator < (const WaitingModeFilePathUpdate& rhs) const {
    if (hasWaitingModeFilePath() || rhs.hasWaitingModeFilePath()) {
        if (getWaitingModeFilePath() < rhs.getWaitingModeFilePath()) return true;
        if (getWaitingModeFilePath() > rhs.getWaitingModeFilePath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WaitingModeFilePathUpdate::clone() {
    return new WaitingModeFilePathUpdate(*this);
}

inline bool WaitingModeFilePathUpdate::operator > (const WaitingModeFilePathUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WaitingModeFilePathUpdate::clear() {
    clearWaitingModeFilePath();
}

inline void WaitingModeFilePathUpdate::clearWaitingModeFilePath() {
    if (hasWaitingModeFilePath()) {
         clear_has_WaitingModeFilePath();
        _WaitingModeFilePath.clear();
     }
}

inline bool WaitingModeFilePathUpdate::hasWaitingModeFilePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePathUpdate::getWaitingModeFilePath () const {
    return _WaitingModeFilePath;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePathUpdate::getWaitingModeFilePathMutable () {
    set_has_WaitingModeFilePath();
    return _WaitingModeFilePath;
}

inline void WaitingModeFilePathUpdate::setWaitingModeFilePath (const ::com::bosch::pmapp::PMAppTypeCollections::WaitingModeFilePathType& WaitingModeFilePath_) {
    set_has_WaitingModeFilePath();
    this->_WaitingModeFilePath = WaitingModeFilePath_;
}

inline void WaitingModeFilePathUpdate::set_has_WaitingModeFilePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void WaitingModeFilePathUpdate::clear_has_WaitingModeFilePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WaitingModeFilePathRegister::WaitingModeFilePathRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WaitingModeFilePathRegister::WaitingModeFilePathRegister (const WaitingModeFilePathRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WaitingModeFilePathRegister::~WaitingModeFilePathRegister() {
}

inline WaitingModeFilePathRegister& WaitingModeFilePathRegister::operator = (const WaitingModeFilePathRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool WaitingModeFilePathRegister::operator == (const WaitingModeFilePathRegister& ) const {
    return true;
}

inline bool WaitingModeFilePathRegister::operator != (const WaitingModeFilePathRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool WaitingModeFilePathRegister::operator < (const WaitingModeFilePathRegister& ) const {
    return false;
}

inline ::asf::core::Payload* WaitingModeFilePathRegister::clone() {
    return new WaitingModeFilePathRegister(*this);
}

inline bool WaitingModeFilePathRegister::operator > (const WaitingModeFilePathRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WaitingModeFilePathRegister::clear() {
}

inline  PhoneCallAudioActiveUpdate::PhoneCallAudioActiveUpdate ()  :
    _PhoneCallAudioActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneCallAudioActiveUpdate::PhoneCallAudioActiveUpdate (const PhoneCallAudioActiveUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneCallAudioActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneCallAudioActiveUpdate::PhoneCallAudioActiveUpdate (bool PhoneCallAudioActive_)  :
    _PhoneCallAudioActive (PhoneCallAudioActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhoneCallAudioActiveUpdate::~PhoneCallAudioActiveUpdate() {
}

inline PhoneCallAudioActiveUpdate& PhoneCallAudioActiveUpdate::operator = (const PhoneCallAudioActiveUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneCallAudioActive()) {
            setPhoneCallAudioActive(rhs.getPhoneCallAudioActive());
        } else {
            clearPhoneCallAudioActive();
        }
    }
    return *this;
}

inline bool PhoneCallAudioActiveUpdate::operator == (const PhoneCallAudioActiveUpdate& rhs) const {
    return (((!hasPhoneCallAudioActive() && !rhs.hasPhoneCallAudioActive()) || getPhoneCallAudioActive() == rhs.getPhoneCallAudioActive()));
}

inline bool PhoneCallAudioActiveUpdate::operator != (const PhoneCallAudioActiveUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneCallAudioActiveUpdate::operator < (const PhoneCallAudioActiveUpdate& rhs) const {
    if (hasPhoneCallAudioActive() || rhs.hasPhoneCallAudioActive()) {
        if (getPhoneCallAudioActive() < rhs.getPhoneCallAudioActive()) return true;
        if (getPhoneCallAudioActive() > rhs.getPhoneCallAudioActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PhoneCallAudioActiveUpdate::clone() {
    return new PhoneCallAudioActiveUpdate(*this);
}

inline bool PhoneCallAudioActiveUpdate::operator > (const PhoneCallAudioActiveUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneCallAudioActiveUpdate::clear() {
    clearPhoneCallAudioActive();
}

inline void PhoneCallAudioActiveUpdate::clearPhoneCallAudioActive() {
    if (hasPhoneCallAudioActive()) {
         clear_has_PhoneCallAudioActive();
        _PhoneCallAudioActive = false;
     }
}

inline bool PhoneCallAudioActiveUpdate::hasPhoneCallAudioActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool PhoneCallAudioActiveUpdate::getPhoneCallAudioActive () const {
    return _PhoneCallAudioActive;
}

inline void PhoneCallAudioActiveUpdate::setPhoneCallAudioActive (bool PhoneCallAudioActive_) {
    set_has_PhoneCallAudioActive();
    this->_PhoneCallAudioActive = PhoneCallAudioActive_;
}

inline void PhoneCallAudioActiveUpdate::set_has_PhoneCallAudioActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhoneCallAudioActiveUpdate::clear_has_PhoneCallAudioActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PhoneCallAudioActiveRegister::PhoneCallAudioActiveRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneCallAudioActiveRegister::PhoneCallAudioActiveRegister (const PhoneCallAudioActiveRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneCallAudioActiveRegister::~PhoneCallAudioActiveRegister() {
}

inline PhoneCallAudioActiveRegister& PhoneCallAudioActiveRegister::operator = (const PhoneCallAudioActiveRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PhoneCallAudioActiveRegister::operator == (const PhoneCallAudioActiveRegister& ) const {
    return true;
}

inline bool PhoneCallAudioActiveRegister::operator != (const PhoneCallAudioActiveRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneCallAudioActiveRegister::operator < (const PhoneCallAudioActiveRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PhoneCallAudioActiveRegister::clone() {
    return new PhoneCallAudioActiveRegister(*this);
}

inline bool PhoneCallAudioActiveRegister::operator > (const PhoneCallAudioActiveRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneCallAudioActiveRegister::clear() {
}

inline  ActivePassiveDeviceListUpdate::ActivePassiveDeviceListUpdate ()  :
    _ActivePassiveDeviceList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivePassiveDeviceListUpdate::ActivePassiveDeviceListUpdate (const ActivePassiveDeviceListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ActivePassiveDeviceList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivePassiveDeviceListUpdate::ActivePassiveDeviceListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceList_)  :
    _ActivePassiveDeviceList (ActivePassiveDeviceList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivePassiveDeviceListUpdate::~ActivePassiveDeviceListUpdate() {
}

inline ActivePassiveDeviceListUpdate& ActivePassiveDeviceListUpdate::operator = (const ActivePassiveDeviceListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActivePassiveDeviceList()) {
            setActivePassiveDeviceList(rhs.getActivePassiveDeviceList());
        } else {
            clearActivePassiveDeviceList();
        }
    }
    return *this;
}

inline bool ActivePassiveDeviceListUpdate::operator == (const ActivePassiveDeviceListUpdate& rhs) const {
    return (((!hasActivePassiveDeviceList() && !rhs.hasActivePassiveDeviceList()) || getActivePassiveDeviceList() == rhs.getActivePassiveDeviceList()));
}

inline bool ActivePassiveDeviceListUpdate::operator != (const ActivePassiveDeviceListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivePassiveDeviceListUpdate::operator < (const ActivePassiveDeviceListUpdate& rhs) const {
    if (hasActivePassiveDeviceList() || rhs.hasActivePassiveDeviceList()) {
        if (getActivePassiveDeviceList() < rhs.getActivePassiveDeviceList()) return true;
        if (getActivePassiveDeviceList() > rhs.getActivePassiveDeviceList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivePassiveDeviceListUpdate::clone() {
    return new ActivePassiveDeviceListUpdate(*this);
}

inline bool ActivePassiveDeviceListUpdate::operator > (const ActivePassiveDeviceListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivePassiveDeviceListUpdate::clear() {
    clearActivePassiveDeviceList();
}

inline void ActivePassiveDeviceListUpdate::clearActivePassiveDeviceList() {
    if (hasActivePassiveDeviceList()) {
         clear_has_ActivePassiveDeviceList();
        _ActivePassiveDeviceList.clear();
     }
}

inline bool ActivePassiveDeviceListUpdate::hasActivePassiveDeviceList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceListUpdate::getActivePassiveDeviceList () const {
    return _ActivePassiveDeviceList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceListUpdate::getActivePassiveDeviceListMutable () {
    set_has_ActivePassiveDeviceList();
    return _ActivePassiveDeviceList;
}

inline void ActivePassiveDeviceListUpdate::setActivePassiveDeviceList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::HfpRoleInfo >& ActivePassiveDeviceList_) {
    set_has_ActivePassiveDeviceList();
    this->_ActivePassiveDeviceList = ActivePassiveDeviceList_;
}

inline void ActivePassiveDeviceListUpdate::set_has_ActivePassiveDeviceList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivePassiveDeviceListUpdate::clear_has_ActivePassiveDeviceList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActivePassiveDeviceListRegister::ActivePassiveDeviceListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivePassiveDeviceListRegister::ActivePassiveDeviceListRegister (const ActivePassiveDeviceListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivePassiveDeviceListRegister::~ActivePassiveDeviceListRegister() {
}

inline ActivePassiveDeviceListRegister& ActivePassiveDeviceListRegister::operator = (const ActivePassiveDeviceListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActivePassiveDeviceListRegister::operator == (const ActivePassiveDeviceListRegister& ) const {
    return true;
}

inline bool ActivePassiveDeviceListRegister::operator != (const ActivePassiveDeviceListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivePassiveDeviceListRegister::operator < (const ActivePassiveDeviceListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActivePassiveDeviceListRegister::clone() {
    return new ActivePassiveDeviceListRegister(*this);
}

inline bool ActivePassiveDeviceListRegister::operator > (const ActivePassiveDeviceListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivePassiveDeviceListRegister::clear() {
}

inline  DeviceObjectPathListUpdate::DeviceObjectPathListUpdate ()  :
    _DeviceObjectPathList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceObjectPathListUpdate::DeviceObjectPathListUpdate (const DeviceObjectPathListUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceObjectPathList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceObjectPathListUpdate::DeviceObjectPathListUpdate (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathList_)  :
    _DeviceObjectPathList (DeviceObjectPathList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceObjectPathListUpdate::~DeviceObjectPathListUpdate() {
}

inline DeviceObjectPathListUpdate& DeviceObjectPathListUpdate::operator = (const DeviceObjectPathListUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceObjectPathList()) {
            setDeviceObjectPathList(rhs.getDeviceObjectPathList());
        } else {
            clearDeviceObjectPathList();
        }
    }
    return *this;
}

inline bool DeviceObjectPathListUpdate::operator == (const DeviceObjectPathListUpdate& rhs) const {
    return (((!hasDeviceObjectPathList() && !rhs.hasDeviceObjectPathList()) || getDeviceObjectPathList() == rhs.getDeviceObjectPathList()));
}

inline bool DeviceObjectPathListUpdate::operator != (const DeviceObjectPathListUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceObjectPathListUpdate::operator < (const DeviceObjectPathListUpdate& rhs) const {
    if (hasDeviceObjectPathList() || rhs.hasDeviceObjectPathList()) {
        if (getDeviceObjectPathList() < rhs.getDeviceObjectPathList()) return true;
        if (getDeviceObjectPathList() > rhs.getDeviceObjectPathList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceObjectPathListUpdate::clone() {
    return new DeviceObjectPathListUpdate(*this);
}

inline bool DeviceObjectPathListUpdate::operator > (const DeviceObjectPathListUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceObjectPathListUpdate::clear() {
    clearDeviceObjectPathList();
}

inline void DeviceObjectPathListUpdate::clearDeviceObjectPathList() {
    if (hasDeviceObjectPathList()) {
         clear_has_DeviceObjectPathList();
        _DeviceObjectPathList.clear();
     }
}

inline bool DeviceObjectPathListUpdate::hasDeviceObjectPathList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathListUpdate::getDeviceObjectPathList () const {
    return _DeviceObjectPathList;
}

inline ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathListUpdate::getDeviceObjectPathListMutable () {
    set_has_DeviceObjectPathList();
    return _DeviceObjectPathList;
}

inline void DeviceObjectPathListUpdate::setDeviceObjectPathList (const ::std::vector< ::com::bosch::pmapp::PMAppTypeCollections::DeviceObjectPathInfo >& DeviceObjectPathList_) {
    set_has_DeviceObjectPathList();
    this->_DeviceObjectPathList = DeviceObjectPathList_;
}

inline void DeviceObjectPathListUpdate::set_has_DeviceObjectPathList () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceObjectPathListUpdate::clear_has_DeviceObjectPathList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceObjectPathListRegister::DeviceObjectPathListRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceObjectPathListRegister::DeviceObjectPathListRegister (const DeviceObjectPathListRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceObjectPathListRegister::~DeviceObjectPathListRegister() {
}

inline DeviceObjectPathListRegister& DeviceObjectPathListRegister::operator = (const DeviceObjectPathListRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeviceObjectPathListRegister::operator == (const DeviceObjectPathListRegister& ) const {
    return true;
}

inline bool DeviceObjectPathListRegister::operator != (const DeviceObjectPathListRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceObjectPathListRegister::operator < (const DeviceObjectPathListRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeviceObjectPathListRegister::clone() {
    return new DeviceObjectPathListRegister(*this);
}

inline bool DeviceObjectPathListRegister::operator > (const DeviceObjectPathListRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceObjectPathListRegister::clear() {
}

inline  NotificationEventSignal::NotificationEventSignal ()  :
    _EventDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NotificationEventSignal::NotificationEventSignal (const NotificationEventSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _EventDetails ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NotificationEventSignal::NotificationEventSignal (const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& EventDetails_)  :
    _EventDetails (EventDetails_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NotificationEventSignal::~NotificationEventSignal() {
}

inline NotificationEventSignal& NotificationEventSignal::operator = (const NotificationEventSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEventDetails()) {
            setEventDetails(rhs.getEventDetails());
        } else {
            clearEventDetails();
        }
    }
    return *this;
}

inline bool NotificationEventSignal::operator == (const NotificationEventSignal& rhs) const {
    return (((!hasEventDetails() && !rhs.hasEventDetails()) || getEventDetails() == rhs.getEventDetails()));
}

inline bool NotificationEventSignal::operator != (const NotificationEventSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NotificationEventSignal::operator < (const NotificationEventSignal& rhs) const {
    if (hasEventDetails() || rhs.hasEventDetails()) {
        if (getEventDetails() < rhs.getEventDetails()) return true;
        if (getEventDetails() > rhs.getEventDetails()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NotificationEventSignal::clone() {
    return new NotificationEventSignal(*this);
}

inline bool NotificationEventSignal::operator > (const NotificationEventSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NotificationEventSignal::clear() {
    clearEventDetails();
}

inline void NotificationEventSignal::clearEventDetails() {
    if (hasEventDetails()) {
         clear_has_EventDetails();
        _EventDetails.clear();
     }
}

inline bool NotificationEventSignal::hasEventDetails () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& NotificationEventSignal::getEventDetails () const {
    return _EventDetails;
}

inline ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& NotificationEventSignal::getEventDetailsMutable () {
    set_has_EventDetails();
    return _EventDetails;
}

inline void NotificationEventSignal::setEventDetails (const ::com::bosch::pmapp::PMAppTypeCollections::EventDetailsType& EventDetails_) {
    set_has_EventDetails();
    this->_EventDetails = EventDetails_;
}

inline void NotificationEventSignal::set_has_EventDetails () {
    _has_bits_[0] |= 1u << 0;
}

inline void NotificationEventSignal::clear_has_EventDetails () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace HfpManager
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_HFPMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
