/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_PMAPP_DEVICEINFOPROXY_H
#define COM_BOSCH_PMAPP_DEVICEINFOPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/pmapp/DeviceInfo.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace com {
namespace bosch {
namespace pmapp {
namespace DeviceInfo {

class DeviceInfoProxy;

class BatteryChargeLevelCallbackIF {
public:
    virtual ~BatteryChargeLevelCallbackIF() {}

    virtual void onBatteryChargeLevelError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< BatteryChargeLevelError >& error) = 0;

    virtual void onBatteryChargeLevelUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< BatteryChargeLevelUpdate >& update) = 0;
};

class FriendlyNameCallbackIF {
public:
    virtual ~FriendlyNameCallbackIF() {}

    virtual void onFriendlyNameError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< FriendlyNameError >& error) = 0;

    virtual void onFriendlyNameUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< FriendlyNameUpdate >& update) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class NetworkOperatorCallbackIF {
public:
    virtual ~NetworkOperatorCallbackIF() {}

    virtual void onNetworkOperatorError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< NetworkOperatorError >& error) = 0;

    virtual void onNetworkOperatorUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< NetworkOperatorUpdate >& update) = 0;
};

class NetworkStatusCallbackIF {
public:
    virtual ~NetworkStatusCallbackIF() {}

    virtual void onNetworkStatusError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< NetworkStatusError >& error) = 0;

    virtual void onNetworkStatusUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< NetworkStatusUpdate >& update) = 0;
};

class SignalStrengthCallbackIF {
public:
    virtual ~SignalStrengthCallbackIF() {}

    virtual void onSignalStrengthError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< SignalStrengthError >& error) = 0;

    virtual void onSignalStrengthUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< SignalStrengthUpdate >& update) = 0;
};

class SupportedFeaturesCallbackIF {
public:
    virtual ~SupportedFeaturesCallbackIF() {}

    virtual void onSupportedFeaturesError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< SupportedFeaturesError >& error) = 0;

    virtual void onSupportedFeaturesUpdate(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< SupportedFeaturesUpdate >& update) = 0;
};

class VoiceMailListCallbackIF {
public:
    virtual ~VoiceMailListCallbackIF() {}

    virtual void onVoiceMailListError(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< VoiceMailListError >& error) = 0;

    virtual void onVoiceMailListResponse(const ::boost::shared_ptr< DeviceInfoProxy >& proxy, const ::boost::shared_ptr< VoiceMailListResponse >& response) = 0;
};


/**
 * DeviceInfoProxy is the client side representation of the D-Bus service
 * interface 'com.bosch.pmapp.DeviceInfo' (specified in file
 * pmapp_device_info_.xml).
 *
 * The interface shall be exposed in the object path:
 *         /com/bosch/pmapp/dev_(HFP device address)
 *
 *     Example:
 *     If the device address of the HFP connected device is - "aabbccddeeff", then the corresponding DeviceInfo interface
 *     will be exposed in the object path: /com/bosch/pmapp/dev_aabbccddeeff
 *
 *     Note:
 *     Notations used in the comments and the description section symbolizes:
 *       [] an Array element
 *       {} a Map element
 *       () a Struct element
 */
class DeviceInfoProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DeviceInfoProxy.
     */
    static ::boost::shared_ptr< DeviceInfoProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DeviceInfoProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DeviceInfoProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DeviceInfoProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DeviceInfoProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DeviceInfoProxy > proxyNew(new DeviceInfoProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~DeviceInfoProxy ();



    // Property 'SupportedFeatures'

    /**
     * Notify on the property 'SupportedFeatures'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupportedFeaturesRegister(SupportedFeaturesCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SupportedFeatures'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @param act The act which was previously returned by the
     * sendSupportedFeaturesRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSupportedFeaturesDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SupportedFeatures'.
     */
    void sendSupportedFeaturesDeregisterAll() const;

    /**
     * Request the value of the property 'SupportedFeatures' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SupportedFeatures'</b>:
     *
     * Provides the supported features of Audio Gateway.
     *
     *         List of features supported by Audio Gateway:-
     *           3way: 3 way calling,
     *           ecnr: ECNR function,
     *           voice_recognition: Voice Recognition is supported,
     *           inband_ringtone: Inband Ringtone is supported,
     *           attach_voice_tag: Attaching a phone number to a voice tag,
     *           reject_incoming_call: Ability to reject an incoming call,
     *           enhanced_call_status: Support to query the list of current calls in Audio Gateway,
     *           enhanced_call_control: Ability to unmerging a conference call or ending an individual call within a conference call,
     *           extended_error_codes: Extended Audio Gateway error,
     *           codec_negotiation: Codec negotiation between HF and AG.
     *
     *         Type Representation - [String]
     *
     *         Example:  ["3way", "reject_incoming_call", "voice_recognition", "attach_voice_tag"]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupportedFeaturesGet(SupportedFeaturesCallbackIF& cb);


    /**
     * Returns the current value of the property 'SupportedFeatures' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSupportedFeatures() returns true.
     *
     * @return the previously received value of the property 'SupportedFeatures'.
     */
    const ::std::vector< ::std::string >& getSupportedFeatures() const;

    /**
     * Determines whether a status message for the property
     * 'SupportedFeatures' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSupportedFeatures() const;

    // Property 'FriendlyName'

    /**
     * Notify on the property 'FriendlyName'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFriendlyNameRegister(FriendlyNameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'FriendlyName'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param act The act which was previously returned by the
     * sendFriendlyNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendFriendlyNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'FriendlyName'.
     */
    void sendFriendlyNameDeregisterAll() const;

    /**
     * Request the value of the property 'FriendlyName' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'FriendlyName'</b>:
     *
     * Provides the friendly name of the Audio Gateway.
     *         The name would have been set in Audio Gateway by the user.
     *
     *         If friendly name is not set in AG, the string shall be empty - "" [Default = ""]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFriendlyNameGet(FriendlyNameCallbackIF& cb);


    /**
     * Returns the current value of the property 'FriendlyName' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFriendlyName() returns true.
     *
     * @return the previously received value of the property 'FriendlyName'.
     */
    const ::std::string& getFriendlyName() const;

    /**
     * Determines whether a status message for the property 'FriendlyName' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFriendlyName() const;

    // Property 'NetworkStatus'

    /**
     * Notify on the property 'NetworkStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkStatusRegister(NetworkStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NetworkStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @param act The act which was previously returned by the
     * sendNetworkStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNetworkStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NetworkStatus'.
     */
    void sendNetworkStatusDeregisterAll() const;

    /**
     * Request the value of the property 'NetworkStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NetworkStatus'</b>:
     *
     * Provides the current network registration status of Audio Gateway.
     *
     *         The possible values are:
     *             0x00 : Unknown - Status is unknown
     *             0x01 : Unregistered - Not registered to any network
     *             0x02 : Registered - Registered to home network
     *             0x03 : Searching - Not registered, but searching
     *             0x04 : Denied - Registration has been denied
     *             0x05 : Roaming - Registered, but roaming
     *             0xFF : Default
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkStatusGet(NetworkStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'NetworkStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNetworkStatus() returns true.
     *
     * @return the previously received value of the property 'NetworkStatus'.
     */
    uint8 getNetworkStatus() const;

    /**
     * Determines whether a status message for the property 'NetworkStatus'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNetworkStatus() const;

    // Property 'SignalStrength'

    /**
     * Notify on the property 'SignalStrength'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignalStrengthRegister(SignalStrengthCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'SignalStrength'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param act The act which was previously returned by the
     * sendSignalStrengthRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSignalStrengthDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'SignalStrength'.
     */
    void sendSignalStrengthDeregisterAll() const;

    /**
     * Request the value of the property 'SignalStrength' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'SignalStrength'</b>:
     *
     * Provides the current signal strength of Audio Gateway.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSignalStrengthGet(SignalStrengthCallbackIF& cb);


    /**
     * Returns the current value of the property 'SignalStrength' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSignalStrength() returns true.
     *
     * @return the previously received value of the property 'SignalStrength'.
     */
    uint8 getSignalStrength() const;

    /**
     * Determines whether a status message for the property 'SignalStrength'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSignalStrength() const;

    // Property 'BatteryChargeLevel'

    /**
     * Notify on the property 'BatteryChargeLevel'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBatteryChargeLevelRegister(BatteryChargeLevelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'BatteryChargeLevel'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param act The act which was previously returned by the
     * sendBatteryChargeLevelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBatteryChargeLevelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'BatteryChargeLevel'.
     */
    void sendBatteryChargeLevelDeregisterAll() const;

    /**
     * Request the value of the property 'BatteryChargeLevel' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'BatteryChargeLevel'</b>:
     *
     * Provides the current charge level of the battery.
     *
     *         The possible values are:
     *         0x00 - 0x05 - Normal Range
     *         0xFF - Default
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBatteryChargeLevelGet(BatteryChargeLevelCallbackIF& cb);


    /**
     * Returns the current value of the property 'BatteryChargeLevel' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBatteryChargeLevel() returns true.
     *
     * @return the previously received value of the property 'BatteryChargeLevel'.
     */
    uint8 getBatteryChargeLevel() const;

    /**
     * Determines whether a status message for the property
     * 'BatteryChargeLevel' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBatteryChargeLevel() const;

    // Property 'NetworkOperator'

    /**
     * Notify on the property 'NetworkOperator'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkOperatorRegister(NetworkOperatorCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'NetworkOperator'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param act The act which was previously returned by the
     * sendNetworkOperatorRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNetworkOperatorDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'NetworkOperator'.
     */
    void sendNetworkOperatorDeregisterAll() const;

    /**
     * Request the value of the property 'NetworkOperator' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'NetworkOperator'</b>:
     *
     * Provides the current network operator name of Audio Gateway.
     *
     *         Contains valid string if Audio Gateway is registered to a network, else contains an empty string - "" [Default = ""]
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNetworkOperatorGet(NetworkOperatorCallbackIF& cb);


    /**
     * Returns the current value of the property 'NetworkOperator' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNetworkOperator() returns true.
     *
     * @return the previously received value of the property 'NetworkOperator'.
     */
    const ::std::string& getNetworkOperator() const;

    /**
     * Determines whether a status message for the property 'NetworkOperator'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNetworkOperator() const;


    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * Returns all the properties of the DeviceInfo Interface.
     *
     *         Possible errors:
     *         ---
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'VoiceMailList'

    /**
     * Call the method 'VoiceMailList'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'VoiceMailList'</b>:
     *
     * Provides the voice mail numbers of the Audio Gateway.
     *
     *         Possible errors:
     *         com.bosch.pmapp.Error.AG.XXX
     *         com.bosch.pmapp.Error.Failed
     *         com.bosch.pmapp.Error.InProgress
     *         com.bosch.pmapp.Error.NotSupported
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVoiceMailListRequest(VoiceMailListCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DeviceInfoProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'SupportedFeatures'

    ::asf::core::nullable< SupportedFeaturesUpdate > _supportedFeatures;

    // Property 'FriendlyName'

    ::asf::core::nullable< FriendlyNameUpdate > _friendlyName;

    // Property 'NetworkStatus'

    ::asf::core::nullable< NetworkStatusUpdate > _networkStatus;

    // Property 'SignalStrength'

    ::asf::core::nullable< SignalStrengthUpdate > _signalStrength;

    // Property 'BatteryChargeLevel'

    ::asf::core::nullable< BatteryChargeLevelUpdate > _batteryChargeLevel;

    // Property 'NetworkOperator'

    ::asf::core::nullable< NetworkOperatorUpdate > _networkOperator;

    DECLARE_CLASS_LOGGER();

    friend class DeviceInfoProxyCallback;
};

} // namespace DeviceInfo
} // namespace pmapp
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_PMAPP_DEVICEINFOPROXY_H
