/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_PLUGINDBUSINTERFACESTUB_H
#define BOSCH_CM_AI_PLUGINDBUSINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/PluginDbusInterface.h"
#include <string>

namespace bosch {
namespace cm {
namespace ai {
namespace PluginDbusInterface {

class PluginDbusInterfaceStubDelegate;

class PluginDbusInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the PluginDbusInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    PluginDbusInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the PluginDbusInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    PluginDbusInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~PluginDbusInterfaceStub();

    // signal 'PluginUpdate'

    /**
     * Raise the signal 'PluginUpdate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PluginUpdate'</b>:
     *
     * Status updates from the plugin
     *
     * @param plugin_name Name of the plugin which updates the status change
     *
     * @param controlblock_name Action that caused the change in status
     *
     * @param data Status data
     */
    void sendPluginUpdateSignal(const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data);

    // signal 'PluginListUpdate'

    /**
     * Raise the signal 'PluginListUpdate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PluginListUpdate'</b>:
     *
     * Status updates from the plugin with list data
     *
     * @param plugin_name Name of the plugin which updates the status change
     *
     * @param controlblock_name Action that caused the change in status
     *
     * @param data Status data
     *
     * @param listData Status data with list entries
     */
    void sendPluginListUpdateSignal(const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data, const ::asf::dbus::DBusVariant& listData);

    // signal 'sig_DBStatus'

    /**
     * Raise the signal 'sig_DBStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_DBStatus'</b>:
     *
     * sig_DBStatus =  to inform DB availability status
     *
     * @param DbState Data base status
     *
     * @param SourceType Source type CMP or CMR
     */
    void sendSig_DBStatusSignal(uint16 dbState, uint16 sourceType);

    // signal 'sig_PlayStatus'

    /**
     * Raise the signal 'sig_PlayStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_PlayStatus'</b>:
     *
     * sig_PlayStatus =  to inform play status
     *
     * @param PlayState Play success or error, Source type, Song id, FileType, Listtype, Filter1 , Filter2, folderpath
     */
    void sendSig_PlayStatusSignal(const Sig_PlayStatusSignalPlayStateStruct& playState);

    // signal 'sig_ReqTrackIndex'

    /**
     * Raise the signal 'sig_ReqTrackIndex' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_ReqTrackIndex'</b>:
     *
     * sig_ReqTrackIndex =  to request current,next and prev trackindex
     *
     * @param TrackReqInfo Action, SOurce type, List type, Filter1, Filter2 ,Position, Region, FolderPath
     */
    void sendSig_ReqTrackIndexSignal(const Sig_ReqTrackIndexSignalTrackReqInfoStruct& trackReqInfo);

    // signal 'sig_CRCCheckStatus'

    /**
     * Raise the signal 'sig_CRCCheckStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_CRCCheckStatus'</b>:
     *
     * sig_CRCState =  update crc check status
     *
     * @param CRCStatus If the meaning of "CRCStatus" isn't clear, then there should be a description here.
     *
     * @param SourceType Source type CMP or CMR
     */
    void sendSig_CRCCheckStatusSignal(bool cRCStatus, uint16 sourceType);

    // property 'EndStationListUpdate'

    /**
     * The method onEndStationListUpdateGet() is called by ASF when a client
     * invokes the read method for the property 'EndStationListUpdate'. The
     * onEndStationListUpdateGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     */
    virtual void onEndStationListUpdateGet(const ::boost::shared_ptr< EndStationListUpdateGet >& payload);

    /**
     * Sends back the update to a previous onEndStationListUpdateGet().
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onEndStationListUpdateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEndStationListUpdateGetUpdate(const ::asf::dbus::DBusVariant& endStationListUpdate, act_t act = 0);

    /**
     * Set the value of the property 'EndStationListUpdate' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     */
    void setEndStationListUpdate(const ::asf::dbus::DBusVariant& endStationListUpdate);

    /**
     * Returns the current value of the property 'EndStationListUpdate'.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     */
    const ::asf::dbus::DBusVariant& getEndStationListUpdate() const;

    /**
     * Returns the current value of the property 'EndStationListUpdate' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendEndStationListUpdateUpdate() method.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     */
    ::asf::dbus::DBusVariant& getEndStationListUpdateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEndStationListUpdateUpdate().
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     */
    void sendEndStationListUpdateUpdate();

    // property 'EntityDetailsUpdate'

    /**
     * The method onEntityDetailsUpdateGet() is called by ASF when a client
     * invokes the read method for the property 'EntityDetailsUpdate'. The
     * onEntityDetailsUpdateGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     */
    virtual void onEntityDetailsUpdateGet(const ::boost::shared_ptr< EntityDetailsUpdateGet >& payload);

    /**
     * Sends back the update to a previous onEntityDetailsUpdateGet().
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onEntityDetailsUpdateGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEntityDetailsUpdateGetUpdate(const ::asf::dbus::DBusVariant& entityDetailsUpdate, act_t act = 0);

    /**
     * Set the value of the property 'EntityDetailsUpdate' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     */
    void setEntityDetailsUpdate(const ::asf::dbus::DBusVariant& entityDetailsUpdate);

    /**
     * Returns the current value of the property 'EntityDetailsUpdate'.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     */
    const ::asf::dbus::DBusVariant& getEntityDetailsUpdate() const;

    /**
     * Returns the current value of the property 'EntityDetailsUpdate' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendEntityDetailsUpdateUpdate() method.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     */
    ::asf::dbus::DBusVariant& getEntityDetailsUpdateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEntityDetailsUpdateUpdate().
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     */
    void sendEntityDetailsUpdateUpdate();

    // property 'PlayBackMode'

    /**
     * The method onPlayBackModeGet() is called by ASF when a client invokes
     * the read method for the property 'PlayBackMode'. The
     * onPlayBackModeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     */
    virtual void onPlayBackModeGet(const ::boost::shared_ptr< PlayBackModeGet >& payload);

    /**
     * Sends back the update to a previous onPlayBackModeGet().
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPlayBackModeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPlayBackModeGetUpdate(const PlayBackModeStruct& playBackMode, act_t act = 0);

    /**
     * Set the value of the property 'PlayBackMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     */
    void setPlayBackMode(const PlayBackModeStruct& playBackMode);

    /**
     * Returns the current value of the property 'PlayBackMode'.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     */
    const PlayBackModeStruct& getPlayBackMode() const;

    /**
     * Returns the current value of the property 'PlayBackMode' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendPlayBackModeUpdate() method.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     */
    PlayBackModeStruct& getPlayBackModeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPlayBackModeUpdate().
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     */
    void sendPlayBackModeUpdate();

    // property 'ListAbsoluteTrackIndex'

    /**
     * The method onListAbsoluteTrackIndexGet() is called by ASF when a client
     * invokes the read method for the property 'ListAbsoluteTrackIndex'. The
     * onListAbsoluteTrackIndexGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    virtual void onListAbsoluteTrackIndexGet(const ::boost::shared_ptr< ListAbsoluteTrackIndexGet >& payload);

    /**
     * Sends back the update to a previous onListAbsoluteTrackIndexGet().
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onListAbsoluteTrackIndexGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendListAbsoluteTrackIndexGetUpdate(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex, act_t act = 0);

    /**
     * The method onListAbsoluteTrackIndexSet() is called by ASF when a client
     * invokes the write method for the property 'ListAbsoluteTrackIndex'. The
     * onListAbsoluteTrackIndexSet() method set property value to the given
     * parameter ListAbsoluteTrackIndex by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    virtual void onListAbsoluteTrackIndexSet(const ::boost::shared_ptr< ListAbsoluteTrackIndexSet >& payload);

    /**
     * Sends back the update to a previous onListAbsoluteTrackIndexSet().
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onListAbsoluteTrackIndexSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendListAbsoluteTrackIndexSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'ListAbsoluteTrackIndex' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    void setListAbsoluteTrackIndex(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex);

    /**
     * Returns the current value of the property 'ListAbsoluteTrackIndex'.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    const ListAbsoluteTrackIndexStruct& getListAbsoluteTrackIndex() const;

    /**
     * Returns the current value of the property 'ListAbsoluteTrackIndex' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendListAbsoluteTrackIndexUpdate() method.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    ListAbsoluteTrackIndexStruct& getListAbsoluteTrackIndexMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendListAbsoluteTrackIndexUpdate().
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    void sendListAbsoluteTrackIndexUpdate();

    // property 'DBState'

    /**
     * The method onDBStateGet() is called by ASF when a client invokes the
     * read method for the property 'DBState'. The onDBStateGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     */
    virtual void onDBStateGet(const ::boost::shared_ptr< DBStateGet >& payload);

    /**
     * Sends back the update to a previous onDBStateGet().
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDBStateGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDBStateGetUpdate(const DBStateStruct& dBState, act_t act = 0);

    /**
     * Set the value of the property 'DBState' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     */
    void setDBState(const DBStateStruct& dBState);

    /**
     * Returns the current value of the property 'DBState'.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     */
    const DBStateStruct& getDBState() const;

    /**
     * Returns the current value of the property 'DBState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDBStateUpdate() method.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     */
    DBStateStruct& getDBStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDBStateUpdate().
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     */
    void sendDBStateUpdate();

    // method 'PluginCommand'

    /**
     * The method onPluginCommand() is called by ASF when a client invokes the
     * method 'PluginCommand'. A subclass has to implement this method and
     * send back a response to the client either with the sendPluginCommand()
     * or sendPluginCommandError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'PluginCommand'</b>:
     *
     * Method that requests plugin to execute a command
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPluginCommandRequest (const ::boost::shared_ptr< PluginCommandRequest >& request) = 0;

    /**
     * The method sendPluginCommandResponse() sends a response of a previous
     * method invocation of 'PluginCommand' back to the client.
     *
     * <b>Documentation of 'PluginCommand'</b>:
     *
     * Method that requests plugin to execute a command
     *
     * @param act The parameter act identifies a previous invocation of
     * onPluginCommand(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPluginCommandResponse (act_t act = 0);

    /**
     * The method sendPluginCommandError() sends an error response of a
     * previous method invocation of 'PluginCommand' back to the client.
     *
     * <b>Documentation of 'PluginCommand'</b>:
     *
     * Method that requests plugin to execute a command
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPluginCommand(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPluginCommandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PluginListCommand'

    /**
     * The method onPluginListCommand() is called by ASF when a client invokes
     * the method 'PluginListCommand'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendPluginListCommand() or sendPluginListCommandError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'PluginListCommand'</b>:
     *
     * Method that requests plugin to execute a command with list data
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPluginListCommandRequest (const ::boost::shared_ptr< PluginListCommandRequest >& request) = 0;

    /**
     * The method sendPluginListCommandResponse() sends a response of a
     * previous method invocation of 'PluginListCommand' back to the client.
     *
     * <b>Documentation of 'PluginListCommand'</b>:
     *
     * Method that requests plugin to execute a command with list data
     *
     * @param act The parameter act identifies a previous invocation of
     * onPluginListCommand(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPluginListCommandResponse (act_t act = 0);

    /**
     * The method sendPluginListCommandError() sends an error response of a
     * previous method invocation of 'PluginListCommand' back to the client.
     *
     * <b>Documentation of 'PluginListCommand'</b>:
     *
     * Method that requests plugin to execute a command with list data
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPluginListCommand().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendPluginListCommandError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    EndStationListUpdateUpdate _EndStationListUpdateProperty;

    EntityDetailsUpdateUpdate _EntityDetailsUpdateProperty;

    PlayBackModeUpdate _PlayBackModeProperty;

    ListAbsoluteTrackIndexUpdate _ListAbsoluteTrackIndexProperty;

    DBStateUpdate _DBStateProperty;

    friend class PluginDbusInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace PluginDbusInterface
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_PLUGINDBUSINTERFACESTUB_H
