/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/PluginDbusInterface.h"
#include "bosch/cm/ai/PluginDbusInterfaceDBus.h"
#include "bosch/cm/ai/PluginDbusInterfaceJson.h"
#include "bosch/cm/ai/PluginDbusInterfaceStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace PluginDbusInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/bosch/cm/ai/PluginDbusInterface", PluginDbusInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "PluginCommand", 0 },
    { 17, "PluginListCommand", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 7, "DBState", 4 },
    { 12, "PlayBackMode", 2 },
    { 19, "EntityDetailsUpdate", 1 },
    { 20, "EndStationListUpdate", 0 },
    { 22, "ListAbsoluteTrackIndex", 3 },
};

class PluginDbusInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    PluginDbusInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    PluginDbusInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    PluginDbusInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.PluginDbusInterface"),
          _logger(logger) {}

    virtual ~PluginDbusInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void PluginDbusInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'PluginCommand'

            LOG_DEBUG_STUB("process method '%s'", "PluginCommand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginCommandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PluginCommand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PluginCommandRequest > payload = ::boost::static_pointer_cast<PluginCommandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PluginDbusInterfaceStub*>(getStub())->onPluginCommandRequest(payload);
            return;
        }
        case 1: {

            // method 'PluginListCommand'

            LOG_DEBUG_STUB("process method '%s'", "PluginListCommand");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PluginListCommandRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PluginListCommand", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PluginListCommandRequest > payload = ::boost::static_pointer_cast<PluginListCommandRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PluginDbusInterfaceStub*>(getStub())->onPluginListCommandRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* PluginDbusInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.PluginDbusInterface\">\n"
            "      <doc>\n"
            "        <line>DBstatus along with the source type update property</line>\n"
            "      </doc>\n"
            "      <annotation name=\"PluginDbusInterface.ServiceName\" value=\"AppUtilities_Plugin.PluginDbusInterface\"/>\n"
            "      <annotation name=\"PluginDbusInterface.ServicePath\" value=\"/bosch/cm/ai/PluginDbusInterface\"/>\n"
            "      <method name=\"PluginCommand\">\n"
            "        <doc>\n"
            "          <line>Method that requests plugin to execute a command</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"plugin_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Name of the plugin</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"controlblock_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Action to be performed by the plugin</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>Data to be passed for the action to be performed</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </method>\n"
            "      <method name=\"PluginListCommand\">\n"
            "        <doc>\n"
            "          <line>Method that requests plugin to execute a command with list data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"plugin_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Name of the plugin</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"controlblock_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Action to be performed by the plugin</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>Data to be passed for the action to be performed</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"in\" name=\"listData\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>List data to be passed for the action to be performed</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </method>\n"
            "      <signal name=\"PluginUpdate\">\n"
            "        <doc>\n"
            "          <line>Status updates from the plugin</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"plugin_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Name of the plugin which updates the status change</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"controlblock_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Action that caused the change in status</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"data\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>Status data</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"PluginListUpdate\">\n"
            "        <doc>\n"
            "          <line>Status updates from the plugin with list data</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"plugin_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Name of the plugin which updates the status change</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"controlblock_name\" type=\"s\">\n"
            "          <doc>\n"
            "            <line>Action that caused the change in status</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"data\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>Status data</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"listData\" type=\"v\">\n"
            "          <doc>\n"
            "            <line>Status data with list entries</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"EndStationListUpdate\" type=\"v\"/>\n"
            "      <property access=\"read\" name=\"EntityDetailsUpdate\" type=\"v\"/>\n"
            "      <signal name=\"sig_DBStatus\">\n"
            "        <doc>\n"
            "          <line>sig_DBStatus =  to inform DB availability status</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"DbState\" type=\"q\">\n"
            "          <doc>\n"
            "            <line>Data base status</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "        <arg direction=\"out\" name=\"SourceType\" type=\"q\">\n"
            "          <doc>\n"
            "            <line>Source type CMP or CMR</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"sig_PlayStatus\">\n"
            "        <doc>\n"
            "          <line>sig_PlayStatus =  to inform play status</line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"PlayState\" type=\"(bqiqqqqs)\">\n"
            "          <doc>\n"
            "            <line>Play success or error, Source type, Song id, FileType, Listtype, Filter1 , Filter2, folderpath </line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"PlayBackMode\" type=\"(iqqi)\"/>\n"
            "      <property access=\"readwrite\" name=\"ListAbsoluteTrackIndex\" type=\"(uqq)\"/>\n"
            "      <property access=\"read\" name=\"DBState\" type=\"(iq)\"/>\n"
            "      <signal name=\"sig_ReqTrackIndex\">\n"
            "        <doc>\n"
            "          <line>sig_ReqTrackIndex =  to request current,next and prev trackindex </line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"TrackReqInfo\" type=\"(qqqqqqqs)\">\n"
            "          <doc>\n"
            "            <line>Action, SOurce type, List type, Filter1, Filter2 ,Position, Region, FolderPath</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "      <signal name=\"sig_CRCCheckStatus\">\n"
            "        <doc>\n"
            "          <line>sig_CRCState =  update crc check status   </line>\n"
            "        </doc>\n"
            "        <arg direction=\"out\" name=\"CRCStatus\" type=\"b\"/>\n"
            "        <arg direction=\"out\" name=\"SourceType\" type=\"q\">\n"
            "          <doc>\n"
            "            <line>Source type CMP or CMR</line>\n"
            "          </doc>\n"
            "        </arg>\n"
            "      </signal>\n"
            "</interface>\n";
}

void PluginDbusInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<PluginDbusInterfaceStub*>(getStub()))->onGetAll (properties);
}

void PluginDbusInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "EndStationListUpdate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "EntityDetailsUpdate");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "PlayBackMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ListAbsoluteTrackIndex");
            ::boost::shared_ptr< ListAbsoluteTrackIndexSet > payload(new ListAbsoluteTrackIndexSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onListAbsoluteTrackIndexSet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DBState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void PluginDbusInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "EndStationListUpdate");
            ::boost::shared_ptr< EndStationListUpdateGet > payload(new EndStationListUpdateGet());
            payload->setAct(act);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onEndStationListUpdateGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "EntityDetailsUpdate");
            ::boost::shared_ptr< EntityDetailsUpdateGet > payload(new EntityDetailsUpdateGet());
            payload->setAct(act);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onEntityDetailsUpdateGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "PlayBackMode");
            ::boost::shared_ptr< PlayBackModeGet > payload(new PlayBackModeGet());
            payload->setAct(act);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onPlayBackModeGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ListAbsoluteTrackIndex");
            ::boost::shared_ptr< ListAbsoluteTrackIndexGet > payload(new ListAbsoluteTrackIndexGet());
            payload->setAct(act);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onListAbsoluteTrackIndexGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "DBState");
            ::boost::shared_ptr< DBStateGet > payload(new DBStateGet());
            payload->setAct(act);
            static_cast<PluginDbusInterfaceStub*>(getStub())->onDBStateGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

PluginDbusInterfaceStub::PluginDbusInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PluginDbusInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PluginDbusInterfaceStub::PluginDbusInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PluginDbusInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PluginDbusInterfaceStub::~PluginDbusInterfaceStub() {
    delete _stubDelegate;
}

void PluginDbusInterfaceStub::sendPluginUpdateSignal(const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data) {
    if (_stubDelegate->isConnected()) {
        PluginUpdateSignal* payload = new PluginUpdateSignal(plugin_name, controlblock_name, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PluginUpdate", PluginUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "PluginUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PluginUpdate");
    }
}

void PluginDbusInterfaceStub::sendPluginListUpdateSignal(const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data, const ::asf::dbus::DBusVariant& listData) {
    if (_stubDelegate->isConnected()) {
        PluginListUpdateSignal* payload = new PluginListUpdateSignal(plugin_name, controlblock_name, data, listData);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PluginListUpdate", PluginListUpdateSignal, payload)
        LOG_INFO ("-> send%sSignal", "PluginListUpdate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PluginListUpdate");
    }
}

void PluginDbusInterfaceStub::sendSig_DBStatusSignal(uint16 dbState, uint16 sourceType) {
    if (_stubDelegate->isConnected()) {
        Sig_DBStatusSignal* payload = new Sig_DBStatusSignal(dbState, sourceType);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_DBStatus", Sig_DBStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_DBStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_DBStatus");
    }
}

void PluginDbusInterfaceStub::sendSig_PlayStatusSignal(const Sig_PlayStatusSignalPlayStateStruct& playState) {
    if (_stubDelegate->isConnected()) {
        Sig_PlayStatusSignal* payload = new Sig_PlayStatusSignal(playState);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_PlayStatus", Sig_PlayStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_PlayStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_PlayStatus");
    }
}

void PluginDbusInterfaceStub::sendSig_ReqTrackIndexSignal(const Sig_ReqTrackIndexSignalTrackReqInfoStruct& trackReqInfo) {
    if (_stubDelegate->isConnected()) {
        Sig_ReqTrackIndexSignal* payload = new Sig_ReqTrackIndexSignal(trackReqInfo);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_ReqTrackIndex", Sig_ReqTrackIndexSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_ReqTrackIndex");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_ReqTrackIndex");
    }
}

void PluginDbusInterfaceStub::sendSig_CRCCheckStatusSignal(bool cRCStatus, uint16 sourceType) {
    if (_stubDelegate->isConnected()) {
        Sig_CRCCheckStatusSignal* payload = new Sig_CRCCheckStatusSignal(cRCStatus, sourceType);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_CRCCheckStatus", Sig_CRCCheckStatusSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_CRCCheckStatus");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_CRCCheckStatus");
    }
}

void PluginDbusInterfaceStub::sendEndStationListUpdateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EndStationListUpdateUpdate payload(_EndStationListUpdateProperty);

        LOG_INFO ("-> send%s", "EndStationListUpdateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EndStationListUpdate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.PluginDbusInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EndStationListUpdateUpdate");
    }
}

void PluginDbusInterfaceStub::onEndStationListUpdateGet(const ::boost::shared_ptr< EndStationListUpdateGet >& endStationListUpdate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EndStationListUpdateGet", endStationListUpdate->getAct());
    sendEndStationListUpdateGetUpdate(_EndStationListUpdateProperty.getEndStationListUpdate(), endStationListUpdate->getAct());
}

void PluginDbusInterfaceStub::sendEndStationListUpdateGetUpdate(const ::asf::dbus::DBusVariant& endStationListUpdate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EndStationListUpdateGet payload(endStationListUpdate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EndStationListUpdateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PluginDbusInterfaceStub::setEndStationListUpdate(const ::asf::dbus::DBusVariant& endStationListUpdate) {
    if(endStationListUpdate!=_EndStationListUpdateProperty.getEndStationListUpdate()) {
        _EndStationListUpdateProperty.setEndStationListUpdate(endStationListUpdate);
        sendEndStationListUpdateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::asf::dbus::DBusVariant& PluginDbusInterfaceStub::getEndStationListUpdate() const {
    return _EndStationListUpdateProperty.getEndStationListUpdate();
}

::asf::dbus::DBusVariant& PluginDbusInterfaceStub::getEndStationListUpdateMutable() {
    return _EndStationListUpdateProperty.getEndStationListUpdateMutable();
}

void PluginDbusInterfaceStub::sendEntityDetailsUpdateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EntityDetailsUpdateUpdate payload(_EntityDetailsUpdateProperty);

        LOG_INFO ("-> send%s", "EntityDetailsUpdateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EntityDetailsUpdate", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.PluginDbusInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EntityDetailsUpdateUpdate");
    }
}

void PluginDbusInterfaceStub::onEntityDetailsUpdateGet(const ::boost::shared_ptr< EntityDetailsUpdateGet >& entityDetailsUpdate) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EntityDetailsUpdateGet", entityDetailsUpdate->getAct());
    sendEntityDetailsUpdateGetUpdate(_EntityDetailsUpdateProperty.getEntityDetailsUpdate(), entityDetailsUpdate->getAct());
}

void PluginDbusInterfaceStub::sendEntityDetailsUpdateGetUpdate(const ::asf::dbus::DBusVariant& entityDetailsUpdate, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EntityDetailsUpdateGet payload(entityDetailsUpdate);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EntityDetailsUpdateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PluginDbusInterfaceStub::setEntityDetailsUpdate(const ::asf::dbus::DBusVariant& entityDetailsUpdate) {
    if(entityDetailsUpdate!=_EntityDetailsUpdateProperty.getEntityDetailsUpdate()) {
        _EntityDetailsUpdateProperty.setEntityDetailsUpdate(entityDetailsUpdate);
        sendEntityDetailsUpdateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::asf::dbus::DBusVariant& PluginDbusInterfaceStub::getEntityDetailsUpdate() const {
    return _EntityDetailsUpdateProperty.getEntityDetailsUpdate();
}

::asf::dbus::DBusVariant& PluginDbusInterfaceStub::getEntityDetailsUpdateMutable() {
    return _EntityDetailsUpdateProperty.getEntityDetailsUpdateMutable();
}

void PluginDbusInterfaceStub::sendPlayBackModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PlayBackModeUpdate payload(_PlayBackModeProperty);

        LOG_INFO ("-> send%s", "PlayBackModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PlayBackMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.PluginDbusInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PlayBackModeUpdate");
    }
}

void PluginDbusInterfaceStub::onPlayBackModeGet(const ::boost::shared_ptr< PlayBackModeGet >& playBackMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PlayBackModeGet", playBackMode->getAct());
    sendPlayBackModeGetUpdate(_PlayBackModeProperty.getPlayBackMode(), playBackMode->getAct());
}

void PluginDbusInterfaceStub::sendPlayBackModeGetUpdate(const PlayBackModeStruct& playBackMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PlayBackModeGet payload(playBackMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PlayBackModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PluginDbusInterfaceStub::setPlayBackMode(const PlayBackModeStruct& playBackMode) {
    if(playBackMode!=_PlayBackModeProperty.getPlayBackMode()) {
        _PlayBackModeProperty.setPlayBackMode(playBackMode);
        sendPlayBackModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const PlayBackModeStruct& PluginDbusInterfaceStub::getPlayBackMode() const {
    return _PlayBackModeProperty.getPlayBackMode();
}

PlayBackModeStruct& PluginDbusInterfaceStub::getPlayBackModeMutable() {
    return _PlayBackModeProperty.getPlayBackModeMutable();
}

void PluginDbusInterfaceStub::sendListAbsoluteTrackIndexUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ListAbsoluteTrackIndexUpdate payload(_ListAbsoluteTrackIndexProperty);

        LOG_INFO ("-> send%s", "ListAbsoluteTrackIndexUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ListAbsoluteTrackIndex", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.PluginDbusInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ListAbsoluteTrackIndexUpdate");
    }
}

void PluginDbusInterfaceStub::onListAbsoluteTrackIndexGet(const ::boost::shared_ptr< ListAbsoluteTrackIndexGet >& listAbsoluteTrackIndex) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ListAbsoluteTrackIndexGet", listAbsoluteTrackIndex->getAct());
    sendListAbsoluteTrackIndexGetUpdate(_ListAbsoluteTrackIndexProperty.getListAbsoluteTrackIndex(), listAbsoluteTrackIndex->getAct());
}

void PluginDbusInterfaceStub::sendListAbsoluteTrackIndexGetUpdate(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ListAbsoluteTrackIndexGet payload(listAbsoluteTrackIndex);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ListAbsoluteTrackIndexGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PluginDbusInterfaceStub::onListAbsoluteTrackIndexSet(const ::boost::shared_ptr< ListAbsoluteTrackIndexSet >& listAbsoluteTrackIndex) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ListAbsoluteTrackIndexSet", listAbsoluteTrackIndex->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*listAbsoluteTrackIndex, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setListAbsoluteTrackIndex (listAbsoluteTrackIndex->getListAbsoluteTrackIndex());
    sendListAbsoluteTrackIndexSetUpdate(listAbsoluteTrackIndex->getAct());
}

void PluginDbusInterfaceStub::sendListAbsoluteTrackIndexSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ListAbsoluteTrackIndexSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void PluginDbusInterfaceStub::setListAbsoluteTrackIndex(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex) {
    if(listAbsoluteTrackIndex!=_ListAbsoluteTrackIndexProperty.getListAbsoluteTrackIndex()) {
        _ListAbsoluteTrackIndexProperty.setListAbsoluteTrackIndex(listAbsoluteTrackIndex);
        sendListAbsoluteTrackIndexUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ListAbsoluteTrackIndexStruct& PluginDbusInterfaceStub::getListAbsoluteTrackIndex() const {
    return _ListAbsoluteTrackIndexProperty.getListAbsoluteTrackIndex();
}

ListAbsoluteTrackIndexStruct& PluginDbusInterfaceStub::getListAbsoluteTrackIndexMutable() {
    return _ListAbsoluteTrackIndexProperty.getListAbsoluteTrackIndexMutable();
}

void PluginDbusInterfaceStub::sendDBStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DBStateUpdate payload(_DBStateProperty);

        LOG_INFO ("-> send%s", "DBStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DBState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.PluginDbusInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DBStateUpdate");
    }
}

void PluginDbusInterfaceStub::onDBStateGet(const ::boost::shared_ptr< DBStateGet >& dBState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DBStateGet", dBState->getAct());
    sendDBStateGetUpdate(_DBStateProperty.getDBState(), dBState->getAct());
}

void PluginDbusInterfaceStub::sendDBStateGetUpdate(const DBStateStruct& dBState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DBStateGet payload(dBState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DBStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void PluginDbusInterfaceStub::setDBState(const DBStateStruct& dBState) {
    if(dBState!=_DBStateProperty.getDBState()) {
        _DBStateProperty.setDBState(dBState);
        sendDBStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const DBStateStruct& PluginDbusInterfaceStub::getDBState() const {
    return _DBStateProperty.getDBState();
}

DBStateStruct& PluginDbusInterfaceStub::getDBStateMutable() {
    return _DBStateProperty.getDBStateMutable();
}

void  PluginDbusInterfaceStub::sendPluginCommandResponse (act_t act) {
    PluginCommandResponse* payload = new PluginCommandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "PluginCommand", PluginCommandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PluginCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PluginDbusInterfaceStub::sendPluginCommandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PluginCommandError* payload = new PluginCommandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PluginCommand", PluginCommandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PluginCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PluginDbusInterfaceStub::sendPluginListCommandResponse (act_t act) {
    PluginListCommandResponse* payload = new PluginListCommandResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "PluginListCommand", PluginListCommandResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PluginListCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PluginDbusInterfaceStub::sendPluginListCommandError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PluginListCommandError* payload = new PluginListCommandError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PluginListCommand", PluginListCommandError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PluginListCommand", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void PluginDbusInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'EndStationListUpdate'
    {
        ::asf::dbus::DBusVariant variant;
        EndStationListUpdateGet payload(_EndStationListUpdateProperty.getEndStationListUpdate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EndStationListUpdate", variant));
    }

    //property 'EntityDetailsUpdate'
    {
        ::asf::dbus::DBusVariant variant;
        EntityDetailsUpdateGet payload(_EntityDetailsUpdateProperty.getEntityDetailsUpdate());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EntityDetailsUpdate", variant));
    }

    //property 'PlayBackMode'
    {
        ::asf::dbus::DBusVariant variant;
        PlayBackModeGet payload(_PlayBackModeProperty.getPlayBackMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PlayBackMode", variant));
    }

    //property 'ListAbsoluteTrackIndex'
    {
        ::asf::dbus::DBusVariant variant;
        ListAbsoluteTrackIndexGet payload(_ListAbsoluteTrackIndexProperty.getListAbsoluteTrackIndex());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ListAbsoluteTrackIndex", variant));
    }

    //property 'DBState'
    {
        ::asf::dbus::DBusVariant variant;
        DBStateGet payload(_DBStateProperty.getDBState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DBState", variant));
    }
}

} // namespace PluginDbusInterface
} // namespace ai
} // namespace cm
} // namespace bosch
