/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_PLUGINDBUSINTERFACEPROXY_H
#define BOSCH_CM_AI_PLUGINDBUSINTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/PluginDbusInterface.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace ai {
namespace PluginDbusInterface {

class PluginDbusInterfaceProxy;

class DBStateCallbackIF {
public:
    virtual ~DBStateCallbackIF() {}

    virtual void onDBStateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateError >& error) = 0;

    virtual void onDBStateUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateUpdate >& update) = 0;
};

class EndStationListUpdateCallbackIF {
public:
    virtual ~EndStationListUpdateCallbackIF() {}

    virtual void onEndStationListUpdateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< EndStationListUpdateError >& error) = 0;

    virtual void onEndStationListUpdateUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< EndStationListUpdateUpdate >& update) = 0;
};

class EntityDetailsUpdateCallbackIF {
public:
    virtual ~EntityDetailsUpdateCallbackIF() {}

    virtual void onEntityDetailsUpdateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< EntityDetailsUpdateError >& error) = 0;

    virtual void onEntityDetailsUpdateUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< EntityDetailsUpdateUpdate >& update) = 0;
};

class ListAbsoluteTrackIndexCallbackIF {
public:
    virtual ~ListAbsoluteTrackIndexCallbackIF() {}

    virtual void onListAbsoluteTrackIndexError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< ListAbsoluteTrackIndexError >& error) = 0;

    virtual void onListAbsoluteTrackIndexUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< ListAbsoluteTrackIndexUpdate >& update) = 0;
};

class PlayBackModeCallbackIF {
public:
    virtual ~PlayBackModeCallbackIF() {}

    virtual void onPlayBackModeError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeError >& error) = 0;

    virtual void onPlayBackModeUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeUpdate >& update) = 0;
};

class PluginCommandCallbackIF {
public:
    virtual ~PluginCommandCallbackIF() {}

    virtual void onPluginCommandError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginCommandError >& error) = 0;

    virtual void onPluginCommandResponse(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginCommandResponse >& response) = 0;
};

class PluginListCommandCallbackIF {
public:
    virtual ~PluginListCommandCallbackIF() {}

    virtual void onPluginListCommandError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginListCommandError >& error) = 0;

    virtual void onPluginListCommandResponse(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginListCommandResponse >& response) = 0;
};

class PluginListUpdateCallbackIF {
public:
    virtual ~PluginListUpdateCallbackIF() {}

    virtual void onPluginListUpdateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginListUpdateError >& error) = 0;

    virtual void onPluginListUpdateSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginListUpdateSignal >& signal) = 0;
};

class PluginUpdateCallbackIF {
public:
    virtual ~PluginUpdateCallbackIF() {}

    virtual void onPluginUpdateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginUpdateError >& error) = 0;

    virtual void onPluginUpdateSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PluginUpdateSignal >& signal) = 0;
};

class Sig_CRCCheckStatusCallbackIF {
public:
    virtual ~Sig_CRCCheckStatusCallbackIF() {}

    virtual void onSig_CRCCheckStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusError >& error) = 0;

    virtual void onSig_CRCCheckStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusSignal >& signal) = 0;
};

class Sig_DBStatusCallbackIF {
public:
    virtual ~Sig_DBStatusCallbackIF() {}

    virtual void onSig_DBStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusError >& error) = 0;

    virtual void onSig_DBStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusSignal >& signal) = 0;
};

class Sig_PlayStatusCallbackIF {
public:
    virtual ~Sig_PlayStatusCallbackIF() {}

    virtual void onSig_PlayStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusError >& error) = 0;

    virtual void onSig_PlayStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusSignal >& signal) = 0;
};

class Sig_ReqTrackIndexCallbackIF {
public:
    virtual ~Sig_ReqTrackIndexCallbackIF() {}

    virtual void onSig_ReqTrackIndexError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexError >& error) = 0;

    virtual void onSig_ReqTrackIndexSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexSignal >& signal) = 0;
};


/**
 * PluginDbusInterfaceProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.ai.PluginDbusInterface' (specified in file
 * PluginDbusInterface.xml).
 *
 * DBstatus along with the source type update property
 */
class PluginDbusInterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of PluginDbusInterfaceProxy.
     */
    static ::boost::shared_ptr< PluginDbusInterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of PluginDbusInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< PluginDbusInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of PluginDbusInterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< PluginDbusInterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< PluginDbusInterfaceProxy > proxyNew(new PluginDbusInterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~PluginDbusInterfaceProxy ();


    // Signal 'PluginUpdate'

    /**
     * Notify on the signal 'PluginUpdate'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'PluginUpdate'</b>:
     *
     * Status updates from the plugin
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPluginUpdateRegister(PluginUpdateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PluginUpdate'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PluginUpdate'</b>:
     *
     * Status updates from the plugin
     *
     * @param act The act which was previously returned by the
     * sendPluginUpdateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPluginUpdateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PluginUpdate'.
     */
    void sendPluginUpdateDeregisterAll () const;

    // Signal 'PluginListUpdate'

    /**
     * Notify on the signal 'PluginListUpdate'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PluginListUpdate'</b>:
     *
     * Status updates from the plugin with list data
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPluginListUpdateRegister(PluginListUpdateCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PluginListUpdate'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PluginListUpdate'</b>:
     *
     * Status updates from the plugin with list data
     *
     * @param act The act which was previously returned by the
     * sendPluginListUpdateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPluginListUpdateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PluginListUpdate'.
     */
    void sendPluginListUpdateDeregisterAll () const;

    // Signal 'sig_DBStatus'

    /**
     * Notify on the signal 'sig_DBStatus'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'sig_DBStatus'</b>:
     *
     * sig_DBStatus =  to inform DB availability status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_DBStatusRegister(Sig_DBStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_DBStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_DBStatus'</b>:
     *
     * sig_DBStatus =  to inform DB availability status
     *
     * @param act The act which was previously returned by the
     * sendSig_DBStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_DBStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_DBStatus'.
     */
    void sendSig_DBStatusDeregisterAll () const;

    // Signal 'sig_PlayStatus'

    /**
     * Notify on the signal 'sig_PlayStatus'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'sig_PlayStatus'</b>:
     *
     * sig_PlayStatus =  to inform play status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_PlayStatusRegister(Sig_PlayStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_PlayStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_PlayStatus'</b>:
     *
     * sig_PlayStatus =  to inform play status
     *
     * @param act The act which was previously returned by the
     * sendSig_PlayStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_PlayStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_PlayStatus'.
     */
    void sendSig_PlayStatusDeregisterAll () const;

    // Signal 'sig_ReqTrackIndex'

    /**
     * Notify on the signal 'sig_ReqTrackIndex'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_ReqTrackIndex'</b>:
     *
     * sig_ReqTrackIndex =  to request current,next and prev trackindex
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_ReqTrackIndexRegister(Sig_ReqTrackIndexCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_ReqTrackIndex'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_ReqTrackIndex'</b>:
     *
     * sig_ReqTrackIndex =  to request current,next and prev trackindex
     *
     * @param act The act which was previously returned by the
     * sendSig_ReqTrackIndexRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_ReqTrackIndexDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_ReqTrackIndex'.
     */
    void sendSig_ReqTrackIndexDeregisterAll () const;

    // Signal 'sig_CRCCheckStatus'

    /**
     * Notify on the signal 'sig_CRCCheckStatus'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'sig_CRCCheckStatus'</b>:
     *
     * sig_CRCState =  update crc check status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSig_CRCCheckStatusRegister(Sig_CRCCheckStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'sig_CRCCheckStatus'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'sig_CRCCheckStatus'</b>:
     *
     * sig_CRCState =  update crc check status
     *
     * @param act The act which was previously returned by the
     * sendSig_CRCCheckStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSig_CRCCheckStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'sig_CRCCheckStatus'.
     */
    void sendSig_CRCCheckStatusDeregisterAll () const;


    // Property 'EndStationListUpdate'

    /**
     * Notify on the property 'EndStationListUpdate'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEndStationListUpdateRegister(EndStationListUpdateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'EndStationListUpdate'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEndStationListUpdateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEndStationListUpdateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'EndStationListUpdate'.
     */
    void sendEndStationListUpdateDeregisterAll() const;

    /**
     * Request the value of the property 'EndStationListUpdate' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'EndStationListUpdate'</b>:
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEndStationListUpdateGet(EndStationListUpdateCallbackIF& cb);


    /**
     * Returns the current value of the property 'EndStationListUpdate' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasEndStationListUpdate() returns true.
     *
     * @return the previously received value of the property 'EndStationListUpdate'.
     */
    const ::asf::dbus::DBusVariant& getEndStationListUpdate() const;

    /**
     * Determines whether a status message for the property
     * 'EndStationListUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEndStationListUpdate() const;

    // Property 'EntityDetailsUpdate'

    /**
     * Notify on the property 'EntityDetailsUpdate'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEntityDetailsUpdateRegister(EntityDetailsUpdateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'EntityDetailsUpdate'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendEntityDetailsUpdateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendEntityDetailsUpdateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'EntityDetailsUpdate'.
     */
    void sendEntityDetailsUpdateDeregisterAll() const;

    /**
     * Request the value of the property 'EntityDetailsUpdate' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'EntityDetailsUpdate'</b>:
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEntityDetailsUpdateGet(EntityDetailsUpdateCallbackIF& cb);


    /**
     * Returns the current value of the property 'EntityDetailsUpdate' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasEntityDetailsUpdate() returns true.
     *
     * @return the previously received value of the property 'EntityDetailsUpdate'.
     */
    const ::asf::dbus::DBusVariant& getEntityDetailsUpdate() const;

    /**
     * Determines whether a status message for the property
     * 'EntityDetailsUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEntityDetailsUpdate() const;

    // Property 'PlayBackMode'

    /**
     * Notify on the property 'PlayBackMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPlayBackModeRegister(PlayBackModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'PlayBackMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPlayBackModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPlayBackModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'PlayBackMode'.
     */
    void sendPlayBackModeDeregisterAll() const;

    /**
     * Request the value of the property 'PlayBackMode' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'PlayBackMode'</b>:
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPlayBackModeGet(PlayBackModeCallbackIF& cb);


    /**
     * Returns the current value of the property 'PlayBackMode' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPlayBackMode() returns true.
     *
     * @return the previously received value of the property 'PlayBackMode'.
     */
    const PlayBackModeStruct& getPlayBackMode() const;

    /**
     * Determines whether a status message for the property 'PlayBackMode' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPlayBackMode() const;

    // Property 'ListAbsoluteTrackIndex'

    /**
     * Notify on the property 'ListAbsoluteTrackIndex'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListAbsoluteTrackIndexRegister(ListAbsoluteTrackIndexCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ListAbsoluteTrackIndex'. This
     * method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendListAbsoluteTrackIndexRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendListAbsoluteTrackIndexDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ListAbsoluteTrackIndex'.
     */
    void sendListAbsoluteTrackIndexDeregisterAll() const;

    /**
     * Request the value of the property 'ListAbsoluteTrackIndex' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListAbsoluteTrackIndexGet(ListAbsoluteTrackIndexCallbackIF& cb);

    /**
     * Set the value of the property 'ListAbsoluteTrackIndex'. This method
     * sends a Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendListAbsoluteTrackIndexSet(ListAbsoluteTrackIndexCallbackIF& cb,
     * const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex) method
     * instead.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     */
    void sendListAbsoluteTrackIndexSet(const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex);

    /**
     * Set the value of the property 'ListAbsoluteTrackIndex'. This method
     * sends a Set message to the D-Bus server.
     *
     * <b>Documentation of 'ListAbsoluteTrackIndex'</b>:
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListAbsoluteTrackIndexSet(ListAbsoluteTrackIndexCallbackIF& cb, const ListAbsoluteTrackIndexStruct& listAbsoluteTrackIndex);

    /**
     * Returns the current value of the property 'ListAbsoluteTrackIndex' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasListAbsoluteTrackIndex() returns true.
     *
     * @return the previously received value of the property 'ListAbsoluteTrackIndex'.
     */
    const ListAbsoluteTrackIndexStruct& getListAbsoluteTrackIndex() const;

    /**
     * Determines whether a status message for the property
     * 'ListAbsoluteTrackIndex' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasListAbsoluteTrackIndex() const;

    // Property 'DBState'

    /**
     * Notify on the property 'DBState'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDBStateRegister(DBStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DBState'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDBStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDBStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DBState'.
     */
    void sendDBStateDeregisterAll() const;

    /**
     * Request the value of the property 'DBState' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DBState'</b>:
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDBStateGet(DBStateCallbackIF& cb);


    /**
     * Returns the current value of the property 'DBState' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDBState()
     * returns true.
     *
     * @return the previously received value of the property 'DBState'.
     */
    const DBStateStruct& getDBState() const;

    /**
     * Determines whether a status message for the property 'DBState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDBState() const;


    // Method 'PluginCommand'

    /**
     * Call the method 'PluginCommand'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'PluginCommand'</b>:
     *
     * Method that requests plugin to execute a command
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param plugin_name Name of the plugin
     *
     * @param controlblock_name Action to be performed by the plugin
     *
     * @param data Data to be passed for the action to be performed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPluginCommandRequest(PluginCommandCallbackIF& cb, const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data) const;

    // Method 'PluginListCommand'

    /**
     * Call the method 'PluginListCommand'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'PluginListCommand'</b>:
     *
     * Method that requests plugin to execute a command with list data
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param plugin_name Name of the plugin
     *
     * @param controlblock_name Action to be performed by the plugin
     *
     * @param data Data to be passed for the action to be performed
     *
     * @param listData List data to be passed for the action to be performed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPluginListCommandRequest(PluginListCommandCallbackIF& cb, const ::std::string& plugin_name, const ::std::string& controlblock_name, const ::asf::dbus::DBusVariant& data, const ::asf::dbus::DBusVariant& listData) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    PluginDbusInterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'EndStationListUpdate'

    ::asf::core::nullable< EndStationListUpdateUpdate > _endStationListUpdate;

    // Property 'EntityDetailsUpdate'

    ::asf::core::nullable< EntityDetailsUpdateUpdate > _entityDetailsUpdate;

    // Property 'PlayBackMode'

    ::asf::core::nullable< PlayBackModeUpdate > _playBackMode;

    // Property 'ListAbsoluteTrackIndex'

    ::asf::core::nullable< ListAbsoluteTrackIndexUpdate > _listAbsoluteTrackIndex;

    // Property 'DBState'

    ::asf::core::nullable< DBStateUpdate > _dBState;

    DECLARE_CLASS_LOGGER();

    friend class PluginDbusInterfaceProxyCallback;
};

} // namespace PluginDbusInterface
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_PLUGINDBUSINTERFACEPROXY_H
