#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_PLUGINDBUSINTERFACE_H
#define BOSCH_CM_AI_PLUGINDBUSINTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "PluginDbusInterface" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace PluginDbusInterface {

// method IDs
static const uint16 ID_PluginCommand = 0;
static const uint16 ID_PluginListCommand = 1;

// signal IDs
static const uint16 ID_PluginUpdate = 2;
static const uint16 ID_PluginListUpdate = 3;
static const uint16 ID_sig_DBStatus = 4;
static const uint16 ID_sig_PlayStatus = 5;
static const uint16 ID_sig_ReqTrackIndex = 6;
static const uint16 ID_sig_CRCCheckStatus = 7;

// property IDs
static const uint16 ID_EndStationListUpdate = 8;
static const uint16 ID_EntityDetailsUpdate = 9;
static const uint16 ID_PlayBackMode = 10;
static const uint16 ID_ListAbsoluteTrackIndex = 11;
static const uint16 ID_DBState = 12;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class PluginCommandRequest;

class PluginListCommandRequest;

class EndStationListUpdateUpdate;

class EndStationListUpdateRegister;

class EntityDetailsUpdateUpdate;

class EntityDetailsUpdateRegister;

class PlayBackModeStruct;

class PlayBackModeUpdate;

class PlayBackModeRegister;

class ListAbsoluteTrackIndexStruct;

class ListAbsoluteTrackIndexUpdate;

class ListAbsoluteTrackIndexRegister;

class DBStateStruct;

class DBStateUpdate;

class DBStateRegister;

class PluginUpdateSignal;

class PluginListUpdateSignal;

class Sig_DBStatusSignal;

class Sig_PlayStatusSignalPlayStateStruct;

class Sig_PlayStatusSignal;

class Sig_ReqTrackIndexSignalTrackReqInfoStruct;

class Sig_ReqTrackIndexSignal;

class Sig_CRCCheckStatusSignal;

// type definitions
/**
 * If the meaning of "PluginCommandResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PluginCommandResponse;

/**
 * If the meaning of "PluginCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PluginCommandError;

/**
 * If the meaning of "PluginListCommandResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage PluginListCommandResponse;

/**
 * If the meaning of "PluginListCommandError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PluginListCommandError;

/**
 * If the meaning of "EndStationListUpdateSet" isn't clear, then there should be a description here.
 */
typedef EndStationListUpdateUpdate EndStationListUpdateSet;

/**
 * If the meaning of "EndStationListUpdateGet" isn't clear, then there should be a description here.
 */
typedef EndStationListUpdateUpdate EndStationListUpdateGet;

/**
 * If the meaning of "EndStationListUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EndStationListUpdateError;

/**
 * If the meaning of "EntityDetailsUpdateSet" isn't clear, then there should be a description here.
 */
typedef EntityDetailsUpdateUpdate EntityDetailsUpdateSet;

/**
 * If the meaning of "EntityDetailsUpdateGet" isn't clear, then there should be a description here.
 */
typedef EntityDetailsUpdateUpdate EntityDetailsUpdateGet;

/**
 * If the meaning of "EntityDetailsUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EntityDetailsUpdateError;

/**
 * If the meaning of "PlayBackModeSet" isn't clear, then there should be a description here.
 */
typedef PlayBackModeUpdate PlayBackModeSet;

/**
 * If the meaning of "PlayBackModeGet" isn't clear, then there should be a description here.
 */
typedef PlayBackModeUpdate PlayBackModeGet;

/**
 * If the meaning of "PlayBackModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PlayBackModeError;

/**
 * If the meaning of "ListAbsoluteTrackIndexSet" isn't clear, then there should be a description here.
 */
typedef ListAbsoluteTrackIndexUpdate ListAbsoluteTrackIndexSet;

/**
 * If the meaning of "ListAbsoluteTrackIndexGet" isn't clear, then there should be a description here.
 */
typedef ListAbsoluteTrackIndexUpdate ListAbsoluteTrackIndexGet;

/**
 * If the meaning of "ListAbsoluteTrackIndexError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ListAbsoluteTrackIndexError;

/**
 * If the meaning of "DBStateSet" isn't clear, then there should be a description here.
 */
typedef DBStateUpdate DBStateSet;

/**
 * If the meaning of "DBStateGet" isn't clear, then there should be a description here.
 */
typedef DBStateUpdate DBStateGet;

/**
 * If the meaning of "DBStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DBStateError;

/**
 * If the meaning of "PluginUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PluginUpdateError;

/**
 * If the meaning of "PluginListUpdateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PluginListUpdateError;

/**
 * If the meaning of "Sig_DBStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_DBStatusError;

/**
 * If the meaning of "Sig_PlayStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_PlayStatusError;

/**
 * If the meaning of "Sig_ReqTrackIndexError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_ReqTrackIndexError;

/**
 * If the meaning of "Sig_CRCCheckStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_CRCCheckStatusError;


/**
 * If the meaning of "PluginCommandRequest" isn't clear, then there should be a description here.
 */
class PluginCommandRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PluginCommandRequest ();

    /**
     * Copy constructor
     */
    inline  PluginCommandRequest (const PluginCommandRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PluginCommandRequest (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_);

    /**
     * Destructor
     */
    inline virtual  ~PluginCommandRequest();

    /**
     * Assignment operator
     */
    inline PluginCommandRequest& operator = (const PluginCommandRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PluginCommandRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PluginCommandRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PluginCommandRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PluginCommandRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "plugin_name"

    static const int kPlugin_name = 0;

    /**
     * Clears the field "plugin_name".
     *
     * The field will be set to its default value. The hasPlugin_name()
     * method will return false.
     */
    inline void clearPlugin_name();

    /**
     * Checks whether the field "plugin_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlugin_name()). Otherwise it will return false.
     */
    inline bool hasPlugin_name () const;

    /**
     * Returns the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "plugin_name"
     */
    inline const ::std::string& getPlugin_name () const;

    /**
     * Retrieves the value of the field "plugin_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "plugin_name".
     */
    inline ::std::string& getPlugin_nameMutable ();

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const ::std::string& plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* value, size_t size);

    // API of field "controlblock_name"

    static const int kControlblock_name = 1;

    /**
     * Clears the field "controlblock_name".
     *
     * The field will be set to its default value. The hasControlblock_name()
     * method will return false.
     */
    inline void clearControlblock_name();

    /**
     * Checks whether the field "controlblock_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlblock_name()). Otherwise it will return false.
     */
    inline bool hasControlblock_name () const;

    /**
     * Returns the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "controlblock_name"
     */
    inline const ::std::string& getControlblock_name () const;

    /**
     * Retrieves the value of the field "controlblock_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "controlblock_name".
     */
    inline ::std::string& getControlblock_nameMutable ();

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const ::std::string& controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* value, size_t size);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::asf::dbus::DBusVariant& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::asf::dbus::DBusVariant& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::asf::dbus::DBusVariant& data_);

    static const PluginCommandRequest &getDefaultInstance();

private:

    inline void set_has_plugin_name ();

    inline void clear_has_plugin_name ();

    inline void set_has_controlblock_name ();

    inline void clear_has_controlblock_name ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _plugin_name;

    ::std::string _controlblock_name;

    ::asf::dbus::DBusVariant _data;

};

/**
 * If the meaning of "PluginListCommandRequest" isn't clear, then there should be a description here.
 */
class PluginListCommandRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PluginListCommandRequest ();

    /**
     * Copy constructor
     */
    inline  PluginListCommandRequest (const PluginListCommandRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PluginListCommandRequest (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_, const ::asf::dbus::DBusVariant& listData_);

    /**
     * Destructor
     */
    inline virtual  ~PluginListCommandRequest();

    /**
     * Assignment operator
     */
    inline PluginListCommandRequest& operator = (const PluginListCommandRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PluginListCommandRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PluginListCommandRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PluginListCommandRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PluginListCommandRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "plugin_name"

    static const int kPlugin_name = 0;

    /**
     * Clears the field "plugin_name".
     *
     * The field will be set to its default value. The hasPlugin_name()
     * method will return false.
     */
    inline void clearPlugin_name();

    /**
     * Checks whether the field "plugin_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlugin_name()). Otherwise it will return false.
     */
    inline bool hasPlugin_name () const;

    /**
     * Returns the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "plugin_name"
     */
    inline const ::std::string& getPlugin_name () const;

    /**
     * Retrieves the value of the field "plugin_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "plugin_name".
     */
    inline ::std::string& getPlugin_nameMutable ();

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const ::std::string& plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* value, size_t size);

    // API of field "controlblock_name"

    static const int kControlblock_name = 1;

    /**
     * Clears the field "controlblock_name".
     *
     * The field will be set to its default value. The hasControlblock_name()
     * method will return false.
     */
    inline void clearControlblock_name();

    /**
     * Checks whether the field "controlblock_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlblock_name()). Otherwise it will return false.
     */
    inline bool hasControlblock_name () const;

    /**
     * Returns the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "controlblock_name"
     */
    inline const ::std::string& getControlblock_name () const;

    /**
     * Retrieves the value of the field "controlblock_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "controlblock_name".
     */
    inline ::std::string& getControlblock_nameMutable ();

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const ::std::string& controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* value, size_t size);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::asf::dbus::DBusVariant& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::asf::dbus::DBusVariant& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::asf::dbus::DBusVariant& data_);

    // API of field "listData"

    static const int kListData = 3;

    /**
     * Clears the field "listData".
     *
     * The field will be set to its default value. The hasListData()
     * method will return false.
     */
    inline void clearListData();

    /**
     * Checks whether the field "listData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListData()). Otherwise it will return false.
     */
    inline bool hasListData () const;

    /**
     * Returns the value of the member "listData".
     *
     * If the meaning of "listData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listData"
     */
    inline const ::asf::dbus::DBusVariant& getListData () const;

    /**
     * Retrieves the value of the field "listData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listData".
     */
    inline ::asf::dbus::DBusVariant& getListDataMutable ();

    /**
     * Sets the value of the member "listData".
     *
     * If the meaning of "listData" isn't clear, then there should be a description here.
     *
     * @param listData The value which will be set
     */
    inline void setListData (const ::asf::dbus::DBusVariant& listData_);

    static const PluginListCommandRequest &getDefaultInstance();

private:

    inline void set_has_plugin_name ();

    inline void clear_has_plugin_name ();

    inline void set_has_controlblock_name ();

    inline void clear_has_controlblock_name ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_listData ();

    inline void clear_has_listData ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _plugin_name;

    ::std::string _controlblock_name;

    ::asf::dbus::DBusVariant _data;

    ::asf::dbus::DBusVariant _listData;

};

/**
 * If the meaning of "EndStationListUpdateUpdate" isn't clear, then there should be a description here.
 */
class EndStationListUpdateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EndStationListUpdateUpdate ();

    /**
     * Copy constructor
     */
    inline  EndStationListUpdateUpdate (const EndStationListUpdateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EndStationListUpdateUpdate (const ::asf::dbus::DBusVariant& EndStationListUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~EndStationListUpdateUpdate();

    /**
     * Assignment operator
     */
    inline EndStationListUpdateUpdate& operator = (const EndStationListUpdateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EndStationListUpdateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EndStationListUpdateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EndStationListUpdateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EndStationListUpdateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EndStationListUpdate"

    static const int kEndStationListUpdate = 0;

    /**
     * Clears the field "EndStationListUpdate".
     *
     * The field will be set to its default value. The hasEndStationListUpdate()
     * method will return false.
     */
    inline void clearEndStationListUpdate();

    /**
     * Checks whether the field "EndStationListUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEndStationListUpdate()). Otherwise it will return false.
     */
    inline bool hasEndStationListUpdate () const;

    /**
     * Returns the value of the member "EndStationListUpdate".
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EndStationListUpdate"
     */
    inline const ::asf::dbus::DBusVariant& getEndStationListUpdate () const;

    /**
     * Retrieves the value of the field "EndStationListUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EndStationListUpdate".
     */
    inline ::asf::dbus::DBusVariant& getEndStationListUpdateMutable ();

    /**
     * Sets the value of the member "EndStationListUpdate".
     *
     * If the meaning of "EndStationListUpdate" isn't clear, then there should be a description here.
     *
     * @param EndStationListUpdate The value which will be set
     */
    inline void setEndStationListUpdate (const ::asf::dbus::DBusVariant& EndStationListUpdate_);

    static const EndStationListUpdateUpdate &getDefaultInstance();

private:

    inline void set_has_EndStationListUpdate ();

    inline void clear_has_EndStationListUpdate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::asf::dbus::DBusVariant _EndStationListUpdate;

};

/**
 * If the meaning of "EndStationListUpdateRegister" isn't clear, then there should be a description here.
 */
class EndStationListUpdateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EndStationListUpdateRegister ();

    /**
     * Copy constructor
     */
    inline  EndStationListUpdateRegister (const EndStationListUpdateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EndStationListUpdateRegister();

    /**
     * Assignment operator
     */
    inline EndStationListUpdateRegister& operator = (const EndStationListUpdateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EndStationListUpdateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EndStationListUpdateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EndStationListUpdateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EndStationListUpdateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EndStationListUpdateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "EntityDetailsUpdateUpdate" isn't clear, then there should be a description here.
 */
class EntityDetailsUpdateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntityDetailsUpdateUpdate ();

    /**
     * Copy constructor
     */
    inline  EntityDetailsUpdateUpdate (const EntityDetailsUpdateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  EntityDetailsUpdateUpdate (const ::asf::dbus::DBusVariant& EntityDetailsUpdate_);

    /**
     * Destructor
     */
    inline virtual  ~EntityDetailsUpdateUpdate();

    /**
     * Assignment operator
     */
    inline EntityDetailsUpdateUpdate& operator = (const EntityDetailsUpdateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntityDetailsUpdateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntityDetailsUpdateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntityDetailsUpdateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntityDetailsUpdateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EntityDetailsUpdate"

    static const int kEntityDetailsUpdate = 0;

    /**
     * Clears the field "EntityDetailsUpdate".
     *
     * The field will be set to its default value. The hasEntityDetailsUpdate()
     * method will return false.
     */
    inline void clearEntityDetailsUpdate();

    /**
     * Checks whether the field "EntityDetailsUpdate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntityDetailsUpdate()). Otherwise it will return false.
     */
    inline bool hasEntityDetailsUpdate () const;

    /**
     * Returns the value of the member "EntityDetailsUpdate".
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EntityDetailsUpdate"
     */
    inline const ::asf::dbus::DBusVariant& getEntityDetailsUpdate () const;

    /**
     * Retrieves the value of the field "EntityDetailsUpdate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EntityDetailsUpdate".
     */
    inline ::asf::dbus::DBusVariant& getEntityDetailsUpdateMutable ();

    /**
     * Sets the value of the member "EntityDetailsUpdate".
     *
     * If the meaning of "EntityDetailsUpdate" isn't clear, then there should be a description here.
     *
     * @param EntityDetailsUpdate The value which will be set
     */
    inline void setEntityDetailsUpdate (const ::asf::dbus::DBusVariant& EntityDetailsUpdate_);

    static const EntityDetailsUpdateUpdate &getDefaultInstance();

private:

    inline void set_has_EntityDetailsUpdate ();

    inline void clear_has_EntityDetailsUpdate ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::asf::dbus::DBusVariant _EntityDetailsUpdate;

};

/**
 * If the meaning of "EntityDetailsUpdateRegister" isn't clear, then there should be a description here.
 */
class EntityDetailsUpdateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntityDetailsUpdateRegister ();

    /**
     * Copy constructor
     */
    inline  EntityDetailsUpdateRegister (const EntityDetailsUpdateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~EntityDetailsUpdateRegister();

    /**
     * Assignment operator
     */
    inline EntityDetailsUpdateRegister& operator = (const EntityDetailsUpdateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntityDetailsUpdateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntityDetailsUpdateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntityDetailsUpdateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntityDetailsUpdateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const EntityDetailsUpdateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PlayBackModeStruct" isn't clear, then there should be a description here.
 */
class PlayBackModeStruct {
public:

    /**
     * Default constructor
     */
    inline  PlayBackModeStruct ();

    /**
     * Copy constructor
     */
    inline  PlayBackModeStruct (const PlayBackModeStruct &rhs);

    /**
     * All fields constructor
     */
    inline  PlayBackModeStruct (int32 elem1_, uint16 elem2_, uint16 elem3_, int32 elem4_);

    /**
     * Destructor
     */
    inline  ~PlayBackModeStruct();

    /**
     * Assignment operator
     */
    inline PlayBackModeStruct& operator = (const PlayBackModeStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayBackModeStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayBackModeStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayBackModeStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayBackModeStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int32 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int32 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline uint16 getElem3 () const;

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (uint16 elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline int32 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (int32 elem4_);

    static const PlayBackModeStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _elem1;

    uint16 _elem2;

    uint16 _elem3;

    int32 _elem4;

};

/**
 * If the meaning of "PlayBackModeUpdate" isn't clear, then there should be a description here.
 */
class PlayBackModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayBackModeUpdate ();

    /**
     * Copy constructor
     */
    inline  PlayBackModeUpdate (const PlayBackModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PlayBackModeUpdate (const PlayBackModeStruct& PlayBackMode_);

    /**
     * Destructor
     */
    inline virtual  ~PlayBackModeUpdate();

    /**
     * Assignment operator
     */
    inline PlayBackModeUpdate& operator = (const PlayBackModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayBackModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayBackModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayBackModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayBackModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PlayBackMode"

    static const int kPlayBackMode = 0;

    /**
     * Clears the field "PlayBackMode".
     *
     * The field will be set to its default value. The hasPlayBackMode()
     * method will return false.
     */
    inline void clearPlayBackMode();

    /**
     * Checks whether the field "PlayBackMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlayBackMode()). Otherwise it will return false.
     */
    inline bool hasPlayBackMode () const;

    /**
     * Returns the value of the member "PlayBackMode".
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PlayBackMode"
     */
    inline const PlayBackModeStruct& getPlayBackMode () const;

    /**
     * Retrieves the value of the field "PlayBackMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PlayBackMode".
     */
    inline PlayBackModeStruct& getPlayBackModeMutable ();

    /**
     * Sets the value of the member "PlayBackMode".
     *
     * If the meaning of "PlayBackMode" isn't clear, then there should be a description here.
     *
     * @param PlayBackMode The value which will be set
     */
    inline void setPlayBackMode (const PlayBackModeStruct& PlayBackMode_);

    static const PlayBackModeUpdate &getDefaultInstance();

private:

    inline void set_has_PlayBackMode ();

    inline void clear_has_PlayBackMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    PlayBackModeStruct _PlayBackMode;

};

/**
 * If the meaning of "PlayBackModeRegister" isn't clear, then there should be a description here.
 */
class PlayBackModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PlayBackModeRegister ();

    /**
     * Copy constructor
     */
    inline  PlayBackModeRegister (const PlayBackModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PlayBackModeRegister();

    /**
     * Assignment operator
     */
    inline PlayBackModeRegister& operator = (const PlayBackModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PlayBackModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PlayBackModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PlayBackModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PlayBackModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PlayBackModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ListAbsoluteTrackIndexStruct" isn't clear, then there should be a description here.
 */
class ListAbsoluteTrackIndexStruct {
public:

    /**
     * Default constructor
     */
    inline  ListAbsoluteTrackIndexStruct ();

    /**
     * Copy constructor
     */
    inline  ListAbsoluteTrackIndexStruct (const ListAbsoluteTrackIndexStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ListAbsoluteTrackIndexStruct (uint32 elem1_, uint16 elem2_, uint16 elem3_);

    /**
     * Destructor
     */
    inline  ~ListAbsoluteTrackIndexStruct();

    /**
     * Assignment operator
     */
    inline ListAbsoluteTrackIndexStruct& operator = (const ListAbsoluteTrackIndexStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListAbsoluteTrackIndexStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListAbsoluteTrackIndexStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListAbsoluteTrackIndexStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListAbsoluteTrackIndexStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint32 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint32 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline uint16 getElem3 () const;

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (uint16 elem3_);

    static const ListAbsoluteTrackIndexStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _elem1;

    uint16 _elem2;

    uint16 _elem3;

};

/**
 * If the meaning of "ListAbsoluteTrackIndexUpdate" isn't clear, then there should be a description here.
 */
class ListAbsoluteTrackIndexUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListAbsoluteTrackIndexUpdate ();

    /**
     * Copy constructor
     */
    inline  ListAbsoluteTrackIndexUpdate (const ListAbsoluteTrackIndexUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ListAbsoluteTrackIndexUpdate (const ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndex_);

    /**
     * Destructor
     */
    inline virtual  ~ListAbsoluteTrackIndexUpdate();

    /**
     * Assignment operator
     */
    inline ListAbsoluteTrackIndexUpdate& operator = (const ListAbsoluteTrackIndexUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListAbsoluteTrackIndexUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListAbsoluteTrackIndexUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListAbsoluteTrackIndexUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListAbsoluteTrackIndexUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ListAbsoluteTrackIndex"

    static const int kListAbsoluteTrackIndex = 0;

    /**
     * Clears the field "ListAbsoluteTrackIndex".
     *
     * The field will be set to its default value. The hasListAbsoluteTrackIndex()
     * method will return false.
     */
    inline void clearListAbsoluteTrackIndex();

    /**
     * Checks whether the field "ListAbsoluteTrackIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListAbsoluteTrackIndex()). Otherwise it will return false.
     */
    inline bool hasListAbsoluteTrackIndex () const;

    /**
     * Returns the value of the member "ListAbsoluteTrackIndex".
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ListAbsoluteTrackIndex"
     */
    inline const ListAbsoluteTrackIndexStruct& getListAbsoluteTrackIndex () const;

    /**
     * Retrieves the value of the field "ListAbsoluteTrackIndex" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListAbsoluteTrackIndex".
     */
    inline ListAbsoluteTrackIndexStruct& getListAbsoluteTrackIndexMutable ();

    /**
     * Sets the value of the member "ListAbsoluteTrackIndex".
     *
     * If the meaning of "ListAbsoluteTrackIndex" isn't clear, then there should be a description here.
     *
     * @param ListAbsoluteTrackIndex The value which will be set
     */
    inline void setListAbsoluteTrackIndex (const ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndex_);

    static const ListAbsoluteTrackIndexUpdate &getDefaultInstance();

private:

    inline void set_has_ListAbsoluteTrackIndex ();

    inline void clear_has_ListAbsoluteTrackIndex ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ListAbsoluteTrackIndexStruct _ListAbsoluteTrackIndex;

};

/**
 * If the meaning of "ListAbsoluteTrackIndexRegister" isn't clear, then there should be a description here.
 */
class ListAbsoluteTrackIndexRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ListAbsoluteTrackIndexRegister ();

    /**
     * Copy constructor
     */
    inline  ListAbsoluteTrackIndexRegister (const ListAbsoluteTrackIndexRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ListAbsoluteTrackIndexRegister();

    /**
     * Assignment operator
     */
    inline ListAbsoluteTrackIndexRegister& operator = (const ListAbsoluteTrackIndexRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ListAbsoluteTrackIndexRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ListAbsoluteTrackIndexRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ListAbsoluteTrackIndexRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ListAbsoluteTrackIndexRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ListAbsoluteTrackIndexRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DBStateStruct" isn't clear, then there should be a description here.
 */
class DBStateStruct {
public:

    /**
     * Default constructor
     */
    inline  DBStateStruct ();

    /**
     * Copy constructor
     */
    inline  DBStateStruct (const DBStateStruct &rhs);

    /**
     * All fields constructor
     */
    inline  DBStateStruct (int32 elem1_, uint16 elem2_);

    /**
     * Destructor
     */
    inline  ~DBStateStruct();

    /**
     * Assignment operator
     */
    inline DBStateStruct& operator = (const DBStateStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBStateStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBStateStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBStateStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBStateStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline int32 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (int32 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    static const DBStateStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _elem1;

    uint16 _elem2;

};

/**
 * If the meaning of "DBStateUpdate" isn't clear, then there should be a description here.
 */
class DBStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DBStateUpdate ();

    /**
     * Copy constructor
     */
    inline  DBStateUpdate (const DBStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DBStateUpdate (const DBStateStruct& DBState_);

    /**
     * Destructor
     */
    inline virtual  ~DBStateUpdate();

    /**
     * Assignment operator
     */
    inline DBStateUpdate& operator = (const DBStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DBState"

    static const int kDBState = 0;

    /**
     * Clears the field "DBState".
     *
     * The field will be set to its default value. The hasDBState()
     * method will return false.
     */
    inline void clearDBState();

    /**
     * Checks whether the field "DBState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDBState()). Otherwise it will return false.
     */
    inline bool hasDBState () const;

    /**
     * Returns the value of the member "DBState".
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DBState"
     */
    inline const DBStateStruct& getDBState () const;

    /**
     * Retrieves the value of the field "DBState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DBState".
     */
    inline DBStateStruct& getDBStateMutable ();

    /**
     * Sets the value of the member "DBState".
     *
     * If the meaning of "DBState" isn't clear, then there should be a description here.
     *
     * @param DBState The value which will be set
     */
    inline void setDBState (const DBStateStruct& DBState_);

    static const DBStateUpdate &getDefaultInstance();

private:

    inline void set_has_DBState ();

    inline void clear_has_DBState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    DBStateStruct _DBState;

};

/**
 * If the meaning of "DBStateRegister" isn't clear, then there should be a description here.
 */
class DBStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DBStateRegister ();

    /**
     * Copy constructor
     */
    inline  DBStateRegister (const DBStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DBStateRegister();

    /**
     * Assignment operator
     */
    inline DBStateRegister& operator = (const DBStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DBStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DBStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DBStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DBStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DBStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "PluginUpdateSignal" isn't clear, then there should be a description here.
 */
class PluginUpdateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PluginUpdateSignal ();

    /**
     * Copy constructor
     */
    inline  PluginUpdateSignal (const PluginUpdateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PluginUpdateSignal (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_);

    /**
     * Destructor
     */
    inline virtual  ~PluginUpdateSignal();

    /**
     * Assignment operator
     */
    inline PluginUpdateSignal& operator = (const PluginUpdateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PluginUpdateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PluginUpdateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PluginUpdateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PluginUpdateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "plugin_name"

    static const int kPlugin_name = 0;

    /**
     * Clears the field "plugin_name".
     *
     * The field will be set to its default value. The hasPlugin_name()
     * method will return false.
     */
    inline void clearPlugin_name();

    /**
     * Checks whether the field "plugin_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlugin_name()). Otherwise it will return false.
     */
    inline bool hasPlugin_name () const;

    /**
     * Returns the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "plugin_name"
     */
    inline const ::std::string& getPlugin_name () const;

    /**
     * Retrieves the value of the field "plugin_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "plugin_name".
     */
    inline ::std::string& getPlugin_nameMutable ();

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const ::std::string& plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* value, size_t size);

    // API of field "controlblock_name"

    static const int kControlblock_name = 1;

    /**
     * Clears the field "controlblock_name".
     *
     * The field will be set to its default value. The hasControlblock_name()
     * method will return false.
     */
    inline void clearControlblock_name();

    /**
     * Checks whether the field "controlblock_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlblock_name()). Otherwise it will return false.
     */
    inline bool hasControlblock_name () const;

    /**
     * Returns the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "controlblock_name"
     */
    inline const ::std::string& getControlblock_name () const;

    /**
     * Retrieves the value of the field "controlblock_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "controlblock_name".
     */
    inline ::std::string& getControlblock_nameMutable ();

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const ::std::string& controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* value, size_t size);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::asf::dbus::DBusVariant& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::asf::dbus::DBusVariant& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::asf::dbus::DBusVariant& data_);

    static const PluginUpdateSignal &getDefaultInstance();

private:

    inline void set_has_plugin_name ();

    inline void clear_has_plugin_name ();

    inline void set_has_controlblock_name ();

    inline void clear_has_controlblock_name ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _plugin_name;

    ::std::string _controlblock_name;

    ::asf::dbus::DBusVariant _data;

};

/**
 * If the meaning of "PluginListUpdateSignal" isn't clear, then there should be a description here.
 */
class PluginListUpdateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PluginListUpdateSignal ();

    /**
     * Copy constructor
     */
    inline  PluginListUpdateSignal (const PluginListUpdateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PluginListUpdateSignal (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_, const ::asf::dbus::DBusVariant& listData_);

    /**
     * Destructor
     */
    inline virtual  ~PluginListUpdateSignal();

    /**
     * Assignment operator
     */
    inline PluginListUpdateSignal& operator = (const PluginListUpdateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PluginListUpdateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PluginListUpdateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PluginListUpdateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PluginListUpdateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "plugin_name"

    static const int kPlugin_name = 0;

    /**
     * Clears the field "plugin_name".
     *
     * The field will be set to its default value. The hasPlugin_name()
     * method will return false.
     */
    inline void clearPlugin_name();

    /**
     * Checks whether the field "plugin_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlugin_name()). Otherwise it will return false.
     */
    inline bool hasPlugin_name () const;

    /**
     * Returns the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "plugin_name"
     */
    inline const ::std::string& getPlugin_name () const;

    /**
     * Retrieves the value of the field "plugin_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "plugin_name".
     */
    inline ::std::string& getPlugin_nameMutable ();

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const ::std::string& plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* plugin_name_);

    /**
     * Sets the value of the member "plugin_name".
     *
     * If the meaning of "plugin_name" isn't clear, then there should be a description here.
     *
     * @param plugin_name The value which will be set
     */
    inline void setPlugin_name (const char* value, size_t size);

    // API of field "controlblock_name"

    static const int kControlblock_name = 1;

    /**
     * Clears the field "controlblock_name".
     *
     * The field will be set to its default value. The hasControlblock_name()
     * method will return false.
     */
    inline void clearControlblock_name();

    /**
     * Checks whether the field "controlblock_name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlblock_name()). Otherwise it will return false.
     */
    inline bool hasControlblock_name () const;

    /**
     * Returns the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "controlblock_name"
     */
    inline const ::std::string& getControlblock_name () const;

    /**
     * Retrieves the value of the field "controlblock_name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "controlblock_name".
     */
    inline ::std::string& getControlblock_nameMutable ();

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const ::std::string& controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* controlblock_name_);

    /**
     * Sets the value of the member "controlblock_name".
     *
     * If the meaning of "controlblock_name" isn't clear, then there should be a description here.
     *
     * @param controlblock_name The value which will be set
     */
    inline void setControlblock_name (const char* value, size_t size);

    // API of field "data"

    static const int kData = 2;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::asf::dbus::DBusVariant& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::asf::dbus::DBusVariant& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::asf::dbus::DBusVariant& data_);

    // API of field "listData"

    static const int kListData = 3;

    /**
     * Clears the field "listData".
     *
     * The field will be set to its default value. The hasListData()
     * method will return false.
     */
    inline void clearListData();

    /**
     * Checks whether the field "listData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListData()). Otherwise it will return false.
     */
    inline bool hasListData () const;

    /**
     * Returns the value of the member "listData".
     *
     * If the meaning of "listData" isn't clear, then there should be a description here.
     *
     * @return The value of the field "listData"
     */
    inline const ::asf::dbus::DBusVariant& getListData () const;

    /**
     * Retrieves the value of the field "listData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listData".
     */
    inline ::asf::dbus::DBusVariant& getListDataMutable ();

    /**
     * Sets the value of the member "listData".
     *
     * If the meaning of "listData" isn't clear, then there should be a description here.
     *
     * @param listData The value which will be set
     */
    inline void setListData (const ::asf::dbus::DBusVariant& listData_);

    static const PluginListUpdateSignal &getDefaultInstance();

private:

    inline void set_has_plugin_name ();

    inline void clear_has_plugin_name ();

    inline void set_has_controlblock_name ();

    inline void clear_has_controlblock_name ();

    inline void set_has_data ();

    inline void clear_has_data ();

    inline void set_has_listData ();

    inline void clear_has_listData ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _plugin_name;

    ::std::string _controlblock_name;

    ::asf::dbus::DBusVariant _data;

    ::asf::dbus::DBusVariant _listData;

};

/**
 * If the meaning of "Sig_DBStatusSignal" isn't clear, then there should be a description here.
 */
class Sig_DBStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_DBStatusSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_DBStatusSignal (const Sig_DBStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_DBStatusSignal (uint16 DbState_, uint16 SourceType_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_DBStatusSignal();

    /**
     * Assignment operator
     */
    inline Sig_DBStatusSignal& operator = (const Sig_DBStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_DBStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_DBStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_DBStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_DBStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DbState"

    static const int kDbState = 0;

    /**
     * Clears the field "DbState".
     *
     * The field will be set to its default value. The hasDbState()
     * method will return false.
     */
    inline void clearDbState();

    /**
     * Checks whether the field "DbState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDbState()). Otherwise it will return false.
     */
    inline bool hasDbState () const;

    /**
     * Returns the value of the member "DbState".
     *
     * If the meaning of "DbState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DbState"
     */
    inline uint16 getDbState () const;

    /**
     * Sets the value of the member "DbState".
     *
     * If the meaning of "DbState" isn't clear, then there should be a description here.
     *
     * @param DbState The value which will be set
     */
    inline void setDbState (uint16 DbState_);

    // API of field "SourceType"

    static const int kSourceType = 1;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline uint16 getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (uint16 SourceType_);

    static const Sig_DBStatusSignal &getDefaultInstance();

private:

    inline void set_has_DbState ();

    inline void clear_has_DbState ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _DbState;

    uint16 _SourceType;

};

/**
 * If the meaning of "Sig_PlayStatusSignalPlayStateStruct" isn't clear, then there should be a description here.
 */
class Sig_PlayStatusSignalPlayStateStruct {
public:

    /**
     * Default constructor
     */
    inline  Sig_PlayStatusSignalPlayStateStruct ();

    /**
     * Copy constructor
     */
    inline  Sig_PlayStatusSignalPlayStateStruct (const Sig_PlayStatusSignalPlayStateStruct &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_PlayStatusSignalPlayStateStruct (bool elem1_, uint16 elem2_, int32 elem3_, uint16 elem4_, uint16 elem5_, uint16 elem6_, uint16 elem7_, const ::std::string& elem8_);

    /**
     * Destructor
     */
    inline  ~Sig_PlayStatusSignalPlayStateStruct();

    /**
     * Assignment operator
     */
    inline Sig_PlayStatusSignalPlayStateStruct& operator = (const Sig_PlayStatusSignalPlayStateStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_PlayStatusSignalPlayStateStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_PlayStatusSignalPlayStateStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_PlayStatusSignalPlayStateStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_PlayStatusSignalPlayStateStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline bool getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (bool elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline int32 getElem3 () const;

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (int32 elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline uint16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (uint16 elem4_);

    // API of field "elem5"

    static const int kElem5 = 4;

    /**
     * Clears the field "elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem5"
     */
    inline uint16 getElem5 () const;

    /**
     * Sets the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @param elem5 The value which will be set
     */
    inline void setElem5 (uint16 elem5_);

    // API of field "elem6"

    static const int kElem6 = 5;

    /**
     * Clears the field "elem6".
     *
     * The field will be set to its default value. The hasElem6()
     * method will return false.
     */
    inline void clearElem6();

    /**
     * Checks whether the field "elem6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem6()). Otherwise it will return false.
     */
    inline bool hasElem6 () const;

    /**
     * Returns the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem6"
     */
    inline uint16 getElem6 () const;

    /**
     * Sets the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @param elem6 The value which will be set
     */
    inline void setElem6 (uint16 elem6_);

    // API of field "elem7"

    static const int kElem7 = 6;

    /**
     * Clears the field "elem7".
     *
     * The field will be set to its default value. The hasElem7()
     * method will return false.
     */
    inline void clearElem7();

    /**
     * Checks whether the field "elem7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem7()). Otherwise it will return false.
     */
    inline bool hasElem7 () const;

    /**
     * Returns the value of the member "elem7".
     *
     * If the meaning of "elem7" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem7"
     */
    inline uint16 getElem7 () const;

    /**
     * Sets the value of the member "elem7".
     *
     * If the meaning of "elem7" isn't clear, then there should be a description here.
     *
     * @param elem7 The value which will be set
     */
    inline void setElem7 (uint16 elem7_);

    // API of field "elem8"

    static const int kElem8 = 7;

    /**
     * Clears the field "elem8".
     *
     * The field will be set to its default value. The hasElem8()
     * method will return false.
     */
    inline void clearElem8();

    /**
     * Checks whether the field "elem8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem8()). Otherwise it will return false.
     */
    inline bool hasElem8 () const;

    /**
     * Returns the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem8"
     */
    inline const ::std::string& getElem8 () const;

    /**
     * Retrieves the value of the field "elem8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem8".
     */
    inline ::std::string& getElem8Mutable ();

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const ::std::string& elem8_);

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const char* elem8_);

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const char* value, size_t size);

    static const Sig_PlayStatusSignalPlayStateStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    inline void set_has_elem5 ();

    inline void clear_has_elem5 ();

    inline void set_has_elem6 ();

    inline void clear_has_elem6 ();

    inline void set_has_elem7 ();

    inline void clear_has_elem7 ();

    inline void set_has_elem8 ();

    inline void clear_has_elem8 ();

    uint32 _has_bits_[ (8 + 31) / 32];

    bool _elem1;

    uint16 _elem2;

    int32 _elem3;

    uint16 _elem4;

    uint16 _elem5;

    uint16 _elem6;

    uint16 _elem7;

    ::std::string _elem8;

};

/**
 * If the meaning of "Sig_PlayStatusSignal" isn't clear, then there should be a description here.
 */
class Sig_PlayStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_PlayStatusSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_PlayStatusSignal (const Sig_PlayStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_PlayStatusSignal (const Sig_PlayStatusSignalPlayStateStruct& PlayState_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_PlayStatusSignal();

    /**
     * Assignment operator
     */
    inline Sig_PlayStatusSignal& operator = (const Sig_PlayStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_PlayStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_PlayStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_PlayStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_PlayStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PlayState"

    static const int kPlayState = 0;

    /**
     * Clears the field "PlayState".
     *
     * The field will be set to its default value. The hasPlayState()
     * method will return false.
     */
    inline void clearPlayState();

    /**
     * Checks whether the field "PlayState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPlayState()). Otherwise it will return false.
     */
    inline bool hasPlayState () const;

    /**
     * Returns the value of the member "PlayState".
     *
     * If the meaning of "PlayState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PlayState"
     */
    inline const Sig_PlayStatusSignalPlayStateStruct& getPlayState () const;

    /**
     * Retrieves the value of the field "PlayState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PlayState".
     */
    inline Sig_PlayStatusSignalPlayStateStruct& getPlayStateMutable ();

    /**
     * Sets the value of the member "PlayState".
     *
     * If the meaning of "PlayState" isn't clear, then there should be a description here.
     *
     * @param PlayState The value which will be set
     */
    inline void setPlayState (const Sig_PlayStatusSignalPlayStateStruct& PlayState_);

    static const Sig_PlayStatusSignal &getDefaultInstance();

private:

    inline void set_has_PlayState ();

    inline void clear_has_PlayState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Sig_PlayStatusSignalPlayStateStruct _PlayState;

};

/**
 * If the meaning of "Sig_ReqTrackIndexSignalTrackReqInfoStruct" isn't clear, then there should be a description here.
 */
class Sig_ReqTrackIndexSignalTrackReqInfoStruct {
public:

    /**
     * Default constructor
     */
    inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct ();

    /**
     * Copy constructor
     */
    inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct (const Sig_ReqTrackIndexSignalTrackReqInfoStruct &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct (uint16 elem1_, uint16 elem2_, uint16 elem3_, uint16 elem4_, uint16 elem5_, uint16 elem6_, uint16 elem7_, const ::std::string& elem8_);

    /**
     * Destructor
     */
    inline  ~Sig_ReqTrackIndexSignalTrackReqInfoStruct();

    /**
     * Assignment operator
     */
    inline Sig_ReqTrackIndexSignalTrackReqInfoStruct& operator = (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline uint16 getElem1 () const;

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (uint16 elem1_);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline uint16 getElem2 () const;

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (uint16 elem2_);

    // API of field "elem3"

    static const int kElem3 = 2;

    /**
     * Clears the field "elem3".
     *
     * The field will be set to its default value. The hasElem3()
     * method will return false.
     */
    inline void clearElem3();

    /**
     * Checks whether the field "elem3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem3()). Otherwise it will return false.
     */
    inline bool hasElem3 () const;

    /**
     * Returns the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem3"
     */
    inline uint16 getElem3 () const;

    /**
     * Sets the value of the member "elem3".
     *
     * If the meaning of "elem3" isn't clear, then there should be a description here.
     *
     * @param elem3 The value which will be set
     */
    inline void setElem3 (uint16 elem3_);

    // API of field "elem4"

    static const int kElem4 = 3;

    /**
     * Clears the field "elem4".
     *
     * The field will be set to its default value. The hasElem4()
     * method will return false.
     */
    inline void clearElem4();

    /**
     * Checks whether the field "elem4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem4()). Otherwise it will return false.
     */
    inline bool hasElem4 () const;

    /**
     * Returns the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem4"
     */
    inline uint16 getElem4 () const;

    /**
     * Sets the value of the member "elem4".
     *
     * If the meaning of "elem4" isn't clear, then there should be a description here.
     *
     * @param elem4 The value which will be set
     */
    inline void setElem4 (uint16 elem4_);

    // API of field "elem5"

    static const int kElem5 = 4;

    /**
     * Clears the field "elem5".
     *
     * The field will be set to its default value. The hasElem5()
     * method will return false.
     */
    inline void clearElem5();

    /**
     * Checks whether the field "elem5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem5()). Otherwise it will return false.
     */
    inline bool hasElem5 () const;

    /**
     * Returns the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem5"
     */
    inline uint16 getElem5 () const;

    /**
     * Sets the value of the member "elem5".
     *
     * If the meaning of "elem5" isn't clear, then there should be a description here.
     *
     * @param elem5 The value which will be set
     */
    inline void setElem5 (uint16 elem5_);

    // API of field "elem6"

    static const int kElem6 = 5;

    /**
     * Clears the field "elem6".
     *
     * The field will be set to its default value. The hasElem6()
     * method will return false.
     */
    inline void clearElem6();

    /**
     * Checks whether the field "elem6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem6()). Otherwise it will return false.
     */
    inline bool hasElem6 () const;

    /**
     * Returns the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem6"
     */
    inline uint16 getElem6 () const;

    /**
     * Sets the value of the member "elem6".
     *
     * If the meaning of "elem6" isn't clear, then there should be a description here.
     *
     * @param elem6 The value which will be set
     */
    inline void setElem6 (uint16 elem6_);

    // API of field "elem7"

    static const int kElem7 = 6;

    /**
     * Clears the field "elem7".
     *
     * The field will be set to its default value. The hasElem7()
     * method will return false.
     */
    inline void clearElem7();

    /**
     * Checks whether the field "elem7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem7()). Otherwise it will return false.
     */
    inline bool hasElem7 () const;

    /**
     * Returns the value of the member "elem7".
     *
     * If the meaning of "elem7" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem7"
     */
    inline uint16 getElem7 () const;

    /**
     * Sets the value of the member "elem7".
     *
     * If the meaning of "elem7" isn't clear, then there should be a description here.
     *
     * @param elem7 The value which will be set
     */
    inline void setElem7 (uint16 elem7_);

    // API of field "elem8"

    static const int kElem8 = 7;

    /**
     * Clears the field "elem8".
     *
     * The field will be set to its default value. The hasElem8()
     * method will return false.
     */
    inline void clearElem8();

    /**
     * Checks whether the field "elem8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem8()). Otherwise it will return false.
     */
    inline bool hasElem8 () const;

    /**
     * Returns the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem8"
     */
    inline const ::std::string& getElem8 () const;

    /**
     * Retrieves the value of the field "elem8" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem8".
     */
    inline ::std::string& getElem8Mutable ();

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const ::std::string& elem8_);

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const char* elem8_);

    /**
     * Sets the value of the member "elem8".
     *
     * If the meaning of "elem8" isn't clear, then there should be a description here.
     *
     * @param elem8 The value which will be set
     */
    inline void setElem8 (const char* value, size_t size);

    static const Sig_ReqTrackIndexSignalTrackReqInfoStruct &getDefaultInstance();

private:

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    inline void set_has_elem3 ();

    inline void clear_has_elem3 ();

    inline void set_has_elem4 ();

    inline void clear_has_elem4 ();

    inline void set_has_elem5 ();

    inline void clear_has_elem5 ();

    inline void set_has_elem6 ();

    inline void clear_has_elem6 ();

    inline void set_has_elem7 ();

    inline void clear_has_elem7 ();

    inline void set_has_elem8 ();

    inline void clear_has_elem8 ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint16 _elem1;

    uint16 _elem2;

    uint16 _elem3;

    uint16 _elem4;

    uint16 _elem5;

    uint16 _elem6;

    uint16 _elem7;

    ::std::string _elem8;

};

/**
 * If the meaning of "Sig_ReqTrackIndexSignal" isn't clear, then there should be a description here.
 */
class Sig_ReqTrackIndexSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_ReqTrackIndexSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_ReqTrackIndexSignal (const Sig_ReqTrackIndexSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_ReqTrackIndexSignal (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& TrackReqInfo_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_ReqTrackIndexSignal();

    /**
     * Assignment operator
     */
    inline Sig_ReqTrackIndexSignal& operator = (const Sig_ReqTrackIndexSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_ReqTrackIndexSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_ReqTrackIndexSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_ReqTrackIndexSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_ReqTrackIndexSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TrackReqInfo"

    static const int kTrackReqInfo = 0;

    /**
     * Clears the field "TrackReqInfo".
     *
     * The field will be set to its default value. The hasTrackReqInfo()
     * method will return false.
     */
    inline void clearTrackReqInfo();

    /**
     * Checks whether the field "TrackReqInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackReqInfo()). Otherwise it will return false.
     */
    inline bool hasTrackReqInfo () const;

    /**
     * Returns the value of the member "TrackReqInfo".
     *
     * If the meaning of "TrackReqInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TrackReqInfo"
     */
    inline const Sig_ReqTrackIndexSignalTrackReqInfoStruct& getTrackReqInfo () const;

    /**
     * Retrieves the value of the field "TrackReqInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TrackReqInfo".
     */
    inline Sig_ReqTrackIndexSignalTrackReqInfoStruct& getTrackReqInfoMutable ();

    /**
     * Sets the value of the member "TrackReqInfo".
     *
     * If the meaning of "TrackReqInfo" isn't clear, then there should be a description here.
     *
     * @param TrackReqInfo The value which will be set
     */
    inline void setTrackReqInfo (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& TrackReqInfo_);

    static const Sig_ReqTrackIndexSignal &getDefaultInstance();

private:

    inline void set_has_TrackReqInfo ();

    inline void clear_has_TrackReqInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    Sig_ReqTrackIndexSignalTrackReqInfoStruct _TrackReqInfo;

};

/**
 * If the meaning of "Sig_CRCCheckStatusSignal" isn't clear, then there should be a description here.
 */
class Sig_CRCCheckStatusSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_CRCCheckStatusSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_CRCCheckStatusSignal (const Sig_CRCCheckStatusSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_CRCCheckStatusSignal (bool CRCStatus_, uint16 SourceType_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_CRCCheckStatusSignal();

    /**
     * Assignment operator
     */
    inline Sig_CRCCheckStatusSignal& operator = (const Sig_CRCCheckStatusSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_CRCCheckStatusSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_CRCCheckStatusSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_CRCCheckStatusSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_CRCCheckStatusSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CRCStatus"

    static const int kCRCStatus = 0;

    /**
     * Clears the field "CRCStatus".
     *
     * The field will be set to its default value. The hasCRCStatus()
     * method will return false.
     */
    inline void clearCRCStatus();

    /**
     * Checks whether the field "CRCStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCRCStatus()). Otherwise it will return false.
     */
    inline bool hasCRCStatus () const;

    /**
     * Returns the value of the member "CRCStatus".
     *
     * If the meaning of "CRCStatus" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CRCStatus"
     */
    inline bool getCRCStatus () const;

    /**
     * Sets the value of the member "CRCStatus".
     *
     * If the meaning of "CRCStatus" isn't clear, then there should be a description here.
     *
     * @param CRCStatus The value which will be set
     */
    inline void setCRCStatus (bool CRCStatus_);

    // API of field "SourceType"

    static const int kSourceType = 1;

    /**
     * Clears the field "SourceType".
     *
     * The field will be set to its default value. The hasSourceType()
     * method will return false.
     */
    inline void clearSourceType();

    /**
     * Checks whether the field "SourceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceType()). Otherwise it will return false.
     */
    inline bool hasSourceType () const;

    /**
     * Returns the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SourceType"
     */
    inline uint16 getSourceType () const;

    /**
     * Sets the value of the member "SourceType".
     *
     * If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param SourceType The value which will be set
     */
    inline void setSourceType (uint16 SourceType_);

    static const Sig_CRCCheckStatusSignal &getDefaultInstance();

private:

    inline void set_has_CRCStatus ();

    inline void clear_has_CRCStatus ();

    inline void set_has_SourceType ();

    inline void clear_has_SourceType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _CRCStatus;

    uint16 _SourceType;

};

inline  PluginCommandRequest::PluginCommandRequest ()  :
    _plugin_name (),
    _controlblock_name (),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PluginCommandRequest::PluginCommandRequest (const PluginCommandRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _plugin_name (),
    _controlblock_name (),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PluginCommandRequest::PluginCommandRequest (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_)  :
    _plugin_name (plugin_name_),
    _controlblock_name (controlblock_name_),
    _data (data_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PluginCommandRequest::~PluginCommandRequest() {
}

inline PluginCommandRequest& PluginCommandRequest::operator = (const PluginCommandRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlugin_name()) {
            setPlugin_name(rhs.getPlugin_name());
        } else {
            clearPlugin_name();
        }
        if (rhs.hasControlblock_name()) {
            setControlblock_name(rhs.getControlblock_name());
        } else {
            clearControlblock_name();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool PluginCommandRequest::operator == (const PluginCommandRequest& rhs) const {
    return (((!hasPlugin_name() && !rhs.hasPlugin_name()) || getPlugin_name() == rhs.getPlugin_name()) &&
        ((!hasControlblock_name() && !rhs.hasControlblock_name()) || getControlblock_name() == rhs.getControlblock_name()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool PluginCommandRequest::operator != (const PluginCommandRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PluginCommandRequest::operator < (const PluginCommandRequest& rhs) const {
    if (hasPlugin_name() || rhs.hasPlugin_name()) {
        if (getPlugin_name() < rhs.getPlugin_name()) return true;
        if (getPlugin_name() > rhs.getPlugin_name()) return false;
    }
    if (hasControlblock_name() || rhs.hasControlblock_name()) {
        if (getControlblock_name() < rhs.getControlblock_name()) return true;
        if (getControlblock_name() > rhs.getControlblock_name()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PluginCommandRequest::clone() {
    return new PluginCommandRequest(*this);
}

inline bool PluginCommandRequest::operator > (const PluginCommandRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PluginCommandRequest::clear() {
    clearPlugin_name();
    clearControlblock_name();
    clearData();
}

inline void PluginCommandRequest::clearPlugin_name() {
    if (hasPlugin_name()) {
         clear_has_plugin_name();
        _plugin_name.clear();
     }
}

inline bool PluginCommandRequest::hasPlugin_name () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PluginCommandRequest::getPlugin_name () const {
    return _plugin_name;
}

inline ::std::string& PluginCommandRequest::getPlugin_nameMutable () {
    set_has_plugin_name();
    return _plugin_name;
}

inline void PluginCommandRequest::setPlugin_name (const ::std::string& plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name = plugin_name_;
}

inline void PluginCommandRequest::setPlugin_name (const char* plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(plugin_name_);
}

inline void PluginCommandRequest::setPlugin_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(value, size);
}

inline void PluginCommandRequest::clearControlblock_name() {
    if (hasControlblock_name()) {
         clear_has_controlblock_name();
        _controlblock_name.clear();
     }
}

inline bool PluginCommandRequest::hasControlblock_name () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PluginCommandRequest::getControlblock_name () const {
    return _controlblock_name;
}

inline ::std::string& PluginCommandRequest::getControlblock_nameMutable () {
    set_has_controlblock_name();
    return _controlblock_name;
}

inline void PluginCommandRequest::setControlblock_name (const ::std::string& controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name = controlblock_name_;
}

inline void PluginCommandRequest::setControlblock_name (const char* controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(controlblock_name_);
}

inline void PluginCommandRequest::setControlblock_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(value, size);
}

inline void PluginCommandRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginCommandRequest::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginCommandRequest::getData () const {
    return _data;
}

inline ::asf::dbus::DBusVariant& PluginCommandRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void PluginCommandRequest::setData (const ::asf::dbus::DBusVariant& data_) {
    set_has_data();
    this->_data = data_;
}

inline void PluginCommandRequest::set_has_plugin_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PluginCommandRequest::clear_has_plugin_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PluginCommandRequest::set_has_controlblock_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void PluginCommandRequest::clear_has_controlblock_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PluginCommandRequest::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void PluginCommandRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PluginListCommandRequest::PluginListCommandRequest ()  :
    _plugin_name (),
    _controlblock_name (),
    _data (),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PluginListCommandRequest::PluginListCommandRequest (const PluginListCommandRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _plugin_name (),
    _controlblock_name (),
    _data (),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PluginListCommandRequest::PluginListCommandRequest (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_, const ::asf::dbus::DBusVariant& listData_)  :
    _plugin_name (plugin_name_),
    _controlblock_name (controlblock_name_),
    _data (data_),
    _listData (listData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PluginListCommandRequest::~PluginListCommandRequest() {
}

inline PluginListCommandRequest& PluginListCommandRequest::operator = (const PluginListCommandRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlugin_name()) {
            setPlugin_name(rhs.getPlugin_name());
        } else {
            clearPlugin_name();
        }
        if (rhs.hasControlblock_name()) {
            setControlblock_name(rhs.getControlblock_name());
        } else {
            clearControlblock_name();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasListData()) {
            setListData(rhs.getListData());
        } else {
            clearListData();
        }
    }
    return *this;
}

inline bool PluginListCommandRequest::operator == (const PluginListCommandRequest& rhs) const {
    return (((!hasPlugin_name() && !rhs.hasPlugin_name()) || getPlugin_name() == rhs.getPlugin_name()) &&
        ((!hasControlblock_name() && !rhs.hasControlblock_name()) || getControlblock_name() == rhs.getControlblock_name()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasListData() && !rhs.hasListData()) || getListData() == rhs.getListData()));
}

inline bool PluginListCommandRequest::operator != (const PluginListCommandRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PluginListCommandRequest::operator < (const PluginListCommandRequest& rhs) const {
    if (hasPlugin_name() || rhs.hasPlugin_name()) {
        if (getPlugin_name() < rhs.getPlugin_name()) return true;
        if (getPlugin_name() > rhs.getPlugin_name()) return false;
    }
    if (hasControlblock_name() || rhs.hasControlblock_name()) {
        if (getControlblock_name() < rhs.getControlblock_name()) return true;
        if (getControlblock_name() > rhs.getControlblock_name()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasListData() || rhs.hasListData()) {
        if (getListData() < rhs.getListData()) return true;
        if (getListData() > rhs.getListData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PluginListCommandRequest::clone() {
    return new PluginListCommandRequest(*this);
}

inline bool PluginListCommandRequest::operator > (const PluginListCommandRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PluginListCommandRequest::clear() {
    clearPlugin_name();
    clearControlblock_name();
    clearData();
    clearListData();
}

inline void PluginListCommandRequest::clearPlugin_name() {
    if (hasPlugin_name()) {
         clear_has_plugin_name();
        _plugin_name.clear();
     }
}

inline bool PluginListCommandRequest::hasPlugin_name () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PluginListCommandRequest::getPlugin_name () const {
    return _plugin_name;
}

inline ::std::string& PluginListCommandRequest::getPlugin_nameMutable () {
    set_has_plugin_name();
    return _plugin_name;
}

inline void PluginListCommandRequest::setPlugin_name (const ::std::string& plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name = plugin_name_;
}

inline void PluginListCommandRequest::setPlugin_name (const char* plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(plugin_name_);
}

inline void PluginListCommandRequest::setPlugin_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(value, size);
}

inline void PluginListCommandRequest::clearControlblock_name() {
    if (hasControlblock_name()) {
         clear_has_controlblock_name();
        _controlblock_name.clear();
     }
}

inline bool PluginListCommandRequest::hasControlblock_name () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PluginListCommandRequest::getControlblock_name () const {
    return _controlblock_name;
}

inline ::std::string& PluginListCommandRequest::getControlblock_nameMutable () {
    set_has_controlblock_name();
    return _controlblock_name;
}

inline void PluginListCommandRequest::setControlblock_name (const ::std::string& controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name = controlblock_name_;
}

inline void PluginListCommandRequest::setControlblock_name (const char* controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(controlblock_name_);
}

inline void PluginListCommandRequest::setControlblock_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(value, size);
}

inline void PluginListCommandRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginListCommandRequest::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginListCommandRequest::getData () const {
    return _data;
}

inline ::asf::dbus::DBusVariant& PluginListCommandRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void PluginListCommandRequest::setData (const ::asf::dbus::DBusVariant& data_) {
    set_has_data();
    this->_data = data_;
}

inline void PluginListCommandRequest::clearListData() {
    if (hasListData()) {
         clear_has_listData();
        _listData = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginListCommandRequest::hasListData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginListCommandRequest::getListData () const {
    return _listData;
}

inline ::asf::dbus::DBusVariant& PluginListCommandRequest::getListDataMutable () {
    set_has_listData();
    return _listData;
}

inline void PluginListCommandRequest::setListData (const ::asf::dbus::DBusVariant& listData_) {
    set_has_listData();
    this->_listData = listData_;
}

inline void PluginListCommandRequest::set_has_plugin_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PluginListCommandRequest::clear_has_plugin_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PluginListCommandRequest::set_has_controlblock_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void PluginListCommandRequest::clear_has_controlblock_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PluginListCommandRequest::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void PluginListCommandRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PluginListCommandRequest::set_has_listData () {
    _has_bits_[0] |= 1u << 3;
}

inline void PluginListCommandRequest::clear_has_listData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  EndStationListUpdateUpdate::EndStationListUpdateUpdate ()  :
    _EndStationListUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EndStationListUpdateUpdate::EndStationListUpdateUpdate (const EndStationListUpdateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _EndStationListUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EndStationListUpdateUpdate::EndStationListUpdateUpdate (const ::asf::dbus::DBusVariant& EndStationListUpdate_)  :
    _EndStationListUpdate (EndStationListUpdate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EndStationListUpdateUpdate::~EndStationListUpdateUpdate() {
}

inline EndStationListUpdateUpdate& EndStationListUpdateUpdate::operator = (const EndStationListUpdateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEndStationListUpdate()) {
            setEndStationListUpdate(rhs.getEndStationListUpdate());
        } else {
            clearEndStationListUpdate();
        }
    }
    return *this;
}

inline bool EndStationListUpdateUpdate::operator == (const EndStationListUpdateUpdate& rhs) const {
    return (((!hasEndStationListUpdate() && !rhs.hasEndStationListUpdate()) || getEndStationListUpdate() == rhs.getEndStationListUpdate()));
}

inline bool EndStationListUpdateUpdate::operator != (const EndStationListUpdateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EndStationListUpdateUpdate::operator < (const EndStationListUpdateUpdate& rhs) const {
    if (hasEndStationListUpdate() || rhs.hasEndStationListUpdate()) {
        if (getEndStationListUpdate() < rhs.getEndStationListUpdate()) return true;
        if (getEndStationListUpdate() > rhs.getEndStationListUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EndStationListUpdateUpdate::clone() {
    return new EndStationListUpdateUpdate(*this);
}

inline bool EndStationListUpdateUpdate::operator > (const EndStationListUpdateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EndStationListUpdateUpdate::clear() {
    clearEndStationListUpdate();
}

inline void EndStationListUpdateUpdate::clearEndStationListUpdate() {
    if (hasEndStationListUpdate()) {
         clear_has_EndStationListUpdate();
        _EndStationListUpdate = ::asf::dbus::DBusVariant ();
     }
}

inline bool EndStationListUpdateUpdate::hasEndStationListUpdate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::asf::dbus::DBusVariant& EndStationListUpdateUpdate::getEndStationListUpdate () const {
    return _EndStationListUpdate;
}

inline ::asf::dbus::DBusVariant& EndStationListUpdateUpdate::getEndStationListUpdateMutable () {
    set_has_EndStationListUpdate();
    return _EndStationListUpdate;
}

inline void EndStationListUpdateUpdate::setEndStationListUpdate (const ::asf::dbus::DBusVariant& EndStationListUpdate_) {
    set_has_EndStationListUpdate();
    this->_EndStationListUpdate = EndStationListUpdate_;
}

inline void EndStationListUpdateUpdate::set_has_EndStationListUpdate () {
    _has_bits_[0] |= 1u << 0;
}

inline void EndStationListUpdateUpdate::clear_has_EndStationListUpdate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EndStationListUpdateRegister::EndStationListUpdateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EndStationListUpdateRegister::EndStationListUpdateRegister (const EndStationListUpdateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EndStationListUpdateRegister::~EndStationListUpdateRegister() {
}

inline EndStationListUpdateRegister& EndStationListUpdateRegister::operator = (const EndStationListUpdateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EndStationListUpdateRegister::operator == (const EndStationListUpdateRegister& ) const {
    return true;
}

inline bool EndStationListUpdateRegister::operator != (const EndStationListUpdateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EndStationListUpdateRegister::operator < (const EndStationListUpdateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EndStationListUpdateRegister::clone() {
    return new EndStationListUpdateRegister(*this);
}

inline bool EndStationListUpdateRegister::operator > (const EndStationListUpdateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EndStationListUpdateRegister::clear() {
}

inline  EntityDetailsUpdateUpdate::EntityDetailsUpdateUpdate ()  :
    _EntityDetailsUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EntityDetailsUpdateUpdate::EntityDetailsUpdateUpdate (const EntityDetailsUpdateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _EntityDetailsUpdate ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EntityDetailsUpdateUpdate::EntityDetailsUpdateUpdate (const ::asf::dbus::DBusVariant& EntityDetailsUpdate_)  :
    _EntityDetailsUpdate (EntityDetailsUpdate_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EntityDetailsUpdateUpdate::~EntityDetailsUpdateUpdate() {
}

inline EntityDetailsUpdateUpdate& EntityDetailsUpdateUpdate::operator = (const EntityDetailsUpdateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEntityDetailsUpdate()) {
            setEntityDetailsUpdate(rhs.getEntityDetailsUpdate());
        } else {
            clearEntityDetailsUpdate();
        }
    }
    return *this;
}

inline bool EntityDetailsUpdateUpdate::operator == (const EntityDetailsUpdateUpdate& rhs) const {
    return (((!hasEntityDetailsUpdate() && !rhs.hasEntityDetailsUpdate()) || getEntityDetailsUpdate() == rhs.getEntityDetailsUpdate()));
}

inline bool EntityDetailsUpdateUpdate::operator != (const EntityDetailsUpdateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool EntityDetailsUpdateUpdate::operator < (const EntityDetailsUpdateUpdate& rhs) const {
    if (hasEntityDetailsUpdate() || rhs.hasEntityDetailsUpdate()) {
        if (getEntityDetailsUpdate() < rhs.getEntityDetailsUpdate()) return true;
        if (getEntityDetailsUpdate() > rhs.getEntityDetailsUpdate()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EntityDetailsUpdateUpdate::clone() {
    return new EntityDetailsUpdateUpdate(*this);
}

inline bool EntityDetailsUpdateUpdate::operator > (const EntityDetailsUpdateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EntityDetailsUpdateUpdate::clear() {
    clearEntityDetailsUpdate();
}

inline void EntityDetailsUpdateUpdate::clearEntityDetailsUpdate() {
    if (hasEntityDetailsUpdate()) {
         clear_has_EntityDetailsUpdate();
        _EntityDetailsUpdate = ::asf::dbus::DBusVariant ();
     }
}

inline bool EntityDetailsUpdateUpdate::hasEntityDetailsUpdate () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::asf::dbus::DBusVariant& EntityDetailsUpdateUpdate::getEntityDetailsUpdate () const {
    return _EntityDetailsUpdate;
}

inline ::asf::dbus::DBusVariant& EntityDetailsUpdateUpdate::getEntityDetailsUpdateMutable () {
    set_has_EntityDetailsUpdate();
    return _EntityDetailsUpdate;
}

inline void EntityDetailsUpdateUpdate::setEntityDetailsUpdate (const ::asf::dbus::DBusVariant& EntityDetailsUpdate_) {
    set_has_EntityDetailsUpdate();
    this->_EntityDetailsUpdate = EntityDetailsUpdate_;
}

inline void EntityDetailsUpdateUpdate::set_has_EntityDetailsUpdate () {
    _has_bits_[0] |= 1u << 0;
}

inline void EntityDetailsUpdateUpdate::clear_has_EntityDetailsUpdate () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EntityDetailsUpdateRegister::EntityDetailsUpdateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EntityDetailsUpdateRegister::EntityDetailsUpdateRegister (const EntityDetailsUpdateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EntityDetailsUpdateRegister::~EntityDetailsUpdateRegister() {
}

inline EntityDetailsUpdateRegister& EntityDetailsUpdateRegister::operator = (const EntityDetailsUpdateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool EntityDetailsUpdateRegister::operator == (const EntityDetailsUpdateRegister& ) const {
    return true;
}

inline bool EntityDetailsUpdateRegister::operator != (const EntityDetailsUpdateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool EntityDetailsUpdateRegister::operator < (const EntityDetailsUpdateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* EntityDetailsUpdateRegister::clone() {
    return new EntityDetailsUpdateRegister(*this);
}

inline bool EntityDetailsUpdateRegister::operator > (const EntityDetailsUpdateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EntityDetailsUpdateRegister::clear() {
}

inline  PlayBackModeStruct::PlayBackModeStruct ()  :
    _elem1 (0),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PlayBackModeStruct::PlayBackModeStruct (const PlayBackModeStruct &rhs)  :
    _elem1 (0),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PlayBackModeStruct::PlayBackModeStruct (int32 elem1_, uint16 elem2_, uint16 elem3_, int32 elem4_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PlayBackModeStruct::~PlayBackModeStruct() {
}

inline PlayBackModeStruct& PlayBackModeStruct::operator = (const PlayBackModeStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
    }
    return *this;
}

inline bool PlayBackModeStruct::operator == (const PlayBackModeStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()));
}

inline bool PlayBackModeStruct::operator != (const PlayBackModeStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool PlayBackModeStruct::operator < (const PlayBackModeStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    return false;
}

inline bool PlayBackModeStruct::operator > (const PlayBackModeStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PlayBackModeStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
}

inline void PlayBackModeStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool PlayBackModeStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 PlayBackModeStruct::getElem1 () const {
    return _elem1;
}

inline void PlayBackModeStruct::setElem1 (int32 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void PlayBackModeStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool PlayBackModeStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 PlayBackModeStruct::getElem2 () const {
    return _elem2;
}

inline void PlayBackModeStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void PlayBackModeStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3 = 0u;
     }
}

inline bool PlayBackModeStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 PlayBackModeStruct::getElem3 () const {
    return _elem3;
}

inline void PlayBackModeStruct::setElem3 (uint16 elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void PlayBackModeStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0;
     }
}

inline bool PlayBackModeStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 PlayBackModeStruct::getElem4 () const {
    return _elem4;
}

inline void PlayBackModeStruct::setElem4 (int32 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void PlayBackModeStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void PlayBackModeStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PlayBackModeStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void PlayBackModeStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PlayBackModeStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void PlayBackModeStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PlayBackModeStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void PlayBackModeStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  PlayBackModeUpdate::PlayBackModeUpdate ()  :
    _PlayBackMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PlayBackModeUpdate::PlayBackModeUpdate (const PlayBackModeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _PlayBackMode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PlayBackModeUpdate::PlayBackModeUpdate (const PlayBackModeStruct& PlayBackMode_)  :
    _PlayBackMode (PlayBackMode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PlayBackModeUpdate::~PlayBackModeUpdate() {
}

inline PlayBackModeUpdate& PlayBackModeUpdate::operator = (const PlayBackModeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlayBackMode()) {
            setPlayBackMode(rhs.getPlayBackMode());
        } else {
            clearPlayBackMode();
        }
    }
    return *this;
}

inline bool PlayBackModeUpdate::operator == (const PlayBackModeUpdate& rhs) const {
    return (((!hasPlayBackMode() && !rhs.hasPlayBackMode()) || getPlayBackMode() == rhs.getPlayBackMode()));
}

inline bool PlayBackModeUpdate::operator != (const PlayBackModeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool PlayBackModeUpdate::operator < (const PlayBackModeUpdate& rhs) const {
    if (hasPlayBackMode() || rhs.hasPlayBackMode()) {
        if (getPlayBackMode() < rhs.getPlayBackMode()) return true;
        if (getPlayBackMode() > rhs.getPlayBackMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PlayBackModeUpdate::clone() {
    return new PlayBackModeUpdate(*this);
}

inline bool PlayBackModeUpdate::operator > (const PlayBackModeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PlayBackModeUpdate::clear() {
    clearPlayBackMode();
}

inline void PlayBackModeUpdate::clearPlayBackMode() {
    if (hasPlayBackMode()) {
         clear_has_PlayBackMode();
        _PlayBackMode.clear();
     }
}

inline bool PlayBackModeUpdate::hasPlayBackMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const PlayBackModeStruct& PlayBackModeUpdate::getPlayBackMode () const {
    return _PlayBackMode;
}

inline PlayBackModeStruct& PlayBackModeUpdate::getPlayBackModeMutable () {
    set_has_PlayBackMode();
    return _PlayBackMode;
}

inline void PlayBackModeUpdate::setPlayBackMode (const PlayBackModeStruct& PlayBackMode_) {
    set_has_PlayBackMode();
    this->_PlayBackMode = PlayBackMode_;
}

inline void PlayBackModeUpdate::set_has_PlayBackMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void PlayBackModeUpdate::clear_has_PlayBackMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PlayBackModeRegister::PlayBackModeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PlayBackModeRegister::PlayBackModeRegister (const PlayBackModeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PlayBackModeRegister::~PlayBackModeRegister() {
}

inline PlayBackModeRegister& PlayBackModeRegister::operator = (const PlayBackModeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool PlayBackModeRegister::operator == (const PlayBackModeRegister& ) const {
    return true;
}

inline bool PlayBackModeRegister::operator != (const PlayBackModeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool PlayBackModeRegister::operator < (const PlayBackModeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* PlayBackModeRegister::clone() {
    return new PlayBackModeRegister(*this);
}

inline bool PlayBackModeRegister::operator > (const PlayBackModeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PlayBackModeRegister::clear() {
}

inline  ListAbsoluteTrackIndexStruct::ListAbsoluteTrackIndexStruct ()  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListAbsoluteTrackIndexStruct::ListAbsoluteTrackIndexStruct (const ListAbsoluteTrackIndexStruct &rhs)  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListAbsoluteTrackIndexStruct::ListAbsoluteTrackIndexStruct (uint32 elem1_, uint16 elem2_, uint16 elem3_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListAbsoluteTrackIndexStruct::~ListAbsoluteTrackIndexStruct() {
}

inline ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndexStruct::operator = (const ListAbsoluteTrackIndexStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
    }
    return *this;
}

inline bool ListAbsoluteTrackIndexStruct::operator == (const ListAbsoluteTrackIndexStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()));
}

inline bool ListAbsoluteTrackIndexStruct::operator != (const ListAbsoluteTrackIndexStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ListAbsoluteTrackIndexStruct::operator < (const ListAbsoluteTrackIndexStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    return false;
}

inline bool ListAbsoluteTrackIndexStruct::operator > (const ListAbsoluteTrackIndexStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListAbsoluteTrackIndexStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
}

inline void ListAbsoluteTrackIndexStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool ListAbsoluteTrackIndexStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ListAbsoluteTrackIndexStruct::getElem1 () const {
    return _elem1;
}

inline void ListAbsoluteTrackIndexStruct::setElem1 (uint32 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void ListAbsoluteTrackIndexStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool ListAbsoluteTrackIndexStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ListAbsoluteTrackIndexStruct::getElem2 () const {
    return _elem2;
}

inline void ListAbsoluteTrackIndexStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void ListAbsoluteTrackIndexStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3 = 0u;
     }
}

inline bool ListAbsoluteTrackIndexStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ListAbsoluteTrackIndexStruct::getElem3 () const {
    return _elem3;
}

inline void ListAbsoluteTrackIndexStruct::setElem3 (uint16 elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void ListAbsoluteTrackIndexStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListAbsoluteTrackIndexStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ListAbsoluteTrackIndexStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ListAbsoluteTrackIndexStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ListAbsoluteTrackIndexStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void ListAbsoluteTrackIndexStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ListAbsoluteTrackIndexUpdate::ListAbsoluteTrackIndexUpdate ()  :
    _ListAbsoluteTrackIndex ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListAbsoluteTrackIndexUpdate::ListAbsoluteTrackIndexUpdate (const ListAbsoluteTrackIndexUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _ListAbsoluteTrackIndex ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListAbsoluteTrackIndexUpdate::ListAbsoluteTrackIndexUpdate (const ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndex_)  :
    _ListAbsoluteTrackIndex (ListAbsoluteTrackIndex_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ListAbsoluteTrackIndexUpdate::~ListAbsoluteTrackIndexUpdate() {
}

inline ListAbsoluteTrackIndexUpdate& ListAbsoluteTrackIndexUpdate::operator = (const ListAbsoluteTrackIndexUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListAbsoluteTrackIndex()) {
            setListAbsoluteTrackIndex(rhs.getListAbsoluteTrackIndex());
        } else {
            clearListAbsoluteTrackIndex();
        }
    }
    return *this;
}

inline bool ListAbsoluteTrackIndexUpdate::operator == (const ListAbsoluteTrackIndexUpdate& rhs) const {
    return (((!hasListAbsoluteTrackIndex() && !rhs.hasListAbsoluteTrackIndex()) || getListAbsoluteTrackIndex() == rhs.getListAbsoluteTrackIndex()));
}

inline bool ListAbsoluteTrackIndexUpdate::operator != (const ListAbsoluteTrackIndexUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ListAbsoluteTrackIndexUpdate::operator < (const ListAbsoluteTrackIndexUpdate& rhs) const {
    if (hasListAbsoluteTrackIndex() || rhs.hasListAbsoluteTrackIndex()) {
        if (getListAbsoluteTrackIndex() < rhs.getListAbsoluteTrackIndex()) return true;
        if (getListAbsoluteTrackIndex() > rhs.getListAbsoluteTrackIndex()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ListAbsoluteTrackIndexUpdate::clone() {
    return new ListAbsoluteTrackIndexUpdate(*this);
}

inline bool ListAbsoluteTrackIndexUpdate::operator > (const ListAbsoluteTrackIndexUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListAbsoluteTrackIndexUpdate::clear() {
    clearListAbsoluteTrackIndex();
}

inline void ListAbsoluteTrackIndexUpdate::clearListAbsoluteTrackIndex() {
    if (hasListAbsoluteTrackIndex()) {
         clear_has_ListAbsoluteTrackIndex();
        _ListAbsoluteTrackIndex.clear();
     }
}

inline bool ListAbsoluteTrackIndexUpdate::hasListAbsoluteTrackIndex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndexUpdate::getListAbsoluteTrackIndex () const {
    return _ListAbsoluteTrackIndex;
}

inline ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndexUpdate::getListAbsoluteTrackIndexMutable () {
    set_has_ListAbsoluteTrackIndex();
    return _ListAbsoluteTrackIndex;
}

inline void ListAbsoluteTrackIndexUpdate::setListAbsoluteTrackIndex (const ListAbsoluteTrackIndexStruct& ListAbsoluteTrackIndex_) {
    set_has_ListAbsoluteTrackIndex();
    this->_ListAbsoluteTrackIndex = ListAbsoluteTrackIndex_;
}

inline void ListAbsoluteTrackIndexUpdate::set_has_ListAbsoluteTrackIndex () {
    _has_bits_[0] |= 1u << 0;
}

inline void ListAbsoluteTrackIndexUpdate::clear_has_ListAbsoluteTrackIndex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ListAbsoluteTrackIndexRegister::ListAbsoluteTrackIndexRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ListAbsoluteTrackIndexRegister::ListAbsoluteTrackIndexRegister (const ListAbsoluteTrackIndexRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ListAbsoluteTrackIndexRegister::~ListAbsoluteTrackIndexRegister() {
}

inline ListAbsoluteTrackIndexRegister& ListAbsoluteTrackIndexRegister::operator = (const ListAbsoluteTrackIndexRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ListAbsoluteTrackIndexRegister::operator == (const ListAbsoluteTrackIndexRegister& ) const {
    return true;
}

inline bool ListAbsoluteTrackIndexRegister::operator != (const ListAbsoluteTrackIndexRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ListAbsoluteTrackIndexRegister::operator < (const ListAbsoluteTrackIndexRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ListAbsoluteTrackIndexRegister::clone() {
    return new ListAbsoluteTrackIndexRegister(*this);
}

inline bool ListAbsoluteTrackIndexRegister::operator > (const ListAbsoluteTrackIndexRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ListAbsoluteTrackIndexRegister::clear() {
}

inline  DBStateStruct::DBStateStruct ()  :
    _elem1 (0),
    _elem2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBStateStruct::DBStateStruct (const DBStateStruct &rhs)  :
    _elem1 (0),
    _elem2 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBStateStruct::DBStateStruct (int32 elem1_, uint16 elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DBStateStruct::~DBStateStruct() {
}

inline DBStateStruct& DBStateStruct::operator = (const DBStateStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool DBStateStruct::operator == (const DBStateStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool DBStateStruct::operator != (const DBStateStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool DBStateStruct::operator < (const DBStateStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool DBStateStruct::operator > (const DBStateStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBStateStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void DBStateStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0;
     }
}

inline bool DBStateStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 DBStateStruct::getElem1 () const {
    return _elem1;
}

inline void DBStateStruct::setElem1 (int32 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void DBStateStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool DBStateStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 DBStateStruct::getElem2 () const {
    return _elem2;
}

inline void DBStateStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void DBStateStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void DBStateStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DBStateStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void DBStateStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DBStateUpdate::DBStateUpdate ()  :
    _DBState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBStateUpdate::DBStateUpdate (const DBStateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DBState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBStateUpdate::DBStateUpdate (const DBStateStruct& DBState_)  :
    _DBState (DBState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DBStateUpdate::~DBStateUpdate() {
}

inline DBStateUpdate& DBStateUpdate::operator = (const DBStateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDBState()) {
            setDBState(rhs.getDBState());
        } else {
            clearDBState();
        }
    }
    return *this;
}

inline bool DBStateUpdate::operator == (const DBStateUpdate& rhs) const {
    return (((!hasDBState() && !rhs.hasDBState()) || getDBState() == rhs.getDBState()));
}

inline bool DBStateUpdate::operator != (const DBStateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DBStateUpdate::operator < (const DBStateUpdate& rhs) const {
    if (hasDBState() || rhs.hasDBState()) {
        if (getDBState() < rhs.getDBState()) return true;
        if (getDBState() > rhs.getDBState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DBStateUpdate::clone() {
    return new DBStateUpdate(*this);
}

inline bool DBStateUpdate::operator > (const DBStateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBStateUpdate::clear() {
    clearDBState();
}

inline void DBStateUpdate::clearDBState() {
    if (hasDBState()) {
         clear_has_DBState();
        _DBState.clear();
     }
}

inline bool DBStateUpdate::hasDBState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const DBStateStruct& DBStateUpdate::getDBState () const {
    return _DBState;
}

inline DBStateStruct& DBStateUpdate::getDBStateMutable () {
    set_has_DBState();
    return _DBState;
}

inline void DBStateUpdate::setDBState (const DBStateStruct& DBState_) {
    set_has_DBState();
    this->_DBState = DBState_;
}

inline void DBStateUpdate::set_has_DBState () {
    _has_bits_[0] |= 1u << 0;
}

inline void DBStateUpdate::clear_has_DBState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DBStateRegister::DBStateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DBStateRegister::DBStateRegister (const DBStateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DBStateRegister::~DBStateRegister() {
}

inline DBStateRegister& DBStateRegister::operator = (const DBStateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DBStateRegister::operator == (const DBStateRegister& ) const {
    return true;
}

inline bool DBStateRegister::operator != (const DBStateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DBStateRegister::operator < (const DBStateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DBStateRegister::clone() {
    return new DBStateRegister(*this);
}

inline bool DBStateRegister::operator > (const DBStateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DBStateRegister::clear() {
}

inline  PluginUpdateSignal::PluginUpdateSignal ()  :
    _plugin_name (),
    _controlblock_name (),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PluginUpdateSignal::PluginUpdateSignal (const PluginUpdateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _plugin_name (),
    _controlblock_name (),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PluginUpdateSignal::PluginUpdateSignal (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_)  :
    _plugin_name (plugin_name_),
    _controlblock_name (controlblock_name_),
    _data (data_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PluginUpdateSignal::~PluginUpdateSignal() {
}

inline PluginUpdateSignal& PluginUpdateSignal::operator = (const PluginUpdateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlugin_name()) {
            setPlugin_name(rhs.getPlugin_name());
        } else {
            clearPlugin_name();
        }
        if (rhs.hasControlblock_name()) {
            setControlblock_name(rhs.getControlblock_name());
        } else {
            clearControlblock_name();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool PluginUpdateSignal::operator == (const PluginUpdateSignal& rhs) const {
    return (((!hasPlugin_name() && !rhs.hasPlugin_name()) || getPlugin_name() == rhs.getPlugin_name()) &&
        ((!hasControlblock_name() && !rhs.hasControlblock_name()) || getControlblock_name() == rhs.getControlblock_name()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool PluginUpdateSignal::operator != (const PluginUpdateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PluginUpdateSignal::operator < (const PluginUpdateSignal& rhs) const {
    if (hasPlugin_name() || rhs.hasPlugin_name()) {
        if (getPlugin_name() < rhs.getPlugin_name()) return true;
        if (getPlugin_name() > rhs.getPlugin_name()) return false;
    }
    if (hasControlblock_name() || rhs.hasControlblock_name()) {
        if (getControlblock_name() < rhs.getControlblock_name()) return true;
        if (getControlblock_name() > rhs.getControlblock_name()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PluginUpdateSignal::clone() {
    return new PluginUpdateSignal(*this);
}

inline bool PluginUpdateSignal::operator > (const PluginUpdateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PluginUpdateSignal::clear() {
    clearPlugin_name();
    clearControlblock_name();
    clearData();
}

inline void PluginUpdateSignal::clearPlugin_name() {
    if (hasPlugin_name()) {
         clear_has_plugin_name();
        _plugin_name.clear();
     }
}

inline bool PluginUpdateSignal::hasPlugin_name () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PluginUpdateSignal::getPlugin_name () const {
    return _plugin_name;
}

inline ::std::string& PluginUpdateSignal::getPlugin_nameMutable () {
    set_has_plugin_name();
    return _plugin_name;
}

inline void PluginUpdateSignal::setPlugin_name (const ::std::string& plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name = plugin_name_;
}

inline void PluginUpdateSignal::setPlugin_name (const char* plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(plugin_name_);
}

inline void PluginUpdateSignal::setPlugin_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(value, size);
}

inline void PluginUpdateSignal::clearControlblock_name() {
    if (hasControlblock_name()) {
         clear_has_controlblock_name();
        _controlblock_name.clear();
     }
}

inline bool PluginUpdateSignal::hasControlblock_name () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PluginUpdateSignal::getControlblock_name () const {
    return _controlblock_name;
}

inline ::std::string& PluginUpdateSignal::getControlblock_nameMutable () {
    set_has_controlblock_name();
    return _controlblock_name;
}

inline void PluginUpdateSignal::setControlblock_name (const ::std::string& controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name = controlblock_name_;
}

inline void PluginUpdateSignal::setControlblock_name (const char* controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(controlblock_name_);
}

inline void PluginUpdateSignal::setControlblock_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(value, size);
}

inline void PluginUpdateSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginUpdateSignal::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginUpdateSignal::getData () const {
    return _data;
}

inline ::asf::dbus::DBusVariant& PluginUpdateSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void PluginUpdateSignal::setData (const ::asf::dbus::DBusVariant& data_) {
    set_has_data();
    this->_data = data_;
}

inline void PluginUpdateSignal::set_has_plugin_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PluginUpdateSignal::clear_has_plugin_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PluginUpdateSignal::set_has_controlblock_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void PluginUpdateSignal::clear_has_controlblock_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PluginUpdateSignal::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void PluginUpdateSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  PluginListUpdateSignal::PluginListUpdateSignal ()  :
    _plugin_name (),
    _controlblock_name (),
    _data (),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PluginListUpdateSignal::PluginListUpdateSignal (const PluginListUpdateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _plugin_name (),
    _controlblock_name (),
    _data (),
    _listData ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PluginListUpdateSignal::PluginListUpdateSignal (const ::std::string& plugin_name_, const ::std::string& controlblock_name_, const ::asf::dbus::DBusVariant& data_, const ::asf::dbus::DBusVariant& listData_)  :
    _plugin_name (plugin_name_),
    _controlblock_name (controlblock_name_),
    _data (data_),
    _listData (listData_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PluginListUpdateSignal::~PluginListUpdateSignal() {
}

inline PluginListUpdateSignal& PluginListUpdateSignal::operator = (const PluginListUpdateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlugin_name()) {
            setPlugin_name(rhs.getPlugin_name());
        } else {
            clearPlugin_name();
        }
        if (rhs.hasControlblock_name()) {
            setControlblock_name(rhs.getControlblock_name());
        } else {
            clearControlblock_name();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
        if (rhs.hasListData()) {
            setListData(rhs.getListData());
        } else {
            clearListData();
        }
    }
    return *this;
}

inline bool PluginListUpdateSignal::operator == (const PluginListUpdateSignal& rhs) const {
    return (((!hasPlugin_name() && !rhs.hasPlugin_name()) || getPlugin_name() == rhs.getPlugin_name()) &&
        ((!hasControlblock_name() && !rhs.hasControlblock_name()) || getControlblock_name() == rhs.getControlblock_name()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()) &&
        ((!hasListData() && !rhs.hasListData()) || getListData() == rhs.getListData()));
}

inline bool PluginListUpdateSignal::operator != (const PluginListUpdateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PluginListUpdateSignal::operator < (const PluginListUpdateSignal& rhs) const {
    if (hasPlugin_name() || rhs.hasPlugin_name()) {
        if (getPlugin_name() < rhs.getPlugin_name()) return true;
        if (getPlugin_name() > rhs.getPlugin_name()) return false;
    }
    if (hasControlblock_name() || rhs.hasControlblock_name()) {
        if (getControlblock_name() < rhs.getControlblock_name()) return true;
        if (getControlblock_name() > rhs.getControlblock_name()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    if (hasListData() || rhs.hasListData()) {
        if (getListData() < rhs.getListData()) return true;
        if (getListData() > rhs.getListData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PluginListUpdateSignal::clone() {
    return new PluginListUpdateSignal(*this);
}

inline bool PluginListUpdateSignal::operator > (const PluginListUpdateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PluginListUpdateSignal::clear() {
    clearPlugin_name();
    clearControlblock_name();
    clearData();
    clearListData();
}

inline void PluginListUpdateSignal::clearPlugin_name() {
    if (hasPlugin_name()) {
         clear_has_plugin_name();
        _plugin_name.clear();
     }
}

inline bool PluginListUpdateSignal::hasPlugin_name () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PluginListUpdateSignal::getPlugin_name () const {
    return _plugin_name;
}

inline ::std::string& PluginListUpdateSignal::getPlugin_nameMutable () {
    set_has_plugin_name();
    return _plugin_name;
}

inline void PluginListUpdateSignal::setPlugin_name (const ::std::string& plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name = plugin_name_;
}

inline void PluginListUpdateSignal::setPlugin_name (const char* plugin_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (plugin_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(plugin_name_);
}

inline void PluginListUpdateSignal::setPlugin_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_plugin_name();
    this->_plugin_name.assign(value, size);
}

inline void PluginListUpdateSignal::clearControlblock_name() {
    if (hasControlblock_name()) {
         clear_has_controlblock_name();
        _controlblock_name.clear();
     }
}

inline bool PluginListUpdateSignal::hasControlblock_name () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& PluginListUpdateSignal::getControlblock_name () const {
    return _controlblock_name;
}

inline ::std::string& PluginListUpdateSignal::getControlblock_nameMutable () {
    set_has_controlblock_name();
    return _controlblock_name;
}

inline void PluginListUpdateSignal::setControlblock_name (const ::std::string& controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name = controlblock_name_;
}

inline void PluginListUpdateSignal::setControlblock_name (const char* controlblock_name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (controlblock_name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(controlblock_name_);
}

inline void PluginListUpdateSignal::setControlblock_name (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_controlblock_name();
    this->_controlblock_name.assign(value, size);
}

inline void PluginListUpdateSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginListUpdateSignal::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginListUpdateSignal::getData () const {
    return _data;
}

inline ::asf::dbus::DBusVariant& PluginListUpdateSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void PluginListUpdateSignal::setData (const ::asf::dbus::DBusVariant& data_) {
    set_has_data();
    this->_data = data_;
}

inline void PluginListUpdateSignal::clearListData() {
    if (hasListData()) {
         clear_has_listData();
        _listData = ::asf::dbus::DBusVariant ();
     }
}

inline bool PluginListUpdateSignal::hasListData () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::asf::dbus::DBusVariant& PluginListUpdateSignal::getListData () const {
    return _listData;
}

inline ::asf::dbus::DBusVariant& PluginListUpdateSignal::getListDataMutable () {
    set_has_listData();
    return _listData;
}

inline void PluginListUpdateSignal::setListData (const ::asf::dbus::DBusVariant& listData_) {
    set_has_listData();
    this->_listData = listData_;
}

inline void PluginListUpdateSignal::set_has_plugin_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PluginListUpdateSignal::clear_has_plugin_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PluginListUpdateSignal::set_has_controlblock_name () {
    _has_bits_[0] |= 1u << 1;
}

inline void PluginListUpdateSignal::clear_has_controlblock_name () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void PluginListUpdateSignal::set_has_data () {
    _has_bits_[0] |= 1u << 2;
}

inline void PluginListUpdateSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void PluginListUpdateSignal::set_has_listData () {
    _has_bits_[0] |= 1u << 3;
}

inline void PluginListUpdateSignal::clear_has_listData () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Sig_DBStatusSignal::Sig_DBStatusSignal ()  :
    _DbState (0u),
    _SourceType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_DBStatusSignal::Sig_DBStatusSignal (const Sig_DBStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _DbState (0u),
    _SourceType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_DBStatusSignal::Sig_DBStatusSignal (uint16 DbState_, uint16 SourceType_)  :
    _DbState (DbState_),
    _SourceType (SourceType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_DBStatusSignal::~Sig_DBStatusSignal() {
}

inline Sig_DBStatusSignal& Sig_DBStatusSignal::operator = (const Sig_DBStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDbState()) {
            setDbState(rhs.getDbState());
        } else {
            clearDbState();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
    }
    return *this;
}

inline bool Sig_DBStatusSignal::operator == (const Sig_DBStatusSignal& rhs) const {
    return (((!hasDbState() && !rhs.hasDbState()) || getDbState() == rhs.getDbState()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()));
}

inline bool Sig_DBStatusSignal::operator != (const Sig_DBStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_DBStatusSignal::operator < (const Sig_DBStatusSignal& rhs) const {
    if (hasDbState() || rhs.hasDbState()) {
        if (getDbState() < rhs.getDbState()) return true;
        if (getDbState() > rhs.getDbState()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if (getSourceType() < rhs.getSourceType()) return true;
        if (getSourceType() > rhs.getSourceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_DBStatusSignal::clone() {
    return new Sig_DBStatusSignal(*this);
}

inline bool Sig_DBStatusSignal::operator > (const Sig_DBStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_DBStatusSignal::clear() {
    clearDbState();
    clearSourceType();
}

inline void Sig_DBStatusSignal::clearDbState() {
    if (hasDbState()) {
         clear_has_DbState();
        _DbState = 0u;
     }
}

inline bool Sig_DBStatusSignal::hasDbState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Sig_DBStatusSignal::getDbState () const {
    return _DbState;
}

inline void Sig_DBStatusSignal::setDbState (uint16 DbState_) {
    set_has_DbState();
    this->_DbState = DbState_;
}

inline void Sig_DBStatusSignal::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = 0u;
     }
}

inline bool Sig_DBStatusSignal::hasSourceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 Sig_DBStatusSignal::getSourceType () const {
    return _SourceType;
}

inline void Sig_DBStatusSignal::setSourceType (uint16 SourceType_) {
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void Sig_DBStatusSignal::set_has_DbState () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_DBStatusSignal::clear_has_DbState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_DBStatusSignal::set_has_SourceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_DBStatusSignal::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_PlayStatusSignalPlayStateStruct::Sig_PlayStatusSignalPlayStateStruct ()  :
    _elem1 (false),
    _elem2 (0u),
    _elem3 (0),
    _elem4 (0u),
    _elem5 (0u),
    _elem6 (0u),
    _elem7 (0u),
    _elem8 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_PlayStatusSignalPlayStateStruct::Sig_PlayStatusSignalPlayStateStruct (const Sig_PlayStatusSignalPlayStateStruct &rhs)  :
    _elem1 (false),
    _elem2 (0u),
    _elem3 (0),
    _elem4 (0u),
    _elem5 (0u),
    _elem6 (0u),
    _elem7 (0u),
    _elem8 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_PlayStatusSignalPlayStateStruct::Sig_PlayStatusSignalPlayStateStruct (bool elem1_, uint16 elem2_, int32 elem3_, uint16 elem4_, uint16 elem5_, uint16 elem6_, uint16 elem7_, const ::std::string& elem8_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_),
    _elem5 (elem5_),
    _elem6 (elem6_),
    _elem7 (elem7_),
    _elem8 (elem8_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_PlayStatusSignalPlayStateStruct::~Sig_PlayStatusSignalPlayStateStruct() {
}

inline Sig_PlayStatusSignalPlayStateStruct& Sig_PlayStatusSignalPlayStateStruct::operator = (const Sig_PlayStatusSignalPlayStateStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
        if (rhs.hasElem6()) {
            setElem6(rhs.getElem6());
        } else {
            clearElem6();
        }
        if (rhs.hasElem7()) {
            setElem7(rhs.getElem7());
        } else {
            clearElem7();
        }
        if (rhs.hasElem8()) {
            setElem8(rhs.getElem8());
        } else {
            clearElem8();
        }
    }
    return *this;
}

inline bool Sig_PlayStatusSignalPlayStateStruct::operator == (const Sig_PlayStatusSignalPlayStateStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()) &&
        ((!hasElem6() && !rhs.hasElem6()) || getElem6() == rhs.getElem6()) &&
        ((!hasElem7() && !rhs.hasElem7()) || getElem7() == rhs.getElem7()) &&
        ((!hasElem8() && !rhs.hasElem8()) || getElem8() == rhs.getElem8()));
}

inline bool Sig_PlayStatusSignalPlayStateStruct::operator != (const Sig_PlayStatusSignalPlayStateStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_PlayStatusSignalPlayStateStruct::operator < (const Sig_PlayStatusSignalPlayStateStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    if (hasElem6() || rhs.hasElem6()) {
        if (getElem6() < rhs.getElem6()) return true;
        if (getElem6() > rhs.getElem6()) return false;
    }
    if (hasElem7() || rhs.hasElem7()) {
        if (getElem7() < rhs.getElem7()) return true;
        if (getElem7() > rhs.getElem7()) return false;
    }
    if (hasElem8() || rhs.hasElem8()) {
        if (getElem8() < rhs.getElem8()) return true;
        if (getElem8() > rhs.getElem8()) return false;
    }
    return false;
}

inline bool Sig_PlayStatusSignalPlayStateStruct::operator > (const Sig_PlayStatusSignalPlayStateStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
    clearElem5();
    clearElem6();
    clearElem7();
    clearElem8();
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = false;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_PlayStatusSignalPlayStateStruct::getElem1 () const {
    return _elem1;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem1 (bool elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 Sig_PlayStatusSignalPlayStateStruct::getElem2 () const {
    return _elem2;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3 = 0;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 Sig_PlayStatusSignalPlayStateStruct::getElem3 () const {
    return _elem3;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem3 (int32 elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0u;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_PlayStatusSignalPlayStateStruct::getElem4 () const {
    return _elem4;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem4 (uint16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem5() {
    if (hasElem5()) {
         clear_has_elem5();
        _elem5 = 0u;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 Sig_PlayStatusSignalPlayStateStruct::getElem5 () const {
    return _elem5;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem5 (uint16 elem5_) {
    set_has_elem5();
    this->_elem5 = elem5_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem6() {
    if (hasElem6()) {
         clear_has_elem6();
        _elem6 = 0u;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem6 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 Sig_PlayStatusSignalPlayStateStruct::getElem6 () const {
    return _elem6;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem6 (uint16 elem6_) {
    set_has_elem6();
    this->_elem6 = elem6_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem7() {
    if (hasElem7()) {
         clear_has_elem7();
        _elem7 = 0u;
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem7 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 Sig_PlayStatusSignalPlayStateStruct::getElem7 () const {
    return _elem7;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem7 (uint16 elem7_) {
    set_has_elem7();
    this->_elem7 = elem7_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clearElem8() {
    if (hasElem8()) {
         clear_has_elem8();
        _elem8.clear();
     }
}

inline bool Sig_PlayStatusSignalPlayStateStruct::hasElem8 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& Sig_PlayStatusSignalPlayStateStruct::getElem8 () const {
    return _elem8;
}

inline ::std::string& Sig_PlayStatusSignalPlayStateStruct::getElem8Mutable () {
    set_has_elem8();
    return _elem8;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem8 (const ::std::string& elem8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8 = elem8_;
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem8 (const char* elem8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8.assign(elem8_);
}

inline void Sig_PlayStatusSignalPlayStateStruct::setElem8 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8.assign(value, size);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem6 () {
    _has_bits_[0] |= 1u << 5;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem6 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem7 () {
    _has_bits_[0] |= 1u << 6;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem7 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void Sig_PlayStatusSignalPlayStateStruct::set_has_elem8 () {
    _has_bits_[0] |= 1u << 7;
}

inline void Sig_PlayStatusSignalPlayStateStruct::clear_has_elem8 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  Sig_PlayStatusSignal::Sig_PlayStatusSignal ()  :
    _PlayState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_PlayStatusSignal::Sig_PlayStatusSignal (const Sig_PlayStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _PlayState ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_PlayStatusSignal::Sig_PlayStatusSignal (const Sig_PlayStatusSignalPlayStateStruct& PlayState_)  :
    _PlayState (PlayState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_PlayStatusSignal::~Sig_PlayStatusSignal() {
}

inline Sig_PlayStatusSignal& Sig_PlayStatusSignal::operator = (const Sig_PlayStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPlayState()) {
            setPlayState(rhs.getPlayState());
        } else {
            clearPlayState();
        }
    }
    return *this;
}

inline bool Sig_PlayStatusSignal::operator == (const Sig_PlayStatusSignal& rhs) const {
    return (((!hasPlayState() && !rhs.hasPlayState()) || getPlayState() == rhs.getPlayState()));
}

inline bool Sig_PlayStatusSignal::operator != (const Sig_PlayStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_PlayStatusSignal::operator < (const Sig_PlayStatusSignal& rhs) const {
    if (hasPlayState() || rhs.hasPlayState()) {
        if (getPlayState() < rhs.getPlayState()) return true;
        if (getPlayState() > rhs.getPlayState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_PlayStatusSignal::clone() {
    return new Sig_PlayStatusSignal(*this);
}

inline bool Sig_PlayStatusSignal::operator > (const Sig_PlayStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_PlayStatusSignal::clear() {
    clearPlayState();
}

inline void Sig_PlayStatusSignal::clearPlayState() {
    if (hasPlayState()) {
         clear_has_PlayState();
        _PlayState.clear();
     }
}

inline bool Sig_PlayStatusSignal::hasPlayState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const Sig_PlayStatusSignalPlayStateStruct& Sig_PlayStatusSignal::getPlayState () const {
    return _PlayState;
}

inline Sig_PlayStatusSignalPlayStateStruct& Sig_PlayStatusSignal::getPlayStateMutable () {
    set_has_PlayState();
    return _PlayState;
}

inline void Sig_PlayStatusSignal::setPlayState (const Sig_PlayStatusSignalPlayStateStruct& PlayState_) {
    set_has_PlayState();
    this->_PlayState = PlayState_;
}

inline void Sig_PlayStatusSignal::set_has_PlayState () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_PlayStatusSignal::clear_has_PlayState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct::Sig_ReqTrackIndexSignalTrackReqInfoStruct ()  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0u),
    _elem5 (0u),
    _elem6 (0u),
    _elem7 (0u),
    _elem8 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct::Sig_ReqTrackIndexSignalTrackReqInfoStruct (const Sig_ReqTrackIndexSignalTrackReqInfoStruct &rhs)  :
    _elem1 (0u),
    _elem2 (0u),
    _elem3 (0u),
    _elem4 (0u),
    _elem5 (0u),
    _elem6 (0u),
    _elem7 (0u),
    _elem8 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct::Sig_ReqTrackIndexSignalTrackReqInfoStruct (uint16 elem1_, uint16 elem2_, uint16 elem3_, uint16 elem4_, uint16 elem5_, uint16 elem6_, uint16 elem7_, const ::std::string& elem8_)  :
    _elem1 (elem1_),
    _elem2 (elem2_),
    _elem3 (elem3_),
    _elem4 (elem4_),
    _elem5 (elem5_),
    _elem6 (elem6_),
    _elem7 (elem7_),
    _elem8 (elem8_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_ReqTrackIndexSignalTrackReqInfoStruct::~Sig_ReqTrackIndexSignalTrackReqInfoStruct() {
}

inline Sig_ReqTrackIndexSignalTrackReqInfoStruct& Sig_ReqTrackIndexSignalTrackReqInfoStruct::operator = (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
        if (rhs.hasElem3()) {
            setElem3(rhs.getElem3());
        } else {
            clearElem3();
        }
        if (rhs.hasElem4()) {
            setElem4(rhs.getElem4());
        } else {
            clearElem4();
        }
        if (rhs.hasElem5()) {
            setElem5(rhs.getElem5());
        } else {
            clearElem5();
        }
        if (rhs.hasElem6()) {
            setElem6(rhs.getElem6());
        } else {
            clearElem6();
        }
        if (rhs.hasElem7()) {
            setElem7(rhs.getElem7());
        } else {
            clearElem7();
        }
        if (rhs.hasElem8()) {
            setElem8(rhs.getElem8());
        } else {
            clearElem8();
        }
    }
    return *this;
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::operator == (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()) &&
        ((!hasElem3() && !rhs.hasElem3()) || getElem3() == rhs.getElem3()) &&
        ((!hasElem4() && !rhs.hasElem4()) || getElem4() == rhs.getElem4()) &&
        ((!hasElem5() && !rhs.hasElem5()) || getElem5() == rhs.getElem5()) &&
        ((!hasElem6() && !rhs.hasElem6()) || getElem6() == rhs.getElem6()) &&
        ((!hasElem7() && !rhs.hasElem7()) || getElem7() == rhs.getElem7()) &&
        ((!hasElem8() && !rhs.hasElem8()) || getElem8() == rhs.getElem8()));
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::operator != (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::operator < (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    if (hasElem3() || rhs.hasElem3()) {
        if (getElem3() < rhs.getElem3()) return true;
        if (getElem3() > rhs.getElem3()) return false;
    }
    if (hasElem4() || rhs.hasElem4()) {
        if (getElem4() < rhs.getElem4()) return true;
        if (getElem4() > rhs.getElem4()) return false;
    }
    if (hasElem5() || rhs.hasElem5()) {
        if (getElem5() < rhs.getElem5()) return true;
        if (getElem5() > rhs.getElem5()) return false;
    }
    if (hasElem6() || rhs.hasElem6()) {
        if (getElem6() < rhs.getElem6()) return true;
        if (getElem6() > rhs.getElem6()) return false;
    }
    if (hasElem7() || rhs.hasElem7()) {
        if (getElem7() < rhs.getElem7()) return true;
        if (getElem7() > rhs.getElem7()) return false;
    }
    if (hasElem8() || rhs.hasElem8()) {
        if (getElem8() < rhs.getElem8()) return true;
        if (getElem8() > rhs.getElem8()) return false;
    }
    return false;
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::operator > (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear() {
    clearElem1();
    clearElem2();
    clearElem3();
    clearElem4();
    clearElem5();
    clearElem6();
    clearElem7();
    clearElem8();
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem1 () const {
    return _elem1;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem1 (uint16 elem1_) {
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem2 () const {
    return _elem2;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem2 (uint16 elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem3() {
    if (hasElem3()) {
         clear_has_elem3();
        _elem3 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem3 () const {
    return _elem3;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem3 (uint16 elem3_) {
    set_has_elem3();
    this->_elem3 = elem3_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem4() {
    if (hasElem4()) {
         clear_has_elem4();
        _elem4 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem4 () const {
    return _elem4;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem4 (uint16 elem4_) {
    set_has_elem4();
    this->_elem4 = elem4_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem5() {
    if (hasElem5()) {
         clear_has_elem5();
        _elem5 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem5 () const {
    return _elem5;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem5 (uint16 elem5_) {
    set_has_elem5();
    this->_elem5 = elem5_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem6() {
    if (hasElem6()) {
         clear_has_elem6();
        _elem6 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem6 () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem6 () const {
    return _elem6;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem6 (uint16 elem6_) {
    set_has_elem6();
    this->_elem6 = elem6_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem7() {
    if (hasElem7()) {
         clear_has_elem7();
        _elem7 = 0u;
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem7 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint16 Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem7 () const {
    return _elem7;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem7 (uint16 elem7_) {
    set_has_elem7();
    this->_elem7 = elem7_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clearElem8() {
    if (hasElem8()) {
         clear_has_elem8();
        _elem8.clear();
     }
}

inline bool Sig_ReqTrackIndexSignalTrackReqInfoStruct::hasElem8 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::std::string& Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem8 () const {
    return _elem8;
}

inline ::std::string& Sig_ReqTrackIndexSignalTrackReqInfoStruct::getElem8Mutable () {
    set_has_elem8();
    return _elem8;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem8 (const ::std::string& elem8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8 = elem8_;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem8 (const char* elem8_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem8_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8.assign(elem8_);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::setElem8 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem8();
    this->_elem8.assign(value, size);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem6 () {
    _has_bits_[0] |= 1u << 5;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem6 () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem7 () {
    _has_bits_[0] |= 1u << 6;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem7 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::set_has_elem8 () {
    _has_bits_[0] |= 1u << 7;
}

inline void Sig_ReqTrackIndexSignalTrackReqInfoStruct::clear_has_elem8 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  Sig_ReqTrackIndexSignal::Sig_ReqTrackIndexSignal ()  :
    _TrackReqInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_ReqTrackIndexSignal::Sig_ReqTrackIndexSignal (const Sig_ReqTrackIndexSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _TrackReqInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_ReqTrackIndexSignal::Sig_ReqTrackIndexSignal (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& TrackReqInfo_)  :
    _TrackReqInfo (TrackReqInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_ReqTrackIndexSignal::~Sig_ReqTrackIndexSignal() {
}

inline Sig_ReqTrackIndexSignal& Sig_ReqTrackIndexSignal::operator = (const Sig_ReqTrackIndexSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTrackReqInfo()) {
            setTrackReqInfo(rhs.getTrackReqInfo());
        } else {
            clearTrackReqInfo();
        }
    }
    return *this;
}

inline bool Sig_ReqTrackIndexSignal::operator == (const Sig_ReqTrackIndexSignal& rhs) const {
    return (((!hasTrackReqInfo() && !rhs.hasTrackReqInfo()) || getTrackReqInfo() == rhs.getTrackReqInfo()));
}

inline bool Sig_ReqTrackIndexSignal::operator != (const Sig_ReqTrackIndexSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_ReqTrackIndexSignal::operator < (const Sig_ReqTrackIndexSignal& rhs) const {
    if (hasTrackReqInfo() || rhs.hasTrackReqInfo()) {
        if (getTrackReqInfo() < rhs.getTrackReqInfo()) return true;
        if (getTrackReqInfo() > rhs.getTrackReqInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_ReqTrackIndexSignal::clone() {
    return new Sig_ReqTrackIndexSignal(*this);
}

inline bool Sig_ReqTrackIndexSignal::operator > (const Sig_ReqTrackIndexSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_ReqTrackIndexSignal::clear() {
    clearTrackReqInfo();
}

inline void Sig_ReqTrackIndexSignal::clearTrackReqInfo() {
    if (hasTrackReqInfo()) {
         clear_has_TrackReqInfo();
        _TrackReqInfo.clear();
     }
}

inline bool Sig_ReqTrackIndexSignal::hasTrackReqInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const Sig_ReqTrackIndexSignalTrackReqInfoStruct& Sig_ReqTrackIndexSignal::getTrackReqInfo () const {
    return _TrackReqInfo;
}

inline Sig_ReqTrackIndexSignalTrackReqInfoStruct& Sig_ReqTrackIndexSignal::getTrackReqInfoMutable () {
    set_has_TrackReqInfo();
    return _TrackReqInfo;
}

inline void Sig_ReqTrackIndexSignal::setTrackReqInfo (const Sig_ReqTrackIndexSignalTrackReqInfoStruct& TrackReqInfo_) {
    set_has_TrackReqInfo();
    this->_TrackReqInfo = TrackReqInfo_;
}

inline void Sig_ReqTrackIndexSignal::set_has_TrackReqInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_ReqTrackIndexSignal::clear_has_TrackReqInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_CRCCheckStatusSignal::Sig_CRCCheckStatusSignal ()  :
    _CRCStatus (false),
    _SourceType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_CRCCheckStatusSignal::Sig_CRCCheckStatusSignal (const Sig_CRCCheckStatusSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _CRCStatus (false),
    _SourceType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_CRCCheckStatusSignal::Sig_CRCCheckStatusSignal (bool CRCStatus_, uint16 SourceType_)  :
    _CRCStatus (CRCStatus_),
    _SourceType (SourceType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_CRCCheckStatusSignal::~Sig_CRCCheckStatusSignal() {
}

inline Sig_CRCCheckStatusSignal& Sig_CRCCheckStatusSignal::operator = (const Sig_CRCCheckStatusSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCRCStatus()) {
            setCRCStatus(rhs.getCRCStatus());
        } else {
            clearCRCStatus();
        }
        if (rhs.hasSourceType()) {
            setSourceType(rhs.getSourceType());
        } else {
            clearSourceType();
        }
    }
    return *this;
}

inline bool Sig_CRCCheckStatusSignal::operator == (const Sig_CRCCheckStatusSignal& rhs) const {
    return (((!hasCRCStatus() && !rhs.hasCRCStatus()) || getCRCStatus() == rhs.getCRCStatus()) &&
        ((!hasSourceType() && !rhs.hasSourceType()) || getSourceType() == rhs.getSourceType()));
}

inline bool Sig_CRCCheckStatusSignal::operator != (const Sig_CRCCheckStatusSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_CRCCheckStatusSignal::operator < (const Sig_CRCCheckStatusSignal& rhs) const {
    if (hasCRCStatus() || rhs.hasCRCStatus()) {
        if (getCRCStatus() < rhs.getCRCStatus()) return true;
        if (getCRCStatus() > rhs.getCRCStatus()) return false;
    }
    if (hasSourceType() || rhs.hasSourceType()) {
        if (getSourceType() < rhs.getSourceType()) return true;
        if (getSourceType() > rhs.getSourceType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_CRCCheckStatusSignal::clone() {
    return new Sig_CRCCheckStatusSignal(*this);
}

inline bool Sig_CRCCheckStatusSignal::operator > (const Sig_CRCCheckStatusSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_CRCCheckStatusSignal::clear() {
    clearCRCStatus();
    clearSourceType();
}

inline void Sig_CRCCheckStatusSignal::clearCRCStatus() {
    if (hasCRCStatus()) {
         clear_has_CRCStatus();
        _CRCStatus = false;
     }
}

inline bool Sig_CRCCheckStatusSignal::hasCRCStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_CRCCheckStatusSignal::getCRCStatus () const {
    return _CRCStatus;
}

inline void Sig_CRCCheckStatusSignal::setCRCStatus (bool CRCStatus_) {
    set_has_CRCStatus();
    this->_CRCStatus = CRCStatus_;
}

inline void Sig_CRCCheckStatusSignal::clearSourceType() {
    if (hasSourceType()) {
         clear_has_SourceType();
        _SourceType = 0u;
     }
}

inline bool Sig_CRCCheckStatusSignal::hasSourceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 Sig_CRCCheckStatusSignal::getSourceType () const {
    return _SourceType;
}

inline void Sig_CRCCheckStatusSignal::setSourceType (uint16 SourceType_) {
    set_has_SourceType();
    this->_SourceType = SourceType_;
}

inline void Sig_CRCCheckStatusSignal::set_has_CRCStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_CRCCheckStatusSignal::clear_has_CRCStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_CRCCheckStatusSignal::set_has_SourceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_CRCCheckStatusSignal::clear_has_SourceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace PluginDbusInterface
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_PLUGINDBUSINTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
