/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVSTUB_H
#define FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv.h"

namespace fcota_descmo_ecu_srv {
namespace FcOtaDescmoEcuSrv {

class FcOtaDescmoEcuSrvStubDelegate;

class FcOtaDescmoEcuSrvStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the FcOtaDescmoEcuSrvStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    FcOtaDescmoEcuSrvStub (const std::string& portName);

    /**
     * Create an instance of the FcOtaDescmoEcuSrvStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    FcOtaDescmoEcuSrvStub (const std::string& portName, const std::string& objectPath);

    virtual ~FcOtaDescmoEcuSrvStub();

    // property 'DescmoState'

    /**
     * The method onDescmoStateGet() is called by ASF when a client invokes
     * the read method for the property 'DescmoState'. The onDescmoStateGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    virtual void onDescmoStateGet(const ::boost::shared_ptr< DescmoStateGet >& payload);

    /**
     * Sends back the update to a previous onDescmoStateGet().
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param act Identifies a previous invocation of onDescmoStateGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDescmoStateGetUpdate(const trDescmoState& descmoState, act_t act = 0);

    /**
     * The method onDescmoStateSet() is called by ASF when a client invokes
     * the write method for the property 'DescmoState'. The onDescmoStateSet()
     * method set property value to the given parameter DescmoState by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    virtual void onDescmoStateSet(const ::boost::shared_ptr< DescmoStateSet >& payload);

    /**
     * Sends back the update to a previous onDescmoStateSet().
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param act Identifies a previous invocation of onDescmoStateSet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDescmoStateSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'DescmoState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    void setDescmoState(const trDescmoState& descmoState);

    /**
     * Returns the current value of the property 'DescmoState'.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    const trDescmoState& getDescmoState() const;

    /**
     * Returns the current value of the property 'DescmoState' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDescmoStateUpdate() method.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    trDescmoState& getDescmoStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDescmoStateUpdate().
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    void sendDescmoStateUpdate();

    // method 'RegisterEcu'

    /**
     * The method onRegisterEcu() is called by ASF when a client invokes the
     * method 'RegisterEcu'. A subclass has to implement this method and send
     * back a response to the client either with the sendRegisterEcu() or
     * sendRegisterEcuError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'RegisterEcu'</b>:
     *
     * Existing ecu updaters have to register through this method.
     *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterEcuRequest (const ::boost::shared_ptr< RegisterEcuRequest >& request) = 0;

    /**
     * The method sendRegisterEcuResponse() sends a response of a previous
     * method invocation of 'RegisterEcu' back to the client.
     *
     * <b>Documentation of 'RegisterEcu'</b>:
     *
     * Existing ecu updaters have to register through this method.
     *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterEcu(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterEcuResponse (const trRegisterEcuResponse& response, act_t act = 0);

    /**
     * The method sendRegisterEcuError() sends an error response of a previous
     * method invocation of 'RegisterEcu' back to the client.
     *
     * <b>Documentation of 'RegisterEcu'</b>:
     *
     * Existing ecu updaters have to register through this method.
     *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterEcu(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRegisterEcuError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetDescmoResult'

    /**
     * The method onSetDescmoResult() is called by ASF when a client invokes
     * the method 'SetDescmoResult'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetDescmoResult() or sendSetDescmoResultError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'SetDescmoResult'</b>:
     *
     * Ecu-client will send result of descmo-request received via DescmoState using this method.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetDescmoResultRequest (const ::boost::shared_ptr< SetDescmoResultRequest >& request) = 0;

    /**
     * The method sendSetDescmoResultResponse() sends a response of a previous
     * method invocation of 'SetDescmoResult' back to the client.
     *
     * <b>Documentation of 'SetDescmoResult'</b>:
     *
     * Ecu-client will send result of descmo-request received via DescmoState using this method.
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetDescmoResult(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetDescmoResultResponse (const trSetDescmoResultResponse& response, act_t act = 0);

    /**
     * The method sendSetDescmoResultError() sends an error response of a
     * previous method invocation of 'SetDescmoResult' back to the client.
     *
     * <b>Documentation of 'SetDescmoResult'</b>:
     *
     * Ecu-client will send result of descmo-request received via DescmoState using this method.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetDescmoResult(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetDescmoResultError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    DescmoStateUpdate _DescmoStateProperty;

    friend class FcOtaDescmoEcuSrvStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace FcOtaDescmoEcuSrv
} // namespace fcota_descmo_ecu_srv

#endif // FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVSTUB_H
