/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVPROXY_H
#define FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv.h"
#include <dbus/dbus.h>

namespace fcota_descmo_ecu_srv {
namespace FcOtaDescmoEcuSrv {

class FcOtaDescmoEcuSrvProxy;

class DescmoStateCallbackIF {
public:
    virtual ~DescmoStateCallbackIF() {}

    virtual void onDescmoStateError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< DescmoStateError >& error) = 0;

    virtual void onDescmoStateUpdate(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< DescmoStateUpdate >& update) = 0;
};

class RegisterEcuCallbackIF {
public:
    virtual ~RegisterEcuCallbackIF() {}

    virtual void onRegisterEcuError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< RegisterEcuError >& error) = 0;

    virtual void onRegisterEcuResponse(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< RegisterEcuResponse >& response) = 0;
};

class SetDescmoResultCallbackIF {
public:
    virtual ~SetDescmoResultCallbackIF() {}

    virtual void onSetDescmoResultError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< SetDescmoResultError >& error) = 0;

    virtual void onSetDescmoResultResponse(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< SetDescmoResultResponse >& response) = 0;
};


/**
 * FcOtaDescmoEcuSrvProxy is the client side representation of the D-Bus
 * service interface 'fcota_descmo_ecu_srv.FcOtaDescmoEcuSrv' (specified
 * in file FcOtaDescmoEcuSrv_.xml).
 *
 * Interface to connect ecus to descmo-functionality.
 */
class FcOtaDescmoEcuSrvProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of FcOtaDescmoEcuSrvProxy.
     */
    static ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of FcOtaDescmoEcuSrvProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of FcOtaDescmoEcuSrvProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy > proxyNew(new FcOtaDescmoEcuSrvProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~FcOtaDescmoEcuSrvProxy ();



    // Property 'DescmoState'

    /**
     * Notify on the property 'DescmoState'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDescmoStateRegister(DescmoStateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DescmoState'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param act The act which was previously returned by the
     * sendDescmoStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDescmoStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DescmoState'.
     */
    void sendDescmoStateDeregisterAll() const;

    /**
     * Request the value of the property 'DescmoState' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDescmoStateGet(DescmoStateCallbackIF& cb);

    /**
     * Set the value of the property 'DescmoState'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendDescmoStateSet(DescmoStateCallbackIF& cb, const
     * trDescmoState& descmoState) method instead.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     */
    void sendDescmoStateSet(const trDescmoState& descmoState);

    /**
     * Set the value of the property 'DescmoState'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'DescmoState'</b>:
     *
     * Global current state.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDescmoStateSet(DescmoStateCallbackIF& cb, const trDescmoState& descmoState);

    /**
     * Returns the current value of the property 'DescmoState' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDescmoState() returns true.
     *
     * @return the previously received value of the property 'DescmoState'.
     */
    const trDescmoState& getDescmoState() const;

    /**
     * Determines whether a status message for the property 'DescmoState' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDescmoState() const;


    // Method 'RegisterEcu'

    /**
     * Call the method 'RegisterEcu'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'RegisterEcu'</b>:
     *
     * Existing ecu updaters have to register through this method.
     *                       FcOta can check for each descmo-request, if a client for the corresponding ecuId exists.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param info If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterEcuRequest(RegisterEcuCallbackIF& cb, const trRegisterEcuInfo& info) const;

    // Method 'SetDescmoResult'

    /**
     * Call the method 'SetDescmoResult'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetDescmoResult'</b>:
     *
     * Ecu-client will send result of descmo-request received via DescmoState using this method.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param info If the meaning of "info" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDescmoResultRequest(SetDescmoResultCallbackIF& cb, const trSetDescmoResultInfo& info) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    FcOtaDescmoEcuSrvProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'DescmoState'

    ::asf::core::nullable< DescmoStateUpdate > _descmoState;

    DECLARE_CLASS_LOGGER();

    friend class FcOtaDescmoEcuSrvProxyCallback;
};

} // namespace FcOtaDescmoEcuSrv
} // namespace fcota_descmo_ecu_srv

#endif // FCOTA_DESCMO_ECU_SRV_FCOTADESCMOECUSRVPROXY_H
