/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICESTUB_H
#define ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

class NavigationServiceStubDelegate;

class NavigationServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NavigationServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NavigationServiceStub (const std::string& portName);

    /**
     * Create an instance of the NavigationServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NavigationServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~NavigationServiceStub();

    // property 'navStatus'

    /**
     * The method onNavStatusGet() is called by ASF when a client invokes the
     * read method for the property 'navStatus'. The onNavStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'navStatus'</b>:
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     */
    virtual void onNavStatusGet(const ::boost::shared_ptr< NavStatusGet >& payload);

    /**
     * Sends back the update to a previous onNavStatusGet().
     *
     * <b>Documentation of 'navStatus'</b>:
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     *
     * @param act Identifies a previous invocation of onNavStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNavStatusGetUpdate(NavStatus navStatus, act_t act = 0);

    /**
     * Set the value of the property 'navStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'navStatus'</b>:
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     */
    void setNavStatus(NavStatus navStatus);

    /**
     * Returns the current value of the property 'navStatus'.
     *
     * <b>Documentation of 'navStatus'</b>:
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     */
    NavStatus getNavStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNavStatusUpdate().
     *
     * <b>Documentation of 'navStatus'</b>:
     *
     * Attribute provides the navigation status like UNKNOWN, BUSY
     */
    void sendNavStatusUpdate();

    // property 'datasetVersion'

    /**
     * The method onDatasetVersionGet() is called by ASF when a client invokes
     * the read method for the property 'datasetVersion'. The
     * onDatasetVersionGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     */
    virtual void onDatasetVersionGet(const ::boost::shared_ptr< DatasetVersionGet >& payload);

    /**
     * Sends back the update to a previous onDatasetVersionGet().
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     *
     * @param act Identifies a previous invocation of onDatasetVersionGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDatasetVersionGetUpdate(const ::std::string& datasetVersion, act_t act = 0);

    /**
     * Set the value of the property 'datasetVersion' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     */
    void setDatasetVersion(const ::std::string& datasetVersion);

    /**
     * Returns the current value of the property 'datasetVersion'.
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     */
    const ::std::string& getDatasetVersion() const;

    /**
     * Returns the current value of the property 'datasetVersion' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDatasetVersionUpdate() method.
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     */
    ::std::string& getDatasetVersionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDatasetVersionUpdate().
     *
     * <b>Documentation of 'datasetVersion'</b>:
     *
     * Attribute provides the Navi Data Set version in use
     */
    void sendDatasetVersionUpdate();

    // property 'nonPremiumTMCStatus'

    /**
     * The method onNonPremiumTMCStatusGet() is called by ASF when a client
     * invokes the read method for the property 'nonPremiumTMCStatus'. The
     * onNonPremiumTMCStatusGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'nonPremiumTMCStatus'</b>:
     *
     * Attribute provides the non premium TMC status
     */
    virtual void onNonPremiumTMCStatusGet(const ::boost::shared_ptr< NonPremiumTMCStatusGet >& payload);

    /**
     * Sends back the update to a previous onNonPremiumTMCStatusGet().
     *
     * <b>Documentation of 'nonPremiumTMCStatus'</b>:
     *
     * Attribute provides the non premium TMC status
     *
     * @param act Identifies a previous invocation of
     * onNonPremiumTMCStatusGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNonPremiumTMCStatusGetUpdate(bool nonPremiumTMCStatus, act_t act = 0);

    /**
     * Set the value of the property 'nonPremiumTMCStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'nonPremiumTMCStatus'</b>:
     *
     * Attribute provides the non premium TMC status
     */
    void setNonPremiumTMCStatus(bool nonPremiumTMCStatus);

    /**
     * Returns the current value of the property 'nonPremiumTMCStatus'.
     *
     * <b>Documentation of 'nonPremiumTMCStatus'</b>:
     *
     * Attribute provides the non premium TMC status
     */
    bool getNonPremiumTMCStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNonPremiumTMCStatusUpdate().
     *
     * <b>Documentation of 'nonPremiumTMCStatus'</b>:
     *
     * Attribute provides the non premium TMC status
     */
    void sendNonPremiumTMCStatusUpdate();

    // property 'currentFreeTextSearchInfo'

    /**
     * The method onCurrentFreeTextSearchInfoGet() is called by ASF when a
     * client invokes the read method for the property
     * 'currentFreeTextSearchInfo'. The onCurrentFreeTextSearchInfoGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     */
    virtual void onCurrentFreeTextSearchInfoGet(const ::boost::shared_ptr< CurrentFreeTextSearchInfoGet >& payload);

    /**
     * Sends back the update to a previous onCurrentFreeTextSearchInfoGet().
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     *
     * @param act Identifies a previous invocation of
     * onCurrentFreeTextSearchInfoGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCurrentFreeTextSearchInfoGetUpdate(const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo, act_t act = 0);

    /**
     * Set the value of the property 'currentFreeTextSearchInfo' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     */
    void setCurrentFreeTextSearchInfo(const CurrentFreeTextSearchInfo& currentFreeTextSearchInfo);

    /**
     * Returns the current value of the property 'currentFreeTextSearchInfo'.
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     */
    const CurrentFreeTextSearchInfo& getCurrentFreeTextSearchInfo() const;

    /**
     * Returns the current value of the property 'currentFreeTextSearchInfo'
     * as a mutable reference. If you change the content of the returned
     * object you have to send updates to registered clients by yourself with
     * the help of the sendCurrentFreeTextSearchInfoUpdate() method.
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     */
    CurrentFreeTextSearchInfo& getCurrentFreeTextSearchInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentFreeTextSearchInfoUpdate().
     *
     * <b>Documentation of 'currentFreeTextSearchInfo'</b>:
     *
     * Attribute provides freeText search string and position information
     */
    void sendCurrentFreeTextSearchInfoUpdate();

    // property 'positionInformation'

    /**
     * The method onPositionInformationGet() is called by ASF when a client
     * invokes the read method for the property 'positionInformation'. The
     * onPositionInformationGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     */
    virtual void onPositionInformationGet(const ::boost::shared_ptr< PositionInformationGet >& payload);

    /**
     * Sends back the update to a previous onPositionInformationGet().
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     *
     * @param act Identifies a previous invocation of
     * onPositionInformationGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendPositionInformationGetUpdate(const PositionInformation& positionInformation, act_t act = 0);

    /**
     * Set the value of the property 'positionInformation' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     */
    void setPositionInformation(const PositionInformation& positionInformation);

    /**
     * Returns the current value of the property 'positionInformation'.
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     */
    const PositionInformation& getPositionInformation() const;

    /**
     * Returns the current value of the property 'positionInformation' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendPositionInformationUpdate() method.
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     */
    PositionInformation& getPositionInformationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPositionInformationUpdate().
     *
     * <b>Documentation of 'positionInformation'</b>:
     *
     * Attribute provides current vehicle position information
     */
    void sendPositionInformationUpdate();

    // property 'distanceToDestination'

    /**
     * The method onDistanceToDestinationGet() is called by ASF when a client
     * invokes the read method for the property 'distanceToDestination'. The
     * onDistanceToDestinationGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     */
    virtual void onDistanceToDestinationGet(const ::boost::shared_ptr< DistanceToDestinationGet >& payload);

    /**
     * Sends back the update to a previous onDistanceToDestinationGet().
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     *
     * @param act Identifies a previous invocation of
     * onDistanceToDestinationGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDistanceToDestinationGetUpdate(const DistanceToDestination& distanceToDestination, act_t act = 0);

    /**
     * Set the value of the property 'distanceToDestination' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     */
    void setDistanceToDestination(const DistanceToDestination& distanceToDestination);

    /**
     * Returns the current value of the property 'distanceToDestination'.
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     */
    const DistanceToDestination& getDistanceToDestination() const;

    /**
     * Returns the current value of the property 'distanceToDestination' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDistanceToDestinationUpdate() method.
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     */
    DistanceToDestination& getDistanceToDestinationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDistanceToDestinationUpdate().
     *
     * <b>Documentation of 'distanceToDestination'</b>:
     *
     * Attribute provides the distance to destination along with unit information
     */
    void sendDistanceToDestinationUpdate();

    // property 'currentStreet'

    /**
     * The method onCurrentStreetGet() is called by ASF when a client invokes
     * the read method for the property 'currentStreet'. The
     * onCurrentStreetGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     */
    virtual void onCurrentStreetGet(const ::boost::shared_ptr< CurrentStreetGet >& payload);

    /**
     * Sends back the update to a previous onCurrentStreetGet().
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     *
     * @param act Identifies a previous invocation of onCurrentStreetGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCurrentStreetGetUpdate(const ::std::string& currentStreet, act_t act = 0);

    /**
     * Set the value of the property 'currentStreet' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     */
    void setCurrentStreet(const ::std::string& currentStreet);

    /**
     * Returns the current value of the property 'currentStreet'.
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     */
    const ::std::string& getCurrentStreet() const;

    /**
     * Returns the current value of the property 'currentStreet' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCurrentStreetUpdate() method.
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     */
    ::std::string& getCurrentStreetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentStreetUpdate().
     *
     * <b>Documentation of 'currentStreet'</b>:
     *
     * Attribute provides the current street
     */
    void sendCurrentStreetUpdate();

    // property 'turntoStreet'

    /**
     * The method onTurntoStreetGet() is called by ASF when a client invokes
     * the read method for the property 'turntoStreet'. The
     * onTurntoStreetGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     */
    virtual void onTurntoStreetGet(const ::boost::shared_ptr< TurntoStreetGet >& payload);

    /**
     * Sends back the update to a previous onTurntoStreetGet().
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     *
     * @param act Identifies a previous invocation of onTurntoStreetGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTurntoStreetGetUpdate(const TurnToStreet& turntoStreet, act_t act = 0);

    /**
     * Set the value of the property 'turntoStreet' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     */
    void setTurntoStreet(const TurnToStreet& turntoStreet);

    /**
     * Returns the current value of the property 'turntoStreet'.
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     */
    const TurnToStreet& getTurntoStreet() const;

    /**
     * Returns the current value of the property 'turntoStreet' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTurntoStreetUpdate() method.
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     */
    TurnToStreet& getTurntoStreetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTurntoStreetUpdate().
     *
     * <b>Documentation of 'turntoStreet'</b>:
     *
     * Attribute provides the turn to street info
     */
    void sendTurntoStreetUpdate();

    // property 'roundaboutExitNumber'

    /**
     * The method onRoundaboutExitNumberGet() is called by ASF when a client
     * invokes the read method for the property 'roundaboutExitNumber'. The
     * onRoundaboutExitNumberGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'roundaboutExitNumber'</b>:
     *
     * Attribute provides the round about Exit Number
     */
    virtual void onRoundaboutExitNumberGet(const ::boost::shared_ptr< RoundaboutExitNumberGet >& payload);

    /**
     * Sends back the update to a previous onRoundaboutExitNumberGet().
     *
     * <b>Documentation of 'roundaboutExitNumber'</b>:
     *
     * Attribute provides the round about Exit Number
     *
     * @param act Identifies a previous invocation of
     * onRoundaboutExitNumberGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRoundaboutExitNumberGetUpdate(uint16 roundaboutExitNumber, act_t act = 0);

    /**
     * Set the value of the property 'roundaboutExitNumber' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'roundaboutExitNumber'</b>:
     *
     * Attribute provides the round about Exit Number
     */
    void setRoundaboutExitNumber(uint16 roundaboutExitNumber);

    /**
     * Returns the current value of the property 'roundaboutExitNumber'.
     *
     * <b>Documentation of 'roundaboutExitNumber'</b>:
     *
     * Attribute provides the round about Exit Number
     */
    uint16 getRoundaboutExitNumber() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRoundaboutExitNumberUpdate().
     *
     * <b>Documentation of 'roundaboutExitNumber'</b>:
     *
     * Attribute provides the round about Exit Number
     */
    void sendRoundaboutExitNumberUpdate();

    // property 'nextTurntoStreet'

    /**
     * The method onNextTurntoStreetGet() is called by ASF when a client
     * invokes the read method for the property 'nextTurntoStreet'. The
     * onNextTurntoStreetGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     */
    virtual void onNextTurntoStreetGet(const ::boost::shared_ptr< NextTurntoStreetGet >& payload);

    /**
     * Sends back the update to a previous onNextTurntoStreetGet().
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     *
     * @param act Identifies a previous invocation of onNextTurntoStreetGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendNextTurntoStreetGetUpdate(const ::std::string& nextTurntoStreet, act_t act = 0);

    /**
     * Set the value of the property 'nextTurntoStreet' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     */
    void setNextTurntoStreet(const ::std::string& nextTurntoStreet);

    /**
     * Returns the current value of the property 'nextTurntoStreet'.
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     */
    const ::std::string& getNextTurntoStreet() const;

    /**
     * Returns the current value of the property 'nextTurntoStreet' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendNextTurntoStreetUpdate() method.
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     */
    ::std::string& getNextTurntoStreetMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNextTurntoStreetUpdate().
     *
     * <b>Documentation of 'nextTurntoStreet'</b>:
     *
     * Attribute provides the next turn to street - DEPRECATED (no longer supported)
     */
    void sendNextTurntoStreetUpdate();

    // property 'barGraphInfo'

    /**
     * The method onBarGraphInfoGet() is called by ASF when a client invokes
     * the read method for the property 'barGraphInfo'. The
     * onBarGraphInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     */
    virtual void onBarGraphInfoGet(const ::boost::shared_ptr< BarGraphInfoGet >& payload);

    /**
     * Sends back the update to a previous onBarGraphInfoGet().
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     *
     * @param act Identifies a previous invocation of onBarGraphInfoGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBarGraphInfoGetUpdate(const BarGraphInfo& barGraphInfo, act_t act = 0);

    /**
     * Set the value of the property 'barGraphInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     */
    void setBarGraphInfo(const BarGraphInfo& barGraphInfo);

    /**
     * Returns the current value of the property 'barGraphInfo'.
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     */
    const BarGraphInfo& getBarGraphInfo() const;

    /**
     * Returns the current value of the property 'barGraphInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendBarGraphInfoUpdate() method.
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     */
    BarGraphInfo& getBarGraphInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendBarGraphInfoUpdate().
     *
     * <b>Documentation of 'barGraphInfo'</b>:
     *
     * Attribute provides barGraph value and state along with unit information
     */
    void sendBarGraphInfoUpdate();

    // property 'maneuverSymbol'

    /**
     * The method onManeuverSymbolGet() is called by ASF when a client invokes
     * the read method for the property 'maneuverSymbol'. The
     * onManeuverSymbolGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'maneuverSymbol'</b>:
     *
     * Destination straight ahead and further enum values indicate clockwise
     */
    virtual void onManeuverSymbolGet(const ::boost::shared_ptr< ManeuverSymbolGet >& payload);

    /**
     * Sends back the update to a previous onManeuverSymbolGet().
     *
     * <b>Documentation of 'maneuverSymbol'</b>:
     *
     * Destination straight ahead and further enum values indicate clockwise
     *
     * @param act Identifies a previous invocation of onManeuverSymbolGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendManeuverSymbolGetUpdate(ManeuverSymbol maneuverSymbol, act_t act = 0);

    /**
     * Set the value of the property 'maneuverSymbol' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'maneuverSymbol'</b>:
     *
     * Destination straight ahead and further enum values indicate clockwise
     */
    void setManeuverSymbol(ManeuverSymbol maneuverSymbol);

    /**
     * Returns the current value of the property 'maneuverSymbol'.
     *
     * <b>Documentation of 'maneuverSymbol'</b>:
     *
     * Destination straight ahead and further enum values indicate clockwise
     */
    ManeuverSymbol getManeuverSymbol() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendManeuverSymbolUpdate().
     *
     * <b>Documentation of 'maneuverSymbol'</b>:
     *
     * Destination straight ahead and further enum values indicate clockwise
     */
    void sendManeuverSymbolUpdate();

    // property 'satelliteInfo'

    /**
     * The method onSatelliteInfoGet() is called by ASF when a client invokes
     * the read method for the property 'satelliteInfo'. The
     * onSatelliteInfoGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     */
    virtual void onSatelliteInfoGet(const ::boost::shared_ptr< SatelliteInfoGet >& payload);

    /**
     * Sends back the update to a previous onSatelliteInfoGet().
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     *
     * @param act Identifies a previous invocation of onSatelliteInfoGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSatelliteInfoGetUpdate(const SatelliteInfo& satelliteInfo, act_t act = 0);

    /**
     * Set the value of the property 'satelliteInfo' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     */
    void setSatelliteInfo(const SatelliteInfo& satelliteInfo);

    /**
     * Returns the current value of the property 'satelliteInfo'.
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     */
    const SatelliteInfo& getSatelliteInfo() const;

    /**
     * Returns the current value of the property 'satelliteInfo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSatelliteInfoUpdate() method.
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     */
    SatelliteInfo& getSatelliteInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSatelliteInfoUpdate().
     *
     * <b>Documentation of 'satelliteInfo'</b>:
     *
     * Attribute provides satellite sensor information
     */
    void sendSatelliteInfoUpdate();

    // property 'destinationInformation'

    /**
     * The method onDestinationInformationGet() is called by ASF when a client
     * invokes the read method for the property 'destinationInformation'. The
     * onDestinationInformationGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     */
    virtual void onDestinationInformationGet(const ::boost::shared_ptr< DestinationInformationGet >& payload);

    /**
     * Sends back the update to a previous onDestinationInformationGet().
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     *
     * @param act Identifies a previous invocation of
     * onDestinationInformationGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDestinationInformationGetUpdate(const ::std::vector< DestinationInfoElement >& destinationInformation, act_t act = 0);

    /**
     * Set the value of the property 'destinationInformation' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     */
    void setDestinationInformation(const ::std::vector< DestinationInfoElement >& destinationInformation);

    /**
     * Returns the current value of the property 'destinationInformation'.
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     */
    const ::std::vector< DestinationInfoElement >& getDestinationInformation() const;

    /**
     * Returns the current value of the property 'destinationInformation' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendDestinationInformationUpdate() method.
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     */
    ::std::vector< DestinationInfoElement >& getDestinationInformationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDestinationInformationUpdate().
     *
     * <b>Documentation of 'destinationInformation'</b>:
     *
     * Attribute provides destination information on the currently guided tour
     */
    void sendDestinationInformationUpdate();

    // property 'routeCalculationDuration'

    /**
     * The method onRouteCalculationDurationGet() is called by ASF when a
     * client invokes the read method for the property
     * 'routeCalculationDuration'. The onRouteCalculationDurationGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    virtual void onRouteCalculationDurationGet(const ::boost::shared_ptr< RouteCalculationDurationGet >& payload);

    /**
     * Sends back the update to a previous onRouteCalculationDurationGet().
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     *
     * @param act Identifies a previous invocation of
     * onRouteCalculationDurationGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRouteCalculationDurationGetUpdate(const RouteCalculationDuration& routeCalculationDuration, act_t act = 0);

    /**
     * The method onRouteCalculationDurationSet() is called by ASF when a
     * client invokes the write method for the property
     * 'routeCalculationDuration'. The onRouteCalculationDurationSet() method
     * set property value to the given parameter routeCalculationDuration by
     * default. If this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    virtual void onRouteCalculationDurationSet(const ::boost::shared_ptr< RouteCalculationDurationSet >& payload);

    /**
     * Sends back the update to a previous onRouteCalculationDurationSet().
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     *
     * @param act Identifies a previous invocation of
     * onRouteCalculationDurationSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRouteCalculationDurationSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'routeCalculationDuration' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    void setRouteCalculationDuration(const RouteCalculationDuration& routeCalculationDuration);

    /**
     * Returns the current value of the property 'routeCalculationDuration'.
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    const RouteCalculationDuration& getRouteCalculationDuration() const;

    /**
     * Returns the current value of the property 'routeCalculationDuration' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendRouteCalculationDurationUpdate() method.
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    RouteCalculationDuration& getRouteCalculationDurationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRouteCalculationDurationUpdate().
     *
     * <b>Documentation of 'routeCalculationDuration'</b>:
     *
     * Attribute provides duration of Search and Guidance
     */
    void sendRouteCalculationDurationUpdate();

    // property 'homeLocation'

    /**
     * The method onHomeLocationGet() is called by ASF when a client invokes
     * the read method for the property 'homeLocation'. The
     * onHomeLocationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     */
    virtual void onHomeLocationGet(const ::boost::shared_ptr< HomeLocationGet >& payload);

    /**
     * Sends back the update to a previous onHomeLocationGet().
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     *
     * @param act Identifies a previous invocation of onHomeLocationGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHomeLocationGetUpdate(const Location& homeLocation, act_t act = 0);

    /**
     * Set the value of the property 'homeLocation' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     */
    void setHomeLocation(const Location& homeLocation);

    /**
     * Returns the current value of the property 'homeLocation'.
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     */
    const Location& getHomeLocation() const;

    /**
     * Returns the current value of the property 'homeLocation' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendHomeLocationUpdate() method.
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     */
    Location& getHomeLocationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendHomeLocationUpdate().
     *
     * <b>Documentation of 'homeLocation'</b>:
     *
     * Attribute provides location of the navigation home location, if set
     */
    void sendHomeLocationUpdate();

    // property 'workLocation'

    /**
     * The method onWorkLocationGet() is called by ASF when a client invokes
     * the read method for the property 'workLocation'. The
     * onWorkLocationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     */
    virtual void onWorkLocationGet(const ::boost::shared_ptr< WorkLocationGet >& payload);

    /**
     * Sends back the update to a previous onWorkLocationGet().
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     *
     * @param act Identifies a previous invocation of onWorkLocationGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWorkLocationGetUpdate(const Location& workLocation, act_t act = 0);

    /**
     * Set the value of the property 'workLocation' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     */
    void setWorkLocation(const Location& workLocation);

    /**
     * Returns the current value of the property 'workLocation'.
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     */
    const Location& getWorkLocation() const;

    /**
     * Returns the current value of the property 'workLocation' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWorkLocationUpdate() method.
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     */
    Location& getWorkLocationMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWorkLocationUpdate().
     *
     * <b>Documentation of 'workLocation'</b>:
     *
     * Attribute provides location of the navigation work location, if set
     */
    void sendWorkLocationUpdate();

    // property 'mapRepresentation'

    /**
     * The method onMapRepresentationGet() is called by ASF when a client
     * invokes the read method for the property 'mapRepresentation'. The
     * onMapRepresentationGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'mapRepresentation'</b>:
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     */
    virtual void onMapRepresentationGet(const ::boost::shared_ptr< MapRepresentationGet >& payload);

    /**
     * Sends back the update to a previous onMapRepresentationGet().
     *
     * <b>Documentation of 'mapRepresentation'</b>:
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     *
     * @param act Identifies a previous invocation of
     * onMapRepresentationGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapRepresentationGetUpdate(MapRepresentation mapRepresentation, act_t act = 0);

    /**
     * Set the value of the property 'mapRepresentation' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'mapRepresentation'</b>:
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     */
    void setMapRepresentation(MapRepresentation mapRepresentation);

    /**
     * Returns the current value of the property 'mapRepresentation'.
     *
     * <b>Documentation of 'mapRepresentation'</b>:
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     */
    MapRepresentation getMapRepresentation() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapRepresentationUpdate().
     *
     * <b>Documentation of 'mapRepresentation'</b>:
     *
     * Attribute provides the map representation (orientation and 2D / 3D)
     */
    void sendMapRepresentationUpdate();

    // property 'sdsAddressWithOptions'

    /**
     * The method onSdsAddressWithOptionsGet() is called by ASF when a client
     * invokes the read method for the property 'sdsAddressWithOptions'. The
     * onSdsAddressWithOptionsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    virtual void onSdsAddressWithOptionsGet(const ::boost::shared_ptr< SdsAddressWithOptionsGet >& payload);

    /**
     * Sends back the update to a previous onSdsAddressWithOptionsGet().
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     *
     * @param act Identifies a previous invocation of
     * onSdsAddressWithOptionsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsAddressWithOptionsGetUpdate(const SDSAddressWithOptions& sdsAddressWithOptions, act_t act = 0);

    /**
     * Set the value of the property 'sdsAddressWithOptions' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    void setSdsAddressWithOptions(const SDSAddressWithOptions& sdsAddressWithOptions);

    /**
     * Returns the current value of the property 'sdsAddressWithOptions'.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    const SDSAddressWithOptions& getSdsAddressWithOptions() const;

    /**
     * Returns the current value of the property 'sdsAddressWithOptions' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSdsAddressWithOptionsUpdate() method.
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    SDSAddressWithOptions& getSdsAddressWithOptionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsAddressWithOptionsUpdate().
     *
     * <b>Documentation of 'sdsAddressWithOptions'</b>:
     *
     * Attribute provides the current SDS address entry
     */
    void sendSdsAddressWithOptionsUpdate();

    // property 'waypointList'

    /**
     * The method onWaypointListGet() is called by ASF when a client invokes
     * the read method for the property 'waypointList'. The
     * onWaypointListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     */
    virtual void onWaypointListGet(const ::boost::shared_ptr< WaypointListGet >& payload);

    /**
     * Sends back the update to a previous onWaypointListGet().
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @param act Identifies a previous invocation of onWaypointListGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendWaypointListGetUpdate(const ::std::vector< WaypointListElement >& waypointList, act_t act = 0);

    /**
     * Set the value of the property 'waypointList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     */
    void setWaypointList(const ::std::vector< WaypointListElement >& waypointList);

    /**
     * Returns the current value of the property 'waypointList'.
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     */
    const ::std::vector< WaypointListElement >& getWaypointList() const;

    /**
     * Returns the current value of the property 'waypointList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendWaypointListUpdate() method.
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     */
    ::std::vector< WaypointListElement >& getWaypointListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWaypointListUpdate().
     *
     * <b>Documentation of 'waypointList'</b>:
     *
     * Attribute provides inserted waypoints on property update ROUTE_WAYPOINTINFOS_CHANGED
     */
    void sendWaypointListUpdate();

    // property 'maneuverView'

    /**
     * The method onManeuverViewGet() is called by ASF when a client invokes
     * the read method for the property 'maneuverView'. The
     * onManeuverViewGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     */
    virtual void onManeuverViewGet(const ::boost::shared_ptr< ManeuverViewGet >& payload);

    /**
     * Sends back the update to a previous onManeuverViewGet().
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     *
     * @param act Identifies a previous invocation of onManeuverViewGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendManeuverViewGetUpdate(const ManeuverView& maneuverView, act_t act = 0);

    /**
     * Set the value of the property 'maneuverView' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     */
    void setManeuverView(const ManeuverView& maneuverView);

    /**
     * Returns the current value of the property 'maneuverView'.
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     */
    const ManeuverView& getManeuverView() const;

    /**
     * Returns the current value of the property 'maneuverView' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendManeuverViewUpdate() method.
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     */
    ManeuverView& getManeuverViewMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendManeuverViewUpdate().
     *
     * <b>Documentation of 'maneuverView'</b>:
     *
     * Attribute provides the maneuver view information
     */
    void sendManeuverViewUpdate();

    // property 'intersectionMapCarsorPosition'

    /**
     * The method onIntersectionMapCarsorPositionGet() is called by ASF when a
     * client invokes the read method for the property
     * 'intersectionMapCarsorPosition'. The
     * onIntersectionMapCarsorPositionGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     */
    virtual void onIntersectionMapCarsorPositionGet(const ::boost::shared_ptr< IntersectionMapCarsorPositionGet >& payload);

    /**
     * Sends back the update to a previous
     * onIntersectionMapCarsorPositionGet().
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     *
     * @param act Identifies a previous invocation of
     * onIntersectionMapCarsorPositionGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendIntersectionMapCarsorPositionGetUpdate(const IntersectionMapCarsorPosition& intersectionMapCarsorPosition, act_t act = 0);

    /**
     * Set the value of the property 'intersectionMapCarsorPosition' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     */
    void setIntersectionMapCarsorPosition(const IntersectionMapCarsorPosition& intersectionMapCarsorPosition);

    /**
     * Returns the current value of the property 'intersectionMapCarsorPosition'.
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     */
    const IntersectionMapCarsorPosition& getIntersectionMapCarsorPosition() const;

    /**
     * Returns the current value of the property
     * 'intersectionMapCarsorPosition' as a mutable reference. If you change
     * the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendIntersectionMapCarsorPositionUpdate() method.
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     */
    IntersectionMapCarsorPosition& getIntersectionMapCarsorPositionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIntersectionMapCarsorPositionUpdate().
     *
     * <b>Documentation of 'intersectionMapCarsorPosition'</b>:
     *
     * Attribute provides the carsorPosition in the intersection map
     */
    void sendIntersectionMapCarsorPositionUpdate();

    // property 'speedLimit'

    /**
     * The method onSpeedLimitGet() is called by ASF when a client invokes the
     * read method for the property 'speedLimit'. The onSpeedLimitGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     */
    virtual void onSpeedLimitGet(const ::boost::shared_ptr< SpeedLimitGet >& payload);

    /**
     * Sends back the update to a previous onSpeedLimitGet().
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     *
     * @param act Identifies a previous invocation of onSpeedLimitGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSpeedLimitGetUpdate(const SpeedLimit& speedLimit, act_t act = 0);

    /**
     * Set the value of the property 'speedLimit' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     */
    void setSpeedLimit(const SpeedLimit& speedLimit);

    /**
     * Returns the current value of the property 'speedLimit'.
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     */
    const SpeedLimit& getSpeedLimit() const;

    /**
     * Returns the current value of the property 'speedLimit' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSpeedLimitUpdate() method.
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     */
    SpeedLimit& getSpeedLimitMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSpeedLimitUpdate().
     *
     * <b>Documentation of 'speedLimit'</b>:
     *
     * Attribute provides the Speed limit details
     */
    void sendSpeedLimitUpdate();

    // property 'trafficEnforcement'

    /**
     * The method onTrafficEnforcementGet() is called by ASF when a client
     * invokes the read method for the property 'trafficEnforcement'. The
     * onTrafficEnforcementGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    virtual void onTrafficEnforcementGet(const ::boost::shared_ptr< TrafficEnforcementGet >& payload);

    /**
     * Sends back the update to a previous onTrafficEnforcementGet().
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     *
     * @param act Identifies a previous invocation of
     * onTrafficEnforcementGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTrafficEnforcementGetUpdate(const TrafficEnforcement& trafficEnforcement, act_t act = 0);

    /**
     * The method onTrafficEnforcementSet() is called by ASF when a client
     * invokes the write method for the property 'trafficEnforcement'. The
     * onTrafficEnforcementSet() method set property value to the given
     * parameter trafficEnforcement by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    virtual void onTrafficEnforcementSet(const ::boost::shared_ptr< TrafficEnforcementSet >& payload);

    /**
     * Sends back the update to a previous onTrafficEnforcementSet().
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     *
     * @param act Identifies a previous invocation of
     * onTrafficEnforcementSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTrafficEnforcementSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'trafficEnforcement' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    void setTrafficEnforcement(const TrafficEnforcement& trafficEnforcement);

    /**
     * Returns the current value of the property 'trafficEnforcement'.
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    const TrafficEnforcement& getTrafficEnforcement() const;

    /**
     * Returns the current value of the property 'trafficEnforcement' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendTrafficEnforcementUpdate() method.
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    TrafficEnforcement& getTrafficEnforcementMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTrafficEnforcementUpdate().
     *
     * <b>Documentation of 'trafficEnforcement'</b>:
     *
     * Indicates traffic/speed controlled areas
     */
    void sendTrafficEnforcementUpdate();

    // property 'nextManeuverDetails'

    /**
     * The method onNextManeuverDetailsGet() is called by ASF when a client
     * invokes the read method for the property 'nextManeuverDetails'. The
     * onNextManeuverDetailsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     */
    virtual void onNextManeuverDetailsGet(const ::boost::shared_ptr< NextManeuverDetailsGet >& payload);

    /**
     * Sends back the update to a previous onNextManeuverDetailsGet().
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     *
     * @param act Identifies a previous invocation of
     * onNextManeuverDetailsGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendNextManeuverDetailsGetUpdate(const NextManeuverDetails& nextManeuverDetails, act_t act = 0);

    /**
     * Set the value of the property 'nextManeuverDetails' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     */
    void setNextManeuverDetails(const NextManeuverDetails& nextManeuverDetails);

    /**
     * Returns the current value of the property 'nextManeuverDetails'.
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     */
    const NextManeuverDetails& getNextManeuverDetails() const;

    /**
     * Returns the current value of the property 'nextManeuverDetails' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendNextManeuverDetailsUpdate() method.
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     */
    NextManeuverDetails& getNextManeuverDetailsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNextManeuverDetailsUpdate().
     *
     * <b>Documentation of 'nextManeuverDetails'</b>:
     *
     * Attribute provides the Maneuver details
     */
    void sendNextManeuverDetailsUpdate();

    // property 'laneRecommendationList'

    /**
     * The method onLaneRecommendationListGet() is called by ASF when a client
     * invokes the read method for the property 'laneRecommendationList'. The
     * onLaneRecommendationListGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     */
    virtual void onLaneRecommendationListGet(const ::boost::shared_ptr< LaneRecommendationListGet >& payload);

    /**
     * Sends back the update to a previous onLaneRecommendationListGet().
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     *
     * @param act Identifies a previous invocation of
     * onLaneRecommendationListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendLaneRecommendationListGetUpdate(const ::std::vector< LaneRecommendation >& laneRecommendationList, act_t act = 0);

    /**
     * Set the value of the property 'laneRecommendationList' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     */
    void setLaneRecommendationList(const ::std::vector< LaneRecommendation >& laneRecommendationList);

    /**
     * Returns the current value of the property 'laneRecommendationList'.
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     */
    const ::std::vector< LaneRecommendation >& getLaneRecommendationList() const;

    /**
     * Returns the current value of the property 'laneRecommendationList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendLaneRecommendationListUpdate() method.
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     */
    ::std::vector< LaneRecommendation >& getLaneRecommendationListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLaneRecommendationListUpdate().
     *
     * <b>Documentation of 'laneRecommendationList'</b>:
     *
     * Attribute provides the Lane recommendation list
     */
    void sendLaneRecommendationListUpdate();

    // property 'arrivalInformationList'

    /**
     * The method onArrivalInformationListGet() is called by ASF when a client
     * invokes the read method for the property 'arrivalInformationList'. The
     * onArrivalInformationListGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     */
    virtual void onArrivalInformationListGet(const ::boost::shared_ptr< ArrivalInformationListGet >& payload);

    /**
     * Sends back the update to a previous onArrivalInformationListGet().
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     *
     * @param act Identifies a previous invocation of
     * onArrivalInformationListGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendArrivalInformationListGetUpdate(const ::std::vector< ArrivalInformation >& arrivalInformationList, act_t act = 0);

    /**
     * Set the value of the property 'arrivalInformationList' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     */
    void setArrivalInformationList(const ::std::vector< ArrivalInformation >& arrivalInformationList);

    /**
     * Returns the current value of the property 'arrivalInformationList'.
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     */
    const ::std::vector< ArrivalInformation >& getArrivalInformationList() const;

    /**
     * Returns the current value of the property 'arrivalInformationList' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendArrivalInformationListUpdate() method.
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     */
    ::std::vector< ArrivalInformation >& getArrivalInformationListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendArrivalInformationListUpdate().
     *
     * <b>Documentation of 'arrivalInformationList'</b>:
     *
     * Attribute provides the Arrival infos array
     */
    void sendArrivalInformationListUpdate();

    // property 'intersectionMap'

    /**
     * The method onIntersectionMapGet() is called by ASF when a client
     * invokes the read method for the property 'intersectionMap'. The
     * onIntersectionMapGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     */
    virtual void onIntersectionMapGet(const ::boost::shared_ptr< IntersectionMapGet >& payload);

    /**
     * Sends back the update to a previous onIntersectionMapGet().
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     *
     * @param act Identifies a previous invocation of onIntersectionMapGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendIntersectionMapGetUpdate(const IntersectionMap& intersectionMap, act_t act = 0);

    /**
     * Set the value of the property 'intersectionMap' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     */
    void setIntersectionMap(const IntersectionMap& intersectionMap);

    /**
     * Returns the current value of the property 'intersectionMap'.
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     */
    const IntersectionMap& getIntersectionMap() const;

    /**
     * Returns the current value of the property 'intersectionMap' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendIntersectionMapUpdate() method.
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     */
    IntersectionMap& getIntersectionMapMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIntersectionMapUpdate().
     *
     * <b>Documentation of 'intersectionMap'</b>:
     *
     * Attribute provides intersection map information for cluster
     */
    void sendIntersectionMapUpdate();

    // property 'isAddressBookChanged'

    /**
     * The method onIsAddressBookChangedGet() is called by ASF when a client
     * invokes the read method for the property 'isAddressBookChanged'. The
     * onIsAddressBookChangedGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'isAddressBookChanged'</b>:
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     */
    virtual void onIsAddressBookChangedGet(const ::boost::shared_ptr< IsAddressBookChangedGet >& payload);

    /**
     * Sends back the update to a previous onIsAddressBookChangedGet().
     *
     * <b>Documentation of 'isAddressBookChanged'</b>:
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     *
     * @param act Identifies a previous invocation of
     * onIsAddressBookChangedGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendIsAddressBookChangedGetUpdate(bool isAddressBookChanged, act_t act = 0);

    /**
     * Set the value of the property 'isAddressBookChanged' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'isAddressBookChanged'</b>:
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     */
    void setIsAddressBookChanged(bool isAddressBookChanged);

    /**
     * Returns the current value of the property 'isAddressBookChanged'.
     *
     * <b>Documentation of 'isAddressBookChanged'</b>:
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     */
    bool getIsAddressBookChanged() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIsAddressBookChangedUpdate().
     *
     * <b>Documentation of 'isAddressBookChanged'</b>:
     *
     * Attribute provides info if Address book has to be requested again using the method requestDestinationMemoryEntries
     */
    void sendIsAddressBookChangedUpdate();

    // property 'isMaxAllowedAddressBookEntriesStored'

    /**
     * The method onIsMaxAllowedAddressBookEntriesStoredGet() is called by ASF
     * when a client invokes the read method for the property
     * 'isMaxAllowedAddressBookEntriesStored'. The
     * onIsMaxAllowedAddressBookEntriesStoredGet() method returns by default
     * the current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'isMaxAllowedAddressBookEntriesStored'</b>:
     *
     * Attribute provides info if max allowed entries stored in addressbook
     */
    virtual void onIsMaxAllowedAddressBookEntriesStoredGet(const ::boost::shared_ptr< IsMaxAllowedAddressBookEntriesStoredGet >& payload);

    /**
     * Sends back the update to a previous
     * onIsMaxAllowedAddressBookEntriesStoredGet().
     *
     * <b>Documentation of 'isMaxAllowedAddressBookEntriesStored'</b>:
     *
     * Attribute provides info if max allowed entries stored in addressbook
     *
     * @param act Identifies a previous invocation of
     * onIsMaxAllowedAddressBookEntriesStoredGet(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendIsMaxAllowedAddressBookEntriesStoredGetUpdate(bool isMaxAllowedAddressBookEntriesStored, act_t act = 0);

    /**
     * Set the value of the property 'isMaxAllowedAddressBookEntriesStored'
     * and send updates to registered clients. No updates will be sent if the
     * property value does not change.
     *
     * <b>Documentation of 'isMaxAllowedAddressBookEntriesStored'</b>:
     *
     * Attribute provides info if max allowed entries stored in addressbook
     */
    void setIsMaxAllowedAddressBookEntriesStored(bool isMaxAllowedAddressBookEntriesStored);

    /**
     * Returns the current value of the property 'isMaxAllowedAddressBookEntriesStored'.
     *
     * <b>Documentation of 'isMaxAllowedAddressBookEntriesStored'</b>:
     *
     * Attribute provides info if max allowed entries stored in addressbook
     */
    bool getIsMaxAllowedAddressBookEntriesStored() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIsMaxAllowedAddressBookEntriesStoredUpdate().
     *
     * <b>Documentation of 'isMaxAllowedAddressBookEntriesStored'</b>:
     *
     * Attribute provides info if max allowed entries stored in addressbook
     */
    void sendIsMaxAllowedAddressBookEntriesStoredUpdate();

    // property 'isLastDestinationListChanged'

    /**
     * The method onIsLastDestinationListChangedGet() is called by ASF when a
     * client invokes the read method for the property
     * 'isLastDestinationListChanged'. The onIsLastDestinationListChangedGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'isLastDestinationListChanged'</b>:
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     */
    virtual void onIsLastDestinationListChangedGet(const ::boost::shared_ptr< IsLastDestinationListChangedGet >& payload);

    /**
     * Sends back the update to a previous
     * onIsLastDestinationListChangedGet().
     *
     * <b>Documentation of 'isLastDestinationListChanged'</b>:
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     *
     * @param act Identifies a previous invocation of
     * onIsLastDestinationListChangedGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendIsLastDestinationListChangedGetUpdate(bool isLastDestinationListChanged, act_t act = 0);

    /**
     * Set the value of the property 'isLastDestinationListChanged' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'isLastDestinationListChanged'</b>:
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     */
    void setIsLastDestinationListChanged(bool isLastDestinationListChanged);

    /**
     * Returns the current value of the property 'isLastDestinationListChanged'.
     *
     * <b>Documentation of 'isLastDestinationListChanged'</b>:
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     */
    bool getIsLastDestinationListChanged() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIsLastDestinationListChangedUpdate().
     *
     * <b>Documentation of 'isLastDestinationListChanged'</b>:
     *
     * Attribute provides info if LastDestination list has to be requested again using the method requestDestinationMemoryEntries
     */
    void sendIsLastDestinationListChangedUpdate();

    // property 'isVoiceGuidanceActive'

    /**
     * The method onIsVoiceGuidanceActiveGet() is called by ASF when a client
     * invokes the read method for the property 'isVoiceGuidanceActive'. The
     * onIsVoiceGuidanceActiveGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'isVoiceGuidanceActive'</b>:
     *
     * Attribute provides voice guidance status
     */
    virtual void onIsVoiceGuidanceActiveGet(const ::boost::shared_ptr< IsVoiceGuidanceActiveGet >& payload);

    /**
     * Sends back the update to a previous onIsVoiceGuidanceActiveGet().
     *
     * <b>Documentation of 'isVoiceGuidanceActive'</b>:
     *
     * Attribute provides voice guidance status
     *
     * @param act Identifies a previous invocation of
     * onIsVoiceGuidanceActiveGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendIsVoiceGuidanceActiveGetUpdate(bool isVoiceGuidanceActive, act_t act = 0);

    /**
     * Set the value of the property 'isVoiceGuidanceActive' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'isVoiceGuidanceActive'</b>:
     *
     * Attribute provides voice guidance status
     */
    void setIsVoiceGuidanceActive(bool isVoiceGuidanceActive);

    /**
     * Returns the current value of the property 'isVoiceGuidanceActive'.
     *
     * <b>Documentation of 'isVoiceGuidanceActive'</b>:
     *
     * Attribute provides voice guidance status
     */
    bool getIsVoiceGuidanceActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendIsVoiceGuidanceActiveUpdate().
     *
     * <b>Documentation of 'isVoiceGuidanceActive'</b>:
     *
     * Attribute provides voice guidance status
     */
    void sendIsVoiceGuidanceActiveUpdate();

    // property 'sdsVoiceTagWithOptions'

    /**
     * The method onSdsVoiceTagWithOptionsGet() is called by ASF when a client
     * invokes the read method for the property 'sdsVoiceTagWithOptions'. The
     * onSdsVoiceTagWithOptionsGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    virtual void onSdsVoiceTagWithOptionsGet(const ::boost::shared_ptr< SdsVoiceTagWithOptionsGet >& payload);

    /**
     * Sends back the update to a previous onSdsVoiceTagWithOptionsGet().
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     *
     * @param act Identifies a previous invocation of
     * onSdsVoiceTagWithOptionsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsVoiceTagWithOptionsGetUpdate(const SDSVoiceTagId& sdsVoiceTagWithOptions, act_t act = 0);

    /**
     * Set the value of the property 'sdsVoiceTagWithOptions' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    void setSdsVoiceTagWithOptions(const SDSVoiceTagId& sdsVoiceTagWithOptions);

    /**
     * Returns the current value of the property 'sdsVoiceTagWithOptions'.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    const SDSVoiceTagId& getSdsVoiceTagWithOptions() const;

    /**
     * Returns the current value of the property 'sdsVoiceTagWithOptions' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendSdsVoiceTagWithOptionsUpdate() method.
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    SDSVoiceTagId& getSdsVoiceTagWithOptionsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsVoiceTagWithOptionsUpdate().
     *
     * <b>Documentation of 'sdsVoiceTagWithOptions'</b>:
     *
     * Attribute used as a request by Navgation to Create/Play/Delete voice tags
     */
    void sendSdsVoiceTagWithOptionsUpdate();

    // property 'trafficMessagesCount'

    /**
     * The method onTrafficMessagesCountGet() is called by ASF when a client
     * invokes the read method for the property 'trafficMessagesCount'. The
     * onTrafficMessagesCountGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     */
    virtual void onTrafficMessagesCountGet(const ::boost::shared_ptr< TrafficMessagesCountGet >& payload);

    /**
     * Sends back the update to a previous onTrafficMessagesCountGet().
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     *
     * @param act Identifies a previous invocation of
     * onTrafficMessagesCountGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTrafficMessagesCountGetUpdate(uint8 trafficMessagesCount, act_t act = 0);

    /**
     * The method onTrafficMessagesCountSet() is called by ASF when a client
     * invokes the write method for the property 'trafficMessagesCount'. The
     * onTrafficMessagesCountSet() method set property value to the given
     * parameter trafficMessagesCount by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     */
    virtual void onTrafficMessagesCountSet(const ::boost::shared_ptr< TrafficMessagesCountSet >& payload);

    /**
     * Sends back the update to a previous onTrafficMessagesCountSet().
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     *
     * @param act Identifies a previous invocation of
     * onTrafficMessagesCountSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTrafficMessagesCountSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'trafficMessagesCount' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     */
    void setTrafficMessagesCount(uint8 trafficMessagesCount);

    /**
     * Returns the current value of the property 'trafficMessagesCount'.
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     */
    uint8 getTrafficMessagesCount() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTrafficMessagesCountUpdate().
     *
     * <b>Documentation of 'trafficMessagesCount'</b>:
     *
     * Attribute provides traffic message count
     */
    void sendTrafficMessagesCountUpdate();

    // property 'trafficServiceReceptionStatus'

    /**
     * The method onTrafficServiceReceptionStatusGet() is called by ASF when a
     * client invokes the read method for the property
     * 'trafficServiceReceptionStatus'. The
     * onTrafficServiceReceptionStatusGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    virtual void onTrafficServiceReceptionStatusGet(const ::boost::shared_ptr< TrafficServiceReceptionStatusGet >& payload);

    /**
     * Sends back the update to a previous
     * onTrafficServiceReceptionStatusGet().
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     *
     * @param act Identifies a previous invocation of
     * onTrafficServiceReceptionStatusGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendTrafficServiceReceptionStatusGetUpdate(const TrafficServiceReceptionStatus& trafficServiceReceptionStatus, act_t act = 0);

    /**
     * The method onTrafficServiceReceptionStatusSet() is called by ASF when a
     * client invokes the write method for the property
     * 'trafficServiceReceptionStatus'. The
     * onTrafficServiceReceptionStatusSet() method set property value to the
     * given parameter trafficServiceReceptionStatus by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    virtual void onTrafficServiceReceptionStatusSet(const ::boost::shared_ptr< TrafficServiceReceptionStatusSet >& payload);

    /**
     * Sends back the update to a previous
     * onTrafficServiceReceptionStatusSet().
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     *
     * @param act Identifies a previous invocation of
     * onTrafficServiceReceptionStatusSet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendTrafficServiceReceptionStatusSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'trafficServiceReceptionStatus' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    void setTrafficServiceReceptionStatus(const TrafficServiceReceptionStatus& trafficServiceReceptionStatus);

    /**
     * Returns the current value of the property 'trafficServiceReceptionStatus'.
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    const TrafficServiceReceptionStatus& getTrafficServiceReceptionStatus() const;

    /**
     * Returns the current value of the property
     * 'trafficServiceReceptionStatus' as a mutable reference. If you change
     * the content of the returned object you have to send updates to
     * registered clients by yourself with the help of the
     * sendTrafficServiceReceptionStatusUpdate() method.
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    TrafficServiceReceptionStatus& getTrafficServiceReceptionStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTrafficServiceReceptionStatusUpdate().
     *
     * <b>Documentation of 'trafficServiceReceptionStatus'</b>:
     *
     * Attribute provides Traffic service reception status
     */
    void sendTrafficServiceReceptionStatusUpdate();

    // property 'sdsPOICategoryShortcuts'

    /**
     * The method onSdsPOICategoryShortcutsGet() is called by ASF when a
     * client invokes the read method for the property
     * 'sdsPOICategoryShortcuts'. The onSdsPOICategoryShortcutsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     */
    virtual void onSdsPOICategoryShortcutsGet(const ::boost::shared_ptr< SdsPOICategoryShortcutsGet >& payload);

    /**
     * Sends back the update to a previous onSdsPOICategoryShortcutsGet().
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     *
     * @param act Identifies a previous invocation of
     * onSdsPOICategoryShortcutsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsPOICategoryShortcutsGetUpdate(const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts, act_t act = 0);

    /**
     * Set the value of the property 'sdsPOICategoryShortcuts' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     */
    void setSdsPOICategoryShortcuts(const ::std::vector< PoiCategoryShortcut >& sdsPOICategoryShortcuts);

    /**
     * Returns the current value of the property 'sdsPOICategoryShortcuts'.
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     */
    const ::std::vector< PoiCategoryShortcut >& getSdsPOICategoryShortcuts() const;

    /**
     * Returns the current value of the property 'sdsPOICategoryShortcuts' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendSdsPOICategoryShortcutsUpdate() method.
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     */
    ::std::vector< PoiCategoryShortcut >& getSdsPOICategoryShortcutsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSdsPOICategoryShortcutsUpdate().
     *
     * <b>Documentation of 'sdsPOICategoryShortcuts'</b>:
     *
     * Attribute provides POI category shortcut names in current selected language
     */
    void sendSdsPOICategoryShortcutsUpdate();

    // property 'menuPoiCategoryShortcuts'

    /**
     * The method onMenuPoiCategoryShortcutsGet() is called by ASF when a
     * client invokes the read method for the property
     * 'menuPoiCategoryShortcuts'. The onMenuPoiCategoryShortcutsGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     */
    virtual void onMenuPoiCategoryShortcutsGet(const ::boost::shared_ptr< MenuPoiCategoryShortcutsGet >& payload);

    /**
     * Sends back the update to a previous onMenuPoiCategoryShortcutsGet().
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     *
     * @param act Identifies a previous invocation of
     * onMenuPoiCategoryShortcutsGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMenuPoiCategoryShortcutsGetUpdate(const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts, act_t act = 0);

    /**
     * Set the value of the property 'menuPoiCategoryShortcuts' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     */
    void setMenuPoiCategoryShortcuts(const ::std::vector< PoiCategoryShortcut >& menuPoiCategoryShortcuts);

    /**
     * Returns the current value of the property 'menuPoiCategoryShortcuts'.
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     */
    const ::std::vector< PoiCategoryShortcut >& getMenuPoiCategoryShortcuts() const;

    /**
     * Returns the current value of the property 'menuPoiCategoryShortcuts' as
     * a mutable reference. If you change the content of the returned object
     * you have to send updates to registered clients by yourself with the
     * help of the sendMenuPoiCategoryShortcutsUpdate() method.
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     */
    ::std::vector< PoiCategoryShortcut >& getMenuPoiCategoryShortcutsMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMenuPoiCategoryShortcutsUpdate().
     *
     * <b>Documentation of 'menuPoiCategoryShortcuts'</b>:
     *
     * Attribute provides POI Category Shortcut Names in current selected language
     */
    void sendMenuPoiCategoryShortcutsUpdate();

    // property 'tripReplayStatusInfo'

    /**
     * The method onTripReplayStatusInfoGet() is called by ASF when a client
     * invokes the read method for the property 'tripReplayStatusInfo'. The
     * onTripReplayStatusInfoGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     */
    virtual void onTripReplayStatusInfoGet(const ::boost::shared_ptr< TripReplayStatusInfoGet >& payload);

    /**
     * Sends back the update to a previous onTripReplayStatusInfoGet().
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     *
     * @param act Identifies a previous invocation of
     * onTripReplayStatusInfoGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTripReplayStatusInfoGetUpdate(const TripReplayStatusInfo& tripReplayStatusInfo, act_t act = 0);

    /**
     * Set the value of the property 'tripReplayStatusInfo' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     */
    void setTripReplayStatusInfo(const TripReplayStatusInfo& tripReplayStatusInfo);

    /**
     * Returns the current value of the property 'tripReplayStatusInfo'.
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     */
    const TripReplayStatusInfo& getTripReplayStatusInfo() const;

    /**
     * Returns the current value of the property 'tripReplayStatusInfo' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendTripReplayStatusInfoUpdate() method.
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     */
    TripReplayStatusInfo& getTripReplayStatusInfoMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTripReplayStatusInfoUpdate().
     *
     * <b>Documentation of 'tripReplayStatusInfo'</b>:
     *
     * Attribute provides trip replay status information
     */
    void sendTripReplayStatusInfoUpdate();

    // property 'etcStatus'

    /**
     * The method onEtcStatusGet() is called by ASF when a client invokes the
     * read method for the property 'etcStatus'. The onEtcStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'etcStatus'</b>:
     *
     * Attribute provides ETC status information
     */
    virtual void onEtcStatusGet(const ::boost::shared_ptr< EtcStatusGet >& payload);

    /**
     * Sends back the update to a previous onEtcStatusGet().
     *
     * <b>Documentation of 'etcStatus'</b>:
     *
     * Attribute provides ETC status information
     *
     * @param act Identifies a previous invocation of onEtcStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEtcStatusGetUpdate(ETCStatus etcStatus, act_t act = 0);

    /**
     * Set the value of the property 'etcStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'etcStatus'</b>:
     *
     * Attribute provides ETC status information
     */
    void setEtcStatus(ETCStatus etcStatus);

    /**
     * Returns the current value of the property 'etcStatus'.
     *
     * <b>Documentation of 'etcStatus'</b>:
     *
     * Attribute provides ETC status information
     */
    ETCStatus getEtcStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEtcStatusUpdate().
     *
     * <b>Documentation of 'etcStatus'</b>:
     *
     * Attribute provides ETC status information
     */
    void sendEtcStatusUpdate();

    // property 'TrafficSignInfoActive'

    /**
     * The method onTrafficSignInfoActiveGet() is called by ASF when a client
     * invokes the read method for the property 'TrafficSignInfoActive'. The
     * onTrafficSignInfoActiveGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'TrafficSignInfoActive'</b>:
     *
     * Attribute provides traffic sign status information
     */
    virtual void onTrafficSignInfoActiveGet(const ::boost::shared_ptr< TrafficSignInfoActiveGet >& payload);

    /**
     * Sends back the update to a previous onTrafficSignInfoActiveGet().
     *
     * <b>Documentation of 'TrafficSignInfoActive'</b>:
     *
     * Attribute provides traffic sign status information
     *
     * @param act Identifies a previous invocation of
     * onTrafficSignInfoActiveGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendTrafficSignInfoActiveGetUpdate(bool trafficSignInfoActive, act_t act = 0);

    /**
     * Set the value of the property 'TrafficSignInfoActive' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'TrafficSignInfoActive'</b>:
     *
     * Attribute provides traffic sign status information
     */
    void setTrafficSignInfoActive(bool trafficSignInfoActive);

    /**
     * Returns the current value of the property 'TrafficSignInfoActive'.
     *
     * <b>Documentation of 'TrafficSignInfoActive'</b>:
     *
     * Attribute provides traffic sign status information
     */
    bool getTrafficSignInfoActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTrafficSignInfoActiveUpdate().
     *
     * <b>Documentation of 'TrafficSignInfoActive'</b>:
     *
     * Attribute provides traffic sign status information
     */
    void sendTrafficSignInfoActiveUpdate();

    // property 'OverSpeedSoundAlertInfoActive'

    /**
     * The method onOverSpeedSoundAlertInfoActiveGet() is called by ASF when a
     * client invokes the read method for the property
     * 'OverSpeedSoundAlertInfoActive'. The
     * onOverSpeedSoundAlertInfoActiveGet() method returns by default the
     * current property value to the caller. In case this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'OverSpeedSoundAlertInfoActive'</b>:
     *
     * Attribute provides over speed sound alert status information
     */
    virtual void onOverSpeedSoundAlertInfoActiveGet(const ::boost::shared_ptr< OverSpeedSoundAlertInfoActiveGet >& payload);

    /**
     * Sends back the update to a previous
     * onOverSpeedSoundAlertInfoActiveGet().
     *
     * <b>Documentation of 'OverSpeedSoundAlertInfoActive'</b>:
     *
     * Attribute provides over speed sound alert status information
     *
     * @param act Identifies a previous invocation of
     * onOverSpeedSoundAlertInfoActiveGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendOverSpeedSoundAlertInfoActiveGetUpdate(bool overSpeedSoundAlertInfoActive, act_t act = 0);

    /**
     * Set the value of the property 'OverSpeedSoundAlertInfoActive' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'OverSpeedSoundAlertInfoActive'</b>:
     *
     * Attribute provides over speed sound alert status information
     */
    void setOverSpeedSoundAlertInfoActive(bool overSpeedSoundAlertInfoActive);

    /**
     * Returns the current value of the property 'OverSpeedSoundAlertInfoActive'.
     *
     * <b>Documentation of 'OverSpeedSoundAlertInfoActive'</b>:
     *
     * Attribute provides over speed sound alert status information
     */
    bool getOverSpeedSoundAlertInfoActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendOverSpeedSoundAlertInfoActiveUpdate().
     *
     * <b>Documentation of 'OverSpeedSoundAlertInfoActive'</b>:
     *
     * Attribute provides over speed sound alert status information
     */
    void sendOverSpeedSoundAlertInfoActiveUpdate();

    // property 'routeRecalculationReason'

    /**
     * The method onRouteRecalculationReasonGet() is called by ASF when a
     * client invokes the read method for the property
     * 'routeRecalculationReason'. The onRouteRecalculationReasonGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'routeRecalculationReason'</b>:
     *
     * Attribute provides the reason for the route re-calculation
     */
    virtual void onRouteRecalculationReasonGet(const ::boost::shared_ptr< RouteRecalculationReasonGet >& payload);

    /**
     * Sends back the update to a previous onRouteRecalculationReasonGet().
     *
     * <b>Documentation of 'routeRecalculationReason'</b>:
     *
     * Attribute provides the reason for the route re-calculation
     *
     * @param act Identifies a previous invocation of
     * onRouteRecalculationReasonGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRouteRecalculationReasonGetUpdate(RouteRecalculationReason routeRecalculationReason, act_t act = 0);

    /**
     * Set the value of the property 'routeRecalculationReason' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'routeRecalculationReason'</b>:
     *
     * Attribute provides the reason for the route re-calculation
     */
    void setRouteRecalculationReason(RouteRecalculationReason routeRecalculationReason);

    /**
     * Returns the current value of the property 'routeRecalculationReason'.
     *
     * <b>Documentation of 'routeRecalculationReason'</b>:
     *
     * Attribute provides the reason for the route re-calculation
     */
    RouteRecalculationReason getRouteRecalculationReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRouteRecalculationReasonUpdate().
     *
     * <b>Documentation of 'routeRecalculationReason'</b>:
     *
     * Attribute provides the reason for the route re-calculation
     */
    void sendRouteRecalculationReasonUpdate();

    // property 'RiskAreaDisplayInfoActive'

    /**
     * The method onRiskAreaDisplayInfoActiveGet() is called by ASF when a
     * client invokes the read method for the property
     * 'RiskAreaDisplayInfoActive'. The onRiskAreaDisplayInfoActiveGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'RiskAreaDisplayInfoActive'</b>:
     *
     * Attribute provides Risk area icon info status information
     */
    virtual void onRiskAreaDisplayInfoActiveGet(const ::boost::shared_ptr< RiskAreaDisplayInfoActiveGet >& payload);

    /**
     * Sends back the update to a previous onRiskAreaDisplayInfoActiveGet().
     *
     * <b>Documentation of 'RiskAreaDisplayInfoActive'</b>:
     *
     * Attribute provides Risk area icon info status information
     *
     * @param act Identifies a previous invocation of
     * onRiskAreaDisplayInfoActiveGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRiskAreaDisplayInfoActiveGetUpdate(bool riskAreaDisplayInfoActive, act_t act = 0);

    /**
     * Set the value of the property 'RiskAreaDisplayInfoActive' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'RiskAreaDisplayInfoActive'</b>:
     *
     * Attribute provides Risk area icon info status information
     */
    void setRiskAreaDisplayInfoActive(bool riskAreaDisplayInfoActive);

    /**
     * Returns the current value of the property 'RiskAreaDisplayInfoActive'.
     *
     * <b>Documentation of 'RiskAreaDisplayInfoActive'</b>:
     *
     * Attribute provides Risk area icon info status information
     */
    bool getRiskAreaDisplayInfoActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRiskAreaDisplayInfoActiveUpdate().
     *
     * <b>Documentation of 'RiskAreaDisplayInfoActive'</b>:
     *
     * Attribute provides Risk area icon info status information
     */
    void sendRiskAreaDisplayInfoActiveUpdate();

    // property 'RiskAreaSoundAlertInfoActive'

    /**
     * The method onRiskAreaSoundAlertInfoActiveGet() is called by ASF when a
     * client invokes the read method for the property
     * 'RiskAreaSoundAlertInfoActive'. The onRiskAreaSoundAlertInfoActiveGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'RiskAreaSoundAlertInfoActive'</b>:
     *
     * Attribute provides Risk Area Acoustic info status information
     */
    virtual void onRiskAreaSoundAlertInfoActiveGet(const ::boost::shared_ptr< RiskAreaSoundAlertInfoActiveGet >& payload);

    /**
     * Sends back the update to a previous
     * onRiskAreaSoundAlertInfoActiveGet().
     *
     * <b>Documentation of 'RiskAreaSoundAlertInfoActive'</b>:
     *
     * Attribute provides Risk Area Acoustic info status information
     *
     * @param act Identifies a previous invocation of
     * onRiskAreaSoundAlertInfoActiveGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendRiskAreaSoundAlertInfoActiveGetUpdate(bool riskAreaSoundAlertInfoActive, act_t act = 0);

    /**
     * Set the value of the property 'RiskAreaSoundAlertInfoActive' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'RiskAreaSoundAlertInfoActive'</b>:
     *
     * Attribute provides Risk Area Acoustic info status information
     */
    void setRiskAreaSoundAlertInfoActive(bool riskAreaSoundAlertInfoActive);

    /**
     * Returns the current value of the property 'RiskAreaSoundAlertInfoActive'.
     *
     * <b>Documentation of 'RiskAreaSoundAlertInfoActive'</b>:
     *
     * Attribute provides Risk Area Acoustic info status information
     */
    bool getRiskAreaSoundAlertInfoActive() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRiskAreaSoundAlertInfoActiveUpdate().
     *
     * <b>Documentation of 'RiskAreaSoundAlertInfoActive'</b>:
     *
     * Attribute provides Risk Area Acoustic info status information
     */
    void sendRiskAreaSoundAlertInfoActiveUpdate();

    // property 'jamAheadList'

    /**
     * The method onJamAheadListGet() is called by ASF when a client invokes
     * the read method for the property 'jamAheadList'. The
     * onJamAheadListGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     */
    virtual void onJamAheadListGet(const ::boost::shared_ptr< JamAheadListGet >& payload);

    /**
     * Sends back the update to a previous onJamAheadListGet().
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     *
     * @param act Identifies a previous invocation of onJamAheadListGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendJamAheadListGetUpdate(const JamAheadList& jamAheadList, act_t act = 0);

    /**
     * Set the value of the property 'jamAheadList' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     */
    void setJamAheadList(const JamAheadList& jamAheadList);

    /**
     * Returns the current value of the property 'jamAheadList'.
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     */
    const JamAheadList& getJamAheadList() const;

    /**
     * Returns the current value of the property 'jamAheadList' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendJamAheadListUpdate() method.
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     */
    JamAheadList& getJamAheadListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendJamAheadListUpdate().
     *
     * <b>Documentation of 'jamAheadList'</b>:
     *
     * Attribute to provide JamAheadList Updates
     */
    void sendJamAheadListUpdate();

    // property 'waypointOperationStatusList'

    /**
     * The method onWaypointOperationStatusListGet() is called by ASF when a
     * client invokes the read method for the property
     * 'waypointOperationStatusList'. The onWaypointOperationStatusListGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     */
    virtual void onWaypointOperationStatusListGet(const ::boost::shared_ptr< WaypointOperationStatusListGet >& payload);

    /**
     * Sends back the update to a previous onWaypointOperationStatusListGet().
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     *
     * @param act Identifies a previous invocation of
     * onWaypointOperationStatusListGet(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendWaypointOperationStatusListGetUpdate(const ::std::vector< WaypointOperationStatus >& waypointOperationStatusList, act_t act = 0);

    /**
     * Set the value of the property 'waypointOperationStatusList' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     */
    void setWaypointOperationStatusList(const ::std::vector< WaypointOperationStatus >& waypointOperationStatusList);

    /**
     * Returns the current value of the property 'waypointOperationStatusList'.
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     */
    const ::std::vector< WaypointOperationStatus >& getWaypointOperationStatusList() const;

    /**
     * Returns the current value of the property 'waypointOperationStatusList'
     * as a mutable reference. If you change the content of the returned
     * object you have to send updates to registered clients by yourself with
     * the help of the sendWaypointOperationStatusListUpdate() method.
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     */
    ::std::vector< WaypointOperationStatus >& getWaypointOperationStatusListMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendWaypointOperationStatusListUpdate().
     *
     * <b>Documentation of 'waypointOperationStatusList'</b>:
     *
     * Attribute provides the waypoint operation status
     */
    void sendWaypointOperationStatusListUpdate();

    // property 'destinationReachedStatus'

    /**
     * The method onDestinationReachedStatusGet() is called by ASF when a
     * client invokes the read method for the property
     * 'destinationReachedStatus'. The onDestinationReachedStatusGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'destinationReachedStatus'</b>:
     *
     * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
     */
    virtual void onDestinationReachedStatusGet(const ::boost::shared_ptr< DestinationReachedStatusGet >& payload);

    /**
     * Sends back the update to a previous onDestinationReachedStatusGet().
     *
     * <b>Documentation of 'destinationReachedStatus'</b>:
     *
     * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
     *
     * @param act Identifies a previous invocation of
     * onDestinationReachedStatusGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDestinationReachedStatusGetUpdate(DestinationReachedStatus destinationReachedStatus, act_t act = 0);

    /**
     * Set the value of the property 'destinationReachedStatus' and send
     * updates to registered clients. No updates will be sent if the property
     * value does not change.
     *
     * <b>Documentation of 'destinationReachedStatus'</b>:
     *
     * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
     */
    void setDestinationReachedStatus(DestinationReachedStatus destinationReachedStatus);

    /**
     * Returns the current value of the property 'destinationReachedStatus'.
     *
     * <b>Documentation of 'destinationReachedStatus'</b>:
     *
     * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
     */
    DestinationReachedStatus getDestinationReachedStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDestinationReachedStatusUpdate().
     *
     * <b>Documentation of 'destinationReachedStatus'</b>:
     *
     * Attribute provides the route reached status like WAYPOINT, FINAL DESTINATION
     */
    void sendDestinationReachedStatusUpdate();

    // property 'lightModeStatus'

    /**
     * The method onLightModeStatusGet() is called by ASF when a client
     * invokes the read method for the property 'lightModeStatus'. The
     * onLightModeStatusGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'lightModeStatus'</b>:
     *
     * Attribute to get current map Day/Night settings
     */
    virtual void onLightModeStatusGet(const ::boost::shared_ptr< LightModeStatusGet >& payload);

    /**
     * Sends back the update to a previous onLightModeStatusGet().
     *
     * <b>Documentation of 'lightModeStatus'</b>:
     *
     * Attribute to get current map Day/Night settings
     *
     * @param act Identifies a previous invocation of onLightModeStatusGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendLightModeStatusGetUpdate(LightModeStatus lightModeStatus, act_t act = 0);

    /**
     * Set the value of the property 'lightModeStatus' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'lightModeStatus'</b>:
     *
     * Attribute to get current map Day/Night settings
     */
    void setLightModeStatus(LightModeStatus lightModeStatus);

    /**
     * Returns the current value of the property 'lightModeStatus'.
     *
     * <b>Documentation of 'lightModeStatus'</b>:
     *
     * Attribute to get current map Day/Night settings
     */
    LightModeStatus getLightModeStatus() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendLightModeStatusUpdate().
     *
     * <b>Documentation of 'lightModeStatus'</b>:
     *
     * Attribute to get current map Day/Night settings
     */
    void sendLightModeStatusUpdate();

    // property 'mapCameraData'

    /**
     * The method onMapCameraDataGet() is called by ASF when a client invokes
     * the read method for the property 'mapCameraData'. The
     * onMapCameraDataGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     */
    virtual void onMapCameraDataGet(const ::boost::shared_ptr< MapCameraDataGet >& payload);

    /**
     * Sends back the update to a previous onMapCameraDataGet().
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     *
     * @param act Identifies a previous invocation of onMapCameraDataGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendMapCameraDataGetUpdate(const MapCameraData& mapCameraData, act_t act = 0);

    /**
     * Set the value of the property 'mapCameraData' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     */
    void setMapCameraData(const MapCameraData& mapCameraData);

    /**
     * Returns the current value of the property 'mapCameraData'.
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     */
    const MapCameraData& getMapCameraData() const;

    /**
     * Returns the current value of the property 'mapCameraData' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendMapCameraDataUpdate() method.
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     */
    MapCameraData& getMapCameraDataMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendMapCameraDataUpdate().
     *
     * <b>Documentation of 'mapCameraData'</b>:
     *
     * Attribute provides the map scale and compass data
     */
    void sendMapCameraDataUpdate();

    // method 'selectPoiCategoryShortcut'

    /**
     * The method onSelectPoiCategoryShortcut() is called by ASF when a client
     * invokes the method 'selectPoiCategoryShortcut'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSelectPoiCategoryShortcut() or
     * sendSelectPoiCategoryShortcutError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'selectPoiCategoryShortcut'</b>:
     *
     * Request to show the nearby POI category
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSelectPoiCategoryShortcutRequest (const ::boost::shared_ptr< SelectPoiCategoryShortcutRequest >& request) = 0;

    /**
     * The method sendSelectPoiCategoryShortcutResponse() sends a response of
     * a previous method invocation of 'selectPoiCategoryShortcut' back to the
     * client.
     *
     * <b>Documentation of 'selectPoiCategoryShortcut'</b>:
     *
     * Request to show the nearby POI category
     *
     * @param act The parameter act identifies a previous invocation of
     * onSelectPoiCategoryShortcut(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectPoiCategoryShortcutResponse (act_t act = 0);

    /**
     * The method sendSelectPoiCategoryShortcutError() sends an error response
     * of a previous method invocation of 'selectPoiCategoryShortcut' back to
     * the client.
     *
     * <b>Documentation of 'selectPoiCategoryShortcut'</b>:
     *
     * Request to show the nearby POI category
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSelectPoiCategoryShortcut(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectPoiCategoryShortcutError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getPoiCategoryShortcuts'

    /**
     * The method onGetPoiCategoryShortcuts() is called by ASF when a client
     * invokes the method 'getPoiCategoryShortcuts'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetPoiCategoryShortcuts() or
     * sendGetPoiCategoryShortcutsError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'getPoiCategoryShortcuts'</b>:
     *
     * Returns the customized preferred category shortcuts
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPoiCategoryShortcutsRequest (const ::boost::shared_ptr< GetPoiCategoryShortcutsRequest >& request) = 0;

    /**
     * The method sendGetPoiCategoryShortcutsResponse() sends a response of a
     * previous method invocation of 'getPoiCategoryShortcuts' back to the
     * client.
     *
     * <b>Documentation of 'getPoiCategoryShortcuts'</b>:
     *
     * Returns the customized preferred category shortcuts
     *
     * @param poiCategoryShortcuts If the meaning of "poiCategoryShortcuts" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetPoiCategoryShortcuts(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetPoiCategoryShortcutsResponse (const ::std::vector< PoiCategoryShortcut >& poiCategoryShortcuts, act_t act = 0);

    /**
     * The method sendGetPoiCategoryShortcutsError() sends an error response
     * of a previous method invocation of 'getPoiCategoryShortcuts' back to
     * the client.
     *
     * <b>Documentation of 'getPoiCategoryShortcuts'</b>:
     *
     * Returns the customized preferred category shortcuts
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetPoiCategoryShortcuts(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetPoiCategoryShortcutsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithCoordinates'

    /**
     * The method onSetLocationWithCoordinates() is called by ASF when a
     * client invokes the method 'setLocationWithCoordinates'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendSetLocationWithCoordinates() or
     * sendSetLocationWithCoordinatesError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'setLocationWithCoordinates'</b>:
     *
     * Request to set the latitude and longitude value
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithCoordinatesRequest (const ::boost::shared_ptr< SetLocationWithCoordinatesRequest >& request) = 0;

    /**
     * The method sendSetLocationWithCoordinatesResponse() sends a response of
     * a previous method invocation of 'setLocationWithCoordinates' back to
     * the client.
     *
     * <b>Documentation of 'setLocationWithCoordinates'</b>:
     *
     * Request to set the latitude and longitude value
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithCoordinates(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithCoordinatesResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithCoordinatesError() sends an error
     * response of a previous method invocation of
     * 'setLocationWithCoordinates' back to the client.
     *
     * <b>Documentation of 'setLocationWithCoordinates'</b>:
     *
     * Request to set the latitude and longitude value
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithCoordinates(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithDetails'

    /**
     * The method onSetLocationWithDetails() is called by ASF when a client
     * invokes the method 'setLocationWithDetails'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetLocationWithDetails() or
     * sendSetLocationWithDetailsError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for further processing
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithDetailsRequest (const ::boost::shared_ptr< SetLocationWithDetailsRequest >& request) = 0;

    /**
     * The method sendSetLocationWithDetailsResponse() sends a response of a
     * previous method invocation of 'setLocationWithDetails' back to the
     * client.
     *
     * <b>Documentation of 'setLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for further processing
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithDetails(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithDetailsResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithDetailsError() sends an error response of
     * a previous method invocation of 'setLocationWithDetails' back to the
     * client.
     *
     * <b>Documentation of 'setLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for further processing
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithDetails(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showPOILocationFromTCU'

    /**
     * The method onShowPOILocationFromTCU() is called by ASF when a client
     * invokes the method 'showPOILocationFromTCU'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendShowPOILocationFromTCU() or
     * sendShowPOILocationFromTCUError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'showPOILocationFromTCU'</b>:
     *
     * Request will provide the "Show POI location" from TCU
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowPOILocationFromTCURequest (const ::boost::shared_ptr< ShowPOILocationFromTCURequest >& request) = 0;

    /**
     * The method sendShowPOILocationFromTCUResponse() sends a response of a
     * previous method invocation of 'showPOILocationFromTCU' back to the
     * client.
     *
     * <b>Documentation of 'showPOILocationFromTCU'</b>:
     *
     * Request will provide the "Show POI location" from TCU
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowPOILocationFromTCU(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowPOILocationFromTCUResponse (act_t act = 0);

    /**
     * The method sendShowPOILocationFromTCUError() sends an error response of
     * a previous method invocation of 'showPOILocationFromTCU' back to the
     * client.
     *
     * <b>Documentation of 'showPOILocationFromTCU'</b>:
     *
     * Request will provide the "Show POI location" from TCU
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowPOILocationFromTCU(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowPOILocationFromTCUError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'storePOILocationToAddressBook'

    /**
     * The method onStorePOILocationToAddressBook() is called by ASF when a
     * client invokes the method 'storePOILocationToAddressBook'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendStorePOILocationToAddressBook() or
     * sendStorePOILocationToAddressBookError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'storePOILocationToAddressBook'</b>:
     *
     * Request to store POI location to navigation address book
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStorePOILocationToAddressBookRequest (const ::boost::shared_ptr< StorePOILocationToAddressBookRequest >& request) = 0;

    /**
     * The method sendStorePOILocationToAddressBookResponse() sends a response
     * of a previous method invocation of 'storePOILocationToAddressBook' back
     * to the client.
     *
     * <b>Documentation of 'storePOILocationToAddressBook'</b>:
     *
     * Request to store POI location to navigation address book
     *
     * @param act The parameter act identifies a previous invocation of
     * onStorePOILocationToAddressBook(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendStorePOILocationToAddressBookResponse (act_t act = 0);

    /**
     * The method sendStorePOILocationToAddressBookError() sends an error
     * response of a previous method invocation of
     * 'storePOILocationToAddressBook' back to the client.
     *
     * <b>Documentation of 'storePOILocationToAddressBook'</b>:
     *
     * Request to store POI location to navigation address book
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStorePOILocationToAddressBook(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendStorePOILocationToAddressBookError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'storeLocationToAddressBook'

    /**
     * The method onStoreLocationToAddressBook() is called by ASF when a
     * client invokes the method 'storeLocationToAddressBook'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendStoreLocationToAddressBook() or
     * sendStoreLocationToAddressBookError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'storeLocationToAddressBook'</b>:
     *
     * Request to store location to navigation address book
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStoreLocationToAddressBookRequest (const ::boost::shared_ptr< StoreLocationToAddressBookRequest >& request) = 0;

    /**
     * The method sendStoreLocationToAddressBookResponse() sends a response of
     * a previous method invocation of 'storeLocationToAddressBook' back to
     * the client.
     *
     * <b>Documentation of 'storeLocationToAddressBook'</b>:
     *
     * Request to store location to navigation address book
     *
     * @param act The parameter act identifies a previous invocation of
     * onStoreLocationToAddressBook(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStoreLocationToAddressBookResponse (act_t act = 0);

    /**
     * The method sendStoreLocationToAddressBookError() sends an error
     * response of a previous method invocation of
     * 'storeLocationToAddressBook' back to the client.
     *
     * <b>Documentation of 'storeLocationToAddressBook'</b>:
     *
     * Request to store location to navigation address book
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStoreLocationToAddressBook(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStoreLocationToAddressBookError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showDestinationOverviewFromTCU'

    /**
     * The method onShowDestinationOverviewFromTCU() is called by ASF when a
     * client invokes the method 'showDestinationOverviewFromTCU'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendShowDestinationOverviewFromTCU() or
     * sendShowDestinationOverviewFromTCUError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showDestinationOverviewFromTCU'</b>:
     *
     * Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowDestinationOverviewFromTCURequest (const ::boost::shared_ptr< ShowDestinationOverviewFromTCURequest >& request) = 0;

    /**
     * The method sendShowDestinationOverviewFromTCUResponse() sends a
     * response of a previous method invocation of
     * 'showDestinationOverviewFromTCU' back to the client.
     *
     * <b>Documentation of 'showDestinationOverviewFromTCU'</b>:
     *
     * Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowDestinationOverviewFromTCU(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowDestinationOverviewFromTCUResponse (act_t act = 0);

    /**
     * The method sendShowDestinationOverviewFromTCUError() sends an error
     * response of a previous method invocation of
     * 'showDestinationOverviewFromTCU' back to the client.
     *
     * <b>Documentation of 'showDestinationOverviewFromTCU'</b>:
     *
     * Show the given position and destination on the split screen map. Zoom level is set such that currentPosition and destination location are visible.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowDestinationOverviewFromTCU(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowDestinationOverviewFromTCUError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showCalculateTour'

    /**
     * The method onShowCalculateTour() is called by ASF when a client invokes
     * the method 'showCalculateTour'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendShowCalculateTour() or sendShowCalculateTourError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'showCalculateTour'</b>:
     *
     * Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowCalculateTourRequest (const ::boost::shared_ptr< ShowCalculateTourRequest >& request) = 0;

    /**
     * The method sendShowCalculateTourResponse() sends a response of a
     * previous method invocation of 'showCalculateTour' back to the client.
     *
     * <b>Documentation of 'showCalculateTour'</b>:
     *
     * Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowCalculateTour(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowCalculateTourResponse (act_t act = 0);

    /**
     * The method sendShowCalculateTourError() sends an error response of a
     * previous method invocation of 'showCalculateTour' back to the client.
     *
     * <b>Documentation of 'showCalculateTour'</b>:
     *
     * Request will show route calculation screen with a route to the given list of locations each of which can have their own route criterion
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onShowCalculateTour().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendShowCalculateTourError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showOnMap'

    /**
     * The method onShowOnMap() is called by ASF when a client invokes the
     * method 'showOnMap'. A subclass has to implement this method and send
     * back a response to the client either with the sendShowOnMap() or
     * sendShowOnMapError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'showOnMap'</b>:
     *
     * Request shows the given location on map
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowOnMapRequest (const ::boost::shared_ptr< ShowOnMapRequest >& request) = 0;

    /**
     * The method sendShowOnMapResponse() sends a response of a previous
     * method invocation of 'showOnMap' back to the client.
     *
     * <b>Documentation of 'showOnMap'</b>:
     *
     * Request shows the given location on map
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowOnMap(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendShowOnMapResponse (act_t act = 0);

    /**
     * The method sendShowOnMapError() sends an error response of a previous
     * method invocation of 'showOnMap' back to the client.
     *
     * <b>Documentation of 'showOnMap'</b>:
     *
     * Request shows the given location on map
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onShowOnMap(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendShowOnMapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showCarsorLocationOnMap'

    /**
     * The method onShowCarsorLocationOnMap() is called by ASF when a client
     * invokes the method 'showCarsorLocationOnMap'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendShowCarsorLocationOnMap() or
     * sendShowCarsorLocationOnMapError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'showCarsorLocationOnMap'</b>:
     *
     * Request shows the carsor Location on map
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowCarsorLocationOnMapRequest (const ::boost::shared_ptr< ShowCarsorLocationOnMapRequest >& request) = 0;

    /**
     * The method sendShowCarsorLocationOnMapResponse() sends a response of a
     * previous method invocation of 'showCarsorLocationOnMap' back to the
     * client.
     *
     * <b>Documentation of 'showCarsorLocationOnMap'</b>:
     *
     * Request shows the carsor Location on map
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowCarsorLocationOnMap(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowCarsorLocationOnMapResponse (act_t act = 0);

    /**
     * The method sendShowCarsorLocationOnMapError() sends an error response
     * of a previous method invocation of 'showCarsorLocationOnMap' back to
     * the client.
     *
     * <b>Documentation of 'showCarsorLocationOnMap'</b>:
     *
     * Request shows the carsor Location on map
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowCarsorLocationOnMap(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowCarsorLocationOnMapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showCityInputAndGetCityCoordinates'

    /**
     * The method onShowCityInputAndGetCityCoordinates() is called by ASF when
     * a client invokes the method 'showCityInputAndGetCityCoordinates'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendShowCityInputAndGetCityCoordinates() or
     * sendShowCityInputAndGetCityCoordinatesError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'showCityInputAndGetCityCoordinates'</b>:
     *
     * Request will respond with City center coordinates
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowCityInputAndGetCityCoordinatesRequest (const ::boost::shared_ptr< ShowCityInputAndGetCityCoordinatesRequest >& request) = 0;

    /**
     * The method sendShowCityInputAndGetCityCoordinatesResponse() sends a
     * response of a previous method invocation of
     * 'showCityInputAndGetCityCoordinates' back to the client.
     *
     * <b>Documentation of 'showCityInputAndGetCityCoordinates'</b>:
     *
     * Request will respond with City center coordinates
     *
     * @param cityCenterCoordinate If the meaning of "cityCenterCoordinate" isn't clear, then there should be a description here.
     *
     * @param isValidAddress If the meaning of "isValidAddress" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowCityInputAndGetCityCoordinates(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowCityInputAndGetCityCoordinatesResponse (const PositionWGS84& cityCenterCoordinate, bool isValidAddress, act_t act = 0);

    /**
     * The method sendShowCityInputAndGetCityCoordinatesError() sends an error
     * response of a previous method invocation of
     * 'showCityInputAndGetCityCoordinates' back to the client.
     *
     * <b>Documentation of 'showCityInputAndGetCityCoordinates'</b>:
     *
     * Request will respond with City center coordinates
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowCityInputAndGetCityCoordinates(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowCityInputAndGetCityCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestLocationDetailsForCoordinates'

    /**
     * The method onRequestLocationDetailsForCoordinates() is called by ASF
     * when a client invokes the method
     * 'requestLocationDetailsForCoordinates'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestLocationDetailsForCoordinates() or
     * sendRequestLocationDetailsForCoordinatesError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'requestLocationDetailsForCoordinates'</b>:
     *
     * Request will respond with location details belonging to given lat/long coordinates
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestLocationDetailsForCoordinatesRequest (const ::boost::shared_ptr< RequestLocationDetailsForCoordinatesRequest >& request) = 0;

    /**
     * The method sendRequestLocationDetailsForCoordinatesResponse() sends a
     * response of a previous method invocation of
     * 'requestLocationDetailsForCoordinates' back to the client.
     *
     * <b>Documentation of 'requestLocationDetailsForCoordinates'</b>:
     *
     * Request will respond with location details belonging to given lat/long coordinates
     *
     * @param locationDetails If the meaning of "locationDetails" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestLocationDetailsForCoordinates(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestLocationDetailsForCoordinatesResponse (const LocationDetails& locationDetails, act_t act = 0);

    /**
     * The method sendRequestLocationDetailsForCoordinatesError() sends an
     * error response of a previous method invocation of
     * 'requestLocationDetailsForCoordinates' back to the client.
     *
     * <b>Documentation of 'requestLocationDetailsForCoordinates'</b>:
     *
     * Request will respond with location details belonging to given lat/long coordinates
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestLocationDetailsForCoordinates(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestLocationDetailsForCoordinatesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showAdjustCurrentLocationScreen'

    /**
     * The method onShowAdjustCurrentLocationScreen() is called by ASF when a
     * client invokes the method 'showAdjustCurrentLocationScreen'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendShowAdjustCurrentLocationScreen() or
     * sendShowAdjustCurrentLocationScreenError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showAdjustCurrentLocationScreen'</b>:
     *
     * Method shows the screen to adjust the current location
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowAdjustCurrentLocationScreenRequest (const ::boost::shared_ptr< ShowAdjustCurrentLocationScreenRequest >& request) = 0;

    /**
     * The method sendShowAdjustCurrentLocationScreenResponse() sends a
     * response of a previous method invocation of
     * 'showAdjustCurrentLocationScreen' back to the client.
     *
     * <b>Documentation of 'showAdjustCurrentLocationScreen'</b>:
     *
     * Method shows the screen to adjust the current location
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowAdjustCurrentLocationScreen(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowAdjustCurrentLocationScreenResponse (act_t act = 0);

    /**
     * The method sendShowAdjustCurrentLocationScreenError() sends an error
     * response of a previous method invocation of
     * 'showAdjustCurrentLocationScreen' back to the client.
     *
     * <b>Documentation of 'showAdjustCurrentLocationScreen'</b>:
     *
     * Method shows the screen to adjust the current location
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowAdjustCurrentLocationScreen(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowAdjustCurrentLocationScreenError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showWhereAmIScreen'

    /**
     * The method onShowWhereAmIScreen() is called by ASF when a client
     * invokes the method 'showWhereAmIScreen'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendShowWhereAmIScreen() or sendShowWhereAmIScreenError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'showWhereAmIScreen'</b>:
     *
     * method to show the current position
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowWhereAmIScreenRequest (const ::boost::shared_ptr< ShowWhereAmIScreenRequest >& request) = 0;

    /**
     * The method sendShowWhereAmIScreenResponse() sends a response of a
     * previous method invocation of 'showWhereAmIScreen' back to the client.
     *
     * <b>Documentation of 'showWhereAmIScreen'</b>:
     *
     * method to show the current position
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowWhereAmIScreen(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowWhereAmIScreenResponse (act_t act = 0);

    /**
     * The method sendShowWhereAmIScreenError() sends an error response of a
     * previous method invocation of 'showWhereAmIScreen' back to the client.
     *
     * <b>Documentation of 'showWhereAmIScreen'</b>:
     *
     * method to show the current position
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onShowWhereAmIScreen().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendShowWhereAmIScreenError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showTrafficInfoScreen'

    /**
     * The method onShowTrafficInfoScreen() is called by ASF when a client
     * invokes the method 'showTrafficInfoScreen'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendShowTrafficInfoScreen() or sendShowTrafficInfoScreenError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'showTrafficInfoScreen'</b>:
     *
     * method to handle traffic data validation to show error pop up or traffic info screen
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowTrafficInfoScreenRequest (const ::boost::shared_ptr< ShowTrafficInfoScreenRequest >& request) = 0;

    /**
     * The method sendShowTrafficInfoScreenResponse() sends a response of a
     * previous method invocation of 'showTrafficInfoScreen' back to the
     * client.
     *
     * <b>Documentation of 'showTrafficInfoScreen'</b>:
     *
     * method to handle traffic data validation to show error pop up or traffic info screen
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowTrafficInfoScreen(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowTrafficInfoScreenResponse (act_t act = 0);

    /**
     * The method sendShowTrafficInfoScreenError() sends an error response of
     * a previous method invocation of 'showTrafficInfoScreen' back to the
     * client.
     *
     * <b>Documentation of 'showTrafficInfoScreen'</b>:
     *
     * method to handle traffic data validation to show error pop up or traffic info screen
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowTrafficInfoScreen(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowTrafficInfoScreenError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showMapScreenWithMapViewMode'

    /**
     * The method onShowMapScreenWithMapViewMode() is called by ASF when a
     * client invokes the method 'showMapScreenWithMapViewMode'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendShowMapScreenWithMapViewMode() or
     * sendShowMapScreenWithMapViewModeError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showMapScreenWithMapViewMode'</b>:
     *
     * Request to show map screen with the given settings for MapViewMode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowMapScreenWithMapViewModeRequest (const ::boost::shared_ptr< ShowMapScreenWithMapViewModeRequest >& request) = 0;

    /**
     * The method sendShowMapScreenWithMapViewModeResponse() sends a response
     * of a previous method invocation of 'showMapScreenWithMapViewMode' back
     * to the client.
     *
     * <b>Documentation of 'showMapScreenWithMapViewMode'</b>:
     *
     * Request to show map screen with the given settings for MapViewMode
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowMapScreenWithMapViewMode(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowMapScreenWithMapViewModeResponse (act_t act = 0);

    /**
     * The method sendShowMapScreenWithMapViewModeError() sends an error
     * response of a previous method invocation of
     * 'showMapScreenWithMapViewMode' back to the client.
     *
     * <b>Documentation of 'showMapScreenWithMapViewMode'</b>:
     *
     * Request to show map screen with the given settings for MapViewMode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowMapScreenWithMapViewMode(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowMapScreenWithMapViewModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showMapScreenCarsorLockMode'

    /**
     * The method onShowMapScreenCarsorLockMode() is called by ASF when a
     * client invokes the method 'showMapScreenCarsorLockMode'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendShowMapScreenCarsorLockMode() or
     * sendShowMapScreenCarsorLockModeError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showMapScreenCarsorLockMode'</b>:
     *
     * Request to show map screen with carsor locked mode
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowMapScreenCarsorLockModeRequest (const ::boost::shared_ptr< ShowMapScreenCarsorLockModeRequest >& request) = 0;

    /**
     * The method sendShowMapScreenCarsorLockModeResponse() sends a response
     * of a previous method invocation of 'showMapScreenCarsorLockMode' back
     * to the client.
     *
     * <b>Documentation of 'showMapScreenCarsorLockMode'</b>:
     *
     * Request to show map screen with carsor locked mode
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowMapScreenCarsorLockMode(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowMapScreenCarsorLockModeResponse (act_t act = 0);

    /**
     * The method sendShowMapScreenCarsorLockModeError() sends an error
     * response of a previous method invocation of
     * 'showMapScreenCarsorLockMode' back to the client.
     *
     * <b>Documentation of 'showMapScreenCarsorLockMode'</b>:
     *
     * Request to show map screen with carsor locked mode
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowMapScreenCarsorLockMode(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowMapScreenCarsorLockModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showDeleteWaypointListScreen'

    /**
     * The method onShowDeleteWaypointListScreen() is called by ASF when a
     * client invokes the method 'showDeleteWaypointListScreen'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendShowDeleteWaypointListScreen() or
     * sendShowDeleteWaypointListScreenError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showDeleteWaypointListScreen'</b>:
     *
     * Method shows the screen to modify  waypoint list
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowDeleteWaypointListScreenRequest (const ::boost::shared_ptr< ShowDeleteWaypointListScreenRequest >& request) = 0;

    /**
     * The method sendShowDeleteWaypointListScreenResponse() sends a response
     * of a previous method invocation of 'showDeleteWaypointListScreen' back
     * to the client.
     *
     * <b>Documentation of 'showDeleteWaypointListScreen'</b>:
     *
     * Method shows the screen to modify  waypoint list
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowDeleteWaypointListScreen(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowDeleteWaypointListScreenResponse (act_t act = 0);

    /**
     * The method sendShowDeleteWaypointListScreenError() sends an error
     * response of a previous method invocation of
     * 'showDeleteWaypointListScreen' back to the client.
     *
     * <b>Documentation of 'showDeleteWaypointListScreen'</b>:
     *
     * Method shows the screen to modify  waypoint list
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowDeleteWaypointListScreen(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendShowDeleteWaypointListScreenError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setZoomInStep'

    /**
     * The method onSetZoomInStep() is called by ASF when a client invokes the
     * method 'setZoomInStep'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetZoomInStep()
     * or sendSetZoomInStepError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'setZoomInStep'</b>:
     *
     * Request to zoom in the given step count
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetZoomInStepRequest (const ::boost::shared_ptr< SetZoomInStepRequest >& request) = 0;

    /**
     * The method sendSetZoomInStepResponse() sends a response of a previous
     * method invocation of 'setZoomInStep' back to the client.
     *
     * <b>Documentation of 'setZoomInStep'</b>:
     *
     * Request to zoom in the given step count
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetZoomInStep(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetZoomInStepResponse (act_t act = 0);

    /**
     * The method sendSetZoomInStepError() sends an error response of a
     * previous method invocation of 'setZoomInStep' back to the client.
     *
     * <b>Documentation of 'setZoomInStep'</b>:
     *
     * Request to zoom in the given step count
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetZoomInStep(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetZoomInStepError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setZoomOutStep'

    /**
     * The method onSetZoomOutStep() is called by ASF when a client invokes
     * the method 'setZoomOutStep'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetZoomOutStep() or sendSetZoomOutStepError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setZoomOutStep'</b>:
     *
     * Request to zoom out the given step count
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetZoomOutStepRequest (const ::boost::shared_ptr< SetZoomOutStepRequest >& request) = 0;

    /**
     * The method sendSetZoomOutStepResponse() sends a response of a previous
     * method invocation of 'setZoomOutStep' back to the client.
     *
     * <b>Documentation of 'setZoomOutStep'</b>:
     *
     * Request to zoom out the given step count
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetZoomOutStep(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetZoomOutStepResponse (act_t act = 0);

    /**
     * The method sendSetZoomOutStepError() sends an error response of a
     * previous method invocation of 'setZoomOutStep' back to the client.
     *
     * <b>Documentation of 'setZoomOutStep'</b>:
     *
     * Request to zoom out the given step count
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetZoomOutStep(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetZoomOutStepError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setZoomLevel'

    /**
     * The method onSetZoomLevel() is called by ASF when a client invokes the
     * method 'setZoomLevel'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetZoomLevel() or
     * sendSetZoomLevelError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'setZoomLevel'</b>:
     *
     * Request zooms to the given zoom level
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetZoomLevelRequest (const ::boost::shared_ptr< SetZoomLevelRequest >& request) = 0;

    /**
     * The method sendSetZoomLevelResponse() sends a response of a previous
     * method invocation of 'setZoomLevel' back to the client.
     *
     * <b>Documentation of 'setZoomLevel'</b>:
     *
     * Request zooms to the given zoom level
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetZoomLevel(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetZoomLevelResponse (act_t act = 0);

    /**
     * The method sendSetZoomLevelError() sends an error response of a
     * previous method invocation of 'setZoomLevel' back to the client.
     *
     * <b>Documentation of 'setZoomLevel'</b>:
     *
     * Request zooms to the given zoom level
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetZoomLevel(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetZoomLevelError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getVersionString'

    /**
     * The method onGetVersionString() is called by ASF when a client invokes
     * the method 'getVersionString'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetVersionString() or sendGetVersionStringError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'getVersionString'</b>:
     *
     * Request will respond with the current NavMiddleware version string
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetVersionStringRequest (const ::boost::shared_ptr< GetVersionStringRequest >& request) = 0;

    /**
     * The method sendGetVersionStringResponse() sends a response of a
     * previous method invocation of 'getVersionString' back to the client.
     *
     * <b>Documentation of 'getVersionString'</b>:
     *
     * Request will respond with the current NavMiddleware version string
     *
     * @param versionString If the meaning of "versionString" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetVersionString(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetVersionStringResponse (const ::std::string& versionString, act_t act = 0);

    /**
     * The method sendGetVersionStringError() sends an error response of a
     * previous method invocation of 'getVersionString' back to the client.
     *
     * <b>Documentation of 'getVersionString'</b>:
     *
     * Request will respond with the current NavMiddleware version string
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetVersionString(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetVersionStringError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setSXMTravelLinkSubscriptionStatus'

    /**
     * The method onSetSXMTravelLinkSubscriptionStatus() is called by ASF when
     * a client invokes the method 'setSXMTravelLinkSubscriptionStatus'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendSetSXMTravelLinkSubscriptionStatus() or
     * sendSetSXMTravelLinkSubscriptionStatusError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setSXMTravelLinkSubscriptionStatus'</b>:
     *
     * Request will set the SXM travel link subscription status
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetSXMTravelLinkSubscriptionStatusRequest (const ::boost::shared_ptr< SetSXMTravelLinkSubscriptionStatusRequest >& request) = 0;

    /**
     * The method sendSetSXMTravelLinkSubscriptionStatusResponse() sends a
     * response of a previous method invocation of
     * 'setSXMTravelLinkSubscriptionStatus' back to the client.
     *
     * <b>Documentation of 'setSXMTravelLinkSubscriptionStatus'</b>:
     *
     * Request will set the SXM travel link subscription status
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetSXMTravelLinkSubscriptionStatus(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetSXMTravelLinkSubscriptionStatusResponse (act_t act = 0);

    /**
     * The method sendSetSXMTravelLinkSubscriptionStatusError() sends an error
     * response of a previous method invocation of
     * 'setSXMTravelLinkSubscriptionStatus' back to the client.
     *
     * <b>Documentation of 'setSXMTravelLinkSubscriptionStatus'</b>:
     *
     * Request will set the SXM travel link subscription status
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetSXMTravelLinkSubscriptionStatus(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetSXMTravelLinkSubscriptionStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startGuidance'

    /**
     * The method onStartGuidance() is called by ASF when a client invokes the
     * method 'startGuidance'. A subclass has to implement this method and
     * send back a response to the client either with the sendStartGuidance()
     * or sendStartGuidanceError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'startGuidance'</b>:
     *
     * method to start the guidance with the current LI / SDS destination
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartGuidanceRequest (const ::boost::shared_ptr< StartGuidanceRequest >& request) = 0;

    /**
     * The method sendStartGuidanceResponse() sends a response of a previous
     * method invocation of 'startGuidance' back to the client.
     *
     * <b>Documentation of 'startGuidance'</b>:
     *
     * method to start the guidance with the current LI / SDS destination
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartGuidance(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartGuidanceResponse (act_t act = 0);

    /**
     * The method sendStartGuidanceError() sends an error response of a
     * previous method invocation of 'startGuidance' back to the client.
     *
     * <b>Documentation of 'startGuidance'</b>:
     *
     * method to start the guidance with the current LI / SDS destination
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartGuidance(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startGuidanceToPosWGS84'

    /**
     * The method onStartGuidanceToPosWGS84() is called by ASF when a client
     * invokes the method 'startGuidanceToPosWGS84'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendStartGuidanceToPosWGS84() or
     * sendStartGuidanceToPosWGS84Error() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'startGuidanceToPosWGS84'</b>:
     *
     * Request will start a guidance to the given WGS84 position
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartGuidanceToPosWGS84Request (const ::boost::shared_ptr< StartGuidanceToPosWGS84Request >& request) = 0;

    /**
     * The method sendStartGuidanceToPosWGS84Response() sends a response of a
     * previous method invocation of 'startGuidanceToPosWGS84' back to the
     * client.
     *
     * <b>Documentation of 'startGuidanceToPosWGS84'</b>:
     *
     * Request will start a guidance to the given WGS84 position
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartGuidanceToPosWGS84(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToPosWGS84Response (act_t act = 0);

    /**
     * The method sendStartGuidanceToPosWGS84Error() sends an error response
     * of a previous method invocation of 'startGuidanceToPosWGS84' back to
     * the client.
     *
     * <b>Documentation of 'startGuidanceToPosWGS84'</b>:
     *
     * Request will start a guidance to the given WGS84 position
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartGuidanceToPosWGS84(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToPosWGS84Error (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startGuidanceToHomeLocation'

    /**
     * The method onStartGuidanceToHomeLocation() is called by ASF when a
     * client invokes the method 'startGuidanceToHomeLocation'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendStartGuidanceToHomeLocation() or
     * sendStartGuidanceToHomeLocationError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'startGuidanceToHomeLocation'</b>:
     *
     * method to start the guidance to home location
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartGuidanceToHomeLocationRequest (const ::boost::shared_ptr< StartGuidanceToHomeLocationRequest >& request) = 0;

    /**
     * The method sendStartGuidanceToHomeLocationResponse() sends a response
     * of a previous method invocation of 'startGuidanceToHomeLocation' back
     * to the client.
     *
     * <b>Documentation of 'startGuidanceToHomeLocation'</b>:
     *
     * method to start the guidance to home location
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartGuidanceToHomeLocation(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToHomeLocationResponse (act_t act = 0);

    /**
     * The method sendStartGuidanceToHomeLocationError() sends an error
     * response of a previous method invocation of
     * 'startGuidanceToHomeLocation' back to the client.
     *
     * <b>Documentation of 'startGuidanceToHomeLocation'</b>:
     *
     * method to start the guidance to home location
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartGuidanceToHomeLocation(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToHomeLocationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startGuidanceToWorkLocation'

    /**
     * The method onStartGuidanceToWorkLocation() is called by ASF when a
     * client invokes the method 'startGuidanceToWorkLocation'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendStartGuidanceToWorkLocation() or
     * sendStartGuidanceToWorkLocationError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'startGuidanceToWorkLocation'</b>:
     *
     * method to start the guidance to work location
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartGuidanceToWorkLocationRequest (const ::boost::shared_ptr< StartGuidanceToWorkLocationRequest >& request) = 0;

    /**
     * The method sendStartGuidanceToWorkLocationResponse() sends a response
     * of a previous method invocation of 'startGuidanceToWorkLocation' back
     * to the client.
     *
     * <b>Documentation of 'startGuidanceToWorkLocation'</b>:
     *
     * method to start the guidance to work location
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartGuidanceToWorkLocation(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToWorkLocationResponse (act_t act = 0);

    /**
     * The method sendStartGuidanceToWorkLocationError() sends an error
     * response of a previous method invocation of
     * 'startGuidanceToWorkLocation' back to the client.
     *
     * <b>Documentation of 'startGuidanceToWorkLocation'</b>:
     *
     * method to start the guidance to work location
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onStartGuidanceToWorkLocation(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendStartGuidanceToWorkLocationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithDestinationMemoryEntry'

    /**
     * The method onSetLocationWithDestinationMemoryEntry() is called by ASF
     * when a client invokes the method
     * 'setLocationWithDestinationMemoryEntry'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetLocationWithDestinationMemoryEntry() or
     * sendSetLocationWithDestinationMemoryEntryError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setLocationWithDestinationMemoryEntry'</b>:
     *
     * Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithDestinationMemoryEntryRequest (const ::boost::shared_ptr< SetLocationWithDestinationMemoryEntryRequest >& request) = 0;

    /**
     * The method sendSetLocationWithDestinationMemoryEntryResponse() sends a
     * response of a previous method invocation of
     * 'setLocationWithDestinationMemoryEntry' back to the client.
     *
     * <b>Documentation of 'setLocationWithDestinationMemoryEntry'</b>:
     *
     * Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithDestinationMemoryEntry(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithDestinationMemoryEntryResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithDestinationMemoryEntryError() sends an
     * error response of a previous method invocation of
     * 'setLocationWithDestinationMemoryEntry' back to the client.
     *
     * <b>Documentation of 'setLocationWithDestinationMemoryEntry'</b>:
     *
     * Request will set location with destination memory entry id, At least once its required to request last destination/address book list before calling this interface
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithDestinationMemoryEntry(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithDestinationMemoryEntryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'cancelRouteGuidance'

    /**
     * The method onCancelRouteGuidance() is called by ASF when a client
     * invokes the method 'cancelRouteGuidance'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendCancelRouteGuidance() or sendCancelRouteGuidanceError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'cancelRouteGuidance'</b>:
     *
     * Request will stop the guidance
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRouteGuidanceRequest (const ::boost::shared_ptr< CancelRouteGuidanceRequest >& request) = 0;

    /**
     * The method sendCancelRouteGuidanceResponse() sends a response of a
     * previous method invocation of 'cancelRouteGuidance' back to the client.
     *
     * <b>Documentation of 'cancelRouteGuidance'</b>:
     *
     * Request will stop the guidance
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelRouteGuidance(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCancelRouteGuidanceResponse (act_t act = 0);

    /**
     * The method sendCancelRouteGuidanceError() sends an error response of a
     * previous method invocation of 'cancelRouteGuidance' back to the client.
     *
     * <b>Documentation of 'cancelRouteGuidance'</b>:
     *
     * Request will stop the guidance
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelRouteGuidance().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelRouteGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'insertWaypoint'

    /**
     * The method onInsertWaypoint() is called by ASF when a client invokes
     * the method 'insertWaypoint'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendInsertWaypoint() or sendInsertWaypointError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'insertWaypoint'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onInsertWaypointRequest (const ::boost::shared_ptr< InsertWaypointRequest >& request) = 0;

    /**
     * The method sendInsertWaypointResponse() sends a response of a previous
     * method invocation of 'insertWaypoint' back to the client.
     *
     * <b>Documentation of 'insertWaypoint'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param act The parameter act identifies a previous invocation of
     * onInsertWaypoint(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendInsertWaypointResponse (act_t act = 0);

    /**
     * The method sendInsertWaypointError() sends an error response of a
     * previous method invocation of 'insertWaypoint' back to the client.
     *
     * <b>Documentation of 'insertWaypoint'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onInsertWaypoint(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendInsertWaypointError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'insertWaypointAtDefaultPosition'

    /**
     * The method onInsertWaypointAtDefaultPosition() is called by ASF when a
     * client invokes the method 'insertWaypointAtDefaultPosition'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendInsertWaypointAtDefaultPosition() or
     * sendInsertWaypointAtDefaultPositionError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'insertWaypointAtDefaultPosition'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Index: Index internally defined by navigation application.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onInsertWaypointAtDefaultPositionRequest (const ::boost::shared_ptr< InsertWaypointAtDefaultPositionRequest >& request) = 0;

    /**
     * The method sendInsertWaypointAtDefaultPositionResponse() sends a
     * response of a previous method invocation of
     * 'insertWaypointAtDefaultPosition' back to the client.
     *
     * <b>Documentation of 'insertWaypointAtDefaultPosition'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Index: Index internally defined by navigation application.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param act The parameter act identifies a previous invocation of
     * onInsertWaypointAtDefaultPosition(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendInsertWaypointAtDefaultPositionResponse (act_t act = 0);

    /**
     * The method sendInsertWaypointAtDefaultPositionError() sends an error
     * response of a previous method invocation of
     * 'insertWaypointAtDefaultPosition' back to the client.
     *
     * <b>Documentation of 'insertWaypointAtDefaultPosition'</b>:
     *
     * Inserts current location as new waypoint in current waypoint list.
     *        Index: Index internally defined by navigation application.
     *        Once waypoint inserted property update ROUTE_WAYPOINTINFOS_CHANGED provides waypoint list
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onInsertWaypointAtDefaultPosition(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendInsertWaypointAtDefaultPositionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'replaceWaypoint'

    /**
     * The method onReplaceWaypoint() is called by ASF when a client invokes
     * the method 'replaceWaypoint'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReplaceWaypoint() or sendReplaceWaypointError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'replaceWaypoint'</b>:
     *
     * Uses current location to replace waypoint
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReplaceWaypointRequest (const ::boost::shared_ptr< ReplaceWaypointRequest >& request) = 0;

    /**
     * The method sendReplaceWaypointResponse() sends a response of a previous
     * method invocation of 'replaceWaypoint' back to the client.
     *
     * <b>Documentation of 'replaceWaypoint'</b>:
     *
     * Uses current location to replace waypoint
     *
     * @param act The parameter act identifies a previous invocation of
     * onReplaceWaypoint(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReplaceWaypointResponse (act_t act = 0);

    /**
     * The method sendReplaceWaypointError() sends an error response of a
     * previous method invocation of 'replaceWaypoint' back to the client.
     *
     * <b>Documentation of 'replaceWaypoint'</b>:
     *
     * Uses current location to replace waypoint
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReplaceWaypoint(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReplaceWaypointError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'deleteWaypoints'

    /**
     * The method onDeleteWaypoints() is called by ASF when a client invokes
     * the method 'deleteWaypoints'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDeleteWaypoints() or sendDeleteWaypointsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'deleteWaypoints'</b>:
     *
     * Delete the waypoints (including firstIndex and lastIndex)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeleteWaypointsRequest (const ::boost::shared_ptr< DeleteWaypointsRequest >& request) = 0;

    /**
     * The method sendDeleteWaypointsResponse() sends a response of a previous
     * method invocation of 'deleteWaypoints' back to the client.
     *
     * <b>Documentation of 'deleteWaypoints'</b>:
     *
     * Delete the waypoints (including firstIndex and lastIndex)
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeleteWaypoints(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDeleteWaypointsResponse (act_t act = 0);

    /**
     * The method sendDeleteWaypointsError() sends an error response of a
     * previous method invocation of 'deleteWaypoints' back to the client.
     *
     * <b>Documentation of 'deleteWaypoints'</b>:
     *
     * Delete the waypoints (including firstIndex and lastIndex)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDeleteWaypoints(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeleteWaypointsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'applyWaypointListChange'

    /**
     * The method onApplyWaypointListChange() is called by ASF when a client
     * invokes the method 'applyWaypointListChange'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendApplyWaypointListChange() or
     * sendApplyWaypointListChangeError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'applyWaypointListChange'</b>:
     *
     * Uses modified waypoint list and trigger new route calculation
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onApplyWaypointListChangeRequest (const ::boost::shared_ptr< ApplyWaypointListChangeRequest >& request) = 0;

    /**
     * The method sendApplyWaypointListChangeResponse() sends a response of a
     * previous method invocation of 'applyWaypointListChange' back to the
     * client.
     *
     * <b>Documentation of 'applyWaypointListChange'</b>:
     *
     * Uses modified waypoint list and trigger new route calculation
     *
     * @param act The parameter act identifies a previous invocation of
     * onApplyWaypointListChange(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendApplyWaypointListChangeResponse (act_t act = 0);

    /**
     * The method sendApplyWaypointListChangeError() sends an error response
     * of a previous method invocation of 'applyWaypointListChange' back to
     * the client.
     *
     * <b>Documentation of 'applyWaypointListChange'</b>:
     *
     * Uses modified waypoint list and trigger new route calculation
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onApplyWaypointListChange(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendApplyWaypointListChangeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestWaypointList'

    /**
     * The method onRequestWaypointList() is called by ASF when a client
     * invokes the method 'requestWaypointList'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestWaypointList() or sendRequestWaypointListError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'requestWaypointList'</b>:
     *
     * Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestWaypointListRequest (const ::boost::shared_ptr< RequestWaypointListRequest >& request) = 0;

    /**
     * The method sendRequestWaypointListResponse() sends a response of a
     * previous method invocation of 'requestWaypointList' back to the client.
     *
     * <b>Documentation of 'requestWaypointList'</b>:
     *
     * Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestWaypointList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestWaypointListResponse (act_t act = 0);

    /**
     * The method sendRequestWaypointListError() sends an error response of a
     * previous method invocation of 'requestWaypointList' back to the client.
     *
     * <b>Documentation of 'requestWaypointList'</b>:
     *
     * Request for inserted way points list. Waypoint list provided on property update ROUTE_WAYPOINTINFOS_CHANGED
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestWaypointList().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestWaypointListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestSetFreeTextSearchType'

    /**
     * The method onRequestSetFreeTextSearchType() is called by ASF when a
     * client invokes the method 'requestSetFreeTextSearchType'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendRequestSetFreeTextSearchType() or
     * sendRequestSetFreeTextSearchTypeError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'requestSetFreeTextSearchType'</b>:
     *
     * Request for the free text search location type
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestSetFreeTextSearchTypeRequest (const ::boost::shared_ptr< RequestSetFreeTextSearchTypeRequest >& request) = 0;

    /**
     * The method sendRequestSetFreeTextSearchTypeResponse() sends a response
     * of a previous method invocation of 'requestSetFreeTextSearchType' back
     * to the client.
     *
     * <b>Documentation of 'requestSetFreeTextSearchType'</b>:
     *
     * Request for the free text search location type
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestSetFreeTextSearchType(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestSetFreeTextSearchTypeResponse (act_t act = 0);

    /**
     * The method sendRequestSetFreeTextSearchTypeError() sends an error
     * response of a previous method invocation of
     * 'requestSetFreeTextSearchType' back to the client.
     *
     * <b>Documentation of 'requestSetFreeTextSearchType'</b>:
     *
     * Request for the free text search location type
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestSetFreeTextSearchType(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestSetFreeTextSearchTypeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestFreeTextSearchResults'

    /**
     * The method onRequestFreeTextSearchResults() is called by ASF when a
     * client invokes the method 'requestFreeTextSearchResults'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendRequestFreeTextSearchResults() or
     * sendRequestFreeTextSearchResultsError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'requestFreeTextSearchResults'</b>:
     *
     * Requests the specified range of free text search results for the search string and scope
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestFreeTextSearchResultsRequest (const ::boost::shared_ptr< RequestFreeTextSearchResultsRequest >& request) = 0;

    /**
     * The method sendRequestFreeTextSearchResultsResponse() sends a response
     * of a previous method invocation of 'requestFreeTextSearchResults' back
     * to the client.
     *
     * <b>Documentation of 'requestFreeTextSearchResults'</b>:
     *
     * Requests the specified range of free text search results for the search string and scope
     *
     * @param searchResults If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestFreeTextSearchResults(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestFreeTextSearchResultsResponse (const ::std::vector< AddressListElement >& searchResults, act_t act = 0);

    /**
     * The method sendRequestFreeTextSearchResultsError() sends an error
     * response of a previous method invocation of
     * 'requestFreeTextSearchResults' back to the client.
     *
     * <b>Documentation of 'requestFreeTextSearchResults'</b>:
     *
     * Requests the specified range of free text search results for the search string and scope
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestFreeTextSearchResults(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestFreeTextSearchResultsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'undoFreeTextSearchElementSelection'

    /**
     * The method onUndoFreeTextSearchElementSelection() is called by ASF when
     * a client invokes the method 'undoFreeTextSearchElementSelection'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendUndoFreeTextSearchElementSelection() or
     * sendUndoFreeTextSearchElementSelectionError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'undoFreeTextSearchElementSelection'</b>:
     *
     * Request to clear the free text search elements
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUndoFreeTextSearchElementSelectionRequest (const ::boost::shared_ptr< UndoFreeTextSearchElementSelectionRequest >& request) = 0;

    /**
     * The method sendUndoFreeTextSearchElementSelectionResponse() sends a
     * response of a previous method invocation of
     * 'undoFreeTextSearchElementSelection' back to the client.
     *
     * <b>Documentation of 'undoFreeTextSearchElementSelection'</b>:
     *
     * Request to clear the free text search elements
     *
     * @param act The parameter act identifies a previous invocation of
     * onUndoFreeTextSearchElementSelection(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendUndoFreeTextSearchElementSelectionResponse (act_t act = 0);

    /**
     * The method sendUndoFreeTextSearchElementSelectionError() sends an error
     * response of a previous method invocation of
     * 'undoFreeTextSearchElementSelection' back to the client.
     *
     * <b>Documentation of 'undoFreeTextSearchElementSelection'</b>:
     *
     * Request to clear the free text search elements
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUndoFreeTextSearchElementSelection(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendUndoFreeTextSearchElementSelectionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithFreeTextSearchInput'

    /**
     * The method onSetLocationWithFreeTextSearchInput() is called by ASF when
     * a client invokes the method 'setLocationWithFreeTextSearchInput'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendSetLocationWithFreeTextSearchInput() or
     * sendSetLocationWithFreeTextSearchInputError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setLocationWithFreeTextSearchInput'</b>:
     *
     * Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithFreeTextSearchInputRequest (const ::boost::shared_ptr< SetLocationWithFreeTextSearchInputRequest >& request) = 0;

    /**
     * The method sendSetLocationWithFreeTextSearchInputResponse() sends a
     * response of a previous method invocation of
     * 'setLocationWithFreeTextSearchInput' back to the client.
     *
     * <b>Documentation of 'setLocationWithFreeTextSearchInput'</b>:
     *
     * Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithFreeTextSearchInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithFreeTextSearchInputResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithFreeTextSearchInputError() sends an error
     * response of a previous method invocation of
     * 'setLocationWithFreeTextSearchInput' back to the client.
     *
     * <b>Documentation of 'setLocationWithFreeTextSearchInput'</b>:
     *
     * Method to cleanup FTS search and set the given search result as current location, so that it can be started afterwards with startGuidance()
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithFreeTextSearchInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithFreeTextSearchInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showDestinationFreeTextSearchInput'

    /**
     * The method onShowDestinationFreeTextSearchInput() is called by ASF when
     * a client invokes the method 'showDestinationFreeTextSearchInput'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendShowDestinationFreeTextSearchInput() or
     * sendShowDestinationFreeTextSearchInputError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'showDestinationFreeTextSearchInput'</b>:
     *
     * Request will respond with a contextSwitch to Navigation Destination Free text search
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowDestinationFreeTextSearchInputRequest (const ::boost::shared_ptr< ShowDestinationFreeTextSearchInputRequest >& request) = 0;

    /**
     * The method sendShowDestinationFreeTextSearchInputResponse() sends a
     * response of a previous method invocation of
     * 'showDestinationFreeTextSearchInput' back to the client.
     *
     * <b>Documentation of 'showDestinationFreeTextSearchInput'</b>:
     *
     * Request will respond with a contextSwitch to Navigation Destination Free text search
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowDestinationFreeTextSearchInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowDestinationFreeTextSearchInputResponse (act_t act = 0);

    /**
     * The method sendShowDestinationFreeTextSearchInputError() sends an error
     * response of a previous method invocation of
     * 'showDestinationFreeTextSearchInput' back to the client.
     *
     * <b>Documentation of 'showDestinationFreeTextSearchInput'</b>:
     *
     * Request will respond with a contextSwitch to Navigation Destination Free text search
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowDestinationFreeTextSearchInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowDestinationFreeTextSearchInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestFixedPOICategorySearchResults'

    /**
     * The method onRequestFixedPOICategorySearchResults() is called by ASF
     * when a client invokes the method
     * 'requestFixedPOICategorySearchResults'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestFixedPOICategorySearchResults() or
     * sendRequestFixedPOICategorySearchResultsError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'requestFixedPOICategorySearchResults'</b>:
     *
     * Requests POI elements for the given fixed POI category and scope
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestFixedPOICategorySearchResultsRequest (const ::boost::shared_ptr< RequestFixedPOICategorySearchResultsRequest >& request) = 0;

    /**
     * The method sendRequestFixedPOICategorySearchResultsResponse() sends a
     * response of a previous method invocation of
     * 'requestFixedPOICategorySearchResults' back to the client.
     *
     * <b>Documentation of 'requestFixedPOICategorySearchResults'</b>:
     *
     * Requests POI elements for the given fixed POI category and scope
     *
     * @param searchResults If the meaning of "searchResults" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestFixedPOICategorySearchResults(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestFixedPOICategorySearchResultsResponse (const ::std::vector< AddressListElement >& searchResults, act_t act = 0);

    /**
     * The method sendRequestFixedPOICategorySearchResultsError() sends an
     * error response of a previous method invocation of
     * 'requestFixedPOICategorySearchResults' back to the client.
     *
     * <b>Documentation of 'requestFixedPOICategorySearchResults'</b>:
     *
     * Requests POI elements for the given fixed POI category and scope
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestFixedPOICategorySearchResults(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestFixedPOICategorySearchResultsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'undoSetLocationWithFixedPOICategoryInput'

    /**
     * The method onUndoSetLocationWithFixedPOICategoryInput() is called by
     * ASF when a client invokes the method
     * 'undoSetLocationWithFixedPOICategoryInput'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendUndoSetLocationWithFixedPOICategoryInput() or
     * sendUndoSetLocationWithFixedPOICategoryInputError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'undoSetLocationWithFixedPOICategoryInput'</b>:
     *
     * Request to clear the selected element from FixedPOISearch Results list
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUndoSetLocationWithFixedPOICategoryInputRequest (const ::boost::shared_ptr< UndoSetLocationWithFixedPOICategoryInputRequest >& request) = 0;

    /**
     * The method sendUndoSetLocationWithFixedPOICategoryInputResponse() sends
     * a response of a previous method invocation of
     * 'undoSetLocationWithFixedPOICategoryInput' back to the client.
     *
     * <b>Documentation of 'undoSetLocationWithFixedPOICategoryInput'</b>:
     *
     * Request to clear the selected element from FixedPOISearch Results list
     *
     * @param act The parameter act identifies a previous invocation of
     * onUndoSetLocationWithFixedPOICategoryInput(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendUndoSetLocationWithFixedPOICategoryInputResponse (act_t act = 0);

    /**
     * The method sendUndoSetLocationWithFixedPOICategoryInputError() sends an
     * error response of a previous method invocation of
     * 'undoSetLocationWithFixedPOICategoryInput' back to the client.
     *
     * <b>Documentation of 'undoSetLocationWithFixedPOICategoryInput'</b>:
     *
     * Request to clear the selected element from FixedPOISearch Results list
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUndoSetLocationWithFixedPOICategoryInput(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendUndoSetLocationWithFixedPOICategoryInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithFixedPOICategoryInput'

    /**
     * The method onSetLocationWithFixedPOICategoryInput() is called by ASF
     * when a client invokes the method
     * 'setLocationWithFixedPOICategoryInput'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetLocationWithFixedPOICategoryInput() or
     * sendSetLocationWithFixedPOICategoryInputError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setLocationWithFixedPOICategoryInput'</b>:
     *
     * Method to choose the selected POI for starting guidance and requesting details
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithFixedPOICategoryInputRequest (const ::boost::shared_ptr< SetLocationWithFixedPOICategoryInputRequest >& request) = 0;

    /**
     * The method sendSetLocationWithFixedPOICategoryInputResponse() sends a
     * response of a previous method invocation of
     * 'setLocationWithFixedPOICategoryInput' back to the client.
     *
     * <b>Documentation of 'setLocationWithFixedPOICategoryInput'</b>:
     *
     * Method to choose the selected POI for starting guidance and requesting details
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithFixedPOICategoryInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithFixedPOICategoryInputResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithFixedPOICategoryInputError() sends an
     * error response of a previous method invocation of
     * 'setLocationWithFixedPOICategoryInput' back to the client.
     *
     * <b>Documentation of 'setLocationWithFixedPOICategoryInput'</b>:
     *
     * Method to choose the selected POI for starting guidance and requesting details
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithFixedPOICategoryInput(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSetLocationWithFixedPOICategoryInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsCheckAddress'

    /**
     * The method onSdsCheckAddress() is called by ASF when a client invokes
     * the method 'sdsCheckAddress'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSdsCheckAddress() or sendSdsCheckAddressError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsCheckAddressRequest (const ::boost::shared_ptr< SdsCheckAddressRequest >& request) = 0;

    /**
     * The method sendSdsCheckAddressResponse() sends a response of a previous
     * method invocation of 'sdsCheckAddress' back to the client.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsCheckAddress(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSdsCheckAddressResponse (act_t act = 0);

    /**
     * The method sendSdsCheckAddressError() sends an error response of a
     * previous method invocation of 'sdsCheckAddress' back to the client.
     *
     * <b>Documentation of 'sdsCheckAddress'</b>:
     *
     * Request will validate the given address,
     *        as result it update the attribute sdsAddressWithOptions
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSdsCheckAddress(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSdsCheckAddressError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsGetRefinementList'

    /**
     * The method onSdsGetRefinementList() is called by ASF when a client
     * invokes the method 'sdsGetRefinementList'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSdsGetRefinementList() or sendSdsGetRefinementListError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsGetRefinementListRequest (const ::boost::shared_ptr< SdsGetRefinementListRequest >& request) = 0;

    /**
     * The method sendSdsGetRefinementListResponse() sends a response of a
     * previous method invocation of 'sdsGetRefinementList' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param refinements If the meaning of "refinements" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsGetRefinementList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetRefinementListResponse (const ::std::vector< RefinementListElement >& refinements, act_t act = 0);

    /**
     * The method sendSdsGetRefinementListError() sends an error response of a
     * previous method invocation of 'sdsGetRefinementList' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetRefinementList'</b>:
     *
     * Request will get refinement list for the validated address
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsGetRefinementList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetRefinementListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'selectSdsRefinement'

    /**
     * The method onSelectSdsRefinement() is called by ASF when a client
     * invokes the method 'selectSdsRefinement'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSelectSdsRefinement() or sendSelectSdsRefinementError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSelectSdsRefinementRequest (const ::boost::shared_ptr< SelectSdsRefinementRequest >& request) = 0;

    /**
     * The method sendSelectSdsRefinementResponse() sends a response of a
     * previous method invocation of 'selectSdsRefinement' back to the client.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param act The parameter act identifies a previous invocation of
     * onSelectSdsRefinement(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectSdsRefinementResponse (act_t act = 0);

    /**
     * The method sendSelectSdsRefinementError() sends an error response of a
     * previous method invocation of 'selectSdsRefinement' back to the client.
     *
     * <b>Documentation of 'selectSdsRefinement'</b>:
     *
     * Request will select the refinement with the id from refinement list and add internal to SDSAddress.
     *        As result it update the attribute sdsAddressWithOptions
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSelectSdsRefinement().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSelectSdsRefinementError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setLocationWithSdsInput'

    /**
     * The method onSetLocationWithSdsInput() is called by ASF when a client
     * invokes the method 'setLocationWithSdsInput'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSetLocationWithSdsInput() or
     * sendSetLocationWithSdsInputError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetLocationWithSdsInputRequest (const ::boost::shared_ptr< SetLocationWithSdsInputRequest >& request) = 0;

    /**
     * The method sendSetLocationWithSdsInputResponse() sends a response of a
     * previous method invocation of 'setLocationWithSdsInput' back to the
     * client.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetLocationWithSdsInput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithSdsInputResponse (act_t act = 0);

    /**
     * The method sendSetLocationWithSdsInputError() sends an error response
     * of a previous method invocation of 'setLocationWithSdsInput' back to
     * the client.
     *
     * <b>Documentation of 'setLocationWithSdsInput'</b>:
     *
     * Request will set the SDS Address as destination or waypoint
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetLocationWithSdsInput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetLocationWithSdsInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestDestinationMemoryEntries'

    /**
     * The method onRequestDestinationMemoryEntries() is called by ASF when a
     * client invokes the method 'requestDestinationMemoryEntries'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendRequestDestinationMemoryEntries() or
     * sendRequestDestinationMemoryEntriesError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'requestDestinationMemoryEntries'</b>:
     *
     * Request will return DestinationMemory entries for the given category
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestDestinationMemoryEntriesRequest (const ::boost::shared_ptr< RequestDestinationMemoryEntriesRequest >& request) = 0;

    /**
     * The method sendRequestDestinationMemoryEntriesResponse() sends a
     * response of a previous method invocation of
     * 'requestDestinationMemoryEntries' back to the client.
     *
     * <b>Documentation of 'requestDestinationMemoryEntries'</b>:
     *
     * Request will return DestinationMemory entries for the given category
     *
     * @param destinationMemoryEntries If the meaning of "destinationMemoryEntries" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestDestinationMemoryEntries(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendRequestDestinationMemoryEntriesResponse (const ::std::vector< DestinationMemoryDetailListElement >& destinationMemoryEntries, act_t act = 0);

    /**
     * The method sendRequestDestinationMemoryEntriesError() sends an error
     * response of a previous method invocation of
     * 'requestDestinationMemoryEntries' back to the client.
     *
     * <b>Documentation of 'requestDestinationMemoryEntries'</b>:
     *
     * Request will return DestinationMemory entries for the given category
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestDestinationMemoryEntries(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendRequestDestinationMemoryEntriesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setMapRepresentation'

    /**
     * The method onSetMapRepresentation() is called by ASF when a client
     * invokes the method 'setMapRepresentation'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSetMapRepresentation() or sendSetMapRepresentationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'setMapRepresentation'</b>:
     *
     * method to select map representation:  dimension/heading combination
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMapRepresentationRequest (const ::boost::shared_ptr< SetMapRepresentationRequest >& request) = 0;

    /**
     * The method sendSetMapRepresentationResponse() sends a response of a
     * previous method invocation of 'setMapRepresentation' back to the
     * client.
     *
     * <b>Documentation of 'setMapRepresentation'</b>:
     *
     * method to select map representation:  dimension/heading combination
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMapRepresentation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMapRepresentationResponse (act_t act = 0);

    /**
     * The method sendSetMapRepresentationError() sends an error response of a
     * previous method invocation of 'setMapRepresentation' back to the
     * client.
     *
     * <b>Documentation of 'setMapRepresentation'</b>:
     *
     * method to select map representation:  dimension/heading combination
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetMapRepresentation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMapRepresentationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestDetailsForSelectedLocation'

    /**
     * The method onRequestDetailsForSelectedLocation() is called by ASF when
     * a client invokes the method 'requestDetailsForSelectedLocation'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendRequestDetailsForSelectedLocation() or
     * sendRequestDetailsForSelectedLocationError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'requestDetailsForSelectedLocation'</b>:
     *
     * Request will respond with location details for the selected location set via setLocationWithXYZ interface
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestDetailsForSelectedLocationRequest (const ::boost::shared_ptr< RequestDetailsForSelectedLocationRequest >& request) = 0;

    /**
     * The method sendRequestDetailsForSelectedLocationResponse() sends a
     * response of a previous method invocation of
     * 'requestDetailsForSelectedLocation' back to the client.
     *
     * <b>Documentation of 'requestDetailsForSelectedLocation'</b>:
     *
     * Request will respond with location details for the selected location set via setLocationWithXYZ interface
     *
     * @param locationDetail If the meaning of "locationDetail" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestDetailsForSelectedLocation(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestDetailsForSelectedLocationResponse (const LocationDetails& locationDetail, act_t act = 0);

    /**
     * The method sendRequestDetailsForSelectedLocationError() sends an error
     * response of a previous method invocation of
     * 'requestDetailsForSelectedLocation' back to the client.
     *
     * <b>Documentation of 'requestDetailsForSelectedLocation'</b>:
     *
     * Request will respond with location details for the selected location set via setLocationWithXYZ interface
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestDetailsForSelectedLocation(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendRequestDetailsForSelectedLocationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'retriggerAcousticOutput'

    /**
     * The method onRetriggerAcousticOutput() is called by ASF when a client
     * invokes the method 'retriggerAcousticOutput'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRetriggerAcousticOutput() or
     * sendRetriggerAcousticOutputError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'retriggerAcousticOutput'</b>:
     *
     * method to retrigger the last voice output (guidance)
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRetriggerAcousticOutputRequest (const ::boost::shared_ptr< RetriggerAcousticOutputRequest >& request) = 0;

    /**
     * The method sendRetriggerAcousticOutputResponse() sends a response of a
     * previous method invocation of 'retriggerAcousticOutput' back to the
     * client.
     *
     * <b>Documentation of 'retriggerAcousticOutput'</b>:
     *
     * method to retrigger the last voice output (guidance)
     *
     * @param act The parameter act identifies a previous invocation of
     * onRetriggerAcousticOutput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRetriggerAcousticOutputResponse (act_t act = 0);

    /**
     * The method sendRetriggerAcousticOutputError() sends an error response
     * of a previous method invocation of 'retriggerAcousticOutput' back to
     * the client.
     *
     * <b>Documentation of 'retriggerAcousticOutput'</b>:
     *
     * method to retrigger the last voice output (guidance)
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRetriggerAcousticOutput(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRetriggerAcousticOutputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'speakSamplePhrase'

    /**
     * The method onSpeakSamplePhrase() is called by ASF when a client invokes
     * the method 'speakSamplePhrase'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSpeakSamplePhrase() or sendSpeakSamplePhraseError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'speakSamplePhrase'</b>:
     *
     * method to trigger the sample voice Phrase
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSpeakSamplePhraseRequest (const ::boost::shared_ptr< SpeakSamplePhraseRequest >& request) = 0;

    /**
     * The method sendSpeakSamplePhraseResponse() sends a response of a
     * previous method invocation of 'speakSamplePhrase' back to the client.
     *
     * <b>Documentation of 'speakSamplePhrase'</b>:
     *
     * method to trigger the sample voice Phrase
     *
     * @param act The parameter act identifies a previous invocation of
     * onSpeakSamplePhrase(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpeakSamplePhraseResponse (act_t act = 0);

    /**
     * The method sendSpeakSamplePhraseError() sends an error response of a
     * previous method invocation of 'speakSamplePhrase' back to the client.
     *
     * <b>Documentation of 'speakSamplePhrase'</b>:
     *
     * method to trigger the sample voice Phrase
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSpeakSamplePhrase().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSpeakSamplePhraseError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setRouteCriterion'

    /**
     * The method onSetRouteCriterion() is called by ASF when a client invokes
     * the method 'setRouteCriterion'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetRouteCriterion() or sendSetRouteCriterionError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'setRouteCriterion'</b>:
     *
     * set RouteCriterion settings and apply them to recalculate
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetRouteCriterionRequest (const ::boost::shared_ptr< SetRouteCriterionRequest >& request) = 0;

    /**
     * The method sendSetRouteCriterionResponse() sends a response of a
     * previous method invocation of 'setRouteCriterion' back to the client.
     *
     * <b>Documentation of 'setRouteCriterion'</b>:
     *
     * set RouteCriterion settings and apply them to recalculate
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetRouteCriterion(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetRouteCriterionResponse (act_t act = 0);

    /**
     * The method sendSetRouteCriterionError() sends an error response of a
     * previous method invocation of 'setRouteCriterion' back to the client.
     *
     * <b>Documentation of 'setRouteCriterion'</b>:
     *
     * set RouteCriterion settings and apply them to recalculate
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetRouteCriterion().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetRouteCriterionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setVoiceGuidance'

    /**
     * The method onSetVoiceGuidance() is called by ASF when a client invokes
     * the method 'setVoiceGuidance'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetVoiceGuidance() or sendSetVoiceGuidanceError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'setVoiceGuidance'</b>:
     *
     * method to set and get the guidance settings element for voice
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetVoiceGuidanceRequest (const ::boost::shared_ptr< SetVoiceGuidanceRequest >& request) = 0;

    /**
     * The method sendSetVoiceGuidanceResponse() sends a response of a
     * previous method invocation of 'setVoiceGuidance' back to the client.
     *
     * <b>Documentation of 'setVoiceGuidance'</b>:
     *
     * method to set and get the guidance settings element for voice
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetVoiceGuidance(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetVoiceGuidanceResponse (act_t act = 0);

    /**
     * The method sendSetVoiceGuidanceError() sends an error response of a
     * previous method invocation of 'setVoiceGuidance' back to the client.
     *
     * <b>Documentation of 'setVoiceGuidance'</b>:
     *
     * method to set and get the guidance settings element for voice
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetVoiceGuidance(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetVoiceGuidanceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CheckNavDataCompatibility'

    /**
     * The method onCheckNavDataCompatibility() is called by ASF when a client
     * invokes the method 'CheckNavDataCompatibility'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendCheckNavDataCompatibility() or
     * sendCheckNavDataCompatibilityError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'CheckNavDataCompatibility'</b>:
     *
     * NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCheckNavDataCompatibilityRequest (const ::boost::shared_ptr< CheckNavDataCompatibilityRequest >& request) = 0;

    /**
     * The method sendCheckNavDataCompatibilityResponse() sends a response of
     * a previous method invocation of 'CheckNavDataCompatibility' back to the
     * client.
     *
     * <b>Documentation of 'CheckNavDataCompatibility'</b>:
     *
     * NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium
     *
     * @param compatibility If the meaning of "compatibility" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCheckNavDataCompatibility(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCheckNavDataCompatibilityResponse (NavDataCompatibility compatibility, act_t act = 0);

    /**
     * The method sendCheckNavDataCompatibilityError() sends an error response
     * of a previous method invocation of 'CheckNavDataCompatibility' back to
     * the client.
     *
     * <b>Documentation of 'CheckNavDataCompatibility'</b>:
     *
     * NavDataUpdate gets version of Navigation application to be installed and additional compatibility information provided by update-medium
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onCheckNavDataCompatibility(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCheckNavDataCompatibilityError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsUpdateVoiceTag'

    /**
     * The method onSdsUpdateVoiceTag() is called by ASF when a client invokes
     * the method 'sdsUpdateVoiceTag'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSdsUpdateVoiceTag() or sendSdsUpdateVoiceTagError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsUpdateVoiceTagRequest (const ::boost::shared_ptr< SdsUpdateVoiceTagRequest >& request) = 0;

    /**
     * The method sendSdsUpdateVoiceTagResponse() sends a response of a
     * previous method invocation of 'sdsUpdateVoiceTag' back to the client.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsUpdateVoiceTag(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsUpdateVoiceTagResponse (act_t act = 0);

    /**
     * The method sendSdsUpdateVoiceTagError() sends an error response of a
     * previous method invocation of 'sdsUpdateVoiceTag' back to the client.
     *
     * <b>Documentation of 'sdsUpdateVoiceTag'</b>:
     *
     * Method used to store/delete the VoiceTagId in the destination memory database
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSdsUpdateVoiceTag().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSdsUpdateVoiceTagError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sdsGetHouseNumberPattern'

    /**
     * The method onSdsGetHouseNumberPattern() is called by ASF when a client
     * invokes the method 'sdsGetHouseNumberPattern'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSdsGetHouseNumberPattern() or
     * sendSdsGetHouseNumberPatternError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSdsGetHouseNumberPatternRequest (const ::boost::shared_ptr< SdsGetHouseNumberPatternRequest >& request) = 0;

    /**
     * The method sendSdsGetHouseNumberPatternResponse() sends a response of a
     * previous method invocation of 'sdsGetHouseNumberPattern' back to the
     * client.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param minHouseNumber If the meaning of "minHouseNumber" isn't clear, then there should be a description here.
     *
     * @param maxHouseNumber If the meaning of "maxHouseNumber" isn't clear, then there should be a description here.
     *
     * @param patterns If the meaning of "patterns" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSdsGetHouseNumberPattern(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetHouseNumberPatternResponse (const ::std::string& minHouseNumber, const ::std::string& maxHouseNumber, const ::std::vector< ::std::string >& patterns, act_t act = 0);

    /**
     * The method sendSdsGetHouseNumberPatternError() sends an error response
     * of a previous method invocation of 'sdsGetHouseNumberPattern' back to
     * the client.
     *
     * <b>Documentation of 'sdsGetHouseNumberPattern'</b>:
     *
     * Request will get house number patterns and the minimum and maximum values of the current SDSAddress
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSdsGetHouseNumberPattern(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSdsGetHouseNumberPatternError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setMapLightMode'

    /**
     * The method onSetMapLightMode() is called by ASF when a client invokes
     * the method 'setMapLightMode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetMapLightMode() or sendSetMapLightModeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'setMapLightMode'</b>:
     *
     * method to change the MAP color based on light mode request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMapLightModeRequest (const ::boost::shared_ptr< SetMapLightModeRequest >& request) = 0;

    /**
     * The method sendSetMapLightModeResponse() sends a response of a previous
     * method invocation of 'setMapLightMode' back to the client.
     *
     * <b>Documentation of 'setMapLightMode'</b>:
     *
     * method to change the MAP color based on light mode request
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMapLightMode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetMapLightModeResponse (act_t act = 0);

    /**
     * The method sendSetMapLightModeError() sends an error response of a
     * previous method invocation of 'setMapLightMode' back to the client.
     *
     * <b>Documentation of 'setMapLightMode'</b>:
     *
     * method to change the MAP color based on light mode request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetMapLightMode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetMapLightModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'startTripReplay'

    /**
     * The method onStartTripReplay() is called by ASF when a client invokes
     * the method 'startTripReplay'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStartTripReplay() or sendStartTripReplayError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'startTripReplay'</b>:
     *
     * Starts the trip-replay for the given trip-file
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStartTripReplayRequest (const ::boost::shared_ptr< StartTripReplayRequest >& request) = 0;

    /**
     * The method sendStartTripReplayResponse() sends a response of a previous
     * method invocation of 'startTripReplay' back to the client.
     *
     * <b>Documentation of 'startTripReplay'</b>:
     *
     * Starts the trip-replay for the given trip-file
     *
     * @param act The parameter act identifies a previous invocation of
     * onStartTripReplay(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStartTripReplayResponse (act_t act = 0);

    /**
     * The method sendStartTripReplayError() sends an error response of a
     * previous method invocation of 'startTripReplay' back to the client.
     *
     * <b>Documentation of 'startTripReplay'</b>:
     *
     * Starts the trip-replay for the given trip-file
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStartTripReplay(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStartTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'stopTripReplay'

    /**
     * The method onStopTripReplay() is called by ASF when a client invokes
     * the method 'stopTripReplay'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendStopTripReplay() or sendStopTripReplayError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'stopTripReplay'</b>:
     *
     * Stops the trip-replay
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onStopTripReplayRequest (const ::boost::shared_ptr< StopTripReplayRequest >& request) = 0;

    /**
     * The method sendStopTripReplayResponse() sends a response of a previous
     * method invocation of 'stopTripReplay' back to the client.
     *
     * <b>Documentation of 'stopTripReplay'</b>:
     *
     * Stops the trip-replay
     *
     * @param act The parameter act identifies a previous invocation of
     * onStopTripReplay(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendStopTripReplayResponse (act_t act = 0);

    /**
     * The method sendStopTripReplayError() sends an error response of a
     * previous method invocation of 'stopTripReplay' back to the client.
     *
     * <b>Documentation of 'stopTripReplay'</b>:
     *
     * Stops the trip-replay
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onStopTripReplay(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendStopTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'seekTripReplay'

    /**
     * The method onSeekTripReplay() is called by ASF when a client invokes
     * the method 'seekTripReplay'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSeekTripReplay() or sendSeekTripReplayError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'seekTripReplay'</b>:
     *
     * Seeks to the specified location, in the trip-replay
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSeekTripReplayRequest (const ::boost::shared_ptr< SeekTripReplayRequest >& request) = 0;

    /**
     * The method sendSeekTripReplayResponse() sends a response of a previous
     * method invocation of 'seekTripReplay' back to the client.
     *
     * <b>Documentation of 'seekTripReplay'</b>:
     *
     * Seeks to the specified location, in the trip-replay
     *
     * @param act The parameter act identifies a previous invocation of
     * onSeekTripReplay(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSeekTripReplayResponse (act_t act = 0);

    /**
     * The method sendSeekTripReplayError() sends an error response of a
     * previous method invocation of 'seekTripReplay' back to the client.
     *
     * <b>Documentation of 'seekTripReplay'</b>:
     *
     * Seeks to the specified location, in the trip-replay
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSeekTripReplay(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSeekTripReplayError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setTripReplayMode'

    /**
     * The method onSetTripReplayMode() is called by ASF when a client invokes
     * the method 'setTripReplayMode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetTripReplayMode() or sendSetTripReplayModeError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'setTripReplayMode'</b>:
     *
     * Sets the mode of the trip-replay
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetTripReplayModeRequest (const ::boost::shared_ptr< SetTripReplayModeRequest >& request) = 0;

    /**
     * The method sendSetTripReplayModeResponse() sends a response of a
     * previous method invocation of 'setTripReplayMode' back to the client.
     *
     * <b>Documentation of 'setTripReplayMode'</b>:
     *
     * Sets the mode of the trip-replay
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetTripReplayMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetTripReplayModeResponse (act_t act = 0);

    /**
     * The method sendSetTripReplayModeError() sends an error response of a
     * previous method invocation of 'setTripReplayMode' back to the client.
     *
     * <b>Documentation of 'setTripReplayMode'</b>:
     *
     * Sets the mode of the trip-replay
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetTripReplayMode().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetTripReplayModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showLocationSelectionAndGetAddressDetails'

    /**
     * The method onShowLocationSelectionAndGetAddressDetails() is called by
     * ASF when a client invokes the method
     * 'showLocationSelectionAndGetAddressDetails'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendShowLocationSelectionAndGetAddressDetails() or
     * sendShowLocationSelectionAndGetAddressDetailsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'showLocationSelectionAndGetAddressDetails'</b>:
     *
     * Request will respond with Address Details along with Destination Memory Id
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowLocationSelectionAndGetAddressDetailsRequest (const ::boost::shared_ptr< ShowLocationSelectionAndGetAddressDetailsRequest >& request) = 0;

    /**
     * The method sendShowLocationSelectionAndGetAddressDetailsResponse()
     * sends a response of a previous method invocation of
     * 'showLocationSelectionAndGetAddressDetails' back to the client.
     *
     * <b>Documentation of 'showLocationSelectionAndGetAddressDetails'</b>:
     *
     * Request will respond with Address Details along with Destination Memory Id
     *
     * @param destinationMemoryDetailListElement If the meaning of "destinationMemoryDetailListElement" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowLocationSelectionAndGetAddressDetails(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendShowLocationSelectionAndGetAddressDetailsResponse (const DestinationMemoryDetailListElement& destinationMemoryDetailListElement, act_t act = 0);

    /**
     * The method sendShowLocationSelectionAndGetAddressDetailsError() sends
     * an error response of a previous method invocation of
     * 'showLocationSelectionAndGetAddressDetails' back to the client.
     *
     * <b>Documentation of 'showLocationSelectionAndGetAddressDetails'</b>:
     *
     * Request will respond with Address Details along with Destination Memory Id
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowLocationSelectionAndGetAddressDetails(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendShowLocationSelectionAndGetAddressDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showRouteCalculationToDestination'

    /**
     * The method onShowRouteCalculationToDestination() is called by ASF when
     * a client invokes the method 'showRouteCalculationToDestination'. A
     * subclass has to implement this method and send back a response to the
     * client either with the sendShowRouteCalculationToDestination() or
     * sendShowRouteCalculationToDestinationError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showRouteCalculationToDestination'</b>:
     *
     * Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowRouteCalculationToDestinationRequest (const ::boost::shared_ptr< ShowRouteCalculationToDestinationRequest >& request) = 0;

    /**
     * The method sendShowRouteCalculationToDestinationResponse() sends a
     * response of a previous method invocation of
     * 'showRouteCalculationToDestination' back to the client.
     *
     * <b>Documentation of 'showRouteCalculationToDestination'</b>:
     *
     * Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowRouteCalculationToDestination(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowRouteCalculationToDestinationResponse (act_t act = 0);

    /**
     * The method sendShowRouteCalculationToDestinationError() sends an error
     * response of a previous method invocation of
     * 'showRouteCalculationToDestination' back to the client.
     *
     * <b>Documentation of 'showRouteCalculationToDestination'</b>:
     *
     * Method starts the route calculation to the destination set using setLocationWithDestinationMemoryEntry interface call from address gadget on home screen
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowRouteCalculationToDestination(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendShowRouteCalculationToDestinationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestJamAheadList'

    /**
     * The method onRequestJamAheadList() is called by ASF when a client
     * invokes the method 'requestJamAheadList'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestJamAheadList() or sendRequestJamAheadListError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'requestJamAheadList'</b>:
     *
     * Fetch the Possible options to block ahead along with continuous updates
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestJamAheadListRequest (const ::boost::shared_ptr< RequestJamAheadListRequest >& request) = 0;

    /**
     * The method sendRequestJamAheadListResponse() sends a response of a
     * previous method invocation of 'requestJamAheadList' back to the client.
     *
     * <b>Documentation of 'requestJamAheadList'</b>:
     *
     * Fetch the Possible options to block ahead along with continuous updates
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestJamAheadList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestJamAheadListResponse (act_t act = 0);

    /**
     * The method sendRequestJamAheadListError() sends an error response of a
     * previous method invocation of 'requestJamAheadList' back to the client.
     *
     * <b>Documentation of 'requestJamAheadList'</b>:
     *
     * Fetch the Possible options to block ahead along with continuous updates
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestJamAheadList().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestJamAheadListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'releaseJamAheadList'

    /**
     * The method onReleaseJamAheadList() is called by ASF when a client
     * invokes the method 'releaseJamAheadList'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendReleaseJamAheadList() or sendReleaseJamAheadListError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'releaseJamAheadList'</b>:
     *
     * Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseJamAheadListRequest (const ::boost::shared_ptr< ReleaseJamAheadListRequest >& request) = 0;

    /**
     * The method sendReleaseJamAheadListResponse() sends a response of a
     * previous method invocation of 'releaseJamAheadList' back to the client.
     *
     * <b>Documentation of 'releaseJamAheadList'</b>:
     *
     * Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this
     *
     * @param act The parameter act identifies a previous invocation of
     * onReleaseJamAheadList(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReleaseJamAheadListResponse (act_t act = 0);

    /**
     * The method sendReleaseJamAheadListError() sends an error response of a
     * previous method invocation of 'releaseJamAheadList' back to the client.
     *
     * <b>Documentation of 'releaseJamAheadList'</b>:
     *
     * Stop continuous update of JamAheadList (?) will there be a context swith to Navi after this
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReleaseJamAheadList().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReleaseJamAheadListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'selectJamAheadListEntry'

    /**
     * The method onSelectJamAheadListEntry() is called by ASF when a client
     * invokes the method 'selectJamAheadListEntry'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendSelectJamAheadListEntry() or
     * sendSelectJamAheadListEntryError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'selectJamAheadListEntry'</b>:
     *
     * Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSelectJamAheadListEntryRequest (const ::boost::shared_ptr< SelectJamAheadListEntryRequest >& request) = 0;

    /**
     * The method sendSelectJamAheadListEntryResponse() sends a response of a
     * previous method invocation of 'selectJamAheadListEntry' back to the
     * client.
     *
     * <b>Documentation of 'selectJamAheadListEntry'</b>:
     *
     * Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this
     *
     * @param act The parameter act identifies a previous invocation of
     * onSelectJamAheadListEntry(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectJamAheadListEntryResponse (act_t act = 0);

    /**
     * The method sendSelectJamAheadListEntryError() sends an error response
     * of a previous method invocation of 'selectJamAheadListEntry' back to
     * the client.
     *
     * <b>Documentation of 'selectJamAheadListEntry'</b>:
     *
     * Choosing an entry from JamAheadList (?) will there be a context switch to Navi after this
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSelectJamAheadListEntry(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSelectJamAheadListEntryError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'activateNonPremiumTMC'

    /**
     * The method onActivateNonPremiumTMC() is called by ASF when a client
     * invokes the method 'activateNonPremiumTMC'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendActivateNonPremiumTMC() or sendActivateNonPremiumTMCError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'activateNonPremiumTMC'</b>:
     *
     * Request to activate Non Premium TMC
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActivateNonPremiumTMCRequest (const ::boost::shared_ptr< ActivateNonPremiumTMCRequest >& request) = 0;

    /**
     * The method sendActivateNonPremiumTMCResponse() sends a response of a
     * previous method invocation of 'activateNonPremiumTMC' back to the
     * client.
     *
     * <b>Documentation of 'activateNonPremiumTMC'</b>:
     *
     * Request to activate Non Premium TMC
     *
     * @param act The parameter act identifies a previous invocation of
     * onActivateNonPremiumTMC(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActivateNonPremiumTMCResponse (act_t act = 0);

    /**
     * The method sendActivateNonPremiumTMCError() sends an error response of
     * a previous method invocation of 'activateNonPremiumTMC' back to the
     * client.
     *
     * <b>Documentation of 'activateNonPremiumTMC'</b>:
     *
     * Request to activate Non Premium TMC
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onActivateNonPremiumTMC(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActivateNonPremiumTMCError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'deactivateNonPremiumTMC'

    /**
     * The method onDeactivateNonPremiumTMC() is called by ASF when a client
     * invokes the method 'deactivateNonPremiumTMC'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendDeactivateNonPremiumTMC() or
     * sendDeactivateNonPremiumTMCError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'deactivateNonPremiumTMC'</b>:
     *
     * Request to deactivate Non Premium TMC
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDeactivateNonPremiumTMCRequest (const ::boost::shared_ptr< DeactivateNonPremiumTMCRequest >& request) = 0;

    /**
     * The method sendDeactivateNonPremiumTMCResponse() sends a response of a
     * previous method invocation of 'deactivateNonPremiumTMC' back to the
     * client.
     *
     * <b>Documentation of 'deactivateNonPremiumTMC'</b>:
     *
     * Request to deactivate Non Premium TMC
     *
     * @param act The parameter act identifies a previous invocation of
     * onDeactivateNonPremiumTMC(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeactivateNonPremiumTMCResponse (act_t act = 0);

    /**
     * The method sendDeactivateNonPremiumTMCError() sends an error response
     * of a previous method invocation of 'deactivateNonPremiumTMC' back to
     * the client.
     *
     * <b>Documentation of 'deactivateNonPremiumTMC'</b>:
     *
     * Request to deactivate Non Premium TMC
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onDeactivateNonPremiumTMC(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDeactivateNonPremiumTMCError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'cancelJamAhead'

    /**
     * The method onCancelJamAhead() is called by ASF when a client invokes
     * the method 'cancelJamAhead'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCancelJamAhead() or sendCancelJamAheadError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'cancelJamAhead'</b>:
     *
     * Deleting already defined JamAhead
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelJamAheadRequest (const ::boost::shared_ptr< CancelJamAheadRequest >& request) = 0;

    /**
     * The method sendCancelJamAheadResponse() sends a response of a previous
     * method invocation of 'cancelJamAhead' back to the client.
     *
     * <b>Documentation of 'cancelJamAhead'</b>:
     *
     * Deleting already defined JamAhead
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelJamAhead(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelJamAheadResponse (act_t act = 0);

    /**
     * The method sendCancelJamAheadError() sends an error response of a
     * previous method invocation of 'cancelJamAhead' back to the client.
     *
     * <b>Documentation of 'cancelJamAhead'</b>:
     *
     * Deleting already defined JamAhead
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelJamAhead(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelJamAheadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestDetailsForSelectedCoordinateWithRadius'

    /**
     * The method onRequestDetailsForSelectedCoordinateWithRadius() is called
     * by ASF when a client invokes the method
     * 'requestDetailsForSelectedCoordinateWithRadius'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRequestDetailsForSelectedCoordinateWithRadius() or
     * sendRequestDetailsForSelectedCoordinateWithRadiusError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'requestDetailsForSelectedCoordinateWithRadius'</b>:
     *
     * Request will respond with list of location details for the given location and radius.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestDetailsForSelectedCoordinateWithRadiusRequest (const ::boost::shared_ptr< RequestDetailsForSelectedCoordinateWithRadiusRequest >& request) = 0;

    /**
     * The method sendRequestDetailsForSelectedCoordinateWithRadiusResponse()
     * sends a response of a previous method invocation of
     * 'requestDetailsForSelectedCoordinateWithRadius' back to the client.
     *
     * <b>Documentation of 'requestDetailsForSelectedCoordinateWithRadius'</b>:
     *
     * Request will respond with list of location details for the given location and radius.
     *
     * @param locationDetailsList If the meaning of "locationDetailsList" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestDetailsForSelectedCoordinateWithRadius(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendRequestDetailsForSelectedCoordinateWithRadiusResponse (const ::std::vector< LocationDetails >& locationDetailsList, act_t act = 0);

    /**
     * The method sendRequestDetailsForSelectedCoordinateWithRadiusError()
     * sends an error response of a previous method invocation of
     * 'requestDetailsForSelectedCoordinateWithRadius' back to the client.
     *
     * <b>Documentation of 'requestDetailsForSelectedCoordinateWithRadius'</b>:
     *
     * Request will respond with list of location details for the given location and radius.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestDetailsForSelectedCoordinateWithRadius(). If the act is not
     * specified, i.e. the most recent invocation will be answered. In case
     * multiple replies are pending an act must be specified. An assertion
     * will be thrown if no or multiple method invocation could be found.
     */
    void sendRequestDetailsForSelectedCoordinateWithRadiusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'showAndSetLocationWithDetails'

    /**
     * The method onShowAndSetLocationWithDetails() is called by ASF when a
     * client invokes the method 'showAndSetLocationWithDetails'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendShowAndSetLocationWithDetails() or
     * sendShowAndSetLocationWithDetailsError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'showAndSetLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for showing them and for further processing
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onShowAndSetLocationWithDetailsRequest (const ::boost::shared_ptr< ShowAndSetLocationWithDetailsRequest >& request) = 0;

    /**
     * The method sendShowAndSetLocationWithDetailsResponse() sends a response
     * of a previous method invocation of 'showAndSetLocationWithDetails' back
     * to the client.
     *
     * <b>Documentation of 'showAndSetLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for showing them and for further processing
     *
     * @param act The parameter act identifies a previous invocation of
     * onShowAndSetLocationWithDetails(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowAndSetLocationWithDetailsResponse (act_t act = 0);

    /**
     * The method sendShowAndSetLocationWithDetailsError() sends an error
     * response of a previous method invocation of
     * 'showAndSetLocationWithDetails' back to the client.
     *
     * <b>Documentation of 'showAndSetLocationWithDetails'</b>:
     *
     * Request to set the latitude and longitude value and location details for showing them and for further processing
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onShowAndSetLocationWithDetails(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendShowAndSetLocationWithDetailsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    NavStatusUpdate _navStatusProperty;

    DatasetVersionUpdate _datasetVersionProperty;

    NonPremiumTMCStatusUpdate _nonPremiumTMCStatusProperty;

    CurrentFreeTextSearchInfoUpdate _currentFreeTextSearchInfoProperty;

    PositionInformationUpdate _positionInformationProperty;

    DistanceToDestinationUpdate _distanceToDestinationProperty;

    CurrentStreetUpdate _currentStreetProperty;

    TurntoStreetUpdate _turntoStreetProperty;

    RoundaboutExitNumberUpdate _roundaboutExitNumberProperty;

    NextTurntoStreetUpdate _nextTurntoStreetProperty;

    BarGraphInfoUpdate _barGraphInfoProperty;

    ManeuverSymbolUpdate _maneuverSymbolProperty;

    SatelliteInfoUpdate _satelliteInfoProperty;

    DestinationInformationUpdate _destinationInformationProperty;

    RouteCalculationDurationUpdate _routeCalculationDurationProperty;

    HomeLocationUpdate _homeLocationProperty;

    WorkLocationUpdate _workLocationProperty;

    MapRepresentationUpdate _mapRepresentationProperty;

    SdsAddressWithOptionsUpdate _sdsAddressWithOptionsProperty;

    WaypointListUpdate _waypointListProperty;

    ManeuverViewUpdate _maneuverViewProperty;

    IntersectionMapCarsorPositionUpdate _intersectionMapCarsorPositionProperty;

    SpeedLimitUpdate _speedLimitProperty;

    TrafficEnforcementUpdate _trafficEnforcementProperty;

    NextManeuverDetailsUpdate _nextManeuverDetailsProperty;

    LaneRecommendationListUpdate _laneRecommendationListProperty;

    ArrivalInformationListUpdate _arrivalInformationListProperty;

    IntersectionMapUpdate _intersectionMapProperty;

    IsAddressBookChangedUpdate _isAddressBookChangedProperty;

    IsMaxAllowedAddressBookEntriesStoredUpdate _isMaxAllowedAddressBookEntriesStoredProperty;

    IsLastDestinationListChangedUpdate _isLastDestinationListChangedProperty;

    IsVoiceGuidanceActiveUpdate _isVoiceGuidanceActiveProperty;

    SdsVoiceTagWithOptionsUpdate _sdsVoiceTagWithOptionsProperty;

    TrafficMessagesCountUpdate _trafficMessagesCountProperty;

    TrafficServiceReceptionStatusUpdate _trafficServiceReceptionStatusProperty;

    SdsPOICategoryShortcutsUpdate _sdsPOICategoryShortcutsProperty;

    MenuPoiCategoryShortcutsUpdate _menuPoiCategoryShortcutsProperty;

    TripReplayStatusInfoUpdate _tripReplayStatusInfoProperty;

    EtcStatusUpdate _etcStatusProperty;

    TrafficSignInfoActiveUpdate _TrafficSignInfoActiveProperty;

    OverSpeedSoundAlertInfoActiveUpdate _OverSpeedSoundAlertInfoActiveProperty;

    RouteRecalculationReasonUpdate _routeRecalculationReasonProperty;

    RiskAreaDisplayInfoActiveUpdate _RiskAreaDisplayInfoActiveProperty;

    RiskAreaSoundAlertInfoActiveUpdate _RiskAreaSoundAlertInfoActiveProperty;

    JamAheadListUpdate _jamAheadListProperty;

    WaypointOperationStatusListUpdate _waypointOperationStatusListProperty;

    DestinationReachedStatusUpdate _destinationReachedStatusProperty;

    LightModeStatusUpdate _lightModeStatusProperty;

    MapCameraDataUpdate _mapCameraDataProperty;

    friend class NavigationServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_CM_NAVIGATION_NAVIGATIONSERVICESTUB_H
