/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Blob.h"
#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include "org/bosch/cm/navigation/NavigationServiceJson.h"
#include "org/bosch/cm/navigation/NavigationServiceJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "OSPSetting"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OSPSetting& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSettingType()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingType" , 11);
        const char* s = ::org::bosch::cm::navigation::NavigationService::OSPSettingType_Name(value.getSettingType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSettingType());
    }
    if (!isSparse || value.hasSettingStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "SettingStatus" , 13);
        yajl_gen_bool(g, (bool)value.getSettingStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OSPSetting& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficServiceReceptionStatus"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasServiceName()) {
        yajl_gen_string(g, (const unsigned char*)  "serviceName" , 11);
        const char *s = value.getServiceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTrafficServiceReceptionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficServiceReceptionStatus" , 29);
        yajl_gen_bool(g, (bool)value.getTrafficServiceReceptionStatus());
    }
    if (!isSparse || value.hasTrafficReceptionState()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficReceptionState" , 21);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TrafficReceptionState_Name(value.getTrafficReceptionState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTrafficReceptionState());
    }
    if (!isSparse || value.hasTrafficMessageCount()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficMessageCount" , 19);
        yajl_gen_integer(g, (long long)value.getTrafficMessageCount());
    }
    if (!isSparse || value.hasTrafficMessageSource()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficMessageSource" , 20);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TrafficMessageSource_Name(value.getTrafficMessageSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTrafficMessageSource());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TurnToStreet"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurnToStreet& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverId()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverId" , 10);
        yajl_gen_integer(g, (long long)value.getManeuverId());
    }
    if (!isSparse || value.hasTurnToStreet()) {
        yajl_gen_string(g, (const unsigned char*)  "turnToStreet" , 12);
        const char *s = value.getTurnToStreet().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurnToStreet& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DistanceToDestination"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestination& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistanceToDestinationAsString()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToDestinationAsString" , 29);
        const char *s = value.getDistanceToDestinationAsString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDistanceToDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToDestination" , 21);
        yajl_gen_integer(g, (long long)value.getDistanceToDestination());
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DistanceUnit_Name(value.getUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUnit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestination& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BarGraphInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasValid()) {
        yajl_gen_string(g, (const unsigned char*)  "valid" , 5);
        yajl_gen_bool(g, (bool)value.getValid());
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        yajl_gen_integer(g, (long long)value.getValue());
    }
    if (!isSparse || value.hasScale()) {
        yajl_gen_string(g, (const unsigned char*)  "scale" , 5);
        yajl_gen_integer(g, (long long)value.getScale());
    }
    if (!isSparse || value.hasUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "unit" , 4);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DistanceUnit_Name(value.getUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getUnit());
    }
    if (!isSparse || value.hasBarGraphMaxScale()) {
        yajl_gen_string(g, (const unsigned char*)  "barGraphMaxScale" , 16);
        const char *s = value.getBarGraphMaxScale().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasBarGraphMinScale()) {
        yajl_gen_string(g, (const unsigned char*)  "barGraphMinScale" , 16);
        const char *s = value.getBarGraphMinScale().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PositionWGS84"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionWGS84& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLongitude()) {
        yajl_gen_string(g, (const unsigned char*)  "longitude" , 9);
        yajl_gen_double(g, (double)value.getLongitude());
    }
    if (!isSparse || value.hasLatitude()) {
        yajl_gen_string(g, (const unsigned char*)  "latitude" , 8);
        yajl_gen_double(g, (double)value.getLatitude());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionWGS84& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TourElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TourElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    if (!isSparse || value.hasUseDefaultRouteCriterion()) {
        yajl_gen_string(g, (const unsigned char*)  "useDefaultRouteCriterion" , 24);
        yajl_gen_bool(g, (bool)value.getUseDefaultRouteCriterion());
    }
    if (!isSparse || value.hasRouteCriterion()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCriterion" , 14);
        const char* s = ::org::bosch::cm::navigation::NavigationService::RouteCriterion_Name(value.getRouteCriterion());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRouteCriterion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TourElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentFreeTextSearchInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "position" , 8);
        serializeJson(value.getPosition(), g, options);
    }
    if (!isSparse || value.hasSearchString()) {
        yajl_gen_string(g, (const unsigned char*)  "searchString" , 12);
        const char *s = value.getSearchString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PositionInformation"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPositionWGS84()) {
        yajl_gen_string(g, (const unsigned char*)  "positionWGS84" , 13);
        serializeJson(value.getPositionWGS84(), g, options);
    }
    if (!isSparse || value.hasMapMatchingPositionAccuracy()) {
        yajl_gen_string(g, (const unsigned char*)  "mapMatchingPositionAccuracy" , 27);
        yajl_gen_double(g, (double)value.getMapMatchingPositionAccuracy());
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "countryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStateCode()) {
        yajl_gen_string(g, (const unsigned char*)  "stateCode" , 9);
        const char *s = value.getStateCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRoadClass()) {
        yajl_gen_string(g, (const unsigned char*)  "roadClass" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::RoadClass_Name(value.getRoadClass());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRoadClass());
    }
    if (!isSparse || value.hasVehicleSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "vehicleSpeed" , 12);
        yajl_gen_double(g, (double)value.getVehicleSpeed());
    }
    if (!isSparse || value.hasVehicleHeading()) {
        yajl_gen_string(g, (const unsigned char*)  "vehicleHeading" , 14);
        yajl_gen_double(g, (double)value.getVehicleHeading());
    }
    if (!isSparse || value.hasAltitude()) {
        yajl_gen_string(g, (const unsigned char*)  "altitude" , 8);
        yajl_gen_integer(g, (long long)value.getAltitude());
    }
    if (!isSparse || value.hasCountry()) {
        yajl_gen_string(g, (const unsigned char*)  "country" , 7);
        const char *s = value.getCountry().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProvince()) {
        yajl_gen_string(g, (const unsigned char*)  "province" , 8);
        const char *s = value.getProvince().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCity()) {
        yajl_gen_string(g, (const unsigned char*)  "city" , 4);
        const char *s = value.getCity().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCityDistrict()) {
        yajl_gen_string(g, (const unsigned char*)  "cityDistrict" , 12);
        const char *s = value.getCityDistrict().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStreet()) {
        yajl_gen_string(g, (const unsigned char*)  "street" , 6);
        const char *s = value.getStreet().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStreetNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "streetNumber" , 12);
        const char *s = value.getStreetNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SatelliteInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVisibleSatellites()) {
        yajl_gen_string(g, (const unsigned char*)  "visibleSatellites" , 17);
        yajl_gen_integer(g, (long long)value.getVisibleSatellites());
    }
    if (!isSparse || value.hasReceivedSatellites()) {
        yajl_gen_string(g, (const unsigned char*)  "receivedSatellites" , 18);
        yajl_gen_integer(g, (long long)value.getReceivedSatellites());
    }
    if (!isSparse || value.hasUsedSatellites()) {
        yajl_gen_string(g, (const unsigned char*)  "usedSatellites" , 14);
        yajl_gen_integer(g, (long long)value.getUsedSatellites());
    }
    if (!isSparse || value.hasGnssMode()) {
        yajl_gen_string(g, (const unsigned char*)  "gnssMode" , 8);
        const char *s = value.getGnssMode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasGnssSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "gnssSpeed" , 9);
        yajl_gen_integer(g, (long long)value.getGnssSpeed());
    }
    if (!isSparse || value.hasGnssSpeedReliability()) {
        yajl_gen_string(g, (const unsigned char*)  "gnssSpeedReliability" , 20);
        yajl_gen_integer(g, (long long)value.getGnssSpeedReliability());
    }
    if (!isSparse || value.hasGnssPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "gnssPosition" , 12);
        serializeJson(value.getGnssPosition(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SDSElementOptions"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSElementOptions& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsAmbigious()) {
        yajl_gen_string(g, (const unsigned char*)  "isAmbigious" , 11);
        yajl_gen_bool(g, (bool)value.getIsAmbigious());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSElementOptions& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SDSAddressOptions"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavigable()) {
        yajl_gen_string(g, (const unsigned char*)  "navigable" , 9);
        yajl_gen_bool(g, (bool)value.getNavigable());
    }
    if (!isSparse || value.hasAmbigious()) {
        yajl_gen_string(g, (const unsigned char*)  "ambigious" , 9);
        yajl_gen_bool(g, (bool)value.getAmbigious());
    }
    if (!isSparse || value.hasRemovedInvalidEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "removedInvalidEntry" , 19);
        yajl_gen_bool(g, (bool)value.getRemovedInvalidEntry());
    }
    if (!isSparse || value.hasMoreEntriesPossible()) {
        yajl_gen_string(g, (const unsigned char*)  "moreEntriesPossible" , 19);
        yajl_gen_bool(g, (bool)value.getMoreEntriesPossible());
    }
    if (!isSparse || value.hasHouseNumberAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "houseNumberAvailable" , 20);
        yajl_gen_bool(g, (bool)value.getHouseNumberAvailable());
    }
    if (!isSparse || value.hasHouseNumberValid()) {
        yajl_gen_string(g, (const unsigned char*)  "houseNumberValid" , 16);
        yajl_gen_bool(g, (bool)value.getHouseNumberValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SDSAddressElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddressElementType()) {
        yajl_gen_string(g, (const unsigned char*)  "addressElementType" , 18);
        const char* s = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType_Name(value.getAddressElementType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAddressElementType());
    }
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasElementOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "elementOptions" , 14);
        serializeJson(value.getElementOptions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SDSAddressWithOptions"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >& o1 = value.getAddress();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasAddressOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "addressOptions" , 14);
        serializeJson(value.getAddressOptions(), g, options);
    }
    if (!isSparse || value.hasAddressElementType()) {
        yajl_gen_string(g, (const unsigned char*)  "addressElementType" , 18);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType >& o3 = value.getAddressElementType();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                const char* s = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType_Name((*o2));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationInfoElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "countryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSubCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "subCountryCode" , 14);
        const char *s = value.getSubCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RefinementListElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RefinementListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    if (!isSparse || value.hasDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "distance" , 8);
        const char *s = value.getDistance().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "direction" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DirectionDescription_Name(value.getDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RefinementListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AddressListElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::AddressListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasData()) {
        yajl_gen_string(g, (const unsigned char*)  "data" , 4);
        const char *s = value.getData().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getId(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "distance" , 8);
        const char *s = value.getDistance().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "direction" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DirectionDescription_Name(value.getDirection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDirection());
    }
    if (!isSparse || value.hasCoordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "coordinates" , 11);
        serializeJson(value.getCoordinates(), g, options);
    }
    if (!isSparse || value.hasSdsNameObjectId()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsNameObjectId" , 15);
        serializeJson(value.getSdsNameObjectId(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::AddressListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeformedImage"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DeformedImage& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasValid()) {
        yajl_gen_string(g, (const unsigned char*)  "valid" , 5);
        yajl_gen_bool(g, (bool)value.getValid());
    }
    if (!isSparse || value.hasDeformedImageRoadType()) {
        yajl_gen_string(g, (const unsigned char*)  "deformedImageRoadType" , 21);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DeformedImageRoadType_Name(value.getDeformedImageRoadType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeformedImageRoadType());
    }
    if (!isSparse || value.hasDeformedImageArrowType()) {
        yajl_gen_string(g, (const unsigned char*)  "deformedImageArrowType" , 22);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DeformedImageArrowType_Name(value.getDeformedImageArrowType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDeformedImageArrowType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DeformedImage& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WaypointListElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    if (!isSparse || value.hasRouteCriterion()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCriterion" , 14);
        const char* s = ::org::bosch::cm::navigation::NavigationService::RouteCriterion_Name(value.getRouteCriterion());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRouteCriterion());
    }
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManeuverView"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverView& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverId()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverId" , 10);
        yajl_gen_integer(g, (long long)value.getManeuverId());
    }
    if (!isSparse || value.hasManeuverViewType()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverViewType" , 16);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ManeuverViewType_Name(value.getManeuverViewType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getManeuverViewType());
    }
    if (!isSparse || value.hasDeformedImage()) {
        yajl_gen_string(g, (const unsigned char*)  "deformedImage" , 13);
        serializeJson(value.getDeformedImage(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverView& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ScreenCoordinate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasXPos()) {
        yajl_gen_string(g, (const unsigned char*)  "xPos" , 4);
        yajl_gen_integer(g, (long long)value.getXPos());
    }
    if (!isSparse || value.hasYPos()) {
        yajl_gen_string(g, (const unsigned char*)  "yPos" , 4);
        yajl_gen_integer(g, (long long)value.getYPos());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapRoadLine"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCoordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "coordinates" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >& o5 = value.getCoordinates();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRoadClass()) {
        yajl_gen_string(g, (const unsigned char*)  "roadClass" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::AdminRoadClass_Name(value.getRoadClass());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRoadClass());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMap"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMap& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverId()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverId" , 10);
        yajl_gen_integer(g, (long long)value.getManeuverId());
    }
    if (!isSparse || value.hasRoad()) {
        yajl_gen_string(g, (const unsigned char*)  "road" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >& o7 = value.getRoad();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasRoute()) {
        yajl_gen_string(g, (const unsigned char*)  "route" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >& o9 = value.getRoute();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasNoEntryIcons()) {
        yajl_gen_string(g, (const unsigned char*)  "noEntryIcons" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >& o11 = value.getNoEntryIcons();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMap& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapCarsorPosition"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverId()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverId" , 10);
        yajl_gen_integer(g, (long long)value.getManeuverId());
    }
    if (!isSparse || value.hasCarsorState()) {
        yajl_gen_string(g, (const unsigned char*)  "carsorState" , 11);
        const char* s = ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorState_Name(value.getCarsorState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCarsorState());
    }
    if (!isSparse || value.hasCarsorPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "carsorPosition" , 14);
        serializeJson(value.getCarsorPosition(), g, options);
    }
    if (!isSparse || value.hasCarsorAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "carsorAngle" , 11);
        yajl_gen_integer(g, (long long)value.getCarsorAngle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedLimit"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimit& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPresent()) {
        yajl_gen_string(g, (const unsigned char*)  "present" , 7);
        yajl_gen_bool(g, (bool)value.getPresent());
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "countryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasValue()) {
        yajl_gen_string(g, (const unsigned char*)  "value" , 5);
        yajl_gen_integer(g, (long long)value.getValue());
    }
    if (!isSparse || value.hasSpeedUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "speedUnit" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::SpeedUnit_Name(value.getSpeedUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSpeedUnit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimit& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficEnforcement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrafficEnforcementAlertState()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficEnforcementAlertState" , 28);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementAlertState_Name(value.getTrafficEnforcementAlertState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTrafficEnforcementAlertState());
    }
    if (!isSparse || value.hasTrafficEnforcementCameraType()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficEnforcementCameraType" , 28);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementCameraType_Name(value.getTrafficEnforcementCameraType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTrafficEnforcementCameraType());
    }
    if (!isSparse || value.hasDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "distance" , 8);
        const char *s = value.getDistance().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDistanceUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceUnit" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DistanceUnit_Name(value.getDistanceUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDistanceUnit());
    }
    if (!isSparse || value.hasTrafficEnforcementDistanceType()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficEnforcementDistanceType" , 30);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementDistanceType_Name(value.getTrafficEnforcementDistanceType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTrafficEnforcementDistanceType());
    }
    if (!isSparse || value.hasSpeedLimit()) {
        yajl_gen_string(g, (const unsigned char*)  "speedLimit" , 10);
        yajl_gen_integer(g, (long long)value.getSpeedLimit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteCalculationDuration"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteCalDurationToFinalDest()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCalDurationToFinalDest" , 27);
        yajl_gen_integer(g, (long long)value.getRouteCalDurationToFinalDest());
    }
    if (!isSparse || value.hasRouteCalDurationToNextDest()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCalDurationToNextDest" , 26);
        yajl_gen_integer(g, (long long)value.getRouteCalDurationToNextDest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LaneRecommendation"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLaneStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "laneStatus" , 10);
        const char* s = ::org::bosch::cm::navigation::NavigationService::LaneStatus_Name(value.getLaneStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLaneStatus());
    }
    if (!isSparse || value.hasCombinedFollowingLaneDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "combinedFollowingLaneDirection" , 30);
        yajl_gen_integer(g, (long long)value.getCombinedFollowingLaneDirection());
    }
    if (!isSparse || value.hasGuidedFollowingLaneDirection()) {
        yajl_gen_string(g, (const unsigned char*)  "guidedFollowingLaneDirection" , 28);
        yajl_gen_integer(g, (long long)value.getGuidedFollowingLaneDirection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArrivalInformation"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistanceToDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToDestination" , 21);
        serializeJson(value.getDistanceToDestination(), g, options);
    }
    if (!isSparse || value.hasTimeToDestinationAsString()) {
        yajl_gen_string(g, (const unsigned char*)  "timeToDestinationAsString" , 25);
        const char *s = value.getTimeToDestinationAsString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTimeToDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "timeToDestination" , 17);
        yajl_gen_integer(g, (long long)value.getTimeToDestination());
    }
    if (!isSparse || value.hasEstimatedTimeOfArrivalAsString()) {
        yajl_gen_string(g, (const unsigned char*)  "estimatedTimeOfArrivalAsString" , 30);
        const char *s = value.getEstimatedTimeOfArrivalAsString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEstimatedTimeOfArrivalHour()) {
        yajl_gen_string(g, (const unsigned char*)  "estimatedTimeOfArrivalHour" , 26);
        yajl_gen_integer(g, (long long)value.getEstimatedTimeOfArrivalHour());
    }
    if (!isSparse || value.hasEstimatedTimeOfArrivalMinute()) {
        yajl_gen_string(g, (const unsigned char*)  "estimatedTimeOfArrivalMinute" , 28);
        yajl_gen_integer(g, (long long)value.getEstimatedTimeOfArrivalMinute());
    }
    if (!isSparse || value.hasEstimatedTimeType()) {
        yajl_gen_string(g, (const unsigned char*)  "estimatedTimeType" , 17);
        const char* s = ::org::bosch::cm::navigation::NavigationService::EstimatedTimeType_Name(value.getEstimatedTimeType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEstimatedTimeType());
    }
    if (!isSparse || value.hasDisplayTimeType()) {
        yajl_gen_string(g, (const unsigned char*)  "displayTimeType" , 15);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TimeType_Name(value.getDisplayTimeType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDisplayTimeType());
    }
    if (!isSparse || value.hasDisplayTimeFormat()) {
        yajl_gen_string(g, (const unsigned char*)  "displayTimeFormat" , 17);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TimeFormat_Name(value.getDisplayTimeFormat());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDisplayTimeFormat());
    }
    if (!isSparse || value.hasDestinationIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationIndex" , 16);
        yajl_gen_integer(g, (long long)value.getDestinationIndex());
    }
    if (!isSparse || value.hasConsumptionUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "consumptionUnit" , 15);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ConsumptionUnit_Name(value.getConsumptionUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getConsumptionUnit());
    }
    if (!isSparse || value.hasConsumptionToDestinationAsInt()) {
        yajl_gen_string(g, (const unsigned char*)  "consumptionToDestinationAsInt" , 29);
        yajl_gen_integer(g, (long long)value.getConsumptionToDestinationAsInt());
    }
    if (!isSparse || value.hasConsumptionToDestinationAsString()) {
        yajl_gen_string(g, (const unsigned char*)  "consumptionToDestinationAsString" , 32);
        const char *s = value.getConsumptionToDestinationAsString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NextManeuverDetails"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistanceToManeuver()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToManeuver" , 18);
        const char *s = value.getDistanceToManeuver().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDistanceToManeuverUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToManeuverUnit" , 22);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DistanceUnit_Name(value.getDistanceToManeuverUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDistanceToManeuverUnit());
    }
    if (!isSparse || value.hasRecommendationType()) {
        yajl_gen_string(g, (const unsigned char*)  "recommendationType" , 18);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ManeuverRecommendationType_Name(value.getRecommendationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRecommendationType());
    }
    if (!isSparse || value.hasIsNewManeuver()) {
        yajl_gen_string(g, (const unsigned char*)  "isNewManeuver" , 13);
        yajl_gen_bool(g, (bool)value.getIsNewManeuver());
    }
    if (!isSparse || value.hasIsReRouted()) {
        yajl_gen_string(g, (const unsigned char*)  "isReRouted" , 10);
        yajl_gen_bool(g, (bool)value.getIsReRouted());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Image"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::Image& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasImage()) {
        yajl_gen_string(g, (const unsigned char*)  "image" , 5);
        {
            yajl_gen_array_open(g);
            const ::asf::core::Blob& o12 = value.getImage();
            for (unsigned int o13=0 ; o13 < o12.getSize (); o13++) {
                yajl_gen_integer(g, (long long)o12.getBytes()[o13]);
            }
            yajl_gen_array_close(g);
        }
    }
    if (!isSparse || value.hasImageType()) {
        yajl_gen_string(g, (const unsigned char*)  "imageType" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ImageType_Name(value.getImageType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getImageType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::Image& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Location"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::Location& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPositionWGS84()) {
        yajl_gen_string(g, (const unsigned char*)  "positionWGS84" , 13);
        serializeJson(value.getPositionWGS84(), g, options);
    }
    if (!isSparse || value.hasValid()) {
        yajl_gen_string(g, (const unsigned char*)  "valid" , 5);
        yajl_gen_bool(g, (bool)value.getValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::Location& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "POILocation"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::POILocation& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    if (!isSparse || value.hasPhoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "phoneNumber" , 11);
        const char *s = value.getPhoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "address" , 7);
        const char *s = value.getAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasIcon()) {
        yajl_gen_string(g, (const unsigned char*)  "icon" , 4);
        serializeJson(value.getIcon(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::POILocation& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PoiCategoryShortcut"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCategoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "categoryName" , 12);
        const char *s = value.getCategoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPoiCategoryId()) {
        yajl_gen_string(g, (const unsigned char*)  "poiCategoryId" , 13);
        yajl_gen_integer(g, (long long)value.getPoiCategoryId());
    }
    if (!isSparse || value.hasIcon()) {
        yajl_gen_string(g, (const unsigned char*)  "icon" , 4);
        serializeJson(value.getIcon(), g, options);
    }
    if (!isSparse || value.hasShortcutIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "shortcutIndex" , 13);
        yajl_gen_integer(g, (long long)value.getShortcutIndex());
    }
    if (!isSparse || value.hasSdsNameObjectId()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsNameObjectId" , 15);
        serializeJson(value.getSdsNameObjectId(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LocationDetails"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LocationDetails& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCityName()) {
        yajl_gen_string(g, (const unsigned char*)  "cityName" , 8);
        const char *s = value.getCityName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCountryName()) {
        yajl_gen_string(g, (const unsigned char*)  "countryName" , 11);
        const char *s = value.getCountryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "countryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStateName()) {
        yajl_gen_string(g, (const unsigned char*)  "stateName" , 9);
        const char *s = value.getStateName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStateCode()) {
        yajl_gen_string(g, (const unsigned char*)  "stateCode" , 9);
        const char *s = value.getStateCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPhoneNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "phoneNumber" , 11);
        const char *s = value.getPhoneNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPoiAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "poiAddress" , 10);
        const char *s = value.getPoiAddress().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStreetName()) {
        yajl_gen_string(g, (const unsigned char*)  "streetName" , 10);
        const char *s = value.getStreetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasZipCode()) {
        yajl_gen_string(g, (const unsigned char*)  "zipCode" , 7);
        const char *s = value.getZipCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "coordinate" , 10);
        serializeJson(value.getCoordinate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LocationDetails& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationMemoryEntry"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasName()) {
        yajl_gen_string(g, (const unsigned char*)  "name" , 4);
        const char *s = value.getName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasEntryID()) {
        yajl_gen_string(g, (const unsigned char*)  "entryID" , 7);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getEntryID(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasVoiceTagId()) {
        yajl_gen_string(g, (const unsigned char*)  "voiceTagId" , 10);
        yajl_gen_integer(g, (long long)value.getVoiceTagId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationMemoryEntryItem"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasItemString()) {
        yajl_gen_string(g, (const unsigned char*)  "itemString" , 10);
        const char *s = value.getItemString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAddressType()) {
        yajl_gen_string(g, (const unsigned char*)  "addressType" , 11);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType_Name(value.getAddressType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAddressType());
    }
    if (!isSparse || value.hasItemPhoneme()) {
        yajl_gen_string(g, (const unsigned char*)  "itemPhoneme" , 11);
        const char *s = value.getItemPhoneme().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationMemoryEntryDetails"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCountryName()) {
        yajl_gen_string(g, (const unsigned char*)  "countryName" , 11);
        const char *s = value.getCountryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStateName()) {
        yajl_gen_string(g, (const unsigned char*)  "stateName" , 9);
        const char *s = value.getStateName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCityName()) {
        yajl_gen_string(g, (const unsigned char*)  "cityName" , 8);
        const char *s = value.getCityName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasStreetName()) {
        yajl_gen_string(g, (const unsigned char*)  "streetName" , 10);
        const char *s = value.getStreetName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasHouseno()) {
        yajl_gen_string(g, (const unsigned char*)  "houseno" , 7);
        const char *s = value.getHouseno().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasJunctionName()) {
        yajl_gen_string(g, (const unsigned char*)  "junctionName" , 12);
        const char *s = value.getJunctionName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPoiName()) {
        yajl_gen_string(g, (const unsigned char*)  "poiName" , 7);
        const char *s = value.getPoiName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPoiCategoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "poiCategoryName" , 15);
        const char *s = value.getPoiCategoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPoiBrandName()) {
        yajl_gen_string(g, (const unsigned char*)  "poiBrandName" , 12);
        const char *s = value.getPoiBrandName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCountryCode()) {
        yajl_gen_string(g, (const unsigned char*)  "countryCode" , 11);
        const char *s = value.getCountryCode().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAddressDetail()) {
        yajl_gen_string(g, (const unsigned char*)  "addressDetail" , 13);
        const char *s = value.getAddressDetail().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSdsDestinationMemoryEntries()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsDestinationMemoryEntries" , 27);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >& o15 = value.getSdsDestinationMemoryEntries();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationMemoryDetailListElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEntry()) {
        yajl_gen_string(g, (const unsigned char*)  "entry" , 5);
        serializeJson(value.getEntry(), g, options);
    }
    if (!isSparse || value.hasDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "details" , 7);
        serializeJson(value.getDetails(), g, options);
    }
    if (!isSparse || value.hasCoordinates()) {
        yajl_gen_string(g, (const unsigned char*)  "coordinates" , 11);
        serializeJson(value.getCoordinates(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SDSVoiceTagId"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestinationMemoryEntryId()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationMemoryEntryId" , 24);
        char buffer[21];
        ::asf::stream::json::ulltoa ((uint64_t)value.getDestinationMemoryEntryId(), buffer);
        yajl_gen_number(g, buffer, strlen (buffer));
    }
    if (!isSparse || value.hasDestinationMemoryEntryName()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationMemoryEntryName" , 26);
        const char *s = value.getDestinationMemoryEntryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSdsVoiceTagId()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsVoiceTagId" , 13);
        yajl_gen_integer(g, (long long)value.getSdsVoiceTagId());
    }
    if (!isSparse || value.hasOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "options" , 7);
        const char* s = ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagOptions_Name(value.getOptions());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getOptions());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TripReplayStatusInfo"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::org::bosch::cm::navigation::NavigationService::TripReplayStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasLoopModeActive()) {
        yajl_gen_string(g, (const unsigned char*)  "loopModeActive" , 14);
        yajl_gen_bool(g, (bool)value.getLoopModeActive());
    }
    if (!isSparse || value.hasTripFileName()) {
        yajl_gen_string(g, (const unsigned char*)  "tripFileName" , 12);
        const char *s = value.getTripFileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "progress" , 8);
        yajl_gen_integer(g, (long long)value.getProgress());
    }
    if (!isSparse || value.hasSyncSegment()) {
        yajl_gen_string(g, (const unsigned char*)  "syncSegment" , 11);
        yajl_gen_integer(g, (long long)value.getSyncSegment());
    }
    if (!isSparse || value.hasCountSyncSegments()) {
        yajl_gen_string(g, (const unsigned char*)  "countSyncSegments" , 17);
        yajl_gen_integer(g, (long long)value.getCountSyncSegments());
    }
    if (!isSparse || value.hasSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "speed" , 5);
        yajl_gen_integer(g, (long long)value.getSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JamAheadListElement"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListElement& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistance()) {
        yajl_gen_string(g, (const unsigned char*)  "distance" , 8);
        const char *s = value.getDistance().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDistanceWithoutUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceWithoutUnit" , 19);
        const char *s = value.getDistanceWithoutUnit().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasDistanceUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceUnit" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DistanceUnit_Name(value.getDistanceUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDistanceUnit());
    }
    if (!isSparse || value.hasIsEnabled()) {
        yajl_gen_string(g, (const unsigned char*)  "isEnabled" , 9);
        yajl_gen_bool(g, (bool)value.getIsEnabled());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListElement& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JamAheadList"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadList& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJamAheadActivityStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "jamAheadActivityStatus" , 22);
        const char* s = ::org::bosch::cm::navigation::NavigationService::JamAheadActivityStatus_Name(value.getJamAheadActivityStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getJamAheadActivityStatus());
    }
    if (!isSparse || value.hasJamAheadListElements()) {
        yajl_gen_string(g, (const unsigned char*)  "jamAheadListElements" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement >& o17 = value.getJamAheadListElements();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadList& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapCameraData"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasScaleBarWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "scaleBarWidth" , 13);
        yajl_gen_integer(g, (long long)value.getScaleBarWidth());
    }
    if (!isSparse || value.hasMapScale()) {
        yajl_gen_string(g, (const unsigned char*)  "mapScale" , 8);
        const char *s = value.getMapScale().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCameraHeading()) {
        yajl_gen_string(g, (const unsigned char*)  "cameraHeading" , 13);
        yajl_gen_double(g, (double)value.getCameraHeading());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GlobalNamedObjectId"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasGlobalUpdateRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "globalUpdateRegionId" , 20);
        serializeJson(value.getGlobalUpdateRegionId(), g, options);
    }
    if (!isSparse || value.hasNamedObjectId()) {
        yajl_gen_string(g, (const unsigned char*)  "namedObjectId" , 13);
        yajl_gen_integer(g, (long long)value.getNamedObjectId());
    }
    if (!isSparse || value.hasIsValid()) {
        yajl_gen_string(g, (const unsigned char*)  "isValid" , 7);
        yajl_gen_bool(g, (bool)value.getIsValid());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GlobalUpdateRegionId"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUpdateRegionId()) {
        yajl_gen_string(g, (const unsigned char*)  "updateRegionId" , 14);
        yajl_gen_integer(g, (long long)value.getUpdateRegionId());
    }
    if (!isSparse || value.hasProductId()) {
        yajl_gen_string(g, (const unsigned char*)  "productId" , 9);
        yajl_gen_integer(g, (long long)value.getProductId());
    }
    if (!isSparse || value.hasSupplierId()) {
        yajl_gen_string(g, (const unsigned char*)  "supplierId" , 10);
        yajl_gen_integer(g, (long long)value.getSupplierId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectPoiCategoryShortcutRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasShortcutIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "shortcutIndex" , 13);
        yajl_gen_integer(g, (long long)value.getShortcutIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetPoiCategoryShortcutsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPoiCategoryShortcuts()) {
        yajl_gen_string(g, (const unsigned char*)  "poiCategoryShortcuts" , 20);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >& o19 = value.getPoiCategoryShortcuts();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o18;
            for (o18 = o19.begin(); o18 != o19.end(); ++o18) {
                serializeJson((*o18), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocationWithCoordinatesRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocationWithDetailsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowPOILocationFromTCURequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPoiLocations()) {
        yajl_gen_string(g, (const unsigned char*)  "poiLocations" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation >& o21 = value.getPoiLocations();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation >::const_iterator o20;
            for (o20 = o21.begin(); o20 != o21.end(); ++o20) {
                serializeJson((*o20), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StorePOILocationToAddressBookRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPoiLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "poiLocation" , 11);
        serializeJson(value.getPoiLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StoreLocationToAddressBookRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowDestinationOverviewFromTCURequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "currentPosition" , 15);
        serializeJson(value.getCurrentPosition(), g, options);
    }
    if (!isSparse || value.hasDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "destination" , 11);
        serializeJson(value.getDestination(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowCalculateTourRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTour()) {
        yajl_gen_string(g, (const unsigned char*)  "tour" , 4);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement >& o23 = value.getTour();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement >::const_iterator o22;
            for (o22 = o23.begin(); o22 != o23.end(); ++o22) {
                serializeJson((*o22), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasScreenTransition()) {
        yajl_gen_string(g, (const unsigned char*)  "screenTransition" , 16);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ScreenTransition_Name(value.getScreenTransition());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getScreenTransition());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowOnMapRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowOnMapRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowOnMapRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowCityInputAndGetCityCoordinatesResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCityCenterCoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "cityCenterCoordinate" , 20);
        serializeJson(value.getCityCenterCoordinate(), g, options);
    }
    if (!isSparse || value.hasIsValidAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "isValidAddress" , 14);
        yajl_gen_bool(g, (bool)value.getIsValidAddress());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestLocationDetailsForCoordinatesRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCityCoordinate()) {
        yajl_gen_string(g, (const unsigned char*)  "cityCoordinate" , 14);
        serializeJson(value.getCityCoordinate(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestLocationDetailsForCoordinatesResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "locationDetails" , 15);
        serializeJson(value.getLocationDetails(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowMapScreenWithMapViewModeRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMapViewMode()) {
        yajl_gen_string(g, (const unsigned char*)  "MapViewMode" , 11);
        const char* s = ::org::bosch::cm::navigation::NavigationService::MapViewMode_Name(value.getMapViewMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMapViewMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowMapScreenCarsorLockModeRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMapCameraMode()) {
        yajl_gen_string(g, (const unsigned char*)  "mapCameraMode" , 13);
        const char* s = ::org::bosch::cm::navigation::NavigationService::MapCameraMode_Name(value.getMapCameraMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMapCameraMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetZoomInStepRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasZoomInStep()) {
        yajl_gen_string(g, (const unsigned char*)  "zoomInStep" , 10);
        yajl_gen_integer(g, (long long)value.getZoomInStep());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetZoomOutStepRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasZoomOutStep()) {
        yajl_gen_string(g, (const unsigned char*)  "zoomOutStep" , 11);
        yajl_gen_integer(g, (long long)value.getZoomOutStep());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetZoomLevelRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasZoomLevel()) {
        yajl_gen_string(g, (const unsigned char*)  "zoomLevel" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ZoomLevel_Name(value.getZoomLevel());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getZoomLevel());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetVersionStringResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GetVersionStringResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVersionString()) {
        yajl_gen_string(g, (const unsigned char*)  "versionString" , 13);
        const char *s = value.getVersionString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::GetVersionStringResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSXMTravelLinkSubscriptionStatusRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        yajl_gen_bool(g, (bool)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartGuidanceToPosWGS84Request"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "destination" , 11);
        serializeJson(value.getDestination(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocationWithDestinationMemoryEntryRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InsertWaypointRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::InsertWaypointRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNewIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "newIndex" , 8);
        yajl_gen_integer(g, (long long)value.getNewIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::InsertWaypointRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReplaceWaypointRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteWaypointsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFirstIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "firstIndex" , 10);
        yajl_gen_integer(g, (long long)value.getFirstIndex());
    }
    if (!isSparse || value.hasLastIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "lastIndex" , 9);
        yajl_gen_integer(g, (long long)value.getLastIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestSetFreeTextSearchTypeRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationType()) {
        yajl_gen_string(g, (const unsigned char*)  "locationType" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FTSLocationType_Name(value.getLocationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLocationType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestFreeTextSearchResultsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSearchString()) {
        yajl_gen_string(g, (const unsigned char*)  "searchString" , 12);
        const char *s = value.getSearchString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasSearchScope()) {
        yajl_gen_string(g, (const unsigned char*)  "searchScope" , 11);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope_Name(value.getSearchScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSearchScope());
    }
    if (!isSparse || value.hasDestinationIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationIndex" , 16);
        yajl_gen_integer(g, (long long)value.getDestinationIndex());
    }
    if (!isSparse || value.hasStartIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "startIndex" , 10);
        yajl_gen_integer(g, (long long)value.getStartIndex());
    }
    if (!isSparse || value.hasNumElements()) {
        yajl_gen_string(g, (const unsigned char*)  "numElements" , 11);
        yajl_gen_integer(g, (long long)value.getNumElements());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestFreeTextSearchResultsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSearchResults()) {
        yajl_gen_string(g, (const unsigned char*)  "searchResults" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >& o25 = value.getSearchResults();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o24;
            for (o24 = o25.begin(); o24 != o25.end(); ++o24) {
                serializeJson((*o24), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocationWithFreeTextSearchInputRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowDestinationFreeTextSearchInputRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationType()) {
        yajl_gen_string(g, (const unsigned char*)  "locationType" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FTSLocationType_Name(value.getLocationType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLocationType());
    }
    if (!isSparse || value.hasLocationSearchScope()) {
        yajl_gen_string(g, (const unsigned char*)  "locationSearchScope" , 19);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope_Name(value.getLocationSearchScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLocationSearchScope());
    }
    if (!isSparse || value.hasSearchString()) {
        yajl_gen_string(g, (const unsigned char*)  "searchString" , 12);
        const char *s = value.getSearchString().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestFixedPOICategorySearchResultsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasFixedPOICategory()) {
        yajl_gen_string(g, (const unsigned char*)  "fixedPOICategory" , 16);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FixedPOICategory_Name(value.getFixedPOICategory());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getFixedPOICategory());
    }
    if (!isSparse || value.hasLocationSearchScope()) {
        yajl_gen_string(g, (const unsigned char*)  "locationSearchScope" , 19);
        const char* s = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope_Name(value.getLocationSearchScope());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLocationSearchScope());
    }
    if (!isSparse || value.hasDestinationIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationIndex" , 16);
        yajl_gen_integer(g, (long long)value.getDestinationIndex());
    }
    if (!isSparse || value.hasStartIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "startIndex" , 10);
        yajl_gen_integer(g, (long long)value.getStartIndex());
    }
    if (!isSparse || value.hasNumElements()) {
        yajl_gen_string(g, (const unsigned char*)  "numElements" , 11);
        yajl_gen_integer(g, (long long)value.getNumElements());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestFixedPOICategorySearchResultsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSearchResults()) {
        yajl_gen_string(g, (const unsigned char*)  "searchResults" , 13);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >& o27 = value.getSearchResults();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o26;
            for (o26 = o27.begin(); o26 != o27.end(); ++o26) {
                serializeJson((*o26), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetLocationWithFixedPOICategoryInputRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsCheckAddressRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequestedAddress()) {
        yajl_gen_string(g, (const unsigned char*)  "requestedAddress" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >& o29 = value.getRequestedAddress();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o28;
            for (o28 = o29.begin(); o28 != o29.end(); ++o28) {
                serializeJson((*o28), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsGetRefinementListRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSdsAddressElementType()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsAddressElementType" , 21);
        const char* s = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType_Name(value.getSdsAddressElementType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSdsAddressElementType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsGetRefinementListResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRefinements()) {
        yajl_gen_string(g, (const unsigned char*)  "refinements" , 11);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement >& o31 = value.getRefinements();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement >::const_iterator o30;
            for (o30 = o31.begin(); o30 != o31.end(); ++o30) {
                serializeJson((*o30), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectSdsRefinementRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasId()) {
        yajl_gen_string(g, (const unsigned char*)  "id" , 2);
        yajl_gen_integer(g, (long long)value.getId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDestinationMemoryEntriesRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCategoryType()) {
        yajl_gen_string(g, (const unsigned char*)  "categoryType" , 12);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DestinationMemoryCategoryType_Name(value.getCategoryType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCategoryType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDestinationMemoryEntriesResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestinationMemoryEntries()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationMemoryEntries" , 24);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement >& o33 = value.getDestinationMemoryEntries();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement >::const_iterator o32;
            for (o32 = o33.begin(); o32 != o33.end(); ++o32) {
                serializeJson((*o32), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMapRepresentationRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRepresentation()) {
        yajl_gen_string(g, (const unsigned char*)  "representation" , 14);
        const char* s = ::org::bosch::cm::navigation::NavigationService::MapRepresentation_Name(value.getRepresentation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRepresentation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDetailsForSelectedLocationResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationDetail()) {
        yajl_gen_string(g, (const unsigned char*)  "locationDetail" , 14);
        serializeJson(value.getLocationDetail(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeakSamplePhraseRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSampleVoicePhrase()) {
        yajl_gen_string(g, (const unsigned char*)  "sampleVoicePhrase" , 17);
        const char* s = ::org::bosch::cm::navigation::NavigationService::SampleVoicePhrase_Name(value.getSampleVoicePhrase());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getSampleVoicePhrase());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRouteCriterionRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteCriterion()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCriterion" , 14);
        const char* s = ::org::bosch::cm::navigation::NavigationService::RouteCriterion_Name(value.getRouteCriterion());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRouteCriterion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetVoiceGuidanceRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActive()) {
        yajl_gen_string(g, (const unsigned char*)  "active" , 6);
        yajl_gen_bool(g, (bool)value.getActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CheckNavDataCompatibilityRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavDataVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "navDataVersion" , 14);
        const char *s = value.getNavDataVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCompatibilityInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "compatibilityInfo" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o35 = value.getCompatibilityInfo();
        {
            ::std::vector< uint8 >::const_iterator o34;
            for (o34 = o35.begin(); o34 != o35.end(); ++o34) {
                yajl_gen_integer(g, (long long)(*o34));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CheckNavDataCompatibilityResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCompatibility()) {
        yajl_gen_string(g, (const unsigned char*)  "compatibility" , 13);
        const char* s = ::org::bosch::cm::navigation::NavigationService::NavDataCompatibility_Name(value.getCompatibility());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCompatibility());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsUpdateVoiceTagRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasVoiceTagID()) {
        yajl_gen_string(g, (const unsigned char*)  "voiceTagID" , 10);
        serializeJson(value.getVoiceTagID(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsGetHouseNumberPatternResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMinHouseNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "minHouseNumber" , 14);
        const char *s = value.getMinHouseNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasMaxHouseNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "maxHouseNumber" , 14);
        const char *s = value.getMaxHouseNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasPatterns()) {
        yajl_gen_string(g, (const unsigned char*)  "patterns" , 8);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o37 = value.getPatterns();
        {
            ::std::vector< ::std::string >::const_iterator o36;
            for (o36 = o37.begin(); o36 != o37.end(); ++o36) {
                const char *s = (*o36).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMapLightModeRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActive()) {
        yajl_gen_string(g, (const unsigned char*)  "active" , 6);
        yajl_gen_bool(g, (bool)value.getActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StartTripReplayRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StartTripReplayRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTripFileName()) {
        yajl_gen_string(g, (const unsigned char*)  "tripFileName" , 12);
        const char *s = value.getTripFileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::StartTripReplayRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SeekTripReplayRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSeekValue()) {
        yajl_gen_string(g, (const unsigned char*)  "seekValue" , 9);
        yajl_gen_integer(g, (long long)value.getSeekValue());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetTripReplayModeRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLoopModeActive()) {
        yajl_gen_string(g, (const unsigned char*)  "loopModeActive" , 14);
        yajl_gen_bool(g, (bool)value.getLoopModeActive());
    }
    if (!isSparse || value.hasSpeed()) {
        yajl_gen_string(g, (const unsigned char*)  "speed" , 5);
        yajl_gen_integer(g, (long long)value.getSpeed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowLocationSelectionAndGetAddressDetailsResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestinationMemoryDetailListElement()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationMemoryDetailListElement" , 34);
        serializeJson(value.getDestinationMemoryDetailListElement(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SelectJamAheadListEntryRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIndex()) {
        yajl_gen_string(g, (const unsigned char*)  "index" , 5);
        yajl_gen_integer(g, (long long)value.getIndex());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDetailsForSelectedCoordinateWithRadiusRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    if (!isSparse || value.hasRadius()) {
        yajl_gen_string(g, (const unsigned char*)  "radius" , 6);
        yajl_gen_integer(g, (long long)value.getRadius());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RequestDetailsForSelectedCoordinateWithRadiusResponse"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocationDetailsList()) {
        yajl_gen_string(g, (const unsigned char*)  "locationDetailsList" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails >& o39 = value.getLocationDetailsList();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails >::const_iterator o38;
            for (o38 = o39.begin(); o38 != o39.end(); ++o38) {
                serializeJson((*o38), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ShowAndSetLocationWithDetailsRequest"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "location" , 8);
        serializeJson(value.getLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NavStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNavStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "navStatus" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::NavStatus_Name(value.getNavStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getNavStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NavStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NavStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NavStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NavStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DatasetVersionUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDatasetVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "datasetVersion" , 14);
        const char *s = value.getDatasetVersion().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DatasetVersionRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NonPremiumTMCStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNonPremiumTMCStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "nonPremiumTMCStatus" , 19);
        yajl_gen_bool(g, (bool)value.getNonPremiumTMCStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NonPremiumTMCStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentFreeTextSearchInfoUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentFreeTextSearchInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "currentFreeTextSearchInfo" , 25);
        serializeJson(value.getCurrentFreeTextSearchInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentFreeTextSearchInfoRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PositionInformationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPositionInformation()) {
        yajl_gen_string(g, (const unsigned char*)  "positionInformation" , 19);
        serializeJson(value.getPositionInformation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PositionInformationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::PositionInformationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DistanceToDestinationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDistanceToDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "distanceToDestination" , 21);
        serializeJson(value.getDistanceToDestination(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DistanceToDestinationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentStreetUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCurrentStreet()) {
        yajl_gen_string(g, (const unsigned char*)  "currentStreet" , 13);
        const char *s = value.getCurrentStreet().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CurrentStreetRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TurntoStreetUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTurntoStreet()) {
        yajl_gen_string(g, (const unsigned char*)  "turntoStreet" , 12);
        serializeJson(value.getTurntoStreet(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TurntoStreetRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RoundaboutExitNumberUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRoundaboutExitNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "roundaboutExitNumber" , 20);
        yajl_gen_integer(g, (long long)value.getRoundaboutExitNumber());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RoundaboutExitNumberRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NextTurntoStreetUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNextTurntoStreet()) {
        yajl_gen_string(g, (const unsigned char*)  "nextTurntoStreet" , 16);
        const char *s = value.getNextTurntoStreet().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NextTurntoStreetRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BarGraphInfoUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBarGraphInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "barGraphInfo" , 12);
        serializeJson(value.getBarGraphInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "BarGraphInfoRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManeuverSymbolUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverSymbol()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverSymbol" , 14);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ManeuverSymbol_Name(value.getManeuverSymbol());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getManeuverSymbol());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManeuverSymbolRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SatelliteInfoUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSatelliteInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "satelliteInfo" , 13);
        serializeJson(value.getSatelliteInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SatelliteInfoRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationInformationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestinationInformation()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationInformation" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement >& o41 = value.getDestinationInformation();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement >::const_iterator o40;
            for (o40 = o41.begin(); o40 != o41.end(); ++o40) {
                serializeJson((*o40), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationInformationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteCalculationDurationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteCalculationDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "routeCalculationDuration" , 24);
        serializeJson(value.getRouteCalculationDuration(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteCalculationDurationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HomeLocationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::HomeLocationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHomeLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "homeLocation" , 12);
        serializeJson(value.getHomeLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::HomeLocationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "HomeLocationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::HomeLocationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::HomeLocationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WorkLocationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WorkLocationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWorkLocation()) {
        yajl_gen_string(g, (const unsigned char*)  "workLocation" , 12);
        serializeJson(value.getWorkLocation(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WorkLocationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WorkLocationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WorkLocationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WorkLocationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapRepresentationUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMapRepresentation()) {
        yajl_gen_string(g, (const unsigned char*)  "mapRepresentation" , 17);
        const char* s = ::org::bosch::cm::navigation::NavigationService::MapRepresentation_Name(value.getMapRepresentation());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getMapRepresentation());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapRepresentationRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsAddressWithOptionsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSdsAddressWithOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsAddressWithOptions" , 21);
        serializeJson(value.getSdsAddressWithOptions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsAddressWithOptionsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WaypointListUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWaypointList()) {
        yajl_gen_string(g, (const unsigned char*)  "waypointList" , 12);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement >& o43 = value.getWaypointList();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement >::const_iterator o42;
            for (o42 = o43.begin(); o42 != o43.end(); ++o42) {
                serializeJson((*o42), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WaypointListRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointListRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManeuverViewUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasManeuverView()) {
        yajl_gen_string(g, (const unsigned char*)  "maneuverView" , 12);
        serializeJson(value.getManeuverView(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ManeuverViewRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapCarsorPositionUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIntersectionMapCarsorPosition()) {
        yajl_gen_string(g, (const unsigned char*)  "intersectionMapCarsorPosition" , 29);
        serializeJson(value.getIntersectionMapCarsorPosition(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapCarsorPositionRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedLimitUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSpeedLimit()) {
        yajl_gen_string(g, (const unsigned char*)  "speedLimit" , 10);
        serializeJson(value.getSpeedLimit(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SpeedLimitRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficEnforcementUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrafficEnforcement()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficEnforcement" , 18);
        serializeJson(value.getTrafficEnforcement(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficEnforcementRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NextManeuverDetailsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNextManeuverDetails()) {
        yajl_gen_string(g, (const unsigned char*)  "nextManeuverDetails" , 19);
        serializeJson(value.getNextManeuverDetails(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "NextManeuverDetailsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LaneRecommendationListUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLaneRecommendationList()) {
        yajl_gen_string(g, (const unsigned char*)  "laneRecommendationList" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation >& o45 = value.getLaneRecommendationList();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation >::const_iterator o44;
            for (o44 = o45.begin(); o44 != o45.end(); ++o44) {
                serializeJson((*o44), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LaneRecommendationListRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArrivalInformationListUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArrivalInformationList()) {
        yajl_gen_string(g, (const unsigned char*)  "arrivalInformationList" , 22);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation >& o47 = value.getArrivalInformationList();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation >::const_iterator o46;
            for (o46 = o47.begin(); o46 != o47.end(); ++o46) {
                serializeJson((*o46), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ArrivalInformationListRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIntersectionMap()) {
        yajl_gen_string(g, (const unsigned char*)  "intersectionMap" , 15);
        serializeJson(value.getIntersectionMap(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IntersectionMapRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsAddressBookChangedUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsAddressBookChanged()) {
        yajl_gen_string(g, (const unsigned char*)  "isAddressBookChanged" , 20);
        yajl_gen_bool(g, (bool)value.getIsAddressBookChanged());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsAddressBookChangedRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsMaxAllowedAddressBookEntriesStoredUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsMaxAllowedAddressBookEntriesStored()) {
        yajl_gen_string(g, (const unsigned char*)  "isMaxAllowedAddressBookEntriesStored" , 36);
        yajl_gen_bool(g, (bool)value.getIsMaxAllowedAddressBookEntriesStored());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsMaxAllowedAddressBookEntriesStoredRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsLastDestinationListChangedUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsLastDestinationListChanged()) {
        yajl_gen_string(g, (const unsigned char*)  "isLastDestinationListChanged" , 28);
        yajl_gen_bool(g, (bool)value.getIsLastDestinationListChanged());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsLastDestinationListChangedRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsVoiceGuidanceActiveUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsVoiceGuidanceActive()) {
        yajl_gen_string(g, (const unsigned char*)  "isVoiceGuidanceActive" , 21);
        yajl_gen_bool(g, (bool)value.getIsVoiceGuidanceActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IsVoiceGuidanceActiveRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsVoiceTagWithOptionsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSdsVoiceTagWithOptions()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsVoiceTagWithOptions" , 22);
        serializeJson(value.getSdsVoiceTagWithOptions(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsVoiceTagWithOptionsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficMessagesCountUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrafficMessagesCount()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficMessagesCount" , 20);
        yajl_gen_integer(g, (long long)value.getTrafficMessagesCount());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficMessagesCountRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficServiceReceptionStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrafficServiceReceptionStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "trafficServiceReceptionStatus" , 29);
        serializeJson(value.getTrafficServiceReceptionStatus(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficServiceReceptionStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsPOICategoryShortcutsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSdsPOICategoryShortcuts()) {
        yajl_gen_string(g, (const unsigned char*)  "sdsPOICategoryShortcuts" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >& o49 = value.getSdsPOICategoryShortcuts();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o48;
            for (o48 = o49.begin(); o48 != o49.end(); ++o48) {
                serializeJson((*o48), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SdsPOICategoryShortcutsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MenuPoiCategoryShortcutsUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMenuPoiCategoryShortcuts()) {
        yajl_gen_string(g, (const unsigned char*)  "menuPoiCategoryShortcuts" , 24);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >& o51 = value.getMenuPoiCategoryShortcuts();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o50;
            for (o50 = o51.begin(); o50 != o51.end(); ++o50) {
                serializeJson((*o50), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MenuPoiCategoryShortcutsRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TripReplayStatusInfoUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTripReplayStatusInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "tripReplayStatusInfo" , 20);
        serializeJson(value.getTripReplayStatusInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TripReplayStatusInfoRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EtcStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::EtcStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasEtcStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "etcStatus" , 9);
        const char* s = ::org::bosch::cm::navigation::NavigationService::ETCStatus_Name(value.getEtcStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getEtcStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::EtcStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "EtcStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::EtcStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::EtcStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficSignInfoActiveUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrafficSignInfoActive()) {
        yajl_gen_string(g, (const unsigned char*)  "TrafficSignInfoActive" , 21);
        yajl_gen_bool(g, (bool)value.getTrafficSignInfoActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TrafficSignInfoActiveRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OverSpeedSoundAlertInfoActiveUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasOverSpeedSoundAlertInfoActive()) {
        yajl_gen_string(g, (const unsigned char*)  "OverSpeedSoundAlertInfoActive" , 29);
        yajl_gen_bool(g, (bool)value.getOverSpeedSoundAlertInfoActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OverSpeedSoundAlertInfoActiveRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteRecalculationReasonUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRouteRecalculationReason()) {
        yajl_gen_string(g, (const unsigned char*)  "routeRecalculationReason" , 24);
        const char* s = ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReason_Name(value.getRouteRecalculationReason());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getRouteRecalculationReason());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RouteRecalculationReasonRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RiskAreaDisplayInfoActiveUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRiskAreaDisplayInfoActive()) {
        yajl_gen_string(g, (const unsigned char*)  "RiskAreaDisplayInfoActive" , 25);
        yajl_gen_bool(g, (bool)value.getRiskAreaDisplayInfoActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RiskAreaDisplayInfoActiveRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RiskAreaSoundAlertInfoActiveUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRiskAreaSoundAlertInfoActive()) {
        yajl_gen_string(g, (const unsigned char*)  "RiskAreaSoundAlertInfoActive" , 28);
        yajl_gen_bool(g, (bool)value.getRiskAreaSoundAlertInfoActive());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RiskAreaSoundAlertInfoActiveRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JamAheadListUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasJamAheadList()) {
        yajl_gen_string(g, (const unsigned char*)  "jamAheadList" , 12);
        serializeJson(value.getJamAheadList(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "JamAheadListRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::JamAheadListRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WaypointOperationStatusListUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasWaypointOperationStatusList()) {
        yajl_gen_string(g, (const unsigned char*)  "waypointOperationStatusList" , 27);
        yajl_gen_array_open(g);
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus >& o53 = value.getWaypointOperationStatusList();
        {
            ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus >::const_iterator o52;
            for (o52 = o53.begin(); o52 != o53.end(); ++o52) {
                const char* s = ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus_Name((*o52));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o52));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "WaypointOperationStatusListRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationReachedStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDestinationReachedStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "destinationReachedStatus" , 24);
        const char* s = ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatus_Name(value.getDestinationReachedStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDestinationReachedStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DestinationReachedStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LightModeStatusUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasLightModeStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "lightModeStatus" , 15);
        const char* s = ::org::bosch::cm::navigation::NavigationService::LightModeStatus_Name(value.getLightModeStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLightModeStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LightModeStatusRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapCameraDataUpdate"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMapCameraData()) {
        yajl_gen_string(g, (const unsigned char*)  "mapCameraData" , 13);
        serializeJson(value.getMapCameraData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapCameraDataRegister"

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::OSPSetting& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TurnToStreet& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DistanceToDestination& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::BarGraphInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::PositionWGS84& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TourElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::PositionInformation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SatelliteInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SDSElementOptions& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SDSAddressElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RefinementListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::AddressListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DeformedImage& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WaypointListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ManeuverView& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMap& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SpeedLimit& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LaneRecommendation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ArrivalInformation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::Image& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::Location& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::POILocation& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LocationDetails& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::JamAheadListElement& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::JamAheadList& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MapCameraData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowOnMapRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::GetVersionStringResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::InsertWaypointRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::StartTripReplayRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NavStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NavStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DatasetVersionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DatasetVersionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::PositionInformationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::PositionInformationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CurrentStreetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::CurrentStreetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TurntoStreetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TurntoStreetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationInformationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::HomeLocationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::HomeLocationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WorkLocationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WorkLocationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MapRepresentationUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MapRepresentationRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WaypointListUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WaypointListRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ManeuverViewUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ManeuverViewRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SpeedLimitUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SpeedLimitRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::EtcStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::EtcStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::JamAheadListUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::JamAheadListRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LightModeStatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::LightModeStatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MapCameraDataUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org
using namespace ::asf::stream::json;

namespace org {
namespace bosch {
namespace cm {
namespace navigation {
namespace NavigationService {

std::ostream& operator<<(std::ostream& o, const ::org::bosch::cm::navigation::NavigationService::MapCameraDataRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace NavigationService
} // namespace navigation
} // namespace cm
} // namespace bosch
} // namespace org

