/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Blob.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "org/bosch/cm/navigation/NavigationServiceConst.h"
#include "org/bosch/cm/navigation/NavigationServiceDBus.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of OSPSetting

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::OSPSetting& in, DBusMessageIter* out) {
    {
        DBusMessageIter o0Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o0Struct));
        const ::org::bosch::cm::navigation::NavigationService::OSPSettingType  o1 = in.getSettingType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_UINT32, &o1));
        dbus_bool_t o2 = in.getSettingStatus() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0Struct, DBUS_TYPE_BOOLEAN, &o2));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o0Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::OSPSetting& out) {
    {
        DBusMessageIter o3;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o3);
                {
                    ::org::bosch::cm::navigation::NavigationService::OSPSettingType SettingTypeValue = ::org::bosch::cm::navigation::NavigationService::OSPSettingType__TRAFFIC_SIGN;
                    dbus_message_iter_get_basic(&o3, &SettingTypeValue);
                    out.setSettingType(SettingTypeValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

                {
                    bool SettingStatusValue;
                    bool &SettingStatusTmpValue = SettingStatusValue;
                    {
                        dbus_bool_t o4;
                        dbus_message_iter_get_basic(&o3, &o4);
                        SettingStatusTmpValue = o4 ? true : false;
                    }
                    out.setSettingStatus(SettingStatusValue);
                }

                if (dbus_message_iter_has_next(&o3)) {
                    dbus_message_iter_next(&o3);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TrafficServiceReceptionStatus

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus& in, DBusMessageIter* out) {
    {
        DBusMessageIter o5Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o5Struct));
        const char* o6 = in.getServiceName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_STRING, &o6));
        dbus_bool_t o7 = in.getTrafficServiceReceptionStatus() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_BOOLEAN, &o7));
        const ::org::bosch::cm::navigation::NavigationService::TrafficReceptionState  o8 = in.getTrafficReceptionState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_UINT32, &o8));
        uint32 o9 = in.getTrafficMessageCount();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_UINT32, &o9));
        const ::org::bosch::cm::navigation::NavigationService::TrafficMessageSource  o10 = in.getTrafficMessageSource();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o5Struct, DBUS_TYPE_UINT32, &o10));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o5Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus& out) {
    {
        DBusMessageIter o11;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o11);
                {
                    ::std::string serviceNameValue;
                    ::std::string &serviceNameTmpValue = serviceNameValue;
                    {
                        char* o12 = 0;
                        dbus_message_iter_get_basic(&o11, &o12);
                        serviceNameTmpValue.assign (o12);
                    }
                    out.setServiceName(serviceNameValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    bool trafficServiceReceptionStatusValue;
                    bool &trafficServiceReceptionStatusTmpValue = trafficServiceReceptionStatusValue;
                    {
                        dbus_bool_t o13;
                        dbus_message_iter_get_basic(&o11, &o13);
                        trafficServiceReceptionStatusTmpValue = o13 ? true : false;
                    }
                    out.setTrafficServiceReceptionStatus(trafficServiceReceptionStatusValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TrafficReceptionState trafficReceptionStateValue = ::org::bosch::cm::navigation::NavigationService::TrafficReceptionState__UNKNOWN;
                    dbus_message_iter_get_basic(&o11, &trafficReceptionStateValue);
                    out.setTrafficReceptionState(trafficReceptionStateValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    uint32 trafficMessageCountValue;
                    uint32 &trafficMessageCountTmpValue = trafficMessageCountValue;
                    dbus_message_iter_get_basic(&o11, &trafficMessageCountTmpValue);
                    out.setTrafficMessageCount(trafficMessageCountValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TrafficMessageSource trafficMessageSourceValue = ::org::bosch::cm::navigation::NavigationService::TrafficMessageSource__UNKOWN;
                    dbus_message_iter_get_basic(&o11, &trafficMessageSourceValue);
                    out.setTrafficMessageSource(trafficMessageSourceValue);
                }

                if (dbus_message_iter_has_next(&o11)) {
                    dbus_message_iter_next(&o11);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TurnToStreet

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TurnToStreet& in, DBusMessageIter* out) {
    {
        DBusMessageIter o14Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o14Struct));
        uint32 o15 = in.getManeuverId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_UINT32, &o15));
        const char* o16 = in.getTurnToStreet().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o14Struct, DBUS_TYPE_STRING, &o16));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o14Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TurnToStreet& out) {
    {
        DBusMessageIter o17;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o17);
                {
                    uint32 maneuverIdValue;
                    uint32 &maneuverIdTmpValue = maneuverIdValue;
                    dbus_message_iter_get_basic(&o17, &maneuverIdTmpValue);
                    out.setManeuverId(maneuverIdValue);
                }

                if (dbus_message_iter_has_next(&o17)) {
                    dbus_message_iter_next(&o17);
                } else {
                    return true;
                }

                {
                    ::std::string turnToStreetValue;
                    ::std::string &turnToStreetTmpValue = turnToStreetValue;
                    {
                        char* o18 = 0;
                        dbus_message_iter_get_basic(&o17, &o18);
                        turnToStreetTmpValue.assign (o18);
                    }
                    out.setTurnToStreet(turnToStreetValue);
                }

                if (dbus_message_iter_has_next(&o17)) {
                    dbus_message_iter_next(&o17);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DistanceToDestination

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestination& in, DBusMessageIter* out) {
    {
        DBusMessageIter o19Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o19Struct));
        const char* o20 = in.getDistanceToDestinationAsString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o19Struct, DBUS_TYPE_STRING, &o20));
        uint32 o21 = in.getDistanceToDestination();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o19Struct, DBUS_TYPE_UINT32, &o21));
        const ::org::bosch::cm::navigation::NavigationService::DistanceUnit  o22 = in.getUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o19Struct, DBUS_TYPE_UINT32, &o22));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o19Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DistanceToDestination& out) {
    {
        DBusMessageIter o23;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o23);
                {
                    ::std::string distanceToDestinationAsStringValue;
                    ::std::string &distanceToDestinationAsStringTmpValue = distanceToDestinationAsStringValue;
                    {
                        char* o24 = 0;
                        dbus_message_iter_get_basic(&o23, &o24);
                        distanceToDestinationAsStringTmpValue.assign (o24);
                    }
                    out.setDistanceToDestinationAsString(distanceToDestinationAsStringValue);
                }

                if (dbus_message_iter_has_next(&o23)) {
                    dbus_message_iter_next(&o23);
                } else {
                    return true;
                }

                {
                    uint32 distanceToDestinationValue;
                    uint32 &distanceToDestinationTmpValue = distanceToDestinationValue;
                    dbus_message_iter_get_basic(&o23, &distanceToDestinationTmpValue);
                    out.setDistanceToDestination(distanceToDestinationValue);
                }

                if (dbus_message_iter_has_next(&o23)) {
                    dbus_message_iter_next(&o23);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceUnit unitValue = ::org::bosch::cm::navigation::NavigationService::DistanceUnit__METERS;
                    dbus_message_iter_get_basic(&o23, &unitValue);
                    out.setUnit(unitValue);
                }

                if (dbus_message_iter_has_next(&o23)) {
                    dbus_message_iter_next(&o23);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of BarGraphInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o25Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o25Struct));
        dbus_bool_t o26 = in.getValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_BOOLEAN, &o26));
        uint16 o27 = in.getValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_UINT16, &o27));
        uint16 o28 = in.getScale();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_UINT16, &o28));
        const ::org::bosch::cm::navigation::NavigationService::DistanceUnit  o29 = in.getUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_UINT32, &o29));
        const char* o30 = in.getBarGraphMaxScale().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_STRING, &o30));
        const char* o31 = in.getBarGraphMinScale().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o25Struct, DBUS_TYPE_STRING, &o31));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o25Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::BarGraphInfo& out) {
    {
        DBusMessageIter o32;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o32);
                {
                    bool validValue;
                    bool &validTmpValue = validValue;
                    {
                        dbus_bool_t o33;
                        dbus_message_iter_get_basic(&o32, &o33);
                        validTmpValue = o33 ? true : false;
                    }
                    out.setValid(validValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    uint16 valueValue;
                    uint16 &valueTmpValue = valueValue;
                    dbus_message_iter_get_basic(&o32, &valueTmpValue);
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    uint16 scaleValue;
                    uint16 &scaleTmpValue = scaleValue;
                    dbus_message_iter_get_basic(&o32, &scaleTmpValue);
                    out.setScale(scaleValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceUnit unitValue = ::org::bosch::cm::navigation::NavigationService::DistanceUnit__METERS;
                    dbus_message_iter_get_basic(&o32, &unitValue);
                    out.setUnit(unitValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::std::string barGraphMaxScaleValue;
                    ::std::string &barGraphMaxScaleTmpValue = barGraphMaxScaleValue;
                    {
                        char* o34 = 0;
                        dbus_message_iter_get_basic(&o32, &o34);
                        barGraphMaxScaleTmpValue.assign (o34);
                    }
                    out.setBarGraphMaxScale(barGraphMaxScaleValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

                {
                    ::std::string barGraphMinScaleValue;
                    ::std::string &barGraphMinScaleTmpValue = barGraphMinScaleValue;
                    {
                        char* o35 = 0;
                        dbus_message_iter_get_basic(&o32, &o35);
                        barGraphMinScaleTmpValue.assign (o35);
                    }
                    out.setBarGraphMinScale(barGraphMinScaleValue);
                }

                if (dbus_message_iter_has_next(&o32)) {
                    dbus_message_iter_next(&o32);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PositionWGS84

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::PositionWGS84& in, DBusMessageIter* out) {
    {
        DBusMessageIter o36Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o36Struct));
        double o37 = in.getLongitude();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_DOUBLE, &o37));
        double o38 = in.getLatitude();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o36Struct, DBUS_TYPE_DOUBLE, &o38));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o36Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::PositionWGS84& out) {
    {
        DBusMessageIter o39;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o39);
                {
                    double longitudeValue;
                    double &longitudeTmpValue = longitudeValue;
                    dbus_message_iter_get_basic(&o39, &longitudeTmpValue);
                    out.setLongitude(longitudeValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

                {
                    double latitudeValue;
                    double &latitudeTmpValue = latitudeValue;
                    dbus_message_iter_get_basic(&o39, &latitudeTmpValue);
                    out.setLatitude(latitudeValue);
                }

                if (dbus_message_iter_has_next(&o39)) {
                    dbus_message_iter_next(&o39);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TourElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TourElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o40Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o40Struct));
        serializeDBus(in.getLocation(), &o40Struct);
        dbus_bool_t o41 = in.getUseDefaultRouteCriterion() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_BOOLEAN, &o41));
        const ::org::bosch::cm::navigation::NavigationService::RouteCriterion  o42 = in.getRouteCriterion();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o40Struct, DBUS_TYPE_UINT32, &o42));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o40Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TourElement& out) {
    {
        DBusMessageIter o43;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o43);
                {
                    ::org::bosch::cm::navigation::NavigationService::POILocation locationValue;
                    if (!deserializeDBus(&o43, locationValue)) {
                        return false;
                    }
                    out.setLocation(locationValue);
                }

                if (dbus_message_iter_has_next(&o43)) {
                    dbus_message_iter_next(&o43);
                } else {
                    return true;
                }

                {
                    bool useDefaultRouteCriterionValue;
                    bool &useDefaultRouteCriterionTmpValue = useDefaultRouteCriterionValue;
                    {
                        dbus_bool_t o44;
                        dbus_message_iter_get_basic(&o43, &o44);
                        useDefaultRouteCriterionTmpValue = o44 ? true : false;
                    }
                    out.setUseDefaultRouteCriterion(useDefaultRouteCriterionValue);
                }

                if (dbus_message_iter_has_next(&o43)) {
                    dbus_message_iter_next(&o43);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::RouteCriterion routeCriterionValue = ::org::bosch::cm::navigation::NavigationService::RouteCriterion__ROUTE_CRITERION_ECONOMIC;
                    dbus_message_iter_get_basic(&o43, &routeCriterionValue);
                    out.setRouteCriterion(routeCriterionValue);
                }

                if (dbus_message_iter_has_next(&o43)) {
                    dbus_message_iter_next(&o43);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of CurrentFreeTextSearchInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o45Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o45Struct));
        serializeDBus(in.getPosition(), &o45Struct);
        const char* o46 = in.getSearchString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o45Struct, DBUS_TYPE_STRING, &o46));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o45Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo& out) {
    {
        DBusMessageIter o47;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o47);
                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 positionValue;
                    if (!deserializeDBus(&o47, positionValue)) {
                        return false;
                    }
                    out.setPosition(positionValue);
                }

                if (dbus_message_iter_has_next(&o47)) {
                    dbus_message_iter_next(&o47);
                } else {
                    return true;
                }

                {
                    ::std::string searchStringValue;
                    ::std::string &searchStringTmpValue = searchStringValue;
                    {
                        char* o48 = 0;
                        dbus_message_iter_get_basic(&o47, &o48);
                        searchStringTmpValue.assign (o48);
                    }
                    out.setSearchString(searchStringValue);
                }

                if (dbus_message_iter_has_next(&o47)) {
                    dbus_message_iter_next(&o47);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PositionInformation

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::PositionInformation& in, DBusMessageIter* out) {
    {
        DBusMessageIter o49Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o49Struct));
        serializeDBus(in.getPositionWGS84(), &o49Struct);
        double o50 = in.getMapMatchingPositionAccuracy();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_DOUBLE, &o50));
        const char* o51 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o51));
        const char* o52 = in.getStateCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o52));
        const ::org::bosch::cm::navigation::NavigationService::RoadClass  o53 = in.getRoadClass();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_UINT32, &o53));
        double o54 = in.getVehicleSpeed();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_DOUBLE, &o54));
        double o55 = in.getVehicleHeading();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_DOUBLE, &o55));
        int32 o56 = in.getAltitude();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_INT32, &o56));
        const char* o57 = in.getCountry().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o57));
        const char* o58 = in.getProvince().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o58));
        const char* o59 = in.getCity().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o59));
        const char* o60 = in.getCityDistrict().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o60));
        const char* o61 = in.getStreet().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o61));
        const char* o62 = in.getStreetNumber().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o49Struct, DBUS_TYPE_STRING, &o62));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o49Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::PositionInformation& out) {
    {
        DBusMessageIter o63;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o63);
                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 positionWGS84Value;
                    if (!deserializeDBus(&o63, positionWGS84Value)) {
                        return false;
                    }
                    out.setPositionWGS84(positionWGS84Value);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    float mapMatchingPositionAccuracyValue;
                    float &mapMatchingPositionAccuracyTmpValue = mapMatchingPositionAccuracyValue;
                    {
                        double o64;
                        dbus_message_iter_get_basic(&o63, &o64);
                        mapMatchingPositionAccuracyTmpValue = static_cast<float>(o64);
                    }
                    out.setMapMatchingPositionAccuracy(mapMatchingPositionAccuracyValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o65 = 0;
                        dbus_message_iter_get_basic(&o63, &o65);
                        countryCodeTmpValue.assign (o65);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string stateCodeValue;
                    ::std::string &stateCodeTmpValue = stateCodeValue;
                    {
                        char* o66 = 0;
                        dbus_message_iter_get_basic(&o63, &o66);
                        stateCodeTmpValue.assign (o66);
                    }
                    out.setStateCode(stateCodeValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::RoadClass roadClassValue = ::org::bosch::cm::navigation::NavigationService::RoadClass__ROAD_CLASS_NONE;
                    dbus_message_iter_get_basic(&o63, &roadClassValue);
                    out.setRoadClass(roadClassValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    float vehicleSpeedValue;
                    float &vehicleSpeedTmpValue = vehicleSpeedValue;
                    {
                        double o67;
                        dbus_message_iter_get_basic(&o63, &o67);
                        vehicleSpeedTmpValue = static_cast<float>(o67);
                    }
                    out.setVehicleSpeed(vehicleSpeedValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    float vehicleHeadingValue;
                    float &vehicleHeadingTmpValue = vehicleHeadingValue;
                    {
                        double o68;
                        dbus_message_iter_get_basic(&o63, &o68);
                        vehicleHeadingTmpValue = static_cast<float>(o68);
                    }
                    out.setVehicleHeading(vehicleHeadingValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    int32 altitudeValue;
                    int32 &altitudeTmpValue = altitudeValue;
                    dbus_message_iter_get_basic(&o63, &altitudeTmpValue);
                    out.setAltitude(altitudeValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string countryValue;
                    ::std::string &countryTmpValue = countryValue;
                    {
                        char* o69 = 0;
                        dbus_message_iter_get_basic(&o63, &o69);
                        countryTmpValue.assign (o69);
                    }
                    out.setCountry(countryValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string provinceValue;
                    ::std::string &provinceTmpValue = provinceValue;
                    {
                        char* o70 = 0;
                        dbus_message_iter_get_basic(&o63, &o70);
                        provinceTmpValue.assign (o70);
                    }
                    out.setProvince(provinceValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string cityValue;
                    ::std::string &cityTmpValue = cityValue;
                    {
                        char* o71 = 0;
                        dbus_message_iter_get_basic(&o63, &o71);
                        cityTmpValue.assign (o71);
                    }
                    out.setCity(cityValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string cityDistrictValue;
                    ::std::string &cityDistrictTmpValue = cityDistrictValue;
                    {
                        char* o72 = 0;
                        dbus_message_iter_get_basic(&o63, &o72);
                        cityDistrictTmpValue.assign (o72);
                    }
                    out.setCityDistrict(cityDistrictValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string streetValue;
                    ::std::string &streetTmpValue = streetValue;
                    {
                        char* o73 = 0;
                        dbus_message_iter_get_basic(&o63, &o73);
                        streetTmpValue.assign (o73);
                    }
                    out.setStreet(streetValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

                {
                    ::std::string streetNumberValue;
                    ::std::string &streetNumberTmpValue = streetNumberValue;
                    {
                        char* o74 = 0;
                        dbus_message_iter_get_basic(&o63, &o74);
                        streetNumberTmpValue.assign (o74);
                    }
                    out.setStreetNumber(streetNumberValue);
                }

                if (dbus_message_iter_has_next(&o63)) {
                    dbus_message_iter_next(&o63);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SatelliteInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o75Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o75Struct));
        uint8 o76 = in.getVisibleSatellites();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_BYTE, &o76));
        uint8 o77 = in.getReceivedSatellites();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_BYTE, &o77));
        uint8 o78 = in.getUsedSatellites();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_BYTE, &o78));
        const char* o79 = in.getGnssMode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_STRING, &o79));
        uint16 o80 = in.getGnssSpeed();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_UINT16, &o80));
        uint8 o81 = in.getGnssSpeedReliability();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o75Struct, DBUS_TYPE_BYTE, &o81));
        serializeDBus(in.getGnssPosition(), &o75Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o75Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SatelliteInfo& out) {
    {
        DBusMessageIter o82;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o82);
                {
                    uint8 visibleSatellitesValue;
                    uint8 &visibleSatellitesTmpValue = visibleSatellitesValue;
                    dbus_message_iter_get_basic(&o82, &visibleSatellitesTmpValue);
                    out.setVisibleSatellites(visibleSatellitesValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    uint8 receivedSatellitesValue;
                    uint8 &receivedSatellitesTmpValue = receivedSatellitesValue;
                    dbus_message_iter_get_basic(&o82, &receivedSatellitesTmpValue);
                    out.setReceivedSatellites(receivedSatellitesValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    uint8 usedSatellitesValue;
                    uint8 &usedSatellitesTmpValue = usedSatellitesValue;
                    dbus_message_iter_get_basic(&o82, &usedSatellitesTmpValue);
                    out.setUsedSatellites(usedSatellitesValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    ::std::string gnssModeValue;
                    ::std::string &gnssModeTmpValue = gnssModeValue;
                    {
                        char* o83 = 0;
                        dbus_message_iter_get_basic(&o82, &o83);
                        gnssModeTmpValue.assign (o83);
                    }
                    out.setGnssMode(gnssModeValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    uint16 gnssSpeedValue;
                    uint16 &gnssSpeedTmpValue = gnssSpeedValue;
                    dbus_message_iter_get_basic(&o82, &gnssSpeedTmpValue);
                    out.setGnssSpeed(gnssSpeedValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    uint8 gnssSpeedReliabilityValue;
                    uint8 &gnssSpeedReliabilityTmpValue = gnssSpeedReliabilityValue;
                    dbus_message_iter_get_basic(&o82, &gnssSpeedReliabilityTmpValue);
                    out.setGnssSpeedReliability(gnssSpeedReliabilityValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 gnssPositionValue;
                    if (!deserializeDBus(&o82, gnssPositionValue)) {
                        return false;
                    }
                    out.setGnssPosition(gnssPositionValue);
                }

                if (dbus_message_iter_has_next(&o82)) {
                    dbus_message_iter_next(&o82);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSElementOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SDSElementOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o84Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o84Struct));
        dbus_bool_t o85 = in.getIsAmbigious() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o84Struct, DBUS_TYPE_BOOLEAN, &o85));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o84Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SDSElementOptions& out) {
    {
        DBusMessageIter o86;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o86);
                {
                    bool isAmbigiousValue;
                    bool &isAmbigiousTmpValue = isAmbigiousValue;
                    {
                        dbus_bool_t o87;
                        dbus_message_iter_get_basic(&o86, &o87);
                        isAmbigiousTmpValue = o87 ? true : false;
                    }
                    out.setIsAmbigious(isAmbigiousValue);
                }

                if (dbus_message_iter_has_next(&o86)) {
                    dbus_message_iter_next(&o86);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o88Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o88Struct));
        dbus_bool_t o89 = in.getNavigable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o89));
        dbus_bool_t o90 = in.getAmbigious() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o90));
        dbus_bool_t o91 = in.getRemovedInvalidEntry() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o91));
        dbus_bool_t o92 = in.getMoreEntriesPossible() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o92));
        dbus_bool_t o93 = in.getHouseNumberAvailable() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o93));
        dbus_bool_t o94 = in.getHouseNumberValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o88Struct, DBUS_TYPE_BOOLEAN, &o94));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o88Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions& out) {
    {
        DBusMessageIter o95;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o95);
                {
                    bool navigableValue;
                    bool &navigableTmpValue = navigableValue;
                    {
                        dbus_bool_t o96;
                        dbus_message_iter_get_basic(&o95, &o96);
                        navigableTmpValue = o96 ? true : false;
                    }
                    out.setNavigable(navigableValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    bool ambigiousValue;
                    bool &ambigiousTmpValue = ambigiousValue;
                    {
                        dbus_bool_t o97;
                        dbus_message_iter_get_basic(&o95, &o97);
                        ambigiousTmpValue = o97 ? true : false;
                    }
                    out.setAmbigious(ambigiousValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    bool removedInvalidEntryValue;
                    bool &removedInvalidEntryTmpValue = removedInvalidEntryValue;
                    {
                        dbus_bool_t o98;
                        dbus_message_iter_get_basic(&o95, &o98);
                        removedInvalidEntryTmpValue = o98 ? true : false;
                    }
                    out.setRemovedInvalidEntry(removedInvalidEntryValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    bool moreEntriesPossibleValue;
                    bool &moreEntriesPossibleTmpValue = moreEntriesPossibleValue;
                    {
                        dbus_bool_t o99;
                        dbus_message_iter_get_basic(&o95, &o99);
                        moreEntriesPossibleTmpValue = o99 ? true : false;
                    }
                    out.setMoreEntriesPossible(moreEntriesPossibleValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    bool houseNumberAvailableValue;
                    bool &houseNumberAvailableTmpValue = houseNumberAvailableValue;
                    {
                        dbus_bool_t o100;
                        dbus_message_iter_get_basic(&o95, &o100);
                        houseNumberAvailableTmpValue = o100 ? true : false;
                    }
                    out.setHouseNumberAvailable(houseNumberAvailableValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

                {
                    bool houseNumberValidValue;
                    bool &houseNumberValidTmpValue = houseNumberValidValue;
                    {
                        dbus_bool_t o101;
                        dbus_message_iter_get_basic(&o95, &o101);
                        houseNumberValidTmpValue = o101 ? true : false;
                    }
                    out.setHouseNumberValid(houseNumberValidValue);
                }

                if (dbus_message_iter_has_next(&o95)) {
                    dbus_message_iter_next(&o95);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SDSAddressElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o102Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o102Struct));
        const ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType  o103 = in.getAddressElementType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o102Struct, DBUS_TYPE_UINT32, &o103));
        const char* o104 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o102Struct, DBUS_TYPE_STRING, &o104));
        serializeDBus(in.getElementOptions(), &o102Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o102Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SDSAddressElement& out) {
    {
        DBusMessageIter o105;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o105);
                {
                    ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType addressElementTypeValue = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
                    dbus_message_iter_get_basic(&o105, &addressElementTypeValue);
                    out.setAddressElementType(addressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o105)) {
                    dbus_message_iter_next(&o105);
                } else {
                    return true;
                }

                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o106 = 0;
                        dbus_message_iter_get_basic(&o105, &o106);
                        dataTmpValue.assign (o106);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o105)) {
                    dbus_message_iter_next(&o105);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::SDSElementOptions elementOptionsValue;
                    if (!deserializeDBus(&o105, elementOptionsValue)) {
                        return false;
                    }
                    out.setElementOptions(elementOptionsValue);
                }

                if (dbus_message_iter_has_next(&o105)) {
                    dbus_message_iter_next(&o105);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSAddressWithOptions

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions& in, DBusMessageIter* out) {
    {
        DBusMessageIter o107Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o107Struct));
        DBusMessageIter o108ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o107Struct, DBUS_TYPE_ARRAY, "(us(b))", &o108ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >* o109 = &in.getAddress();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o110 = o109->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o111 = o109->begin(); o111 != o110; ++o111) {
            serializeDBus((*o111), &o108ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o107Struct, &o108ArrayIter));
        serializeDBus(in.getAddressOptions(), &o107Struct);
        DBusMessageIter o112ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o107Struct, DBUS_TYPE_ARRAY, "u", &o112ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType >* o113 = &in.getAddressElementType();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType >::const_iterator o114 = o113->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType >::const_iterator o115 = o113->begin(); o115 != o114; ++o115) {
            const ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType  o116 = (*o115);
            DBUS_ASSERT(dbus_message_iter_append_basic(&o112ArrayIter, DBUS_TYPE_UINT32, &o116));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o107Struct, &o112ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o107Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions& out) {
    {
        DBusMessageIter o117;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o117);
                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement > addressValue;

                    if (dbus_message_iter_get_arg_type(&o117) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o118ArrayIter;
                        dbus_message_iter_recurse (&o117, &o118ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o118ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::SDSAddressElement o119;
                                if (!deserializeDBus(&o118ArrayIter, o119)) {
                                    return false;
                                }
                                addressValue.push_back(o119);
                            } while (dbus_message_iter_next(&o118ArrayIter));
                        }
                    }
                    out.setAddress(addressValue);
                }

                if (dbus_message_iter_has_next(&o117)) {
                    dbus_message_iter_next(&o117);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::SDSAddressOptions addressOptionsValue;
                    if (!deserializeDBus(&o117, addressOptionsValue)) {
                        return false;
                    }
                    out.setAddressOptions(addressOptionsValue);
                }

                if (dbus_message_iter_has_next(&o117)) {
                    dbus_message_iter_next(&o117);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType > addressElementTypeValue;

                    if (dbus_message_iter_get_arg_type(&o117) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o120ArrayIter;
                        dbus_message_iter_recurse (&o117, &o120ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o120ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType o121 = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
                                dbus_message_iter_get_basic(&o120ArrayIter, &o121);
                                addressElementTypeValue.push_back(o121);
                            } while (dbus_message_iter_next(&o120ArrayIter));
                        }
                    }
                    out.setAddressElementType(addressElementTypeValue);
                }

                if (dbus_message_iter_has_next(&o117)) {
                    dbus_message_iter_next(&o117);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DestinationInfoElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o122Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o122Struct));
        serializeDBus(in.getLocation(), &o122Struct);
        const char* o123 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o122Struct, DBUS_TYPE_STRING, &o123));
        const char* o124 = in.getSubCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o122Struct, DBUS_TYPE_STRING, &o124));
        const char* o125 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o122Struct, DBUS_TYPE_STRING, &o125));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o122Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement& out) {
    {
        DBusMessageIter o126;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o126);
                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 locationValue;
                    if (!deserializeDBus(&o126, locationValue)) {
                        return false;
                    }
                    out.setLocation(locationValue);
                }

                if (dbus_message_iter_has_next(&o126)) {
                    dbus_message_iter_next(&o126);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o127 = 0;
                        dbus_message_iter_get_basic(&o126, &o127);
                        countryCodeTmpValue.assign (o127);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o126)) {
                    dbus_message_iter_next(&o126);
                } else {
                    return true;
                }

                {
                    ::std::string subCountryCodeValue;
                    ::std::string &subCountryCodeTmpValue = subCountryCodeValue;
                    {
                        char* o128 = 0;
                        dbus_message_iter_get_basic(&o126, &o128);
                        subCountryCodeTmpValue.assign (o128);
                    }
                    out.setSubCountryCode(subCountryCodeValue);
                }

                if (dbus_message_iter_has_next(&o126)) {
                    dbus_message_iter_next(&o126);
                } else {
                    return true;
                }

                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o129 = 0;
                        dbus_message_iter_get_basic(&o126, &o129);
                        nameTmpValue.assign (o129);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o126)) {
                    dbus_message_iter_next(&o126);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of RefinementListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RefinementListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o130Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o130Struct));
        const char* o131 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o130Struct, DBUS_TYPE_STRING, &o131));
        uint32 o132 = in.getId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o130Struct, DBUS_TYPE_UINT32, &o132));
        const char* o133 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o130Struct, DBUS_TYPE_STRING, &o133));
        const ::org::bosch::cm::navigation::NavigationService::DirectionDescription  o134 = in.getDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o130Struct, DBUS_TYPE_UINT32, &o134));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o130Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RefinementListElement& out) {
    {
        DBusMessageIter o135;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o135);
                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o136 = 0;
                        dbus_message_iter_get_basic(&o135, &o136);
                        dataTmpValue.assign (o136);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o135)) {
                    dbus_message_iter_next(&o135);
                } else {
                    return true;
                }

                {
                    uint32 idValue;
                    uint32 &idTmpValue = idValue;
                    dbus_message_iter_get_basic(&o135, &idTmpValue);
                    out.setId(idValue);
                }

                if (dbus_message_iter_has_next(&o135)) {
                    dbus_message_iter_next(&o135);
                } else {
                    return true;
                }

                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o137 = 0;
                        dbus_message_iter_get_basic(&o135, &o137);
                        distanceTmpValue.assign (o137);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o135)) {
                    dbus_message_iter_next(&o135);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DirectionDescription directionValue = ::org::bosch::cm::navigation::NavigationService::DirectionDescription__NORTH;
                    dbus_message_iter_get_basic(&o135, &directionValue);
                    out.setDirection(directionValue);
                }

                if (dbus_message_iter_has_next(&o135)) {
                    dbus_message_iter_next(&o135);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of AddressListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::AddressListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o138Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o138Struct));
        const char* o139 = in.getData().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138Struct, DBUS_TYPE_STRING, &o139));
        uint64 o140 = in.getId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138Struct, DBUS_TYPE_UINT64, &o140));
        const char* o141 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138Struct, DBUS_TYPE_STRING, &o141));
        const char* o142 = in.getAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138Struct, DBUS_TYPE_STRING, &o142));
        const ::org::bosch::cm::navigation::NavigationService::DirectionDescription  o143 = in.getDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o138Struct, DBUS_TYPE_UINT32, &o143));
        serializeDBus(in.getCoordinates(), &o138Struct);
        serializeDBus(in.getSdsNameObjectId(), &o138Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o138Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::AddressListElement& out) {
    {
        DBusMessageIter o144;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o144);
                {
                    ::std::string dataValue;
                    ::std::string &dataTmpValue = dataValue;
                    {
                        char* o145 = 0;
                        dbus_message_iter_get_basic(&o144, &o145);
                        dataTmpValue.assign (o145);
                    }
                    out.setData(dataValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    uint64 idValue;
                    uint64 &idTmpValue = idValue;
                    dbus_message_iter_get_basic(&o144, &idTmpValue);
                    out.setId(idValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o146 = 0;
                        dbus_message_iter_get_basic(&o144, &o146);
                        distanceTmpValue.assign (o146);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    ::std::string addressValue;
                    ::std::string &addressTmpValue = addressValue;
                    {
                        char* o147 = 0;
                        dbus_message_iter_get_basic(&o144, &o147);
                        addressTmpValue.assign (o147);
                    }
                    out.setAddress(addressValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DirectionDescription directionValue = ::org::bosch::cm::navigation::NavigationService::DirectionDescription__NORTH;
                    dbus_message_iter_get_basic(&o144, &directionValue);
                    out.setDirection(directionValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 coordinatesValue;
                    if (!deserializeDBus(&o144, coordinatesValue)) {
                        return false;
                    }
                    out.setCoordinates(coordinatesValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId sdsNameObjectIdValue;
                    if (!deserializeDBus(&o144, sdsNameObjectIdValue)) {
                        return false;
                    }
                    out.setSdsNameObjectId(sdsNameObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o144)) {
                    dbus_message_iter_next(&o144);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DeformedImage

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DeformedImage& in, DBusMessageIter* out) {
    {
        DBusMessageIter o148Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o148Struct));
        dbus_bool_t o149 = in.getValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o148Struct, DBUS_TYPE_BOOLEAN, &o149));
        const ::org::bosch::cm::navigation::NavigationService::DeformedImageRoadType  o150 = in.getDeformedImageRoadType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o148Struct, DBUS_TYPE_UINT32, &o150));
        const ::org::bosch::cm::navigation::NavigationService::DeformedImageArrowType  o151 = in.getDeformedImageArrowType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o148Struct, DBUS_TYPE_UINT32, &o151));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o148Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DeformedImage& out) {
    {
        DBusMessageIter o152;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o152);
                {
                    bool validValue;
                    bool &validTmpValue = validValue;
                    {
                        dbus_bool_t o153;
                        dbus_message_iter_get_basic(&o152, &o153);
                        validTmpValue = o153 ? true : false;
                    }
                    out.setValid(validValue);
                }

                if (dbus_message_iter_has_next(&o152)) {
                    dbus_message_iter_next(&o152);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DeformedImageRoadType deformedImageRoadTypeValue = ::org::bosch::cm::navigation::NavigationService::DeformedImageRoadType__NONE;
                    dbus_message_iter_get_basic(&o152, &deformedImageRoadTypeValue);
                    out.setDeformedImageRoadType(deformedImageRoadTypeValue);
                }

                if (dbus_message_iter_has_next(&o152)) {
                    dbus_message_iter_next(&o152);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DeformedImageArrowType deformedImageArrowTypeValue = ::org::bosch::cm::navigation::NavigationService::DeformedImageArrowType__NONE;
                    dbus_message_iter_get_basic(&o152, &deformedImageArrowTypeValue);
                    out.setDeformedImageArrowType(deformedImageArrowTypeValue);
                }

                if (dbus_message_iter_has_next(&o152)) {
                    dbus_message_iter_next(&o152);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of WaypointListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WaypointListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o154Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o154Struct));
        serializeDBus(in.getLocation(), &o154Struct);
        const ::org::bosch::cm::navigation::NavigationService::RouteCriterion  o155 = in.getRouteCriterion();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o154Struct, DBUS_TYPE_UINT32, &o155));
        const char* o156 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o154Struct, DBUS_TYPE_STRING, &o156));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o154Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::WaypointListElement& out) {
    {
        DBusMessageIter o157;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o157);
                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 locationValue;
                    if (!deserializeDBus(&o157, locationValue)) {
                        return false;
                    }
                    out.setLocation(locationValue);
                }

                if (dbus_message_iter_has_next(&o157)) {
                    dbus_message_iter_next(&o157);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::RouteCriterion routeCriterionValue = ::org::bosch::cm::navigation::NavigationService::RouteCriterion__ROUTE_CRITERION_ECONOMIC;
                    dbus_message_iter_get_basic(&o157, &routeCriterionValue);
                    out.setRouteCriterion(routeCriterionValue);
                }

                if (dbus_message_iter_has_next(&o157)) {
                    dbus_message_iter_next(&o157);
                } else {
                    return true;
                }

                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o158 = 0;
                        dbus_message_iter_get_basic(&o157, &o158);
                        nameTmpValue.assign (o158);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o157)) {
                    dbus_message_iter_next(&o157);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ManeuverView

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ManeuverView& in, DBusMessageIter* out) {
    {
        DBusMessageIter o159Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o159Struct));
        uint32 o160 = in.getManeuverId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o159Struct, DBUS_TYPE_UINT32, &o160));
        const ::org::bosch::cm::navigation::NavigationService::ManeuverViewType  o161 = in.getManeuverViewType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o159Struct, DBUS_TYPE_UINT32, &o161));
        serializeDBus(in.getDeformedImage(), &o159Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o159Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ManeuverView& out) {
    {
        DBusMessageIter o162;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o162);
                {
                    uint32 maneuverIdValue;
                    uint32 &maneuverIdTmpValue = maneuverIdValue;
                    dbus_message_iter_get_basic(&o162, &maneuverIdTmpValue);
                    out.setManeuverId(maneuverIdValue);
                }

                if (dbus_message_iter_has_next(&o162)) {
                    dbus_message_iter_next(&o162);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::ManeuverViewType maneuverViewTypeValue = ::org::bosch::cm::navigation::NavigationService::ManeuverViewType__NONE;
                    dbus_message_iter_get_basic(&o162, &maneuverViewTypeValue);
                    out.setManeuverViewType(maneuverViewTypeValue);
                }

                if (dbus_message_iter_has_next(&o162)) {
                    dbus_message_iter_next(&o162);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DeformedImage deformedImageValue;
                    if (!deserializeDBus(&o162, deformedImageValue)) {
                        return false;
                    }
                    out.setDeformedImage(deformedImageValue);
                }

                if (dbus_message_iter_has_next(&o162)) {
                    dbus_message_iter_next(&o162);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ScreenCoordinate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate& in, DBusMessageIter* out) {
    {
        DBusMessageIter o163Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o163Struct));
        uint32 o164 = in.getXPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o163Struct, DBUS_TYPE_UINT32, &o164));
        uint32 o165 = in.getYPos();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o163Struct, DBUS_TYPE_UINT32, &o165));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o163Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate& out) {
    {
        DBusMessageIter o166;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o166);
                {
                    uint32 xPosValue;
                    uint32 &xPosTmpValue = xPosValue;
                    dbus_message_iter_get_basic(&o166, &xPosTmpValue);
                    out.setXPos(xPosValue);
                }

                if (dbus_message_iter_has_next(&o166)) {
                    dbus_message_iter_next(&o166);
                } else {
                    return true;
                }

                {
                    uint32 yPosValue;
                    uint32 &yPosTmpValue = yPosValue;
                    dbus_message_iter_get_basic(&o166, &yPosTmpValue);
                    out.setYPos(yPosValue);
                }

                if (dbus_message_iter_has_next(&o166)) {
                    dbus_message_iter_next(&o166);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapRoadLine

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine& in, DBusMessageIter* out) {
    {
        DBusMessageIter o167Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o167Struct));
        DBusMessageIter o168ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o167Struct, DBUS_TYPE_ARRAY, "(uu)", &o168ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >* o169 = &in.getCoordinates();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o170 = o169->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o171 = o169->begin(); o171 != o170; ++o171) {
            serializeDBus((*o171), &o168ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o167Struct, &o168ArrayIter));
        const ::org::bosch::cm::navigation::NavigationService::AdminRoadClass  o172 = in.getRoadClass();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o167Struct, DBUS_TYPE_UINT32, &o172));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o167Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine& out) {
    {
        DBusMessageIter o173;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o173);
                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate > coordinatesValue;

                    if (dbus_message_iter_get_arg_type(&o173) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o174ArrayIter;
                        dbus_message_iter_recurse (&o173, &o174ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o174ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate o175;
                                if (!deserializeDBus(&o174ArrayIter, o175)) {
                                    return false;
                                }
                                coordinatesValue.push_back(o175);
                            } while (dbus_message_iter_next(&o174ArrayIter));
                        }
                    }
                    out.setCoordinates(coordinatesValue);
                }

                if (dbus_message_iter_has_next(&o173)) {
                    dbus_message_iter_next(&o173);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::AdminRoadClass roadClassValue = ::org::bosch::cm::navigation::NavigationService::AdminRoadClass__UNKNOWN;
                    dbus_message_iter_get_basic(&o173, &roadClassValue);
                    out.setRoadClass(roadClassValue);
                }

                if (dbus_message_iter_has_next(&o173)) {
                    dbus_message_iter_next(&o173);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMap

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMap& in, DBusMessageIter* out) {
    {
        DBusMessageIter o176Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o176Struct));
        uint32 o177 = in.getManeuverId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o176Struct, DBUS_TYPE_UINT32, &o177));
        DBusMessageIter o178ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o176Struct, DBUS_TYPE_ARRAY, "(a(uu)u)", &o178ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >* o179 = &in.getRoad();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o180 = o179->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o181 = o179->begin(); o181 != o180; ++o181) {
            serializeDBus((*o181), &o178ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o176Struct, &o178ArrayIter));
        DBusMessageIter o182ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o176Struct, DBUS_TYPE_ARRAY, "(a(uu)u)", &o182ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >* o183 = &in.getRoute();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o184 = o183->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine >::const_iterator o185 = o183->begin(); o185 != o184; ++o185) {
            serializeDBus((*o185), &o182ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o176Struct, &o182ArrayIter));
        DBusMessageIter o186ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o176Struct, DBUS_TYPE_ARRAY, "(uu)", &o186ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >* o187 = &in.getNoEntryIcons();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o188 = o187->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate >::const_iterator o189 = o187->begin(); o189 != o188; ++o189) {
            serializeDBus((*o189), &o186ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o176Struct, &o186ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o176Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IntersectionMap& out) {
    {
        DBusMessageIter o190;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o190);
                {
                    uint32 maneuverIdValue;
                    uint32 &maneuverIdTmpValue = maneuverIdValue;
                    dbus_message_iter_get_basic(&o190, &maneuverIdTmpValue);
                    out.setManeuverId(maneuverIdValue);
                }

                if (dbus_message_iter_has_next(&o190)) {
                    dbus_message_iter_next(&o190);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine > roadValue;

                    if (dbus_message_iter_get_arg_type(&o190) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o191ArrayIter;
                        dbus_message_iter_recurse (&o190, &o191ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o191ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine o192;
                                if (!deserializeDBus(&o191ArrayIter, o192)) {
                                    return false;
                                }
                                roadValue.push_back(o192);
                            } while (dbus_message_iter_next(&o191ArrayIter));
                        }
                    }
                    out.setRoad(roadValue);
                }

                if (dbus_message_iter_has_next(&o190)) {
                    dbus_message_iter_next(&o190);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine > routeValue;

                    if (dbus_message_iter_get_arg_type(&o190) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o193ArrayIter;
                        dbus_message_iter_recurse (&o190, &o193ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o193ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::IntersectionMapRoadLine o194;
                                if (!deserializeDBus(&o193ArrayIter, o194)) {
                                    return false;
                                }
                                routeValue.push_back(o194);
                            } while (dbus_message_iter_next(&o193ArrayIter));
                        }
                    }
                    out.setRoute(routeValue);
                }

                if (dbus_message_iter_has_next(&o190)) {
                    dbus_message_iter_next(&o190);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate > noEntryIconsValue;

                    if (dbus_message_iter_get_arg_type(&o190) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o195ArrayIter;
                        dbus_message_iter_recurse (&o190, &o195ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o195ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate o196;
                                if (!deserializeDBus(&o195ArrayIter, o196)) {
                                    return false;
                                }
                                noEntryIconsValue.push_back(o196);
                            } while (dbus_message_iter_next(&o195ArrayIter));
                        }
                    }
                    out.setNoEntryIcons(noEntryIconsValue);
                }

                if (dbus_message_iter_has_next(&o190)) {
                    dbus_message_iter_next(&o190);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapCarsorPosition

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition& in, DBusMessageIter* out) {
    {
        DBusMessageIter o197Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o197Struct));
        uint32 o198 = in.getManeuverId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_UINT32, &o198));
        const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorState  o199 = in.getCarsorState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_UINT32, &o199));
        serializeDBus(in.getCarsorPosition(), &o197Struct);
        int32 o200 = in.getCarsorAngle();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o197Struct, DBUS_TYPE_INT32, &o200));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o197Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition& out) {
    {
        DBusMessageIter o201;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o201);
                {
                    uint32 maneuverIdValue;
                    uint32 &maneuverIdTmpValue = maneuverIdValue;
                    dbus_message_iter_get_basic(&o201, &maneuverIdTmpValue);
                    out.setManeuverId(maneuverIdValue);
                }

                if (dbus_message_iter_has_next(&o201)) {
                    dbus_message_iter_next(&o201);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorState carsorStateValue = ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorState__OFF;
                    dbus_message_iter_get_basic(&o201, &carsorStateValue);
                    out.setCarsorState(carsorStateValue);
                }

                if (dbus_message_iter_has_next(&o201)) {
                    dbus_message_iter_next(&o201);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::ScreenCoordinate carsorPositionValue;
                    if (!deserializeDBus(&o201, carsorPositionValue)) {
                        return false;
                    }
                    out.setCarsorPosition(carsorPositionValue);
                }

                if (dbus_message_iter_has_next(&o201)) {
                    dbus_message_iter_next(&o201);
                } else {
                    return true;
                }

                {
                    int32 carsorAngleValue;
                    int32 &carsorAngleTmpValue = carsorAngleValue;
                    dbus_message_iter_get_basic(&o201, &carsorAngleTmpValue);
                    out.setCarsorAngle(carsorAngleValue);
                }

                if (dbus_message_iter_has_next(&o201)) {
                    dbus_message_iter_next(&o201);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SpeedLimit

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SpeedLimit& in, DBusMessageIter* out) {
    {
        DBusMessageIter o202Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o202Struct));
        dbus_bool_t o203 = in.getPresent() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o202Struct, DBUS_TYPE_BOOLEAN, &o203));
        const char* o204 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o202Struct, DBUS_TYPE_STRING, &o204));
        uint16 o205 = in.getValue();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o202Struct, DBUS_TYPE_UINT16, &o205));
        const ::org::bosch::cm::navigation::NavigationService::SpeedUnit  o206 = in.getSpeedUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o202Struct, DBUS_TYPE_UINT32, &o206));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o202Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SpeedLimit& out) {
    {
        DBusMessageIter o207;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o207);
                {
                    bool presentValue;
                    bool &presentTmpValue = presentValue;
                    {
                        dbus_bool_t o208;
                        dbus_message_iter_get_basic(&o207, &o208);
                        presentTmpValue = o208 ? true : false;
                    }
                    out.setPresent(presentValue);
                }

                if (dbus_message_iter_has_next(&o207)) {
                    dbus_message_iter_next(&o207);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o209 = 0;
                        dbus_message_iter_get_basic(&o207, &o209);
                        countryCodeTmpValue.assign (o209);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o207)) {
                    dbus_message_iter_next(&o207);
                } else {
                    return true;
                }

                {
                    uint16 valueValue;
                    uint16 &valueTmpValue = valueValue;
                    dbus_message_iter_get_basic(&o207, &valueTmpValue);
                    out.setValue(valueValue);
                }

                if (dbus_message_iter_has_next(&o207)) {
                    dbus_message_iter_next(&o207);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::SpeedUnit speedUnitValue = ::org::bosch::cm::navigation::NavigationService::SpeedUnit__KM_PER_HOUR;
                    dbus_message_iter_get_basic(&o207, &speedUnitValue);
                    out.setSpeedUnit(speedUnitValue);
                }

                if (dbus_message_iter_has_next(&o207)) {
                    dbus_message_iter_next(&o207);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TrafficEnforcement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o210Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o210Struct));
        const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementAlertState  o211 = in.getTrafficEnforcementAlertState();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_UINT32, &o211));
        const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementCameraType  o212 = in.getTrafficEnforcementCameraType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_UINT32, &o212));
        const char* o213 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_STRING, &o213));
        const ::org::bosch::cm::navigation::NavigationService::DistanceUnit  o214 = in.getDistanceUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_UINT32, &o214));
        const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementDistanceType  o215 = in.getTrafficEnforcementDistanceType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_UINT32, &o215));
        uint32 o216 = in.getSpeedLimit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o210Struct, DBUS_TYPE_UINT32, &o216));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o210Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement& out) {
    {
        DBusMessageIter o217;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o217);
                {
                    ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementAlertState trafficEnforcementAlertStateValue = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementAlertState__NO_ALERT;
                    dbus_message_iter_get_basic(&o217, &trafficEnforcementAlertStateValue);
                    out.setTrafficEnforcementAlertState(trafficEnforcementAlertStateValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementCameraType trafficEnforcementCameraTypeValue = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementCameraType__FIXED_SPEED;
                    dbus_message_iter_get_basic(&o217, &trafficEnforcementCameraTypeValue);
                    out.setTrafficEnforcementCameraType(trafficEnforcementCameraTypeValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o218 = 0;
                        dbus_message_iter_get_basic(&o217, &o218);
                        distanceTmpValue.assign (o218);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceUnit distanceUnitValue = ::org::bosch::cm::navigation::NavigationService::DistanceUnit__METERS;
                    dbus_message_iter_get_basic(&o217, &distanceUnitValue);
                    out.setDistanceUnit(distanceUnitValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementDistanceType trafficEnforcementDistanceTypeValue = ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementDistanceType__TO_ZONE_BEGIN;
                    dbus_message_iter_get_basic(&o217, &trafficEnforcementDistanceTypeValue);
                    out.setTrafficEnforcementDistanceType(trafficEnforcementDistanceTypeValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

                {
                    uint32 speedLimitValue;
                    uint32 &speedLimitTmpValue = speedLimitValue;
                    dbus_message_iter_get_basic(&o217, &speedLimitTmpValue);
                    out.setSpeedLimit(speedLimitValue);
                }

                if (dbus_message_iter_has_next(&o217)) {
                    dbus_message_iter_next(&o217);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of RouteCalculationDuration

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration& in, DBusMessageIter* out) {
    {
        DBusMessageIter o219Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o219Struct));
        uint32 o220 = in.getRouteCalDurationToFinalDest();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o219Struct, DBUS_TYPE_UINT32, &o220));
        uint32 o221 = in.getRouteCalDurationToNextDest();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o219Struct, DBUS_TYPE_UINT32, &o221));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o219Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration& out) {
    {
        DBusMessageIter o222;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o222);
                {
                    uint32 routeCalDurationToFinalDestValue;
                    uint32 &routeCalDurationToFinalDestTmpValue = routeCalDurationToFinalDestValue;
                    dbus_message_iter_get_basic(&o222, &routeCalDurationToFinalDestTmpValue);
                    out.setRouteCalDurationToFinalDest(routeCalDurationToFinalDestValue);
                }

                if (dbus_message_iter_has_next(&o222)) {
                    dbus_message_iter_next(&o222);
                } else {
                    return true;
                }

                {
                    uint32 routeCalDurationToNextDestValue;
                    uint32 &routeCalDurationToNextDestTmpValue = routeCalDurationToNextDestValue;
                    dbus_message_iter_get_basic(&o222, &routeCalDurationToNextDestTmpValue);
                    out.setRouteCalDurationToNextDest(routeCalDurationToNextDestValue);
                }

                if (dbus_message_iter_has_next(&o222)) {
                    dbus_message_iter_next(&o222);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of LaneRecommendation

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendation& in, DBusMessageIter* out) {
    {
        DBusMessageIter o223Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o223Struct));
        const ::org::bosch::cm::navigation::NavigationService::LaneStatus  o224 = in.getLaneStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o223Struct, DBUS_TYPE_UINT32, &o224));
        int32 o225 = in.getCombinedFollowingLaneDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o223Struct, DBUS_TYPE_INT32, &o225));
        int32 o226 = in.getGuidedFollowingLaneDirection();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o223Struct, DBUS_TYPE_INT32, &o226));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o223Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::LaneRecommendation& out) {
    {
        DBusMessageIter o227;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o227);
                {
                    ::org::bosch::cm::navigation::NavigationService::LaneStatus laneStatusValue = ::org::bosch::cm::navigation::NavigationService::LaneStatus__UNKNOWN;
                    dbus_message_iter_get_basic(&o227, &laneStatusValue);
                    out.setLaneStatus(laneStatusValue);
                }

                if (dbus_message_iter_has_next(&o227)) {
                    dbus_message_iter_next(&o227);
                } else {
                    return true;
                }

                {
                    int32 combinedFollowingLaneDirectionValue;
                    int32 &combinedFollowingLaneDirectionTmpValue = combinedFollowingLaneDirectionValue;
                    dbus_message_iter_get_basic(&o227, &combinedFollowingLaneDirectionTmpValue);
                    out.setCombinedFollowingLaneDirection(combinedFollowingLaneDirectionValue);
                }

                if (dbus_message_iter_has_next(&o227)) {
                    dbus_message_iter_next(&o227);
                } else {
                    return true;
                }

                {
                    int32 guidedFollowingLaneDirectionValue;
                    int32 &guidedFollowingLaneDirectionTmpValue = guidedFollowingLaneDirectionValue;
                    dbus_message_iter_get_basic(&o227, &guidedFollowingLaneDirectionTmpValue);
                    out.setGuidedFollowingLaneDirection(guidedFollowingLaneDirectionValue);
                }

                if (dbus_message_iter_has_next(&o227)) {
                    dbus_message_iter_next(&o227);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of ArrivalInformation

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformation& in, DBusMessageIter* out) {
    {
        DBusMessageIter o228Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o228Struct));
        serializeDBus(in.getDistanceToDestination(), &o228Struct);
        const char* o229 = in.getTimeToDestinationAsString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_STRING, &o229));
        int32 o230 = in.getTimeToDestination();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_INT32, &o230));
        const char* o231 = in.getEstimatedTimeOfArrivalAsString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_STRING, &o231));
        int32 o232 = in.getEstimatedTimeOfArrivalHour();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_INT32, &o232));
        int32 o233 = in.getEstimatedTimeOfArrivalMinute();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_INT32, &o233));
        const ::org::bosch::cm::navigation::NavigationService::EstimatedTimeType  o234 = in.getEstimatedTimeType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_UINT32, &o234));
        const ::org::bosch::cm::navigation::NavigationService::TimeType  o235 = in.getDisplayTimeType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_UINT32, &o235));
        const ::org::bosch::cm::navigation::NavigationService::TimeFormat  o236 = in.getDisplayTimeFormat();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_UINT32, &o236));
        int32 o237 = in.getDestinationIndex();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_INT32, &o237));
        const ::org::bosch::cm::navigation::NavigationService::ConsumptionUnit  o238 = in.getConsumptionUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_UINT32, &o238));
        uint32 o239 = in.getConsumptionToDestinationAsInt();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_UINT32, &o239));
        const char* o240 = in.getConsumptionToDestinationAsString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o228Struct, DBUS_TYPE_STRING, &o240));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o228Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ArrivalInformation& out) {
    {
        DBusMessageIter o241;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o241);
                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceToDestination distanceToDestinationValue;
                    if (!deserializeDBus(&o241, distanceToDestinationValue)) {
                        return false;
                    }
                    out.setDistanceToDestination(distanceToDestinationValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::std::string timeToDestinationAsStringValue;
                    ::std::string &timeToDestinationAsStringTmpValue = timeToDestinationAsStringValue;
                    {
                        char* o242 = 0;
                        dbus_message_iter_get_basic(&o241, &o242);
                        timeToDestinationAsStringTmpValue.assign (o242);
                    }
                    out.setTimeToDestinationAsString(timeToDestinationAsStringValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    int32 timeToDestinationValue;
                    int32 &timeToDestinationTmpValue = timeToDestinationValue;
                    dbus_message_iter_get_basic(&o241, &timeToDestinationTmpValue);
                    out.setTimeToDestination(timeToDestinationValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::std::string estimatedTimeOfArrivalAsStringValue;
                    ::std::string &estimatedTimeOfArrivalAsStringTmpValue = estimatedTimeOfArrivalAsStringValue;
                    {
                        char* o243 = 0;
                        dbus_message_iter_get_basic(&o241, &o243);
                        estimatedTimeOfArrivalAsStringTmpValue.assign (o243);
                    }
                    out.setEstimatedTimeOfArrivalAsString(estimatedTimeOfArrivalAsStringValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    int32 estimatedTimeOfArrivalHourValue;
                    int32 &estimatedTimeOfArrivalHourTmpValue = estimatedTimeOfArrivalHourValue;
                    dbus_message_iter_get_basic(&o241, &estimatedTimeOfArrivalHourTmpValue);
                    out.setEstimatedTimeOfArrivalHour(estimatedTimeOfArrivalHourValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    int32 estimatedTimeOfArrivalMinuteValue;
                    int32 &estimatedTimeOfArrivalMinuteTmpValue = estimatedTimeOfArrivalMinuteValue;
                    dbus_message_iter_get_basic(&o241, &estimatedTimeOfArrivalMinuteTmpValue);
                    out.setEstimatedTimeOfArrivalMinute(estimatedTimeOfArrivalMinuteValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::EstimatedTimeType estimatedTimeTypeValue = ::org::bosch::cm::navigation::NavigationService::EstimatedTimeType__DESTINATION;
                    dbus_message_iter_get_basic(&o241, &estimatedTimeTypeValue);
                    out.setEstimatedTimeType(estimatedTimeTypeValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TimeType displayTimeTypeValue = ::org::bosch::cm::navigation::NavigationService::TimeType__REMAININGTIME;
                    dbus_message_iter_get_basic(&o241, &displayTimeTypeValue);
                    out.setDisplayTimeType(displayTimeTypeValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::TimeFormat displayTimeFormatValue = ::org::bosch::cm::navigation::NavigationService::TimeFormat__UNSET;
                    dbus_message_iter_get_basic(&o241, &displayTimeFormatValue);
                    out.setDisplayTimeFormat(displayTimeFormatValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    int32 destinationIndexValue;
                    int32 &destinationIndexTmpValue = destinationIndexValue;
                    dbus_message_iter_get_basic(&o241, &destinationIndexTmpValue);
                    out.setDestinationIndex(destinationIndexValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::ConsumptionUnit consumptionUnitValue = ::org::bosch::cm::navigation::NavigationService::ConsumptionUnit__MICROLITER;
                    dbus_message_iter_get_basic(&o241, &consumptionUnitValue);
                    out.setConsumptionUnit(consumptionUnitValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    uint32 consumptionToDestinationAsIntValue;
                    uint32 &consumptionToDestinationAsIntTmpValue = consumptionToDestinationAsIntValue;
                    dbus_message_iter_get_basic(&o241, &consumptionToDestinationAsIntTmpValue);
                    out.setConsumptionToDestinationAsInt(consumptionToDestinationAsIntValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

                {
                    ::std::string consumptionToDestinationAsStringValue;
                    ::std::string &consumptionToDestinationAsStringTmpValue = consumptionToDestinationAsStringValue;
                    {
                        char* o244 = 0;
                        dbus_message_iter_get_basic(&o241, &o244);
                        consumptionToDestinationAsStringTmpValue.assign (o244);
                    }
                    out.setConsumptionToDestinationAsString(consumptionToDestinationAsStringValue);
                }

                if (dbus_message_iter_has_next(&o241)) {
                    dbus_message_iter_next(&o241);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of NextManeuverDetails

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails& in, DBusMessageIter* out) {
    {
        DBusMessageIter o245Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o245Struct));
        const char* o246 = in.getDistanceToManeuver().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o245Struct, DBUS_TYPE_STRING, &o246));
        const ::org::bosch::cm::navigation::NavigationService::DistanceUnit  o247 = in.getDistanceToManeuverUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o245Struct, DBUS_TYPE_UINT32, &o247));
        const ::org::bosch::cm::navigation::NavigationService::ManeuverRecommendationType  o248 = in.getRecommendationType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o245Struct, DBUS_TYPE_UINT32, &o248));
        dbus_bool_t o249 = in.getIsNewManeuver() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o245Struct, DBUS_TYPE_BOOLEAN, &o249));
        dbus_bool_t o250 = in.getIsReRouted() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o245Struct, DBUS_TYPE_BOOLEAN, &o250));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o245Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails& out) {
    {
        DBusMessageIter o251;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o251);
                {
                    ::std::string distanceToManeuverValue;
                    ::std::string &distanceToManeuverTmpValue = distanceToManeuverValue;
                    {
                        char* o252 = 0;
                        dbus_message_iter_get_basic(&o251, &o252);
                        distanceToManeuverTmpValue.assign (o252);
                    }
                    out.setDistanceToManeuver(distanceToManeuverValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceUnit distanceToManeuverUnitValue = ::org::bosch::cm::navigation::NavigationService::DistanceUnit__METERS;
                    dbus_message_iter_get_basic(&o251, &distanceToManeuverUnitValue);
                    out.setDistanceToManeuverUnit(distanceToManeuverUnitValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::ManeuverRecommendationType recommendationTypeValue = ::org::bosch::cm::navigation::NavigationService::ManeuverRecommendationType__PREVIEW;
                    dbus_message_iter_get_basic(&o251, &recommendationTypeValue);
                    out.setRecommendationType(recommendationTypeValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    bool isNewManeuverValue;
                    bool &isNewManeuverTmpValue = isNewManeuverValue;
                    {
                        dbus_bool_t o253;
                        dbus_message_iter_get_basic(&o251, &o253);
                        isNewManeuverTmpValue = o253 ? true : false;
                    }
                    out.setIsNewManeuver(isNewManeuverValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

                {
                    bool isReRoutedValue;
                    bool &isReRoutedTmpValue = isReRoutedValue;
                    {
                        dbus_bool_t o254;
                        dbus_message_iter_get_basic(&o251, &o254);
                        isReRoutedTmpValue = o254 ? true : false;
                    }
                    out.setIsReRouted(isReRoutedValue);
                }

                if (dbus_message_iter_has_next(&o251)) {
                    dbus_message_iter_next(&o251);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of Image

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::Image& in, DBusMessageIter* out) {
    {
        DBusMessageIter o255Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o255Struct));
        ::asf::core::Blob o256 = in.getImage();
        DBusMessageIter o257ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o255Struct, DBUS_TYPE_ARRAY, "y", &o257ArrayIter));
        for (uint32 i = 0; i < o256.getSize(); i++) {
            DBUS_ASSERT(dbus_message_iter_append_basic(&o257ArrayIter, DBUS_TYPE_BYTE, &o256.getBytes()[i]));
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o255Struct, &o257ArrayIter));
        const ::org::bosch::cm::navigation::NavigationService::ImageType  o258 = in.getImageType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o255Struct, DBUS_TYPE_UINT32, &o258));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o255Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::Image& out) {
    {
        DBusMessageIter o259;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o259);
                {
                    ::asf::core::Blob imageValue;
                    ::asf::core::Blob &imageTmpValue = imageValue;
                    if (dbus_message_iter_get_arg_type(&o259) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o260ArrayIter;
                        dbus_message_iter_recurse (&o259, &o260ArrayIter);

                        if (dbus_message_iter_get_arg_type(&o260ArrayIter) != DBUS_TYPE_INVALID) {
                            uint8 o261;
                            do {
                                dbus_message_iter_get_basic(&o260ArrayIter, &o261);
                                imageTmpValue.push_back(o261);
                            } while (dbus_message_iter_next(&o260ArrayIter));
                        }
                    }
                    out.setImage(imageValue);
                }

                if (dbus_message_iter_has_next(&o259)) {
                    dbus_message_iter_next(&o259);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::ImageType imageTypeValue = ::org::bosch::cm::navigation::NavigationService::ImageType__PNG;
                    dbus_message_iter_get_basic(&o259, &imageTypeValue);
                    out.setImageType(imageTypeValue);
                }

                if (dbus_message_iter_has_next(&o259)) {
                    dbus_message_iter_next(&o259);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of Location

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::Location& in, DBusMessageIter* out) {
    {
        DBusMessageIter o262Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o262Struct));
        const char* o263 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o262Struct, DBUS_TYPE_STRING, &o263));
        serializeDBus(in.getPositionWGS84(), &o262Struct);
        dbus_bool_t o264 = in.getValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o262Struct, DBUS_TYPE_BOOLEAN, &o264));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o262Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::Location& out) {
    {
        DBusMessageIter o265;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o265);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o266 = 0;
                        dbus_message_iter_get_basic(&o265, &o266);
                        nameTmpValue.assign (o266);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o265)) {
                    dbus_message_iter_next(&o265);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 positionWGS84Value;
                    if (!deserializeDBus(&o265, positionWGS84Value)) {
                        return false;
                    }
                    out.setPositionWGS84(positionWGS84Value);
                }

                if (dbus_message_iter_has_next(&o265)) {
                    dbus_message_iter_next(&o265);
                } else {
                    return true;
                }

                {
                    bool validValue;
                    bool &validTmpValue = validValue;
                    {
                        dbus_bool_t o267;
                        dbus_message_iter_get_basic(&o265, &o267);
                        validTmpValue = o267 ? true : false;
                    }
                    out.setValid(validValue);
                }

                if (dbus_message_iter_has_next(&o265)) {
                    dbus_message_iter_next(&o265);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of POILocation

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::POILocation& in, DBusMessageIter* out) {
    {
        DBusMessageIter o268Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o268Struct));
        serializeDBus(in.getLocation(), &o268Struct);
        const char* o269 = in.getPhoneNumber().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o268Struct, DBUS_TYPE_STRING, &o269));
        const char* o270 = in.getAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o268Struct, DBUS_TYPE_STRING, &o270));
        serializeDBus(in.getIcon(), &o268Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o268Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::POILocation& out) {
    {
        DBusMessageIter o271;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o271);
                {
                    ::org::bosch::cm::navigation::NavigationService::Location locationValue;
                    if (!deserializeDBus(&o271, locationValue)) {
                        return false;
                    }
                    out.setLocation(locationValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    ::std::string phoneNumberValue;
                    ::std::string &phoneNumberTmpValue = phoneNumberValue;
                    {
                        char* o272 = 0;
                        dbus_message_iter_get_basic(&o271, &o272);
                        phoneNumberTmpValue.assign (o272);
                    }
                    out.setPhoneNumber(phoneNumberValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    ::std::string addressValue;
                    ::std::string &addressTmpValue = addressValue;
                    {
                        char* o273 = 0;
                        dbus_message_iter_get_basic(&o271, &o273);
                        addressTmpValue.assign (o273);
                    }
                    out.setAddress(addressValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::Image iconValue;
                    if (!deserializeDBus(&o271, iconValue)) {
                        return false;
                    }
                    out.setIcon(iconValue);
                }

                if (dbus_message_iter_has_next(&o271)) {
                    dbus_message_iter_next(&o271);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of PoiCategoryShortcut

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut& in, DBusMessageIter* out) {
    {
        DBusMessageIter o274Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o274Struct));
        const char* o275 = in.getCategoryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o274Struct, DBUS_TYPE_STRING, &o275));
        uint32 o276 = in.getPoiCategoryId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o274Struct, DBUS_TYPE_UINT32, &o276));
        serializeDBus(in.getIcon(), &o274Struct);
        uint8 o277 = in.getShortcutIndex();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o274Struct, DBUS_TYPE_BYTE, &o277));
        serializeDBus(in.getSdsNameObjectId(), &o274Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o274Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut& out) {
    {
        DBusMessageIter o278;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o278);
                {
                    ::std::string categoryNameValue;
                    ::std::string &categoryNameTmpValue = categoryNameValue;
                    {
                        char* o279 = 0;
                        dbus_message_iter_get_basic(&o278, &o279);
                        categoryNameTmpValue.assign (o279);
                    }
                    out.setCategoryName(categoryNameValue);
                }

                if (dbus_message_iter_has_next(&o278)) {
                    dbus_message_iter_next(&o278);
                } else {
                    return true;
                }

                {
                    uint32 poiCategoryIdValue;
                    uint32 &poiCategoryIdTmpValue = poiCategoryIdValue;
                    dbus_message_iter_get_basic(&o278, &poiCategoryIdTmpValue);
                    out.setPoiCategoryId(poiCategoryIdValue);
                }

                if (dbus_message_iter_has_next(&o278)) {
                    dbus_message_iter_next(&o278);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::Image iconValue;
                    if (!deserializeDBus(&o278, iconValue)) {
                        return false;
                    }
                    out.setIcon(iconValue);
                }

                if (dbus_message_iter_has_next(&o278)) {
                    dbus_message_iter_next(&o278);
                } else {
                    return true;
                }

                {
                    uint8 shortcutIndexValue;
                    uint8 &shortcutIndexTmpValue = shortcutIndexValue;
                    dbus_message_iter_get_basic(&o278, &shortcutIndexTmpValue);
                    out.setShortcutIndex(shortcutIndexValue);
                }

                if (dbus_message_iter_has_next(&o278)) {
                    dbus_message_iter_next(&o278);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId sdsNameObjectIdValue;
                    if (!deserializeDBus(&o278, sdsNameObjectIdValue)) {
                        return false;
                    }
                    out.setSdsNameObjectId(sdsNameObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o278)) {
                    dbus_message_iter_next(&o278);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of LocationDetails

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LocationDetails& in, DBusMessageIter* out) {
    {
        DBusMessageIter o280Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o280Struct));
        const char* o281 = in.getCityName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o281));
        const char* o282 = in.getCountryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o282));
        const char* o283 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o283));
        const char* o284 = in.getStateName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o284));
        const char* o285 = in.getStateCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o285));
        const char* o286 = in.getPhoneNumber().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o286));
        const char* o287 = in.getPoiAddress().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o287));
        const char* o288 = in.getStreetName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o288));
        const char* o289 = in.getZipCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o280Struct, DBUS_TYPE_STRING, &o289));
        serializeDBus(in.getCoordinate(), &o280Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o280Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::LocationDetails& out) {
    {
        DBusMessageIter o290;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o290);
                {
                    ::std::string cityNameValue;
                    ::std::string &cityNameTmpValue = cityNameValue;
                    {
                        char* o291 = 0;
                        dbus_message_iter_get_basic(&o290, &o291);
                        cityNameTmpValue.assign (o291);
                    }
                    out.setCityName(cityNameValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string countryNameValue;
                    ::std::string &countryNameTmpValue = countryNameValue;
                    {
                        char* o292 = 0;
                        dbus_message_iter_get_basic(&o290, &o292);
                        countryNameTmpValue.assign (o292);
                    }
                    out.setCountryName(countryNameValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o293 = 0;
                        dbus_message_iter_get_basic(&o290, &o293);
                        countryCodeTmpValue.assign (o293);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string stateNameValue;
                    ::std::string &stateNameTmpValue = stateNameValue;
                    {
                        char* o294 = 0;
                        dbus_message_iter_get_basic(&o290, &o294);
                        stateNameTmpValue.assign (o294);
                    }
                    out.setStateName(stateNameValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string stateCodeValue;
                    ::std::string &stateCodeTmpValue = stateCodeValue;
                    {
                        char* o295 = 0;
                        dbus_message_iter_get_basic(&o290, &o295);
                        stateCodeTmpValue.assign (o295);
                    }
                    out.setStateCode(stateCodeValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string phoneNumberValue;
                    ::std::string &phoneNumberTmpValue = phoneNumberValue;
                    {
                        char* o296 = 0;
                        dbus_message_iter_get_basic(&o290, &o296);
                        phoneNumberTmpValue.assign (o296);
                    }
                    out.setPhoneNumber(phoneNumberValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string poiAddressValue;
                    ::std::string &poiAddressTmpValue = poiAddressValue;
                    {
                        char* o297 = 0;
                        dbus_message_iter_get_basic(&o290, &o297);
                        poiAddressTmpValue.assign (o297);
                    }
                    out.setPoiAddress(poiAddressValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string streetNameValue;
                    ::std::string &streetNameTmpValue = streetNameValue;
                    {
                        char* o298 = 0;
                        dbus_message_iter_get_basic(&o290, &o298);
                        streetNameTmpValue.assign (o298);
                    }
                    out.setStreetName(streetNameValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::std::string zipCodeValue;
                    ::std::string &zipCodeTmpValue = zipCodeValue;
                    {
                        char* o299 = 0;
                        dbus_message_iter_get_basic(&o290, &o299);
                        zipCodeTmpValue.assign (o299);
                    }
                    out.setZipCode(zipCodeValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 coordinateValue;
                    if (!deserializeDBus(&o290, coordinateValue)) {
                        return false;
                    }
                    out.setCoordinate(coordinateValue);
                }

                if (dbus_message_iter_has_next(&o290)) {
                    dbus_message_iter_next(&o290);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DestinationMemoryEntry

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry& in, DBusMessageIter* out) {
    {
        DBusMessageIter o300Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o300Struct));
        const char* o301 = in.getName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o300Struct, DBUS_TYPE_STRING, &o301));
        uint64 o302 = in.getEntryID();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o300Struct, DBUS_TYPE_UINT64, &o302));
        uint32 o303 = in.getVoiceTagId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o300Struct, DBUS_TYPE_UINT32, &o303));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o300Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry& out) {
    {
        DBusMessageIter o304;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o304);
                {
                    ::std::string nameValue;
                    ::std::string &nameTmpValue = nameValue;
                    {
                        char* o305 = 0;
                        dbus_message_iter_get_basic(&o304, &o305);
                        nameTmpValue.assign (o305);
                    }
                    out.setName(nameValue);
                }

                if (dbus_message_iter_has_next(&o304)) {
                    dbus_message_iter_next(&o304);
                } else {
                    return true;
                }

                {
                    uint64 entryIDValue;
                    uint64 &entryIDTmpValue = entryIDValue;
                    dbus_message_iter_get_basic(&o304, &entryIDTmpValue);
                    out.setEntryID(entryIDValue);
                }

                if (dbus_message_iter_has_next(&o304)) {
                    dbus_message_iter_next(&o304);
                } else {
                    return true;
                }

                {
                    uint32 voiceTagIdValue;
                    uint32 &voiceTagIdTmpValue = voiceTagIdValue;
                    dbus_message_iter_get_basic(&o304, &voiceTagIdTmpValue);
                    out.setVoiceTagId(voiceTagIdValue);
                }

                if (dbus_message_iter_has_next(&o304)) {
                    dbus_message_iter_next(&o304);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DestinationMemoryEntryItem

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem& in, DBusMessageIter* out) {
    {
        DBusMessageIter o306Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o306Struct));
        const char* o307 = in.getItemString().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o306Struct, DBUS_TYPE_STRING, &o307));
        const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType  o308 = in.getAddressType();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o306Struct, DBUS_TYPE_UINT32, &o308));
        const char* o309 = in.getItemPhoneme().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o306Struct, DBUS_TYPE_STRING, &o309));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o306Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem& out) {
    {
        DBusMessageIter o310;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o310);
                {
                    ::std::string itemStringValue;
                    ::std::string &itemStringTmpValue = itemStringValue;
                    {
                        char* o311 = 0;
                        dbus_message_iter_get_basic(&o310, &o311);
                        itemStringTmpValue.assign (o311);
                    }
                    out.setItemString(itemStringValue);
                }

                if (dbus_message_iter_has_next(&o310)) {
                    dbus_message_iter_next(&o310);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType addressTypeValue = ::org::bosch::cm::navigation::NavigationService::DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY;
                    dbus_message_iter_get_basic(&o310, &addressTypeValue);
                    out.setAddressType(addressTypeValue);
                }

                if (dbus_message_iter_has_next(&o310)) {
                    dbus_message_iter_next(&o310);
                } else {
                    return true;
                }

                {
                    ::std::string itemPhonemeValue;
                    ::std::string &itemPhonemeTmpValue = itemPhonemeValue;
                    {
                        char* o312 = 0;
                        dbus_message_iter_get_basic(&o310, &o312);
                        itemPhonemeTmpValue.assign (o312);
                    }
                    out.setItemPhoneme(itemPhonemeValue);
                }

                if (dbus_message_iter_has_next(&o310)) {
                    dbus_message_iter_next(&o310);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DestinationMemoryEntryDetails

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails& in, DBusMessageIter* out) {
    {
        DBusMessageIter o313Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o313Struct));
        const char* o314 = in.getCountryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o314));
        const char* o315 = in.getStateName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o315));
        const char* o316 = in.getCityName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o316));
        const char* o317 = in.getStreetName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o317));
        const char* o318 = in.getHouseno().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o318));
        const char* o319 = in.getJunctionName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o319));
        const char* o320 = in.getPoiName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o320));
        const char* o321 = in.getPoiCategoryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o321));
        const char* o322 = in.getPoiBrandName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o322));
        const char* o323 = in.getCountryCode().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o323));
        const char* o324 = in.getAddressDetail().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o313Struct, DBUS_TYPE_STRING, &o324));
        DBusMessageIter o325ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o313Struct, DBUS_TYPE_ARRAY, "(sus)", &o325ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >* o326 = &in.getSdsDestinationMemoryEntries();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >::const_iterator o327 = o326->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >::const_iterator o328 = o326->begin(); o328 != o327; ++o328) {
            serializeDBus((*o328), &o325ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o313Struct, &o325ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o313Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails& out) {
    {
        DBusMessageIter o329;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o329);
                {
                    ::std::string countryNameValue;
                    ::std::string &countryNameTmpValue = countryNameValue;
                    {
                        char* o330 = 0;
                        dbus_message_iter_get_basic(&o329, &o330);
                        countryNameTmpValue.assign (o330);
                    }
                    out.setCountryName(countryNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string stateNameValue;
                    ::std::string &stateNameTmpValue = stateNameValue;
                    {
                        char* o331 = 0;
                        dbus_message_iter_get_basic(&o329, &o331);
                        stateNameTmpValue.assign (o331);
                    }
                    out.setStateName(stateNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string cityNameValue;
                    ::std::string &cityNameTmpValue = cityNameValue;
                    {
                        char* o332 = 0;
                        dbus_message_iter_get_basic(&o329, &o332);
                        cityNameTmpValue.assign (o332);
                    }
                    out.setCityName(cityNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string streetNameValue;
                    ::std::string &streetNameTmpValue = streetNameValue;
                    {
                        char* o333 = 0;
                        dbus_message_iter_get_basic(&o329, &o333);
                        streetNameTmpValue.assign (o333);
                    }
                    out.setStreetName(streetNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string housenoValue;
                    ::std::string &housenoTmpValue = housenoValue;
                    {
                        char* o334 = 0;
                        dbus_message_iter_get_basic(&o329, &o334);
                        housenoTmpValue.assign (o334);
                    }
                    out.setHouseno(housenoValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string junctionNameValue;
                    ::std::string &junctionNameTmpValue = junctionNameValue;
                    {
                        char* o335 = 0;
                        dbus_message_iter_get_basic(&o329, &o335);
                        junctionNameTmpValue.assign (o335);
                    }
                    out.setJunctionName(junctionNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string poiNameValue;
                    ::std::string &poiNameTmpValue = poiNameValue;
                    {
                        char* o336 = 0;
                        dbus_message_iter_get_basic(&o329, &o336);
                        poiNameTmpValue.assign (o336);
                    }
                    out.setPoiName(poiNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string poiCategoryNameValue;
                    ::std::string &poiCategoryNameTmpValue = poiCategoryNameValue;
                    {
                        char* o337 = 0;
                        dbus_message_iter_get_basic(&o329, &o337);
                        poiCategoryNameTmpValue.assign (o337);
                    }
                    out.setPoiCategoryName(poiCategoryNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string poiBrandNameValue;
                    ::std::string &poiBrandNameTmpValue = poiBrandNameValue;
                    {
                        char* o338 = 0;
                        dbus_message_iter_get_basic(&o329, &o338);
                        poiBrandNameTmpValue.assign (o338);
                    }
                    out.setPoiBrandName(poiBrandNameValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string countryCodeValue;
                    ::std::string &countryCodeTmpValue = countryCodeValue;
                    {
                        char* o339 = 0;
                        dbus_message_iter_get_basic(&o329, &o339);
                        countryCodeTmpValue.assign (o339);
                    }
                    out.setCountryCode(countryCodeValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::string addressDetailValue;
                    ::std::string &addressDetailTmpValue = addressDetailValue;
                    {
                        char* o340 = 0;
                        dbus_message_iter_get_basic(&o329, &o340);
                        addressDetailTmpValue.assign (o340);
                    }
                    out.setAddressDetail(addressDetailValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem > sdsDestinationMemoryEntriesValue;

                    if (dbus_message_iter_get_arg_type(&o329) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o341ArrayIter;
                        dbus_message_iter_recurse (&o329, &o341ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o341ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem o342;
                                if (!deserializeDBus(&o341ArrayIter, o342)) {
                                    return false;
                                }
                                sdsDestinationMemoryEntriesValue.push_back(o342);
                            } while (dbus_message_iter_next(&o341ArrayIter));
                        }
                    }
                    out.setSdsDestinationMemoryEntries(sdsDestinationMemoryEntriesValue);
                }

                if (dbus_message_iter_has_next(&o329)) {
                    dbus_message_iter_next(&o329);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of DestinationMemoryDetailListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o343Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o343Struct));
        serializeDBus(in.getEntry(), &o343Struct);
        serializeDBus(in.getDetails(), &o343Struct);
        serializeDBus(in.getCoordinates(), &o343Struct);
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o343Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement& out) {
    {
        DBusMessageIter o344;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o344);
                {
                    ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntry entryValue;
                    if (!deserializeDBus(&o344, entryValue)) {
                        return false;
                    }
                    out.setEntry(entryValue);
                }

                if (dbus_message_iter_has_next(&o344)) {
                    dbus_message_iter_next(&o344);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryDetails detailsValue;
                    if (!deserializeDBus(&o344, detailsValue)) {
                        return false;
                    }
                    out.setDetails(detailsValue);
                }

                if (dbus_message_iter_has_next(&o344)) {
                    dbus_message_iter_next(&o344);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::PositionWGS84 coordinatesValue;
                    if (!deserializeDBus(&o344, coordinatesValue)) {
                        return false;
                    }
                    out.setCoordinates(coordinatesValue);
                }

                if (dbus_message_iter_has_next(&o344)) {
                    dbus_message_iter_next(&o344);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SDSVoiceTagId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o345Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o345Struct));
        uint64 o346 = in.getDestinationMemoryEntryId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o345Struct, DBUS_TYPE_UINT64, &o346));
        const char* o347 = in.getDestinationMemoryEntryName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o345Struct, DBUS_TYPE_STRING, &o347));
        uint32 o348 = in.getSdsVoiceTagId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o345Struct, DBUS_TYPE_UINT32, &o348));
        const ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagOptions  o349 = in.getOptions();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o345Struct, DBUS_TYPE_UINT32, &o349));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o345Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId& out) {
    {
        DBusMessageIter o350;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o350);
                {
                    uint64 destinationMemoryEntryIdValue;
                    uint64 &destinationMemoryEntryIdTmpValue = destinationMemoryEntryIdValue;
                    dbus_message_iter_get_basic(&o350, &destinationMemoryEntryIdTmpValue);
                    out.setDestinationMemoryEntryId(destinationMemoryEntryIdValue);
                }

                if (dbus_message_iter_has_next(&o350)) {
                    dbus_message_iter_next(&o350);
                } else {
                    return true;
                }

                {
                    ::std::string destinationMemoryEntryNameValue;
                    ::std::string &destinationMemoryEntryNameTmpValue = destinationMemoryEntryNameValue;
                    {
                        char* o351 = 0;
                        dbus_message_iter_get_basic(&o350, &o351);
                        destinationMemoryEntryNameTmpValue.assign (o351);
                    }
                    out.setDestinationMemoryEntryName(destinationMemoryEntryNameValue);
                }

                if (dbus_message_iter_has_next(&o350)) {
                    dbus_message_iter_next(&o350);
                } else {
                    return true;
                }

                {
                    uint32 sdsVoiceTagIdValue;
                    uint32 &sdsVoiceTagIdTmpValue = sdsVoiceTagIdValue;
                    dbus_message_iter_get_basic(&o350, &sdsVoiceTagIdTmpValue);
                    out.setSdsVoiceTagId(sdsVoiceTagIdValue);
                }

                if (dbus_message_iter_has_next(&o350)) {
                    dbus_message_iter_next(&o350);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagOptions optionsValue = ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagOptions__NONE;
                    dbus_message_iter_get_basic(&o350, &optionsValue);
                    out.setOptions(optionsValue);
                }

                if (dbus_message_iter_has_next(&o350)) {
                    dbus_message_iter_next(&o350);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of TripReplayStatusInfo

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo& in, DBusMessageIter* out) {
    {
        DBusMessageIter o352Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o352Struct));
        const ::org::bosch::cm::navigation::NavigationService::TripReplayStatus  o353 = in.getStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_UINT32, &o353));
        dbus_bool_t o354 = in.getLoopModeActive() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_BOOLEAN, &o354));
        const char* o355 = in.getTripFileName().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_STRING, &o355));
        uint8 o356 = in.getProgress();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_BYTE, &o356));
        uint8 o357 = in.getSyncSegment();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_BYTE, &o357));
        uint8 o358 = in.getCountSyncSegments();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_BYTE, &o358));
        uint8 o359 = in.getSpeed();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o352Struct, DBUS_TYPE_BYTE, &o359));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o352Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo& out) {
    {
        DBusMessageIter o360;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o360);
                {
                    ::org::bosch::cm::navigation::NavigationService::TripReplayStatus statusValue = ::org::bosch::cm::navigation::NavigationService::TripReplayStatus__UNKNOWN;
                    dbus_message_iter_get_basic(&o360, &statusValue);
                    out.setStatus(statusValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    bool loopModeActiveValue;
                    bool &loopModeActiveTmpValue = loopModeActiveValue;
                    {
                        dbus_bool_t o361;
                        dbus_message_iter_get_basic(&o360, &o361);
                        loopModeActiveTmpValue = o361 ? true : false;
                    }
                    out.setLoopModeActive(loopModeActiveValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    ::std::string tripFileNameValue;
                    ::std::string &tripFileNameTmpValue = tripFileNameValue;
                    {
                        char* o362 = 0;
                        dbus_message_iter_get_basic(&o360, &o362);
                        tripFileNameTmpValue.assign (o362);
                    }
                    out.setTripFileName(tripFileNameValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    uint8 progressValue;
                    uint8 &progressTmpValue = progressValue;
                    dbus_message_iter_get_basic(&o360, &progressTmpValue);
                    out.setProgress(progressValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    uint8 syncSegmentValue;
                    uint8 &syncSegmentTmpValue = syncSegmentValue;
                    dbus_message_iter_get_basic(&o360, &syncSegmentTmpValue);
                    out.setSyncSegment(syncSegmentValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    uint8 countSyncSegmentsValue;
                    uint8 &countSyncSegmentsTmpValue = countSyncSegmentsValue;
                    dbus_message_iter_get_basic(&o360, &countSyncSegmentsTmpValue);
                    out.setCountSyncSegments(countSyncSegmentsValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

                {
                    uint8 speedValue;
                    uint8 &speedTmpValue = speedValue;
                    dbus_message_iter_get_basic(&o360, &speedTmpValue);
                    out.setSpeed(speedValue);
                }

                if (dbus_message_iter_has_next(&o360)) {
                    dbus_message_iter_next(&o360);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of JamAheadListElement

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::JamAheadListElement& in, DBusMessageIter* out) {
    {
        DBusMessageIter o363Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o363Struct));
        const char* o364 = in.getDistance().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o363Struct, DBUS_TYPE_STRING, &o364));
        const char* o365 = in.getDistanceWithoutUnit().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o363Struct, DBUS_TYPE_STRING, &o365));
        const ::org::bosch::cm::navigation::NavigationService::DistanceUnit  o366 = in.getDistanceUnit();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o363Struct, DBUS_TYPE_UINT32, &o366));
        dbus_bool_t o367 = in.getIsEnabled() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o363Struct, DBUS_TYPE_BOOLEAN, &o367));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o363Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::JamAheadListElement& out) {
    {
        DBusMessageIter o368;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o368);
                {
                    ::std::string distanceValue;
                    ::std::string &distanceTmpValue = distanceValue;
                    {
                        char* o369 = 0;
                        dbus_message_iter_get_basic(&o368, &o369);
                        distanceTmpValue.assign (o369);
                    }
                    out.setDistance(distanceValue);
                }

                if (dbus_message_iter_has_next(&o368)) {
                    dbus_message_iter_next(&o368);
                } else {
                    return true;
                }

                {
                    ::std::string distanceWithoutUnitValue;
                    ::std::string &distanceWithoutUnitTmpValue = distanceWithoutUnitValue;
                    {
                        char* o370 = 0;
                        dbus_message_iter_get_basic(&o368, &o370);
                        distanceWithoutUnitTmpValue.assign (o370);
                    }
                    out.setDistanceWithoutUnit(distanceWithoutUnitValue);
                }

                if (dbus_message_iter_has_next(&o368)) {
                    dbus_message_iter_next(&o368);
                } else {
                    return true;
                }

                {
                    ::org::bosch::cm::navigation::NavigationService::DistanceUnit distanceUnitValue = ::org::bosch::cm::navigation::NavigationService::DistanceUnit__METERS;
                    dbus_message_iter_get_basic(&o368, &distanceUnitValue);
                    out.setDistanceUnit(distanceUnitValue);
                }

                if (dbus_message_iter_has_next(&o368)) {
                    dbus_message_iter_next(&o368);
                } else {
                    return true;
                }

                {
                    bool isEnabledValue;
                    bool &isEnabledTmpValue = isEnabledValue;
                    {
                        dbus_bool_t o371;
                        dbus_message_iter_get_basic(&o368, &o371);
                        isEnabledTmpValue = o371 ? true : false;
                    }
                    out.setIsEnabled(isEnabledValue);
                }

                if (dbus_message_iter_has_next(&o368)) {
                    dbus_message_iter_next(&o368);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of JamAheadList

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::JamAheadList& in, DBusMessageIter* out) {
    {
        DBusMessageIter o372Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o372Struct));
        const ::org::bosch::cm::navigation::NavigationService::JamAheadActivityStatus  o373 = in.getJamAheadActivityStatus();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o372Struct, DBUS_TYPE_UINT32, &o373));
        DBusMessageIter o374ArrayIter;
        DBUS_ASSERT(dbus_message_iter_open_container(&o372Struct, DBUS_TYPE_ARRAY, "(ssub)", &o374ArrayIter));
        const ::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement >* o375 = &in.getJamAheadListElements();
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement >::const_iterator o376 = o375->end();
        for (::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement >::const_iterator o377 = o375->begin(); o377 != o376; ++o377) {
            serializeDBus((*o377), &o374ArrayIter);
        }
        DBUS_ASSERT(dbus_message_iter_close_container(&o372Struct, &o374ArrayIter));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o372Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::JamAheadList& out) {
    {
        DBusMessageIter o378;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o378);
                {
                    ::org::bosch::cm::navigation::NavigationService::JamAheadActivityStatus jamAheadActivityStatusValue = ::org::bosch::cm::navigation::NavigationService::JamAheadActivityStatus__INACTIVE;
                    dbus_message_iter_get_basic(&o378, &jamAheadActivityStatusValue);
                    out.setJamAheadActivityStatus(jamAheadActivityStatusValue);
                }

                if (dbus_message_iter_has_next(&o378)) {
                    dbus_message_iter_next(&o378);
                } else {
                    return true;
                }

                {
                    ::std::vector< ::org::bosch::cm::navigation::NavigationService::JamAheadListElement > jamAheadListElementsValue;

                    if (dbus_message_iter_get_arg_type(&o378) != DBUS_TYPE_INVALID) {
                        DBusMessageIter o379ArrayIter;
                        dbus_message_iter_recurse (&o378, &o379ArrayIter);

                        if(dbus_message_iter_get_arg_type(&o379ArrayIter) != DBUS_TYPE_INVALID) {
                            do {
                                ::org::bosch::cm::navigation::NavigationService::JamAheadListElement o380;
                                if (!deserializeDBus(&o379ArrayIter, o380)) {
                                    return false;
                                }
                                jamAheadListElementsValue.push_back(o380);
                            } while (dbus_message_iter_next(&o379ArrayIter));
                        }
                    }
                    out.setJamAheadListElements(jamAheadListElementsValue);
                }

                if (dbus_message_iter_has_next(&o378)) {
                    dbus_message_iter_next(&o378);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of MapCameraData

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MapCameraData& in, DBusMessageIter* out) {
    {
        DBusMessageIter o381Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o381Struct));
        uint16 o382 = in.getScaleBarWidth();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o381Struct, DBUS_TYPE_UINT16, &o382));
        const char* o383 = in.getMapScale().c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o381Struct, DBUS_TYPE_STRING, &o383));
        double o384 = in.getCameraHeading();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o381Struct, DBUS_TYPE_DOUBLE, &o384));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o381Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::MapCameraData& out) {
    {
        DBusMessageIter o385;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o385);
                {
                    uint16 scaleBarWidthValue;
                    uint16 &scaleBarWidthTmpValue = scaleBarWidthValue;
                    dbus_message_iter_get_basic(&o385, &scaleBarWidthTmpValue);
                    out.setScaleBarWidth(scaleBarWidthValue);
                }

                if (dbus_message_iter_has_next(&o385)) {
                    dbus_message_iter_next(&o385);
                } else {
                    return true;
                }

                {
                    ::std::string mapScaleValue;
                    ::std::string &mapScaleTmpValue = mapScaleValue;
                    {
                        char* o386 = 0;
                        dbus_message_iter_get_basic(&o385, &o386);
                        mapScaleTmpValue.assign (o386);
                    }
                    out.setMapScale(mapScaleValue);
                }

                if (dbus_message_iter_has_next(&o385)) {
                    dbus_message_iter_next(&o385);
                } else {
                    return true;
                }

                {
                    float cameraHeadingValue;
                    float &cameraHeadingTmpValue = cameraHeadingValue;
                    {
                        double o387;
                        dbus_message_iter_get_basic(&o385, &o387);
                        cameraHeadingTmpValue = static_cast<float>(o387);
                    }
                    out.setCameraHeading(cameraHeadingValue);
                }

                if (dbus_message_iter_has_next(&o385)) {
                    dbus_message_iter_next(&o385);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GlobalNamedObjectId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o388Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o388Struct));
        serializeDBus(in.getGlobalUpdateRegionId(), &o388Struct);
        uint32 o389 = in.getNamedObjectId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o388Struct, DBUS_TYPE_UINT32, &o389));
        dbus_bool_t o390 = in.getIsValid() ? TRUE : FALSE;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o388Struct, DBUS_TYPE_BOOLEAN, &o390));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o388Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::GlobalNamedObjectId& out) {
    {
        DBusMessageIter o391;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o391);
                {
                    ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId globalUpdateRegionIdValue;
                    if (!deserializeDBus(&o391, globalUpdateRegionIdValue)) {
                        return false;
                    }
                    out.setGlobalUpdateRegionId(globalUpdateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o391)) {
                    dbus_message_iter_next(&o391);
                } else {
                    return true;
                }

                {
                    uint32 namedObjectIdValue;
                    uint32 &namedObjectIdTmpValue = namedObjectIdValue;
                    dbus_message_iter_get_basic(&o391, &namedObjectIdTmpValue);
                    out.setNamedObjectId(namedObjectIdValue);
                }

                if (dbus_message_iter_has_next(&o391)) {
                    dbus_message_iter_next(&o391);
                } else {
                    return true;
                }

                {
                    bool isValidValue;
                    bool &isValidTmpValue = isValidValue;
                    {
                        dbus_bool_t o392;
                        dbus_message_iter_get_basic(&o391, &o392);
                        isValidTmpValue = o392 ? true : false;
                    }
                    out.setIsValid(isValidValue);
                }

                if (dbus_message_iter_has_next(&o391)) {
                    dbus_message_iter_next(&o391);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of GlobalUpdateRegionId

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId& in, DBusMessageIter* out) {
    {
        DBusMessageIter o393Struct;
        DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_STRUCT, 0, &o393Struct));
        int16 o394 = in.getUpdateRegionId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o393Struct, DBUS_TYPE_INT16, &o394));
        int32 o395 = in.getProductId();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o393Struct, DBUS_TYPE_INT32, &o395));
        int16 o396 = in.getSupplierId();
        int16 o397 = o396;
        DBUS_ASSERT(dbus_message_iter_append_basic(&o393Struct, DBUS_TYPE_INT16, &o397));
        DBUS_ASSERT(dbus_message_iter_close_container(out, &o393Struct));
    }
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::GlobalUpdateRegionId& out) {
    {
        DBusMessageIter o398;
        char* signature = dbus_message_iter_get_signature(in);

        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
            dbus_free(signature);

            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                dbus_message_iter_recurse (in, &o398);
                {
                    int16 updateRegionIdValue;
                    int16 &updateRegionIdTmpValue = updateRegionIdValue;
                    dbus_message_iter_get_basic(&o398, &updateRegionIdTmpValue);
                    out.setUpdateRegionId(updateRegionIdValue);
                }

                if (dbus_message_iter_has_next(&o398)) {
                    dbus_message_iter_next(&o398);
                } else {
                    return true;
                }

                {
                    int32 productIdValue;
                    int32 &productIdTmpValue = productIdValue;
                    dbus_message_iter_get_basic(&o398, &productIdTmpValue);
                    out.setProductId(productIdValue);
                }

                if (dbus_message_iter_has_next(&o398)) {
                    dbus_message_iter_next(&o398);
                } else {
                    return true;
                }

                {
                    int16 supplierIdValue;
                    int16 &supplierIdTmpValue = supplierIdValue;
                    dbus_message_iter_get_basic(&o398, &supplierIdTmpValue);
                    out.setSupplierId(static_cast<int8>(supplierIdValue));
                }

                if (dbus_message_iter_has_next(&o398)) {
                    dbus_message_iter_next(&o398);
                } else {
                    return true;
                }

            }
        } else
            dbus_free(signature);
    }
    return true;
}

// D-Bus serialize and deserialize functions of SelectPoiCategoryShortcutRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest& in, DBusMessageIter* out) {
    uint8 o399 = in.getShortcutIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o399));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest& out) {
    {
        uint8 shortcutIndexValue;
        uint8 &shortcutIndexTmpValue = shortcutIndexValue;
        dbus_message_iter_get_basic(in, &shortcutIndexTmpValue);
        out.setShortcutIndex(shortcutIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetPoiCategoryShortcutsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o400ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(su(ayu)y((nin)ub))", &o400ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >* o401 = &in.getPoiCategoryShortcuts();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o402 = o401->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o403 = o401->begin(); o403 != o402; ++o403) {
        serializeDBus((*o403), &o400ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o400ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > poiCategoryShortcutsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o404ArrayIter;
            dbus_message_iter_recurse (in, &o404ArrayIter);

            if(dbus_message_iter_get_arg_type(&o404ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut o405;
                    if (!deserializeDBus(&o404ArrayIter, o405)) {
                        return false;
                    }
                    poiCategoryShortcutsValue.push_back(o405);
                } while (dbus_message_iter_next(&o404ArrayIter));
            }
        }
        out.setPoiCategoryShortcuts(poiCategoryShortcutsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetLocationWithCoordinatesRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetLocationWithDetailsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::POILocation locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowPOILocationFromTCURequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest& in, DBusMessageIter* out) {
    DBusMessageIter o406ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((s(dd)b)ss(ayu))", &o406ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation >* o407 = &in.getPoiLocations();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation >::const_iterator o408 = o407->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation >::const_iterator o409 = o407->begin(); o409 != o408; ++o409) {
        serializeDBus((*o409), &o406ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o406ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::POILocation > poiLocationsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o410ArrayIter;
            dbus_message_iter_recurse (in, &o410ArrayIter);

            if(dbus_message_iter_get_arg_type(&o410ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::POILocation o411;
                    if (!deserializeDBus(&o410ArrayIter, o411)) {
                        return false;
                    }
                    poiLocationsValue.push_back(o411);
                } while (dbus_message_iter_next(&o410ArrayIter));
            }
        }
        out.setPoiLocations(poiLocationsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StorePOILocationToAddressBookRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getPoiLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::POILocation poiLocationValue;
        if (!deserializeDBus(in, poiLocationValue)) {
            return false;
        }
        out.setPoiLocation(poiLocationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StoreLocationToAddressBookRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::Location locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowDestinationOverviewFromTCURequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest& in, DBusMessageIter* out) {
    serializeDBus(in.getCurrentPosition(), out);
    serializeDBus(in.getDestination(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::Location currentPositionValue;
        if (!deserializeDBus(in, currentPositionValue)) {
            return false;
        }
        out.setCurrentPosition(currentPositionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationService::Location destinationValue;
        if (!deserializeDBus(in, destinationValue)) {
            return false;
        }
        out.setDestination(destinationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowCalculateTourRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest& in, DBusMessageIter* out) {
    DBusMessageIter o412ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(((s(dd)b)ss(ayu))bu)", &o412ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement >* o413 = &in.getTour();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement >::const_iterator o414 = o413->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement >::const_iterator o415 = o413->begin(); o415 != o414; ++o415) {
        serializeDBus((*o415), &o412ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o412ArrayIter));
    const ::org::bosch::cm::navigation::NavigationService::ScreenTransition  o416 = in.getScreenTransition();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o416));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::TourElement > tourValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o417ArrayIter;
            dbus_message_iter_recurse (in, &o417ArrayIter);

            if(dbus_message_iter_get_arg_type(&o417ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::TourElement o418;
                    if (!deserializeDBus(&o417ArrayIter, o418)) {
                        return false;
                    }
                    tourValue.push_back(o418);
                } while (dbus_message_iter_next(&o417ArrayIter));
            }
        }
        out.setTour(tourValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationService::ScreenTransition screenTransitionValue = ::org::bosch::cm::navigation::NavigationService::ScreenTransition__ROUTE_INFO_SCREEN;
        dbus_message_iter_get_basic(in, &screenTransitionValue);
        out.setScreenTransition(screenTransitionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowOnMapRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowOnMapRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowOnMapRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowCityInputAndGetCityCoordinatesResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getCityCenterCoordinate(), out);
    dbus_bool_t o419 = in.getIsValidAddress() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o419));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 cityCenterCoordinateValue;
        if (!deserializeDBus(in, cityCenterCoordinateValue)) {
            return false;
        }
        out.setCityCenterCoordinate(cityCenterCoordinateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        bool isValidAddressValue;
        bool &isValidAddressTmpValue = isValidAddressValue;
        {
            dbus_bool_t o420;
            dbus_message_iter_get_basic(in, &o420);
            isValidAddressTmpValue = o420 ? true : false;
        }
        out.setIsValidAddress(isValidAddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestLocationDetailsForCoordinatesRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getCityCoordinate(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 cityCoordinateValue;
        if (!deserializeDBus(in, cityCoordinateValue)) {
            return false;
        }
        out.setCityCoordinate(cityCoordinateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestLocationDetailsForCoordinatesResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getLocationDetails(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::LocationDetails locationDetailsValue;
        if (!deserializeDBus(in, locationDetailsValue)) {
            return false;
        }
        out.setLocationDetails(locationDetailsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowMapScreenWithMapViewModeRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::MapViewMode  o421 = in.getMapViewMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o421));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::MapViewMode MapViewModeValue = ::org::bosch::cm::navigation::NavigationService::MapViewMode__MAP_VIEW_MODE_FULL_MAP;
        dbus_message_iter_get_basic(in, &MapViewModeValue);
        out.setMapViewMode(MapViewModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowMapScreenCarsorLockModeRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::MapCameraMode  o422 = in.getMapCameraMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o422));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::MapCameraMode mapCameraModeValue = ::org::bosch::cm::navigation::NavigationService::MapCameraMode__MAP_MODE_CARSOR;
        dbus_message_iter_get_basic(in, &mapCameraModeValue);
        out.setMapCameraMode(mapCameraModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetZoomInStepRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest& in, DBusMessageIter* out) {
    uint8 o423 = in.getZoomInStep();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o423));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest& out) {
    {
        uint8 zoomInStepValue;
        uint8 &zoomInStepTmpValue = zoomInStepValue;
        dbus_message_iter_get_basic(in, &zoomInStepTmpValue);
        out.setZoomInStep(zoomInStepValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetZoomOutStepRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest& in, DBusMessageIter* out) {
    uint8 o424 = in.getZoomOutStep();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o424));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest& out) {
    {
        uint8 zoomOutStepValue;
        uint8 &zoomOutStepTmpValue = zoomOutStepValue;
        dbus_message_iter_get_basic(in, &zoomOutStepTmpValue);
        out.setZoomOutStep(zoomOutStepValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetZoomLevelRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::ZoomLevel  o425 = in.getZoomLevel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o425));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::ZoomLevel zoomLevelValue = ::org::bosch::cm::navigation::NavigationService::ZoomLevel__ZOOM_50M;
        dbus_message_iter_get_basic(in, &zoomLevelValue);
        out.setZoomLevel(zoomLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetVersionStringResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::GetVersionStringResponse& in, DBusMessageIter* out) {
    const char* o426 = in.getVersionString().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o426));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::GetVersionStringResponse& out) {
    {
        ::std::string versionStringValue;
        ::std::string &versionStringTmpValue = versionStringValue;
        {
            char* o427 = 0;
            dbus_message_iter_get_basic(in, &o427);
            versionStringTmpValue.assign (o427);
        }
        out.setVersionString(versionStringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetSXMTravelLinkSubscriptionStatusRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest& in, DBusMessageIter* out) {
    dbus_bool_t o428 = in.getStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o428));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest& out) {
    {
        bool statusValue;
        bool &statusTmpValue = statusValue;
        {
            dbus_bool_t o429;
            dbus_message_iter_get_basic(in, &o429);
            statusTmpValue = o429 ? true : false;
        }
        out.setStatus(statusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartGuidanceToPosWGS84Request

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request& in, DBusMessageIter* out) {
    serializeDBus(in.getDestination(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 destinationValue;
        if (!deserializeDBus(in, destinationValue)) {
            return false;
        }
        out.setDestination(destinationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetLocationWithDestinationMemoryEntryRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest& in, DBusMessageIter* out) {
    uint32 o430 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o430));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of InsertWaypointRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::InsertWaypointRequest& in, DBusMessageIter* out) {
    uint32 o431 = in.getNewIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o431));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::InsertWaypointRequest& out) {
    {
        uint32 newIndexValue;
        uint32 &newIndexTmpValue = newIndexValue;
        dbus_message_iter_get_basic(in, &newIndexTmpValue);
        out.setNewIndex(newIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReplaceWaypointRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest& in, DBusMessageIter* out) {
    uint32 o432 = in.getIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o432));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest& out) {
    {
        uint32 indexValue;
        uint32 &indexTmpValue = indexValue;
        dbus_message_iter_get_basic(in, &indexTmpValue);
        out.setIndex(indexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DeleteWaypointsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest& in, DBusMessageIter* out) {
    uint32 o433 = in.getFirstIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o433));
    uint32 o434 = in.getLastIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o434));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest& out) {
    {
        uint32 firstIndexValue;
        uint32 &firstIndexTmpValue = firstIndexValue;
        dbus_message_iter_get_basic(in, &firstIndexTmpValue);
        out.setFirstIndex(firstIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 lastIndexValue;
        uint32 &lastIndexTmpValue = lastIndexValue;
        dbus_message_iter_get_basic(in, &lastIndexTmpValue);
        out.setLastIndex(lastIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestSetFreeTextSearchTypeRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::FTSLocationType  o435 = in.getLocationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o435));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::FTSLocationType locationTypeValue = ::org::bosch::cm::navigation::NavigationService::FTSLocationType__FREETEXT_SEARCH_TYPE_COMBINED;
        dbus_message_iter_get_basic(in, &locationTypeValue);
        out.setLocationType(locationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestFreeTextSearchResultsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest& in, DBusMessageIter* out) {
    const char* o436 = in.getSearchString().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o436));
    const ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope  o437 = in.getSearchScope();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o437));
    uint8 o438 = in.getDestinationIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o438));
    uint32 o439 = in.getStartIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o439));
    uint32 o440 = in.getNumElements();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o440));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest& out) {
    {
        ::std::string searchStringValue;
        ::std::string &searchStringTmpValue = searchStringValue;
        {
            char* o441 = 0;
            dbus_message_iter_get_basic(in, &o441);
            searchStringTmpValue.assign (o441);
        }
        out.setSearchString(searchStringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope searchScopeValue = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION;
        dbus_message_iter_get_basic(in, &searchScopeValue);
        out.setSearchScope(searchScopeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 destinationIndexValue;
        uint8 &destinationIndexTmpValue = destinationIndexValue;
        dbus_message_iter_get_basic(in, &destinationIndexTmpValue);
        out.setDestinationIndex(destinationIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 startIndexValue;
        uint32 &startIndexTmpValue = startIndexValue;
        dbus_message_iter_get_basic(in, &startIndexTmpValue);
        out.setStartIndex(startIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 numElementsValue;
        uint32 &numElementsTmpValue = numElementsValue;
        dbus_message_iter_get_basic(in, &numElementsTmpValue);
        out.setNumElements(numElementsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestFreeTextSearchResultsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o442ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(stssu(dd)((nin)ub))", &o442ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >* o443 = &in.getSearchResults();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o444 = o443->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o445 = o443->begin(); o445 != o444; ++o445) {
        serializeDBus((*o445), &o442ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o442ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement > searchResultsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o446ArrayIter;
            dbus_message_iter_recurse (in, &o446ArrayIter);

            if(dbus_message_iter_get_arg_type(&o446ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::AddressListElement o447;
                    if (!deserializeDBus(&o446ArrayIter, o447)) {
                        return false;
                    }
                    searchResultsValue.push_back(o447);
                } while (dbus_message_iter_next(&o446ArrayIter));
            }
        }
        out.setSearchResults(searchResultsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetLocationWithFreeTextSearchInputRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest& in, DBusMessageIter* out) {
    uint32 o448 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o448));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowDestinationFreeTextSearchInputRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::FTSLocationType  o449 = in.getLocationType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o449));
    const ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope  o450 = in.getLocationSearchScope();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o450));
    const char* o451 = in.getSearchString().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o451));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::FTSLocationType locationTypeValue = ::org::bosch::cm::navigation::NavigationService::FTSLocationType__FREETEXT_SEARCH_TYPE_COMBINED;
        dbus_message_iter_get_basic(in, &locationTypeValue);
        out.setLocationType(locationTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope locationSearchScopeValue = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION;
        dbus_message_iter_get_basic(in, &locationSearchScopeValue);
        out.setLocationSearchScope(locationSearchScopeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string searchStringValue;
        ::std::string &searchStringTmpValue = searchStringValue;
        {
            char* o452 = 0;
            dbus_message_iter_get_basic(in, &o452);
            searchStringTmpValue.assign (o452);
        }
        out.setSearchString(searchStringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestFixedPOICategorySearchResultsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::FixedPOICategory  o453 = in.getFixedPOICategory();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o453));
    const ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope  o454 = in.getLocationSearchScope();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o454));
    uint8 o455 = in.getDestinationIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o455));
    uint32 o456 = in.getStartIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o456));
    uint32 o457 = in.getNumElements();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o457));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::FixedPOICategory fixedPOICategoryValue = ::org::bosch::cm::navigation::NavigationService::FixedPOICategory__UNDEFINED;
        dbus_message_iter_get_basic(in, &fixedPOICategoryValue);
        out.setFixedPOICategory(fixedPOICategoryValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope locationSearchScopeValue = ::org::bosch::cm::navigation::NavigationService::FreeTextSearchScope__FREETEXT_SEARCH_SCOPE_POI_AT_CURRENT_POSITION;
        dbus_message_iter_get_basic(in, &locationSearchScopeValue);
        out.setLocationSearchScope(locationSearchScopeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 destinationIndexValue;
        uint8 &destinationIndexTmpValue = destinationIndexValue;
        dbus_message_iter_get_basic(in, &destinationIndexTmpValue);
        out.setDestinationIndex(destinationIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 startIndexValue;
        uint32 &startIndexTmpValue = startIndexValue;
        dbus_message_iter_get_basic(in, &startIndexTmpValue);
        out.setStartIndex(startIndexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 numElementsValue;
        uint32 &numElementsTmpValue = numElementsValue;
        dbus_message_iter_get_basic(in, &numElementsTmpValue);
        out.setNumElements(numElementsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestFixedPOICategorySearchResultsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse& in, DBusMessageIter* out) {
    DBusMessageIter o458ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(stssu(dd)((nin)ub))", &o458ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >* o459 = &in.getSearchResults();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o460 = o459->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement >::const_iterator o461 = o459->begin(); o461 != o460; ++o461) {
        serializeDBus((*o461), &o458ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o458ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::AddressListElement > searchResultsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o462ArrayIter;
            dbus_message_iter_recurse (in, &o462ArrayIter);

            if(dbus_message_iter_get_arg_type(&o462ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::AddressListElement o463;
                    if (!deserializeDBus(&o462ArrayIter, o463)) {
                        return false;
                    }
                    searchResultsValue.push_back(o463);
                } while (dbus_message_iter_next(&o462ArrayIter));
            }
        }
        out.setSearchResults(searchResultsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetLocationWithFixedPOICategoryInputRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest& in, DBusMessageIter* out) {
    uint32 o464 = in.getIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o464));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest& out) {
    {
        uint32 indexValue;
        uint32 &indexTmpValue = indexValue;
        dbus_message_iter_get_basic(in, &indexTmpValue);
        out.setIndex(indexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsCheckAddressRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest& in, DBusMessageIter* out) {
    DBusMessageIter o465ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(us(b))", &o465ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >* o466 = &in.getRequestedAddress();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o467 = o466->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement >::const_iterator o468 = o466->begin(); o468 != o467; ++o468) {
        serializeDBus((*o468), &o465ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o465ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::SDSAddressElement > requestedAddressValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o469ArrayIter;
            dbus_message_iter_recurse (in, &o469ArrayIter);

            if(dbus_message_iter_get_arg_type(&o469ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::SDSAddressElement o470;
                    if (!deserializeDBus(&o469ArrayIter, o470)) {
                        return false;
                    }
                    requestedAddressValue.push_back(o470);
                } while (dbus_message_iter_next(&o469ArrayIter));
            }
        }
        out.setRequestedAddress(requestedAddressValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsGetRefinementListRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType  o471 = in.getSdsAddressElementType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o471));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType sdsAddressElementTypeValue = ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY;
        dbus_message_iter_get_basic(in, &sdsAddressElementTypeValue);
        out.setSdsAddressElementType(sdsAddressElementTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsGetRefinementListResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse& in, DBusMessageIter* out) {
    DBusMessageIter o472ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(susu)", &o472ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement >* o473 = &in.getRefinements();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement >::const_iterator o474 = o473->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement >::const_iterator o475 = o473->begin(); o475 != o474; ++o475) {
        serializeDBus((*o475), &o472ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o472ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::RefinementListElement > refinementsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o476ArrayIter;
            dbus_message_iter_recurse (in, &o476ArrayIter);

            if(dbus_message_iter_get_arg_type(&o476ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::RefinementListElement o477;
                    if (!deserializeDBus(&o476ArrayIter, o477)) {
                        return false;
                    }
                    refinementsValue.push_back(o477);
                } while (dbus_message_iter_next(&o476ArrayIter));
            }
        }
        out.setRefinements(refinementsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SelectSdsRefinementRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest& in, DBusMessageIter* out) {
    uint32 o478 = in.getId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o478));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest& out) {
    {
        uint32 idValue;
        uint32 &idTmpValue = idValue;
        dbus_message_iter_get_basic(in, &idTmpValue);
        out.setId(idValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDestinationMemoryEntriesRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::DestinationMemoryCategoryType  o479 = in.getCategoryType();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o479));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::DestinationMemoryCategoryType categoryTypeValue = ::org::bosch::cm::navigation::NavigationService::DestinationMemoryCategoryType__ADDRESS_BOOK;
        dbus_message_iter_get_basic(in, &categoryTypeValue);
        out.setCategoryType(categoryTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDestinationMemoryEntriesResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o480ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((stu)(sssssssssssa(sus))(dd))", &o480ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement >* o481 = &in.getDestinationMemoryEntries();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement >::const_iterator o482 = o481->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement >::const_iterator o483 = o481->begin(); o483 != o482; ++o483) {
        serializeDBus((*o483), &o480ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o480ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement > destinationMemoryEntriesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o484ArrayIter;
            dbus_message_iter_recurse (in, &o484ArrayIter);

            if(dbus_message_iter_get_arg_type(&o484ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement o485;
                    if (!deserializeDBus(&o484ArrayIter, o485)) {
                        return false;
                    }
                    destinationMemoryEntriesValue.push_back(o485);
                } while (dbus_message_iter_next(&o484ArrayIter));
            }
        }
        out.setDestinationMemoryEntries(destinationMemoryEntriesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMapRepresentationRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::MapRepresentation  o486 = in.getRepresentation();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o486));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::MapRepresentation representationValue = ::org::bosch::cm::navigation::NavigationService::MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
        dbus_message_iter_get_basic(in, &representationValue);
        out.setRepresentation(representationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDetailsForSelectedLocationResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getLocationDetail(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::LocationDetails locationDetailValue;
        if (!deserializeDBus(in, locationDetailValue)) {
            return false;
        }
        out.setLocationDetail(locationDetailValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SpeakSamplePhraseRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::SampleVoicePhrase  o487 = in.getSampleVoicePhrase();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o487));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SampleVoicePhrase sampleVoicePhraseValue = ::org::bosch::cm::navigation::NavigationService::SampleVoicePhrase__SAMPLE_PHRASE__GUIDANCE_WILL_BE_AT_THIS_VOLUME;
        dbus_message_iter_get_basic(in, &sampleVoicePhraseValue);
        out.setSampleVoicePhrase(sampleVoicePhraseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetRouteCriterionRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::RouteCriterion  o488 = in.getRouteCriterion();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o488));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::RouteCriterion routeCriterionValue = ::org::bosch::cm::navigation::NavigationService::RouteCriterion__ROUTE_CRITERION_ECONOMIC;
        dbus_message_iter_get_basic(in, &routeCriterionValue);
        out.setRouteCriterion(routeCriterionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetVoiceGuidanceRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest& in, DBusMessageIter* out) {
    dbus_bool_t o489 = in.getActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o489));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest& out) {
    {
        bool activeValue;
        bool &activeTmpValue = activeValue;
        {
            dbus_bool_t o490;
            dbus_message_iter_get_basic(in, &o490);
            activeTmpValue = o490 ? true : false;
        }
        out.setActive(activeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CheckNavDataCompatibilityRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest& in, DBusMessageIter* out) {
    const char* o491 = in.getNavDataVersion().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o491));
    DBusMessageIter o492ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o492ArrayIter));
    const ::std::vector< uint8 >* o493 = &in.getCompatibilityInfo();
    ::std::vector< uint8 >::const_iterator o494 = o493->end();
    for (::std::vector< uint8 >::const_iterator o495 = o493->begin(); o495 != o494; ++o495) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o492ArrayIter, DBUS_TYPE_BYTE, &(*o495)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o492ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest& out) {
    {
        ::std::string navDataVersionValue;
        ::std::string &navDataVersionTmpValue = navDataVersionValue;
        {
            char* o496 = 0;
            dbus_message_iter_get_basic(in, &o496);
            navDataVersionTmpValue.assign (o496);
        }
        out.setNavDataVersion(navDataVersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint8 > compatibilityInfoValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o497ArrayIter;
            dbus_message_iter_recurse (in, &o497ArrayIter);

            if(dbus_message_iter_get_arg_type(&o497ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o498;
                    dbus_message_iter_get_basic(&o497ArrayIter, &o498);
                    compatibilityInfoValue.push_back(o498);
                } while (dbus_message_iter_next(&o497ArrayIter));
            }
        }
        out.setCompatibilityInfo(compatibilityInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CheckNavDataCompatibilityResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityResponse& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::NavDataCompatibility  o499 = in.getCompatibility();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o499));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::NavDataCompatibility compatibilityValue = ::org::bosch::cm::navigation::NavigationService::NavDataCompatibility__NAVDATA_COMPATIBLE;
        dbus_message_iter_get_basic(in, &compatibilityValue);
        out.setCompatibility(compatibilityValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsUpdateVoiceTagRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getVoiceTagID(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId voiceTagIDValue;
        if (!deserializeDBus(in, voiceTagIDValue)) {
            return false;
        }
        out.setVoiceTagID(voiceTagIDValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsGetHouseNumberPatternResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse& in, DBusMessageIter* out) {
    const char* o500 = in.getMinHouseNumber().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o500));
    const char* o501 = in.getMaxHouseNumber().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o501));
    DBusMessageIter o502ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o502ArrayIter));
    const ::std::vector< ::std::string >* o503 = &in.getPatterns();
    ::std::vector< ::std::string >::const_iterator o504 = o503->end();
    for (::std::vector< ::std::string >::const_iterator o505 = o503->begin(); o505 != o504; ++o505) {
        const char* o506 = (*o505).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o502ArrayIter, DBUS_TYPE_STRING, &o506));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o502ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternResponse& out) {
    {
        ::std::string minHouseNumberValue;
        ::std::string &minHouseNumberTmpValue = minHouseNumberValue;
        {
            char* o507 = 0;
            dbus_message_iter_get_basic(in, &o507);
            minHouseNumberTmpValue.assign (o507);
        }
        out.setMinHouseNumber(minHouseNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string maxHouseNumberValue;
        ::std::string &maxHouseNumberTmpValue = maxHouseNumberValue;
        {
            char* o508 = 0;
            dbus_message_iter_get_basic(in, &o508);
            maxHouseNumberTmpValue.assign (o508);
        }
        out.setMaxHouseNumber(maxHouseNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > patternsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o509ArrayIter;
            dbus_message_iter_recurse (in, &o509ArrayIter);

            if(dbus_message_iter_get_arg_type(&o509ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o510;
                    {
                        char* o511 = 0;
                        dbus_message_iter_get_basic(&o509ArrayIter, &o511);
                        o510.assign (o511);
                    }
                    patternsValue.push_back(o510);
                } while (dbus_message_iter_next(&o509ArrayIter));
            }
        }
        out.setPatterns(patternsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetMapLightModeRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest& in, DBusMessageIter* out) {
    dbus_bool_t o512 = in.getActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o512));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest& out) {
    {
        bool activeValue;
        bool &activeTmpValue = activeValue;
        {
            dbus_bool_t o513;
            dbus_message_iter_get_basic(in, &o513);
            activeTmpValue = o513 ? true : false;
        }
        out.setActive(activeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of StartTripReplayRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::StartTripReplayRequest& in, DBusMessageIter* out) {
    const char* o514 = in.getTripFileName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o514));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::StartTripReplayRequest& out) {
    {
        ::std::string tripFileNameValue;
        ::std::string &tripFileNameTmpValue = tripFileNameValue;
        {
            char* o515 = 0;
            dbus_message_iter_get_basic(in, &o515);
            tripFileNameTmpValue.assign (o515);
        }
        out.setTripFileName(tripFileNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SeekTripReplayRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest& in, DBusMessageIter* out) {
    int16 o516 = in.getSeekValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o516));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest& out) {
    {
        int16 seekValueValue;
        int16 &seekValueTmpValue = seekValueValue;
        dbus_message_iter_get_basic(in, &seekValueTmpValue);
        out.setSeekValue(seekValueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetTripReplayModeRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest& in, DBusMessageIter* out) {
    dbus_bool_t o517 = in.getLoopModeActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o517));
    uint16 o518 = in.getSpeed();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o518));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest& out) {
    {
        bool loopModeActiveValue;
        bool &loopModeActiveTmpValue = loopModeActiveValue;
        {
            dbus_bool_t o519;
            dbus_message_iter_get_basic(in, &o519);
            loopModeActiveTmpValue = o519 ? true : false;
        }
        out.setLoopModeActive(loopModeActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 speedValue;
        uint16 &speedTmpValue = speedValue;
        dbus_message_iter_get_basic(in, &speedTmpValue);
        out.setSpeed(speedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowLocationSelectionAndGetAddressDetailsResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsResponse& in, DBusMessageIter* out) {
    serializeDBus(in.getDestinationMemoryDetailListElement(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsResponse& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement destinationMemoryDetailListElementValue;
        if (!deserializeDBus(in, destinationMemoryDetailListElementValue)) {
            return false;
        }
        out.setDestinationMemoryDetailListElement(destinationMemoryDetailListElementValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SelectJamAheadListEntryRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest& in, DBusMessageIter* out) {
    int32 o520 = in.getIndex();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o520));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest& out) {
    {
        int32 indexValue;
        int32 &indexTmpValue = indexValue;
        dbus_message_iter_get_basic(in, &indexTmpValue);
        out.setIndex(indexValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDetailsForSelectedCoordinateWithRadiusRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
    uint16 o521 = in.getRadius();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o521));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionWGS84 locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint16 radiusValue;
        uint16 &radiusTmpValue = radiusValue;
        dbus_message_iter_get_basic(in, &radiusTmpValue);
        out.setRadius(radiusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestDetailsForSelectedCoordinateWithRadiusResponse

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusResponse& in, DBusMessageIter* out) {
    DBusMessageIter o522ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(sssssssss(dd))", &o522ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails >* o523 = &in.getLocationDetailsList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails >::const_iterator o524 = o523->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails >::const_iterator o525 = o523->begin(); o525 != o524; ++o525) {
        serializeDBus((*o525), &o522ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o522ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusResponse& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::LocationDetails > locationDetailsListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o526ArrayIter;
            dbus_message_iter_recurse (in, &o526ArrayIter);

            if(dbus_message_iter_get_arg_type(&o526ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::LocationDetails o527;
                    if (!deserializeDBus(&o526ArrayIter, o527)) {
                        return false;
                    }
                    locationDetailsListValue.push_back(o527);
                } while (dbus_message_iter_next(&o526ArrayIter));
            }
        }
        out.setLocationDetailsList(locationDetailsListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ShowAndSetLocationWithDetailsRequest

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest& in, DBusMessageIter* out) {
    serializeDBus(in.getLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::POILocation locationValue;
        if (!deserializeDBus(in, locationValue)) {
            return false;
        }
        out.setLocation(locationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NavStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::NavStatus  o528 = in.getNavStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o528));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::NavStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::NavStatus navStatusValue = ::org::bosch::cm::navigation::NavigationService::NavStatus__NAVSTATUS_UNKNOWN;
        dbus_message_iter_get_basic(in, &navStatusValue);
        out.setNavStatus(navStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NavStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NavStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::NavStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DatasetVersionUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionUpdate& in, DBusMessageIter* out) {
    const char* o529 = in.getDatasetVersion().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o529));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DatasetVersionUpdate& out) {
    {
        ::std::string datasetVersionValue;
        ::std::string &datasetVersionTmpValue = datasetVersionValue;
        {
            char* o530 = 0;
            dbus_message_iter_get_basic(in, &o530);
            datasetVersionTmpValue.assign (o530);
        }
        out.setDatasetVersion(datasetVersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DatasetVersionRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DatasetVersionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::DatasetVersionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NonPremiumTMCStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o531 = in.getNonPremiumTMCStatus() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o531));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusUpdate& out) {
    {
        bool nonPremiumTMCStatusValue;
        bool &nonPremiumTMCStatusTmpValue = nonPremiumTMCStatusValue;
        {
            dbus_bool_t o532;
            dbus_message_iter_get_basic(in, &o532);
            nonPremiumTMCStatusTmpValue = o532 ? true : false;
        }
        out.setNonPremiumTMCStatus(nonPremiumTMCStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NonPremiumTMCStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::NonPremiumTMCStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CurrentFreeTextSearchInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getCurrentFreeTextSearchInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfo currentFreeTextSearchInfoValue;
        if (!deserializeDBus(in, currentFreeTextSearchInfoValue)) {
            return false;
        }
        out.setCurrentFreeTextSearchInfo(currentFreeTextSearchInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentFreeTextSearchInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::CurrentFreeTextSearchInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of PositionInformationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::PositionInformationUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getPositionInformation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::PositionInformationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::PositionInformation positionInformationValue;
        if (!deserializeDBus(in, positionInformationValue)) {
            return false;
        }
        out.setPositionInformation(positionInformationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PositionInformationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::PositionInformationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::PositionInformationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DistanceToDestinationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getDistanceToDestination(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::DistanceToDestination distanceToDestinationValue;
        if (!deserializeDBus(in, distanceToDestinationValue)) {
            return false;
        }
        out.setDistanceToDestination(distanceToDestinationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DistanceToDestinationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::DistanceToDestinationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of CurrentStreetUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetUpdate& in, DBusMessageIter* out) {
    const char* o533 = in.getCurrentStreet().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o533));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::CurrentStreetUpdate& out) {
    {
        ::std::string currentStreetValue;
        ::std::string &currentStreetTmpValue = currentStreetValue;
        {
            char* o534 = 0;
            dbus_message_iter_get_basic(in, &o534);
            currentStreetTmpValue.assign (o534);
        }
        out.setCurrentStreet(currentStreetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CurrentStreetRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::CurrentStreetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::CurrentStreetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TurntoStreetUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getTurntoStreet(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TurntoStreetUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::TurnToStreet turntoStreetValue;
        if (!deserializeDBus(in, turntoStreetValue)) {
            return false;
        }
        out.setTurntoStreet(turntoStreetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TurntoStreetRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TurntoStreetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TurntoStreetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RoundaboutExitNumberUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberUpdate& in, DBusMessageIter* out) {
    uint16 o535 = in.getRoundaboutExitNumber();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT16, &o535));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberUpdate& out) {
    {
        uint16 roundaboutExitNumberValue;
        uint16 &roundaboutExitNumberTmpValue = roundaboutExitNumberValue;
        dbus_message_iter_get_basic(in, &roundaboutExitNumberTmpValue);
        out.setRoundaboutExitNumber(roundaboutExitNumberValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RoundaboutExitNumberRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::RoundaboutExitNumberRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NextTurntoStreetUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetUpdate& in, DBusMessageIter* out) {
    const char* o536 = in.getNextTurntoStreet().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o536));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetUpdate& out) {
    {
        ::std::string nextTurntoStreetValue;
        ::std::string &nextTurntoStreetTmpValue = nextTurntoStreetValue;
        {
            char* o537 = 0;
            dbus_message_iter_get_basic(in, &o537);
            nextTurntoStreetTmpValue.assign (o537);
        }
        out.setNextTurntoStreet(nextTurntoStreetValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NextTurntoStreetRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::NextTurntoStreetRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of BarGraphInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getBarGraphInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::BarGraphInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::BarGraphInfo barGraphInfoValue;
        if (!deserializeDBus(in, barGraphInfoValue)) {
            return false;
        }
        out.setBarGraphInfo(barGraphInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of BarGraphInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::BarGraphInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::BarGraphInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ManeuverSymbolUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbol  o538 = in.getManeuverSymbol();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o538));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::ManeuverSymbol maneuverSymbolValue = ::org::bosch::cm::navigation::NavigationService::ManeuverSymbol__MANEUVER_SYMBOL_NO_SYMBOL;
        dbus_message_iter_get_basic(in, &maneuverSymbolValue);
        out.setManeuverSymbol(maneuverSymbolValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ManeuverSymbolRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::ManeuverSymbolRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SatelliteInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSatelliteInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SatelliteInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SatelliteInfo satelliteInfoValue;
        if (!deserializeDBus(in, satelliteInfoValue)) {
            return false;
        }
        out.setSatelliteInfo(satelliteInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SatelliteInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SatelliteInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::SatelliteInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DestinationInformationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o539ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((dd)sss)", &o539ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement >* o540 = &in.getDestinationInformation();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement >::const_iterator o541 = o540->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement >::const_iterator o542 = o540->begin(); o542 != o541; ++o542) {
        serializeDBus((*o542), &o539ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o539ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement > destinationInformationValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o543ArrayIter;
            dbus_message_iter_recurse (in, &o543ArrayIter);

            if(dbus_message_iter_get_arg_type(&o543ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::DestinationInfoElement o544;
                    if (!deserializeDBus(&o543ArrayIter, o544)) {
                        return false;
                    }
                    destinationInformationValue.push_back(o544);
                } while (dbus_message_iter_next(&o543ArrayIter));
            }
        }
        out.setDestinationInformation(destinationInformationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DestinationInformationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationInformationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::DestinationInformationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RouteCalculationDurationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getRouteCalculationDuration(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::RouteCalculationDuration routeCalculationDurationValue;
        if (!deserializeDBus(in, routeCalculationDurationValue)) {
            return false;
        }
        out.setRouteCalculationDuration(routeCalculationDurationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RouteCalculationDurationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::RouteCalculationDurationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of HomeLocationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::HomeLocationUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getHomeLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::HomeLocationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::Location homeLocationValue;
        if (!deserializeDBus(in, homeLocationValue)) {
            return false;
        }
        out.setHomeLocation(homeLocationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of HomeLocationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::HomeLocationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::HomeLocationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WorkLocationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WorkLocationUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getWorkLocation(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::WorkLocationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::Location workLocationValue;
        if (!deserializeDBus(in, workLocationValue)) {
            return false;
        }
        out.setWorkLocation(workLocationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WorkLocationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WorkLocationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::WorkLocationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MapRepresentationUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::MapRepresentation  o545 = in.getMapRepresentation();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o545));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::MapRepresentationUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::MapRepresentation mapRepresentationValue = ::org::bosch::cm::navigation::NavigationService::MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
        dbus_message_iter_get_basic(in, &mapRepresentationValue);
        out.setMapRepresentation(mapRepresentationValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MapRepresentationRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MapRepresentationRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::MapRepresentationRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SdsAddressWithOptionsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSdsAddressWithOptions(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SDSAddressWithOptions sdsAddressWithOptionsValue;
        if (!deserializeDBus(in, sdsAddressWithOptionsValue)) {
            return false;
        }
        out.setSdsAddressWithOptions(sdsAddressWithOptionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsAddressWithOptionsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WaypointListUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WaypointListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o546ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((dd)us)", &o546ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement >* o547 = &in.getWaypointList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement >::const_iterator o548 = o547->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement >::const_iterator o549 = o547->begin(); o549 != o548; ++o549) {
        serializeDBus((*o549), &o546ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o546ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::WaypointListUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointListElement > waypointListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o550ArrayIter;
            dbus_message_iter_recurse (in, &o550ArrayIter);

            if(dbus_message_iter_get_arg_type(&o550ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::WaypointListElement o551;
                    if (!deserializeDBus(&o550ArrayIter, o551)) {
                        return false;
                    }
                    waypointListValue.push_back(o551);
                } while (dbus_message_iter_next(&o550ArrayIter));
            }
        }
        out.setWaypointList(waypointListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WaypointListRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WaypointListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::WaypointListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ManeuverViewUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getManeuverView(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ManeuverViewUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::ManeuverView maneuverViewValue;
        if (!deserializeDBus(in, maneuverViewValue)) {
            return false;
        }
        out.setManeuverView(maneuverViewValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ManeuverViewRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ManeuverViewRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::ManeuverViewRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapCarsorPositionUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getIntersectionMapCarsorPosition(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPosition intersectionMapCarsorPositionValue;
        if (!deserializeDBus(in, intersectionMapCarsorPositionValue)) {
            return false;
        }
        out.setIntersectionMapCarsorPosition(intersectionMapCarsorPositionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapCarsorPositionRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorPositionRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SpeedLimitUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSpeedLimit(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SpeedLimitUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SpeedLimit speedLimitValue;
        if (!deserializeDBus(in, speedLimitValue)) {
            return false;
        }
        out.setSpeedLimit(speedLimitValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SpeedLimitRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SpeedLimitRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::SpeedLimitRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TrafficEnforcementUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getTrafficEnforcement(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::TrafficEnforcement trafficEnforcementValue;
        if (!deserializeDBus(in, trafficEnforcementValue)) {
            return false;
        }
        out.setTrafficEnforcement(trafficEnforcementValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TrafficEnforcementRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TrafficEnforcementRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of NextManeuverDetailsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getNextManeuverDetails(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::NextManeuverDetails nextManeuverDetailsValue;
        if (!deserializeDBus(in, nextManeuverDetailsValue)) {
            return false;
        }
        out.setNextManeuverDetails(nextManeuverDetailsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of NextManeuverDetailsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::NextManeuverDetailsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LaneRecommendationListUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o552ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(uii)", &o552ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation >* o553 = &in.getLaneRecommendationList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation >::const_iterator o554 = o553->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation >::const_iterator o555 = o553->begin(); o555 != o554; ++o555) {
        serializeDBus((*o555), &o552ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o552ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::LaneRecommendation > laneRecommendationListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o556ArrayIter;
            dbus_message_iter_recurse (in, &o556ArrayIter);

            if(dbus_message_iter_get_arg_type(&o556ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::LaneRecommendation o557;
                    if (!deserializeDBus(&o556ArrayIter, o557)) {
                        return false;
                    }
                    laneRecommendationListValue.push_back(o557);
                } while (dbus_message_iter_next(&o556ArrayIter));
            }
        }
        out.setLaneRecommendationList(laneRecommendationListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LaneRecommendationListRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::LaneRecommendationListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of ArrivalInformationListUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o558ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "((suu)sisiiuuuiuus)", &o558ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation >* o559 = &in.getArrivalInformationList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation >::const_iterator o560 = o559->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation >::const_iterator o561 = o559->begin(); o561 != o560; ++o561) {
        serializeDBus((*o561), &o558ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o558ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::ArrivalInformation > arrivalInformationListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o562ArrayIter;
            dbus_message_iter_recurse (in, &o562ArrayIter);

            if(dbus_message_iter_get_arg_type(&o562ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::ArrivalInformation o563;
                    if (!deserializeDBus(&o562ArrayIter, o563)) {
                        return false;
                    }
                    arrivalInformationListValue.push_back(o563);
                } while (dbus_message_iter_next(&o562ArrayIter));
            }
        }
        out.setArrivalInformationList(arrivalInformationListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ArrivalInformationListRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::ArrivalInformationListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getIntersectionMap(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IntersectionMapUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::IntersectionMap intersectionMapValue;
        if (!deserializeDBus(in, intersectionMapValue)) {
            return false;
        }
        out.setIntersectionMap(intersectionMapValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IntersectionMapRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IntersectionMapRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IntersectionMapRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IsAddressBookChangedUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o564 = in.getIsAddressBookChanged() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o564));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedUpdate& out) {
    {
        bool isAddressBookChangedValue;
        bool &isAddressBookChangedTmpValue = isAddressBookChangedValue;
        {
            dbus_bool_t o565;
            dbus_message_iter_get_basic(in, &o565);
            isAddressBookChangedTmpValue = o565 ? true : false;
        }
        out.setIsAddressBookChanged(isAddressBookChangedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IsAddressBookChangedRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IsAddressBookChangedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IsMaxAllowedAddressBookEntriesStoredUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o566 = in.getIsMaxAllowedAddressBookEntriesStored() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o566));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredUpdate& out) {
    {
        bool isMaxAllowedAddressBookEntriesStoredValue;
        bool &isMaxAllowedAddressBookEntriesStoredTmpValue = isMaxAllowedAddressBookEntriesStoredValue;
        {
            dbus_bool_t o567;
            dbus_message_iter_get_basic(in, &o567);
            isMaxAllowedAddressBookEntriesStoredTmpValue = o567 ? true : false;
        }
        out.setIsMaxAllowedAddressBookEntriesStored(isMaxAllowedAddressBookEntriesStoredValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IsMaxAllowedAddressBookEntriesStoredRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IsMaxAllowedAddressBookEntriesStoredRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IsLastDestinationListChangedUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o568 = in.getIsLastDestinationListChanged() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o568));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedUpdate& out) {
    {
        bool isLastDestinationListChangedValue;
        bool &isLastDestinationListChangedTmpValue = isLastDestinationListChangedValue;
        {
            dbus_bool_t o569;
            dbus_message_iter_get_basic(in, &o569);
            isLastDestinationListChangedTmpValue = o569 ? true : false;
        }
        out.setIsLastDestinationListChanged(isLastDestinationListChangedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IsLastDestinationListChangedRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IsLastDestinationListChangedRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of IsVoiceGuidanceActiveUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o570 = in.getIsVoiceGuidanceActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o570));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveUpdate& out) {
    {
        bool isVoiceGuidanceActiveValue;
        bool &isVoiceGuidanceActiveTmpValue = isVoiceGuidanceActiveValue;
        {
            dbus_bool_t o571;
            dbus_message_iter_get_basic(in, &o571);
            isVoiceGuidanceActiveTmpValue = o571 ? true : false;
        }
        out.setIsVoiceGuidanceActive(isVoiceGuidanceActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of IsVoiceGuidanceActiveRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::IsVoiceGuidanceActiveRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SdsVoiceTagWithOptionsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getSdsVoiceTagWithOptions(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::SDSVoiceTagId sdsVoiceTagWithOptionsValue;
        if (!deserializeDBus(in, sdsVoiceTagWithOptionsValue)) {
            return false;
        }
        out.setSdsVoiceTagWithOptions(sdsVoiceTagWithOptionsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsVoiceTagWithOptionsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::SdsVoiceTagWithOptionsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TrafficMessagesCountUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountUpdate& in, DBusMessageIter* out) {
    uint8 o572 = in.getTrafficMessagesCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o572));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountUpdate& out) {
    {
        uint8 trafficMessagesCountValue;
        uint8 &trafficMessagesCountTmpValue = trafficMessagesCountValue;
        dbus_message_iter_get_basic(in, &trafficMessagesCountTmpValue);
        out.setTrafficMessagesCount(trafficMessagesCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TrafficMessagesCountRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TrafficMessagesCountRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TrafficServiceReceptionStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getTrafficServiceReceptionStatus(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatus trafficServiceReceptionStatusValue;
        if (!deserializeDBus(in, trafficServiceReceptionStatusValue)) {
            return false;
        }
        out.setTrafficServiceReceptionStatus(trafficServiceReceptionStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TrafficServiceReceptionStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TrafficServiceReceptionStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of SdsPOICategoryShortcutsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o573ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(su(ayu)y((nin)ub))", &o573ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >* o574 = &in.getSdsPOICategoryShortcuts();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o575 = o574->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o576 = o574->begin(); o576 != o575; ++o576) {
        serializeDBus((*o576), &o573ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o573ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > sdsPOICategoryShortcutsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o577ArrayIter;
            dbus_message_iter_recurse (in, &o577ArrayIter);

            if(dbus_message_iter_get_arg_type(&o577ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut o578;
                    if (!deserializeDBus(&o577ArrayIter, o578)) {
                        return false;
                    }
                    sdsPOICategoryShortcutsValue.push_back(o578);
                } while (dbus_message_iter_next(&o577ArrayIter));
            }
        }
        out.setSdsPOICategoryShortcuts(sdsPOICategoryShortcutsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SdsPOICategoryShortcutsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::SdsPOICategoryShortcutsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MenuPoiCategoryShortcutsUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o579ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(su(ayu)y((nin)ub))", &o579ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >* o580 = &in.getMenuPoiCategoryShortcuts();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o581 = o580->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut >::const_iterator o582 = o580->begin(); o582 != o581; ++o582) {
        serializeDBus((*o582), &o579ArrayIter);
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o579ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > menuPoiCategoryShortcutsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o583ArrayIter;
            dbus_message_iter_recurse (in, &o583ArrayIter);

            if(dbus_message_iter_get_arg_type(&o583ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut o584;
                    if (!deserializeDBus(&o583ArrayIter, o584)) {
                        return false;
                    }
                    menuPoiCategoryShortcutsValue.push_back(o584);
                } while (dbus_message_iter_next(&o583ArrayIter));
            }
        }
        out.setMenuPoiCategoryShortcuts(menuPoiCategoryShortcutsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MenuPoiCategoryShortcutsRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TripReplayStatusInfoUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getTripReplayStatusInfo(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfo tripReplayStatusInfoValue;
        if (!deserializeDBus(in, tripReplayStatusInfoValue)) {
            return false;
        }
        out.setTripReplayStatusInfo(tripReplayStatusInfoValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TripReplayStatusInfoRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TripReplayStatusInfoRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EtcStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::EtcStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::ETCStatus  o585 = in.getEtcStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o585));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::EtcStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::ETCStatus etcStatusValue = ::org::bosch::cm::navigation::NavigationService::ETCStatus__INACTIVE;
        dbus_message_iter_get_basic(in, &etcStatusValue);
        out.setEtcStatus(etcStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EtcStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::EtcStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::EtcStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of TrafficSignInfoActiveUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o586 = in.getTrafficSignInfoActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o586));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveUpdate& out) {
    {
        bool TrafficSignInfoActiveValue;
        bool &TrafficSignInfoActiveTmpValue = TrafficSignInfoActiveValue;
        {
            dbus_bool_t o587;
            dbus_message_iter_get_basic(in, &o587);
            TrafficSignInfoActiveTmpValue = o587 ? true : false;
        }
        out.setTrafficSignInfoActive(TrafficSignInfoActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TrafficSignInfoActiveRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::TrafficSignInfoActiveRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of OverSpeedSoundAlertInfoActiveUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o588 = in.getOverSpeedSoundAlertInfoActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o588));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveUpdate& out) {
    {
        bool OverSpeedSoundAlertInfoActiveValue;
        bool &OverSpeedSoundAlertInfoActiveTmpValue = OverSpeedSoundAlertInfoActiveValue;
        {
            dbus_bool_t o589;
            dbus_message_iter_get_basic(in, &o589);
            OverSpeedSoundAlertInfoActiveTmpValue = o589 ? true : false;
        }
        out.setOverSpeedSoundAlertInfoActive(OverSpeedSoundAlertInfoActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of OverSpeedSoundAlertInfoActiveRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::OverSpeedSoundAlertInfoActiveRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RouteRecalculationReasonUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReason  o590 = in.getRouteRecalculationReason();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o590));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReason routeRecalculationReasonValue = ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReason__UNKNOWN;
        dbus_message_iter_get_basic(in, &routeRecalculationReasonValue);
        out.setRouteRecalculationReason(routeRecalculationReasonValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RouteRecalculationReasonRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::RouteRecalculationReasonRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RiskAreaDisplayInfoActiveUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o591 = in.getRiskAreaDisplayInfoActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o591));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveUpdate& out) {
    {
        bool RiskAreaDisplayInfoActiveValue;
        bool &RiskAreaDisplayInfoActiveTmpValue = RiskAreaDisplayInfoActiveValue;
        {
            dbus_bool_t o592;
            dbus_message_iter_get_basic(in, &o592);
            RiskAreaDisplayInfoActiveTmpValue = o592 ? true : false;
        }
        out.setRiskAreaDisplayInfoActive(RiskAreaDisplayInfoActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RiskAreaDisplayInfoActiveRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::RiskAreaDisplayInfoActiveRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of RiskAreaSoundAlertInfoActiveUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveUpdate& in, DBusMessageIter* out) {
    dbus_bool_t o593 = in.getRiskAreaSoundAlertInfoActive() ? TRUE : FALSE;
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BOOLEAN, &o593));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveUpdate& out) {
    {
        bool RiskAreaSoundAlertInfoActiveValue;
        bool &RiskAreaSoundAlertInfoActiveTmpValue = RiskAreaSoundAlertInfoActiveValue;
        {
            dbus_bool_t o594;
            dbus_message_iter_get_basic(in, &o594);
            RiskAreaSoundAlertInfoActiveTmpValue = o594 ? true : false;
        }
        out.setRiskAreaSoundAlertInfoActive(RiskAreaSoundAlertInfoActiveValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RiskAreaSoundAlertInfoActiveRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::RiskAreaSoundAlertInfoActiveRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of JamAheadListUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::JamAheadListUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getJamAheadList(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::JamAheadListUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::JamAheadList jamAheadListValue;
        if (!deserializeDBus(in, jamAheadListValue)) {
            return false;
        }
        out.setJamAheadList(jamAheadListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of JamAheadListRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::JamAheadListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::JamAheadListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of WaypointOperationStatusListUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o595ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o595ArrayIter));
    const ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus >* o596 = &in.getWaypointOperationStatusList();
    ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus >::const_iterator o597 = o596->end();
    for (::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus >::const_iterator o598 = o596->begin(); o598 != o597; ++o598) {
        const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus  o599 = (*o598);
        DBUS_ASSERT(dbus_message_iter_append_basic(&o595ArrayIter, DBUS_TYPE_UINT32, &o599));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o595ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListUpdate& out) {
    {
        ::std::vector< ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus > waypointOperationStatusListValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o600ArrayIter;
            dbus_message_iter_recurse (in, &o600ArrayIter);

            if(dbus_message_iter_get_arg_type(&o600ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus o601 = ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatus__INSERTED;
                    dbus_message_iter_get_basic(&o600ArrayIter, &o601);
                    waypointOperationStatusListValue.push_back(o601);
                } while (dbus_message_iter_next(&o600ArrayIter));
            }
        }
        out.setWaypointOperationStatusList(waypointOperationStatusListValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of WaypointOperationStatusListRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::WaypointOperationStatusListRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of DestinationReachedStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatus  o602 = in.getDestinationReachedStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o602));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatus destinationReachedStatusValue = ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatus__UNKNOWN;
        dbus_message_iter_get_basic(in, &destinationReachedStatusValue);
        out.setDestinationReachedStatus(destinationReachedStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DestinationReachedStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::DestinationReachedStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of LightModeStatusUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusUpdate& in, DBusMessageIter* out) {
    const ::org::bosch::cm::navigation::NavigationService::LightModeStatus  o603 = in.getLightModeStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o603));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::LightModeStatusUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::LightModeStatus lightModeStatusValue = ::org::bosch::cm::navigation::NavigationService::LightModeStatus__DAY;
        dbus_message_iter_get_basic(in, &lightModeStatusValue);
        out.setLightModeStatus(lightModeStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of LightModeStatusRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::LightModeStatusRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::LightModeStatusRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of MapCameraDataUpdate

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataUpdate& in, DBusMessageIter* out) {
    serializeDBus(in.getMapCameraData(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::cm::navigation::NavigationService::MapCameraDataUpdate& out) {
    {
        ::org::bosch::cm::navigation::NavigationService::MapCameraData mapCameraDataValue;
        if (!deserializeDBus(in, mapCameraDataValue)) {
            return false;
        }
        out.setMapCameraData(mapCameraDataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of MapCameraDataRegister

void serializeDBus (const ::org::bosch::cm::navigation::NavigationService::MapCameraDataRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::cm::navigation::NavigationService::MapCameraDataRegister& /*out*/) {
    return true;
}

